<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
<xsl:variable name="DEFAULTCOL">
	<xsl:value-of select="/DOCUMENTROOT/METADATA/DEFAULT_COL" />
</xsl:variable>
<xsl:variable name="TITLE">
	<xsl:value-of select="/DOCUMENTROOT/METADATA/MSG_TITLE" />
</xsl:variable>
<xsl:variable name="COLDATATYPE">
	<xsl:value-of select="/DOCUMENTROOT/METADATA/FIELD_TYPE" />
</xsl:variable>
<xsl:variable name="MULTIPLE_OPT">
	<xsl:value-of select="/DOCUMENTROOT/METADATA/MULTIPLE_OPT" />
</xsl:variable>
<HTML>
<HEAD>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/default.css"/>
<link id="userThemeLink" type="text/css" rel="stylesheet" href=""/>
<TITLE>
<xsl:value-of select="$TITLE"/>
</TITLE>
<SCRIPT>
	<![CDATA[ 
	 var multipleOpt;
	 multipleOpt="]]><xsl:value-of select="$MULTIPLE_OPT"/><![CDATA[";
	]]>
</SCRIPT>
</HEAD>
<SCRIPT>
<![CDATA[
 var checkedItem;
 function isMultipleValue()
 {
	if( multipleOpt == "1" )
	{
		return true;
	}
	else if( multipleOpt == "2" )
	{
		return true;
	}
	else if(multipleOpt == "0")
	{
		return false;
	}
 }

 function updateCheckStatus(obj)
 {
	if(!isMultipleValue())
	{
		if(checkedItem != undefined && checkedItem.value.trim() != obj.value.trim())
		{
			checkedItem.checked = false;
		}
		checkedItem = obj;
	}
	else
	{
		checkedItem = obj;
	}
 }
 function submitValue(obj)
 {
	valueToSubmit = "";
	var isMultipleValSel = isMultipleValue();
	var colDataType="]]><xsl:value-of select="$COLDATATYPE"/><![CDATA[";
	if(document.all['CHECKBOX_ID'].length!=undefined)
	{
		if(isMultipleValSel) 
		{
	    	 for(ctr = 0; ctr < document.all['CHECKBOX_ID'].length; ctr++)
			 {
				if(document.all['CHECKBOX_ID'][ctr].checked )
				{				
					valueToSubmit += document.all['CHECKBOX_ID'][ctr].value + ",";
				}
			 }
			valueToSubmit =valueToSubmit.substring(0,(valueToSubmit.length-1));
		}
		else
		{
			if(checkedItem != undefined)
			{
				valueToSubmit = checkedItem.value;
			}
		}
	}
	else{
		if(checkedItem != undefined)
		{
			valueToSubmit = checkedItem.value;
		}
	}
	if(valueToSubmit==''){
	
		 //Chnaged by Nilesh Soor on 08/10/2014 Start
		  //valueToSubmit += obj.value;
		  if( obj != null && obj != undefined)
		  {
			 valueToSubmit += obj.getAttribute("value");
		  }
		//Chnaged by Nilesh Soor on 08/10/2014 End
			      	
	} 	
	//  Added by Nilesh Soor on 17/09/2014 [ PopHelp values not setting in respective field ] START
	//window.opener.assignValue(valueToSubmit);
	//self.close();
	//this.parent.assignValue(valueToSubmit);
	//closeMe();
	
	//Added by Nilesh Soor on 08/10/2014 [ Pophelp not working in other Transaction page and on homepage. ] Start
	//alert("valueToSubmit..["+valueToSubmit+"]");
	if( window.opener != null && window.opener !== undefined)
	{
		window.opener.assignValueClaimProcess(valueToSubmit);
		self.close();
	}
	else
	{
		this.parent.assignValueClaimProcess(valueToSubmit);
		closeMe();
	}
	//Added by Nilesh Soor on 08/10/2014 [ Pophelp not working in other Transaction page and on homepage. ] End
	
	//  Added by Nilesh Soor on 17/09/2014 [ PopHelp values not setting in respective field ] END
 }
 
 //  Added by Nilesh Soor on 17/09/2014 [ PopHelp values not setting in respective field ] START
  function closeMe()
{
	//this.parent.closeMe();
	//Added by Nilesh Soor on 08/10/2014 [ Pophelp not working in other Transaction page and on homepage. ] Start
	if(  window.opener != null && window.opener !== undefined )
	{
		self.close();
	}
	else
	{
		this.parent.closeMe();
	}
	//Added by Nilesh Soor on 08/10/2014 [ Pophelp not working in other Transaction page and on homepage. ] End
}
 //  Added by Nilesh Soor on 17/09/2014 [ PopHelp values not setting in respective field ] END
 
 function setSelect()
 {
   if(document.all['VALUE_MODE'].selectedIndex == "0" || document.all['VALUE_MODE'].selectedIndex == "1"  )
   {
     document.all['CHECKBOX_TABLE'].disabled = false;
   }
   if(document.all['VALUE_MODE'].selectedIndex == "2")
	{
	 document.all['CHECKBOX_TABLE'].disabled = true;
	}
  }
function raiseButton(el) 
{ 
  with (el.style) {borderTop ="1 solid buttonhighlight";borderLeft ="1 solid buttonhighlight";
  borderBottom ="1 solid buttonshadow";borderRight="1 solid buttonshadow";padding ="1";}
}
function normalButton(el)
{
  with (el.style) {border="0";padding = "1";}
}
function selectAll( isChecked )
{	
	var tableObj = document.getElementById("CHECKBOX_TABLE");
	var norow= tableObj.rows.length;
	var val='';
	if ( isChecked == true )
	{
		for(var i=1;i<norow;i++)
		{	
			if(tableObj.rows[i].cells[0].childNodes != undefined)
			{
				tableObj.rows[i].cells[0].childNodes.item(0).checked= true;
			}
		}
	}
	else if ( isChecked == false )	
	{
		for(var i=1;i<norow;i++)
		{	
			if(tableObj.rows[i].cells[0].childNodes != undefined)
			{
				tableObj.rows[i].cells[0].childNodes.item(0).checked= false;
			}
		}
	}
}
function isChecked()
{
	if(document.getElementById("selectAll").checked)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function selectCheckbox()
{
	var checkboxArr = document.getElementsByName('CONST');
	var selectedVal = '';
	if(  window.opener != null && window.opener != undefined )
	{
		selectedVal= window.curFieldVal;
	}
	else
	{
		selectedVal= parent.curFieldVal;
	}
	var count = 0;
	if( checkboxArr != null && checkboxArr != undefined && checkboxArr.length > 0 && selectedVal != null && selectedVal != undefined )
	{
		var valArr = selectedVal.split(',');
		if( valArr != null && valArr != undefined && valArr.length > 0)
		{
			if( valArr.length != checkboxArr.length )
			{
				for(var j = 0; j< valArr.length; j++ )
				{
					for(var i = 0; i < checkboxArr.length; i++ )
					{
						var value = checkboxArr[i].value;
						if( value != null && value != undefined  )
						{
							if( valArr[j].trim() == value.trim() )
							{
								count++;
								checkboxArr[i].click();
								if( count == valArr.length )
								{
									break;
								}
							}
						}
					}
				}
			}
			else
			{
				document.getElementById('selectAll').click();
			}
		}
	}
}
]]>
</SCRIPT>
<!--Commented by Nilesh Soor on 17/09/2014 [ bicommon.js not found as per Danish Sir ]-->
<!-- <SCRIPT src="../js/bicommon.js"></SCRIPT> -->
<BODY style="margin: 0;" onLoad="selectCheckbox();">
	<div class = "mainPage-Container"> 
		<div class="headerPage-Container pophelp-Header" >
			<!--style="HEIGHT :3%; WIDTH  :100%; TOP:1%; position:absolute; FONT-FAMILY:Verdana; FONT-SIZE: 8pt; Background: #3BB3C3;" -->
			<span class="pophelp-headerTitle">
			Select <xsl:value-of select="$TITLE"/>
			</span>
		</div>
		<div class="detailPage-Container pophelp-Container">
			<div id="dataDivID" class="pophelp-Contents" >
			<table id= "CHECKBOX_TABLE" class = "tableClass">
			<thead class="table-head">
			<tr class = "trClass">
				<xsl:for-each select="DOCUMENTROOT/GROUP0/HEADER0/DETAIL[1]/*">
				<xsl:if  test="position() = 1">	
				<TH class = "thClass">	
					<xsl:if test="$MULTIPLE_OPT='1'">
					<Input type="checkbox" id="selectAll" name="selectAll" onClick="normalButton(this),selectAll( isChecked() )"/>
					</xsl:if>
			
					<xsl:if test="$MULTIPLE_OPT='2'">
					<Input disabled='true' type="checkbox" id="selectAll" onClick="normalButton(this),selectAll( isChecked() )"/>	
					</xsl:if>
				</TH>
				</xsl:if>
				<TH class = "thClass" NOWRAP="TRUE">
					<b><xsl:value-of select="translate(local-name(),'_',' ')"/></b>
				</TH>
			</xsl:for-each>
			</tr>
			</thead>
			<tbody class="table-body">
			<xsl:for-each select="DOCUMENTROOT/GROUP0/HEADER0/DETAIL">
				<xsl:variable name="CURVALUE">
					<xsl:value-of select="child::node()[position() = $DEFAULTCOL]"/>
				</xsl:variable>
			  <TR>
				<TD class = "trClass" NOWRAP="TRUE">
					<xsl:if test="$MULTIPLE_OPT='0'">
						<Input type="radio" id="CHECKBOX_ID" name="CONST" value="{$CURVALUE}" onClick="updateCheckStatus(this)"/>
					</xsl:if>
					<xsl:if test="$MULTIPLE_OPT='1'">
						<Input type="checkbox" id="CHECKBOX_ID" name="CONST" value="{$CURVALUE}" onClick="updateCheckStatus(this)"/>
					</xsl:if>
					<xsl:if test="$MULTIPLE_OPT='2'">
						<Input type="checkbox" id="CHECKBOX_ID" name="CONST" value="{$CURVALUE}" onClick="updateCheckStatus(this)"/>
					</xsl:if>
				</TD>
				<xsl:for-each select="*">
					<TD  class = "trClass" value="{$CURVALUE}" ondblclick="submitValue(this)" NOWRAP="TRUE">
						<xsl:value-of select="."/>
					</TD>
				</xsl:for-each>
			  </TR>
			</xsl:for-each>
			</tbody>
			</table>
			</div>
		</div>
		<div class="footerPage-Container pophelp-Footer">
			<div id="refresh" class="button green-Btn pophelp-refresh" onClick='window.location.reload();'>
				<span>Refresh</span>
			</div>
<!-- 			<span id="refresh" onclick="normalButton(this),window.location.reload()"  -->
<!-- 			style="position:absolute;top:1.5%;left:88%;width:10%;cursor:hand;"> -->
<!-- 			</span> -->
			<div id="ok" class="button green-Btn pophelp-okcancel" onClick='submitValue();'>
				<span>Ok</span>
			</div>
<!-- 			<span id="ok" style="position:absolute;top:1.5%;left:76%;width:10%;cursor:hand;"> -->
<!-- 			<img src="../../images/ok.gif" alt="Ok" onmouseover="raiseButton(this)" onmouseout="normalButton(this)" onclick="normalButton(this),submitValue()"> -->
<!-- 			</img> -->
<!-- 			</span> -->
<!-- Added by Nilesh Soor on 17/09/2014 [ PopHelp values not setting in respective field ] START -->
<!-- <div id="cancel" class="button red-Btn pophelp-okcancel" onClick='self.close();'> -->
			<div id="cancel" class="button red-Btn pophelp-okcancel" onClick='closeMe();'>
				<span>Cancel</span>
			</div>
<!-- Added by Nilesh Soor on 17/09/2014 [ PopHelp values not setting in respective field ] END -->
<!-- 			<span id="cancel" style="position:absolute;top:1.5%;left:82%;width:10%;cursor:hand;"> -->
<!-- 			<img src="../../images/cancel.gif" alt="Cancel" onmouseover="raiseButton(this)" onmouseout="normalButton(this)" onclick="normalButton(this),self.close()" > -->
<!-- 			</img> -->
<!-- 			</span> -->
		</div>
	</div>

</BODY>
<script language="javascript">
//  Added by Nilesh Soor on 08/10/2014 START
<![CDATA[
//  Added by Nilesh Soor on 19/09/2014 [ PopHelp values not setting in respective filed ] START
var usrTheme = '';
if(  window.opener != null && window.opener != undefined )
{
	usrTheme= window.opener.userTheme;
}
else
{
	usrTheme= parent.userTheme;
}

//var usrTheme= parent.userTheme;
document.getElementById("userThemeLink").href = "/ibase/webitm/css/theme/"+usrTheme+".css";
//  Added by Nilesh Soor on 19/09/2014 [ PopHelp values not setting in respective filed ] END
]]>
//  Added by Nilesh Soor on 08/10/2014 END
</script>
</HTML>
</xsl:template>
</xsl:stylesheet>