

/********************************************************
	Title : ProjectIC (DI3ASUN006)
	Date  : 09/04/13
	Developer: Kunal Mandhre

 ********************************************************/

package ibase.webitm.ejb.adm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; 
@Stateless 

public class ProjectIC extends ValidatorEJB implements ProjectICLocal, ProjectICRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0 )
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0 )
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ProjectIC][wfValData( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String siteCode = "" ,projectCode = "", descr = "" ,itemCode = "";
		String startDateStr = "" ,endDateStr = "",deptCode = "",accountCode = "",cctrCode = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		//String sql = "";
		String errorType = "";
		int count = 0;
		int ctr=0;
		int currentFormNo = 0;
		int childNodeListLength;
		Timestamp startDate = null, endDate = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		System.out.println("editFlag="+editFlag);
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("proj_code"))
					{
						projectCode = checkNull(genericUtility.getColumnValue("proj_code", dom));
						System.out.println("projectCode="+projectCode);
						/*if("A".equalsIgnoreCase(editFlag))
						{
							if(projectCode == null || projectCode.trim().length() == 0)
							{
								errCode = "VEPRJ1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								if((isExist(conn, "project", "proj_code" ,projectCode)))
								{
									errCode = "VDPRJ1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());   
								}
							}
						}*/
					}
					else if(childNodeName.equalsIgnoreCase("descr"))
					{
						descr = checkNull(genericUtility.getColumnValue("descr", dom));
						if( descr.trim().length() == 0)
						{
							errCode = "VEPRJ2";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("start_date"))
					{
						startDateStr = genericUtility.getColumnValue("start_date", dom);
						if( startDateStr == null || startDateStr.trim().length() == 0)
						{
							errCode = "VEDAT1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("end_date"))
					{
						startDateStr = genericUtility.getColumnValue("start_date", dom);
						endDateStr = genericUtility.getColumnValue("end_date", dom);
						/*if( endDateStr == null || endDateStr.trim().length() == 0)
						{
							errCode = "VEDAT1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}*/
						if(startDateStr != null && startDateStr.trim().length() > 0 && endDateStr != null && endDateStr.trim().length() > 0 )
						{
							startDate = Timestamp.valueOf(genericUtility.getValidDateString(startDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
							endDate = Timestamp.valueOf(genericUtility.getValidDateString(endDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
							if(endDate != null && endDate.before(startDate))
							{
								errCode = "VMSTDT10";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("exp_end_date"))
					{
						startDateStr = genericUtility.getColumnValue("start_date", dom);
						endDateStr = genericUtility.getColumnValue("exp_end_date", dom);
						/*if( endDateStr == null || endDateStr.trim().length() == 0)
						{
							errCode = "VEDAT1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}*/
						if(startDateStr != null && startDateStr.trim().length() > 0 && endDateStr != null && endDateStr.trim().length() > 0 )
						{
							startDate = Timestamp.valueOf(genericUtility.getValidDateString(startDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
							endDate = Timestamp.valueOf(genericUtility.getValidDateString(endDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
							if(endDate != null && endDate.before(startDate))
							{
								errCode = "VMSTDT10";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("site_code"))
					{
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));

						if(siteCode.trim().length() > 0)
						{
							if(!(isExist(conn, "site", "site_code" ,siteCode)))
							{
								errCode = "VMSITE1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("item_code"))
					{
						itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
						if(itemCode.trim().length() > 0)
						{
							if(!(isExist(conn, "item", "item_code" ,itemCode)))
							{
								errCode = "VMITEMCDX";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
							else
							{
							//gbf_item
							errCode = isItem(siteCode, itemCode, "", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("dept_code"))
					{
						deptCode = checkNull(genericUtility.getColumnValue("dept_code", dom));
						if(deptCode.trim().length() > 0)
						{
							//gbf_department
							if(!(isExist(conn, "department", "dept_code" ,deptCode)))
							{
								errCode = "VTDEPT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("acct_code"))
					{
						accountCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
						if(accountCode.trim().length() > 0)
						{
							if(!(isExist(conn, "ACCOUNTS", "ACCT_CODE" ,accountCode)))
							{
								errCode = "VMACCT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
							else
							{
							//gbf_acct
							//errCode = isAcctCode(siteCode, accountCode, "");
							errCode = isAcctCode(siteCode, accountCode, "",conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("cctr_code"))
					{
						cctrCode = checkNull(genericUtility.getColumnValue("cctr_code", dom));
						accountCode = checkNull(genericUtility.getColumnValue("acct_code", dom));
						if(cctrCode.trim().length() > 0)
						{
							//gbf_cctr
							errCode = isCctrCode(accountCode, cctrCode, "");
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}

				}
				break;


			}
			int errListSize = errList.size();
			count = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(count = 0; count < errListSize; count ++)
				{
					errCode = errList.get(count);
					errFldName = errFields.get(count);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	// method for item change
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		System.out.println("xmlString............."+xmlString);
		System.out.println("xmlString1............"+xmlString);
		System.out.println("xmlString2............"+xmlString);
		try
		{   
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ProjectIC][itemChanged( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String descr = "",siteCode = "";
		String projStatus = "" , endDateStr = "",itemCode = "" , deptCode = "" ,acctCode = "";
		String childNodeName = null;
		//String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		try
		{   
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{

			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));


				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					siteCode  = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
					descr = "";
					descr = findValue(conn, "descr", "site", "site_code",siteCode );
					valueXmlString.append("<site_code>").append("<![CDATA[" + siteCode +"]]>").append("</site_code>");
					valueXmlString.append("<site_descr>").append("<![CDATA[" + descr +"]]>").append("</site_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("proj_status"))
				{
					projStatus  = checkNull(genericUtility.getColumnValue("proj_status", dom));
					endDateStr = genericUtility.getColumnValue("end_date", dom);
					if("P".equalsIgnoreCase(projStatus) || "A".equalsIgnoreCase(projStatus))
					{
						if(endDateStr == null || endDateStr.trim().length() == 0)
						{
							valueXmlString.append("<end_date protect='1'></end_date>");
						}
						else
						{
							valueXmlString.append("<end_date protect='1'></end_date>");
							//valueXmlString.append("<end_date protect='1'>").append("<![CDATA[" + endDateStr +"]]>").append("</end_date>");
						}
					}
					else if ("T".equalsIgnoreCase(projStatus) || "C".equalsIgnoreCase(projStatus))
					{
						if(endDateStr == null || endDateStr.trim().length() == 0)
						{
							valueXmlString.append("<end_date protect='0'></end_date>");
						}
						else
						{
							valueXmlString.append("<end_date protect='1'></end_date>");
						//valueXmlString.append("<end_date protect='0'>").append("<![CDATA[" + endDateStr +"]]>").append("</end_date>");
						}
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					siteCode  = checkNull(genericUtility.getColumnValue("site_code", dom));
					descr = "";
					descr = findValue(conn, "descr", "site", "site_code",siteCode );
					valueXmlString.append("<site_descr>").append("<![CDATA[" + descr +"]]>").append("</site_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("item_code"))
				{
					itemCode  = checkNull(genericUtility.getColumnValue("item_code", dom));
					descr = "";
					descr = findValue(conn, "descr", "item", "item_code",itemCode );
					valueXmlString.append("<item_descr>").append("<![CDATA[" + descr +"]]>").append("</item_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("dept_code"))
				{
					deptCode  = checkNull(genericUtility.getColumnValue("dept_code", dom));
					descr = "";
					descr = findValue(conn, "descr", "department", "dept_code",deptCode );
					valueXmlString.append("<department_descr>").append("<![CDATA[" + descr +"]]>").append("</department_descr>");
				}
				else if(currentColumn.trim().equalsIgnoreCase("acct_code"))
				{
					acctCode  = checkNull(genericUtility.getColumnValue("acct_code", dom));
					descr = "";
					descr = findValue(conn, "descr", "accounts", "acct_code",acctCode );
					valueXmlString.append("<accounts_descr>").append("<![CDATA[" + descr +"]]>").append("</accounts_descr>");
				}
				valueXmlString.append("</Detail1>");
				break; 
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;	
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}			
		}
		return valueXmlString.toString();
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}
	private boolean isExist(Connection conn, String tableName, String columnName, String value) throws  ITMException, RemoteException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		boolean status = false;
		try
		{			
			sql = "SELECT count(*) from " + tableName + " where " + columnName +"  = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();

			if(rs.next())
			{					
				if(rs.getBoolean(1))
				{					
					status = true;
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in isExist ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from isExist ");
		return status;
	}
	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";

		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();

			if(rs.next())
			{					
				findValue = rs.getString(columnName);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from findValue ");
		return findValue;
	}
	public String isAcctCode(String siteCode,String acctCode,String modName,Connection con ) throws RemoteException,ITMException
	{
		String errCode = "", siteSpec = ""; //$NON-NLS-1$ //$NON-NLS-2$
		long counter;
		//Connection con = null;
		String sql1 = ""; //$NON-NLS-1$
		Statement stmt1 = null;
		ResultSet rs1 = null;

		String sql2 = ""; //$NON-NLS-1$
		Statement stmt2 = null;
		ResultSet rs2 = null;

		String sql3 = ""; //$NON-NLS-1$
		Statement stmt3 = null;
		ResultSet rs3 = null;

		StringBuffer sql4 = null;
		Statement stmt4 = null;
		ResultSet rs4 = null;
		try
		{
			//con = getConnection();
			sql1 = "SELECT VAR_VALUE FROM FINPARM WHERE PRD_CODE = '999999' AND VAR_NAME = 'SITE_SPECIFIC_ACCT'"; //$NON-NLS-1$
			stmt1 = con.createStatement();
			rs1 = stmt1.executeQuery(sql1);
			if (rs1.next())
			{
				siteSpec = checkNull(rs1.getString(1)).trim();
				System.out.println("siteSpec="+siteSpec);
				sql2 = "SELECT COUNT(1) FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
				stmt2 = con.createStatement();
				rs2 = stmt1.executeQuery(sql2);
				if (rs2.next())
				{
					if (rs2.getLong(1) != 0)
					{
						sql3 = "SELECT ACTIVE FROM ACCOUNTS WHERE ACCT_CODE = '" + acctCode + "'"; //$NON-NLS-1$ //$NON-NLS-2$
						stmt3 = con.createStatement();
						rs3 = stmt3.executeQuery(sql3);
						if (rs3.next())
						{
							if (!rs3.getString(1).equals("Y")) //$NON-NLS-1$
							{
								// Error : A/c code not active.
								errCode = "VMACCTA"; //$NON-NLS-1$
							}
							else
							{
								//siteSpec = rs1.getString(1).trim();
								if(siteSpec.equals("Y") && siteSpec != null) //$NON-NLS-1$
								{
									sql4 = new StringBuffer();
									sql4.append("SELECT COUNT(1) FROM SITE_ACCOUNT WHERE SITE_CODE = '"); //$NON-NLS-1$
									sql4.append(siteCode).append("' AND ACCT_CODE = '"); //$NON-NLS-1$
									sql4.append(acctCode).append("'"); //$NON-NLS-1$
									stmt4 = con.createStatement();
									rs4 = stmt4.executeQuery(sql4.toString());
									if (rs4.next())
									{
										if (rs4.getLong(1) == 0)
										{
											errCode = "VMACCT4"; //$NON-NLS-1$
										}
									}
								}
							}
						}
					}
					else
					{
						errCode = "VMACCT1"; //$NON-NLS-1$
					}
				}
			}
       		rs1.close();
			//rs2.close();
			//rs3.close();
			//rs4.close();
			stmt1.close();
			//stmt2.close();
			//stmt3.close();
			//stmt4.close();
			//con.close();
		}
		
		catch(Exception e)
		{
			System.out.println("Exception : ValidatorEJB : isAcctCode :==>\n"+e.getMessage()); //$NON-NLS-1$
			e.printStackTrace();
			errCode = e.getMessage();
			throw new ITMException(e);
		}
		return errCode;
	}


	private String errorType(Connection conn , String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}
}	
