/*
 * Copyright (c) 2008-2009 GWT Mosaic Georgios J. Georgopolos.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwt.mosaic.actions.client;

/**
 * This interface is for classes that listen for {@link Action} events.
 * 
 * @author georgopoulos.georgios(at)gmail.com
 * @see ActionEvent
 */
public interface ActionListener {
  /**
   * This method is invoked when an action occurs.
   * 
   * @param event the {@link ActionEvent} that occurred.
   */
  public void actionPerformed(ActionEvent event);
}
