/*
 * Author:Wasim Ansari
 * Date: 10-OCT-15
 * Request ID: W15GSUN002
 * Description: Pallet requisition (Against Order)
 */

package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;

@Stateless
public class PalletRequisitionActEJB extends ActionHandlerEJB implements PalletRequisitionActLocal,PalletRequisitionActRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();
	DistCommon distComm = new DistCommon();
	public String distActionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------ActionHandler method of Distribution Pallet Requisition ------------- : ["+tranId+"]");
		String retString = "";	
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Boolean isError = false;

		try
		{		
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			connDriver = null;
			retString = distPalletRequisition(tranId,xtraParams,forcedFlag,conn);
			//String sql = "select item_code,line_no,quantity,unit,lot_no,lot_sl,mfg_date,exp_date,pallet_no from distord_issdet where dist_order = ?";
			//retString = distPalletRequisition(tranId,xtraParams,forcedFlag,sql,conn);		
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :SendReport :actionHandler():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally
		{
			System.out.println("is Error in main="+isError);
			try
			{
				if(isError)
				{
					conn.rollback();
					retString = itmDBAccessEJB.getErrorString("","VTTNSVD","","",conn);
				}
				if(conn != null){conn.close();conn = null;}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Final return="+retString);
		return retString;
	}

	public String sorderActionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------ActionHandler method of Sorder Pallet Requisition ------------- : ["+tranId+"]");
		String retString = "";	
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Boolean isError = false;

		try
		{		
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			connDriver = null;
			retString = sorderPalletRequisition(tranId,xtraParams,forcedFlag,conn);
			//String sql = "select item_code,line_no,quantity,unit__std,lot_no,lot_sl,mfg_date,exp_date FROM sordalloc where sale_order = ?";
			//retString = distPalletRequisition(tranId,xtraParams,forcedFlag,sql,conn);	
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :actionHandler():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally
		{
			System.out.println("is Error in main="+isError);
			try
			{
				if(isError)
				{
					retString = itmDBAccessEJB.getErrorString("","VTTNSVD","","",conn);
				}
				if(conn != null){conn.close();conn = null;}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Final return="+retString);
		return retString;
	}

	public String distPalletRequisition(String tranId,String xtraParams,String forcedFlag,Connection conn) throws RemoteException,ITMException
	{
		System.out.println("==================In distPalletRequisition=======================");
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null, interfacePstmt = null;	
		int flag = 0;
		Boolean isError = false;
		HashMap hm = new HashMap();

		String loginEmpCode = "",userId = "",loginSite = "",errString = "",itemDescr = "";
		String itemCode = "",lineNo = "",descr = "",unit = "",itemType = "",familyGrp = "",refSer = "",lotNo = "",refId = "",lotSl = "",
		palletNo = "",palletStatus = "",lockStat = "",qcType = "",stroPref = "",palletRej = "",palletRejDesc = "",confirmed = "",siteCode = "";
		String transactionId = "";

		//Timestamp today = new Timestamp(System.currentTimeMillis());
		Calendar cal = Calendar.getInstance();
		
		
		Timestamp expDate = null;
		Timestamp mfgDate = null;

		double quantity = 0, noArtQuot = 0,noArtRem = 0,notArt = 0,shipperSize = 0,totalQuantity = 0, qtyPerArt = 0;

		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("XTRA PARAMS ["+xtraParams+"]");

		loginEmpCode = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode")));

		ArrayList interfaceArrList = new ArrayList();
		try
		{
			System.out.println("Inside try block distribution.....");
			//changed by azhar
			SimpleDateFormat dbf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Timestamp today = Timestamp.valueOf(dbf.format(cal.getTime()) + " 00:00:00.0");
			//changed by azhar
			System.out.println("today::: " + today);
			System.out.println("String date:: " + String.valueOf(today));
			
			sql = "SELECT CONFIRMED FROM DISTORDER WHERE DIST_ORDER = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			if("Y".equalsIgnoreCase(confirmed))
			{
				//sql = "SELECT * FROM INTERFACE2 WHERE REF_ID = ?";
				sql = "SELECT * FROM SWMS_TO_AWMS WHERE REF_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					System.out.println("Transaction is already present in interface2 table");
					errString = itmDBAccessEJB.getErrorString("","ALRDYSUBMT","","",conn);  
					return errString;
				}
				else
				{
					//Changed by wasim on 09-11-2015 for taking data from stock and distorderalloc join.
					//sql = "SELECT ITEM_CODE,LINE_NO,QUANTITY,UNIT,LOT_NO,LOT_SL,MFG_DATE,EXP_DATE,LOC_CODE,SITE_CODE__MFG FROM DISTORDER_ALLOC WHERE DIST_ORDER = ?";
					sql = "SELECT D.ITEM_CODE,I.DESCR,D.LINE_NO,D.QUANTITY,D.UNIT,D.LOT_NO,D.LOT_SL,S.SITE_CODE,D.LOC_CODE,S.NO_ART,S.QTY_PER_ART"
						//+" FROM STOCK S,DISTORDER_ALLOC D,DISTORDER H WHERE" //Changed by wasim on 20-08-2015 to add inv_stat AWMS validation
						+" FROM STOCK S,DISTORDER_ALLOC D,DISTORDER H,LOCATION L,ITEM I WHERE" 
						+" S.ITEM_CODE = D.ITEM_CODE" 
						+" AND S.LOT_NO = D.LOT_NO"
						+" AND S.LOT_SL = D.LOT_SL"
						+" AND S.LOC_CODE = D.LOC_CODE"
						//+" AND S.SITE_CODE = H.SITE_CODE"
						+" AND S.SITE_CODE = H.SITE_CODE__SHIP" //Changed by wasim on 14-07-2016 as per manoharan sir
						+" AND H.DIST_ORDER = D.DIST_ORDER"
						+" AND L.LOC_CODE = D.LOC_CODE" //Changed by wasim on 20-08-2015 to add inv_stat validation
						//+" AND L.INV_STAT = 'AWMS'" //Changed by wasim on 20-08-2015 to add inv_stat validation
						+" AND L.INV_STAT IN ('AWMS','AWMSQ')" 
						+" AND I.ITEM_CODE = D.ITEM_CODE" //Changed by wasim on 20-08-2015 to add inv_stat validation
						+" AND D.DIST_ORDER = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						flag = 1;//record found in distribution order

						itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
						itemDescr = checkNullAndTrim(rs.getString("DESCR"));
						lineNo = checkNullAndTrim(rs.getString("LINE_NO"));

						//Changed by wasim on 26-11-2015 to remove space for interface table [START]
						/*lineNo = "   " + lineNo;
							lineNo = lineNo.substring(lineNo.length()-3);*/
						//Changed by wasim on 26-11-2015 to remove space for interface table [END]

						quantity   = rs.getDouble("QUANTITY");
						unit  = checkNullAndTrim(rs.getString("UNIT"));
						lotNo  = checkNullAndTrim(rs.getString("LOT_NO"));
						lotSl  = checkNullAndTrim(rs.getString("LOT_SL"));
						//mfgDate  = rs.getTimestamp("MFG_DATE");
						//expDate  = rs.getTimestamp("EXP_DATE");
						palletNo  = checkNullAndTrim(rs.getString("LOC_CODE"));
						siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));
						notArt  = rs.getDouble("NO_ART");
						qtyPerArt  = rs.getDouble("QTY_PER_ART");

						/*hm = getPalletizedAttributes(itemCode,siteCode,conn);
							familyGrp = (String) hm.get("LOC_ZONE__PREF");
							qcType = (String) hm.get("PROC_MTH");
							stroPref = (String) hm.get("ANALYSIS_CLASS");*/

						//transactionId = generateTranTd("w_interface2",today.toString(),loginSite,conn);

						palletStatus = commonWmsUtility.getFullOrPrtialPalletOut(palletNo,"D-SO",tranId,siteCode,conn);
						System.out.println("Pallet Status recevied from common util="+palletStatus);
						HashMap interfaceHmap = new HashMap();

						/*hm = commonWmsUtility.getItemVoumeMap(itemCode,lotNo,conn);
							shipperSize =  (Double) hm.get("PACK_SIZE");

							noArtQuot= quantity / shipperSize ;
							noArtRem = quantity % shipperSize ;
							if(noArtRem > 0)
							{
								noArtRem = 1;
							}
							notArt = noArtQuot + noArtRem;
							totalQuantity = notArt * shipperSize;

							System.out.println("Quantity["+quantity+"]ShipperSize["+shipperSize+"]noArtQuot["+noArtQuot+"]"
									+ "noArtRem["+noArtRem+"]notArt["+notArt+"]TotalQuantity["+totalQuantity+"]");*/

						noArtQuot= quantity / qtyPerArt ;
						noArtRem = quantity % qtyPerArt ;
						if(noArtRem > 0)
						{
							noArtRem = 1;
						}
						noArtQuot = (int) noArtQuot;

						notArt = noArtQuot + noArtRem;
						totalQuantity = notArt * qtyPerArt;

						System.out.println("Quantity["+quantity+"]ShipperSize["+qtyPerArt+"]noArtQuot["+noArtQuot+"]"
								+ "noArtRem["+noArtRem+"]notArt["+notArt+"]TotalQuantity["+totalQuantity+"]");


						System.out.println("Pallet No before removing suffix: "+palletNo);
						palletNo = (palletNo.charAt(palletNo.trim().length()-1)=='Q') || (palletNo.charAt(palletNo.trim().length()-1)=='M') || 
						(palletNo.charAt(palletNo.trim().length()-1)=='S') || (palletNo.charAt(palletNo.trim().length()-1)=='B') ||
						(palletNo.charAt(palletNo.trim().length()-1)=='X') || (palletNo.charAt(palletNo.trim().length()-1)=='U') || 
						(palletNo.charAt(palletNo.trim().length()-1)=='P') || (palletNo.charAt(palletNo.trim().length()-1)=='R')
						 ? palletNo.substring(0,palletNo.trim().length()-1):palletNo;
						System.out.println("Pallet No After removing suffix: "+palletNo);	

						interfaceHmap.put("TRAN_ID", "");
						interfaceHmap.put("ITEM_CODE", itemCode);
						interfaceHmap.put("DESCR", itemDescr);
						interfaceHmap.put("UNIT", unit);
						interfaceHmap.put("ITEM_TYPE", "");
						interfaceHmap.put("FAMILY_GRP", "");
						interfaceHmap.put("IN_OUT", "O");
						interfaceHmap.put("REF_SER", "D-SO");
						interfaceHmap.put("REF_ID", tranId);
						interfaceHmap.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
						interfaceHmap.put("LOT_NO", lotNo);	
						interfaceHmap.put("LOT_SL", lotSl);
						interfaceHmap.put("QUANTITY", String.valueOf(notArt));
						interfaceHmap.put("QTY_PER_ART", String.valueOf(qtyPerArt));
						interfaceHmap.put("TOTAL_QTY", String.valueOf(totalQuantity));
						System.out.println("exp_date="+expDate);
						System.out.println("Mfg_date="+mfgDate);
						interfaceHmap.put("EXP_DATE", "");	
						interfaceHmap.put("MFG_DATE", "");	
						interfaceHmap.put("PALLET_NO", palletNo);	
						interfaceHmap.put("MSG_STAT", "N");
						interfaceHmap.put("PALLET_STATUS", palletStatus);
						interfaceHmap.put("LOCK_STAT", "");
						interfaceHmap.put("ERR_COD", "");
						interfaceHmap.put("ERR_DESC", "");
						interfaceHmap.put("QC_TYPE", "");
						interfaceHmap.put("TRANS_DT_ACK", "");
						interfaceHmap.put("STRO_PREF", "");
						interfaceHmap.put("LINE_NO", lineNo);

						interfaceArrList.add(interfaceHmap);
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;

					if(flag == 0)
					{
						sql = "SELECT D.ITEM_CODE,I.DESCR,D.LINE_NO,D.QUANTITY,D.UNIT,D.LOT_NO,D.LOT_SL,D.LOC_CODE,S.NO_ART,S.QTY_PER_ART,H.SITE_CODE"
							//+" FROM STOCK S,DISTORD_ISSDET D,DISTORD_ISS H  WHERE" //Changed by wasim on 20-08-2015 to add inv_stat AWMS validation
							+" FROM STOCK S,DISTORD_ISSDET D,DISTORD_ISS H,LOCATION L,ITEM I  WHERE"
							+" S.ITEM_CODE = D.ITEM_CODE" 
							+" AND S.LOT_NO = D.LOT_NO"
							+" AND S.LOT_SL = D.LOT_SL"
							+" AND S.LOC_CODE = D.LOC_CODE"
							+" AND S.SITE_CODE = H.SITE_CODE"
							+" AND D.TRAN_ID = H.TRAN_ID"
							+" AND H.CONFIRMED = 'N'"
							+" AND L.LOC_CODE = D.LOC_CODE" //Changed by wasim on 20-08-2015 to add inv_stat validation
							//+" AND L.INV_STAT = 'AWMS'"
							+" AND L.INV_STAT IN ('AWMS','AWMSQ')" 
							+" AND I.ITEM_CODE = D.ITEM_CODE" //Changed by wasim on 20-08-2015 to add inv_stat validation
							+" AND D.DIST_ORDER = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranId);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							flag = 1;

							itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
							itemDescr = checkNullAndTrim(rs.getString("DESCR"));
							lineNo = checkNullAndTrim(rs.getString("LINE_NO"));

							//Changed by wasim on 26-11-2015 to remove space for interface table [START]
							/*lineNo = "   " + lineNo;
								lineNo = lineNo.substring(lineNo.length()-3);*/
							//Changed by wasim on 26-11-2015 to remove space for interface table [END]

							quantity   = rs.getDouble("QUANTITY");
							unit  = checkNullAndTrim(rs.getString("UNIT"));
							lotNo  = checkNullAndTrim(rs.getString("LOT_NO"));
							lotSl  = checkNullAndTrim(rs.getString("LOT_SL"));
							palletNo  = checkNullAndTrim(rs.getString("LOC_CODE"));
							notArt  = rs.getDouble("NO_ART");
							qtyPerArt  = rs.getDouble("QTY_PER_ART");

							siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));


							noArtQuot= quantity / qtyPerArt ;
							noArtRem = quantity % qtyPerArt ;
							if(noArtRem > 0)
							{
								noArtRem = 1;
							}
							noArtQuot = (int) noArtQuot;

							notArt = noArtQuot + noArtRem;
							totalQuantity = notArt * qtyPerArt;

							System.out.println("Quantity["+quantity+"]ShipperSize["+qtyPerArt+"]noArtQuot["+noArtQuot+"]"
									+ "noArtRem["+noArtRem+"]notArt["+notArt+"]TotalQuantity["+totalQuantity+"]");

							palletStatus = commonWmsUtility.getFullOrPrtialPalletOut(palletNo,"D-SO",tranId,siteCode,conn);
							System.out.println("Pallet Status recevied from common util="+palletStatus);

							System.out.println("Pallet No before removing suffix: "+palletNo);
							palletNo = (palletNo.charAt(palletNo.trim().length()-1)=='Q') || (palletNo.charAt(palletNo.trim().length()-1)=='M') || 
							(palletNo.charAt(palletNo.trim().length()-1)=='S') || (palletNo.charAt(palletNo.trim().length()-1)=='B') ||
							(palletNo.charAt(palletNo.trim().length()-1)=='X') || (palletNo.charAt(palletNo.trim().length()-1)=='U') || 
							(palletNo.charAt(palletNo.trim().length()-1)=='P') || (palletNo.charAt(palletNo.trim().length()-1)=='R')
							 ? palletNo.substring(0,palletNo.trim().length()-1):palletNo;
							System.out.println("Pallet No After removing suffix: "+palletNo);	

							HashMap interfaceHmap = new HashMap();

							interfaceHmap.put("TRAN_ID", "");
							interfaceHmap.put("ITEM_CODE", itemCode);
							interfaceHmap.put("DESCR", itemDescr);
							interfaceHmap.put("UNIT", unit);
							interfaceHmap.put("ITEM_TYPE", "");
							interfaceHmap.put("FAMILY_GRP", "");
							interfaceHmap.put("IN_OUT", "O");
							interfaceHmap.put("REF_SER", "D-SO");
							interfaceHmap.put("REF_ID", tranId);
							interfaceHmap.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
							interfaceHmap.put("LOT_NO", lotNo);	
							interfaceHmap.put("LOT_SL", lotSl);
							interfaceHmap.put("QUANTITY", String.valueOf(notArt));
							interfaceHmap.put("QTY_PER_ART", String.valueOf(qtyPerArt));
							interfaceHmap.put("TOTAL_QTY", String.valueOf(quantity));
							interfaceHmap.put("EXP_DATE", "");	
							interfaceHmap.put("MFG_DATE", "");	
							interfaceHmap.put("PALLET_NO", palletNo);	
							interfaceHmap.put("MSG_STAT", "N");
							interfaceHmap.put("PALLET_STATUS", palletStatus);
							interfaceHmap.put("LOCK_STAT", "");
							interfaceHmap.put("ERR_COD", "");
							interfaceHmap.put("ERR_DESC", "");
							interfaceHmap.put("QC_TYPE", "");
							interfaceHmap.put("TRANS_DT_ACK", "");
							interfaceHmap.put("STRO_PREF", "");
							interfaceHmap.put("LINE_NO", lineNo);

							interfaceArrList.add(interfaceHmap);
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

						if(flag == 0)
						{	
							errString = itmDBAccessEJB.getErrorString("","RECNOTSORA","","",conn);
							return errString;
						}
						else
						{	System.out.println("list for mapping:: " + interfaceArrList);
							commonWmsUtility.updateAwmsInterface(interfaceArrList,loginSite,conn);
						}
					}
					else
					{	System.out.println("list for commonsutil:: " + interfaceArrList);
						commonWmsUtility.updateAwmsInterface(interfaceArrList,loginSite,conn);
					}
				}
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTTSORNTCF","","",conn);
				return errString;
			}
		}
		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError="+isError);
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
					errString = itmDBAccessEJB.getErrorString("","VTCONPARM","","",conn);   
				}

				if(pstmt != null){pstmt.close();pstmt=null;}
				if(interfacePstmt != null){interfacePstmt.close();interfacePstmt=null;}
				if(rs != null){rs.close();rs=null;}
			}
			catch(Exception e1)
			{
				throw new ITMException(e1);
			}
		}
		return errString;
	}
	public String sorderPalletRequisition(String tranId,String xtraParams,String forcedFlag,Connection conn) throws RemoteException,ITMException
	{
		System.out.println("==================In sorderPalletRequisition=======================");
		String sql = "", interfaceSql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null, interfacePstmt = null;	

		int caseCount = 0,flag = 0;
		Boolean isError = false;

		String loginEmpCode = "",userId = "",loginSite = "",errString = "",objName = "",itemDescr = "";
		String itemCode = "",lineNo = "",descr = "",unit = "",itemType = "",familyGrp = "",refSer = "",lotNo = "",refId = "",lotSl = "",
		palletNo = "",palletStatus = "",lockStat = "",qcType = "",stroPref = "",palletRej = "",palletRejDesc = "",confirmed = "",siteCode = "";
		String transactionId = "";

		double quantity = 0, noArtQuot = 0,noArtRem = 0,notArt = 0,shipperSize = 0,totalQuantity = 0,qtyPerArt = 0;

		//Timestamp today = new Timestamp(System.currentTimeMillis());
		Timestamp expDate = null;
		Timestamp mfgDate = null;

		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("XTRA PARAMS ["+xtraParams+"]");

		loginEmpCode = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode")));
		Calendar cal = Calendar.getInstance();
		ArrayList interfaceArrList = new ArrayList();

		try
		{
			//changed by azhar
			SimpleDateFormat dbf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Timestamp today = Timestamp.valueOf(dbf.format(cal.getTime()) + " 00:00:00.0");
			//changed by azhar
			
			System.out.println("Inside try block sale order.....");
			System.out.println("Today="+today);

			sql = "SELECT CONFIRMED FROM SORDER WHERE SALE_ORDER = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			if("Y".equalsIgnoreCase(confirmed))
			{
				//sql = "SELECT * FROM INTERFACE2 WHERE REF_ID = ?";SWMS_TO_AWMS
				sql = "SELECT * FROM SWMS_TO_AWMS WHERE REF_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					System.out.println("Transaction is already present in interface2 table");
					errString = itmDBAccessEJB.getErrorString("","ALRDYSUBMT","","",conn);  
					return errString;
				}
				else
				{
					//sql = "SELECT ITEM_CODE,LINE_NO,QUANTITY,UNIT__STD,LOT_NO,LOT_SL,MFG_DATE,EXP_DATE,LOC_CODE,SITE_CODE FROM SORDALLOC WHERE SALE_ORDER = ?";
					sql = "SELECT S.ITEM_CODE,I.DESCR,D.LINE_NO,S.QUANTITY,D.UNIT,S.LOT_NO,S.LOT_SL,S.SITE_CODE,S.LOC_CODE,S.NO_ART,S.QTY_PER_ART,"
						+" I.ITEM_TYPE"//+" FROM STOCK S,SORDALLOC D WHERE" //Changed by wasim on 20-08-2015 to add inv_stat validation
						+" FROM STOCK S,SORDALLOC D,LOCATION L,ITEM I WHERE" 
						+" S.ITEM_CODE = D.ITEM_CODE" 
						+" AND S.LOT_NO = D.LOT_NO"
						+" AND S.LOT_SL = D.LOT_SL"
						+" AND S.LOC_CODE = D.LOC_CODE"
						+" AND S.SITE_CODE = D.SITE_CODE"
						+" AND L.LOC_CODE = D.LOC_CODE" //Changed by wasim on 20-08-2015 to add inv_stat validation
						+" AND L.INV_STAT IN ('AWMS','AWMSQ')" 
						+" AND I.ITEM_CODE = D.ITEM_CODE" //Changed by wasim on 20-08-2015 to add inv_stat validation
						+" AND D.SALE_ORDER = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						flag = 1;

						itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
						itemDescr = checkNullAndTrim(rs.getString("DESCR"));
						lineNo = checkNullAndTrim(rs.getString("LINE_NO"));

						//Changed by wasim on 26-11-2015 to remove space for interface table [START]
						/*lineNo = "   " + lineNo;
							lineNo = lineNo.substring(lineNo.length()-3);*/
						//Changed by wasim on 26-11-2015 to remove space for interface table [END]

						quantity   = rs.getDouble("QUANTITY");
						unit  = checkNullAndTrim(rs.getString("UNIT"));
						lotNo  = checkNullAndTrim(rs.getString("LOT_NO"));
						lotSl  = checkNullAndTrim(rs.getString("LOT_SL"));
						//mfgDate  = rs.getTimestamp("MFG_DATE");
						//expDate  = rs.getTimestamp("EXP_DATE");
						palletNo  = checkNullAndTrim(rs.getString("LOC_CODE"));

						notArt  = rs.getDouble("NO_ART");
						qtyPerArt  = rs.getDouble("QTY_PER_ART");

						itemType = checkNullAndTrim(rs.getString("ITEM_TYPE"));
						/*hm = getPalletizedAttributes(itemCode,siteCode,conn);
							familyGrp = (String) hm.get("LOC_ZONE__PREF");
							qcType = (String) hm.get("PROC_MTH");
							stroPref = (String) hm.get("ANALYSIS_CLASS");*/

						//transactionId = generateTranTd("w_interface2",today.toString(),loginSite,conn);

						/*HashMap hm = new HashMap();
							hm = commonWmsUtility.getItemVoumeMap(itemCode,lotNo,conn);
							shipperSize =  (Double) hm.get("PACK_SIZE");

							noArtQuot= quantity / shipperSize ;
							noArtRem = quantity % shipperSize ;
							if(noArtRem > 0)
							{
								noArtRem = 1;
							}
							notArt = noArtQuot + noArtRem;
							totalQuantity = notArt * shipperSize;
							System.out.println("Quantity["+quantity+"]ShipperSize["+shipperSize+"]noArtQuot["+noArtQuot+"]"
									+ "noArtRem["+noArtRem+"]notArt["+notArt+"]TotalQuantity["+totalQuantity+"]");*/

						noArtQuot= quantity / qtyPerArt ;
						noArtRem = quantity % qtyPerArt ;
						if(noArtRem > 0)
						{
							noArtRem = 1;
						}
						noArtQuot = (int) noArtQuot;

						notArt = noArtQuot + noArtRem;
						totalQuantity = notArt * qtyPerArt;

						System.out.println("Quantity["+quantity+"]ShipperSize["+qtyPerArt+"]noArtQuot["+noArtQuot+"]"
								+ "noArtRem["+noArtRem+"]notArt["+notArt+"]TotalQuantity["+totalQuantity+"]");

						System.out.println("Pallet No before removing suffix: "+palletNo);
						palletNo = (palletNo.charAt(palletNo.trim().length()-1)=='Q') || (palletNo.charAt(palletNo.trim().length()-1)=='M') || 
						(palletNo.charAt(palletNo.trim().length()-1)=='S') || (palletNo.charAt(palletNo.trim().length()-1)=='B') ||
						(palletNo.charAt(palletNo.trim().length()-1)=='X') || (palletNo.charAt(palletNo.trim().length()-1)=='U') || 
						(palletNo.charAt(palletNo.trim().length()-1)=='P') || (palletNo.charAt(palletNo.trim().length()-1)=='R')
						 ? palletNo.substring(0,palletNo.trim().length()-1):palletNo;
						System.out.println("Pallet No After removing suffix: "+palletNo);	

						HashMap interfaceHmap = new HashMap(); 

						interfaceHmap.put("TRAN_ID", "");
						interfaceHmap.put("ITEM_CODE", itemCode);
						interfaceHmap.put("DESCR", itemDescr);
						interfaceHmap.put("UNIT", unit);
						interfaceHmap.put("ITEM_TYPE", itemType);
						interfaceHmap.put("FAMILY_GRP", "");
						interfaceHmap.put("IN_OUT", "O");
						interfaceHmap.put("REF_SER", "S-ORD");
						interfaceHmap.put("REF_ID", tranId);
						interfaceHmap.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
						interfaceHmap.put("LOT_NO", lotNo);	
						interfaceHmap.put("LOT_SL", lotSl);
						interfaceHmap.put("QUANTITY", String.valueOf(notArt));
						interfaceHmap.put("QTY_PER_ART", String.valueOf(qtyPerArt));
						interfaceHmap.put("TOTAL_QTY", String.valueOf(quantity));
						interfaceHmap.put("EXP_DATE", "");	
						interfaceHmap.put("MFG_DATE", "");	
						interfaceHmap.put("PALLET_NO", palletNo);	
						interfaceHmap.put("MSG_STAT", "N");
						interfaceHmap.put("PALLET_STATUS", "");
						interfaceHmap.put("LOCK_STAT", "");
						interfaceHmap.put("ERR_COD", "");
						interfaceHmap.put("ERR_DESC", "");
						interfaceHmap.put("QC_TYPE", "");
						interfaceHmap.put("TRANS_DT_ACK", "");
						interfaceHmap.put("STRO_PREF", "");
						interfaceHmap.put("LINE_NO", lineNo);

						interfaceArrList.add(interfaceHmap);
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;

					if(flag == 0)
					{
						errString = itmDBAccessEJB.getErrorString("","RECNOTSORA","","",conn);
						return errString;
					}
					else
					{	
						commonWmsUtility.updateAwmsInterface(interfaceArrList,loginSite,conn);
					}	
				}
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTTSORNTCF","","",conn);
				return errString;
			}
		}
		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError="+isError);
				System.out.println("Flag="+flag);
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
					errString = itmDBAccessEJB.getErrorString("","VTCONPARM","","",conn);
				}
				if(pstmt != null){pstmt.close();pstmt=null;}
				if(interfacePstmt != null){interfacePstmt.close();interfacePstmt=null;}
				if(rs != null){rs.close();rs=null;}
			}
			catch(Exception e1)
			{
				throw new ITMException(e1);
			}
		}
		System.out.println("errString="+errString);
		return errString;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

	//Changed by wasim on 21-04-2016 to stock transfer for damage and hold items [START]
	public String palletRequestLock(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------Damage/Hold Stock Transfer out------------- : ["+tranId+"]");
		String retString = "";	
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		boolean isError = false;

		try
		{		
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			connDriver = null;
			retString = palletRequestLock(tranId,xtraParams,forcedFlag,conn);
		}
		catch(Exception e)
		{
			isError = true;
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
					retString = itmDBAccessEJB.getErrorString("","VTTNSVD","","",conn);
				}
				if(conn != null)
				{
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Final return="+retString);
		return retString;
	}

	public String palletRequestLock(String refId,String xtraParams,String forcedFlag,Connection conn) throws RemoteException,ITMException
	{
		System.out.println("==================In palletRequestDamageHold=======================");

		ResultSet rs = null,rsGen = null;
		PreparedStatement pstmt = null, interfacePstmt = null,pstmtHdr = null,pstmtDet = null,pstmtStock = null,pstmtUpdate = null,pstmtGen = null;	
		boolean isError = false,isRecordExist = false;
		String sql = "",errString = "",loginSiteCode = "",userId = "",chgTerm = "",tranID = "",sqlStock = "";
		String itemCode="",lotNo="",lotSl = "",locCode = "",siteCode = "",noArt = "",locCodeFrom = "",locCodeTo = "",
		lineNoInvHold = "",tranType = "",confirmed = "",sqlUpdate = "",refNo = "",palletNo = "",holdStatus = "",
		confReqDsp="";
		int updCnt = 0,lineNo = 0 ,reqcnt=0,holdDetCnt = 0;
		double quantity = 0,allocQty = 0,palletCnt = 0;
		ResultSet rsStock = null;
		//Changed by Jagruti Shinde Request Id:[W16CSUN008]
		confReqDsp = checkNullAndTrim(distComm.getDisparams("999999", "CONF_REQ", conn));
		System.out.println("CONF_REQ in disparm::::"+confReqDsp);
		PalletReqConf palletConf = new PalletReqConf();
		try
		{
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

			java.sql.Timestamp currDate = getCurrtDate();
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);

			sql = "SELECT CONFIRMED FROM INV_HOLD WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt=null;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}

			System.out.println("INV_HOLD_ID["+refId+"] CONFIRMED["+confirmed+"]");

			if("Y".equalsIgnoreCase(confirmed))
			{	
				sql = "SELECT REF_NO FROM INV_HOLD WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refId);
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					refNo = checkNullAndTrim(rs.getString("REF_NO"));
				}
				if(pstmt != null){pstmt.close();pstmt=null;}
				if(rs != null){rs.close();rs=null;}

				if(refNo != null && refNo.length() > 0)
				{
					//sql = "SELECT COUNT(*) FROM SWMS_TO_AWMS WHERE REF_ID = ?";
					sql = "SELECT REF_ID FROM SWMS_TO_AWMS WHERE REF_ID = ? AND REF_SER = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refNo);
					pstmt.setString(2, "PRS");
					rs = pstmt.executeQuery();

					if(rs.next())
					{
						System.out.println("Transaction is already present in interface2 table");
						errString = itmDBAccessEJB.getErrorString("","VTNOTEDIT","","",conn);  
						return errString;
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt=null;
					}
					if(rs != null)
					{
						rs.close();rs=null;
					}
				}

				tranID = commonWmsUtility.generateTranTd("w_pallet_req_stk", currDateStr, loginSiteCode, conn);

				sql = "INSERT INTO PALLET_REQ_DET (TRAN_ID,LINE_NO,PALLET_NO,LOC_CODE,STATUS,ITEM_CODE,LOT_NO,LOT_SL,QUANTITY,NO_ART) "
					+ "values (?,?,?,?,?,?,?,?,?,?)";
				pstmtDet = conn.prepareStatement(sql);

				sql = "INSERT INTO PALLET_REQ_HDR (TRAN_ID,TRAN_DATE,SITE_CODE,LOC_CODE,REMARKS,CONFIRMED,CONF_DATE,EMP_CODE__APRV,"//8
					+ "ADD_USER,ADD_DATE,ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TRAN_TYPE) "//15
					+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

				pstmtHdr = conn.prepareStatement(sql);
				pstmtHdr.setString( 1, tranID );
				pstmtHdr.setTimestamp( 2, currDate );
				pstmtHdr.setString( 3, loginSiteCode );
				pstmtHdr.setString( 4, locCode);
				pstmtHdr.setString( 5, "Pallet Out for Hold/Damage");
				pstmtHdr.setString( 6, "N" );
				pstmtHdr.setTimestamp( 7, currDate );
				pstmtHdr.setString( 8, "" );
				pstmtHdr.setString( 9, userId );
				pstmtHdr.setTimestamp( 10, currDate );
				pstmtHdr.setString( 11, chgTerm );
				pstmtHdr.setString( 12, userId );
				pstmtHdr.setTimestamp( 13, currDate );
				pstmtHdr.setString( 14, chgTerm );
				pstmtHdr.setString( 15, "O" );

				/*updCnt = pstmtHdr.executeUpdate();
					if(pstmtHdr != null){pstmtHdr.close();pstmtHdr=null;}*/

				sqlStock= " SELECT S.ITEM_CODE,S.LOC_CODE,S.SITE_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY,S.ALLOC_QTY,S.NO_ART,D.LINE_NO "
					+" FROM STOCK S, INV_HOLD H,INV_HOLD_DET D"
					+" WHERE S.QUANTITY > 0 " +
					"AND S.ITEM_CODE = D.ITEM_CODE " +
					/*"AND S.LOC_CODE = D. LOC_CODE " +
					"AND S.SITE_CODE = D. SITE_CODE " +
					"AND S.LOT_NO = D.LOT_NO " +
					"AND S.LOT_SL = D.LOT_SL " +
					"AND S.LOC_CODE = D.LOC_CODE" +*/
					//changed by azhar on 01-MAR-2017 to handle null data[START]
					"AND case when D.LOC_CODE is null then '*' else S.LOC_CODE end  = case when D.LOC_CODE is null then '*' else D.LOC_CODE end " +
					"AND case when D.SITE_CODE is null then '*' else S.SITE_CODE end  = case when D.SITE_CODE is null then '*' else D.SITE_CODE end " +
					"AND case when D.LOT_NO is null then '*' else S.LOT_NO end  = case when D.LOT_NO is null then '*' else D.LOT_NO end " +
					"AND case when D.LOT_SL is null then '*' else S.LOT_SL end  = case when D.LOT_SL is null then '*' else D.LOT_SL end " + 
					"AND case when D.LOC_CODE is null then '*' else S.LOC_CODE end  = case when D.LOC_CODE is null then '*' else D.LOC_CODE end " +
					//changed by azhar on 01-MAR-2017 to handle null data[END]
					" AND H.TRAN_ID = D.TRAN_ID AND H.TRAN_ID = ? " +
					"AND D.HOLD_STATUS != 'R' AND S.INV_STAT IN ('AWMS','AWMSQ') "; //Changed by Jagruti Shinde to request only pallet of inv_stat AWMS and AWMSQ Req id:[W16CSUN008] 
				pstmtStock = conn.prepareStatement(sqlStock);
				pstmtStock.setString(1, refId);
				rsStock = pstmtStock.executeQuery();

				while(rsStock.next())
				{
					System.out.println("holdDetCnt"+holdDetCnt);
					holdDetCnt++;
					
					itemCode = checkNullAndTrim(rsStock.getString("ITEM_CODE"));
					palletNo  = checkNullAndTrim(rsStock.getString("LOC_CODE"));
					siteCode  = rsStock.getString("SITE_CODE");
					lotNo  = rsStock.getString("LOT_NO");
					lotSl  = rsStock.getString("LOT_SL");
					quantity   = rsStock.getDouble("QUANTITY");
					allocQty  = rsStock.getDouble("ALLOC_QTY");
					noArt  = checkNullAndTrim(rsStock.getString("NO_ART"));
					//lineNoInvHold  = checkNullAndTrim(rsStock.getString("LINE_NO"));

					System.out.println("Pallet No After before suffix: "+palletNo);	
					palletNo = (palletNo.charAt(palletNo.trim().length()-1)=='Q') || (palletNo.charAt(palletNo.trim().length()-1)=='M') || 
					(palletNo.charAt(palletNo.trim().length()-1)=='S') || (palletNo.charAt(palletNo.trim().length()-1)=='B') ||
					(palletNo.charAt(palletNo.trim().length()-1)=='X') || (palletNo.charAt(palletNo.trim().length()-1)=='U') || 
					(palletNo.charAt(palletNo.trim().length()-1)=='P') || (palletNo.charAt(palletNo.trim().length()-1)=='R')  
					? palletNo.substring(0,palletNo.trim().length()-1):palletNo;
					System.out.println("Pallet No After removing suffix: "+palletNo);

					palletCnt = 0;
					sql = "SELECT FN_CHK_PR(TRIM(?),'') FROM DUAL";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, palletNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						palletCnt = rs.getInt(1);
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt=null;
					}
					if(rs != null)
					{
						rs.close();rs=null;
					}

					if(palletCnt > 0)
					{
						System.out.println("Pallet is already requested so not considering this pallet");
						System.out.println("reqcnt"+reqcnt);
						reqcnt++;
						continue;
					}

					lineNo++;
					pstmtDet.setString( 1, tranID );
					pstmtDet.setInt( 2, lineNo );
					pstmtDet.setString( 3, palletNo );
					pstmtDet.setString( 4, locCode );
					pstmtDet.setString( 5, "P" );
					pstmtDet.setString( 6, itemCode );
					pstmtDet.setString( 7, lotNo );
					pstmtDet.setString( 8, lotSl );
					pstmtDet.setDouble( 9, quantity );
					pstmtDet.setString( 10, noArt );

					pstmtDet.addBatch();
					isRecordExist = true;
					
				}
				if(isRecordExist)
				{	
					updCnt = pstmtHdr.executeUpdate();
					if(pstmtHdr != null)
					{
						pstmtHdr.close();pstmtHdr=null;
					}
					pstmtDet.executeBatch();
				}
				//Changed by Jagruti Shinde to request only pallet of inv_stat AWMS and AWMSQ Req id:[W16CSUN008][Start]
				else
				{
					if (holdDetCnt == 0)
					{	
						errString = itmDBAccessEJB.getErrorString("","VTPRNOTALW","","",conn);
						return errString;
					}
					else if(holdDetCnt == reqcnt)
					{
						errString = itmDBAccessEJB.getErrorString("","VTPALREQAL","","",conn);
						return errString;
					}
				}
				//Changed by Jagruti Shinde to request only pallet of inv_stat AWMS and AWMSQ Req id:[W16CSUN008][End]

				if(pstmtStock != null)
				{
					pstmtStock.close();pstmtStock=null;
				}
				if(rsStock != null)
				{
					rsStock.close();rsStock=null;
				}
				if(pstmtDet != null)
				{
					pstmtDet.close();pstmtDet=null;
				}

				System.out.println("isRecordExist="+isRecordExist);
				if(isRecordExist)
				{	
					//Changed by Jagruti Shinde Request Id:[W16CSUN008][Start]
					if("Y".equalsIgnoreCase(checkNullAndTrim(confReqDsp)))
					{
						errString = palletConf.confirm(tranID,xtraParams,forcedFlag,conn,false);
						System.out.println("String after confirm pallet request="+errString);
					}

					//if(errString != null &&  (errString.indexOf("VMTRANSACN") != -1))
					//{
					//Changed by Jagruti Shinde Request Id:[W16CSUN008][End]
					//sqlUpdate = "UPDATE INV_HOLD SET REF_NO = ?, REF_SER = ? WHERE TRAN_ID = ? "; //commented by azhar[01/MAR/2017]
					sqlUpdate = "UPDATE INV_HOLD SET REF_ID = ?, REF_SER = ? WHERE TRAN_ID = ? "; //changed by azhar[01/MAR/2017]
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, tranID);
					pstmtUpdate.setString(2, "PRS");
					pstmtUpdate.setString(3, refId);
					updCnt = pstmtUpdate.executeUpdate();
					System.out.println("Updated ="+updCnt);
					if(pstmtUpdate != null)
					{
						pstmtUpdate.close();pstmtUpdate=null;
					}
					//Changed by Jagruti Shinde Request Id:[W16CSUN008]
					//}
				}
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTTSORNTCF","","",conn);
				return errString;
			}	
		}
		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError="+isError);
				if(isError || !isRecordExist)
				{
					conn.rollback();
					errString = itmDBAccessEJB.getErrorString("","VTTNSVD","","",conn);
				}
				else
				{
					conn.commit();
					errString = itmDBAccessEJB.getErrorString("","VTCONPARM","","",conn);
				}
				if(pstmtStock != null)
				{
					pstmtStock.close();pstmtStock=null;
				}
				if(rsStock != null)
				{
					rsStock.close();rsStock=null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs != null)
				{
					rs.close();rs=null;
				}
				if(pstmtDet != null)
				{
					pstmtDet.close();pstmtDet=null;
				}
				if(pstmtHdr != null)
				{
					pstmtHdr.close();pstmtHdr=null;
				}
				if(pstmtUpdate != null)
				{
					pstmtUpdate.close();pstmtUpdate=null;
				}
			}
			catch(Exception e1)
			{
				throw new ITMException(e1);
			}
		}
		System.out.println("errString Return Stock Out="+errString);
		return errString;
	}
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	//Changed by wasim on 21-04-2016 to stock transfer for damage and hold items [START]
}
