CREATE TABLE  RELA_PARTY_HDR
(
TRAN_ID 		CHAR(10) NOT NULL,
TRAN_DATE		DATE,
SITE_CODE 		CHAR(5),
FIN_ENTITY 		CHAR(10) NOT NULL,
ACCT_PRD 		CHAR(6) NOT NULL,
PRD_CODE__FR 		CHAR(6) NOT NULL,
PRD_CODE__TO 		CHAR(6) NOT NULL,
CONTACT_CODE 		CHAR(10),
TRAN_TYPE 		VARCHAR2(20),
DESCR 			VARCHAR2(120),
REMARKS1 		VARCHAR2(120),
REMARKS2 		VARCHAR2(120),
REMARKS3 		VARCHAR2(120),
CONFIRMED		CHAR(1),
CONF_DATE		DATE,
ADD_DATE  		DATE,
ADD_USER  		VARCHAR2(10),
ADD_TERM  		VARCHAR2(15),
CHG_DATE  		DATE,
CHG_USER  		VARCHAR2(10),
chg_term  		varchar2(15)
);

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT RELA_PARTY_HDR_X PRIMARY KEY(TRAN_ID);

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT FK_RELA_PARTY_HDR_FIN_ENTITY FOREIGN KEY
(
  FIN_ENTITY  
)
REFERENCES FINENT
(
  fin_entity 
); 

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT FK_RELA_PARTY_HDR_SITE_CODE FOREIGN KEY
(
  site_code  
)
REFERENCES SITE
(
  site_code 
); 

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT FK_RELA_PARTY_HDR_ACCT_PRD FOREIGN KEY
(
  ACCT_PRD  
)
REFERENCES ACCTPRD
(
  code 
);  

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT FK_RELA_PARTY_HDR_PRD_CODE__FR FOREIGN KEY
(
  PRD_CODE__FR  
)
REFERENCES PERIOD
(
  code 
); 

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT FK_RELA_PARTY_HDR_PRD_CODE__TO FOREIGN KEY
(
  PRD_CODE__TO  
)
REFERENCES PERIOD
(
  code 
);

ALTER TABLE RELA_PARTY_HDR ADD CONSTRAINT FK_RELA_PARTY_HDR_CONTACT_CODE FOREIGN KEY
(
  CONTACT_CODE  
)
REFERENCES CONTACT
(
  contact_code 
);



CREATE TABLE RELA_PARTY_DET
(
TRAN_ID 		CHAR(10) NOT NULL,
LINE_NO 		CHAR(3) NOT NULL,
TRAN_CAT 		VARCHAR2(5),
MAX_AMT 		NUMBER(14,3),
ALERT_AMT_PERC 		NUMBER(14,3),
REMARKS 		VARCHAR2(120)
);
ALTER TABLE RELA_PARTY_DET ADD CONSTRAINT RELA_PARTY_DET_X PRIMARY KEY(TRAN_ID,LINE_NO);

ALTER TABLE RELA_PARTY_DET ADD CONSTRAINT FK_RELA_PARTY_DET FOREIGN KEY
(
  TRAN_ID  
)
REFERENCES RELA_PARTY_HDR
(
  tran_id 
) ;


ALTER TABLE RELA_PARTY_DET ADD CONSTRAINT FK_RELA_PARTY_DET_TRAN_CAT FOREIGN KEY
(
  TRAN_CAT  
)
REFERENCES TRANSACTION_CAT
(
  tran_cat 
) ;

 
INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,CONFIRM_COL,CONFIRM_VAL,TRAN_ID_COL,APPLICATION,TABLE_NAME,TABLE_DESC)
VALUES ('w_rela_party_def',
        '2',
        '2',
        'A',
        'seq10',
        sysdate,
        'base    ',
        'base  ',
        '0',
        'RPARTY',
        'F',
        '2',
        'M',
        'CONFIRMED',
        'Y',
        'TRAN_ID',
        'FIN',
        'RELA_PARTY_HDR',
        'RELATED PARTY DESC');
        
    
        
INSERT INTO obj_forms(WIN_NAME,TITLE,FORM_NO,ASSISTED_MODE,DEFAULT_VIEW)
VALUES ('w_rela_party_def',
        'Related Party',
        '1',
        'E',
        'A');
        
        
INSERT INTO obj_forms(WIN_NAME,TITLE,FORM_NO,ASSISTED_MODE,DEFAULT_VIEW)
VALUES ('w_rela_party_def',
        'Related Party detail',
        '2',
        'E',
        'A');

        
 
INSERT INTO obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
values ('rela_party_def',
        2,
        'edit.gif',
        'Editing Existing Record',
        'a',
        'a',
        'E',
        'Edit',
        '1',
        'S');


INSERT INTO obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
values ('rela_party_def',
        1,
        'add.gif',
        'Saving',
        'a',
        'a',
        'A',
        'Add',
        '1',
        'S');
        
INSERT INTO obj_actions(OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE)
VALUES ('rela_party_def',
        3,
        'menu.bmp',
        'View Audit Trail',
        'audit_trail',
        '1',
        'X',
        'View Audit',
        '1',
        '1',
        '1',
        'U');
        
        
        
INSERT INTO obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('rela_party_def',
        4,
        'confirm.gif',
        'Confirmation',
        'pre_confirm',
        'a',
        'F',
        'Confirm',
        '1',
        '2',
        'U');
        
   
        
        
INSERT INTO ITM2MENU (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,MENU_PATH,CHG_DATE,CHG_TERM,CHG_USER,OBJ_TYPE,ICON_PATH)
VALUES ('FIN',
        2,
        54,
        0,
        0,
        0,
        'w_rela_party_def',
        'Related Party Definition',
        'FIN.2.54.0.0.0',
        sysdate,
        'BASE',
        'BASE',
        'T',
        'e12_logo.gif');
        
        
INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '1',
        'site_code');


INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '1',
        'contact_code');


INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '1',
        'tran_type');


INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '2',
        'tran_cat');


INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '1',
        'acct_prd');

INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '1',
        'itm_default');
        
INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('rela_party_def',
        '1',
        'itm_defaultedit');
        
        
 
 

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('rela_party_def',
        'post_item_change',
        '1',
        'poic_default_ejb',
        '0',
         sysdate,
        'BASE      ',
        'BASE',
        '2',
        'EJB',
        'RelPartyDefIC');


INSERT INTO system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('rela_party_def',
        'pre_confirm',
        '1',
        'prcm_default_ejb',
        '0',
        sysdate,
        'BASE',
        'BASE',
        '2',
        'EJB',
        'RelPartyDefConf');


INSERT INTO system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('rela_party_def',
        'pre_validate',
        '1',
        'prv_default_ejb',
        '0',
        sysdate,
        'BASE',
        'BASE',
        '2',
        'EJB',
        'RelPartyDefIC');
        
        
      
        

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('SITE_CODE',
        'W_RELA_PARTY_DEF',
        'SELECT SITE_CODE, DESCR FROM SITE',
        'Site Codes',
        0,
        0,
        sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');
        
 
    
        
        
        
                
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('ACCT_PRD',
        'W_RELA_PARTY_DEF',
        'SELECT CODE, DESCR FROM ACCTPRD',
        'Acct Period Codes',
         0,
         0,
         sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');
        

        
        
        
        
                
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('CONTACT_CODE',
        'W_RELA_PARTY_DEF',
        'SELECT CONTACT_CODE, NAME FROM CONTACT WHERE CASE WHEN RELATED_PARTY IS NULL THEN ''N'' ELSE RELATED_PARTY END=''Y''',
        'Contacts Codes',
         0,
         0,
         sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');
        
        
              
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('TRAN_TYPE',
        'W_RELA_PARTY_DEF',
        'SELECT FLD_VALUE,DESCR FROM GENCODES WHERE FLD_NAME =''TRAN_TYPE''  AND MOD_NAME = ''W_RELA_PARTY_DEF''',
        'Trantype Codes',
         0,
         0,
         sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');
        
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('PRD_CODE__TO',
        'W_RELA_PARTY_DEF',
        'SELECT CODE, DESCR FROM PERIOD',
        'PERIOD CODE TO',
         0,
         0,
         sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('PRD_CODE__FR',
        'W_RELA_PARTY_DEF',
        'SELECT CODE, DESCR FROM PERIOD',
        'PERIOD CODE FROM',
         0,
         0,
         sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');        
        
INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,POP_ALIGN,HELP_OPTION)
VALUES ('TRAN_CAT',
        'W_RELA_PARTY_DEF',
        'SELECT TRAN_CAT, DESCR  FROM TRANSACTION_CAT',
        'TRAN CAT',
         0,
         0,
         sysdate,
        'BASE',
        'BASE',
        '0',
        'C',
        '0');      
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULSITCD',
        'Invalid Site Code!',
        'Site code cannot empty or null !',
        'E',
         sysdate,
        'BASE',
        'BASE');

        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULTRNDT',
        'Invalid Tran date',
        'Invalid Tran date cannot empty or null !',
        'E',
         sysdate,
        'BASE',
        'BASE');
   
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTNULPRDCD',
        'Invalid AccountPrd!',
        'Acct_prd cannot empty or null !',
        'E',
         sysdate,
        'BASE',
        'BASE');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMACTPRDCD',
        'Invalid AccountPrd!',
        'Account period code does not exist in Acctprd master',
        'E',
         sysdate,
        'BASE',
        'BASE');        
        
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULPRDFR',
        'Invalid PeriodCode!',
        'Period Code from cannot empty or null !',
        'E',
         sysdate,
        'BASE',
        'BASE');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMPRDFRCD',
        'Invalid PeriodCode!',
        'Period Code from does not exist in Period master, please enter valid  Period Code ',
        'E',
         sysdate,
        'BASE',
        'BASE');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULPRDTO',
        'Invalid Period Code!',
        'Period Code to cannot empty or null ! please enter the valid Period Code',
        'E',
         sysdate,
        'BASE',
        'BASE');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMPRDFRT0',
        'Invalid Period Code!',
        'Period Code to does not exist in Period master, please enter valid  Period Code ',
        'E',
         sysdate,
        'BASE',
        'BASE');
        
        

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULCONCD',
        'Invalid ContactCode!',
        'Contact cannot empty or null !please enter the valid Contact Code ',
        'E',
         sysdate,
        'BASE',
        'BASE');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VMCONTCD',
        'Invalid contactcode!',
        'Contact Code  does not exist in contact master, please enter valid  Contact Code',
        'E',
         sysdate,
        'BASE',
        'BASE');       
        
        

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULTRCAT',
        'Invalid trancategory!',
        'Tran Cat cannot empty or null ! please enter the valid Tran Cat  Code ',
        'E',
         sysdate,
        'BASE',
        'BASE');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMTRNCATCD',
        'Invalid trancat code!',
        'transaction category Code  does not exist in Transaction_cat  master, please enter valid  tran_cat Code',
        'E',
         sysdate,
        'BASE',
        'BASE');          
        
      
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VMSTATUSCD',
        'Invalid active status',
        'Invalid active status in  transaction category  master',
        'E',
         sysdate,
        'BASE',
        'BASE'); 
        
        
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTAMTPR',
        'Invalid Ammount !',
        'Maximum amount should be greater then Zero',
        'E',
         sysdate,
        'BASE',
        'BASE'); 
       
       
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTALTAMTPR',
        'Invalid alertamount',
        'Alert  amount % should be greater then zero and less then hundred',
        'E',
         sysdate,
        'BASE',
        'BASE'); 
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTPRDGRF0',
        'Invalid Period code',
        'Invalid Period code from ! Period Code from should be  less then  period code to  ',
        'E',
         sysdate,
        'BASE',
        'BASE');          
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTPRDGRT0',
        'Invalid Period code',
        'Invalid Period code to ! Period Code to should be  greter then  period code from ',
        'E',
         sysdate,
        'BASE',
        'BASE');    
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMTRNRPCNR',
        'Transaction Confirmed',
        'Transaction successfully confirmed',
        'P',
         sysdate,
        'BASE',
        'BASE');
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULTRNTP',
        'Invalid tran type!',
        'Tran type code cannot empty or null ! please enter valid tran type',
        'E',
         sysdate,
        'BASE',
        'BASE'); 
        
                
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMATRNTYPE',
        'Invalid tran type !',
        'Tran type code does not exist in master  ! please enter valid tran type ',
        'E',
         sysdate,
        'BASE',
        'BASE');
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('RPDCONFEMD',
        'Invalid transaction !',
        'Transaction allready confirmed !',
        'P',
         sysdate,
        'BASE',
        'BASE');
        
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTFUTRNDT',
        'Invalid  tran date !',
        'Tran date should not be greater then current date',
        'E',
         sysdate,
        'BASE',
        'BASE');     
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VTNULTRNID',
        'Invalid  tran Id !',
        'Tran Id cannot empty or null ',
        'E',
         sysdate,
        'BASE',
        'BASE');     
INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMTRNID',
        'Invalid tran Id !',
        'Tran Id already in exist',
        'E',
         sysdate,
        'BASE',
        'BASE'); 
        
INSERT INTO messages  (msg_no,  msg_str,  msg_descr,  msg_type,  msg_opt,  chg_date,  chg_user,  chg_term)
VALUES('VMSITECD  ',
    'Invalid SiteCode !',
    'Site code does not exsit in  site  master',
    'E',
    'Y',
    sysdate,
    'BASE',
    'BASE'
  );

        
insert into messages (msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term)
values ('VTDUPTRCAT',
        'Tran_cat Duplicate!',
        'Transaction Category code can not be dublicate .',
        'E',
         sysdate,
        'BASE',
        'BASE');      
        
        
insert into messages (msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term)
values ('VTTRANSACT',
        'Transaction accepted!',
        'Selected transaction already accepted. .',
        'E',
         sysdate,
        'BASE',
        'BASE');  
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        