package ibase.dashboard.pai.servlet;

import ibase.dashboard.pai.ejb.CrediteStatusSummaryRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class CrediteStatusSummaryServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		CrediteStatusSummaryRemote crediteStatusSummaryRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		HttpSession session = null;
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		UserInfoBean userInfo = null;
		String custCode=null;
		try
		{
			response.setContentType("application/xml");
			session = request.getSession(true);
			userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
			custCode = userInfo.getEntityCode();
			//custCode="CV0004";
			dataSourceName = request.getParameter("dataSourceName");
			System.out.println("custCode in CrediteStatusSummaryServlet =" + custCode);			
			context = new InitialContext(appConnectParm.getProperty());
			crediteStatusSummaryRemote = (CrediteStatusSummaryRemote) context.lookup("ibase/CrediteStatusSummary/remote");
		    jsonObjData = (JSONObject) crediteStatusSummaryRemote.getCrediteStatusSummaryServlet(dataSourceName,custCode);
			//String jsonObjData="{'0':{'refresh':'70'},'1':{'active',:'20'}}";
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for CrediteStatusSummaryServlet  build the Graph is==="+ jsonObjData);
		}
		catch (Exception e)
		{
			System.out.println("Exception : CrediteStatusSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :"+ e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
