/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class AdditionalPropertiesDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new AdditionalPropertiesDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private AdditionalPropertiesDigester() {
        super("additionalProperties", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode properties = FACTORY.arrayNode();
        ArrayNode patternProperties = FACTORY.arrayNode();
        ret.put(this.keyword, true);
        ret.put("properties", (JsonNode)properties);
        ret.put("patternProperties", (JsonNode)patternProperties);
        if (schema.get(this.keyword).asBoolean(true)) {
            return ret;
        }
        ret.put(this.keyword, false);
        ArrayList list = Lists.newArrayList((Iterator)schema.path("properties").fieldNames());
        Collections.sort(list);
        for (String s : list) {
            properties.add(s);
        }
        list = Lists.newArrayList((Iterator)schema.path("patternProperties").fieldNames());
        Collections.sort(list);
        for (String s : list) {
            patternProperties.add(s);
        }
        return ret;
    }
}

