/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMUploadFileRemote;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ITMUploadFileServlet
extends ITMAuthenticateServlet {
    private static File DUMP_DIR;
    private static File LOG_DUMP_DIR;
    private static Logger logger;
    private static int MAX_UPLOAD_SIZE;
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this.servletConfig = servletConfig;
            this.servletContext = servletConfig.getServletContext();
            if (CommonConstants.UPLOAD_LOC == null && CommonConstants.J2EE_VERSION.equals("1")) {
                System.out.println("UPLOAD_LOC is null");
                DUMP_DIR = new File(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent() + File.separator + "dump");
                LOG_DUMP_DIR = new File(DUMP_DIR.getParent() + File.separator + "logs");
            } else {
                DUMP_DIR = new File(new File(CommonConstants.UPLOAD_LOC) + File.separator + "dump");
                if (!DUMP_DIR.exists()) {
                    DUMP_DIR.mkdir();
                }
                if (!(LOG_DUMP_DIR = new File(new File(CommonConstants.UPLOAD_LOC) + File.separator + "logs")).exists()) {
                    LOG_DUMP_DIR.mkdir();
                }
            }
            CommonConstants.UPLOAD_LOC = DUMP_DIR.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = null;
        Object var5_5 = null;
        try {
            if (Boolean.valueOf(this.authenticate(httpServletRequest)).booleanValue()) {
                UserInfoBean userInfoBean = (UserInfoBean)httpServletRequest.getSession().getAttribute("USER_INFO");
                string = userInfoBean.getLoginCode();
                System.out.println("loginCode :[" + string + "]");
                if (logger != null) {
                    logger.shutdown();
                }
                logger = Logger.getRootLogger();
                FileAppender fileAppender = new FileAppender((Layout)new HTMLLayout(), LOG_DUMP_DIR + File.separator + "UploadLog" + string + ".html");
                logger.addAppender((Appender)fileAppender);
                String[] stringArray = this.loadFile(httpServletRequest, string);
                String string2 = stringArray[1];
                System.out.println("fileName :[" + string2 + "]");
                Object var10_13 = null;
                Object var11_14 = null;
                boolean bl = stringArray[0] == null ? false : Boolean.valueOf(stringArray[0]);
                InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
                ITMUploadFileRemote iTMUploadFileRemote = (ITMUploadFileRemote)initialContext.lookup("ibase/ITMUploadFileEJB/remote");
                String string3 = iTMUploadFileRemote.insertFileData(stringArray, userInfoBean, DUMP_DIR, CommonConstants.APPLICATION_CONTEXT);
                httpServletRequest.getSession().setAttribute("responseString", (Object)string3);
                RequestDispatcher requestDispatcher = this.servletContext.getRequestDispatcher("/webitm/jsp/DownloadFile.jsp");
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        catch (ITMException iTMException) {
            iTMException.printStackTrace();
            System.out.println("[" + string + "]ITMException :WriteFileServlet :doPost :==>ITMException");
            this.parseException((Exception)((Object)iTMException), printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("[" + string + "]Exception :WriteFileServlet :doPost :==>IOException");
            System.out.println("Error reading or saving file");
            this.parseException(iOException, printWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("[" + string + "]Exception :WriteFileServlet :doPost :==>Exception");
            this.parseException(exception, printWriter);
        }
    }

    private String[] loadFile(HttpServletRequest httpServletRequest, String string) throws Exception {
        String string2 = null;
        String[] stringArray = new String[4];
        try {
            Part part;
            this.servletContext.log("[" + string + "]Uploading file......");
            MultipartParser multipartParser = new MultipartParser(httpServletRequest, MAX_UPLOAD_SIZE);
            while ((part = multipartParser.readNextPart()) != null) {
                String string3;
                ParamPart paramPart;
                String string4 = part.getName();
                if (part.isParam()) {
                    paramPart = (ParamPart)part;
                    string3 = paramPart.getStringValue();
                    if (part.getName().trim().equals("IS_INTERACTIVE")) {
                        stringArray[0] = string3;
                        continue;
                    }
                    if (!part.getName().trim().equals("OBJ_NAME")) continue;
                    stringArray[2] = string3;
                    continue;
                }
                if (!part.isFile()) continue;
                paramPart = (FilePart)part;
                string3 = paramPart.getFileName();
                string2 = System.currentTimeMillis() + "_" + string + "_" + string3;
                if ("filefieldXSL".equals(part.getName())) {
                    stringArray[3] = string3;
                } else {
                    stringArray[1] = string2;
                }
                long l = paramPart.writeTo(DUMP_DIR);
                File file = new File(DUMP_DIR + File.separator + string3);
                if (!file.exists()) continue;
                file.renameTo(new File(DUMP_DIR + File.separator + string2));
            }
            this.servletContext.log("[" + string + "]File uploaded");
        }
        catch (IOException iOException) {
            this.servletContext.log("[" + string + "]Exception :ITMUploadFileServlet :loadFile :==>IOException");
            throw iOException;
        }
        catch (Exception exception) {
            this.servletContext.log("[" + string + "]Exception :ITMUploadFileServlet :loadFile :==>Exception");
            throw exception;
        }
        return stringArray;
    }

    private void parseException(Exception exception, PrintWriter printWriter) {
        String string;
        String string2;
        String string3;
        String string4;
        block6: {
            string4 = "";
            string3 = "";
            string2 = "";
            string = "";
            String string5 = "";
            try {
                string5 = exception.getMessage();
                System.out.println("[ITMUploadFileServlet]Exception Message :==>\n" + string5);
                if (string5.equals("")) break block6;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string5.getBytes());
                Document document = documentBuilder.parse(byteArrayInputStream);
                NodeList nodeList = document.getElementsByTagName("Error");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    NodeList nodeList2 = nodeList.item(i).getChildNodes();
                    string4 = nodeList2.item(0).getFirstChild().getNodeValue();
                    try {
                        FileWriter fileWriter = new FileWriter("four.prn");
                        fileWriter.write(string4);
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (Exception exception2) {
                        System.out.println("Error in IMException-getMessage");
                    }
                    string3 = nodeList2.item(1).getFirstChild().getNodeValue();
                    string2 = nodeList2.item(2).getFirstChild().getNodeValue();
                    int n = 0;
                    while (string2.indexOf(10) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        int n2 = stringBuffer.toString().indexOf(10);
                        stringBuffer.replace(n2, n2 + 1, "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        string2 = stringBuffer.toString();
                        stringBuffer = null;
                        ++n;
                    }
                    string = nodeList2.item(3).getFirstChild().getNodeValue();
                }
            }
            catch (Exception exception3) {
                string3 = string5;
                exception3.printStackTrace();
            }
        }
        printWriter.println("<HTML><BODY BGCOLOR='#EEEEEE'>");
        printWriter.println("<b>Message :</b>" + string4);
        printWriter.println("<br>");
        printWriter.println("<b>Description : </b>" + string3);
        printWriter.println("<br>");
        printWriter.println("<b>Trace : </b>" + string2);
        printWriter.println("<br>");
        printWriter.println("<b>Redirect : </b>" + string);
        printWriter.println("</BODY></HTML>");
    }

    static {
        logger = null;
        MAX_UPLOAD_SIZE = 0xA00000;
    }
}

