/********************************************************
	Title : CustStockGWTConf[D15ESUN013]
	Date  : 27/10/15
	Developer: Chandrashekar

 ********************************************************/
package ibase.webitm.ejb.dis.adv;

import java.rmi.RemoteException;


import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.*;
import java.sql.*;
import java.text.SimpleDateFormat;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

import java.util.Calendar;

@Stateless
public class CustStockGWTConf extends ActionHandlerEJB implements CustStockGWTConfLocal, CustStockGWTConfRemote
{

	public String submit(String tranId, String xtraParams, String forcedFlag)throws RemoteException, ITMException
	{
		System.out.println(">>>>>>>>>>>>>>>>>>CustStockGWTConf submit called>>>>>>>>>>>>>>>>>>>");
		String sql = "",status="",confirmed="";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try
		{

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 09-06-2016 :START
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changes and Commented By Bhushan on 09-06-2016 :END 
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0)
			{
				System.out.println("tranId>>>["+tranId+"]");
				sql = "	select status,confirmed from  cust_stock where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					status = rs.getString("status");
					confirmed = rs.getString("confirmed");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("status>>>>>>>>"+status);
				if(!"Y".equalsIgnoreCase(confirmed) && !"S".equalsIgnoreCase(status))
				{
					methodName = "gbf_post";
					actionURI = "http://NvoServiceurl.org/" + methodName;

					sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = 'cust_stock' AND EVENT_CODE = 'pre_confirm' ";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						serviceCode = rs.getString("SERVICE_CODE");
						compName = rs.getString("COMP_NAME");
					}
					System.out.println(">>>cust stock confirmation serviceCode = " + serviceCode + " compName " + compName);
					// Changed by Manish on 01/04/16 for max cursor issue [start]
					if (pstmt != null)
					{
						pstmt.close();
						pstmt=null;
					}
					if (rs !=null)
					{
						rs.close();
						rs=null;
					}
					// Changed by Manish on 01/04/16 for max cursor issue [end]
					sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, serviceCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						serviceURI = rs.getString("SERVICE_URI");
					}
					System.out.println(">>>cust stock confirmation serviceURI = " + serviceURI + " compName = " + compName);
					// Changed by Manish on 01/04/16 for max cursor issue [start]
					if (pstmt != null)
					{
						pstmt.close();
						pstmt=null;
					}
					if (rs !=null)
					{
						rs.close();
						rs=null;
					}
					// Changed by Manish on 01/04/16 for max cursor issue [end]
					Service service = new Service();
					Call call = (Call) service.createCall();
					call.setTargetEndpointAddress(new java.net.URL(serviceURI));
					call.setOperationName(new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName));
					call.setUseSOAPAction(true);
					call.setSOAPActionURI(actionURI);
					Object[] aobj = new Object[4];

					call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
					call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
					call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
					call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

					aobj[0] = new String(compName);
					aobj[1] = new String(tranId);
					aobj[2] = new String(xtraParams);
					aobj[3] = new String(forcedFlag);

					System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
					call.setReturnType(XMLType.XSD_STRING);
					errString = (String) call.invoke(aobj);

					System.out.println(">>>>Confirm Complete Return string from NVO is:==>[" + errString + "]");
					if((errString != null ) && (errString.indexOf("VTSUCC1") > -1))
					{
						sql = " update cust_stock set status = 'S' where tran_id = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranId);
						cnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
						if (cnt > 0)
						{
							errString = itmDBAccessLocal.getErrorString("", "VTSUBM1", "");
							conn.commit();

						}
					}
				}else
				{
					errString = itmDBAccessLocal.getErrorString("", "VTINVSUB2", "");
				}
				}
			
			//}

			// end if errstrng
		} catch (Exception e)
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e)
			{
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;

	}
	public String open(String tranId, String xtraParams, String forcedFlag)throws RemoteException, ITMException
	{
		System.out.println(">>>>>>>>>>>>>>>>>>CustStockGWTConf open called>>>>>>>>>>>>>>>>>>>");
		String sql = "",status="",confirmed="";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try
		{

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 09-06-2016 :START
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changes and Commented By Bhushan on 09-06-2016 :END 
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0)
			{
				System.out.println("tranId>>>[" + tranId + "]");
				sql = "	select status from  cust_stock where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					status = rs.getString("status");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("status>>>>>>>>"+status);
				if ("S".equalsIgnoreCase(status))
				{

					sql = " update cust_stock set status = 'O',confirmed='N',conf_date='' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					cnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					if (cnt > 0)
					{
						errString = itmDBAccessLocal.getErrorString("", "VTSTAOPEN", "");
						conn.commit();

					}
				}else 
				{
					errString =  itmDBAccessLocal.getErrorString("","VTNOTOPEN","");
				}

			}
			
			// end if errstrng
		} catch (Exception e)
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e)
			{
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;

	}

}