/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import ibase.e12ria.client.E12CollabDataWrapper;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.I18nConstants;
import java.util.HashMap;

public class E12CollabFeedGen {
    private final I18nConstants constants = (I18nConstants)GWT.create(I18nConstants.class);
    static HashMap<String, E12CollabDataWrapper> wraperColabHM = new HashMap();

    public void getTree(Object callBackPanel, final Callback<HashMap<String, E12CollabDataWrapper>, Throwable> callBack) {
        try {
            wraperColabHM.clear();
            String path = "";
            String hostUrl = "";
            path = String.valueOf(hostUrl) + "/ibase/CollabGetGroupsServlet";
            RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, path);
            try {
                requestBuilder.sendRequest(null, new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        Window.alert((String)E12Constants.constants.setErrMsgAlt());
                    }

                    public void onResponseReceived(Request request, Response response) {
                        if (E12Global.getInstance().checkErrorException(response, 1)) {
                            final String xmlString = response.getText();
                            GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

                                public void onSuccess() {
                                    E12CollabFeedGen.this.getColabFeedGenData(xmlString);
                                    if (callBack != null) {
                                        callBack.onSuccess(wraperColabHM);
                                    }
                                }

                                public void onFailure(Throwable reason) {
                                    if (callBack != null) {
                                        callBack.onFailure((Object)reason);
                                    }
                                    Window.alert((String)("Error :: " + reason.getMessage()));
                                }
                            });
                        }
                    }
                });
            }
            catch (RequestException ex) {
                Window.alert((String)("RequestException" + ex.getMessage() + "]"));
                System.out.println("RequestException : " + ex.getMessage());
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception:getTree" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void getColabFeedGenData(String xmlString) {
        try {
            Document document = XMLParser.parse((String)xmlString);
            NodeList groupNodeList = document.getElementsByTagName("GROUP");
            if (groupNodeList != null) {
                int groupLen = groupNodeList.getLength();
                int groupCntr = 0;
                while (groupCntr < groupLen) {
                    E12CollabDataWrapper e12ColabDataWrapper = new E12CollabDataWrapper();
                    Node groupNode = groupNodeList.item(groupCntr);
                    NodeList groupChildNodeList = groupNode.getChildNodes();
                    int groupChildLen = groupChildNodeList.getLength();
                    String groupId = groupNode.getAttributes().getNamedItem("id").getNodeValue();
                    e12ColabDataWrapper.setGroupId(groupId);
                    int groupChildCntr = 0;
                    while (groupChildCntr < groupChildLen) {
                        Node groupChildNode = groupChildNodeList.item(groupChildCntr);
                        if ("NAME".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String groupName = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setGroupName(groupName);
                        } else if ("DESCR".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String groupDescr = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setGroupDescr(groupDescr);
                        } else if ("IMAGE".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String groupImage = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setGroupImage(groupImage);
                        } else if ("OWNER".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String groupOwner = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setGroupOwner(groupOwner);
                        } else if ("IS_AUTO_DOWNLOAD".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String isAutoDownload = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setIsAutoDownload(isAutoDownload);
                        } else if ("ATTACH_MANDATORY".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String isAttachMandatory = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setIsAttachMandatory(isAttachMandatory);
                        } else if ("POST_ALLOW_TO".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String postAllowTo = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setPostAllowTo(postAllowTo);
                        } else if ("MODERATOR".equalsIgnoreCase(groupChildNode.getNodeName())) {
                            String groupModerator = groupChildNode.getFirstChild().getNodeValue();
                            e12ColabDataWrapper.setGroupModerator(groupModerator);
                        }
                        ++groupChildCntr;
                    }
                    wraperColabHM.put(groupId, e12ColabDataWrapper);
                    ++groupCntr;
                }
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception : E12ColabFeedGen : getColabFeedGenData() :" + e.getMessage()));
        }
    }
}

