/**
 *  Purpose: to reset password for all the users, Reuest ID: S16EBAS030  
 *  Author: Sneha Mestry
 *  Date: 31-08-2016
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.EMail;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import javax.ejb.Stateless;

@Stateless
public class ResetPasswordEJB extends ValidatorEJB implements ResetPasswordEJBLocal, ResetPasswordEJBRemote
{
	public ResetPasswordEJB()
	{
		
	}
	GenericUtility genericUtility = GenericUtility.getInstance();
	
	public boolean validateUser(String userCode, String password, String passwordStr, String firstLogin)
	{
		System.out.println(" **** Inside validateUser ****** ");
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		boolean isValidate = false;
		int count = 0;
		boolean isError = false;
		ArrayList<String> mailInfo = new ArrayList<String>();
		
		try
		{
			conn = getConnection();
			conn.setAutoCommit(false);

			sql = "SELECT CODE, EMAIL_ID FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, userCode);
			rs = pstmt.executeQuery();
			isValidate = rs.next();

			if (isValidate) 
			{ 
				mailInfo.add(rs.getString("EMAIL_ID"));
				mailInfo.add("Your New Password For User Id: " + userCode);
				mailInfo.add("Your password was reset successfully. Your new password is: " + passwordStr);

				sql = "UPDATE USERS SET PASS_WD_SHA = ?, LOGIN_FIRST = ?, ACCT_LOCK = ? WHERE CODE = ? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, password);
				pstmt1.setString(2, firstLogin);
				pstmt1.setString(3, "N");
				pstmt1.setString(4, userCode);
				count = pstmt1.executeUpdate();
				//System.out.println("count ========>> "+count);
				
				if (count != 0)
				{
					
					sendMail(mailInfo);
					isValidate = true;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			else if(!isValidate)
			{
				System.out.println(" ***** User not found. Enter Valid User Code *****");
				isValidate = false;
			}
			
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e)
		{ 
			isError = true;
			e.printStackTrace();
		} 
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Log In failed: An Exception has occurred! In :validateUser() : " + d.getMessage());
			}
		}
		
		return isValidate;
	}

	public void sendMail(ArrayList<String> mailInfo)
	{
		EMail email = new EMail();
		StringBuffer commInfo = new StringBuffer();
		try
		{
			/*System.out.println("mailInfo.get(0)=======>>"+mailInfo.get(0));
			System.out.println("mailInfo.get(1)=======>>"+mailInfo.get(1));
			System.out.println("mailInfo.get(2)=======>>"+mailInfo.get(2));*/
			
			commInfo.append("<ROOT>");
			commInfo.append("<MAILINFO>");
			commInfo.append("<EMAIL_TYPE>").append("page").append("</EMAIL_TYPE>");
			commInfo.append("<TO_ADD>").append("<![CDATA[" + mailInfo.get(0) + "]]>").append("</TO_ADD>");
			commInfo.append("<SUBJECT>").append("<![CDATA[" + mailInfo.get(1) + "]]>").append("</SUBJECT>");
			commInfo.append("<BODY_TEXT>").append("<![CDATA[" +mailInfo.get(2) + "]]>").append("</BODY_TEXT>");
			commInfo.append("</MAILINFO>");
			commInfo.append("</ROOT>");
			
			System.out.println(" calling sendMail method() form for Reset Password. ");
			email.sendMail(commInfo.toString(), "ITM", null);
			System.out.println(" ******** Email send succesfully for Reset Password. ***********");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : sendMail  " + e.getMessage());
		}
		finally
		{
			System.out.println("in Finally block for sendMail ");
		}
		email = null;
	}
}
