
ALTER TABLE SPL_SALES_POR_HDR ADD REMARKS VARCHAR2(120);

ALTER TABLE SPL_SALES_POR_HDR MODIFY CUST_CODE__SOLTO CHAR(10);

COMMIT;

Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('proof_of_delivery','1  ','cust_code__solto','Y');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME) 
VALUES ('CUSTOMER_CUST_CODE','W_PROOF_OF_DELIVERY','SELECT CUST_CODE,CUST_NAME FROM CUSTOMER',NULL,
'Customer Code',0,0,SYSDATE,'BASE','BASE',
null,null,null,null,null,null,null,null,null,null,'1',null);

INSERT INTO DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('999999','PROOF_OF_DELIVERY','N','10','Stockiest Margin of products to approve rate of Sales for Stockiest',NULL,SYSDATE,'BASE','SANKET');

INSERT INTO DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('999999','POD_PRD_DATE','D','01-NOV-14','POD Process activate w.e.f. 01-11-14',NULL,SYSDATE,'BASE','SANKET');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTREJNOTAB','Rejection Remark Is Blank','Reject Remark should Not be blank. When Status is Reject.','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTREJNOTAC','Rejection Remark Should Blank','Reject Remark should be blank. When Status is Not Reject.','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);

CREATE OR REPLACE FUNCTION DDF_GET_BALQTY_POD(TRAN_ID_1 varCHAR2 ,LINE_NO_1 number)
RETURN NUMBER IS
BAL_QTY NUMBER(14,3);
   BEGIN
     BAL_QTY := 0;
       SELECT (SPL_SALES_POR_DET.PEND_QTY - SPL_SALES_POR_DET.QUANTITY__RESALE) INTO BAL_QTY
       FROM SPL_SALES_POR_DET WHERE SPL_SALES_POR_DET.TRAN_ID= TRAN_ID_1 AND SPL_SALES_POR_DET.LINE_NO= LINE_NO_1;
     RETURN BAL_QTY;
END;

INSERT INTO TRANSETUP (	TRAN_WINDOW,SAVE_FLAG ,	VAL_FLAG ,	KEY_FLAG ,	KEY_STRING ,	REPEATE_ADD ,	CHG_DATE ,	CHG_USER ,	CHG_TERM ,	EDI_OPTION ,	WORKFLOW_OPT 	)
VALUES ('w_pod_process','2','2','A','seq10','Y',SYSDATE,'SANKET','SANKET ','0','2');

COMMIT;

create table spl_sales_por_hdr (
tran_id Char(10), 
tran_date Date NOT NULL,
invoice_id  Char(10) NOT NULL,
site_code Char(5) NOT NULL,
cust_code Char(10) NOT NULL,
curr_code Char(5),
exch_rate Number(14,6),
amount	number(14,3),
tran_id__drn char(10),
confirmed char(1),
conf_date date ,
emp_code__aprv char(10),
wf_status  char(1),
chg_date date NOT NULL,
chg_user char(10) NOT NULL,
CHG_TERM CHAR(15) NOT NULL
);
SELECT DDF_GET_BALQTY_POD('1000',1) FROM DUAL;


ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT spl_sales_por_hdr_X PRIMARY KEY (TRAN_ID) USING INDEX; TABLESPACE ITM_DIS_I1;

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_I FOREIGN KEY (INVOICE_ID) REFERENCES invoice (INVOICE_ID);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_S FOREIGN KEY (SITE_CODE) REFERENCES site (SITE_CODE);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_C FOREIGN KEY (CUST_CODE) REFERENCES customer (CUST_CODE);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_U FOREIGN KEY (CURR_CODE) REFERENCES currency (CURR_CODE);

ALTER TABLE spl_sales_por_hdr ADD CONSTRAINT FK_spl_sales_por_hdr_E FOREIGN KEY (EMP_CODE__APRV) REFERENCES employee (EMP_CODE);

create table spl_sales_por_det (
tran_id Char(10) not null,
line_no Number(3) NOT NULL,
line_no__trace Number(3) NOT NULL,
item_code Char(10) NOT NULL,
loc_code Char(8),
lot_no Char(15),
lot_sl Char(15),
bill_no Varchar2(40),
bil_date Date,
rate__inv  number(15,4),
rate__resale number(15,4),
quantity__inv number(14,3),
quantity__resale number(14,3),
AMOUNT NUMBER(14,3)
);

ALTER TABLE spl_sales_por_det ADD CONSTRAINT spl_sales_por_det_X PRIMARY KEY (TRAN_ID,LINE_NO) USING INDEX; TABLESPACE ITM_DIS_I1;

ALTER TABLE spl_sales_por_det ADD CONSTRAINT FK_spl_sales_por_det FOREIGN KEY (TRAN_ID) REFERENCES spl_sales_por_hdr (TRAN_ID) ON DELETE CASCADE;
ALTER TABLE spl_sales_por_det ADD CONSTRAINT FK_spl_sales_por_det_I FOREIGN KEY (ITEM_CODE) REFERENCES item (ITEM_CODE) ;
ALTER TABLE SPL_SALES_POR_DET ADD CONSTRAINT FK_SPL_SALES_POR_DET_L FOREIGN KEY (LOC_CODE) REFERENCES LOCATION (LOC_CODE) ;

alter table spl_sales_por_det add remarks varchar2(100);
alter table spl_sales_por_det add transit_day number(3);
alter table spl_sales_por_hdr add debit_note_amt number(14,3);
alter table spl_sales_por_det add debit_note_amt number(14,3);

ALTER TABLE SPL_SALES_POR_DET ADD APRV_RATE NUMBER(15,4);

alter table SPL_SALES_POR_hdr DROP COLUMN CUST_CODE__SOLTO;

INSERT INTO ITM2MENU(APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,CLOSE_ICON,
OPEN_ICON,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER,MOB_DEPLOY)
VALUES ('DIS',3,9,45,0,0,'w_pod_rej_remark','POD Rejection Remark','POD Rejection Remark','DIS.3.9.45.0.0',
'e12_logo.gif',NULL,NULL,'P',SYSDATE,'SANKET','SANKET',NULL);

INSERT INTO OBJ_FORMS(WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,FORM_NO)
VALUES ('w_pod_rej_remark','Header','pod_rej_remark11','w_pod_rej_remark11','1');

Insert into  obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,
PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER) 
values ('pod_rej_remark',1,null,'Reject','PODRejRemark','a','R','Reject','1','3',null,'U',null,sysdate,'SANKET','SANKET');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT)
values ('pod_rej_remark','process','1','PODRejRemark',null,'0',sysdate,'SANKET','SANKET','2','EJB','PODRejectionRemark',null);

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,RETURN_XFRM_XSL,CHG_DATE,CHG_USER,CHG_TERM)
values ('PODRejRemark','process','http://172.16.145.69/BaseE12DotNetService6-3-2-48/E12BusinessLogic6-3-2-017.asmx','SANKET','process','String','S',null,null, EMPTY_BLOB(),sysdate,'SANKET','SANKET');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('PODRejRemark',1,'COMPONENT_TYPE','I',NULL,'C.String',NULL,SYSDATE,'BASE','BASE','EJB');
 
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('PODRejRemark',2,'COMPONENT_NAME','I',NULL,'C.String',NULL,SYSDATE,'BASE','BASE','PODRejectionRemark');
 
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('PODRejRemark',3,'XML_DATA_1','l',NULL,'S',NULL,SYSDATE,'BASE','BASE',NULL);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('PODRejRemark',4,'XML_DATA__ALL','l',NULL,'S',NULL,SYSDATE,'BASE','BASE',NULL);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
 VALUES ('PODRejRemark',5,'OBJ_CONTEXT','l',NULL,'S',NULL,SYSDATE,'BASE','BASE',NULL);
 
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('PODRejRemark',6,'XTRA_PARAMS','l',NULL,'S',NULL,SYSDATE,'BASE','BASE',NULL);

COMMIT;

INSERT INTO OBJ_LINKS (OBJ_NAME,FORM_NO,FIELD_NAME,TARGET_OBJ_NAME,LINK_FORM_NAME,LINK_TITLE,
LINK_URI,LINK_TYPE,LINK_ARG,UPDATE_FLAG,LINK_NAME,RIGHTS_CHAR,IMAGE)
VALUES ('proof_of_delivery','1','tran_id','pod_rej_remark','pod_rej_remark11',
'Insert Remark',NULL,'6','tran_id.String,wf_status.String','0',null,'T',NULL);

INSERT INTO USER_RIGHTS (PROFILE_ID,APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,LEVEL_4,LEVEL_5,MENU_NAME,RIGHTS,
ACC_FILT,DEF_FILT,OBJ_NAME,FAV_OPTION,FAV_ORDER,EXCLUDE_RIGHTS_CHAR)
VALUES ('BASE','DIS',4,19,10,0,0,'Proof Of Delivery','V',NULL,NULL,'pod_rej_remark',NULL,NULL,NULL);

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) VALUES ('pod_rej_remark','1','tran_id','Y');
INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) VALUES ('pod_rej_remark','1','wf_status','Y');
INSERT INTO TRANSETUP (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,REPEATADDDET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,CUST_ACC_COL,SALES_PERS_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_CODE,EMP_ACC_COL,ITEM_SER_ACC_COL,WORKFLOW_OPT,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,TRAN_ID__FROM,TRAN_ID__TO,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,MULTITIRE_OPT,REF_SER,VIEW_MODE,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,IGNOREERRLIST_ONLOAD,CHILDDATA_ARGOPT,EDIT_TMPLT,WRKFLW_INIT,EDITTAX,FORMAL_ARGS,AUDIT_TRAIL_OPT,EDIT_OPT,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,RATE_COL,QTY_COL,EDIT_EXPR_INP,RCP_CACHE_STATUS,PRINT_CONTROL,TRANSFER_MODE,PROFILE_ID__RES,TRAN_COMPL_MSG,PERIOD_OPTION,WRKFLW_PRIORITY,EXEC_TYPE,DISP_META_DATA,ALLOW_ATTACH,START_FORM,ISATTACHMENT,HEADER_FORM_NO,MSG_ONSAVE,WF_STATUS)
VALUES ('w_pod_rej_remark','2','2','A','seq10',NULL,NULL,NULL,NULL,NULL,NULL,SYSDATE,'BASE','BASE111','0',NULL,NULL,NULL,'N',NULL,NULL,NULL,'N',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'DMD','F',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'M',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

Insert into  OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pod_rej_remark','1  ','itm_defaultedit','Y');
INSERT INTO  (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) VALUES ('proof_of_delivery','2  ','itm_default','Y');


INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) VALUES ('pod_rej_remark','post_item_change','1','poic_default_ejb',NULL,'0',TO_TIMESTAMP('10-JUL-15','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE','1','EJB','ProofOfDelivery',NULL);

-------------------------- MESSAGES---------------------------

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTSTANUL ','Status is Null','Status Cannot be Null!','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTSTANUL ','Status is Null','Status Cannot be Null!','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTREJNOTAC','Rejection Remark Should be Blank','Reject Remark should be blank. When Status is Not Reject.','E',NULL,NULL,NULL,NULL,SYSDATE,'SANKET','SANKET',NULL,NULL);

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
VALUES ('VTSTAUPTD','Remark Updated!','Rejection Remark Updated successfully','P','Y',NULL,NULL,NULL,sysdate,'SANKET','SANKET',NULL,NULL);

COMMIT;






