package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.LiveEventDetailsRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;

public class ParticipentEventSummaryServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		LiveEventDetailsRemote liveEventDetailsRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName  = "";
		String eventCode       = "";
		String rowsValue       = "";
		
		try
		{
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName");
			eventCode = request.getParameter("survey_templ");
			rowsValue = request.getParameter("P1").trim();
			String []outputDateArray = rowsValue.split(" ");
			/*if(outputDateArray.length>1)
			{
				eventCode  = outputDateArray[0];
								
			}*/
			System.out.println("Final data set eventCode in ParticipentEventSummaryServlet  ==== "+eventCode);
			
			context = new InitialContext(appConnectParm.getProperty());
			liveEventDetailsRemote      = (LiveEventDetailsRemote) context.lookup("ibase/LiveEventDetails/remote");
			JSONObject jsonObjData      = (JSONObject) liveEventDetailsRemote.getParticipentEventSummary(dataSourceName,eventCode);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ParticipentEventSummaryServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ParticipentEventSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}