package ibase.e12ria.dcdet.client;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.E12Global.E12Storage;
import ibase.e12ria.client.E12RequestBuilder;
import ibase.e12ria.client.E12RequestBuilder.RequestDataKeys;
import ibase.e12ria.client.PlayVideo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
/**
 * This class is draw brands and return the widget
 * 
 * @author Dnyaneshwar
 * */
public class Brands extends Composite
{///
	
	//Changed By Mahesh Patidar on 05/10/12
//	private HashMap<String, String> playFilesHM = new HashMap<String, String>();
	protected VerticalPanel parentVerticalPanel = new VerticalPanel();
	//protected Hidden mediaFiles=new Hidden();
	protected Panel outerDiv = new SimplePanel();
	protected Panel innerDiv = new SimplePanel();
	
	/** TextBox for search value */
	protected TextBox searchTextBox;
	
	PlayVideo objPlayVideo = new PlayVideo();
	
	
	int noOfBrands = 0;
	public  Brands()
	{
		searchTextBox = new TextBox();
		searchTextBox.addKeyUpHandler( new KeyUpHandler()
		{
			@Override
			public void onKeyUp(KeyUpEvent event)
			{
				showBrandsTextBoxEmpty();
			}
		});
		
		searchTextBox.addKeyPressHandler( new KeyPressHandler() 
		{
			@Override
			public void onKeyPress(KeyPressEvent event) 
			{
				searchValue( event );
			}
		});
		
		searchTextBox.setStyleName( "searchboxinput" );
		innerDiv.setStyleName( "searchboxform" );
		outerDiv.setStyleName( "searchbox" );
		
		innerDiv.add( searchTextBox );
		outerDiv.add( innerDiv );
		
		parentVerticalPanel.setWidth( "100%" );
		
		
		
		
	//	final String url = MELogin.hostUrl +"/ibase/BrandsServlet";
		final String url = E12Global.getHostUrl() +"/ibase/BrandsServlet";
		
		HashMap<String, String> requestDataMap = new HashMap<String, String>();
		requestDataMap.put( RequestDataKeys.LOCAL_STORAGE_KEY, E12Constants.userID + "/ibase/BrandsServlet" );
		
		E12RequestBuilder requestBuilder = new E12RequestBuilder( RequestBuilder.GET, url );
		try
		{
			requestBuilder.sendRequest(requestDataMap, new RequestCallback()
			{
				@Override
				public void onResponseReceived(Request request,
						Response response) 
				{
					try
					{
					//	cordovafileExecuter();
						String responseText = E12Global.checkNull( response.getText() );
						if( responseText != null && responseText.length() > 0 && responseText.indexOf("Exception") == -1  )
						{
							parentVerticalPanel.add( outerDiv );
							Document document = XMLParser.parse( response.getText() );
							NodeList nodeList = document.getElementsByTagName( "Detail5" );
							noOfBrands = nodeList.getLength();;
							for( int index=0 ; index < noOfBrands; index++)
							{
								final Label feedLabel = new Label();
								feedLabel.setStyleName( "feedBackLabel" );
								Node node = nodeList.item( index );
								String brandName = "";
								String brandCode = "";
								String brandDocId = "";
								for(int j = 0; j < node.getChildNodes().getLength(); j++ )
								{	
									Node node2 = node.getChildNodes().item(j);
									String nodeName = node2.getNodeName();
									if( "brand_code".equals( nodeName ) )
									{
										brandCode = node2.getFirstChild().getNodeValue();
									}
									if( "brand_doc_id".equals( nodeName ) )
									{
										brandDocId = node2.getFirstChild().getNodeValue();
									}
									if( "description".equals( nodeName ) )
									{
										brandName = node2.getFirstChild().getNodeValue();
									}
								}//End for is j
								
								HorizontalPanel childHorizontalPanel = new HorizontalPanel();
								HorizontalPanel containerHorizontalPanel = new HorizontalPanel();
								childHorizontalPanel.setVisible( true );
								containerHorizontalPanel.setVisible( true );
								Label descLable = new Label( brandName );
								descLable.setStyleName( "brandsName" );
								String imagePath = "";
								if( E12Global.getInstance().isOffline() )
								{
									imagePath = "file:///mnt/sdcard/base/" + brandCode + ".png";
								}
								else
								{
									imagePath = E12Global.getHostUrl() + "/ibase/dcdet/Brands/Logo/" + brandCode + ".png";
								}
								final String curBrandDocID = brandDocId;
								final String curBrandName = brandName;
								final Image mediaImage = new Image( imagePath );
								mediaImage.addErrorHandler(new ErrorHandler() 
								{
									@Override
									public void onError(ErrorEvent event) {
										mediaImage.setUrl("images/presentation.png");
									}
								});
								mediaImage.setWidth( "60px" );
								mediaImage.setHeight( "60px" );
								mediaImage.addClickHandler(new ClickHandler() 
								{
									@Override
									public void onClick(ClickEvent event) 
									{
										openFile( curBrandDocID, curBrandName );
									}
								});
								childHorizontalPanel.setSpacing( 10 );
								childHorizontalPanel.setVerticalAlignment( HasVerticalAlignment.ALIGN_MIDDLE );
								childHorizontalPanel.add( mediaImage );
								childHorizontalPanel.add( descLable );
								childHorizontalPanel.add( feedLabel );
								
								containerHorizontalPanel.setVerticalAlignment( HasVerticalAlignment.ALIGN_MIDDLE );
								containerHorizontalPanel.setHorizontalAlignment( HasHorizontalAlignment.ALIGN_LEFT );
								containerHorizontalPanel.setWidth( "100%" );
								containerHorizontalPanel.setStyleName( "brandsPanel" );
								containerHorizontalPanel.setHeight( "60px" );
								
								containerHorizontalPanel.add( childHorizontalPanel );
								
								parentVerticalPanel.add( containerHorizontalPanel );
								
							}// End for is index
						}
						
						
					}catch( Exception e ){
						Window.alert( "Exception is [ " + e.toString()+ " ]" );
						throw new RuntimeException( e );
					}
				}
				
				@Override
				public void onError(Request request, Throwable exception) 
				{
					Window.alert( "ERROR: Error on response [" + url + "]: " + exception.toString() );
					throw new RuntimeException( exception );
				}
			});
			
		}catch(Exception e){
			Window.alert( "ERROR: Error while calling servlet [" + url + "]: " + e.toString() );
			throw new RuntimeException( e );
		}
		initWidget( parentVerticalPanel );
	}

	private void searchValue(KeyPressEvent event) 
	{
		
		try
		{	
			if ( KeyCodes.KEY_ENTER == event.getNativeEvent().getKeyCode() )
			{
				List < HorizontalPanel > searchFalseWidget = new ArrayList < HorizontalPanel > ();
				List < HorizontalPanel > searchTrueWidget = new ArrayList < HorizontalPanel > ();
				
				Iterator < Widget > iVerticalPanelWidgets = parentVerticalPanel.iterator();
				while ( iVerticalPanelWidgets.hasNext() )
				{
					  Widget childWidget = iVerticalPanelWidgets.next();
					  if ( childWidget instanceof HorizontalPanel ) 
					  {
						  HorizontalPanel childHP = ( HorizontalPanel ) childWidget;
						  Iterator < Widget > iHorizontalPanelWidgets = childHP.iterator();
						  while( iHorizontalPanelWidgets.hasNext() )
						  {
							  Widget child = iHorizontalPanelWidgets.next();
							  if( child instanceof HorizontalPanel )
							  {
								 HorizontalPanel valuesHP = ( HorizontalPanel ) child;
								 Widget valueWidget = valuesHP.getWidget( 1 );
								 if( valueWidget instanceof Label )
								 { 
									Label valueLabel = ( Label ) valueWidget;
									
									if( valueLabel.getText().toLowerCase().contains( searchTextBox.getText().toLowerCase() ) )
									{
										searchTrueWidget.add( childHP );
									}
									else
									{
										searchFalseWidget.add( childHP );
									}
								 }//End valueWidget
							  }//End child
						  }//End hPanelWidgets  
				       }//End childWidget
				  
				}
				
				if( searchTrueWidget.size() == 0 )
				{
//					Window.alert( "No match found." );
					searchTextBox.selectAll();
				}
				else
				{
					for( int i = 0; i < searchFalseWidget.size(); i++ )
					{
						HorizontalPanel searchFalseHP = searchFalseWidget.get( i );
						searchFalseHP.setVisible( false );
					}
					searchTextBox.setFocus( true );
				}
			}
			
		}catch(Exception ee){
			Window.alert( "Error is [ " + ee.toString() + " ]  \n method name is searchValue()" );
		}//End catch
		
	}//End searchValue
	
	/**
	 * This method is visible all brands if search box is an empty 
	 * */
	private void showBrandsTextBoxEmpty() 
	{	
		if( searchTextBox.getText().length() == 0 )
		{
			Iterator < Widget > iVerticalPanelWidgets = parentVerticalPanel.iterator();
			while ( iVerticalPanelWidgets.hasNext() )
			{	
				Widget childWidget = iVerticalPanelWidgets.next();
				if ( childWidget instanceof HorizontalPanel ) 
				{
					childWidget.setVisible( true );
				}
			}
		}
	}
	
	private void openFile( String curBrandDocId, String curBrandName ) 
	{
		try 
		{
			String conId = E12Storage.getItem("curConnection");
			String clientPath = E12Storage.getItem( conId+curBrandDocId );
			E12CommonUtils.printOnConsole( "clientPath ["+clientPath+"]" );
			String url =  clientPath;
			//Added by Dnyaneshwar Chavan on 19-JUL-13 [Video file open in InAppBrowser as per KBSir] Start
			if( clientPath.contains( ".pdf" ) || clientPath.contains(".mp4") )
			{
				E12CommonUtils.openInAppBrowser( url,  true );
			}
			else
			{
				String productName = clientPath+"/index.html";
				E12CommonUtils.openInAppBrowser( "dcdetPresentation.html?productName="+productName, false );
			}
		} catch (Exception e) {
			Window.alert("No presentation for selected Brand : " + curBrandName + ".");
		}
	}
	
	public native static void log(String log)
	/*-{
		console.log( log );
         
	}-*/;

	
}// End Brands class
