<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />
	<xsl:variable name="order_type_1" />
	<xsl:template match="/">

		<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
			</head>

			<script type="text/javascript" src="/ibase/webitm/js/MRPWizard.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    var maxCnt=0;
    function resetOrderOfVisit(obj)
    {
	for(cnt=1;cnt <=maxId;cnt++)
	{
		var selBoxID ="Detail2."+cnt+"."+ "selectbox";
		var visitOrderID ="Detail2."+cnt+"."+ "order_of_visit";
		if ( document.getElementById(selBoxID) != null && document.getElementById(selBoxID).value=='true' )
		{
			document.getElementById(selBoxID).value = false;
			document.getElementById(selBoxID).checked = false;
			
			if(document.getElementById(visitOrderID) != null)
			{
			      document.getElementById(visitOrderID).value = "";
			}
		}
		
	}
	orderVisit = 0;
    }
    
    
    function selectTemplateId()
{
	var templateId = "";
	var seldbID ="";
	for( dbID = 1; dbID <= maxId; dbID++)
	{
		if( document.getElementById("Detail1."+dbID+".selectbox").value == 'true' )
		{
			seldbID = dbID;
			templateId = document.getElementById("Detail1."+dbID+".template_id").value;
			
			
		}
	}
	if( templateId == "" )
	{
		alert("No Selection Made ! \nPlease Select the Template ID !");
	}
	else
	{
		window.opener.displayTemplate( templateId);
		window.close();
	}
}


function setChecked( obj )
{
	for( dbID = 1; dbID <= maxId; dbID++)
	{
		objCurr = document.getElementById("Detail1."+dbID+".selectbox");
		if( objCurr.value == 'true' )
		{
			objCurr.value ='false';
			objCurr.checked = false;
		}
	}
	if( obj.value == 'false' )
	{
		
		obj.value ='true';
		obj.checked = true;
	}
	else
	{
		obj.value = 'false';
		obj.checked = false;
	}
}
    
    
]]>

			</script>
			<body onload="javascript:selectAlltr()">


				<style type="text/css">

					.tableClass
					{margin-left:10px;margin-top:10px}

					.tableClass_rep
					{margin-left:0px}

					.header_td
					{border:inset
					0;background:#FFCCCC;font-family:verdana;font-size:9pt}

					.reset
					{border:inset 1;font-family:verdana;font-size:9pt;
					font-weight:bold}

					.input_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.input_editable_right
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					width:100%}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_leftAlign1
					{text-align:left;font-family:verdana;font-size:9pt}

					.Stock
					{background:#CDDADE}

					.Planned
					{background:#FFDCA5}

					.WIP
					{background:#A6A6BE}
					
					.displyColor
					{ height:10pt }

					.stockcircle{
					width:
					25px;
					height: 25px;
					background-color: #CDDADE
					}

					.plannedcircle{
					width:
					25px;
					height: 25px;
					background-color: #FFDCA5
					}

					.WIPcircle{
					width: 25px;
					height: 25px;
					background-color: #A6A6BE
					}

					.hide
					{display:none }

					.displyCommonInfo
					{
					border:inset
					0;background:#EEF4F8;font-family:verdana;font-size:10pt;
					cellspacing=15px; cellpadding=9px ; font-weight:bold;
					}

					.td_commonAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}


				</style>

				<!-- form name = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" 
					onSubmit="javascript:return validatePlace('3');" -->
				<!-- form name = "mrp_run_wiz" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" -->
				<form name="mrp_run_wiz" METHOD="post">

					<table class="displyColor">
						<tr class="header_td1">
							
							<td width="20"></td>
							<td>
								<div class="stockcircle"></div>
							</td>
							<td width="100"> - Stock</td>
							<td width="10"></td>
							
							<td>
								<div class="plannedcircle"></div>
							</td>
							<td width="150"> - Planned</td>
							<td width="10"></td>
							
							<td>
								<div class="WIPcircle"></div>
							</td>
							<td width="100"> - WIP</td>
							<td width="10"></td>
														
						</tr>
					</table>


			

					<xsl:for-each select="//CommonDetail">
						<xsl:variable name="dbID" select="@domID" />
						<xsl:variable name="chkbox" select="@selected" />
			
						<xsl:variable name="detail2dbID" select="detail2dbID" />
						<xsl:variable name="sale_order_1" select="sale_order" />
						<xsl:variable name="line_no_1" select="line_no" />
						<xsl:variable name="site_code_1" select="site_code" />
						<xsl:variable name="item_code_1" select="item_code" />
						<xsl:variable name="item_code_descr_1" select="item_code_descr" />
						<xsl:variable name="qty_reqd_1" select="qty_reqd" />
						<xsl:variable name="order_type_1" select="order_type" />
						<xsl:variable name="dueDateDet2" select="dueDateDet2" />

						<table class="displyCommonInfo" align="center">
							<tr>
								<td>Order Number :</td>
								<td align="left">
									<input type="hidden" name="Detail4.sale_order_1" id="Detail4.sale_order_1"
										value="{$sale_order_1}" size="10" ISCHANGED="false" />
									<xsl:value-of select="$sale_order_1" />
								</td>
								<td width="30"></td>
								<td>Line No :</td>
								<td align="left">
									<input type="hidden" name="Detail4.line_no_1" id="Detail4.line_no_1"
										value="{$line_no_1}" size="04" ISCHANGED="false" />
									<xsl:value-of select="$line_no_1" />
								</td>
								<td width="30"></td>
								<td>Site Code :</td>
								<td align="left">
									<input type="hidden" name="Detail4.site_code_1" id="Detail4.site_code_1"
										value="{$site_code_1}" size="10" ISCHANGED="false" />
									<xsl:value-of select="$site_code_1" />
								</td>
								<td width="30"></td>
								<td>Item Code :</td>
								<td align="left">
									<input type="hidden" name="Detail4.item_code_1" id="Detail4.item_code_1"
										value="{$item_code_1}" size="10" ISCHANGED="false" />
									<xsl:value-of select="$item_code_1" />
								</td>
								<td width="30"></td>
								<td>Item Description :</td>
								<td align="left">
									<input type="hidden" name="Detail4.item_code_descr_1" id="Detail4.item_code_descr_1"
										value="{$item_code_descr_1}" size="30" ISCHANGED="false" />
									<xsl:value-of select="$item_code_descr_1" />
								</td>
								<td width="30"></td>
								<td>Quantity Required :</td>
								<td align="left">
									<input type="hidden" name="Detail4.qty_reqd_1" id="Detail4.qty_reqd_1"
										value="{$qty_reqd_1}" size="30" ISCHANGED="false" />
									<xsl:value-of select="$qty_reqd_1" />
								</td>
 
								<td class="hide" align="left">
									<input type="hide" name="Detail4.order_type_1" id="Detail4.order_type_1"
										value="{$order_type_1}" size="30" ISCHANGED="false" />
									<xsl:value-of select="$order_type_1" />
								</td>

								<td class="hide" align="left">
									<input type="hide" name="detail2dbID" id="detail2dbID"
										value="{$detail2dbID}" size="30" ISCHANGED="false" />
									<xsl:value-of select="$detail2dbID" />
								</td>
								
								<td class="hide" align="left">
									<input type="hide" name="dueDateDet2" id="dueDateDet2"
										value="{$dueDateDet2}" size="30" ISCHANGED="false" />
									<xsl:value-of select="$dueDateDet2" />
								</td>
								

							</tr>
						</table>
					</xsl:for-each>

					<table id="travelTable" width="100%" class="tableClass"
						border="0" cellspacing="1" cellpadding="1">

						<xsl:variable name="dbID2">
							<xsl:value-of select="@dbID2" />
						</xsl:variable>

						<xsl:for-each select="//Detail4">
							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>
							<SCRIPT>
				<![CDATA[ 
				var detCnt ;  
				detCnt ="]]><xsl:value-of select="$dbID" /><![CDATA[";
					maxId= detCnt; 												
				]]>
							</SCRIPT>

						</xsl:for-each>
						<tr>
							<td width="1%" class="header_td" nowrap="true" valign="bottom">
							</td>
							<td width="5%" class="hide" nowrap="true" valign="bottom">
								<strong>
									Sale
									<br />
									Order
								</strong>
							</td>
							<td width="5%" class="hide" nowrap="true" valign="bottom">
								<strong>Line No</strong>
							</td>
							<td width="5%" class="hide" nowrap="true" valign="bottom">
								<strong>Site Code</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Item Code</strong>
							</td>
							<td width="10%" class="header_td" nowrap="true" valign="bottom">
								<strong>Item Description</strong>
							</td>
							<td width="10%" class="header_td" nowrap="true" valign="bottom">
								<strong>Lot No</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Lot Sl</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Loc Code</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Source</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Ref Id</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>
									Reference
									<br />
									Line No
								</strong>
							</td>

							<!-- <td width="5%" class="header_td" nowrap="true" valign="bottom"> 
								<strong>Quantity <br/>Required</strong> </td> -->

							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>
									Stock
									<br />
									Quantity
								</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>
									WIP/Planned
									<br />
									Quantity
								</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>
									Available
									<br />
									Supply
								</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>
									Quantity To
									<br />
									Be Allocated
								</strong>
							</td>
							<td width="5%" class="header_td" nowrap="true" valign="bottom">
								<strong>Due date</strong>
							</td>

						</tr>


						<xsl:for-each select="//Detail4">

							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>
							<xsl:variable name="chkbox">
								<xsl:value-of select="@selected" />
							</xsl:variable>

							<xsl:variable name="sale_order">
								<xsl:value-of select="sale_order" />
							</xsl:variable>
							<xsl:variable name="line_no">
								<xsl:value-of select="line_no" />
							</xsl:variable>

							<xsl:variable name="qty_reqd">
								<xsl:value-of select="qty_reqd" />
							</xsl:variable>

							<xsl:variable name="site_code">
								<xsl:value-of select="site_code" />
							</xsl:variable>
							<xsl:variable name="item_code">
								<xsl:value-of select="item_code" />
							</xsl:variable>
							<xsl:variable name="item_code_descr">
								<xsl:value-of select="item_code_descr" />
							</xsl:variable>
							<xsl:variable name="lot_no">
								<xsl:value-of select="lot_no" />
							</xsl:variable>
							<xsl:variable name="lot_sl">
								<xsl:value-of select="lot_sl" />
							</xsl:variable>
							<xsl:variable name="loc_code">
								<xsl:value-of select="loc_code" />
							</xsl:variable>
							<xsl:variable name="tran_ser">
								<xsl:value-of select="tran_ser" />
							</xsl:variable>
							<xsl:variable name="tran_id">
								<xsl:value-of select="tran_id" />
							</xsl:variable>
							<xsl:variable name="ref_line_no">
								<xsl:value-of select="ref_line_no" />
							</xsl:variable>
							<xsl:variable name="supply">
								<xsl:value-of select="supply" />
							</xsl:variable>
							<xsl:variable name="planned_quantity">
								<xsl:value-of select="planned_quantity" />
							</xsl:variable>
							<xsl:variable name="available_supply">
								<xsl:value-of select="available_supply" />
							</xsl:variable>
							<xsl:variable name="alloc_qty">
								<xsl:value-of select="alloc_qty" />
							</xsl:variable>
							<xsl:variable name="source_supply">
								<xsl:value-of select="source_supply" />
							</xsl:variable>
							<xsl:variable name="parent_item">
								<xsl:value-of select="parent_item" />
							</xsl:variable>

							<xsl:variable name="item_code_parent">
								<xsl:value-of select="item_code_parent" />
							</xsl:variable>
							<xsl:variable name="originalOrAltitem">
								<xsl:value-of select="originalOrAltitem" />
							</xsl:variable>

							<xsl:variable name="quantityFlag">
								<xsl:value-of select="False" />
							</xsl:variable>

							<xsl:variable name="prev_item_worder">
								<xsl:value-of select="prev_item_worder" />
							</xsl:variable>
							<xsl:variable name="previous_item">
								<xsl:value-of select="previous_item" />
							</xsl:variable>
							<xsl:variable name="new_planned_supply">
								<xsl:value-of select="new_planned_supply" />
							</xsl:variable>
							
							<xsl:variable name="due_date">
								<xsl:value-of select="due_date" />
							</xsl:variable>
							
							<xsl:variable name="alloc_pref">
								<xsl:value-of select="alloc_pref" />
							</xsl:variable>
							
							
							<xsl:variable name="alt_item_perc">
								<xsl:value-of select="alt_item_perc" />
							</xsl:variable>
							

							<!-- <xsl:choose> <xsl:when test="supply > 0 "> <xsl:when test=" ( 
								supply > 0 ) and ( tran_ser == 'Stock' ) "> <xsl:variable name="quantityFlag" 
								value ="True" /> </xsl:when> </xsl:choose> <xsl:choose> <xsl:when test="supply 
								> 0 "> <xsl:variable name="quantityFlag" value ="True" /> </xsl:when> </xsl:choose> 
								<xsl:choose> <xsl:when test="$quantityFlag == 'False' "> -->
							<tr id="tr.{normalize-space($dbID)}">
								<td class="td_leftAlign1">
									<xsl:choose>
										<xsl:when test="$chkbox ='Y'">
											<script>
							<![CDATA[ orderVisit = parseInt("]]>
												<xsl:value-of select="order_of_visit" /><![CDATA[");]]>
											</script>
											<input type="checkbox"
												name="Detail4.{normalize-space($dbID)}.selectbox" id="Detail4.{normalize-space($dbID)}.selectbox"
												checked='Y' value="true"
												onClick="javaScript:setCheckedPlace(this, '{normalize-space($dbID)}' )" />
										</xsl:when>
										<xsl:otherwise>
											<input type="checkbox"
												name="Detail4.{normalize-space($dbID)}.selectbox" id="Detail4.{normalize-space($dbID)}.selectbox"
												value="false"
												onClick="javaScript:setCheckedPlace(this, '{normalize-space($dbID)}' )" />
										</xsl:otherwise>
									</xsl:choose>
								</td>

								<td class="hide" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.sale_order"
										id="Detail4.{normalize-space($dbID)}.sale_order" value="{$sale_order}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="sale_order" />
								</td>

								<td class="hide" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.line_no"
										id="Detail4.{normalize-space($dbID)}.line_no" value="{$line_no}"
										size="04" ISCHANGED="false" />
									<xsl:value-of select="line_no" />
								</td>


								<td class="hide" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.site_code"
										id="Detail4.{normalize-space($dbID)}.site_code" value="{$site_code}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="site_code" />
								</td>

								<xsl:choose>
									<xsl:when test="originalOrAltitem ='A'">
										<td class="td_leftAlign1" align="left">
											<input type="hidden"
												name="Detail4.{normalize-space($dbID)}.item_code" id="Detail4.{normalize-space($dbID)}.item_code"
												value="{$item_code}" size="10" ISCHANGED="false" />
											<xsl:value-of select="item_code" />
										</td>
										<td class="td_leftAlign1" align="left">
											<input type="hidden"
												name="Detail4.{normalize-space($dbID)}.item_code_descr" id="Detail4.{normalize-space($dbID)}.item_code_descr"
												value="{$item_code_descr}" size="30" ISCHANGED="false" />
											<xsl:value-of select="item_code_descr" />
										</td>
									</xsl:when>
									<xsl:otherwise>
										<td class="td_leftAlign1" align="left">
											<input type="hidden"
												name="Detail4.{normalize-space($dbID)}.item_code" id="Detail4.{normalize-space($dbID)}.item_code"
												value="{$item_code}" size="10" ISCHANGED="false" />
											
										</td>
										<td class="td_leftAlign1" align="left">
											<input type="hidden"
												name="Detail4.{normalize-space($dbID)}.item_code_descr" id="Detail4.{normalize-space($dbID)}.item_code_descr"
												value="{$item_code_descr}" size="30" ISCHANGED="false" />
											
										</td>
									</xsl:otherwise>
								</xsl:choose>

								<td class="td_leftAlign1" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.lot_no"
										id="Detail4.{normalize-space($dbID)}.lot_no" value="{$lot_no}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="lot_no" />
								</td>

								<td class="td_leftAlign1" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.lot_sl"
										id="Detail4.{normalize-space($dbID)}.lot_sl" value="{$lot_sl}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="lot_sl" />
								</td>

								<td class="td_leftAlign1" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.loc_code"
										id="Detail4.{normalize-space($dbID)}.loc_code" value="{$loc_code}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="loc_code" />
								</td>

								<td class="td_leftAlign1" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.tran_ser"
										id="Detail4.{normalize-space($dbID)}.tran_ser" value="{$tran_ser}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="tran_ser" />
								</td>

								<td class="td_leftAlign1" align="left">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.tran_id"
										id="Detail4.{normalize-space($dbID)}.tran_id" value="{$tran_id}"
										size="10" ISCHANGED="false" />
									<xsl:value-of select="tran_id" />
								</td>

								<td class="td_leftAlign1" align="left">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.ref_line_no" id="Detail4.{normalize-space($dbID)}.ref_line_no"
										value="{$ref_line_no}" size="10" ISCHANGED="false" />
									<xsl:value-of select="ref_line_no" />
								</td>
								<td class="hide" style="text-align:right">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.qty_reqd"
										id="Detail4.{normalize-space($dbID)}.qty_reqd" value="{$qty_reqd}"
										size="04" ISCHANGED="false" />
									<xsl:value-of select="qty_reqd" />
								</td>
								<td class="td_leftAlign1" style="text-align:right">
									<input type="hidden" name="Detail4.{normalize-space($dbID)}.supply"
										id="Detail4.{normalize-space($dbID)}.supply" value="{$supply}"
										size="10" ISCHANGED="false" />
									<!-- <xsl:value-of select="supply" /> -->
									<xsl:value-of select="format-number(supply, '######.000')" />
								</td>
								<td class="td_leftAlign1" style="text-align:right">
									<!-- <input type="hidden" name="Detail4.{normalize-space($dbID)}.planned_quantity" 
										id="Detail4.{normalize-space($dbID)}.planned_quantity" value="{$planned_quantity}" 
										size="10" ISCHANGED="false"/> <xsl:value-of select="planned_quantity"/> -->
									<xsl:choose>
										<xsl:when test="tran_ser ='Stock'">
											<input type="hidden" name="Detail4.{normalize-space($dbID)}.supply"
												id="Detail4.{normalize-space($dbID)}.supply" value="{$supply}"
												size="10" ISCHANGED="false" />
										<!-- 	<xsl:value-of select="supply" />   -->
										</xsl:when>
										<xsl:otherwise>
											<input type="hidden"
												name="Detail4.{normalize-space($dbID)}.planned_quantity" id="Detail4.{normalize-space($dbID)}.planned_quantity"
												value="{$planned_quantity}" size="10" ISCHANGED="false" />
											<!-- <xsl:value-of select="planned_quantity" /> -->
											<xsl:value-of select="format-number(planned_quantity, '######.000')" />	
										</xsl:otherwise>
									</xsl:choose>

								</td>
								<td class="td_leftAlign1" style="text-align:right">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.available_supply" id="Detail4.{normalize-space($dbID)}.available_supply"
										value="{$available_supply}" size="10" ISCHANGED="false" />
									<!-- <xsl:value-of select="number(supply) - number(alloc_qty)"/> -->
									<!-- <xsl:value-of select="available_supply" /> -->
									<xsl:value-of select="format-number(available_supply, '######.000')" />
								</td>

								<td class="td_leftAlign1" style="text-align:right">
									<xsl:choose>
										<xsl:when test="order_type_1 ='MPS'">
											<input type="hidden" class="input_editable"
												name="Detail4.{normalize-space($dbID)}.alloc_qty" id="Detail4.{normalize-space($dbID)}.alloc_qty"
												value="{$supply}" size="15" align="right" ISCHANGED="false" />
												<xsl:value-of select="order_type_1" />
										</xsl:when>
										<xsl:when test="tran_ser ='Stock'">
											<input type="text" class="input_editable_right"
												name="Detail4.{normalize-space($dbID)}.alloc_qty" id="Detail4.{normalize-space($dbID)}.alloc_qty"
												value="{$alloc_qty}" size="15" align="right"
												onkeypress="return isNumberKey(event)" ISCHANGED="false" />
										</xsl:when>
										<xsl:otherwise>
											<input type="hidden" class="input_editable"
												name="Detail4.{normalize-space($dbID)}.alloc_qty" id="Detail4.{normalize-space($dbID)}.alloc_qty"
												value="{$supply}" size="15" align="right" ISCHANGED="false" />
											<!-- <xsl:value-of select="supply" /> -->
											<xsl:value-of select="format-number(supply, '######.000')" />
										</xsl:otherwise>
									</xsl:choose>

								</td>
								<td class="hide" style="text-align:right">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.source_supply" id="Detail4.{normalize-space($dbID)}.source_supply"
										value="{$source_supply}" size="10" ISCHANGED="false" />
									<xsl:value-of select="source_supply" />
								</td>
								<td class="hide" align="text-align:right">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.parent_item" id="Detail4.{normalize-space($dbID)}.parent_item"
										value="{$parent_item}" size="10" ISCHANGED="false" />
									<xsl:value-of select="parent_item" />
								</td>
								
								
								<td class="hide" align="text-align:right">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.prev_item_worder" id="Detail4.{normalize-space($dbID)}.prev_item_worder"
										value="{$prev_item_worder}" size="10" ISCHANGED="false" />
									<xsl:value-of select="prev_item_worder" />
								</td>
								<td class="hide" align="text-align:right">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.previous_item" id="Detail4.{normalize-space($dbID)}.previous_item"
										value="{$previous_item}" size="10" ISCHANGED="false" />
									<xsl:value-of select="previous_item" />
								</td>
								
								<td class="hide" align="text-align:right">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.new_planned_supply" id="Detail4.{normalize-space($dbID)}.new_planned_supply"
										value="{$new_planned_supply}" size="10" ISCHANGED="false" />
									<xsl:value-of select="new_planned_supply" />
								</td>
								
								<td class="td_leftAlign1" style="text-align:left">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.due_date" id="Detail4.{normalize-space($dbID)}.due_date"
										value="{$due_date}" size="10" ISCHANGED="false" />
									<xsl:value-of select="due_date" />
								</td>
								
								<td class="hide" style="text-align:left">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.alloc_pref" id="Detail4.{normalize-space($dbID)}.alloc_pref"
										value="{$alloc_pref}" size="10" ISCHANGED="false" />
									<xsl:value-of select="alloc_pref" />
								</td>
								
								<td class="hide" style="text-align:left">
									<input type="hidden"
										name="Detail4.{normalize-space($dbID)}.alt_item_perc" id="Detail4.{normalize-space($dbID)}.alt_item_perc"
										value="{$alt_item_perc}" size="10" ISCHANGED="false" />
									<xsl:value-of select="alt_item_perc" />
								</td>
								
								
								
							</tr>
							<!-- </xsl:when> </xsl:choose> -->

						</xsl:for-each>

					</table>
					<div id="repeatPlacesDiv" style="margin-left:10px"></div>
					<table>
						<tr>
							<td>
								<input type="hidden" value="4" name="FORM_NO" ID="FORM_NO" />
								<input type="hidden" value="mrp_run_wiz" name="OBJ_NAME" />
								<input type="hidden" value="" name="action" id="action" />
								<input type="button" value="Add" title='Add' onclick="addSupply();" />
								<!--  <input type="button" value="Add" title='Add' onclick="addSupply();" />  -->
								
								<input type="button" value="Cancel" title='Cancel'
									onclick="window.close()" />
							</td>
						</tr>
					</table>
					<table id="errorTravelTable" width="85%" class="tableClass"
						border="0" cellspacing="1" cellpadding="1">
						<xsl:for-each select="//error">
							<xsl:variable name="message">
								<xsl:value-of select="message" />
							</xsl:variable>
							<xsl:variable name="description">
								<xsl:value-of select="description" />
							</xsl:variable>
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:variable name="dbID">
								<xsl:value-of select="@domId" />
							</xsl:variable>
							<xsl:variable name="column_name">
								<xsl:value-of select="@column_name" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<tr>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Message :
									</td>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Description :
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="message" />
								</td>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="description" />
								</td>
							</tr>
						</xsl:for-each>
						<xsl:for-each select="//error">
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<xsl:if test="$type = 'W'">
									<tr>
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											Override
											Warnings :
										</td>
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											<input type="checkbox" name="forceSave" value="false"
												onClick="javascript:setChecked(this)" />
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:for-each>
					</table>

				</form>
			</body>

		</html>
	</xsl:template>
</xsl:stylesheet>
