package ibase.webitm.ejb.gst;

import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;

import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.gst.B2B;
import ibase.webitm.bean.gst.B2BA;
import ibase.webitm.bean.gst.B2CL;
import ibase.webitm.bean.gst.B2CLA;
import ibase.webitm.bean.gst.B2CS;
import ibase.webitm.bean.gst.B2CSA;
import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNR;
import ibase.webitm.bean.gst.CDNRA;
import ibase.webitm.bean.gst.GSTR1;
import ibase.webitm.bean.gst.InvLineItem;
import ibase.webitm.bean.gst.Invoice;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GSTDataSubmitWizPos extends ValidatorEJB implements GSTDataSubmitWizPosLocal, GSTDataSubmitWizPosRemote
{
	private String GST_API_URL = "";
	private String GSTR1_URL = "";
	private String GSTR2_URL = "";
	private final String APPLICATION_JSON = "application/json";
	private String appKey = "";
	InetAddress ipAddress = null;
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	Connection conn = null;
	E12GenericUtility e12GeneticUitlity = null;
	@PostConstruct
	public void postConstruct()
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("GSTDataSubmitWizPos PostConstruct called!");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/GSTN_Public_Key.cer");
			conn = getConnection();
			e12GeneticUitlity = new E12GenericUtility();
			FinCommon finCommon = new FinCommon();
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = Inet4Address.getLocalHost();
			System.out.println("host ipAddress["+ipAddress.getHostAddress()+"]");
			
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = 'gst_base_url' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				GST_API_URL = checkNullandTrim(rs.getString("SERVICE_URI"));
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = 'gstr1_url' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				GSTR1_URL = checkNullandTrim(rs.getString("SERVICE_URI"));
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = 'gstr2_url' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				GSTR2_URL = checkNullandTrim(rs.getString("SERVICE_URI"));
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		Document allXMLDom = null;
		NodeList detail1NList = null, detail1ChildNList = null;
		String retString = "", nodeName = "", otp = "", stateCode = "", sek = "", returnsType = "", gstin = "", periodCode = "", grossTurnover = "",
			   action = "", siteCode = "";
		byte[] authSEK = null;
		
		try
		{
			String userName = "", authToken = "";
			String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			String AUTH_TOKEN_URL = "/taxpayerapi/v0.2/authenticate";
			
			System.out.println("xmlStringAll["+xmlStringAll+"]");
			System.out.println("dcrId["+dcrId+"]");
			System.out.println("editFlag["+editFlag+"]");
			
			allXMLDom = e12GeneticUitlity.parseString(xmlStringAll);
			
			detail1NList = allXMLDom.getElementsByTagName("Detail1");
			detail1ChildNList = detail1NList.item(0).getChildNodes();
			
			for(int i=0; i<detail1ChildNList.getLength();i++)
			{
				Node eachDetail1Element = detail1ChildNList.item(i);
				nodeName = eachDetail1Element.getNodeName();
				
				if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
				{
					if("username".equalsIgnoreCase(nodeName))
					{
						userName = eachDetail1Element.getTextContent();
					}
					else if("state_code".equalsIgnoreCase(nodeName))
					{
						stateCode = eachDetail1Element.getTextContent();;
					}
					else if("app_key".equalsIgnoreCase(nodeName))
					{
						appKey = eachDetail1Element.getTextContent();
					}
					else if("otp".equalsIgnoreCase(nodeName))
					{
						otp = eachDetail1Element.getTextContent();
					}
					else if("returns_type".equalsIgnoreCase(nodeName))
					{
						returnsType = eachDetail1Element.getTextContent();
					}
					else if("gstin".equalsIgnoreCase(nodeName))
					{
						gstin = eachDetail1Element.getTextContent();
					}
					else if("period_code".equalsIgnoreCase(nodeName))
					{
						periodCode = eachDetail1Element.getTextContent();
					}
					else if("gross_turnover".equalsIgnoreCase(nodeName))
					{
						grossTurnover = eachDetail1Element.getTextContent();
					}
					else if("action".equalsIgnoreCase(nodeName))
					{
						action = eachDetail1Element.getTextContent();
					}
					else if("site_code".equalsIgnoreCase(nodeName))
					{
						siteCode = eachDetail1Element.getTextContent();
					}
				}
			}		
			
			System.out.println("returnsType["+returnsType+"] action ["+action+"]");
			
			appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
			appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
			
			String encryptedOTP = aesEncryption.encryptEK(otp.getBytes(), appKeyInBytes);
			
			JSONObject authTokenReq = new JSONObject();
	        authTokenReq.put("action", "AUTHTOKEN");
	        authTokenReq.put("username", userName);
	        authTokenReq.put("app_key", appKeyEncryptedAndCoded);
	        authTokenReq.put("otp", encryptedOTP);

	        HttpResponse<JsonNode> authTokenResp = Unirest.post(String.format("%s%s", GST_API_URL, AUTH_TOKEN_URL))
												   .header("Content-Type",APPLICATION_JSON)
												   .header("clientid", clientId)
												   .header("client-secret", clientSecret)
												   .header("state-cd", stateCode)
												   .header("ip-usr", ipAddress.getHostAddress())
												   .header("txn", transactionId)
												   .header("app_key", appKeyEncryptedAndCoded)
												   .body(new JsonNode(authTokenReq.toString()))
												   .asJson();

	        System.out.println(String.format("authTokenResp Request : Status[%s] Response[%s]", authTokenResp.getStatus(), authTokenResp.getBody()));
	        if (authTokenResp.getStatus() == 200) 
	        {
	            JSONObject object = authTokenResp.getBody().getObject();
	            if (object.has("auth_token") && object.has("sek") && object.has("status_cd") && Objects.equals(object.getString("status_cd"), "1")) 
	            {
	                authToken = object.getString("auth_token");
	                sek = object.getString("sek");

	                authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
	                System.out.println("AuthSEK = "+ aesEncryption.encodeBase64String(authSEK));
	                
	                if("GSTR1".equalsIgnoreCase(returnsType))
	                {
	                	if("SAVE".equalsIgnoreCase(action))
	                	{
	                		retString = saveGstr1(authToken, siteCode, stateCode, userName, gstin, periodCode, grossTurnover, authSEK, conn);
	                	}
	                	else if ("RETSUM".equalsIgnoreCase(action) || "FILE".equalsIgnoreCase(action))
	                	{
	                		retString = getGstr1Summary(authToken, stateCode, userName, gstin, periodCode, authSEK, action, conn);
	                	}
	                	else if ("SUBMIT".equalsIgnoreCase(action))
	                	{
	                		retString = submitGstr1(authToken, stateCode, userName, gstin, periodCode, authSEK, conn);
	                	}
	                }
	                else if("GSTR2".equalsIgnoreCase(returnsType))
	                {
	                	if("GETINV".equalsIgnoreCase(action))
	                	{
	                		retString = getGstr2Invoices(authToken, stateCode, userName, gstin, periodCode, authSEK, conn);
	                	}
	                }
	            }
	            else
	            {
	            	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
	            	
	            	if("AUTH4033".equalsIgnoreCase(errorJSON.getString("error_cd")))
	            	{
	            		retString = new ITMDBAccessEJB().getErrorString("","VTINVOTP","","",conn);
	            	}
	            	else
	            	{
	            		String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	            		retString = getError(errMsg, "GSTAPIERR", conn);
	            	}
	            }
	        }
	        else
	        {
	        	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
	        	String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.postSave()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private String saveGstr1(String authToken, String siteCode, String stateCode, String userName, String gstin, String periodCode, String grossTurnover, byte[] authSek, Connection conn)
	{
		String retString = "", errMsg = "";
		String gstr1Data = "", gstr1Rek = "";
		String retStatsData = "", retStatsRek = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		
		String sql = "", lineSql = "", refDataSql = "";
		PreparedStatement pstmt = null, linePstmt = null, refDataPstmt = null;
		ResultSet rs = null, lineRs = null, refDataRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "", posStateCodeStr = "", supplyType = "";
		
		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2BA> b2baInvoiceList = new ArrayList<B2BA>();
		ArrayList<B2CL> b2clInvoiceList = new ArrayList<B2CL>();
		ArrayList<B2CLA> b2claInvoiceList = new ArrayList<B2CLA>();
		ArrayList<B2CS> b2csInvoiceList = new ArrayList<B2CS>();
		ArrayList<B2CSA> b2csaInvoiceList = new ArrayList<B2CSA>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<CDNRA> cdnraList = new ArrayList<CDNRA>();

		ArrayList<InvLineItem> invLineItems = null;
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		
		GSTR1 gstr1 = null;
		Invoice invoice = null;
		InvLineItem invLineItem = null;
		B2B b2b = null;
		B2BA b2ba = null;
		B2CL b2cl = null;
		B2CLA b2cla = null;
		B2CS b2cs = null;
		B2CSA b2csa = null;
		CDNR cdnr = null;
		CDNRA cdnra = null;
		CDNDetails cdnDetails = null;
		
		try
		{
			gstr1 = new GSTR1();
			gstr1.gstin = gstin;
			gstr1.financialPeriod = periodCode;
			gstr1.grossTurnOver = Double.valueOf(grossTurnover);
			
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE ='1'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCodeStr = checkNullandTrim(rs.getString("STATE_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCodeStr["+posStateCodeStr+"] tranIdRef["+tranIdRef+"]");
				
				if(posStateCodeStr.length() > 0)
				{
					lineSql = "SELECT GST_CODE FROM STATE WHERE STATE_CODE = ?";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, posStateCodeStr);
					lineRs = linePstmt.executeQuery();
					
					if(lineRs.next())
					{
						posStateCode = checkNullandTrim(lineRs.getString("GST_CODE")) ;
					}
					
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				invLineItems = new ArrayList<InvLineItem>();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				if(invoicesHMap.containsKey(ctin+"~"+tranType))
				{
					invoices = invoicesHMap.get(ctin+"~"+tranType);
				}
				
				//tran_type : 01 = B2B invoices, 02 B2BA invoices
				if("01".equalsIgnoreCase(tranType) || "02".equalsIgnoreCase(tranType))
				{
					if("02".equalsIgnoreCase(tranType))
					{
						if(tranIdRef.length() > 0)
						{
							lineSql = "SELECT DOC_NO, DOC_DATE FROM GST_DATA_HDR WHERE TRAN_ID = ?";
							linePstmt = conn.prepareStatement(lineSql);
							linePstmt.setString(1, tranIdRef);
							lineRs = linePstmt.executeQuery();
							
							if(lineRs.next())
							{
								invoice.oinum = checkNullandTrim(lineRs.getString("DOC_NO")) ;
								invoice.oidt = lineRs.getDate("DOC_DATE");
							}
							
							if(linePstmt != null)
							{
								linePstmt.close();
								linePstmt = null;
							}
							if(lineRs != null)
							{
								lineRs.close();
								lineRs = null;
							}
						}
					}
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = lineRs.getInt("LINE_NO");
						invLineItem.ty = lineRs.getString("LINE_TYPE");
						invLineItem.hsn_sc = lineRs.getString("GS_CODE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.irt = lineRs.getDouble("IGST_PERC");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.crt = lineRs.getDouble("CGST_PERC");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.srt = lineRs.getDouble("SGST_PERC");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csrt = lineRs.getDouble("CESS_PERC");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.pos = posStateCode;
					invoice.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
					invoice.prs = "Y".equalsIgnoreCase(rs.getString("PROV_ASSMNT"));
					invoice.od_num = rs.getString("ORDER_NO");
					invoice.od_dt = rs.getDate("ORDER_DATE");
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+tranType, invoices);
					
					if("01".equalsIgnoreCase(tranType))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+tranType))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+tranType);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+tranType, b2b);
						b2bInvoiceList.add(b2b);
					}
					else if("02".equalsIgnoreCase(tranType))
					{
						b2ba = new B2BA();
						if(invTypObjHMap.containsKey(ctin+"~"+tranType))
						{
							b2ba = (B2BA)invTypObjHMap.get(ctin+"~"+tranType);
							if(b2baInvoiceList.contains(b2ba))
							{
								int index = b2baInvoiceList.indexOf(b2ba);
								b2baInvoiceList.remove(index);
							}
						}
						b2ba.ctin = ctin;
						b2ba.isReverseCharge = true;
						b2ba.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+tranType, b2ba);
						b2baInvoiceList.add(b2ba);
					}
				}
				//tran_type : 03 = B2CL invoices, 04 B2CLA invoices
				if("03".equalsIgnoreCase(tranType) || "04".equalsIgnoreCase(tranType))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					if("04".equalsIgnoreCase(tranType))
					{
						tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
						
						if(tranIdRef.length() > 0)
						{
							lineSql = "SELECT DOC_NO, DOC_DATE FROM GST_DATA_HDR WHERE TRAN_ID = ?";
							linePstmt = conn.prepareStatement(lineSql);
							linePstmt.setString(1, tranIdRef);
							lineRs = linePstmt.executeQuery();
							
							if(lineRs.next())
							{
								invoice.oinum = checkNullandTrim(lineRs.getString("DOC_NO")) ;
								invoice.oidt = lineRs.getDate("DOC_DATE");
							}
							
							if(linePstmt != null)
							{
								linePstmt.close();
								linePstmt = null;
							}
							if(lineRs != null)
							{
								lineRs.close();
								lineRs = null;
							}
						}
					}
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = lineRs.getInt("LINE_NO");
						invLineItem.ty = lineRs.getString("LINE_TYPE");
						invLineItem.hsn_sc = lineRs.getString("GS_CODE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.irt = lineRs.getDouble("IGST_PERC");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.crt = lineRs.getDouble("CGST_PERC");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.srt = lineRs.getDouble("SGST_PERC");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csrt = lineRs.getDouble("CESS_PERC");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.cname = checkNullandTrim(rs.getString("CUST_NAME"));
					invoice.inum = checkNullandTrim(rs.getString("DOC_NO"));
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.pos = posStateCode;
					invoice.prs = "Y".equalsIgnoreCase(rs.getString("PROV_ASSMNT"));
					invoice.od_num = checkNullandTrim(rs.getString("ORDER_NO"));
					invoice.od_dt = rs.getDate("ORDER_DATE");
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					if("03".equalsIgnoreCase(tranType))
					{
						b2cl = new B2CL();
						b2cl.stateCode = stateCode;
						b2cl.isReverseCharge = false;
						b2cl.invoices = invoices;
						
						b2clInvoiceList.add(b2cl);
					}
					else if("04".equalsIgnoreCase(tranType))
					{
						b2cla = new B2CLA();
						b2cla.stateCode = stateCode;
						b2cla.isReverseCharge = false;
						b2cla.invoices = invoices;
						
						b2claInvoiceList.add(b2cla);
					}
				}
				//tran_type : 05 = B2CS invoices, 06 B2CSA invoices
				if("05".equalsIgnoreCase(tranType) || "06".equalsIgnoreCase(tranType))
				{
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						if("05".equalsIgnoreCase(tranType))
						{
							b2cs = new B2CS();
							
							refDataSql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_GSTR' AND FLD_NAME = 'SUPPLY_TYPE' AND FLD_VALUE = ?";
							refDataPstmt = conn.prepareStatement(refDataSql);
							refDataPstmt.setString(1, checkNullandTrim(lineRs.getString("SUPPLY_TYPE")));
							refDataRs = refDataPstmt.executeQuery();
							
							if(refDataRs.next())
							{
								supplyType = checkNullandTrim(refDataRs.getString("DESCR"));
							}
							if(refDataPstmt != null)
							{
								refDataPstmt.close();
								refDataPstmt = null;
							}
							if(refDataRs != null)
							{
								refDataRs.close();
								refDataRs = null;
							}
							
							b2cs.stateCode = posStateCode;
							b2cs.ty = checkNullandTrim(lineRs.getString("LINE_TYPE"));
							b2cs.itemOrServiceCode = lineRs.getString("GS_CODE");
							b2cs.txval = lineRs.getDouble("TAXABLE_AMT");
							b2cs.irt = lineRs.getDouble("IGST_PERC");
							b2cs.iamt = lineRs.getDouble("IGST_AMT");
							b2cs.crt = lineRs.getDouble("CGST_PERC");
							b2cs.camt = lineRs.getDouble("CGST_AMT");
							b2cs.srt = lineRs.getDouble("SGST_PERC");
							b2cs.samt = lineRs.getDouble("SGST_AMT");
							b2cs.csrt = lineRs.getDouble("CESS_PERC");
							b2cs.csamt = lineRs.getDouble("CESS_AMT");
							b2cs.prs = "Y".equalsIgnoreCase(checkNullandTrim(rs.getString("PROV_ASSMNT")));
							b2cs.od_num = rs.getString("ORDER_NO");
							b2cs.od_dt = rs.getDate("ORDER_DATE");
							b2cs.etin = rs.getString("ECOM_REG_NO");
							b2cs.typ = supplyType;
							
							b2csInvoiceList.add(b2cs);
						}
						if("06".equalsIgnoreCase(tranType))
						{
							String orgPeriodCode = "", orgType = "", orgItemOrServiceCode="", orgStateCode = ""; 
							b2csa = new B2CSA();
							
							if(tranIdRef.length() > 0)
							{
								refDataSql = " SELECT GDH.PRD_CODE,S.GST_CODE,GDD.LINE_TYPE,GDD.GS_CODE "
										   + " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S " 
										   + " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.STATE_CODE = S.STATE_CODE "
										   + " AND GDH.TRAN_ID = ? AND GDD.LINE_NO = ?";
								refDataPstmt = conn.prepareStatement(refDataSql);
								refDataPstmt.setString(1, tranIdRef);
								refDataPstmt.setString(2, lineRs.getString("SR_NO__OLD"));
								refDataRs = refDataPstmt.executeQuery();
								
								if(refDataRs.next())
								{
									orgPeriodCode = checkNullandTrim(refDataRs.getString("PRD_CODE"));
									orgType = checkNullandTrim(refDataRs.getString("LINE_TYPE"));
									orgItemOrServiceCode = checkNullandTrim(refDataRs.getString("GS_CODE"));
									orgStateCode = checkNullandTrim(refDataRs.getString("GST_CODE"));
								}
								if(refDataPstmt != null)
								{
									refDataPstmt.close();
									refDataPstmt = null;
								}
								if(refDataRs != null)
								{
									refDataRs.close();
									refDataRs = null;
								}
							}
							
							refDataSql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_GSTR' AND FLD_NAME = 'SUPPLY_TYPE' AND FLD_VALUE = ?";
							refDataPstmt = conn.prepareStatement(refDataSql);
							refDataPstmt.setString(1, checkNullandTrim(lineRs.getString("SUPPLY_TYPE")));
							refDataRs = refDataPstmt.executeQuery();
							
							if(refDataRs.next())
							{
								supplyType = checkNullandTrim(refDataRs.getString("DESCR"));
							}
							if(refDataPstmt != null)
							{
								refDataPstmt.close();
								refDataPstmt = null;
							}
							if(refDataRs != null)
							{
								refDataRs.close();
								refDataRs = null;
							}
							
							b2csa.orgPeriodCode = orgPeriodCode;
							b2csa.orgType = orgType;
							b2csa.orgItemOrServiceCode = orgItemOrServiceCode;
							b2csa.orgStateCode = orgStateCode;
							b2csa.stateCode = posStateCode;
							b2csa.ty = checkNullandTrim(lineRs.getString("LINE_TYPE"));
							b2csa.itemOrServiceCode = lineRs.getString("GS_CODE");
							b2csa.txval = lineRs.getDouble("TAXABLE_AMT");
							b2csa.irt = lineRs.getDouble("IGST_PERC");
							b2csa.iamt = lineRs.getDouble("IGST_AMT");
							b2csa.crt = lineRs.getDouble("CGST_PERC");
							b2csa.camt = lineRs.getDouble("CGST_AMT");
							b2csa.srt = lineRs.getDouble("SGST_PERC");
							b2csa.samt = lineRs.getDouble("SGST_AMT");
							b2csa.csrt = lineRs.getDouble("CESS_PERC");
							b2csa.csamt = lineRs.getDouble("CESS_AMT");
							b2csa.prs = "Y".equalsIgnoreCase(checkNullandTrim(rs.getString("PROV_ASSMNT")));
							b2csa.od_num = rs.getString("ORDER_NO");
							b2csa.od_dt = rs.getDate("ORDER_DATE");
							b2csa.etin = rs.getString("ECOM_REG_NO");
							b2csa.typ = supplyType;
							
							b2csaInvoiceList.add(b2csa);
						}
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				//tran_type : 07 = CDNR, 08 CDNRA
				if("07".equalsIgnoreCase(tranType) || "08".equalsIgnoreCase(tranType))
				{
					String reason = "";
					
					refDataSql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_GSTR' AND FLD_NAME = 'REAS_CODE' AND FLD_VALUE = ?";
					refDataPstmt = conn.prepareStatement(refDataSql);
					refDataPstmt.setString(1, checkNullandTrim(rs.getString("REAS_CODE")));
					refDataRs = refDataPstmt.executeQuery();
					
					if(refDataRs.next())
					{
						reason = checkNullandTrim(refDataRs.getString("DESCR"));
					}
					if(refDataPstmt != null)
					{
						refDataPstmt.close();
						refDataPstmt = null;
					}
					if(refDataRs != null)
					{
						refDataRs.close();
						refDataRs = null;
					}
					
					if("07".equalsIgnoreCase(tranType))
					{
						cdnr = new CDNR();
						
						cdnr.isReverseCharge = true;
						cdnr.ctin = ctin;
						
						lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							cdnDetails = new CDNDetails();
							
							cdnDetails.cdnNoteType = checkNullandTrim(rs.getString("DOC_TYPE"));
							cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
							cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
							cdnDetails.reason = reason;
							cdnDetails.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
							cdnDetails.invoiceDate = rs.getDate("REF_DATE__INV");
							cdnDetails.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
							cdnDetails.val = lineRs.getDouble("TAXABLE_AMT");
							cdnDetails.irt = lineRs.getDouble("IGST_PERC");
							cdnDetails.iamt = lineRs.getDouble("IGST_AMT");
							cdnDetails.crt = lineRs.getDouble("CGST_PERC");
							cdnDetails.camt = lineRs.getDouble("CGST_AMT");
							cdnDetails.srt = lineRs.getDouble("SGST_PERC");
							cdnDetails.samt = lineRs.getDouble("SGST_AMT");
							cdnDetails.csrt = lineRs.getDouble("CESS_PERC");
							cdnDetails.csamt = lineRs.getDouble("CESS_AMT");
							cdnDetails.etin = rs.getString("ECOM_REG_NO");
							
							cdnDetailsList.add(cdnDetails);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
					
					if("08".equalsIgnoreCase(tranType))
					{
						String orgInvoiceNumber = "";
						Date orgInvoiceDate = null;
						
						if(tranIdRef.length() > 0)
						{
							refDataSql = "SELECT DOC_NO, DOC_DATE FROM GST_DATA_HDR WHERE TRAN_ID = ?";
							refDataPstmt = conn.prepareStatement(refDataSql);
							refDataPstmt.setString(1, tranIdRef);
							refDataRs = refDataPstmt.executeQuery();
							
							if(refDataRs.next())
							{
								orgInvoiceNumber = checkNullandTrim(refDataRs.getString("DOC_NO")) ;
								orgInvoiceDate = refDataRs.getDate("DOC_DATE");
							}
							
							if(refDataPstmt != null)
							{
								refDataPstmt.close();
								refDataPstmt = null;
							}
							if(refDataRs != null)
							{
								refDataRs.close();
								refDataRs = null;
							}
						}
						
						cdnra = new CDNRA();
						
						cdnra.isReverseCharge = true;
						cdnra.ctin = ctin;
						
						lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							cdnDetails = new CDNDetails();
							
							cdnDetails.cdnNoteType = checkNullandTrim(rs.getString("DOC_TYPE"));
							cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
							cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
							cdnDetails.orgCDNoteNumber = orgInvoiceNumber;
							cdnDetails.orgCDNoteDate = orgInvoiceDate;
							cdnDetails.reason = reason;
							cdnDetails.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
							cdnDetails.invoiceDate = rs.getDate("REF_DATE__INV");
							cdnDetails.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
							cdnDetails.val = lineRs.getDouble("TAXABLE_AMT");
							cdnDetails.irt = lineRs.getDouble("IGST_PERC");
							cdnDetails.iamt = lineRs.getDouble("IGST_AMT");
							cdnDetails.crt = lineRs.getDouble("CGST_PERC");
							cdnDetails.camt = lineRs.getDouble("CGST_AMT");
							cdnDetails.srt = lineRs.getDouble("SGST_PERC");
							cdnDetails.samt = lineRs.getDouble("SGST_AMT");
							cdnDetails.csrt = lineRs.getDouble("CESS_PERC");
							cdnDetails.csamt = lineRs.getDouble("CESS_AMT");
							cdnDetails.etin = rs.getString("ECOM_REG_NO");
							
							cdnDetailsList.add(cdnDetails);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnra.cdnDetails = cdnDetailsList;
						
						cdnraList.add(cdnra);
					}
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(b2bInvoiceList.size() > 0)
			{
				gstr1.b2b = b2bInvoiceList;
			}
			if(b2baInvoiceList.size() > 0)
			{
				gstr1.b2ba = b2baInvoiceList;
			}
			if(b2clInvoiceList.size() > 0)
			{
				gstr1.b2cl = b2clInvoiceList;
			}
			if(b2claInvoiceList.size() > 0)
			{
				gstr1.b2cla = b2claInvoiceList;
			}
			if(b2csInvoiceList.size() > 0)
			{
				gstr1.b2cs = b2csInvoiceList;
			}
			if(b2csaInvoiceList.size() > 0)
			{
				gstr1.b2csa = b2csaInvoiceList;
			}
			if(cdnrList.size() > 0)
			{
				gstr1.cdnr = cdnrList;
			}
			if(cdnraList.size() > 0)
			{
				gstr1.cdnra = cdnraList;
			}
			
			ObjectMapper objectMapper = new ObjectMapper();
			
			String json = objectMapper.writeValueAsString(gstr1); 
			
			System.out.println("jsonPayload to SAVE GSTR1["+json+"]");
			
			byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSek);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSek));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
			
			JSONObject gstr1HeaderObj = new JSONObject();
			gstr1HeaderObj.put("action", "RETSAVE");
			gstr1HeaderObj.put("data", encryptedPayload);
			gstr1HeaderObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
			
			HttpResponse<JsonNode> gstr1Resp = Unirest.put(String.format("%s/%s", GST_API_URL, GSTR1_URL))
											   .header("Content-Type", APPLICATION_JSON)
											   .header("clientid", clientId)
											   .header("client-secret", clientSecret)
											   .header("txn",transactionId)
											   .header("state-cd", stateCode)
											   .header("auth-token", authToken)
											   .header("gstin", gstin)
											   .header("username", userName)
											   .header("ret_period", periodCode)
											   .header("ip-usr", ipAddress.getHostAddress())
											   .header("app_key", appKeyEncryptedAndCoded)
											   .body(new JsonNode(gstr1HeaderObj.toString()))
											   .asJson();
			
			System.out.println(String.format("gstr1Resp Request : Status[%s] Response[%s]", gstr1Resp.getStatus(), gstr1Resp.getBody()));
			
			if (gstr1Resp.getStatus() == 200) 
	        {
				JSONObject gstr1RespObj = gstr1Resp.getBody().getObject();
				
				if(gstr1RespObj.has("data") && gstr1RespObj.has("rek"))
				{
					gstr1Data = gstr1RespObj.getString("data");
					gstr1Rek = gstr1RespObj.getString("rek");
					
					byte[] apiEKGstr1 = aesEncryption.decrypt(gstr1Rek, authSek);
					String Gstr1RespJsoninBase64 = new String(aesEncryption.decrypt(gstr1Data, apiEKGstr1));
					
					byte[] Gstr1RespJsonInBytes = aesEncryption.decodeBase64StringTOByte(Gstr1RespJsoninBase64);
					
					JSONObject Gstr1RespObj = new JSONObject(new String(Gstr1RespJsonInBytes));
					String transId = Gstr1RespObj.getString("reference_id");
					
					System.out.println("transId to getStatus["+transId+"]");
					
					while(true)
					{
						HttpResponse<JsonNode> retStatusResp = Unirest.get(String.format("%s/%s", GST_API_URL, GSTR1_URL))
															   .queryString("action","RETSTATUS")
															   .queryString("gstin", gstin)
															   .queryString("ret_period", periodCode)
															   .queryString("trans_id",transId)
															   .header("Content-Type", APPLICATION_JSON)
															   .header("state-cd", stateCode)
															   .header("clientid", clientId)
															   .header("client-secret", clientSecret)
															   .header("ip-usr", ipAddress.getHostAddress())
															   .header("username", userName)
															   .header("auth-token", authToken)
															   .header("app_key", appKeyEncryptedAndCoded)
															   .header("txn", transactionId)
															   .header("ret_period", periodCode)
															   .header("gstin", gstin)
															   .asJson();

						System.out.println(String.format("retStatusResp Request : Status[%s] Response[%s]", retStatusResp.getStatus(), retStatusResp.getBody()));

						if (retStatusResp.getStatus() == 200) 
						{
							JSONObject retStatsRespObj = retStatusResp.getBody().getObject();
							if(retStatsRespObj.has("data") && retStatsRespObj.has("rek"))
							{
								retStatsData = retStatsRespObj.getString("data");
								retStatsRek = retStatsRespObj.getString("rek");

								byte[] apiEKRetstats = aesEncryption.decrypt(retStatsRek, authSek);

								String retStatsRespJsoninBase64 = new String(aesEncryption.decrypt(retStatsData, apiEKRetstats));

								byte[] retStatsRespJsonInBytes = aesEncryption.decodeBase64StringTOByte(retStatsRespJsoninBase64);

								JSONObject retStatsJsonData = new JSONObject(new String(retStatsRespJsonInBytes));
								System.out.println( "retStatsJsonData["+retStatsJsonData+"]");
								
								if("IP".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
								{
									continue;
								}
								else if("P".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
								{
									break;
								}
								else if("PE".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
								{
									errMsg = getRetStatusErrMsg(retStatsJsonData);
									retString = getError(errMsg, "GSTAPIERR", conn);
									break;
								}
							}
							else
							{
								JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
								errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
								retString = getError(errMsg, "GSTAPIERR", conn);
							}
						}
						else
						{
							JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
							errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
							retString = getError(errMsg, "GSTAPIERR", conn);
						}
					}
				}
				else
	            {
					JSONObject errorJSON = gstr1Resp.getBody().getObject().getJSONObject("error");
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
            	JSONObject errorJSON = gstr1Resp.getBody().getObject().getJSONObject("error");
	        	errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }

		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.saveGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return retString;
	}
	private String getGstr1Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String action, Connection conn)
	{
		String retString = "";
		String errMsg = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		try
		{
			
			HttpResponse<JsonNode> getGstr1SumryResp = Unirest.get(String.format("%s/%s", GST_API_URL, GSTR1_URL))
													   .queryString("action","RETSUM")
													   .queryString("gstin", gstin)
													   .queryString("ret_period", periodCode)
													   .header("Content-Type", APPLICATION_JSON)
													   .header("state-cd", stateCode)
													   .header("clientid", clientId)
													   .header("client-secret", clientSecret)
													   .header("ip-usr", ipAddress.getHostAddress())
													   .header("username", userName)
													   .header("auth-token", authToken)
													   .header("app_key", appKeyEncryptedAndCoded)
													   .header("txn", transactionId)
													   .header("ret_period", periodCode)
													   .header("gstin", gstin)
													   .asJson();
			
			System.out.println(String.format("getGstr1SumryResp Request : Status[%s] Response[%s]", getGstr1SumryResp.getStatus(), getGstr1SumryResp.getBody()));
			
			if (getGstr1SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr1SumryRespObj = getGstr1SumryResp.getBody().getObject();
				if(getGstr1SumryRespObj.has("data") && getGstr1SumryRespObj.has("rek"))
				{
					String gstr1Sumrydata = getGstr1SumryRespObj.getString("data");
					String gstr1Sumryrek = getGstr1SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SumryJsonObj = new JSONObject(new String(respJsonInBytes));
					//String jsonData = new String(respJsonInBytes);
					System.out.println(gstr1SumryJsonObj);
					
					if("FILE".equalsIgnoreCase(action))
					{
						byte[] jsonBase64 = Base64.getEncoder().encode(gstr1SumryJsonObj.toString().getBytes());
						String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSek);
						
						HMac hmac = new HMac(new SHA256Digest());
						byte[] resBuf = new byte[hmac.getMacSize()];
						
						hmac.init(new KeyParameter(authSek));
						hmac.update(jsonBase64, 0, jsonBase64.length);
						hmac.doFinal(resBuf, 0);
						
						JSONObject fileGstr1DataJsonObj = new JSONObject();
						fileGstr1DataJsonObj.put("action", "RETFILE");
						fileGstr1DataJsonObj.put("data", encryptedPayload);
						fileGstr1DataJsonObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
						fileGstr1DataJsonObj.put("sign", "asfasfasfu3dsfkj3kjdv=");
						fileGstr1DataJsonObj.put("st", "DSC");
						fileGstr1DataJsonObj.put("sid", "AMAPT8269L");
						
						HttpResponse<JsonNode> fileGstr1Resp = Unirest.post(String.format("%s/%s", GST_API_URL, GSTR1_URL))
															   .header("Content-Type", APPLICATION_JSON)
															   .header("state-cd", stateCode)
															   .header("clientid", clientId)
															   .header("client-secret", clientSecret)
															   .header("ip-usr", ipAddress.getHostAddress())
															   .header("username", userName)
															   .header("auth-token", authToken)
															   .header("app_key", appKeyEncryptedAndCoded)
															   .header("txn", transactionId)
															   .header("ret_period", periodCode)
															   .header("gstin", gstin)
															   .body(new JsonNode(fileGstr1DataJsonObj.toString()))
															   .asJson();
						
						System.out.println(String.format("fileGstr1Resp Request : Status[%s] Response[%s]", fileGstr1Resp.getStatus(), fileGstr1Resp.getBody()));
						if (fileGstr1Resp.getStatus() == 200) 
				        {
							JSONObject fileGstr1RespObj = fileGstr1Resp.getBody().getObject();
							if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
							{
								String fileGstr1Data = fileGstr1RespObj.getString("data");
								String fileGstr1Rek = fileGstr1RespObj.getString("rek");
								
								byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSek);
								
								String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));
								
								byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);
								
								System.out.println(new String(fileGstr1JsonInBytes));
							}
							else
							{
								JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
					        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					        	retString = getError(errMsg, "GSTAPIERR", conn);
							}
				        }
						else
						{
							JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
				        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				        	retString = getError(errMsg, "GSTAPIERR", conn);
						}
					}
				}
				else
	            {
					JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
            	JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
            	errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr1Summary()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return retString;
	}
	
	private String submitGstr1(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSEK, Connection conn)
	{
		String retString = "";
		String errMsg = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		try
		{
			
			String json = "{\"gstin\":\""+gstin+"\",\"ret_period\":\""+periodCode+"\"}";
            
            byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
            
			JSONObject reqBody = new JSONObject();
            reqBody.put("action", "RETSUBMIT");
            reqBody.put("data", encryptedPayload);
            reqBody.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
            
            HttpResponse<JsonNode> gstr1SubmitResp = Unirest.post(String.format("%s/%s", GST_API_URL, GSTR1_URL))
            										.header("Content-Type", APPLICATION_JSON)
            										.header("action", "RETSUBMIT")
            				                        .header("state-cd", stateCode)
            				                        .header("clientid", clientId)
            				                        .header("client-secret", clientSecret)
            				                        .header("ip-usr", ipAddress.getHostAddress())
            				                        .header("username", userName)
            				                        .header("auth-token", authToken)
            				                        .header("app_key", appKeyEncryptedAndCoded)
            				                        .header("txn", transactionId)
            				                        .header("ret_period", periodCode)
            				                        .header("gstin", gstin)
            				                        .body(new JsonNode(reqBody.toString()))
            				                        .asJson();
            
            System.out.println(String.format("gstr1SubmitResp Request : Status[%s] Response[%s]", gstr1SubmitResp.getStatus(), gstr1SubmitResp.getBody()));
            
            if (gstr1SubmitResp.getStatus() == 200) 
	        {
				JSONObject gstr1SubmitRespObj = gstr1SubmitResp.getBody().getObject();
				if(gstr1SubmitRespObj.has("data") && gstr1SubmitRespObj.has("rek"))
				{
					String gstr1Submitdata = gstr1SubmitRespObj.getString("data");
					String gstr1Submitrek = gstr1SubmitRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Submitrek, authSEK);
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Submitdata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SubmitObj = new JSONObject(new String(respJsonInBytes));
					String transId = gstr1SubmitObj.getString("reference_id");
					
					System.out.println("transId to getStatus after SUBMIT call["+transId+"]");
				}
				else
	            {
					JSONObject errorJSON = gstr1SubmitResp.getBody().getObject().getJSONObject("error");
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
            	JSONObject errorJSON = gstr1SubmitResp.getBody().getObject().getJSONObject("error");
            	errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.submitGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return retString;
	}
	
	private String getGstr2Invoices(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSEK, Connection conn)
	{
		String retString = "";
		String errMsg = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		
		try
		{
			 HttpResponse<JsonNode> getGstr2InvoicesResp = Unirest.get(String.format("%s/%s", GST_API_URL, GSTR2_URL))
						     				  		   	   .queryString("action", "B2B")
						     				  		   	   .queryString("gstin", gstin)
						     				  		   	   .queryString("ret_period", periodCode)
						     				  		   	   .header("Content-Type", APPLICATION_JSON)
						     				  		   	   .header("state-cd", stateCode)
						     				  		   	   .header("clientid", clientId)
						     				  		   	   .header("client-secret", clientSecret)
						     				  		   	   .header("ip-usr", ipAddress.getHostAddress())
						     				  		   	   .header("username", userName)
						     				  		   	   .header("auth-token", authToken)
						     				  		   	   .header("app_key", appKeyEncryptedAndCoded)
						     				  		   	   .header("txn", transactionId)
						     				  		   	   .header("ret_period", periodCode)
						     				  		   	   .header("gstin", gstin)
						     				  		   	   .asJson();
			 
			 System.out.println(String.format("getGstr2InvoicesResp Request : Status[%s] Response[%s]", getGstr2InvoicesResp.getStatus(), getGstr2InvoicesResp.getBody()));
			 
			 if (getGstr2InvoicesResp.getStatus() == 200) 
			 {
				 JSONObject getGstr2InvoicesRespObj = getGstr2InvoicesResp.getBody().getObject();
				 if(getGstr2InvoicesRespObj.has("data") && getGstr2InvoicesRespObj.has("rek"))
				 {
					 String gstr2InvoicesData = getGstr2InvoicesRespObj.getString("data");
					 String gstr2InvoicesRek = getGstr2InvoicesRespObj.getString("rek");

					 byte[] apiEK = aesEncryption.decrypt(gstr2InvoicesRek, authSEK);
					 String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2InvoicesData, apiEK));

					 byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					 
					 JSONObject gstr2InvoiceJsonObj = new JSONObject(new String(respJsonInBytes));

					 System.out.println("respJsonInBytes["+new String(respJsonInBytes)+"]");

				 }
				 else
				 {
					 JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
					 errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					 retString = getError(errMsg, "GSTAPIERR", conn);
				 }

			 }
			 else
			 {
				 JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
				 errMsg = "Message : "+errorJSON.getString("desc")+" \nError code : "+errorJSON.getString("code");
				 retString = getError(errMsg, "GSTAPIERR", conn);
			 }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr2Invoices()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return retString;
	}
	
	private String getError(String errMsg, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			mainStr = checkNullandTrim(begPart) + "<![CDATA[" +errMsg+ " ]]>" + checkNullandTrim(endDesc);
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	private String getRetStatusErrMsg(JSONObject retStatusJsonObj)
	{
		String retString = "";
		JSONObject errorJsonObj = null;
		JSONArray eachInvErrorJsonArry = null;
		
		try
		{
			errorJsonObj = retStatusJsonObj.getJSONObject("error_report");
			
			if(errorJsonObj.has("b2b"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2b");
			}
			else if(errorJsonObj.has("b2ba"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2ba");
			}
			else if(errorJsonObj.has("b2cl"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cl");
			}
			else if(errorJsonObj.has("b2cla"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cla");
			}
			else if(errorJsonObj.has("b2cs"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cs");
			}
			else if(errorJsonObj.has("b2csa"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2csa");
			}
			else if(errorJsonObj.has("cdnr"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("cdnr");
			}
			else if(errorJsonObj.has("cdnra"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("cdnra");
			}
			
			
			for(int i=0; i<eachInvErrorJsonArry.length(); i++)
			{
				JSONObject tempJsonObj = (JSONObject) eachInvErrorJsonArry.get(i); 
				retString += tempJsonObj.getString("error_msg")+"\n";
				if(tempJsonObj.has("ty") && tempJsonObj.has("hsn_sc"))
				{
					retString += " Line Type : "+tempJsonObj.optString("ty")+ " Item/Service Code : "+tempJsonObj.optString("hsn_sc")+"\n";
				}
				else if(tempJsonObj.has("nt_num") && tempJsonObj.has("nt_dt"))
				{
					retString += " Credit/Debit No. : "+tempJsonObj.optString("nt_num")+ " Credit/Debit Dt. : "+tempJsonObj.optString("nt_dt")+"\n";
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getRetStatusErrMsg()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private static String checkNullandTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

}
