package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import java.text.SimpleDateFormat;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; 

@Stateless 
public class LoanPartyIC extends ValidatorEJB implements LoanPartyICLocal, LoanPartyICRemote 
{
	//changes and commented by sarita on 01/06/2017
	//E12GenericUtility genericUtility = new E12GenericUtility();
	GenericUtility genericUtility = GenericUtility.getInstance();
	FinCommon finCommon = new FinCommon();

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);	
		}
		catch(Exception e)
		{
			System.out.println("Exception : [LoanPartyIC][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		int currentFormNo = 0;
	    int ctr = 0;
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null ;
        NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String mcode = "";
		ConnDriver connDriver = new ConnDriver();
		String code="",tempCode="",descr = "";
		try
		{  
			
			//changes and commented by sarita for DBConnection on 01/06/2017
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			//conn = getConnection(); 
			//changes and commented by sarita for DBConnection on 01/06/2017
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext.trim());
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			System.out.println("**********ITEMCHANGE FOR CASE" + currentFormNo + "**************");
				switch (currentFormNo)
				{
					case 1:
					{
						parentNodeList = dom.getElementsByTagName("Detail1");
						parentNode = parentNodeList.item(0);
						childNodeList = parentNode.getChildNodes();
						ctr = 0;
						valueXmlString.append("<Detail1>");
						if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					    {
							code = genericUtility.getColumnValue("party_code", dom);
							tempCode = genericUtility.getColumnValue("group_code", dom);
							if(tempCode == null || tempCode.trim().length() == 0 )
							{
								valueXmlString.append("<group_code>").append("<![CDATA[" + checkNull(code) + "]]>").append("</group_code>");
							}
							
							code =genericUtility.getColumnValue("contact_code", dom);
							 sql = "select cont_pers,cont_pfx,sh_name,name, addr1,addr2,addr3,city,pin, "
								 + " state_code, count_code,tele1,tele2,tele3,tele_ext,fax,email_addr,edi_addr "
								 + " from contact where contact_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr =genericUtility.getColumnValue("cont_pers", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("cont_pers");
									 valueXmlString.append("<cont_pers>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</cont_pers>");
								 }
		
								 descr =genericUtility.getColumnValue("cont_pfx", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("cont_pfx");
									 valueXmlString.append("<cont_pfx>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</cont_pfx>");
								 }
								
								 descr =genericUtility.getColumnValue("chq_name", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("name");
									 valueXmlString.append("<chq_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</chq_name>");
								 }
								 
								 descr =genericUtility.getColumnValue("sh_name", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("sh_name");
									 valueXmlString.append("<sh_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</sh_name>");
								 }
								
								 descr =genericUtility.getColumnValue("party_name", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("name");
									 valueXmlString.append("<party_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</party_name>");
								 }
								 
								 descr =genericUtility.getColumnValue("addr1", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("addr1");
									 valueXmlString.append("<addr1>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</addr1>");
								 }
								 
								 descr =genericUtility.getColumnValue("addr2", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("addr2");
									 valueXmlString.append("<addr2>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</addr2>");
								 }
								 
								 descr =genericUtility.getColumnValue("addr3", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("addr3");
									 valueXmlString.append("<addr3>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</addr3>");
								 }
								 
								 descr =genericUtility.getColumnValue("city", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("city");
									 valueXmlString.append("<city>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</city>");
								 }
								 
								 descr =genericUtility.getColumnValue("pin", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("pin");
									 valueXmlString.append("<pin>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</pin>");
								 }
								 
								 descr =genericUtility.getColumnValue("state_code", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("state_code");
									 valueXmlString.append("<state_code>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_code>");
									 System.out.println("Inside state_code");
									 sql = "select descr from state where state_code = ? ";
									 pstmt1 =  conn.prepareStatement(sql);
									 pstmt1.setString(1,descr);
									 rs1 = pstmt1.executeQuery();
									 if(rs1.next())
									 {
										 descr = rs1.getString("descr");
										 valueXmlString.append("<state_a_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_a_descr>");
									 }
									 if(pstmt1 != null)
									 {
										pstmt1.close(); 
										pstmt1 = null;
									 }
									 if(rs1 != null)
									 {
										rs1.close();
										rs1 = null;
									 }	
								 }	
								 
								 descr =genericUtility.getColumnValue("count_code", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("count_code");
									 valueXmlString.append("<count_code>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</count_code>");
								 }
								 
								 descr =genericUtility.getColumnValue("tele1", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele1");
									 valueXmlString.append("<tele1>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele1>");
								 }
								 
								 descr =genericUtility.getColumnValue("tele2", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele2");
									 valueXmlString.append("<tele2>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele2>");
								 }
								 
								 descr =genericUtility.getColumnValue("tele3", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele3");
									 valueXmlString.append("<tele3>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele3>");
								 }
								
								 descr =genericUtility.getColumnValue("tele_ext", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele_ext");
									 valueXmlString.append("<tele_ext>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele_ext>");
								 }
								 
								 descr =genericUtility.getColumnValue("fax", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("fax");
									 valueXmlString.append("<fax>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</fax>");
								 }
								 
								 descr =genericUtility.getColumnValue("email_addr", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("email_addr");
									 valueXmlString.append("<email_addr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</email_addr>");
								 }
								 
								 descr =genericUtility.getColumnValue("edi_addr", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("edi_addr");
									 valueXmlString.append("<edi_addr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</edi_addr>");
								 }
								 
								 descr =genericUtility.getColumnValue("curr_code", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("count_code");
									 sql = "select curr_code from country where count_code = ?";
									 pstmt1 =  conn.prepareStatement(sql);
									 pstmt1.setString(1,descr);
									 rs1 = pstmt1.executeQuery();
									 if(rs1.next())
									 {
										 descr = rs1.getString("curr_code");
										 valueXmlString.append("<curr_code>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</curr_code>");
									 }
									 if(pstmt != null)
									 {
								        pstmt.close(); 
										pstmt = null;
									 }
									 if(rs != null)
									 {
									 	rs.close();
									 	rs = null;
									 }	
								 }
							 }
							
							 code =genericUtility.getColumnValue("stan_code", dom);
							 sql = "select descr, state_code from station where stan_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr = rs.getString("descr");
								 valueXmlString.append("<station_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</station_descr>");
								 tempCode = rs.getString("state_code");
								 sql = "select descr, count_code from state where state_code = ?";
								 pstmt1 =  conn.prepareStatement(sql);
								 pstmt1.setString(1,tempCode);
								 rs1 = pstmt1.executeQuery();
								 if(rs1.next())
								 {
									 descr = rs1.getString("descr");
									 tempCode = rs1.getString("count_code");
									 valueXmlString.append("<state_a_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_a_descr>");
									 valueXmlString.append("<count_code>").append("<![CDATA[" + checkNull(tempCode) + "]]>").append("</count_code>");
								 }
								 if(pstmt != null)
								 {
								 	pstmt.close(); 
									pstmt = null;
								 }
								 if(rs != null)
								 {
									rs.close();
									rs = null;
								 }		
							 }
							 

							 code =genericUtility.getColumnValue("state_code__reg", dom);
							 System.out.println("Inside state_code__reg");
							 sql = "select descr from state where state_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr = rs.getString("descr");
								 valueXmlString.append("<state_b_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_b_descr>");
							 }
							 if(pstmt != null)
							 {
							 	pstmt.close(); 
								pstmt = null;
							 }
							 if(rs != null)
							 {
								rs.close();
								rs = null;
							 }			
							 
							 code =genericUtility.getColumnValue("bank_code", dom);
							 sql = "select bank_name from bank where bank_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr = rs.getString("bank_name");
								 valueXmlString.append("<bank_bank_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</bank_bank_name>");
							 }
							 if(pstmt != null)
							 {
							 	pstmt.close(); 
								pstmt = null;
							 }
							 if(rs != null)
							 {
								rs.close();
								rs = null;
							 }	
							 
							 code =genericUtility.getColumnValue("channel_partner", dom);
							 tempCode =genericUtility.getColumnValue("site_code", dom);
							 if ("N".equals(code))
							 {
								 valueXmlString.append("<site_code protect =\"1\">").append("<![CDATA[]]>").append("</site_code>");
							 }
							 else
							 {
								 valueXmlString.append("<site_code protect =\"0\">").append("<![CDATA[]]>").append("</site_code>");
							 }
						}
						else if(currentColumn.trim().equalsIgnoreCase("party_code"))
						{
							code = genericUtility.getColumnValue("party_code", dom);
							tempCode = genericUtility.getColumnValue("group_code", dom);
							if(tempCode == null || tempCode.trim().length() == 0 )
							{
								valueXmlString.append("<group_code>").append("<![CDATA[" + checkNull(code) + "]]>").append("</group_code>");
							}
							
						 }
						 else if(currentColumn.trim().equalsIgnoreCase("contact_code"))	
						 {
							 code =genericUtility.getColumnValue("contact_code", dom);
							 sql = "select cont_pers,cont_pfx,sh_name,name, addr1,addr2,addr3,city,pin, "
								 + " state_code, count_code,tele1,tele2,tele3,tele_ext,fax,email_addr,edi_addr "
								 + " from contact where contact_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr =genericUtility.getColumnValue("cont_pers", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("cont_pers");
									 valueXmlString.append("<cont_pers>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</cont_pers>");
								 }
		
								 descr =genericUtility.getColumnValue("cont_pfx", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("cont_pfx");
									 valueXmlString.append("<cont_pfx>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</cont_pfx>");
								 }
								
								 descr =genericUtility.getColumnValue("chq_name", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("name");
									 valueXmlString.append("<chq_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</chq_name>");
								 }
								 
								 descr =genericUtility.getColumnValue("sh_name", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("sh_name");
									 valueXmlString.append("<sh_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</sh_name>");
								 }
								
								 descr =genericUtility.getColumnValue("party_name", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("name");
									 valueXmlString.append("<party_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</party_name>");
								 }
								 
								 descr =genericUtility.getColumnValue("addr1", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("addr1");
									 valueXmlString.append("<addr1>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</addr1>");
								 }
								 
								 descr =genericUtility.getColumnValue("addr2", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("addr2");
									 valueXmlString.append("<addr2>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</addr2>");
								 }
								 
								 descr =genericUtility.getColumnValue("addr3", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("addr3");
									 valueXmlString.append("<addr3>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</addr3>");
								 }
								 
								 descr =genericUtility.getColumnValue("city", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("city");
									 valueXmlString.append("<city>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</city>");
								 }
								 
								 descr =genericUtility.getColumnValue("pin", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("pin");
									 valueXmlString.append("<pin>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</pin>");
								 }
								 
								 descr =genericUtility.getColumnValue("state_code", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("state_code");
									 valueXmlString.append("<state_code>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_code>");
									 System.out.println("Inside state_code");
									 sql = "select descr from state where state_code = ? ";
									 pstmt1 =  conn.prepareStatement(sql);
									 pstmt1.setString(1,descr);
									 rs1 = pstmt1.executeQuery();
									 if(rs1.next())
									 {
										 descr = rs1.getString("descr");
										 valueXmlString.append("<state_a_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_a_descr>");
									 }
									 if(pstmt1 != null)
									 {
										pstmt1.close(); 
										pstmt1 = null;
									 }
									 if(rs1 != null)
									 {
										rs1.close();
										rs1 = null;
									 }	
								 }	
								 
								 descr =genericUtility.getColumnValue("count_code", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("count_code");
									 valueXmlString.append("<count_code>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</count_code>");
								 }
								 
								 descr =genericUtility.getColumnValue("tele1", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele1");
									 valueXmlString.append("<tele1>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele1>");
								 }
								 
								 descr =genericUtility.getColumnValue("tele2", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele2");
									 valueXmlString.append("<tele2>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele2>");
								 }
								 
								 descr =genericUtility.getColumnValue("tele3", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele3");
									 valueXmlString.append("<tele3>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele3>");
								 }
								
								 descr =genericUtility.getColumnValue("tele_ext", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("tele_ext");
									 valueXmlString.append("<tele_ext>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</tele_ext>");
								 }
								 
								 descr =genericUtility.getColumnValue("fax", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("fax");
									 valueXmlString.append("<fax>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</fax>");
								 }
								 
								 descr =genericUtility.getColumnValue("email_addr", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("email_addr");
									 valueXmlString.append("<email_addr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</email_addr>");
								 }
								 
								 descr =genericUtility.getColumnValue("edi_addr", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("edi_addr");
									 valueXmlString.append("<edi_addr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</edi_addr>");
								 }
								 
								 descr =genericUtility.getColumnValue("curr_code", dom);
								 if(descr == null || descr.trim().length() == 0 )
								 {
									 descr = rs.getString("count_code");
									 sql = "select curr_code from country where count_code = ?";
									 pstmt1 =  conn.prepareStatement(sql);
									 pstmt1.setString(1,descr);
									 rs1 = pstmt1.executeQuery();
									 if(rs1.next())
									 {
										 descr = rs1.getString("curr_code");
										 valueXmlString.append("<curr_code>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</curr_code>");
									 }
									 if(pstmt != null)
									 {
								        pstmt.close(); 
										pstmt = null;
									 }
									 if(rs != null)
									 {
									 	rs.close();
									 	rs = null;
									 }	
								 }
							 }
							 if(pstmt != null)
							 {
							 	pstmt.close(); 
								pstmt = null;
							 }
							 if(rs != null)
							 {
								rs.close();
								rs = null;
							 }	
						 }// end of if block for contact_code
						 else if(currentColumn.trim().equalsIgnoreCase("stan_code"))	
						 {
							 code =genericUtility.getColumnValue("stan_code", dom);
							 sql = "select descr, state_code from station where stan_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr = rs.getString("descr");
								 valueXmlString.append("<station_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</station_descr>");
								 tempCode = rs.getString("state_code");
								 sql = "select descr, count_code from state where state_code = ?";
								 pstmt1 =  conn.prepareStatement(sql);
								 pstmt1.setString(1,tempCode);
								 rs1 = pstmt1.executeQuery();
								 if(rs1.next())
								 {
									 descr = rs1.getString("descr");
									 tempCode = rs1.getString("count_code");
									 valueXmlString.append("<state_a_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_a_descr>");
									 valueXmlString.append("<count_code>").append("<![CDATA[" + checkNull(tempCode) + "]]>").append("</count_code>");
								 }
								 if(pstmt != null)
								 {
								 	pstmt.close(); 
									pstmt = null;
								 }
								 if(rs != null)
								 {
									rs.close();
									rs = null;
								 }		
							 }
							 if(pstmt != null)
							 {
							 	pstmt.close(); 
								pstmt = null;
							 }
							 if(rs != null)
							 {
								rs.close();
								rs = null;
							 }				
						 }
						 else if(currentColumn.trim().equalsIgnoreCase("state_code__reg"))	
						 {
							 code =genericUtility.getColumnValue("state_code__reg", dom);
							 System.out.println("Inside state_code__reg");
							 sql = "select descr from state where state_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr = rs.getString("descr");
								 valueXmlString.append("<state_b_descr>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</state_b_descr>");
							 }
							 if(pstmt != null)
							 {
							 	pstmt.close(); 
								pstmt = null;
							 }
							 if(rs != null)
							 {
								rs.close();
								rs = null;
							 }			
						 }
						 else if(currentColumn.trim().equalsIgnoreCase("bank_code"))	
						 {
							 code =genericUtility.getColumnValue("bank_code", dom);
							 sql = "select bank_name from bank where bank_code = ? ";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,code);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
								 descr = rs.getString("bank_name");
								 valueXmlString.append("<bank_bank_name>").append("<![CDATA[" + checkNull(descr) + "]]>").append("</bank_bank_name>");
							 }
							 if(pstmt != null)
							 {
							 	pstmt.close(); 
								pstmt = null;
							 }
							 if(rs != null)
							 {
								rs.close();
								rs = null;
							 }				
						 }
						 else if(currentColumn.trim().equalsIgnoreCase("channel_partner"))	
						 {
							 code =genericUtility.getColumnValue("channel_partner", dom);
							 tempCode =genericUtility.getColumnValue("site_code", dom);
							 if ("N".equals(code))
							 {
								 valueXmlString.append("<site_code protect =\"1\">").append("<![CDATA[]]>").append("</site_code>");
							 }
							 else
							 {
								 valueXmlString.append("<site_code protect =\"0\">").append("<![CDATA[]]>").append("</site_code>");
							 }
						 }
						valueXmlString.append("</Detail1>");
						break;  //end case 1 for itemchange.				   
					}
				}
				valueXmlString.append("</Root>");
			}// end of try block
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception ::"+ e.getMessage());
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
					pstmt.close();
					pstmt = null;
					}					
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
					connDriver = null;
				}
				catch(Exception d)
				{
					d.printStackTrace();
				}			
			}// end of finally statement
			return valueXmlString.toString();
		}	 
	
	private String checkNull(String input) 
	{
		return input == null ? "" : input;
	}
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		try
		{
			if(xmlString != null && xmlString.trim().length() > 0)
			   {
				  dom =  genericUtility.parseString(xmlString);
			   }
			   if(xmlString1 != null && xmlString1.trim().length() > 0)
			   {
				   dom1 = genericUtility.parseString(xmlString1);
			   }
			   if(xmlString2 != null && xmlString2.trim().length() > 0)
			   {
				   dom2 = genericUtility.parseString(xmlString2);
			   }
			   errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			   System.out.println("retString:::"+errString);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		int cnt = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;		
		String siteCode = "";
		String userId = "";
		String sql="";
		String errCode="";
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		String existFlag = "";
		String contact_code = "",party_name = "",party_type = "",group_code = "",party_code = "",state_code="";
		String stan_code = "",count_code = "",state_code__reg="",bank_code="",int_term="",int_term__penalty="";
		String chq_name="",acct_code__ar="",modName="",acct_code__ap="",acct_code__ap_adv="",cctr_code__ar="";
		String cctr_code__ap="",cctr_code__ap_adv="",site_code="",channel_partner="",curr_code="",loginSiteCode;
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			SimpleDateFormat sdf1= new SimpleDateFormat(genericUtility.getDBDateFormat());
			//changes and commented by sarita for DBConnection on 01/06/2017 
			conn = connDriver.getConnectDB("DriverITM");
			//conn = getConnection();
			//changes and commented by sarita for DBConnection on 01/06/2017 
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch (currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr ++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("site_code"))
						{    
							siteCode = genericUtility.getColumnValue("site_code", dom);
							if(editFlag.equals("A"))
							{
								if(siteCode!= null && siteCode.trim().length() > 0)
								{
									existFlag = isExist("site", "site_code", siteCode, conn);
									if ("TRUE".equals(existFlag))
									{
										errCode = "VTDUPSITCD";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								else
								{
									errCode = "VMSITECD";  //VESIT2 
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for site_code	
						else if("contact_code".equalsIgnoreCase(childNodeName))
						{
							contact_code = checkNull(genericUtility.getColumnValue("contact_code", dom)).trim();
							if(contact_code == null || contact_code.trim().length() ==0)
							{
								errCode = "VMCONTACD";  
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = "select count(*) as cnt from contact where contact_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,contact_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMCONTACT1";  
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for contact_code
						else if("party_code".equalsIgnoreCase(childNodeName))
						{
							party_code = checkNull(genericUtility.getColumnValue("party_code",dom)).trim();
							if(party_code == null || party_code.trim().length() == 0)
							{
								errCode = "VMPARTY1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for party_code
						else if("party_name".equalsIgnoreCase(childNodeName))
						{
							party_name = checkNull(genericUtility.getColumnValue("party_name",dom)).trim();
							if(party_name == null || party_name.trim().length() == 0)
							{
								errCode = "VMPARTYNM";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for party_name
						else if("party_type".equalsIgnoreCase(childNodeName))
						{
							party_type = checkNull(genericUtility.getColumnValue("party_type",dom)).trim();
							if(party_type == null || party_type.trim().length() == 0)
							{
								errCode = "VMPARTYTP";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for party_type
						else if("group_code".equalsIgnoreCase(childNodeName))
						{
							group_code = checkNull(genericUtility.getColumnValue("group_code",dom)).trim();
							if(group_code == null || group_code.trim().length() == 0)
							{
								errCode = "VMGRPCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								party_code = checkNull(genericUtility.getColumnValue("party_code",dom)).trim();
								if(!(party_code.equalsIgnoreCase(group_code)))
								{
									sql = "select count(*) as cnt from loanparty where party_code =?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, party_code);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
										pstmt.close(); 
										pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
								
									if(cnt == 0)
									{
										errCode = "VMGRPCD1";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}	
						}// end of if block for group_code
						else if("state_code".equalsIgnoreCase(childNodeName))
						{
							state_code = checkNull(genericUtility.getColumnValue("state_code",dom)).trim();
							if(state_code == null || state_code.trim().length() == 0)
							{
								errCode = "VMSTAT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = "select count(*) as cnt from state where state_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, state_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMSTATE1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for state_code
						else if("stan_code".equalsIgnoreCase(childNodeName))
						{
							stan_code = checkNull(genericUtility.getColumnValue("stan_code",dom)).trim();
							if(stan_code == null || stan_code.trim().length() == 0)
							{
								errCode = "VMSTAT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = "select count(*) as cnt from station where stan_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, stan_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMSTAN1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for stan_code
						else if("count_code".equalsIgnoreCase(childNodeName))
						{
							count_code = checkNull(genericUtility.getColumnValue("count_code",dom)).trim();
							if(count_code == null || count_code.trim().length() == 0)
							{
								errCode = "VMCOUNT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = "select count(*) as cnt from country where count_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, count_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMCOUNT";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for count_code
						else if("state_code__reg".equalsIgnoreCase(childNodeName))
						{
							state_code__reg = checkNull(genericUtility.getColumnValue("state_code__reg",dom)).trim();
							
							sql = "select count(*) as cnt from state where state_code =?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, state_code__reg);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								rs.getInt("cnt");
							}
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}
						
							if(cnt == 0)
							{
								errCode = "VMSTATE1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for state_code__reg
						else if("bank_code".equalsIgnoreCase(childNodeName))
						{
							bank_code = checkNull(genericUtility.getColumnValue("bank_code",dom)).trim();
							if(bank_code != null || bank_code.trim().length() > 0)
							{
								sql = "select count(*) as cnt from bank where bank_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, bank_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMBANK";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for bank_code
						else if("int_term".equalsIgnoreCase(childNodeName))
						{
							int_term = checkNull(genericUtility.getColumnValue("int_term",dom)).trim();
							int_term__penalty = checkNull(genericUtility.getColumnValue("int_term__penalty",dom)).trim();
							sql = "select count(*) as cnt from interestterm where int_term =?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, int_term);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}
						
							if(cnt == 0)
							{
								errCode = "VMINT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for int_term
						else if("int_term__penalty".equalsIgnoreCase(childNodeName))
						{
							int_term__penalty = checkNull(genericUtility.getColumnValue("int_term__penalty",dom)).trim();
							sql = "select count(*) as cnt from interestterm where int_term =?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, int_term__penalty);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt("cnt");
							}
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}
						
							if(cnt == 0)
							{
								errCode = "VMINT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for int_term__penalty
						else if("curr_code".equalsIgnoreCase(childNodeName))
						{
							curr_code = checkNull(genericUtility.getColumnValue("curr_code",dom)).trim();
							if(curr_code == null || curr_code.trim().length() == 0)
							{
								errCode = "VMCURR1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = "select count(*) as cnt from currency where curr_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, curr_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMCURR";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for curr_code
						else if("chq_name".equalsIgnoreCase(childNodeName))
						{
							chq_name = checkNull(genericUtility.getColumnValue("chq_name",dom)).trim();
							if(chq_name == null || chq_name.trim().length() == 0)
							{
								errCode = "VMCHQNAME";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for chq_name
						else if("acct_code__ar".equalsIgnoreCase(childNodeName))
						{
							acct_code__ar = checkNull(genericUtility.getColumnValue("acct_code__ar",dom)).trim();
							loginSiteCode = (genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
							errCode = finCommon.isAcctCode(loginSiteCode, acct_code__ar, modName, conn);
							if(!("".equals(errCode)))
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for acct_code__ar
						else if("acct_code__ap".equalsIgnoreCase(childNodeName))
						{
							acct_code__ap = checkNull(genericUtility.getColumnValue("acct_code__ap",dom)).trim();
							loginSiteCode = (genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
							errCode = finCommon.isAcctCode(loginSiteCode, acct_code__ap, modName, conn);
							if(!("".equals(errCode)))
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for acct_code__ap
						else if("acct_code__ap_adv".equalsIgnoreCase(childNodeName))
						{
							acct_code__ap_adv = checkNull(genericUtility.getColumnValue("acct_code__ap_adv",dom)).trim();
							loginSiteCode = (genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
							errCode = finCommon.isAcctCode(loginSiteCode, acct_code__ap_adv, modName, conn);
							if(!("".equals(errCode)))
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}// end of if block for acct_code__ap_adv
						else if("cctr_code__ar".equalsIgnoreCase(childNodeName))
						{
							cctr_code__ar = checkNull(genericUtility.getColumnValue("cctr_code__ar",dom)).trim();
							if(cctr_code__ar != null && cctr_code__ar.trim().length() > 0)
							{
								acct_code__ar = checkNull(genericUtility.getColumnValue("acct_code__ar",dom)).trim();
								errCode = finCommon.isCctrCode(acct_code__ar, cctr_code__ar, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for cctr_code__ar
						else if("cctr_code__ap".equalsIgnoreCase(childNodeName))
						{
							cctr_code__ap = checkNull(genericUtility.getColumnValue("cctr_code__ap",dom)).trim();
							if(cctr_code__ap != null && cctr_code__ap.trim().length() > 0)
							{
								acct_code__ap = checkNull(genericUtility.getColumnValue("acct_code__ap",dom)).trim();
								errCode = finCommon.isCctrCode(acct_code__ap, cctr_code__ap, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for cctr_code__ap
						else if("cctr_code__ap_adv".equalsIgnoreCase(childNodeName))
						{
							cctr_code__ap_adv = checkNull(genericUtility.getColumnValue("cctr_code__ap_adv",dom)).trim();
							if(cctr_code__ap_adv != null && cctr_code__ap_adv.trim().length() > 0)
							{
								acct_code__ap_adv = checkNull(genericUtility.getColumnValue("acct_code__ap_adv",dom)).trim();
								errCode = finCommon.isCctrCode(acct_code__ap_adv, cctr_code__ap_adv, modName, conn);
							}
						}// end of if block for cctr_code__ap_adv
						else if("site_code".equalsIgnoreCase(childNodeName))
						{
							site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
							channel_partner = checkNull(genericUtility.getColumnValue("channel_partner",dom)).trim();
							if("Y".equalsIgnoreCase(channel_partner))
							{
								sql = "select count(*) as cnt from site where site_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, site_code);
								rs = pstmt.executeQuery();
							
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}	
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
							
								if(cnt == 0)
								{
									errCode = "VMSITE";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}// end of if block for site_code 
					}
				}// end of case1
				break; 
			}// end of switch statement 			
			int errListSize = errList.size();
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				connDriver = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		System.out.println("testing : final errString : " + errString);
		return errString;
	}//end of validation
	
	private String isExist(String table, String field, String value, Connection conn) throws SQLException

	{
		String sql = "", retStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int cnt = 0;

		sql = " SELECT COUNT(1) FROM " + table + " WHERE " + field + " = ? ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, value);
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			cnt = rs.getInt(1);
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;
		if (cnt > 0)
		{
			retStr = "TRUE";
		}
		if (cnt == 0)
		{
			retStr = "FALSE";
		}
		System.out.println("@@@@ isexist[" + value + "]:::[" + retStr + "]:::[" + cnt + "]");
		return retStr;
	}
	
	private String findValue(Connection conn, String columnName, String tableName, String columnName2, String value) throws ITMException, RemoteException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String findValue = "";
		try
		{
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 + "= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, value);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (findValue == null || findValue.trim().length()== 0)
			{
				findValue = "";
			}
		} 
		catch (Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}	
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
}  


