package ibase.dashboard.sfa.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class RSRScoreEJB extends ValidatorEJB implements RSRScoreRemote, RSRScoreLocal
{
	public RSRScoreEJB()
	{}
	@SuppressWarnings("unchecked")
	@Override
    public JSONObject getRSRScoreDetails(String salesPerson, String month, String year,String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashbordUtil = null;
		
		
		try
		{
			System.out.println(" Inside RSRScoreEJB for Data Soruc Name ="+dataSourceName+" salesPerson is =" + salesPerson +" month is =" + month +" year is =" + year);
			dashbordUtil = new DashboardUtility();
			salesPerson= dashbordUtil.getCommaSeparated(salesPerson);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			
			sql = 	" Select station.descr as territory, RSR_SCORE.insight_id as insight_id, RSR_SCORE.rep_name as sales_pers, "  +
					" sum(field_working_days) as field_working_days, sum(target_outlets) as target_outlets,  "  +
					" sum(chemist_call) as chemist_call, sum(total_coverage) as total_coverage,  "  +
					" sum(productive_coverage) as productive_coverage,  "  +
					" round((case when sum(field_working_days)=0 then 0 else sum(chemist_call)/sum(field_working_days) end),2) as call_average,  "  +
					" round((case when sum(target_outlets) =0 then 0 else (sum(total_coverage)/sum(target_outlets))*100  end ),0)as  TC_PER,   "  +
					" round((case when sum(target_outlets)=0 then 0 else (sum(productive_coverage)/sum(target_outlets))*100 end ),0) as  PC_PER  "  +
					" FROM ( select A.SALES_PERS as insight_id, A.SP_NAME as rep_name,  "  +
					" sum(case when upper(A.descr) like upper('%HALF%') then 0.5 else 1 end)as field_working_days, 0 as target_outlets,  "  +
					" 0 as chemist_call, 0 as total_coverage, 0 as productive_coverage  "  +
					" FROM ( SELECT DISTINCT SM.EVENT_DATE, S.SALES_PERS, S.SP_NAME , FA.descr  "  +
					" FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS  "  +
					" JOIN (select activity_code,DESCR from fieldactivity where activity_type='FW')  FA "  +
					" ON FA.activity_code=SM.EVENT_TYPE  "  +
					" WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON')  "  +
					" And last_day(to_date('" + month + "'||'" + year + "','MONYYYY')) AND STRG_TYPE = 'C'  "  +
					" And S.Item_Ser ='OTC'  "  +
					" And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN')))  "  +
					" And S.Sales_Pers in (" + salesPerson + ") "  +
					" GROUP BY SM.EVENT_DATE,S.SALES_PERS, S.SP_NAME,FA.descr )A  "  +
					" GROUP BY A.SALES_PERS,A.SP_NAME "  +
					" union all  "  +
					" SELECT SALES_PERS.SALES_PERS as insight_id, SALES_PERS.sp_name as rep_name, 0 as field_working_days, "  +
					" COUNT(STRG_SERIES.SC_CODE) as target_outlets, 0 as chemist_call, 0 as total_coverage, 0 as productive_coverage  "  +
					" FROM STRG_SERIES, SALES_PERS WHERE Strg_Series.Sales_Pers=Sales_Pers.Sales_Pers  "  +
					" And STRG_SERIES.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') ) )  "  +
					" And STRG_SERIES.Sales_Pers in (" + salesPerson + ") AND STRG_SERIES.ITEM_SER ='OTC'  "  +
					" AND STRG_SERIES.STATUS ='Y' AND STRG_SERIES.CUST_TYPE ='C' GROUP BY SALES_PERS.SALES_PERS, SALES_PERS.sp_name  "  +
					" union all  "  +
					" SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, "  +
					" COUNT(*)  as chemist_call, 0 as total_coverage, 0 as productive_coverage FROM STRG_MEET SM "  +
					" JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON') "  +
					" And last_day(to_date('" + month + "'||'" + year + "','MONYYYY')) AND STRG_TYPE = 'C' AND S.ITEM_SER ='OTC'  "  +
					" And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') ) )  "  +
					" And S.Sales_Pers in (" + salesPerson + ")  "  +
					" GROUP BY S.SALES_PERS, S.SP_NAME "  +
					" union all  "  +
					" SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call,  "  +
					" COUNT(DISTINCT SM.STRG_CODE) as total_coverage , 0 as productive_coverage  "  +
					" FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS  "  +
					" WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON') "  +
					" And last_day(to_date('" + month + "'||'" + year + "','MONYYYY')) AND STRG_TYPE = 'C'  "  +
					" AND S.ITEM_SER ='OTC' And Sm.Strg_Class_Code In('A','I')   "  +
					" And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') ) )  "  +
					" And S.Sales_Pers in (" + salesPerson + ")  "  +
					" GROUP BY S.SALES_PERS, S.SP_NAME  "  +
					" union all  "  +
					" SELECT (A.SALES_PERS) as insight_id, A.sp_name as rep_name, 0 as field_working_days, 0 target_outlets,  "  +
					" 0 chemist_call, 0 as total_coverage , COUNT(A.SC_CODE) as productive_coverage "  +
					" FROM (SELECT SM.STRG_CODE AS SC_CODE, S.SALES_PERS,  S.SP_NAME AS SP_NAME "  +
					" FROM STRG_MEET SM JOIN SALES_PERS S  "  +
					" ON S.SALES_PERS=SM.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON')  "  +
					" And last_day(to_date('" + month + "'||'" + year + "','MONYYYY')) And Sm.Strg_Class_Code In('A','I')  "  +
					" And S.Sales_Pers IN ( (select emp_code from users "  +
					" where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN')) )  "  +
					" And S.Sales_Pers in (" + salesPerson + ")  "  +
					" GROUP BY SM.STRG_CODE, S.SALES_PERS,S.SP_NAME HAVING COUNT(STRG_CODE)> 1)A GROUP BY A.SALES_PERS,A.sp_name ) RSR_SCORE , "  +
					" employee left outer join station on trim(employee.hobby4)=trim(station.stan_code)  "  +
					" where RSR_SCORE.insight_id=employee.emp_code group by station.descr, RSR_SCORE.insight_id, RSR_SCORE.rep_name  "  +
					" UNION ALL "  +
					" select station.descr||' Total'  as territory, ' ' as insight_id, ' ' as sales_pers,  "  +
					" sum(field_working_days) as field_working_days, sum(target_outlets) as target_outlets,  "  +
					" sum(chemist_call) as chemist_call, sum(total_coverage) as total_coverage, sum(productive_coverage) as productive_coverage,  "  +
					" round((case when sum(field_working_days)=0 then 0 else sum(chemist_call)/sum(field_working_days) end),2) as call_average,  "  +
					" round((case when sum(target_outlets) =0 then 0 else (sum(total_coverage)/sum(target_outlets))*100  end ),0)as  TC_PER,  "  +
					" round((case when sum(target_outlets)=0 then 0 else (sum(productive_coverage)/sum(target_outlets))*100 end ),0) as  PC_PER FROM ( select A.SALES_PERS as insight_id, A.SP_NAME as rep_name, sum(case when upper(A.descr) like upper('%HALF%') then 0.5 else 1 end) as field_working_days,  "  +
					" 0 as target_outlets, 0 as chemist_call, 0 as  total_coverage, 0 as productive_coverage "  +
					" FROM ( SELECT DISTINCT SM.EVENT_DATE, S.SALES_PERS, S.SP_NAME , FA.descr  "  +
					" FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS JOIN (select activity_code,DESCR from fieldactivity where activity_type='FW')  FA ON FA.activity_code=SM.EVENT_TYPE  "  +
					" WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON') And last_day(to_date('" + month + "'||'" + year + "','MONYYYY')) AND STRG_TYPE = 'C'  "  +
					" And S.Item_Ser ='OTC'  And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') ) )  "  +
					" And S.Sales_Pers in (" + salesPerson + ") GROUP BY SM.EVENT_DATE,S.SALES_PERS, S.SP_NAME,FA.descr )A  "  +
					" GROUP BY A.SALES_PERS,A.SP_NAME  "  +
					" union all SELECT SALES_PERS.SALES_PERS as insight_id, SALES_PERS.sp_name as rep_name, 0 as field_working_days,  "  +
					" COUNT(STRG_SERIES.SC_CODE) as target_outlets, 0 as chemist_call, 0 as total_coverage,  "  +
					" 0 as productive_coverage FROM STRG_SERIES, SALES_PERS WHERE Strg_Series.Sales_Pers=Sales_Pers.Sales_Pers   "  +
					" And STRG_SERIES.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') )  )  And STRG_SERIES.Sales_Pers in (" + salesPerson + ") AND STRG_SERIES.ITEM_SER ='OTC'  "  +
					" AND STRG_SERIES.STATUS ='Y' AND STRG_SERIES.CUST_TYPE ='C' GROUP BY SALES_PERS.SALES_PERS, SALES_PERS.sp_name  "  +
					" union all  "  +
					" SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets,  "  +
					" COUNT(*)  as chemist_call, 0 as total_coverage, 0 as productive_coverage  "  +
					" FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS  "  +
					" WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON') And last_day(to_date('" + month + "'||'" + year + "','MONYYYY')) "  +
					" AND STRG_TYPE = 'C' And S.Item_Ser ='OTC'   "  +
					" And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN')) )    "  +
					" And S.Sales_Pers in (" + salesPerson + ") GROUP BY S.SALES_PERS, S.SP_NAME  "  +
					" union all "  +
					" SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call,  "  +
					" COUNT(DISTINCT SM.STRG_CODE) as total_coverage , 0 as productive_coverage  "  +
					" FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014  ','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014  ','MONYYYY')) AND STRG_TYPE = 'C' "  +
					" AND S.ITEM_SER ='OTC' And Sm.Strg_Class_Code In('A','I')   "  +
					" And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') ) )   "  +
					" And S.Sales_Pers in (" + salesPerson + ") GROUP BY S.SALES_PERS, S.SP_NAME union all SELECT (A.SALES_PERS) as insight_id, A.sp_name as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call, 0 as total_coverage ,  "  +
					" COUNT(A.SC_CODE) as productive_coverage FROM (SELECT SM.STRG_CODE AS SC_CODE, S.SALES_PERS, S.SP_NAME AS SP_NAME FROM STRG_MEET SM JOIN SALES_PERS S ON S.SALES_PERS=SM.SALES_PERS "  +
					" WHERE SM.Event_Date BETWEEN trunc(to_date('" + month + "'||'" + year + "','MONYYYY'),'MON') And last_day(to_date('" + month + "'||'" + year + "','MONYYYY'))  And Sm.Strg_Class_Code In('A','I')  "  +
					" And S.Sales_Pers IN ( (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') )  )   "  +
					" And S.Sales_Pers in (" + salesPerson + ") GROUP BY SM.STRG_CODE, S.SALES_PERS,S.SP_NAME HAVING COUNT(STRG_CODE)> 1)A GROUP BY A.SALES_PERS,A.sp_name ) RSR_SCORE ,employee  "  +
					" left outer join station on trim(employee.hobby4)=trim(station.stan_code)  "  +
					" where RSR_SCORE.insight_id=employee.emp_code group by station.descr order by TERRITORY,INSIGHT_ID DESC ";
			
			
			
		
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("territory", (rs.getString("TERRITORY")));
				rowData.put("insight_id", rs.getString("INSIGHT_ID"));
				rowData.put("sales_pers", rs.getString("SALES_PERS"));		
				rowData.put("field_working_days", rs.getString("FIELD_WORKING_DAYS"));		
				rowData.put("target_outlets", rs.getString("TARGET_OUTLETS"));		
				rowData.put("chemist_call", rs.getString("CHEMIST_CALL"));		
				rowData.put("total_coverage", rs.getString("TOTAL_COVERAGE"));		
				rowData.put("productive_coverage", rs.getString("PRODUCTIVE_COVERAGE"));		
				rowData.put("call_average", rs.getString("CALL_AVERAGE"));
				rowData.put("tc_per", rs.getString("TC_PER"));		
				rowData.put("pc_per", rs.getString("PC_PER"));		
				
				rawDataMnthDivWiseSalesJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :RSRScoreEJB:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("RSR Score EJB JSON--->["+rawDataMnthDivWiseSalesJson+"]");
		return rawDataMnthDivWiseSalesJson;
		
	}

	
	public void getData()
	{
		
		
	String	sql =   "Select station.descr as territory, RSR_SCORE.insight_id as insight_id, RSR_SCORE.rep_name as sales_pers, sum(field_working_days) as field_working_days, sum(target_outlets) as target_outlets, sum(chemist_call) as chemist_call, sum(total_coverage) as total_coverage, sum(productive_coverage) as productive_coverage, round((case when sum(field_working_days)=0 then 0 else sum(chemist_call)/sum(field_working_days) end),2) as call_average, round((case when sum(target_outlets) =0 then 0 else (sum(total_coverage)/sum(target_outlets))*100  end ),0)as  TC_PER, " +
				"round((case when sum(target_outlets)=0 then 0 else (sum(productive_coverage)/sum(target_outlets))*100 end ),0) as  PC_PER FROM ( select A.SALES_PERS as insight_id, A.SP_NAME as rep_name, sum(case when upper(A.descr) like upper('%HALF%') then 0.5 else 1 end) as field_working_days, 0 as target_outlets, 0 as chemist_call, 0 as total_coverage, 0 as productive_coverage FROM ( SELECT DISTINCT SM.EVENT_DATE, S.SALES_PERS, S.SP_NAME , FA.descr FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS JOIN (select activity_code,DESCR from fieldactivity where activity_type='FW') " +
				" FA ON FA.activity_code=SM.EVENT_TYPE WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) AND STRG_TYPE = 'C' And S.Item_Ser ='OTC'" +
			
				//"/* And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to ) */ " +
			
				" And S.Sales_Pers in ('62851') GROUP BY SM.EVENT_DATE,S.SALES_PERS, S.SP_NAME,FA.descr )A GROUP BY A.SALES_PERS,A.SP_NAME union all SELECT SALES_PERS.SALES_PERS as insight_id, SALES_PERS.sp_name as rep_name, 0 as field_working_days, COUNT(STRG_SERIES.SC_CODE) as target_outlets, 0 as chemist_call, 0 as total_coverage, 0 as productive_coverage FROM STRG_SERIES, SALES_PERS WHERE Strg_Series.Sales_Pers=Sales_Pers.Sales_Pers " +
				
				//"/* And STRG_SERIES.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to )*/ " +
			
				" And STRG_SERIES.Sales_Pers in ('62851') AND STRG_SERIES.ITEM_SER ='OTC' AND STRG_SERIES.STATUS ='Y' AND STRG_SERIES.CUST_TYPE ='C' GROUP BY SALES_PERS.SALES_PERS, SALES_PERS.sp_name union all SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, COUNT(*) " +
				" as chemist_call, 0 as total_coverage, 0 as productive_coverage FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) AND STRG_TYPE = 'C' AND S.ITEM_SER ='OTC' " +
			
				//"/*And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to ) */" +
				
				" And S.Sales_Pers in ('62851') GROUP BY S.SALES_PERS, S.SP_NAME union all SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call, COUNT(DISTINCT SM.STRG_CODE) as total_coverage , 0 as productive_coverage FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) AND STRG_TYPE = 'C' AND S.ITEM_SER ='OTC' And Sm.Strg_Class_Code In('A','I') " +
				
				//"/*And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to ) */ " +
				
				" And S.Sales_Pers in ('62851') GROUP BY S.SALES_PERS, S.SP_NAME union all SELECT (A.SALES_PERS) as insight_id, A.sp_name as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call, 0 as total_coverage , COUNT(A.SC_CODE) as productive_coverage FROM (SELECT SM.STRG_CODE AS SC_CODE, S.SALES_PERS, " +
				" S.SP_NAME AS SP_NAME FROM STRG_MEET SM JOIN SALES_PERS S ON S.SALES_PERS=SM.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) And Sm.Strg_Class_Code In('A','I') " +
			
				//"/* And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to )*/ " +
			
				" And S.Sales_Pers in ('62851') GROUP BY SM.STRG_CODE, S.SALES_PERS,S.SP_NAME HAVING COUNT(STRG_CODE)> 1)A GROUP BY A.SALES_PERS,A.sp_name ) RSR_SCORE ,employee left outer join station on trim(employee.hobby4)=trim(station.stan_code) where RSR_SCORE.insight_id=employee.emp_code group by station.descr, RSR_SCORE.insight_id, RSR_SCORE.rep_name UNION ALL select station.descr||' Total'  as territory, ' ' as insight_id, ' ' as sales_pers, sum(field_working_days) as field_working_days, sum(target_outlets) as target_outlets, sum(chemist_call) as chemist_call, sum(total_coverage) as total_coverage, sum(productive_coverage) as productive_coverage, " +
				" round((case when sum(field_working_days)=0 then 0 else sum(chemist_call)/sum(field_working_days) end),2) as call_average, round((case when sum(target_outlets) =0 then 0 else (sum(total_coverage)/sum(target_outlets))*100  end ),0)as  TC_PER, round((case when sum(target_outlets)=0 then 0 else (sum(productive_coverage)/sum(target_outlets))*100 end ),0) as  PC_PER FROM ( select A.SALES_PERS as insight_id, A.SP_NAME as rep_name, sum(case when upper(A.descr) like upper('%HALF%') then 0.5 else 1 end) as field_working_days, 0 as target_outlets, 0 as chemist_call, 0 as " +
				" total_coverage, 0 as productive_coverage FROM ( SELECT DISTINCT SM.EVENT_DATE, S.SALES_PERS, S.SP_NAME , FA.descr FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS JOIN (select activity_code,DESCR from fieldactivity where activity_type='FW')  FA ON FA.activity_code=SM.EVENT_TYPE WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) AND STRG_TYPE = 'C' And S.Item_Ser ='OTC' " +
				
				
				//"/* And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to )*/ " +
				
				" And S.Sales_Pers in ('62851') GROUP BY SM.EVENT_DATE,S.SALES_PERS, S.SP_NAME,FA.descr )A GROUP BY A.SALES_PERS,A.SP_NAME union all SELECT SALES_PERS.SALES_PERS as insight_id, SALES_PERS.sp_name as rep_name, 0 as field_working_days, COUNT(STRG_SERIES.SC_CODE) as target_outlets, 0 as chemist_call, 0 as total_coverage, 0 as productive_coverage FROM STRG_SERIES, SALES_PERS WHERE Strg_Series.Sales_Pers=Sales_Pers.Sales_Pers " +
			
				//"/*And STRG_SERIES.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN')  connect by prior emp_code = report_to )*/ " +
			
				" And STRG_SERIES.Sales_Pers in ('62851') AND STRG_SERIES.ITEM_SER ='OTC' AND STRG_SERIES.STATUS ='Y' AND STRG_SERIES.CUST_TYPE ='C' GROUP BY SALES_PERS.SALES_PERS, SALES_PERS.sp_name union all SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, COUNT(*)  as chemist_call, 0 as total_coverage, 0 as productive_coverage FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) AND STRG_TYPE = 'C' And S.Item_Ser ='OTC' " +
				
				//"/*And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to )*/ " +
				
				" And S.Sales_Pers in ('62851') GROUP BY S.SALES_PERS, S.SP_NAME union all SELECT (S.SALES_PERS) as insight_id, S.SP_NAME as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call, COUNT(DISTINCT SM.STRG_CODE) as total_coverage , 0 as productive_coverage FROM STRG_MEET SM JOIN SALES_PERS S ON SM.SALES_PERS = S.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY')) AND STRG_TYPE = 'C' AND S.ITEM_SER ='OTC' And Sm.Strg_Class_Code In('A','I') " +
				
				//"/*And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to )*/ " +
				
				" And S.Sales_Pers in ('62851') GROUP BY S.SALES_PERS, S.SP_NAME union all SELECT (A.SALES_PERS) as insight_id, A.sp_name as rep_name, 0 as field_working_days, 0 target_outlets, 0 chemist_call, 0 as total_coverage , COUNT(A.SC_CODE) as productive_coverage FROM (SELECT SM.STRG_CODE AS SC_CODE, S.SALES_PERS, S.SP_NAME AS SP_NAME FROM STRG_MEET SM JOIN SALES_PERS S ON S.SALES_PERS=SM.SALES_PERS WHERE SM.Event_Date BETWEEN trunc(to_date('AUG'||'2014','MONYYYY'),'MON') And last_day(to_date('AUG'||'2014','MONYYYY'))  And Sm.Strg_Class_Code In('A','I') " +
			
			//	"/* And S.Sales_Pers IN ( select emp_code from employee start with emp_code = (select emp_code from users where (Profile_Id = 'RSR-BEM1' OR Profile_Id = 'ADMIN') And code = 'ADMIN') connect by prior emp_code = report_to )*/ " +
			
				" And S.Sales_Pers in ('62851') GROUP BY SM.STRG_CODE, S.SALES_PERS,S.SP_NAME HAVING COUNT(STRG_CODE)> 1)A GROUP BY A.SALES_PERS,A.sp_name ) RSR_SCORE ,employee left outer join station on trim(employee.hobby4)=trim(station.stan_code) where RSR_SCORE.insight_id=employee.emp_code group by station.descr order by TERRITORY,INSIGHT_ID DESC ";
		
	}
}
