package ibase.webitm.ejb.gst;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.w3c.dom.Document;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GenerateGSTR3BPrc extends ProcessEJB implements GenerateGSTR3BPrcLocal,GenerateGSTR3BPrcRemote 
{
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
	
	FinCommon finCommon = new FinCommon();
	
	public String process(String xmlString, String xmlString2, String objContext, String xtraParams) throws ITMException 
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		
		try 
		{
			System.out.println("xmlString   [" + xmlString + "]");
			System.out.println("xmlString2  [" + xmlString2 + "]");
			System.out.println("objContext   [" + objContext + "]");
			System.out.println("xtraParams   [" + xtraParams + "]");
			
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				headerDom = e12GenericUtility.parseString(xmlString);
			}
			if (xmlString2 != null && xmlString2.length() != 0) 
			{
				detailDom = e12GenericUtility.parseString(xmlString2);
			}
			
			retStr = process(headerDom, detailDom, objContext, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("GenerateGSTR3BPrc.process()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String objContext, String xtraParams) throws ITMException
	{
		String errString = "";
		String prdCode = "", gstin = "", loginSiteCode= "", gstCode = "";
		
		boolean isDataFound01 = false, isDataFound03 = false, isDataFound04 = false, isDataFound05 = false, isDataFound06 = false, isDataFound09 = false,
				isDataFound10 = false, isDataFound11 = false, isDataFound14 = false, isDataFound21 = false, isDataFound28 = false, isDataFound29 = false,
				isDataFound30 = false, isDataFound31 = false;
		
		double taxableAmtTemp1 = 0.0, igstAmtTemp1 = 0.0, cgstAmtTemp1 = 0.0, sgstAmtTemp1 = 0.0, cessAmtTemp1 = 0.0;
		double taxableAmtTemp2 = 0.0, igstAmtTemp2 = 0.0, cgstAmtTemp2 = 0.0, sgstAmtTemp2 = 0.0, cessAmtTemp2 = 0.0;
		double taxableAmt = 0.0, igstAmt = 0.0, cgstAmt = 0.0, sgstAmt = 0.0, cessAmt = 0.0;
		
		HashMap<String,Object> headerDataHMap = new HashMap<String,Object>();
		HashMap<String,Object> detailDataHMap = new HashMap<String,Object>();
		List<HashMap<String,Object>> detailDataList = new ArrayList<HashMap<String,Object>>();
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		Connection conn = null;
		
		boolean isError = false;
		try
		{
			conn = getConnection();
			prdCode = gstCommonUtil.checkNull(e12GenericUtility.getColumnValue("prd_code", headerDom));
			gstin = gstCommonUtil.checkNull(e12GenericUtility.getColumnValue("gstin", headerDom));
			
			System.out.println("prdCode["+prdCode+"] gstin["+gstin+"]");
			
			if(prdCode.trim().length() == 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTBLNKPRD","","",conn);
				return errString;
			}
			else if(prdCode.trim().length() > 0)
			{
				sql = "SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, prdCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					if(rs.getInt("CNT") == 0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTMONATD10","","",conn);
						return errString;
					}
				}
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
			}
			
			loginSiteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			
			System.out.println("Outward taxable supplies (other than zero) START");
			
			sql = " SELECT SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT ,SUM(GDD.IGST_AMT) AS IGST_AMT,SUM(GDD.CGST_AMT) AS CGST_AMT, "
				+ " SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('01','03','08','09','10','06','07','11','12','30','41','42') ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "1");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound01 = true;
				taxableAmtTemp1 = rs.getDouble("TAXABLE_AMT");
				igstAmtTemp1 = rs.getDouble("IGST_AMT");
				cgstAmtTemp1 = rs.getDouble("CGST_AMT");
				sgstAmtTemp1 = rs.getDouble("SGST_AMT");
				cessAmtTemp1 = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			sql = " SELECT SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT ,SUM(GDD.IGST_AMT) AS IGST_AMT,SUM(GDD.CGST_AMT) AS CGST_AMT, "
				+ " SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('29','43','44') ";
				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "1");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound01 = true;
				taxableAmtTemp2 = rs.getDouble("TAXABLE_AMT");
				igstAmtTemp2 = rs.getDouble("IGST_AMT");
				cgstAmtTemp2 = rs.getDouble("CGST_AMT");
				sgstAmtTemp2 = rs.getDouble("SGST_AMT");
				cessAmtTemp2 = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound01)
			{
				taxableAmt = taxableAmtTemp1 - taxableAmtTemp2;
				igstAmt = igstAmtTemp1 - igstAmtTemp2;
				cgstAmt = cgstAmtTemp1 - cgstAmtTemp2;
				sgstAmt = sgstAmtTemp1 - sgstAmtTemp2;
				cessAmt = cessAmtTemp1 - cessAmtTemp2;
				
				System.out.println("taxableAmt["+taxableAmt+"]");
				System.out.println("igstAmt["+igstAmt+"]");
				System.out.println("cgstAmt["+cgstAmt+"]");
				System.out.println("sgstAmt["+sgstAmt+"]");
				System.out.println("cessAmt["+cessAmt+"]");
				
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "01");
				headerDataHMap.put("gst_type", "O");
				
				detailDataHMap.clear();
				detailDataHMap.put("taxable_amt", taxableAmt);
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
				
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
				
				taxableAmtTemp1 = 0.0; igstAmtTemp1 = 0.0; cgstAmtTemp1 = 0.0; sgstAmtTemp1 = 0.0; cessAmtTemp1 = 0.0;
				taxableAmtTemp2 = 0.0; igstAmtTemp2 = 0.0; cgstAmtTemp2 = 0.0; sgstAmtTemp2 = 0.0; cessAmtTemp2 = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [01]");
			}
			
			System.out.println("Outward taxable supplies (other than zero) END");
			
			System.out.println("Outward taxable supplies (zero rated ) START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("Outward taxable supplies (zero rated ) END");
			
			System.out.println("Other outward supplies (Nil rated, exempted) START");
			
			sql = " SELECT SUM(GDH.AMOUNT) AS AMOUNT " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('15','16','18','19','21','22','24','25') ";
				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "1");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound03 = true;
				taxableAmt = rs.getDouble("AMOUNT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound03)
			{
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "03");
				headerDataHMap.put("gst_type", "O");
				headerDataHMap.put("amount", taxableAmt);
				
				insertGSTHdrDetData(headerDataHMap, null, xtraParams, conn);
				
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [03]");
			}
			
			System.out.println("Other outward supplies (Nil rated, exempted) END");
			
			System.out.println("Inward supplies (liable to reverse charge) START");
			
			sql = " SELECT SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT ,SUM(GDD.IGST_AMT) AS IGST_AMT,SUM(GDD.CGST_AMT) AS CGST_AMT, "
				+ " SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('02') ";
				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "1");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound04 = true;
				taxableAmt = rs.getDouble("TAXABLE_AMT");
				igstAmt = rs.getDouble("IGST_AMT");
				cgstAmt = rs.getDouble("CGST_AMT");
				sgstAmt = rs.getDouble("SGST_AMT");
				cessAmt = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound04)
			{
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "04");
				headerDataHMap.put("gst_type", "O");
				
				detailDataHMap.clear();
				detailDataHMap.put("taxable_amt", taxableAmt);
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
					
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [04]");
			}
			
			System.out.println("Inward supplies (liable to reverse charge) END");
			
			System.out.println("Non-GST outward supplies START");
			
			sql = " SELECT SUM(GDH.AMOUNT) AS AMOUNT " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('17','20','23','26') ";
				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "1");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound05 = true;
				taxableAmt = rs.getDouble("AMOUNT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound05)
			{
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "05");
				headerDataHMap.put("gst_type", "O");
				headerDataHMap.put("amount", taxableAmt);
				
				insertGSTHdrDetData(headerDataHMap, null, xtraParams, conn);
				
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [05]");
			}
			
			System.out.println("Non-GST outward supplies END");
	
			System.out.println("Supplies to unregistered persons START");
			
			sql = " SELECT GDH.GST_CODE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT ,SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('04','05','13','14') GROUP BY GST_CODE ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "1");
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				isDataFound06 = true;
				gstCode = rs.getString("GST_CODE");
				taxableAmt = rs.getDouble("TAXABLE_AMT");
				igstAmt = rs.getDouble("IGST_AMT");
				cessAmt = rs.getDouble("CESS_AMT");
				
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "06");
				headerDataHMap.put("gst_type", "D");
				headerDataHMap.put("gst_code", gstCode);
				headerDataHMap.put("doc_type", "U");
				
				detailDataHMap.clear();
				detailDataHMap.put("taxable_amt", taxableAmt);
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
				
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(!isDataFound06)
			{
				System.out.println("No data found for GSTR3B trantype [06]");
			}
			
			System.out.println("Supplies to unregistered persons END");
			
			System.out.println("Supplies to composite persons START");

			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("Supplies to composite persons END");
			
			System.out.println("Supplies to UIN holders START");

			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("Supplies to UIN holders END");
			
			System.out.println("IMPG ITC avilable START");
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD "
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? "
				+ " AND GDH.TRAN_TYPE IN ('08','09') ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "2");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound09 = true;
				igstAmt = rs.getDouble("IGST_AMT");
				cgstAmt = rs.getDouble("CGST_AMT");
				sgstAmt = rs.getDouble("SGST_AMT");
				cessAmt = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound09)
			{
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "09");
				headerDataHMap.put("gst_type", "E");
				
				detailDataHMap.clear();
				detailDataHMap.put("itc_type", "IG");
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
					
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [09]");
			}
			
			System.out.println("IMPG ITC avilable END");
			
			System.out.println("IMPS ITC avilable START");
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD "
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? "
				+ " AND GDH.TRAN_TYPE IN ('07') ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "2");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound10 = true;
				igstAmt = rs.getDouble("IGST_AMT");
				cgstAmt = rs.getDouble("CGST_AMT");
				sgstAmt = rs.getDouble("SGST_AMT");
				cessAmt = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound10)
			{
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "10");
				headerDataHMap.put("gst_type", "E");
				
				detailDataHMap.clear();
				detailDataHMap.put("itc_type", "IS");
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
					
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [10]");
			}
			
			System.out.println("IMPS ITC avilable END");
			
			System.out.println("ISRC ITC avilable START");
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD "
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? "
				+ " AND GDH.TRAN_TYPE IN ('05') ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "2");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound11 = true;
				igstAmt = rs.getDouble("IGST_AMT");
				cgstAmt = rs.getDouble("CGST_AMT");
				sgstAmt = rs.getDouble("SGST_AMT");
				cessAmt = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound11)
			{
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "11");
				headerDataHMap.put("gst_type", "E");
				
				detailDataHMap.clear();
				detailDataHMap.put("itc_type", "IC");
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
					
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [11]");
			}
			
			System.out.println("ISRC ITC avilable END");
			
			System.out.println("ISD ITC avilable START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("ISD ITC avilable END");
			
			System.out.println("RUL ITC avilable START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("RUL ITC avilable END");
			
			System.out.println("OTH ITC avilable START");
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT,SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ "	FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('01','02','03','04','06','10','11','16','17') ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "2");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound14 = true;
				igstAmtTemp1 = rs.getDouble("IGST_AMT");
				cgstAmtTemp1 = rs.getDouble("CGST_AMT");
				sgstAmtTemp1 = rs.getDouble("SGST_AMT");
				cessAmtTemp1 = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT,SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ "	FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('12','13','14','15') ";
				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "2");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound14 = true;
				igstAmtTemp2 = rs.getDouble("IGST_AMT");
				cgstAmtTemp2 = rs.getDouble("CGST_AMT");
				sgstAmtTemp2 = rs.getDouble("SGST_AMT");
				cessAmtTemp2 = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound14)
			{
				igstAmt = igstAmtTemp1 - igstAmtTemp2;
				cgstAmt = cgstAmtTemp1 - cgstAmtTemp2;
				sgstAmt = sgstAmtTemp1 - sgstAmtTemp2;
				cessAmt = cessAmtTemp1 - cessAmtTemp2;
				
				System.out.println("igstAmt["+igstAmt+"]");
				System.out.println("cgstAmt["+cgstAmt+"]");
				System.out.println("sgstAmt["+sgstAmt+"]");
				System.out.println("cessAmt["+cessAmt+"]");
				
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "14");
				headerDataHMap.put("gst_type", "E");
				
				detailDataHMap.clear();
				detailDataHMap.put("itc_type", "OT");
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
				
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
				taxableAmtTemp1 = 0.0; igstAmtTemp1 = 0.0; cgstAmtTemp1 = 0.0; sgstAmtTemp1 = 0.0; cessAmtTemp1 = 0.0;
				taxableAmtTemp2 = 0.0; igstAmtTemp2 = 0.0; cgstAmtTemp2 = 0.0; sgstAmtTemp2 = 0.0; cessAmtTemp2 = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [14]");
			}
			
			System.out.println("OTH ITC avilable END");
			
			System.out.println("IMPG ITC reversed START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("IMPG ITC reversed END");
			
			System.out.println("IMPS ITC reversed START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("IMPS ITC reversed END");
			
			System.out.println("ISRC ITC reversed START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("ISRC ITC reversed END");
			
			System.out.println("ISD ITC reversed START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("ISD ITC reversed END");
			
			System.out.println("RUL ITC reversed START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("RUL ITC reversed END");
			
			System.out.println("OTH ITC reversed START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("OTH ITC reversed END");
			
			System.out.println("NET ITC Available START");
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('09','10','11','12','13','14') ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "6");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound21 = true;
				igstAmtTemp1 = rs.getDouble("IGST_AMT");
				cgstAmtTemp1 = rs.getDouble("CGST_AMT");
				sgstAmtTemp1 = rs.getDouble("SGST_AMT");
				cessAmtTemp1 = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			sql = " SELECT SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT "
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD " 
				+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.REC_TYPE = ? " 
				+ " AND GDH.TRAN_TYPE IN ('15','16','17','18','19','20') ";
				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, "6");
			
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				isDataFound21 = true;
				igstAmtTemp2 = rs.getDouble("IGST_AMT");
				cgstAmtTemp2 = rs.getDouble("CGST_AMT");
				sgstAmtTemp2 = rs.getDouble("SGST_AMT");
				cessAmtTemp2 = rs.getDouble("CESS_AMT");
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			
			if(isDataFound21)
			{
				igstAmt = igstAmtTemp1 - igstAmtTemp2;
				cgstAmt = cgstAmtTemp1 - cgstAmtTemp2;
				sgstAmt = sgstAmtTemp1 - sgstAmtTemp2;
				cessAmt = cessAmtTemp1 - cessAmtTemp2;
				
				System.out.println("igstAmt["+igstAmt+"]");
				System.out.println("cgstAmt["+cgstAmt+"]");
				System.out.println("sgstAmt["+sgstAmt+"]");
				System.out.println("cessAmt["+cessAmt+"]");
				
				headerDataHMap.clear();
				headerDataHMap.put("prd_code", prdCode);
				headerDataHMap.put("tran_type", "21");
				headerDataHMap.put("gst_type", "E");
				
				detailDataHMap.clear();
				detailDataHMap.put("igst_amt", igstAmt);
				detailDataHMap.put("cgst_amt", cgstAmt);
				detailDataHMap.put("sgst_amt", sgstAmt);
				detailDataHMap.put("cess_amt", cessAmt);
				
				detailDataList.clear();
				detailDataList.add(detailDataHMap);
				
				insertGSTHdrDetData(headerDataHMap, detailDataList, xtraParams, conn);
				
				taxableAmt = 0.0; igstAmt = 0.0; cgstAmt = 0.0; sgstAmt = 0.0; cessAmt = 0.0;
				taxableAmtTemp1 = 0.0; igstAmtTemp1 = 0.0; cgstAmtTemp1 = 0.0; sgstAmtTemp1 = 0.0; cessAmtTemp1 = 0.0;
				taxableAmtTemp2 = 0.0; igstAmtTemp2 = 0.0; cgstAmtTemp2 = 0.0; sgstAmtTemp2 = 0.0; cessAmtTemp2 = 0.0;
			}
			else
			{
				System.out.println("No data found for GSTR3B trantype [21]");
			}
			
			System.out.println("NET ITC Available END");
			
			System.out.println("IMPG ITC ineligible START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("IMPG ITC ineligible END");
			
			System.out.println("IMPS ITC ineligible START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("IMPS ITC ineligible END");
			
			System.out.println("ISRC ITC ineligible START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("ISRC ITC reversed END");
			
			System.out.println("ISD ITC ineligible START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("ISD ITC ineligible END");
			
			System.out.println("RUL ITC ineligible START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("RUL ITC ineligible END");
			
			System.out.println("OTH ITC ineligible START");
			
			System.out.println("!!!!!!!!!!!!!!No inforamtion to identify data!!!!!!!!!!!!!!");
			
			System.out.println("OTH ITC ineligible END");
		} 
		catch (Exception e)
		{
			System.out.println("GenerateGSTR3BPrc.process()["+e.getMessage()+"]");
			isError = true;
			e.printStackTrace();
		}
		finally
		{
			System.out.println("Inside finally isError["+isError+"]");
			try
			{
				if(isError)
				{
					conn.rollback();
					if(rs!=null)
					{
						rs.close();
						rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt=null;
					}
				}
				if((errString == null || errString.trim().length() == 0) && !isError)
				{
					conn.commit();
					errString = itmDBAccessEJB.getErrorString("","PRCSUCCESS","","",conn);
				}
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn=null;
				}
			}
			catch (Exception ex)
			{	
				ex.printStackTrace();
				throw new ITMException(ex);
			}		
		}
		System.out.println("Return String from process ["+errString+"]");
		return errString;
	}
	
	private void insertGSTHdrDetData(HashMap<String,Object> headerDataHMap, List<HashMap<String,Object>> detailDataList, String xtraParams, Connection conn) throws ITMException
	{
		String tranId = "", siteCode = "", periodCode = "", tranType = "", docType = "", gstCode = "", gstType = "",
			   loginCode = "", chgTerm = "", supplyType = "", itcType = "";
		double amount = 0.0, taxableAmt = 0.0, igstAmt = 0.0, cgstAmt = 0.0, sgstAmt = 0.0, cessAmt = 0.0;
		
		int lineNo = 0;
		
		int hdrInsCnt = 0;
		int[] detInsCnt = null;
		
		String hdrInsSql = "", detInsSql = "";
		PreparedStatement hdrInsPstmt = null, detInsPstmt = null;
		boolean isError = false;
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			periodCode = (String)headerDataHMap.get("prd_code");
			tranType = (String)headerDataHMap.get("tran_type");
			docType = (String)headerDataHMap.get("doc_type");
			gstCode = (String)headerDataHMap.get("gst_code");
			gstType = (String)headerDataHMap.get("gst_type");
			amount = (double)headerDataHMap.get("amount");
			
			hdrInsSql = " INSERT INTO GST_DATA_HDR (TRAN_ID, TRAN_DATE, TRAN_ID__REF, SITE_CODE, PRD_CODE, REC_TYPE, TRAN_TYPE, CUST_CODE, CUST_NAME,"
					  + " SUBMISSION_TYPE, DOC_CHECKSUM, DOC_TYPE, DOC_NO, DOC_DATE, AMOUNT, REVERSE_CHRG, LR_NO, LR_DATE, REAS_CODE, REF_ID__INV,"
					  + " REF_DATE__INV, PROV_ASSMNT, ORDER_NO, ORDER_DATE, REMARKS, SUBMIT_STATUS, SUBMIT_DATE, ADD_USER, ADD_DATE, ADD_TERM, CHG_USER,"
					  + " CHG_DATE, CHG_TERM, TAX_REG_NO, RECO_STATUS, ECOM_REG_NO, REF_SER, GST_CODE, GST_TYPE, REF_ID)"
					  + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
			hdrInsPstmt = conn.prepareStatement(hdrInsSql);
			
			tranId = gstCommonUtil.generateTranId("w_gstr3b", siteCode, conn);
			
			hdrInsPstmt.setString(1, tranId);
			hdrInsPstmt.setTimestamp(2, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
			hdrInsPstmt.setString(3, null);
			hdrInsPstmt.setString(4, siteCode);
			hdrInsPstmt.setString(5, periodCode);
			hdrInsPstmt.setString(6, "6");
			hdrInsPstmt.setString(7, tranType);
			hdrInsPstmt.setString(8, null);
			hdrInsPstmt.setString(9, null);
			hdrInsPstmt.setString(10, null);
			hdrInsPstmt.setString(11, null);
			hdrInsPstmt.setString(12, docType);
			hdrInsPstmt.setString(13, null);
			hdrInsPstmt.setTimestamp(14, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
			hdrInsPstmt.setDouble(15, amount);
			hdrInsPstmt.setString(16, null);
			hdrInsPstmt.setString(17, null);
			hdrInsPstmt.setTimestamp(18, null);
			hdrInsPstmt.setString(19, null);
			hdrInsPstmt.setString(20, null);
			hdrInsPstmt.setTimestamp(21, null);
			hdrInsPstmt.setString(22, null);
			hdrInsPstmt.setString(23, null);
			hdrInsPstmt.setTimestamp(24, null);
			hdrInsPstmt.setString(25, null);
			hdrInsPstmt.setString(26, "P");
			hdrInsPstmt.setTimestamp(27, null);
			hdrInsPstmt.setString(28, loginCode);
			hdrInsPstmt.setTimestamp(29, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
			hdrInsPstmt.setString(30, chgTerm);
			hdrInsPstmt.setString(31, loginCode);
			hdrInsPstmt.setTimestamp(32, java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateTimeFormat())));
			hdrInsPstmt.setString(33, chgTerm);
			hdrInsPstmt.setString(34, null);
			hdrInsPstmt.setString(35, null);
			hdrInsPstmt.setString(36, null);
			hdrInsPstmt.setString(37, null);
			hdrInsPstmt.setString(38, gstCode);
			hdrInsPstmt.setString(39, gstType);
			hdrInsPstmt.setString(40, null);
			
			hdrInsCnt = hdrInsPstmt.executeUpdate();
			
			System.out.println("data inserted into header ["+hdrInsCnt+"]");
			
			if(hdrInsPstmt != null)
			{
				hdrInsPstmt.close();
				hdrInsPstmt = null;
			}
			
			if(detailDataList != null && detailDataList.size() > 0)
			{
				detInsSql = " INSERT INTO GST_DATA_DET (TRAN_ID, LINE_NO, STATUS, SR_NO__OLD, LINE_TYPE, GS_CODE, TAXABLE_AMT, IGST_PERC,"
						  + " IGST_AMT, CGST_PERC, CGST_AMT, SGST_PERC, SGST_AMT, GS_DESCR, UNIT, QUANTITY, SUPPLY_TYPE, CESS_PERC, CESS_AMT,"
						  + " REMARKS, ITC_TYPE, ITC_IGST, ITC_CGST, ITC_SGST, ITC_CESS, GST_RATE)"
						  + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				
				detInsPstmt = conn.prepareStatement(detInsSql);
				
				for(HashMap<String,Object> eachDataHMap : detailDataList)
				{
					taxableAmt = (double)eachDataHMap.get("taxable_amt");
					igstAmt = (double)eachDataHMap.get("igst_amt");
					cgstAmt = (double)eachDataHMap.get("cgst_amt");
					sgstAmt = (double)eachDataHMap.get("sgst_amt");
					cessAmt = (double)eachDataHMap.get("cess_amt");
					supplyType = (String)eachDataHMap.get("supply_type");
					itcType = (String)eachDataHMap.get("itc_type");
							
					detInsPstmt.setString(1, tranId);
					detInsPstmt.setInt(2, ++lineNo);
					detInsPstmt.setString(3, null);
					detInsPstmt.setInt(4, 0);
					detInsPstmt.setString(5, null);
					detInsPstmt.setString(6, null);
					detInsPstmt.setDouble(7, taxableAmt);
					detInsPstmt.setDouble(8, 0.0);
					detInsPstmt.setDouble(9, igstAmt);
					detInsPstmt.setDouble(10, 0.0);
					detInsPstmt.setDouble(11, cgstAmt);
					detInsPstmt.setDouble(12, 0.0);
					detInsPstmt.setDouble(13, sgstAmt);
					detInsPstmt.setString(14, null);
					detInsPstmt.setString(15, null);
					detInsPstmt.setInt(16, 0);
					detInsPstmt.setString(17, supplyType);
					detInsPstmt.setDouble(18, 0.0);
					detInsPstmt.setDouble(19, cessAmt);
					detInsPstmt.setString(20, null);
					detInsPstmt.setString(21, itcType);
					detInsPstmt.setDouble(22, 0.0);
					detInsPstmt.setDouble(23, 0.0);
					detInsPstmt.setDouble(24, 0.0);
					detInsPstmt.setDouble(25, 0.0);
					detInsPstmt.setDouble(26, 0.0);
					
					detInsPstmt.addBatch();
					detInsPstmt.clearParameters();
				}
				
				detInsCnt = detInsPstmt.executeBatch();
				
				if(detInsPstmt != null)
				{
					detInsPstmt.close();
					detInsPstmt = null;
				}
				
				if(detInsCnt!=null)
				{
					for(int eachRowCnt : detInsCnt)
					{
						System.out.println("data inserted into detail ["+eachRowCnt+"]");
					}
				}
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("GenerateGSTR3BPrc.insertGSTHdrDetData()");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("inside GenerateGSTR3BPrc.insertGSTHdrDetData() isError["+isError+"]");
				
				if(isError)
				{
					if(hdrInsPstmt != null)
					{
						hdrInsPstmt.close();
						hdrInsPstmt = null;
					}
					if(detInsPstmt != null)
					{
						detInsPstmt.close();
						detInsPstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				System.out.println("GenerateGSTR3BPrc.insertGSTHdrDetData()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
	}
	
	public String getError(String message,String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  itmDBAccessEJB.getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
}