/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.core.client.Callback;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import ibase.e12ria.client.BaseE12;
import ibase.e12ria.client.E12CollabDataWrapper;
import ibase.e12ria.client.E12CollabFeedDetailObj;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.E12RIA;
import ibase.e12ria.client.E12Wizard;
import ibase.e12ria.client.EntryWrapper;
import ibase.e12ria.e12widgets.client.AndroidDownloader;
import ibase.e12ria.e12widgets.shared.AttachmentObj;
import ibase.e12ria.e12widgets.shared.FileViewer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class CollabFeedDetailPanel {
    protected FlowPanel userFeedContainer = new FlowPanel();
    static final HashMap<String, String> fileTypeImageMap = new HashMap();
    protected static HashMap<String, DownloadStatusBean> fileDownloadStatusBean = new HashMap();
    protected static HashMap<String, Boolean> fileDownloadStatusMap = new HashMap();
    protected Boolean isMobileOS;
    protected E12CollabDataWrapper entry;
    protected FlexTable header = new FlexTable();
    protected int height = 500;
    private int currentStartPos = 0;
    private Button feedDataNextButton = new Button(">");
    private Button feedDataLastButton = new Button(">>");
    private Label feedDataLabel = new Label(E12Constants.constants.setNoDataLbl());
    private Button feedDataPreButton = new Button("<");
    private Button feedDataFirstButton = new Button("<<");
    int displayFeedLength = 4;
    VerticalPanel feedTableDataPanel = new VerticalPanel();
    String isAutoDownload = "";

    static {
        fileTypeImageMap.put("word", "mswordImage");
        fileTypeImageMap.put("excel", "excelImage");
        fileTypeImageMap.put("pdf", "pdfImage");
    }

    public VerticalPanel createCollabFeedDetailPanel(E12CollabDataWrapper entry, String grpName) {
        TextBox tabIdTxtBx = new TextBox();
        tabIdTxtBx.setText(grpName);
        tabIdTxtBx.setVisible(false);
        tabIdTxtBx.setHeight("0px");
        VerticalPanel colabVPnl = new VerticalPanel();
        colabVPnl.add((Widget)this.createCollabFeedDetailPanel(entry, false));
        colabVPnl.add((Widget)tabIdTxtBx);
        return colabVPnl;
    }

    public FlowPanel createCollabFeedDetailPanel(E12CollabDataWrapper entry, boolean isMobileOs) {
        try {
            String url = "";
            E12Global.getInstance().setLoading(true);
            this.userFeedContainer.setStyleName("collab-userFeedContainer");
            this.isMobileOS = isMobileOs;
            this.entry = entry;
            this.isAutoDownload = entry.isAutoDownload();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("GROUP_ID", entry.getGroupId());
            String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
            url = "/ibase/CollabGetGroupPostsServlet?" + paramString;
            RequestBuilder requestBldr = new RequestBuilder(RequestBuilder.GET, url);
            try {
                requestBldr.sendRequest(null, new RequestCallback(){

                    public void onResponseReceived(Request request, Response response) {
                        if (E12Global.getInstance().checkErrorException(response, 1)) {
                            E12Global.getInstance().setLoading(false);
                            String responseStr = response.getText();
                            CollabFeedDetailPanel.this.viewUserPost(responseStr);
                        }
                    }

                    public void onError(Request request, Throwable exception) {
                        Window.alert((String)(" onError of CollabGetGroupPostsServlet:  " + exception.getMessage()));
                    }
                });
            }
            catch (Exception e) {
                Window.alert((String)(" Exception in createE12ColabFeedDetailPanel requestBuilder: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception in createE12ColabFeedDetailPanel constructor: " + e.getMessage()));
            e.printStackTrace();
        }
        return this.userFeedContainer;
    }

    public void viewUserPost(String responseStr) {
        try {
            Document dom = XMLParser.parse((String)responseStr);
            XMLParser.removeWhitespace((Node)dom);
            NodeList userFeedInfoNode = dom.getElementsByTagName("POST");
            this.setMetadataForFeed(userFeedInfoNode);
        }
        catch (Exception e) {
            Window.alert((String)(" Exception in  view User post " + e.getMessage()));
        }
    }

    public void setMetadataForFeed(NodeList userFeedInfoNode) {
        try {
            this.createHeaderPanel();
            ArrayList<AttachmentObj> attachmentList = null;
            ArrayList<E12CollabFeedDetailObj> feedDataList = new ArrayList<E12CollabFeedDetailObj>();
            int feedCount = userFeedInfoNode.getLength();
            int ctr = 0;
            while (ctr < feedCount) {
                String userGroupId = userFeedInfoNode.item(ctr).getAttributes().getNamedItem("id").getNodeValue();
                String postOwner = userFeedInfoNode.item(ctr).getChildNodes().item(0).getFirstChild().getNodeValue();
                String userFeedDescription = userFeedInfoNode.item(ctr).getChildNodes().item(1).getFirstChild().getNodeValue();
                String postDate = userFeedInfoNode.item(ctr).getChildNodes().item(2).getFirstChild().getNodeValue();
                NodeList postAttachmentnode = userFeedInfoNode.item(ctr).getChildNodes().item(3).getChildNodes();
                String posterName = userFeedInfoNode.item(ctr).getChildNodes().item(4).getFirstChild().getNodeValue();
                int length = postAttachmentnode.getLength();
                attachmentList = new ArrayList<AttachmentObj>();
                int i = 0;
                while (i < length) {
                    String fileType = postAttachmentnode.item(i).getAttributes().getNamedItem("type").getNodeValue();
                    String fileUrl = postAttachmentnode.item(i).getAttributes().getNamedItem("url").getNodeValue();
                    String fileId = postAttachmentnode.item(i).getAttributes().getNamedItem("id").getNodeValue();
                    String fileName = postAttachmentnode.item(i).getFirstChild().getNodeValue();
                    if (fileName.indexOf(".swf") != -1) {
                        fileName = String.valueOf(fileName.substring(0, fileName.indexOf(".swf"))) + ".base";
                    }
                    if ("".equalsIgnoreCase(fileUrl)) {
                        String winHostUrl = "";
                        fileUrl = String.valueOf(winHostUrl) + "/ibase/WebITMDocumentHandlerServlet?USER=" + E12Constants.userID + "&PASSWORD=" + E12Constants.passwordSha256 + "&isSHA256Appld=true&ACTION=GET_DOCUMENT&DOC_ID=" + fileId + "&DOC_TYPE=" + fileType;
                    }
                    AttachmentObj attchmentObj = new AttachmentObj(fileType, fileUrl, fileName, fileId);
                    attachmentList.add(attchmentObj);
                    ++i;
                }
                E12CollabFeedDetailObj feedDetailObj = new E12CollabFeedDetailObj(userGroupId, userFeedDescription, postOwner, postDate, attachmentList, posterName);
                feedDataList.add(feedDetailObj);
                ++ctr;
            }
            if (this.isMobileOS.booleanValue()) {
                this.createCollabPostFeeds(feedDataList);
            } else {
                this.createFeedTable(feedDataList);
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception " + e.getMessage()));
        }
    }

    public void createFeedTable(ArrayList<E12CollabFeedDetailObj> feedDataList) {
        try {
            final ScrollPanel scrPanel = new ScrollPanel();
            this.feedTableDataPanel.add((Widget)this.getFeedTableData(feedDataList, this.currentStartPos, this.displayFeedLength));
            this.feedTableDataPanel.setWidth("100%");
            scrPanel.add((Widget)this.feedTableDataPanel);
            VerticalPanel vPanel1 = new VerticalPanel();
            vPanel1.add((Widget)scrPanel);
            if (feedDataList.size() - this.displayFeedLength > 0) {
                HorizontalPanel hPanel = this.getPostPagerPanel(feedDataList);
                vPanel1.add((Widget)hPanel);
                vPanel1.setCellHorizontalAlignment((Widget)hPanel, HasHorizontalAlignment.ALIGN_CENTER);
            }
            this.updateSize();
            scrPanel.setHeight(String.valueOf(this.height) + "px");
            scrPanel.setWidth("100%");
            Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    CollabFeedDetailPanel.this.updateSize();
                    CollabFeedDetailPanel.this.feedTableDataPanel.setWidth("100%");
                    scrPanel.setWidth("100%");
                    scrPanel.setHeight(String.valueOf(CollabFeedDetailPanel.this.height) + "px");
                }
            });
            vPanel1.setWidth("100%");
            this.userFeedContainer.add((Widget)vPanel1);
        }
        catch (Exception e) {
            Window.alert((String)("Exception in createFeedTable: " + e.getMessage()));
        }
    }

    public void createHeaderPanel() {
        try {
            HTML nameHtml = new HTML(this.entry.getGroupName());
            nameHtml.setStyleName("collabGroupName");
            HTML discriptionHtml = new HTML(this.entry.getGroupDescr());
            discriptionHtml.setStyleName("collabGroupDiscription");
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.setStyleName(this.entry.getGroupImage());
            final Image groupImage = new Image("/ibase/collaborate/images/groups/" + this.entry.getGroupId().trim() + ".png");
            groupImage.addErrorHandler(new ErrorHandler(){

                public void onError(ErrorEvent event) {
                    groupImage.setUrl("/ibase/collaborate/images/groups/default.png");
                }
            });
            groupImage.setSize("32px", "32px");
            hPanel.add((Widget)groupImage);
            String groupOwner = this.entry.getGroupOwner().trim();
            String groupModerator = this.entry.getGroupModerator().trim();
            String postAllowTo = this.entry.getPostAllowTo().trim();
            boolean isAllowPost = false;
            if (postAllowTo.equalsIgnoreCase("A")) {
                isAllowPost = true;
            }
            if (!isAllowPost && postAllowTo.equalsIgnoreCase("O") && groupOwner.equals(E12Constants.userID.trim())) {
                isAllowPost = true;
            }
            if (!isAllowPost && postAllowTo.equalsIgnoreCase("M") && groupModerator.equals(E12Constants.userID.trim())) {
                isAllowPost = true;
            }
            if (E12RIA.callertInterface.equalsIgnoreCase("BROWSER") && isAllowPost) {
                this.addPostButton();
            }
            this.header.setWidget(0, 0, (Widget)hPanel);
            this.header.getFlexCellFormatter().setRowSpan(0, 0, 2);
            this.header.getFlexCellFormatter().setHeight(0, 0, "32px");
            this.header.getFlexCellFormatter().setWidth(0, 0, "32px");
            this.header.setWidget(0, 1, (Widget)nameHtml);
            this.header.setWidget(1, 0, (Widget)discriptionHtml);
            this.header.setStyleName("collabHeaderPanel");
        }
        catch (Exception e) {
            Window.alert((String)("Exception in createHeaderPanel() :{" + e.getMessage() + " }"));
            e.printStackTrace();
        }
    }

    public VerticalPanel addPostUserImagePanel(final E12CollabFeedDetailObj feedDetailObj) {
        VerticalPanel postDiscriptionPanel = new VerticalPanel();
        String postOwnerStr = feedDetailObj.getPostOwner();
        String posterName = feedDetailObj.getPosterName();
        HTML postNameHtml = new HTML(posterName);
        final Image postImageUrl = new Image("/ibase/collaborate/images/users/" + postOwnerStr.trim() + ".png");
        postImageUrl.addErrorHandler(new ErrorHandler(){

            public void onError(ErrorEvent event) {
                postImageUrl.setUrl("/ibase/collaborate/images/users/default.png");
            }
        });
        postImageUrl.setSize("48px", "48px");
        final PopupPanel posterDescrPanel = new PopupPanel();
        posterDescrPanel.setStyleName("posterDescrPanel");
        postImageUrl.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                CollabFeedDetailPanel.this.setPosterDescrPanel(feedDetailObj, posterDescrPanel, false);
                posterDescrPanel.setPopupPosition(event.getClientX() + 5, event.getClientY() + 5);
            }
        });
        postImageUrl.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                CollabFeedDetailPanel.this.setPosterDescrPanel(feedDetailObj, posterDescrPanel, true);
                posterDescrPanel.setPopupPosition(event.getClientX() + 5, event.getClientY() + 5);
            }
        });
        postNameHtml.setStyleName("collabPostName");
        String postDateStr = feedDetailObj.getPostDate();
        HTML postDateHtml = new HTML(postDateStr);
        postDateHtml.setStyleName("collabPostDate");
        postDiscriptionPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        postDiscriptionPanel.add((Widget)postImageUrl);
        postDiscriptionPanel.setStyleName("collabPostDiscriptionPanel");
        return postDiscriptionPanel;
    }

    public SimplePanel addDiscriptionPanel(E12CollabFeedDetailObj feedDetailObj) {
        SimplePanel discriptionPanel = new SimplePanel();
        HTML postDiscriptionFeedHtml = new HTML(feedDetailObj.getUserFeedDescription());
        postDiscriptionFeedHtml.setStyleName("collabPostDiscription");
        discriptionPanel.add((Widget)postDiscriptionFeedHtml);
        discriptionPanel.setStyleName("collabDiscriptionPanel");
        return discriptionPanel;
    }

    public HorizontalPanel addAttachmentPanel(E12CollabFeedDetailObj feedDetailObj) {
        HorizontalPanel hAttachmentPanel = new HorizontalPanel();
        hAttachmentPanel.setSpacing(3);
        HorizontalPanel attchmentInfoPanel = new HorizontalPanel();
        hAttachmentPanel.setWidth("100%");
        hAttachmentPanel.add((Widget)attchmentInfoPanel);
        attchmentInfoPanel.setStyleName("collabAttchmentInfoPanel");
        ArrayList<AttachmentObj> attachmentList = feedDetailObj.getAttachmentList();
        final String userGroupId = feedDetailObj.getUserGroupId();
        for (final AttachmentObj attachmentObj : attachmentList) {
            final String fileType = attachmentObj.getFileType().trim();
            String fileUrl = attachmentObj.getFileUrl();
            final String fileName = attachmentObj.getFileName();
            final String fileId = attachmentObj.getFileId();
            if (!fileDownloadStatusMap.containsKey(fileId)) {
                fileDownloadStatusMap.put(fileId, false);
            }
            HorizontalPanel hImagePanel = new HorizontalPanel();
            hImagePanel.setSpacing(2);
            hImagePanel.setWidth("100%");
            Label imageLabel = new Label();
            final Anchor attachmentFileName = new Anchor();
            attachmentFileName.setStyleName("collabAttachmentFileName");
            attachmentFileName.setEnabled(true);
            Label indicatingLabel = new Label("downloading...");
            indicatingLabel.setStyleName("collabIndicatingLable");
            DownloadStatusBean statusBean = new DownloadStatusBean(indicatingLabel, attachmentFileName, attachmentObj);
            fileDownloadStatusBean.put(fileId, statusBean);
            if (fileTypeImageMap.containsKey(fileType)) {
                imageLabel.setStyleName(fileTypeImageMap.get(fileType));
            } else {
                imageLabel.setStyleName("defaultImage");
            }
            attachmentFileName.setHTML(fileName);
            attachmentFileName.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.Navigator.getUserAgent().indexOf("Android") == -1) {
                        String url = attachmentObj.getFileUrl();
                        if (url != null && !url.equalsIgnoreCase("")) {
                            Window.open((String)url, (String)"_blank", (String)"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
                        } else {
                            Window.alert((String)E12Constants.constants.setNoUrl());
                        }
                    } else {
                        if (!attachmentObj.getDownload() && !fileDownloadStatusMap.get(fileId).booleanValue()) {
                            CollabFeedDetailPanel.this.downloadFile(fileId, userGroupId, fileName, fileType, attachmentObj, attachmentFileName);
                        }
                        if (attachmentObj.getDownload()) {
                            CollabFeedDetailPanel.this.viewFile(attachmentObj.getFileName());
                        }
                    }
                }
            });
            if (!fileDownloadStatusMap.get(fileId).booleanValue() && "Y".equals(this.isAutoDownload) && Window.Navigator.getUserAgent().indexOf("Android") != -1) {
                this.downloadFile(fileId, userGroupId, fileName, fileType, attachmentObj, attachmentFileName);
            } else {
                indicatingLabel.setVisible(false);
                indicatingLabel.setText("");
            }
            if (!(fileType.equalsIgnoreCase("jpg") || fileType.equalsIgnoreCase("png") || fileType.equalsIgnoreCase("gif") || fileType.equalsIgnoreCase("jpeg"))) {
                hImagePanel.add((Widget)imageLabel);
                hImagePanel.add((Widget)attachmentFileName);
            } else {
                final Image attachImage = new Image(attachmentObj.getFileUrl());
                attachImage.addLoadHandler(new LoadHandler(){

                    public void onLoad(LoadEvent event) {
                        if (attachImage.getWidth() > CollabFeedDetailPanel.this.feedTableDataPanel.getElement().getClientWidth() - 200) {
                            attachImage.setWidth("100%");
                        }
                    }
                });
                final PopupPanel imagePanel = new PopupPanel(){

                    public boolean onKeyDownPreview(char key, int modifiers) {
                        switch (key) {
                            case '\u001b': {
                                this.hide();
                            }
                        }
                        return true;
                    }
                };
                attachImage.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        String url = attachmentObj.getFileUrl();
                        if (url != null && !url.equalsIgnoreCase("")) {
                            if (!imagePanel.isShowing()) {
                                imagePanel.clear();
                            }
                            final Image image = new Image(url);
                            image.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    imagePanel.hide();
                                    imagePanel.clear();
                                }
                            });
                            final ScrollPanel scrPanel = new ScrollPanel();
                            image.addLoadHandler(new LoadHandler(){

                                public void onLoad(LoadEvent event) {
                                    int imageHeight = image.getHeight();
                                    int imageWidth = image.getWidth();
                                    if ((double)imageHeight >= (double)Window.getClientHeight() * 0.9) {
                                        scrPanel.setHeight(String.valueOf((double)Window.getClientHeight() * 0.9) + "px");
                                    } else if (imageHeight <= 100) {
                                        image.setHeight("100px");
                                    } else {
                                        scrPanel.setHeight(String.valueOf(imageHeight + 20) + "px");
                                    }
                                    if ((double)imageWidth >= (double)Window.getClientWidth() * 0.9) {
                                        scrPanel.setWidth(String.valueOf((double)Window.getClientWidth() * 0.9) + "px");
                                    } else if (imageWidth <= 100) {
                                        image.setWidth("100px");
                                    } else {
                                        scrPanel.setWidth(String.valueOf(imageWidth + 20) + "px");
                                    }
                                    imagePanel.center();
                                }
                            });
                            scrPanel.add((Widget)image);
                            imagePanel.add((Widget)scrPanel);
                            imagePanel.addStyleName("imagePopupPanel");
                            imagePanel.setAutoHideEnabled(true);
                            imagePanel.setGlassEnabled(true);
                            imagePanel.setGlassStyleName("imagePanelGlassStyle");
                            imagePanel.setAnimationEnabled(true);
                            imagePanel.show();
                            imagePanel.center();
                            if (!attachmentObj.getDownload() && !fileDownloadStatusMap.get(fileId).booleanValue() && Window.Navigator.getUserAgent().indexOf("Android") != -1) {
                                CollabFeedDetailPanel.this.downloadFile(fileId, userGroupId, fileName, fileType, attachmentObj, attachmentFileName);
                            }
                        } else {
                            Window.alert((String)E12Constants.constants.setNoUrl());
                        }
                    }
                });
                hImagePanel.add((Widget)attachImage);
            }
            hImagePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            if (this.isMobileOS.booleanValue()) {
                hImagePanel.add((Widget)indicatingLabel);
            }
            attchmentInfoPanel.add((Widget)hImagePanel);
        }
        return hAttachmentPanel;
    }

    public void downloadFile(final String fileId, String userGroupId, String fileName, String fileType, AttachmentObj attachmentObj, Anchor attachmentFileName, final Callback<AndroidDownloader.Result, Exception> callback) {
        try {
            String winHostUrl = "";
            AndroidDownloader downloader = new AndroidDownloader();
            AndroidDownloader.Params params = new AndroidDownloader.Params();
            params.setDirName("/mnt/sdcard/base/");
            params.setFileName(fileName);
            downloader.downloadFile(String.valueOf(winHostUrl) + "/ibase/WebITMDocumentHandlerServlet?USER=" + E12Constants.userID + "&PASSWORD=" + E12Constants.passwordSha256 + "&isSHA256Appld=true&ACTION=GET_DOCUMENT&DOC_ID=" + fileId + "&DOC_TYPE=" + fileType, params, new AndroidDownloader.Callback(){

                public void onSuccess(AndroidDownloader.Result result) {
                    fileDownloadStatusMap.put(fileId, true);
                    try {
                        if (result.getStatus()) {
                            fileDownloadStatusMap.put(fileId, false);
                            fileDownloadStatusBean.get(fileId).getAttachmentObj().setDownload(true);
                            callback.onSuccess((Object)result);
                        }
                    }
                    catch (Exception e) {
                        Window.alert((String)("Exception occurred! " + e.getLocalizedMessage()));
                    }
                }

                public void onError(Exception e) {
                    callback.onFailure((Object)e);
                }
            });
        }
        catch (Exception e) {
            Window.alert((String)(" Exception " + e.getMessage()));
        }
    }

    public void viewFile(String fileName) {
        FileViewer fileViewer = new FileViewer();
        String fileContentType = fileViewer.getContentType(fileViewer.getFileType(fileName));
        String fileUrl = "/mnt/sdcard/base/" + fileName;
        try {
            if (fileName.indexOf(".base") != -1) {
                this.playVideo(fileUrl);
            } else if (!fileUrl.equalsIgnoreCase("") && !fileContentType.equalsIgnoreCase("")) {
                fileViewer.showFile(fileUrl, fileContentType);
            } else {
                Window.alert((String)E12Constants.constants.setFileNotShow());
            }
        }
        catch (Exception e) {
            Window.alert((String)E12Constants.constants.setCheckFileFormat());
        }
    }

    public void playVideo(String fileUrl) {
        String path = "";
        path = !fileUrl.contains("file://") && fileUrl.startsWith("/mnt") ? "file://" + fileUrl : fileUrl;
    }

    protected void addPostButton() {
        try {
            final Label postButton = new Label();
            postButton.setStyleName("addButton");
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            hPanel.setSpacing(5);
            hPanel.add((Widget)postButton);
            final Label addNewLabel = new Label(E12Constants.constants.setNewLbl());
            addNewLabel.setStyleName("addNewLabel");
            hPanel.add((Widget)addNewLabel);
            this.header.setWidget(0, 2, (Widget)hPanel);
            this.header.getFlexCellFormatter().setRowSpan(0, 2, 2);
            addNewLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    E12Global.currentGroup = CollabFeedDetailPanel.this.entry;
                    CollabFeedDetailPanel.this.drawCollabPost();
                }
            });
            addNewLabel.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    addNewLabel.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                }
            });
            postButton.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    postButton.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                }
            });
            postButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    E12Global.currentGroup = CollabFeedDetailPanel.this.entry;
                    CollabFeedDetailPanel.this.drawCollabPost();
                }
            });
            if (E12Global.getInstance().getDeviceType() == E12Global.DeviceType.Tablet) {
                postButton.setVisible(false);
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception in addPostButton: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void drawCollabPost() {
        try {
            EntryWrapper entry = new EntryWrapper();
            entry.setTitle(" Collaborate Post ");
            entry.setObjName("colab_post_gwt");
            entry.setObjType("W");
            String randomID = String.valueOf(E12Constants.userID) + this.generateRandomNo();
            entry.setId("ID001~" + randomID);
            E12Wizard e12Wizard = new E12Wizard(entry, randomID, entry.getId(), BaseE12.callerInterface);
            e12Wizard.showWizardPanelDialog();
        }
        catch (Exception e) {
            Window.alert((String)("E12ColabFeedDetailPanel :: drawCollabPost :" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private int generateRandomNo() {
        int randNo = -1;
        randNo = (int)(Math.random() * 1.0E9) + 1;
        return randNo;
    }

    public void updateSize() {
        this.height = Window.getClientHeight() - 155;
    }

    private VerticalPanel getFeedTableData(ArrayList<E12CollabFeedDetailObj> feedDataList, int currentStartPos, int displayFeedLength) {
        this.feedTableDataPanel.clear();
        this.feedTableDataPanel.add((Widget)this.header);
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setWidth("100%");
        int i = currentStartPos;
        while (i < feedDataList.size() && i < currentStartPos + displayFeedLength) {
            E12CollabFeedDetailObj feedDetailObj = feedDataList.get(i);
            FlexTable feedInfoTable = new FlexTable();
            feedInfoTable.setStyleName("collabFeedInfoTable");
            feedInfoTable.setWidget(0, 0, (Widget)this.addPostUserImagePanel(feedDetailObj));
            feedInfoTable.getFlexCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_TOP);
            feedInfoTable.getFlexCellFormatter().setVerticalAlignment(0, 2, HasVerticalAlignment.ALIGN_TOP);
            feedInfoTable.getFlexCellFormatter().addStyleName(0, 0, "collabPostDicriptionVPanel");
            feedInfoTable.getFlexCellFormatter().addStyleName(0, 2, "collabPostDicriptionVPanel");
            feedInfoTable.getFlexCellFormatter().setRowSpan(0, 0, 2);
            feedInfoTable.getFlexCellFormatter().setRowSpan(0, 2, 2);
            feedInfoTable.setWidget(0, 1, (Widget)this.addDiscriptionPanel(feedDetailObj));
            feedInfoTable.setWidget(1, 0, (Widget)this.addAttachmentPanel(feedDetailObj));
            feedInfoTable.setWidget(0, 2, (Widget)this.addPosterDateLabel(feedDetailObj));
            vPanel.add((Widget)feedInfoTable);
            ++i;
        }
        if (currentStartPos == 0) {
            this.feedDataFirstButton.setEnabled(false);
            this.feedDataPreButton.setEnabled(false);
        } else {
            this.feedDataFirstButton.setEnabled(true);
            this.feedDataPreButton.setEnabled(true);
        }
        if (currentStartPos + displayFeedLength >= feedDataList.size()) {
            this.feedDataLastButton.setEnabled(false);
            this.feedDataNextButton.setEnabled(false);
        } else {
            this.feedDataLastButton.setEnabled(true);
            this.feedDataNextButton.setEnabled(true);
        }
        int totalPage = feedDataList.size() / this.displayFeedLength;
        if (feedDataList.size() % this.displayFeedLength != 0) {
            ++totalPage;
        }
        this.feedDataLabel.setText("Page " + (this.currentStartPos / this.displayFeedLength + 1) + " of " + totalPage);
        this.feedDataLabel.setTitle("Page " + (this.currentStartPos / this.displayFeedLength + 1) + " of " + totalPage);
        return vPanel;
    }

    private HorizontalPanel getPostPagerPanel(final ArrayList<E12CollabFeedDetailObj> feedDataList) {
        HorizontalPanel hPanel = new HorizontalPanel();
        int totalPage = feedDataList.size() / this.displayFeedLength;
        if (feedDataList.size() % this.displayFeedLength != 0) {
            ++totalPage;
        }
        final int countTotalPages = totalPage;
        this.feedDataFirstButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CollabFeedDetailPanel.this.currentStartPos = 0;
                CollabFeedDetailPanel.this.feedTableDataPanel.add((Widget)CollabFeedDetailPanel.this.getFeedTableData(feedDataList, CollabFeedDetailPanel.this.currentStartPos, CollabFeedDetailPanel.this.displayFeedLength));
            }
        });
        this.feedDataLastButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CollabFeedDetailPanel.this.currentStartPos = (countTotalPages - 1) * CollabFeedDetailPanel.this.displayFeedLength;
                CollabFeedDetailPanel.this.feedTableDataPanel.add((Widget)CollabFeedDetailPanel.this.getFeedTableData(feedDataList, CollabFeedDetailPanel.this.currentStartPos, CollabFeedDetailPanel.this.displayFeedLength));
            }
        });
        this.feedDataNextButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CollabFeedDetailPanel collabFeedDetailPanel = CollabFeedDetailPanel.this;
                collabFeedDetailPanel.currentStartPos = collabFeedDetailPanel.currentStartPos + CollabFeedDetailPanel.this.displayFeedLength;
                CollabFeedDetailPanel.this.feedTableDataPanel.add((Widget)CollabFeedDetailPanel.this.getFeedTableData(feedDataList, CollabFeedDetailPanel.this.currentStartPos, CollabFeedDetailPanel.this.displayFeedLength));
            }
        });
        this.feedDataPreButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CollabFeedDetailPanel collabFeedDetailPanel = CollabFeedDetailPanel.this;
                collabFeedDetailPanel.currentStartPos = collabFeedDetailPanel.currentStartPos - CollabFeedDetailPanel.this.displayFeedLength;
                if (CollabFeedDetailPanel.this.currentStartPos < 0) {
                    CollabFeedDetailPanel.this.currentStartPos = 0;
                }
                CollabFeedDetailPanel.this.feedTableDataPanel.add((Widget)CollabFeedDetailPanel.this.getFeedTableData(feedDataList, CollabFeedDetailPanel.this.currentStartPos, CollabFeedDetailPanel.this.displayFeedLength));
            }
        });
        hPanel.add((Widget)this.feedDataFirstButton);
        hPanel.add((Widget)this.feedDataPreButton);
        hPanel.add((Widget)this.feedDataLabel);
        hPanel.setCellVerticalAlignment((Widget)this.feedDataLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        hPanel.add((Widget)this.feedDataNextButton);
        hPanel.add((Widget)this.feedDataLastButton);
        hPanel.setSpacing(10);
        return hPanel;
    }

    private void setPosterDescrPanel(E12CollabFeedDetailObj feedDetailObj, PopupPanel posterDescrPanel, boolean isVisible) {
        String posterName = feedDetailObj.getPosterName();
        HTML postNameHtml = new HTML(posterName);
        postNameHtml.setStyleName("collabPostName");
        if (!isVisible) {
            posterDescrPanel.add((Widget)postNameHtml);
            posterDescrPanel.show();
        } else {
            posterDescrPanel.hide();
            posterDescrPanel.clear();
        }
    }

    public Label addPosterDateLabel(E12CollabFeedDetailObj feedDetailObj) {
        String postDateStr = feedDetailObj.getPostDate();
        String currFormat = "yyyy-MM-dd HH:mm:ss.S";
        String reqFormat = "dd-MM-yy hh:mm a";
        SimpleDateFormat format1 = new SimpleDateFormat(currFormat);
        SimpleDateFormat format2 = new SimpleDateFormat(reqFormat);
        Label dateLabel = new Label(postDateStr);
        try {
            dateLabel.setText(format2.format(format1.parse(postDateStr)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        dateLabel.getElement().setAttribute("style", "color:black;");
        return dateLabel;
    }

    private void downloadFile(final String fileId, String userGroupId, String fileName, String fileType, AttachmentObj attachmentObj, Anchor attachmentFileName) {
        final Label indicatingLabel = fileDownloadStatusBean.get(fileId).getIndicatingLabel();
        this.downloadFile(fileId, userGroupId, fileName, fileType, attachmentObj, attachmentFileName, new Callback<AndroidDownloader.Result, Exception>(){

            public void onFailure(Exception reason) {
                Window.alert((String)E12Constants.constants.setFailedDownload());
                indicatingLabel.setVisible(false);
                indicatingLabel.setText("");
            }

            public void onSuccess(AndroidDownloader.Result result) {
                Anchor attachmentFileName = fileDownloadStatusBean.get(fileId).getAttachmentFileName();
                indicatingLabel.setVisible(false);
                indicatingLabel.setText("");
                attachmentFileName.setEnabled(true);
            }
        });
    }

    public void createCollabPostFeeds(ArrayList<E12CollabFeedDetailObj> feedDataList) {
    }

    public VerticalPanel addUserImagePanel(E12CollabFeedDetailObj feedDetailObj) {
        VerticalPanel userImagePanel = new VerticalPanel();
        return userImagePanel;
    }

    private class DownloadStatusBean {
        private Label indicatingLabel;
        private Anchor attachmentFileName;
        private AttachmentObj attachmentObj;
        private boolean isDownload = false;

        public DownloadStatusBean(Label indicatingLabel, Anchor attachmentFileName, AttachmentObj attachmentObj) {
            this.indicatingLabel = indicatingLabel;
            this.attachmentFileName = attachmentFileName;
            this.attachmentObj = attachmentObj;
        }

        public Label getIndicatingLabel() {
            return this.indicatingLabel;
        }

        public boolean isDownload() {
            return this.isDownload;
        }

        public void setDownload(boolean isDownload) {
            this.isDownload = isDownload;
        }

        public Anchor getAttachmentFileName() {
            return this.attachmentFileName;
        }

        public AttachmentObj getAttachmentObj() {
            return this.attachmentObj;
        }
    }
}

