package ibase.webitm.ejb.gst;


import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.w3c.dom.Document;

@javax.ejb.Stateless
public class GstClearDataPrc extends ProcessEJB implements GstClearDataPrcLocal,GstClearDataPrcRemote
{

	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	E12GenericUtility genericUtility = new E12GenericUtility();
	Connection connLocal = null,connGST = null;

	Timestamp fromDate = null, toDate = null , fromdateOracle = null, todateOracle=null;
	String chgUser = "",chgTerm = "",loginSiteCode = "",currDateStr = "",fromDateOrcle="",toDateOrcle="" ;
	java.sql.Timestamp currDate = null,sysDate = null;
	Timestamp currMonthStartDate = null;
	Timestamp julyMonthStartDate = null;
	double GST_B2CL_INV_VAL = 0.0;

	StringBuffer errorMessage =null;

	public String process() throws RemoteException, ITMException 
	{
		return "";
	}

	public String process(String xmlString, String xmlString2,String windowName, String xtraParams) throws RemoteException,ITMException 
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;

		try 
		{
			System.out.println("xmlString   [" + xmlString + "]");
			System.out.println("xmlString2  [" + xmlString2 + "]");
			System.out.println("windowName   [" + windowName + "]");
			System.out.println("xtraParams   [" + xtraParams + "]");

			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if (xmlString2 != null && xmlString2.length() != 0) 
			{
				detailDom = genericUtility.parseString(xmlString2);
			}

			retStr = process(headerDom, detailDom, windowName, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception GstDataPrc :process()"+ e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		
		StringBuffer errorMessage = new StringBuffer();
		PreparedStatement pstmt = null; 
		ResultSet rs = null;

		String fromDateStr = "", toDateStr = "", prcType = "", sitecode="" ;
		int prdCnt = 0 , synDataCount= 0, hdrCount=0;

		String retString = "";
		String period = "", type = "", sql = "";
		
		boolean isError = false;
		try
		{
			System.out.println("CommonConstants.DB_NAME"+ CommonConstants.DB_NAME );
			long startTime = System.currentTimeMillis();
			System.out.println("START TIME FOR GST DATA POPULATION PROCESS IN SECONDS:::["+startTime/1000+"]");

			connGST = getConnection();

			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");

			System.out.println("LoginSiteCode"+loginSiteCode);

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			sysDate = new java.sql.Timestamp(System.currentTimeMillis());

			System.out.println("sysdate newly added"+sysDate);
			currDateStr = sdf.format(sysDate);

			System.out.println("currDateStr"+currDateStr);

			currDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");

			System.out.println("current date newly added"+currDate);

			Calendar c = Calendar.getInstance();   
			c.set(Calendar.DAY_OF_MONTH, 1);
			currMonthStartDate = Timestamp.valueOf(genericUtility.getValidDateString(sdf.format(c.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");


			c.set(2017, 06, 01);
			julyMonthStartDate = Timestamp.valueOf(genericUtility.getValidDateString(sdf.format(c.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");

			System.out.println("julyMonthStartDate"+julyMonthStartDate.getTime());

			period = checkNull(genericUtility.getColumnValue("prd_code", headerDom));
			type = genericUtility.getColumnValue("gst_type",headerDom);
			fromDateStr = genericUtility.getColumnValue("from_date",headerDom);
			toDateStr = genericUtility.getColumnValue("to_date",headerDom);
			sitecode= genericUtility.getColumnValue("site_code",headerDom);



			System.out.println("Login SiteCode["+loginSiteCode+"] PrdCode["+period+"] Type["+type+"] ProcessType[::"+prcType+"] sitecode["+sitecode+"]" );

			if(period == null || period.trim().length() == 0)
			{
				retString = itmDBAccessEJB.getErrorString("","VTBLNKPRD","","",connGST);
				return retString;
			}
			else if(period !=null && period.trim().length() > 0)
			{


				if(!"P".equalsIgnoreCase(prcType) && !"C".equalsIgnoreCase(prcType))
				{

					sql="SELECT COUNT(1) AS SynCnt from gst_data_hdr where submit_status='P' ";
					pstmt = connGST.prepareStatement(sql);

					rs = pstmt.executeQuery();

					if(rs.next())
					{
						synDataCount = rs.getInt("SynCnt");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs!=null)
					{
						rs.close();
						rs = null;
					}

					if (synDataCount == 0)
					{
						System.out.println("no data available for syncing");
						retString = itmDBAccessEJB.getErrorString("","VMSYNNULL","","",connGST);
						return retString;
					}
				}

				System.out.println("synDataCount"+synDataCount);


				sql = "SELECT COUNT(1) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";

				pstmt = connGST.prepareStatement(sql);
				pstmt.setString(1, period);

				rs = pstmt.executeQuery();

				if(rs.next())
				{
					prdCnt = rs.getInt("CNT");
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}

				if (prdCnt == 0)
				{
					System.out.println("period code not found in period master");
					retString = itmDBAccessEJB.getErrorString("","CNDIPRDINV","","",connGST);
					return retString;
				}

				if(fromDateStr != null && fromDateStr.trim().length() > 0)
				{
					fromDate = Timestamp.valueOf(genericUtility.getValidDateString( fromDateStr , genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				}
				else
				{
					System.out.println("from date is null");
					retString = itmDBAccessEJB.getErrorString("","VMDATNULL","","",connGST);
					return retString;
				}
				if(toDateStr != null && toDateStr.trim().length() > 0)
				{
					toDate = Timestamp.valueOf(genericUtility.getValidDateString( toDateStr , genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				}
				else
				{
					System.out.println("to date is null");
					retString = itmDBAccessEJB.getErrorString("","VMDATNULL","","",connGST);
					return retString;
				}

				if(fromDate.after(toDate))
				{
					System.out.println("from date is seleted is before to date");
					retString = itmDBAccessEJB.getErrorString("","VMDTGTR","","",connGST);
					return retString;
				}
			}

			sql = "DELETE  FROM GST_DATA_HDR WHERE SUBMIT_STATUS ='P' and REC_TYPE= ? AND SITE_CODE= ? AND  DOC_DATE BETWEEN ? AND ? " ; 

			pstmt = connGST.prepareStatement(sql);
			if ("S".equalsIgnoreCase(type))
			{
				pstmt.setString(1, "1");
			}
			else
			{
				pstmt.setString(1, "2");
			}
			pstmt.setString(2,sitecode);
			pstmt.setTimestamp(3,fromDate);
			pstmt.setTimestamp(4,toDate);


			 hdrCount = pstmt.executeUpdate();

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(hdrCount > 0)
			{
				errorMessage.append("\n All pending data cleared successfully ! No Of records deleted "+hdrCount);
			}
			else
			{
				errorMessage.append("\n No Pending Records found for clear operation !!!");
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println(e);
			errorMessage.append("\n["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					connGST.rollback();
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt=null;
					}
					if(rs!=null)
					{
						rs.close();
						rs = null;
					}
					retString = getError(errorMessage.toString(),"PRCNOTDONE",connGST);
				}
				
				if((retString == null || retString.trim().length() == 0) && !isError)
				{
					System.out.println("inside commit");
					connGST.commit();
					if(hdrCount > 0)
					{
						retString = getError(errorMessage.toString(),"PRCSUCCESS",connGST);	
					}
					else
					{
						retString = getError(errorMessage.toString(),"PRCNOTDONE",connGST);
					}
				}
				if(connGST != null && !connGST.isClosed())
				{
					connGST.close();
					connGST=null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GstClearDataPrc.process()["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
				
			}
		}
		return retString;
	}
	public String getError(String message,String Code, Connection conn)  throws ITMException
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  itmDBAccessEJB.getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}

	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		}
		return input;
	}

}