CREATE TABLE POB_HDR
(
TRAN_ID		 CHAR(10) NOT NULL,
TRAN_DATE	 DATE NOT NULL,
SITE_CODE	 CHAR(5) NOT NULL,
ITEM_SER	 CHAR(5),
ORDER_TYPE	 VARCHAR2(3),
CUST_CODE	 CHAR(10) NOT NULL,
SC_CODE		 CHAR(10),
SC_MOBILE_NO_1	 VARCHAR2(15),
SC_MOBILE_NO_2	 VARCHAR2(15),
SC_TELE_1	 VARCHAR2(15),
SC_TELE_2	 VARCHAR2(15),
SC_EMAIL_ADDR	 VARCHAR2(40),
RETAILER_CODE	 CHAR(10),
RET_MOBILE_NO_1	 VARCHAR2(15),
RET_MOBILE_NO_2	 VARCHAR2(15),
RET_TELE_1	 VARCHAR2(15),
RET_TELE_2	VARCHAR2(15),
EMP_CODE__ORD 	CHAR(10),
ORDERED_BY 	CHAR(1),
DLV_CFA 	CHAR(1),
DLV_CFA_DT 	DATE,
DUE_DATE 	DATE,
LAST_ORD_DT 	DATE,
LAST_ORD_VALUE 	NUMBER(14,3),
LAST_ORD_POD 	char(1),
WF_STATUS 	CHAR(1),
STATUS_DATE 	DATE,
CONFIRMED 	CHAR(1),
CONF_DATE 	DATE,
REMARKS	 	VARCHAR2(60),
EMP_CODE__APRV 	CHAR(10),
ADD_DATE	 DATE,
ADD_USER	 CHAR(10),
ADD_TERM	 VARCHAR2(15),
CHG_DATE	 DATE,
CHG_USER	 CHAR(10),
CHG_TERM 	VARCHAR2(15),
PHARMACY_OWN 	CHAR(1)
) TABLESPACE "ITM_DIS_D1" ;

ALTER TABLE POB_HDR ADD CONSTRAINT POB_HDR_X PRIMARY KEY (TRAN_ID) USING INDEX TABLESPACE "ITM_DIS_I1";

CREATE TABLE POB_DET
(
TRAN_ID	 	CHAR(10) NOT NULL,
LINE_NO	 	NUMBER(3) NOT NULL,
ITEM_CODE	CHAR(10) NOT NULL,
RATE	 	NUMBER(15,4),
QUANTITY	NUMBER(14,3),
FREE_QTY	NUMBER(14,3),
TOT_QTY	 	NUMBER(14,3),
DISCOUNT	NUMBER(14,3),
NET_AMT	 	NUMBER(14,3)
) TABLESPACE "ITM_DIS_D1";
ALTER TABLE POB_DET ADD CONSTRAINT POB_DET_X PRIMARY KEY (TRAN_ID,LINE_NO) USING INDEX TABLESPACE "ITM_DIS_I1";


ALTER TABLE POB_DET ADD CONSTRAINT FK_POB_DET FOREIGN KEY (TRAN_ID) REFERENCES POB_HDR (TRAN_ID);




Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,OBJ_TYPE,CHG_USER,CHG_TERM,CHG_DATE) 
values ('DIS',11,12,0,0,0,'w_pob','POB Transaction','POB Transaction','DIS.11.12.0.0.0','e12_logo.gif','Z','BASE','BASE',sysdate);

Insert into user_rights (PROFILE_ID,APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,LEVEL_4,LEVEL_5,MENU_NAME,RIGHTS,ACC_FILT,DEF_FILT,OBJ_NAME,FAV_OPTION,FAV_ORDER,EXCLUDE_RIGHTS_CHAR,ATTACH_RIGHTS) values ('BASE','DIS',11,12,0,0,0,'POB Transaction','*',null,null,'pob','Y',null,null,null);

Insert into USER_OBJ_FAV (OBJ_NAME,USER_ID,CHG_DATE,CHG_USER,CHG_TERM) 
values ('pob','BASE',SYSDATE,'BASE','BASE');

INSERT INTO TRANSETUP
(TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,TRAN_ID_COL,CONFIRM_MODE,MAIL_OPTION,GARBAGE_OPT,WORKFLOW_OPT,TABLE_NAME,AUDIT_TRAIL_OPT,PERIOD_OPTION,EDIT_OPT,REF_SER,CONFIRM_COL,CONFIRM_VAL,isgwtinitiated,header_form_no)
VALUES ('w_pob','2','2','A','seq10','Y',sysdate,'BASE','BASE','1', 'tran_id','0','0','N','0','POB_HDR','0','M','0','T-POB','CONFIRMED','Y','Y','2');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',1,'Next','N','Next','1','U');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',2,'Next','N','Next','2','U');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',3,'Previous','P','Previous','2','U');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',4,'Previous','P','Previous','3','U');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',5,'Add','A','Add','3','U');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',6,'Select','L','Select','3','U');
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
VALUES ('pob',7,'Deselect All','D','Deselect','3','U');
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
values ('pob',8,'edit~normal.gif','Edit New Property','a','a','E','Edit','3','1','1','S',null,null,null,null,null,null,null);

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE)
VALUES ('pob',10,'X','1','audit_trail','View Audit Trail','View Audit','menu.bmp','1','1','1','U');

insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,FORM_NO,scr_flag)
values('w_pob','Filter','d_pob11','d_pob21','1','F');

insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,FORM_NO,scr_flag)
values('w_pob','Header','d_pob12','d_pob22','2','F');

insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,FORM_NO,scr_flag,assisted_mode)
values('w_pob','Detail','d_pob13','d_pob23','3','T','A');

Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('pob','default_data_wiz','1','poic_pob_gwt',null,'0',sysdate,'BASE','BASE','2','EJB','POBWizIC',null);


Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('pob','post_item_change','1','poic_pob_gwt',null,'0',sysdate,'BASE','BASE','2','EJB','POBWizIC',null);

Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('pob','pre_validate','1','ppv_pob_gwt',null,'0',sysdate,'BASE','BASE','2','EJB','POBWizIC',null);

Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('pob','pre_navigate_next','1','ppv_pob_gwt',null,'0',sysdate,'BASE','BASE','2','EJB','POBWizIC',null);



Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('poic_pob_gwt','itemchanged','http://localhost:9090/axis/services/ValidatorService',null,'itemChanged','String','S',null,null,sysdate,'BASE','BASE');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',1,'COMPONENT_TYPE','l',null,'S',null,sysdate,'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',2,'COMPONENT_NAME','l',null,'S',null,sysdate,'BASE      ','BASE','POBWizIC');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',3,'XML_DATA','l',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',4,'XML_DATA_1','l',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',5,'XML_DATA_ALL','l',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',6,'OBJ_CONTEXT','l',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',7,'FOCUSED_COLUMN','l',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',8,'EDIT_FLAG','l',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_pob_gwt',9,'XTRA_PARAMS','l',null,'S',null,sysdate,'BASE      ','BASE',null);

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('ppv_pob_gwt','Navigate','http://localhost:9090/axis/services/NavigatorService',null,'wfValData','String','S',null,null,sysdate,'BASE      ','BASE');


Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE      ','BASE','POBWizIC');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',3,'XML_DATA__ALL','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',4,'XML_DATA_1','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',5,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',6,'OBJ_CONTEXT','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',7,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('ppv_pob_gwt',8,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE      ','BASE',null);

Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','1','itm_default',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','2','itm_default',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','3','itm_default',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','1','cust_code','Y');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','1','order_type','Y');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','1','sc_code','Y');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','1','retailer_code','Y');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','1','item_ser','Y');
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','3','itm_default_add',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','3','item_code',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','3','rate',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','3','quantity',null);
Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('pob','3','free_qty',null);

update obj_itemchange set mandatory='Y' where obj_name='sorder' and form_no='2' and field_name='nature';


Insert into pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL,MULTI_OPT,SQL_INPUT)
values ('ORDER_TYPE','W_POB','select trim(order_type),descr from sordertype where order_type in(?)',null,'Order Type',0,0,SYSDATE,'BASE','BASE',0,0,0,':pob_order_type');


Insert into pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL,MULTI_OPT,SQL_INPUT)
values ('RETAILER_CODE','W_POB',
'select retailer_code,retailer_name from retailer where retailer_code in(select retailer_code from retailer_doctor where sc_code= ''?'') ',null,'Retailer',0,0,SYSDATE,'BASE','BASE',0,0,0,':sc_code');


Insert into pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN) 
values ('CUST_CODE','W_POB',' select trim(cust_code),cust_name from customer where cust_code in (select cust_code from sprs_stockist where sprs_code = ''?'') order by cust_code ',null,'Customer Code',0,0,null,null,null,'0',null,':login_code',0,null,null,null,null,null,0,null,null,null);

Insert into pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL,MULTI_OPT,SQL_INPUT)
values ('ITEM_CODE','W_POB','select item_code,descr,unit from item where item_code like ''?%''',null,'Item Code',0,0,SYSDATE,'BASE','BASE',0,0,0,':item_code');

Insert into disparm (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM)
values ('999999','POB_ORD_TYPE','S','F,SMP,NE,DON','Order type',0,sysdate,'SUN','BASE');

------messages querys
INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTSTCUSTCD', 'Invalid Customer Code','Customer Code you have entered is not existing in the sprs_stockist table with login.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMITEMNULL', 'Invalid Product Code!','Product Code Cannot Be Kept Blank.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');


INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMITEMNOT', 'Product Not Found!','Product Code you have entered is not existing in the item master.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMRETCDBK', 'Invalid Retailer Code!','Retailer Code Cannot Be Kept Blank.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMRETCD1', 'Retailer Code Not Found!','Retailer Code  you have entered is not found in the retailer master.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTDUPITM', 'Duplicate Product Code!','Product Code can not be duplicate.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTRATELESS', 'Invalid PTS!','PTS cannot be zero or less than zero.PriceList is not defined for entered Product Code!','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTQTYBLK', 'Invalid Chargeable Qty!','Chargeable Quantity Cannot Be Kept Blank.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTQTYLESS', 'Invalid Chargeable Qty!','Chargeable Quantity cannot be 0 or less than zero','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('INVLDQTY', 'Invalid Chargeable Qty!','Chargeable Quantity should be numeric value.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('INVLDFRQTY', 'Invalid Free Qty!','Free Quantity should be numeric value.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('INVLDISC', 'Invalid Discount !','Discount Percentage(%) should be numeric value.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMSTRGCDBK', 'Invalid Doctor!','Doctor Cannot Be Kept Blank.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');


INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMSTRGCD1', 'Doctor Not Found!','Doctor you have entered is not existing in the strg_customer master.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTORDTYNF1', 'Invalid Order Type!','Order Type you have entered is not existing in the sordertype master.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTSCMOBNO1', 'Invalid Doctor MobileNo1!','Invalid mobile number1. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');
INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTSCMOBNO2', 'Invalid Doctor MobileNo2!','Invalid mobile number2. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTREMOBNO1', 'Invalid Retailer MobileNo1!','Invalid mobile number1. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');
INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTREMOBNO2', 'Invalid Retailer MobileNo2!','Invalid mobile number2. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTPOBSUBM', 'Submit successful!','Selected transaction is submitted successfully.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTPOBDISPM', 'DIS parameter not defined!','Distribution parameter not defined for order Type, please define POB_ORD_TYPE','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTDISORTY', 'Invalid Order Type!','Order Type not match with POB_ORD_TYPE Distribution parameter value','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTPRCLIST', 'Invalid Customer!','PriceList is not defind in site_customer and customer table!','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTSTRGNO', 'Invalid Customer!','Entered Customer code is not defined in sprs_stockist table!','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

------pob view transaction
INSERT into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,OBJ_TYPE,CHG_USER,CHG_TERM,CHG_DATE) 
values ('DIS',11,13,0,0,0,'w_pob_view','POB List','POB List','DIS.11.13.0.0.0','e12_logo.gif','T','BASE','BASE',sysdate);


INSERT INTO TRANSETUP (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,TRAN_ID_COL,CONFIRM_MODE,MAIL_OPTION,GARBAGE_OPT,WORKFLOW_OPT,TABLE_NAME,AUDIT_TRAIL_OPT,PERIOD_OPTION,EDIT_OPT,REF_SER,WRKFLW_INIT,CONFIRM_COL,CONFIRM_VAL,SITE_ACC_COL,ledg_post_conf,chg_date_on_conf)
VALUES ('w_pob_view','2','2','A','seq10','Y',SYSDATE,'BASE','BASE','1', 'TRAN_ID','0','0','N','4','POB_HDR','0','M','0','T-POB','POB_CONF_WF','confirmed','Y',NULL,'N','Y');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) 
values ('pob_view',21,'menu.bmp','View Audit Trail','audit_trail','1','X','View Audit','1','1','U',sysdate,'base','base');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('pob_view',2,'C','a','wf_approve','Submit','Submit','approve.gif','1','2','U');

INSERT INTO obj_forms     (win_name,title,obj_brow_name,obj_edit_name,cross_update_expr,expr_fld_info,target_fld_info,expr_comment,form_no )
VALUES ('w_pob_view','Header','d_pob_view11','d_pob_view12',NULL,NULL,NULL,NULL,'1');

INSERT INTO obj_forms     (win_name,title,obj_brow_name,obj_edit_name,cross_update_expr,expr_fld_info,target_fld_info,expr_comment,form_no )
VALUES ('w_pob_view','Detail','d_pob_view21','d_pob_view22',NULL,NULL,NULL,NULL,'2');

Insert into system_events(OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES('pob_view','wf_approve','1','prcm_default_ejb','0',SYSDATE,'BASE','BASE','2','EJB','POBWizConf');


---Start added by chandra shekar on 08-Oct-2015

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTSTRGTEL1', 'Invalid Doctor Land Line1!','Invalid Land Line1. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');
INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTSTRGTEL2', 'Invalid Doctor Land Line2!','Invalid Land Line2. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTRETTEL1', 'Invalid Retailer Land Line1!','Invalid Land Line1. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');
INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VTRETTEL2', 'Invalid Retailer Land Line2!','Invalid Land Line2. please enter valid number.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMITSER', 'Invalid ItemSeries!','Item Series Cannot Be Kept Blank.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

---End added by chandra shekar on 08-Oct-2015


INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMDOCRETCD', 'Invalid Retailer Code!','Entered Retailer Code  is exist in the retailer_doctor master.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

--Added by Sagar on 13-OCT-15 , Start..
INSERT INTO pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,DEFAULT_COL,MULTI_OPT,SQL_INPUT)
VALUES ('SC_CODE','W_POB','select distinct(a.sc_code),b.first_name,b.middle_name,b.last_name from strg_series a,strg_customer b where a.sc_code = b.sc_code and a.item_ser=''?'' and a.sales_pers=''?'' ',NULL,'Doctor/Pharmacy ',0,0,SYSDATE,'BASE','BASE',0,0,0,':item_ser,:login_code');

INSERT INTO MESSAGES (msg_no , msg_str , msg_descr ,  msg_type ,  msg_opt , chg_date , chg_user , chg_term  )
VALUES ('VMSTRGSRCD', 'Doctor Not Found!','Doctor you have entered is not existing in the strg_series master.','E',   'Y',  SYSDATE,  'BASE ', 'BASE');

INSERT INTO obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE) 
VALUES ('pob',9,NULL,'Save',NULL,NULL,'S','Save','3',NULL,NULL,'U');

--Added by Sagar on 13-OCT-15 , End.





