/**
 *  Request ID: W16DSUN007   
 */
package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

import javax.ejb.Stateless;

@Stateless
public class PalletizationActConf extends ActionHandlerEJB
implements PalletizationActConfLocal, PalletizationActConfRemote
{

	E12GenericUtility genericUtility = new E12GenericUtility();

	public String confirm(String tranID, String xtraParams, String forcedFlag)
	throws RemoteException, ITMException
	{
		String retString = "";
		Connection conn = null;
		//ConnDriver connDriver = new ConnDriver();
		boolean isConn = true;
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;

			retString = confirm(tranID, xtraParams, forcedFlag, conn, isConn);

			if ((retString != null) && (retString.length() > 0))
			{
				throw new Exception("Exception while calling confirm for tran  Id:[" + tranID + "]");
			}
		}
		catch (Exception exception)
		{
			System.out.println("Exception in [PalletizationActConf]  " + exception.getMessage());
		}
		return retString;
	}

	public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn, boolean conStat) throws RemoteException, ITMException
	{
		System.out.println("PalletizationActConf Called........");

		boolean isError = false;
		String sql = "" ,errString = "" ,confirmed ="" ,sqlUpdate ="",empCodeAprv ="";
		ResultSet rs = null; 
		PreparedStatement pstmt = null ,pstmtUpdt = null;
		int stockCount = 0, updCnt = 0;
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		
		try
		{
			System.out.println(" tranId [" + tranId + "]");
			System.out.println(" force flag [" + forcedFlag + "]");
			System.out.println(" xtraParams --> [" + xtraParams + "]");
			empCodeAprv = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

			sql = "SELECT CONFIRMED FROM PALLET_HDR WHERE TRAN_ID=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
				System.out.println("CONFIRMED >>>>>>>" + confirmed);
			}
			if(pstmt!=null) { pstmt.close(); pstmt = null;}
			if(rs!=null){ rs.close();rs = null;}

			if ((confirmed != null) && ("Y".equalsIgnoreCase(confirmed)))
			{
				System.out.println("error" + errString);
				errString = itmdbAccess.getErrorString("", "VMTRANSCOF", "", "", conn);
				return errString;
			}

			sql="SELECT COUNT(1) FROM PALLET_DET WHERE TRAN_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				stockCount = rs.getInt(1);	
				System.out.println("Stock count for pallet_det::" +stockCount);
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if (stockCount > 0)
			{
				System.out.println("stock is present in pallet_det");
				errString = itmdbAccess.getErrorString("", "VMTRANNOCF", "");
				return errString;
			}
			else
			{
				System.out.println(" stock not present in pallet_det");
				sqlUpdate = "UPDATE  PALLET_HDR SET CONFIRMED=? ,CONF_DATE=? ,EMP_CODE__APRV=? WHERE TRAN_ID=?";
				pstmtUpdt = conn.prepareStatement(sqlUpdate);
				pstmtUpdt.setString(1, "Y");
				pstmtUpdt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
				pstmtUpdt.setString(3, empCodeAprv);
				pstmtUpdt.setString(4, tranId);

				updCnt = pstmtUpdt.executeUpdate();

				if (updCnt == 0)
				{
					errString = itmdbAccess.getErrorString("", "VMTRANNOUP", "");
					System.out.println("Pallet_hdr not updated:::::");
					return errString;
				}
				if(pstmtUpdt!=null)
				{
					pstmtUpdt.close();
					pstmtUpdt = null;
				}
			}
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if ( isError )
				{
					System.out.println("rollback");
					conn.rollback();
				}
				else 
				{
					System.out.println("commmit");
					conn.commit(); 
					errString = itmdbAccess.getErrorString("", "VMTRANSACN", "", "", conn);
				}
				if(pstmtUpdt!=null)
				{
					pstmtUpdt.close();
					pstmtUpdt = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String checkNullAndTrim(String inputVal)
	{
		if (inputVal == null)
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
}
