package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;

import ibase.webitm.bean.gst.BaseData;
import ibase.webitm.bean.gst.InvLineItem;
import ibase.webitm.bean.gst.Invoice;

abstract class BaseSerializer<T extends BaseData> extends JsonSerializer<T> 
{
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
    final SimpleDateFormat gstFmt = new SimpleDateFormat(gstCommonUtil.getGSTDateFormat());

    void writeInvoices(T genericInvoice, JsonGenerator json) throws IOException 
    {
        json.writeFieldName("inv");
        json.writeStartArray();

        for(Invoice inv : genericInvoice.invoices)
        {
        	writeInvoice(genericInvoice, json, inv);
        }
        
        json.writeEndArray();
    }

    private void writeInvoice(T genericInvoice, JsonGenerator json, Invoice inv) 
    {
        try 
        {
            json.writeStartObject();
            
            if( (inv.taxPayerAction != null) && ("A".equalsIgnoreCase(inv.taxPayerAction) || "M".equalsIgnoreCase(inv.taxPayerAction) || "D".equalsIgnoreCase(inv.taxPayerAction)) )
            {
            	json.writeStringField("flag", inv.taxPayerAction);
            	json.writeStringField("inum", inv.inum);
                json.writeStringField("idt", gstFmt.format(inv.idt));
                json.writeStringField("chksum", inv.checksum);
            }
            else
            {
            	if(inv.shippingPortCode != null)
            	{
            		json.writeStringField("sbpcode",inv.shippingPortCode);
            	}
                if(inv.shippingBillNum > 0)
                {
                	json.writeNumberField("sbnum", inv.shippingBillNum);
                }
                if(inv.shippingBillDt != null)
                {
                	json.writeStringField("sbdt", gstFmt.format(inv.shippingBillDt));
                }
            	json.writeStringField("inum", inv.inum);
                json.writeStringField("idt", gstFmt.format(inv.idt));
                json.writeNumberField("val", inv.val);
                if(inv.pos != null)
                {
                	json.writeStringField("pos", inv.pos);
                }
                if(genericInvoice.isReverseCharge)
                {
                	json.writeStringField("rchrg", inv.rchrg ? "Y" : "N");
                }
                if(inv.etin!=null)
                {
                	json.writeStringField("etin", inv.etin);
                }
                if(inv.invoiceType != null)
                {
                	json.writeStringField("inv_typ", inv.invoiceType);
                }
                
                writeLineItems(genericInvoice, json, inv);
            }

            json.writeEndObject();
        } 
        catch (Exception e) 
        {
        	System.out.println("BaseSerializer.writeInvoice()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }

    private void writeLineItems(T genericInvoice, JsonGenerator json, Invoice inv) throws IOException 
    {
        json.writeFieldName("itms");
        json.writeStartArray();
        
        for(InvLineItem li : inv.items)
        {
        	writeLineItem(genericInvoice, json, li);
        }

        json.writeEndArray();
    }

    private void writeLineItem(T genericInvoice, JsonGenerator json, InvLineItem li) 
    {
        try 
        {
            json.writeStartObject();
            
            if(li.num > 0 )
            {
            	json.writeNumberField("num", li.num);
            }
            
            if(!("EXP".equalsIgnoreCase(genericInvoice.getClass().getSimpleName()) || "EXPA".equalsIgnoreCase(genericInvoice.getClass().getSimpleName())))
            {
            	json.writeFieldName("itm_det");
            	json.writeStartObject();
            }
            json.writeNumberField("rt", li.rate);
            json.writeNumberField("txval", li.taxval);

            if(li.iamt > 0.0)
            {
            	json.writeNumberField("iamt", li.iamt);
            }
            
            if(li.camt > 0.0)
            {
            	json.writeNumberField("camt", li.camt);
            }
        	
            if(li.samt > 0.0)
            {
            	json.writeNumberField("samt", li.samt);
            }
            
            if(li.csamt > 0.0)
            {
            	json.writeNumberField("csamt", li.csamt);
            }
            
            if(!("EXP".equalsIgnoreCase(genericInvoice.getClass().getSimpleName()) || "EXPA".equalsIgnoreCase(genericInvoice.getClass().getSimpleName())))
            {
            	json.writeEndObject();
            }
            
            if(li.itcType != null && (li.igstInputTax > 0.0 || li.cgstInputTax > 0.0 || li.sgstInputTax > 0.0) || li.cessInputTax > 0.0)
            {
            	json.writeFieldName("itc");
            	json.writeStartObject();
            	
            	json.writeStringField("elg", li.itcType);
            	json.writeNumberField("tx_i", li.igstInputTax);
            	json.writeNumberField("tx_c", li.cgstInputTax);
            	json.writeNumberField("tx_s", li.sgstInputTax);
            	json.writeNumberField("tx_cs", li.cessInputTax);
            	
            	json.writeEndObject();
            }
            
            json.writeEndObject();
        }
        catch (Exception e) 
        {
        	System.out.println("BaseSerializer.writeLineItem()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }
}
