package ibase.client;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Window;


//import ibase.e12ria.client.E12AdvDataGrid;
//import ibase.e12ria.client.E12CommonUtils;
//import ibase.e12ria.client.E12Constants;
//import ibase.client.GWTDashBoardReport.Contact;


/**
 * This class is used to show the data in paged format.
 * 
 * @author base
 */

public class CellTableGridInfo
{
	public String siteFor;
	public String siteTo;
	public String itemCode;
	public String desc;
	public String lotNo;
	public String qtyOrd;
	public String unit;
	public String noArt;
	public String mfgDate;
	public String expiryDate;
	public String transType;
	public String tranCode;
	public String tranName;

	 
	 public CellTableGridInfo()
	 {
		 
	 }

	public CellTableGridInfo(String siteFor, String siteTo, String itemCode,String desc, String lotNo,String qtyOrd,
			                String unit,String noArt,String mfgDate,String expiryDate,String transType,String tranCode,
			                String tranName )
	{
		this.siteFor = siteFor;
		this.siteTo = siteTo;
		this.itemCode = itemCode;
		this.desc = desc;
		this.lotNo = lotNo;
		this.qtyOrd=qtyOrd;
		this.unit=unit;
		this.noArt=noArt;
		this.mfgDate=mfgDate;
		this.expiryDate=expiryDate;
		this.transType=transType;
		this.tranCode=tranCode;
		this.tranName=tranName;
	}
	
	public String getSiteFor()
	{
		return siteFor;
	}
	public String getSiteTo()
	{
		return siteTo;
	}
	public String getItemCode()
	{
		return itemCode;
	}
	public String getDescr()
	{
		return desc;
	}
	public String getLotNo()
	{
		return lotNo;
	}
	public String getQtyOrd()
	{
		return qtyOrd;
	}
	public String getUnit()
	{
		return unit;
	}
	public String getNoArt()
	{
		return noArt;
	}
	public String getMfgDate()
	{
		return mfgDate;
	}
	
	public String getExpiryDate()
	{
		return expiryDate;
	}
	public String getTransType()
	{
		return transType;
	}
	public String getTranCode()
	{
		return tranCode;
	}
	public String getTranName()
	{
		return tranName;
	}
	
	public void setDescr(String description)
	{
		this.desc = description;
	}
	public void setLotNo(String lotNo)
	{
		this.lotNo = lotNo;
	}
	public void setQtyOrd(String qtyOrd)
	{
		this.qtyOrd = qtyOrd;
	}
	public void setUnit(String unit)
	{
		this.unit = unit;
	}
	public void setNoArt(String noArt)
	{
		this.noArt = noArt;
	}
	public void setMfgDate(String mfgDate)
	{
		this.mfgDate = mfgDate;
	}
	public void setExpiryDate(String expiryDate)
	{
		this.expiryDate = expiryDate;
	}
	public void setTransType(String transType)
	{
		this.transType = transType;
	}
	public void setTranCode(String tranCode)
	{
		this.tranCode = tranCode;
	}
	public void setTranName(String tranName)
	{
		this.tranName = tranName;
	}
	
	
	@SuppressWarnings("unchecked")
	public ArrayList<String> getClassParameters(HashMap<String, HashMap> gridNGraphMeataDataMap)
	{
		 LinkedHashMap<String, List<String>> gridNameMap = null;
		 ArrayList<String> paramDtlList = new ArrayList<String>();
		 CellTableGridInfo gridInfo =null;
		try
		{
		      gridNameMap = (LinkedHashMap<String, List<String>>) gridNGraphMeataDataMap.get("columnName");
		      gridInfo= new CellTableGridInfo();
		      for (Map.Entry<String, List<String>> entry : gridNameMap.entrySet())
				{
					String key = entry.getKey();
					List<String> values = entry.getValue();
					if(values.size()==1)
					{
						 paramDtlList.add(values.get(0));
					}
					if(values.size()>1)
					{
						paramDtlList.add(values.get(0));
						paramDtlList.add(values.get(1));
						
					}
					
				 }
		     
		}
		catch(Exception e)
		{
			Window.alert( "Excpetion in CellTableGridInfo:getClassParameters():["+e.getMessage()+"]" );
		}
		return paramDtlList;
		
	}
	public List<CellTableGridInfo> getDataInfo(HashMap<String, HashMap> gridNGraphMeataDataMap,JSONObject jsonObjGridData)
	{
		LinkedHashMap<String, List<String>> gridIDMap = null;
		JSONObject jsonEachRow = null;
		CellTableGridInfo info = null;
		String siteFor=null;
		String siteTo=null;
		String itemCode=null;
		String desc=null;
		String lotNo=null;
		String qtyOrd=null;
		String unit=null;
		String noArt=null;
		String mfgDate=null;
		String expiryDate=null;
		String transType=null;
		String tranCode=null;
		String tranName=null;
		ArrayList<String> graphDtlList = null;
		List<CellTableGridInfo> dataList = null;
		try
		{
			dataList=new ArrayList<CellTableGridInfo>();
			gridIDMap = (LinkedHashMap<String, List<String>>) gridNGraphMeataDataMap.get("grid");
			JSONObject jsonObjData =(JSONObject) jsonObjGridData.get("grid");
			ArrayList<String> arrList = null;
			for(int jRowCtr=0;jRowCtr<jsonObjData.size();jRowCtr++)
			{
				int count=0;
				info= new CellTableGridInfo();
				jsonEachRow = new JSONObject();
				jsonEachRow = (JSONObject) jsonObjData.get(""+jRowCtr);

			    if(jsonEachRow!=null)
			    {
				for(int i=0;i<jsonEachRow.size();i++)
				{
					arrList= new ArrayList<String>();
				for (Map.Entry<String, List<String>> entry : gridIDMap.entrySet())
				{
					String key = entry.getKey();
					List<String> values = entry.getValue();
					    if(values.size()==1)
					    {
					    	 arrList.add((""+jsonEachRow.get(""+values.get(0))).replace('"', ' '));
							/* siteTo      =  (""+jsonEachRow.get(""+values.get(1))).replace('"', ' ');	
							 itemCode    =  (""+jsonEachRow.get(""+values.get(2))).replace('"', ' ');	
							 desc        =  (""+jsonEachRow.get(""+values.get(3))).replace('"', ' ');	
							 lotNo       =  (""+jsonEachRow.get(""+values.get(4))).replace('"', ' ');	
							 qtyOrd      =  (""+jsonEachRow.get(""+values.get(5))).replace('"', ' ');	
							 unit        =  (""+jsonEachRow.get(""+values.get(6))).replace('"', ' ');	
							 noArt       =  (""+jsonEachRow.get(""+values.get(7))).replace('"', ' ');	
							 mfgDate     =  (""+jsonEachRow.get(""+values.get(8))).replace('"', ' ');	
							 expiryDate  =  (""+jsonEachRow.get(""+values.get(9))).replace('"', ' ');	
							 transType   =  (""+jsonEachRow.get(""+values.get(10))).replace('"', ' ');	
							 tranCode    =  (""+jsonEachRow.get(""+values.get(11))).replace('"', ' ');	
							 tranName    =  (""+jsonEachRow.get(""+values.get(12))).replace('"', ' ');	*/
					    	 count++;
					    }
				    }
				}
				
				info= new CellTableGridInfo(arrList.get(0),arrList.get(1),arrList.get(2),arrList.get(3),arrList.get(4),
						arrList.get(5),arrList.get(6),arrList.get(7),arrList.get(8),arrList.get(9),
						arrList.get(10),arrList.get(11),arrList.get(12) );
				dataList.add(info);
			}
			}
		}
		catch(Exception e)
		{
		}
		return dataList;
	}
	
	public void setCellTableColumn(ArrayList<String> paramDtlList,CellTable<CellTableGridInfo> table)
	{
		if(paramDtlList!=null)
		{
				String siteFor = checkNull(paramDtlList.get(0));
				TextColumn<CellTableGridInfo> siteForColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.siteFor;
				      }
				    };
				//  currInColumn.setSortable(true);    
				table.addColumn(siteForColumn,siteFor);
				
				String siteTo =checkNull( paramDtlList.get(1));
				TextColumn<CellTableGridInfo> siteToColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.siteTo;
				      }
				    };
				//  currOutColumn.setSortable(true);    
				table.addColumn(siteToColumn,siteTo);
				
				String itemCode = checkNull(paramDtlList.get(2));
				TextColumn<CellTableGridInfo> itemCodeColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.itemCode;
				      }
				    };
				//  preInColumn.setSortable(true);   
				table.addColumn(itemCodeColumn,itemCode);
				
				String descr = checkNull(paramDtlList.get(3));
				TextColumn<CellTableGridInfo> descColumn = new TextColumn<CellTableGridInfo>() {
					@Override
					public String getValue(CellTableGridInfo contact) {
						return contact.desc;
					}
				};
				descColumn.setSortable(true);    
				table.addColumn(descColumn,descr);	
				
				
				
				String lotNo =checkNull(paramDtlList.get(4));
				TextColumn<CellTableGridInfo> lotNoColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.lotNo;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(lotNoColumn,lotNo);
				String qtyOrd =checkNull(paramDtlList.get(5));
				TextColumn<CellTableGridInfo> qtyOrdColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.qtyOrd;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(qtyOrdColumn,qtyOrd);
				
				String unit =checkNull(paramDtlList.get(6));
				TextColumn<CellTableGridInfo> unitColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.unit;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(unitColumn,unit);
				
				
				String noArt =checkNull(paramDtlList.get(7));
				TextColumn<CellTableGridInfo> noArtColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.noArt;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(noArtColumn,noArt);
				
				String mfgDate =checkNull(paramDtlList.get(8));
				TextColumn<CellTableGridInfo> mfgDateColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.mfgDate;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(mfgDateColumn,mfgDate);
				
				String expiryDate =checkNull(paramDtlList.get(9));
				TextColumn<CellTableGridInfo> expiryDateColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.expiryDate;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(expiryDateColumn,expiryDate);
				String transType =checkNull(paramDtlList.get(10));
				TextColumn<CellTableGridInfo> transTypeColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.transType;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(transTypeColumn,transType);
				
				String tranCode =checkNull(paramDtlList.get(11));
				TextColumn<CellTableGridInfo> tranCodeColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.tranCode;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(tranCodeColumn,tranCode);
				
				String tranName =checkNull(paramDtlList.get(12));
				TextColumn<CellTableGridInfo> tranNameColumn = new TextColumn<CellTableGridInfo>() {
				      @Override
				      public String getValue(CellTableGridInfo contact) {
				        return contact.tranName;
				      }
				    };
				//  preOutColumn.setSortable(true);  
				table.addColumn(tranNameColumn,tranName);
				
		}
	}
	
  private String checkNull(String str)
	{
		if(str == "null")
		{
			return "";
		}
		else
		{
			return str ;
		}

	}
	
}
