package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import org.json.simple.JSONObject;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import javax.ejb.Stateless;

@Stateless
public class AdminPlan extends ValidatorEJB implements AdminPlanLocal,AdminPlanRemote 
{
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getAdminPlanSummary(String dataSourceName,String loginId,String salePersons, String loginEmpCode) throws RemoteException, ITMException 
	{
		JSONObject rawDataAdminPlanDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "",fromDate = "",toDate = "",periodCode = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		SimpleDateFormat formatter = null;
		int count = 0,year = 0,month = 0;
		Calendar cal = null;
		double percntVal = 0.0, actWorkDays = 0.0, planWorkDays= 0.0,totalCircle = 629.0, dashOffSet = 0.0;		
		
		try 
		{
			salePersons = checkNull(salePersons);
			conn        = connDriver.getConnectDB(dataSourceName);
			connDriver  = null;
			formatter   = new SimpleDateFormat("dd-MMM-yy");
			cal = Calendar.getInstance();
		    year = cal.get(Calendar.YEAR);
		    month = cal.get(Calendar.MONTH)+1;
		    if(month < 10){
		    	periodCode = year +"0"+month;
		    }
		    else{
		    	periodCode = year +""+month;
		    }
			fromDate = getDateString("firstDayOfMonth",formatter);
			toDate = getDateString("lastDayOfMonth",formatter);
			System.out.println("fromDate:"+fromDate+" toDate:"+toDate);
			
			if("".equalsIgnoreCase(salePersons)){
				
				sql = "select sum(work_days) as act_work_days,sum(adm_work_days) as plan_work_days,emp_name from " +
					  "(SELECT CASE WHEN TO_CHAR(Query1.WORK_DAYS) IS NULL THEN '0' ELSE TO_CHAR(Query1.WORK_DAYS) END" +
					  " AS WORK_DAYS, Query2.WORK_DAYS AS ADM_WORK_DAYS, (select emp_fname || ' ' || emp_lname from employee " +
				      "where emp_code = (select emp_code from users where code='"+loginId+"')) AS emp_name FROM ((SELECT COUNT(SR.STATION_TYPE) AS WORK_DAYS, " +
					  "SR.STATION_TYPE, SP.SPRS_CODE__FOR FROM SPRS_PLAN SP INNER JOIN LOCALITY L ON SP.LOCALITY_CODE = L.LOCALITY_CODE " +
					  "INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE  = L.LOCALITY_CODE WHERE SPRS_CODE__FOR  in (select emp_code from employee start with emp_code = (select emp_code from users where code='"+loginId+"') connect by prior emp_code = report_to) " +
					  "AND SP.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY SR.STATION_TYPE,SP.SPRS_CODE__FOR ORDER BY SR.STATION_TYPE ) Query1 " +
					  "RIGHT JOIN (SELECT SPPS.STAN_TYPE, SPPS.WORK_DAYS FROM SF_PLAN_PARAM_STAN SPPS JOIN sf_plan_param SPP ON SPPS.PRD_CODE       = SPP.PRD_CODE " +
					  "WHERE SPPS.PARAM_TABLE = SPP.PARAM_TABLE AND SPP.PARAM_TABLE    = (SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'PARAM_TABLE') AND SPP.PRD_CODE  = '"+periodCode+"' " +
					  "ORDER BY SPPS.stan_type ) Query2 ON Query1.STATION_TYPE = Query2.STAN_TYPE) ORDER BY Query2.STAN_TYPE) group by emp_name";
			}
			else {
				
				sql = "select sum(work_days) as act_work_days,sum(adm_work_days) as plan_work_days,emp_name from " +
					  "(SELECT CASE WHEN TO_CHAR(Query1.WORK_DAYS) IS NULL THEN '0' ELSE TO_CHAR(Query1.WORK_DAYS) END" +
					  " AS WORK_DAYS, Query2.WORK_DAYS AS ADM_WORK_DAYS, (select emp_fname || ' ' || emp_lname from employee " +
					  "where emp_code = '"+salePersons+"') AS emp_name FROM ((SELECT COUNT(SR.STATION_TYPE) AS WORK_DAYS, " +
					  "SR.STATION_TYPE, SP.SPRS_CODE__FOR FROM SPRS_PLAN SP INNER JOIN LOCALITY L ON SP.LOCALITY_CODE = L.LOCALITY_CODE " +
					  "INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE  = L.LOCALITY_CODE WHERE SPRS_CODE__FOR  in (select emp_code from employee start with emp_code = '"+salePersons+"' connect by prior emp_code = report_to) " +
					  "AND SP.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY SR.STATION_TYPE,SP.SPRS_CODE__FOR ORDER BY SR.STATION_TYPE ) Query1 " +
					  "RIGHT JOIN (SELECT SPPS.STAN_TYPE, SPPS.WORK_DAYS FROM SF_PLAN_PARAM_STAN SPPS JOIN sf_plan_param SPP ON SPPS.PRD_CODE       = SPP.PRD_CODE " +
					  "WHERE SPPS.PARAM_TABLE = SPP.PARAM_TABLE AND SPP.PARAM_TABLE    = (SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'PARAM_TABLE') AND SPP.PRD_CODE  = '"+periodCode+"' " +
					  "ORDER BY SPPS.stan_type ) Query2 ON Query1.STATION_TYPE = Query2.STAN_TYPE) ORDER BY Query2.STAN_TYPE) group by emp_name";
			}
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			
			while(rs.next())
			{
				rowData      = new JSONObject();
				actWorkDays  = rs.getDouble("act_work_days");
				planWorkDays = rs.getDouble("plan_work_days");
				if(planWorkDays != 0.0){
					percntVal    = (actWorkDays / planWorkDays) * 100.0D;
				}
				dashOffSet   = totalCircle * percntVal / 100.0D;
				if (percntVal > 100) {
					percntVal = 100;
		        }
		        rowData.put("emp_name", checkNull(rs.getString("emp_name")));
		        rowData.put("sales_pers", salePersons);
		        rowData.put("prd_code", periodCode);
		        rowData.put("fr_date", fromDate);
		        rowData.put("to_date", toDate);
		        rowData.put("act_work_days", checkNull(rs.getString("act_work_days")));
		        rowData.put("plan_work_days", checkNull(rs.getString("plan_work_days")));
		        rowData.put("percentage", Long.valueOf(Math.round(percntVal)));
		        rowData.put("dashOffSet", Double.valueOf(dashOffSet));
		        rowData.put("tbldisplay", "style='display: visible'");
		        rowData.put("circledisplay", "c100");
		        if("".equalsIgnoreCase(salePersons)){
		        	rowData.put("sp_code", loginEmpCode);
		        }
		        else {
		        	rowData.put("sp_code", salePersons);
				}
		        rawDataAdminPlanDtlJson.put(count, rowData);
		        count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			System.out.println("rawDataPlanDtlJson :"+rawDataAdminPlanDtlJson);
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in AdminPlan:getAdminPlanDtl()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataAdminPlanDtlJson;
	}
	
	public String getDateString(String dateCondition,SimpleDateFormat formatter ) {
        Calendar cal = Calendar.getInstance(); 
        
        if("firstDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+1);
        }
        if("yesterday".equalsIgnoreCase(dateCondition)){
        	cal.add(Calendar.DATE, -1);
        }
        if("lastDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+7);
        }
        if("firstDayOfMonth".equalsIgnoreCase(dateCondition)){
        	cal.set(Calendar.DAY_OF_MONTH, 1);
        }
        if("lastDayOfMonth".equalsIgnoreCase(dateCondition)){
        	cal.add(Calendar.MONTH, 1);  
        	cal.set(Calendar.DAY_OF_MONTH, 1);  
        	cal.add(Calendar.DATE, -1);  
            System.out.println("Last Day of Month: " + formatter.format(cal.getTime())); 
        }
		return formatter.format(cal.getTime());
	}
	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str.trim() ;
   		}
   	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getAdminPlanDetail(String dataSourceName, String loginId,String salePersons,String loginEmpCode,String period,String fromDate,String toDate, String spCode,String prvSpCode) throws RemoteException, ITMException {

		JSONObject rawDataAdminPlanDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "",empName = "", statType = "", planWorkDaysStr = "",actWorkDaysStr = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "",salesPersCode = "";
		int count = 0;
		double percntVal = 0.0, actWorkDays = 0.0, planWorkDays= 0.0,totalCircle = 629.0, dashOffSet = 0.0;		
		long percentage = 0;
		TreeMap<String, ArrayList<HashMap<String, String>>> salPersMap = null;
		ArrayList<HashMap<String, String>> spStatDetailList = null;
		HashMap<String, String> spStatDetailmap = null;
		StringBuffer htmlBuffer = null;
		
		try 
		{
			salePersons  = checkNull(salePersons);
			fromDate     = checkNull(fromDate);
			toDate       = checkNull(toDate);
			period       = checkNull(period);
			spCode       = checkNull(spCode);
			loginId      = checkNull(loginId);
			prvSpCode    = checkNull(prvSpCode);
		    loginEmpCode = checkNull(loginEmpCode);
			conn         = connDriver.getConnectDB(dataSourceName);
			connDriver   = null;
			System.out.println("fromDate:"+fromDate+" toDate:"+toDate+" period:"+period+" salePersons"+salePersons);
			
			appendSQL = " (select emp_code from employee where report_to = '"+spCode+"')";
			
			sql = "SELECT CASE WHEN TO_CHAR(Query1.WORK_DAYS) IS NULL THEN '0' ELSE TO_CHAR(Query1.WORK_DAYS) END AS WORK_DAYS, " +
				  "Query2.STAN_TYPE AS STATION_TYPE, Query2.WORK_DAYS AS ADM_WORK_DAYS, Query1.SPRS_CODE__FOR AS SPRS_CODE, " +
				  "Query1.emp_name FROM( (SELECT COUNT(SR.STATION_TYPE) AS WORK_DAYS, SR.STATION_TYPE, SP.SPRS_CODE__FOR, " +
				  "e.emp_fname || ' ' || e.emp_lname AS emp_name FROM SPRS_PLAN SP INNER JOIN LOCALITY L ON SP.LOCALITY_CODE = L.LOCALITY_CODE " +
				  "INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE  = L.LOCALITY_CODE INNER JOIN EMPLOYEE E ON E.EMP_CODE   = SP.SPRS_CODE__FOR " +
				  "WHERE SPRS_CODE__FOR  in "+appendSQL+" AND SP.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY SR.STATION_TYPE,SP.SPRS_CODE__FOR," +
				  "e.emp_fname,e.emp_lname ORDER BY SR.STATION_TYPE ) Query1 RIGHT JOIN (SELECT SPPS.STAN_TYPE, SPPS.WORK_DAYS FROM SF_PLAN_PARAM_STAN SPPS " +
				  "JOIN sf_plan_param SPP ON SPPS.PRD_CODE = SPP.PRD_CODE WHERE SPPS.PARAM_TABLE = SPP.PARAM_TABLE AND SPP.PARAM_TABLE    = (" +
				  "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'PARAM_TABLE') AND SPP.PRD_CODE  = '"+period+"' ORDER BY SPPS.stan_type ) Query2 " +
				  "ON Query1.STATION_TYPE = Query2.STAN_TYPE) WHERE Query1.SPRS_CODE__FOR IS NOT NULL ORDER BY Query1.EMP_NAME,Query2.STAN_TYPE";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			salPersMap  = new TreeMap<String, ArrayList<HashMap<String, String>>>();
			
			while(rs.next())
			{
				salesPersCode   = checkNull(rs.getString("SPRS_CODE"));
				actWorkDays     = rs.getDouble("WORK_DAYS");
				planWorkDays    = rs.getDouble("ADM_WORK_DAYS");
				empName         = checkNull(rs.getString("emp_name"));
				statType        = checkNull(rs.getString("STATION_TYPE"));
				actWorkDaysStr  = checkNull(rs.getString("WORK_DAYS"));
				planWorkDaysStr = checkNull(rs.getString("ADM_WORK_DAYS"));
				
				if(planWorkDays != 0.0){
					percntVal    = (actWorkDays / planWorkDays) * 100.0D;
					percentage   = Long.valueOf(Math.round(percntVal));
					if (percentage > 100) {
						percentage = 100;
			        } 
				}
				dashOffSet   = totalCircle * percntVal / 100.0D;
				
				if(salPersMap.containsKey(salesPersCode)){
					spStatDetailList = salPersMap.get(salesPersCode);
					spStatDetailmap  = new HashMap<String, String>();
					spStatDetailmap.put("actWorkDaysStr", actWorkDaysStr);
					spStatDetailmap.put("planWorkDaysStr", planWorkDaysStr);
					spStatDetailmap.put("statType", statType);
					spStatDetailmap.put("salesPersCode", salesPersCode);
					spStatDetailmap.put("empName", empName);
					spStatDetailmap.put("percentage", String.valueOf(percentage));
					if (dashOffSet > totalCircle) {
			        	spStatDetailmap.put("dashOffSet", String.valueOf(totalCircle));
			        } 
			        else {
						spStatDetailmap.put("dashOffSet", String.valueOf(dashOffSet));
					}
					spStatDetailList.add(spStatDetailmap);
					salPersMap.put(salesPersCode, spStatDetailList);
				}
				else{
					spStatDetailList = new ArrayList<HashMap<String,String>>();
					spStatDetailmap  = new HashMap<String, String>();
					spStatDetailmap.put("actWorkDaysStr", actWorkDaysStr);
					spStatDetailmap.put("planWorkDaysStr", planWorkDaysStr);
					spStatDetailmap.put("statType", statType);
					spStatDetailmap.put("salesPersCode", salesPersCode);
					spStatDetailmap.put("empName", empName);
					spStatDetailmap.put("percentage", String.valueOf(percentage));
					if (dashOffSet > totalCircle) {
			        	spStatDetailmap.put("dashOffSet", String.valueOf(totalCircle));
			        } 
			        else {
						spStatDetailmap.put("dashOffSet", String.valueOf(dashOffSet));
					}
					spStatDetailList.add(spStatDetailmap);
					salPersMap.put(salesPersCode, spStatDetailList);
				}
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			for (Map.Entry<String, ArrayList<HashMap<String, String>>> entry : salPersMap.entrySet()) {
				salesPersCode = entry.getKey();
				spStatDetailList = entry.getValue();
				System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
				String spName = spStatDetailList.get(0).get("empName");
				htmlBuffer = getSPHtmlString(spStatDetailList);
				
				rowData         = new JSONObject();
				rowData.put("emp_name", spName);
				rowData.put("emp_code", salesPersCode);
				rowData.put("prd_code", period);
		        rowData.put("fr_date", fromDate);
		        rowData.put("to_date", toDate);
		        rowData.put("tbldisplay", "style='display: visible'");
		        rowData.put("circledisplay", "c100");
		        rowData.put("plan_display", htmlBuffer.toString());
		        rowData.put("prd_code", period);
		        rowData.put("fr_date", fromDate);
		        rowData.put("to_date", toDate);
		        rowData.put("prv_sp_code", spCode);
		        
		        rawDataAdminPlanDtlJson.put(count, rowData);
		        count++;
			}
			System.out.println("rawDataPlanDtlJson :"+rawDataAdminPlanDtlJson);
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in AdminPlan:getAdminPlanDtl()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataAdminPlanDtlJson;
	
	}

	private StringBuffer getSPHtmlString(ArrayList<HashMap<String, String>> spStatDetailList) {
		StringBuffer htmlBuffer = new StringBuffer("<tr>");
		HashMap<String, String> spStatDetailmap = null;
		int count    = 0;
		String tdStr = "";
		
		for (Iterator<HashMap<String, String>> iterator = spStatDetailList.iterator(); iterator.hasNext();) {
			spStatDetailmap = (HashMap<String, String>) iterator.next();
			tdStr = "<td align = 'center' width = '30%' style='padding-top: 15px;'><table><tr><td class='cardViewTableVer' align='center'><div class='c100  p"+spStatDetailmap.get("percentage")+" green' style='font-size: 115px;'><span class='internalSpan' style='top: 50px !important;'>  "+spStatDetailmap.get("actWorkDaysStr")+"/"+spStatDetailmap.get("planWorkDaysStr")+"  </span><div class='slice'><div class='bar'></div><div class='fill'></div></div></div></td></tr><tr><td class='cardViewTableVer' align='center'> "+spStatDetailmap.get("statType")+" </td></tr><tr><td class='cardViewTableVer' align='center'></td></tr></table></td>";
			
			if(count!=0 && count%3==0){
				htmlBuffer.append("</tr><tr>");
			}
			
			htmlBuffer.append(tdStr);
			count++;
		}
		if(count%3 == 1)
		{
			htmlBuffer.append("<td align = 'center' width = '30%'></td>");
			htmlBuffer.append("<td align = 'center' width = '30%'></td>");
		}
		if(count%3 == 2)
		{
			htmlBuffer.append("<td align = 'center' width = '30%'></td>");
		}
		htmlBuffer.append("</tr>");
		return htmlBuffer;
	}
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getSalePersPlanDetail(String dataSourceName, String loginId,String loginEmpCode,String period,String fromDate,String toDate, String spCode,String prvSpCode) throws RemoteException, ITMException {

		JSONObject rawDataSPPlanDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "",empName = "", statType = "", planWorkDaysStr = "",actWorkDaysStr = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "",salesPersCode = "";
		int count = 0;
		double percntVal = 0.0, actWorkDays = 0.0, planWorkDays= 0.0,totalCircle = 629.0, dashOffSet = 0.0;		
		long percentage = 0;
		TreeMap<String, ArrayList<HashMap<String, String>>> salPersMap = null;
		ArrayList<HashMap<String, String>> spStatDetailList = null;
		HashMap<String, String> spStatDetailmap = null;
		StringBuffer htmlBuffer = null;
		
		try 
		{
			fromDate     = checkNull(fromDate);
			toDate       = checkNull(toDate);
			period       = checkNull(period);
			spCode       = checkNull(spCode);
			loginId      = checkNull(loginId);
			prvSpCode    = checkNull(prvSpCode);
		    loginEmpCode = checkNull(loginEmpCode);
			conn         = connDriver.getConnectDB(dataSourceName);
			connDriver   = null;
			System.out.println("fromDate:"+fromDate+" toDate:"+toDate+" period:"+period);
			
			appendSQL = " (select emp_code from employee where report_to = '"+spCode+"')";
			sql = "SELECT CASE WHEN TO_CHAR(Query1.WORK_DAYS) IS NULL THEN '0' ELSE TO_CHAR(Query1.WORK_DAYS) END AS WORK_DAYS, " +
				  "Query2.STAN_TYPE AS STATION_TYPE, Query2.WORK_DAYS AS ADM_WORK_DAYS, Query1.SPRS_CODE__FOR AS SPRS_CODE, " +
				  "Query1.emp_name FROM( (SELECT COUNT(SR.STATION_TYPE) AS WORK_DAYS, SR.STATION_TYPE, SP.SPRS_CODE__FOR, " +
				  "e.emp_fname || ' ' || e.emp_lname AS emp_name FROM SPRS_PLAN SP INNER JOIN LOCALITY L ON SP.LOCALITY_CODE = L.LOCALITY_CODE " +
				  "INNER JOIN SPRS_ROUTE SR ON SR.LOCALITY_CODE  = L.LOCALITY_CODE INNER JOIN EMPLOYEE E ON E.EMP_CODE   = SP.SPRS_CODE__FOR " +
				  "WHERE SPRS_CODE__FOR  in "+appendSQL+" AND SP.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY SR.STATION_TYPE,SP.SPRS_CODE__FOR," +
				  "e.emp_fname,e.emp_lname ORDER BY SR.STATION_TYPE ) Query1 RIGHT JOIN (SELECT SPPS.STAN_TYPE, SPPS.WORK_DAYS FROM SF_PLAN_PARAM_STAN SPPS " +
				  "JOIN sf_plan_param SPP ON SPPS.PRD_CODE = SPP.PRD_CODE WHERE SPPS.PARAM_TABLE = SPP.PARAM_TABLE AND SPP.PARAM_TABLE    = (" +
				  "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'PARAM_TABLE') AND SPP.PRD_CODE  = '"+period+"' ORDER BY SPPS.stan_type ) Query2 " +
				  "ON Query1.STATION_TYPE = Query2.STAN_TYPE) WHERE Query1.SPRS_CODE__FOR IS NOT NULL ORDER BY Query1.EMP_NAME,Query2.STAN_TYPE";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			salPersMap  = new TreeMap<String, ArrayList<HashMap<String, String>>>();
			
			while(rs.next())
			{
				salesPersCode   = checkNull(rs.getString("SPRS_CODE"));
				actWorkDays     = rs.getDouble("WORK_DAYS");
				planWorkDays    = rs.getDouble("ADM_WORK_DAYS");
				empName         = checkNull(rs.getString("emp_name"));
				statType        = checkNull(rs.getString("STATION_TYPE"));
				actWorkDaysStr  = checkNull(rs.getString("WORK_DAYS"));
				planWorkDaysStr = checkNull(rs.getString("ADM_WORK_DAYS"));
				
				if(planWorkDays != 0.0){
					percntVal    = (actWorkDays / planWorkDays) * 100.0D;
					percentage   = Long.valueOf(Math.round(percntVal));
					if (percentage > 100) {
						percentage = 100;
			        }
				}
				dashOffSet   = totalCircle * percntVal / 100.0D;
				
				if(salPersMap.containsKey(salesPersCode)){
					spStatDetailList = salPersMap.get(salesPersCode);
					spStatDetailmap  = new HashMap<String, String>();
					spStatDetailmap.put("actWorkDaysStr", actWorkDaysStr);
					spStatDetailmap.put("planWorkDaysStr", planWorkDaysStr);
					spStatDetailmap.put("statType", statType);
					spStatDetailmap.put("salesPersCode", salesPersCode);
					spStatDetailmap.put("empName", empName);
					spStatDetailmap.put("percentage", String.valueOf(percentage));
					if (dashOffSet > totalCircle) {
			        	spStatDetailmap.put("dashOffSet", String.valueOf(totalCircle));
			        } 
			        else {
						spStatDetailmap.put("dashOffSet", String.valueOf(dashOffSet));
					}
					spStatDetailList.add(spStatDetailmap);
					salPersMap.put(salesPersCode, spStatDetailList);
				}
				else{
					spStatDetailList = new ArrayList<HashMap<String,String>>();
					spStatDetailmap  = new HashMap<String, String>();
					spStatDetailmap.put("actWorkDaysStr", actWorkDaysStr);
					spStatDetailmap.put("planWorkDaysStr", planWorkDaysStr);
					spStatDetailmap.put("statType", statType);
					spStatDetailmap.put("salesPersCode", salesPersCode);
					spStatDetailmap.put("empName", empName);
					spStatDetailmap.put("percentage", String.valueOf(percentage));
					if (dashOffSet > totalCircle) {
			        	spStatDetailmap.put("dashOffSet", String.valueOf(totalCircle));
			        } 
			        else {
						spStatDetailmap.put("dashOffSet", String.valueOf(dashOffSet));
					}
					spStatDetailList.add(spStatDetailmap);
					salPersMap.put(salesPersCode, spStatDetailList);
				}
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			for (Map.Entry<String, ArrayList<HashMap<String, String>>> entry : salPersMap.entrySet()) {
				salesPersCode = entry.getKey();
				spStatDetailList = entry.getValue();
				System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
				String spName = spStatDetailList.get(0).get("empName");
				htmlBuffer = getSPHtmlString(spStatDetailList);
				
				rowData         = new JSONObject();
				rowData.put("emp_name", spName);
				rowData.put("emp_code", salesPersCode);
				rowData.put("prd_code", period);
		        rowData.put("fr_date", fromDate);
		        rowData.put("to_date", toDate);
		        rowData.put("tbldisplay", "style='display: visible'");
		        rowData.put("circledisplay", "c100");
		        rowData.put("plan_display", htmlBuffer.toString());
		        rowData.put("prd_code", period);
		        rowData.put("fr_date", fromDate);
		        rowData.put("to_date", toDate);
		        rowData.put("prv_sp_code", spCode);
		        
		        rawDataSPPlanDtlJson.put(count, rowData);
		        count++;
			}
			System.out.println("rawDataSPPlanDtlJson :"+rawDataSPPlanDtlJson);
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in AdminPlan:getSalePersPlanDetail()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataSPPlanDtlJson;
	}
}
