/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import ibase.e12ria.client.CustomScreenLayoutWidget;
import ibase.e12ria.client.LayoutAnimationCallback;
import ibase.e12ria.shared.ScreenDTO;
import ibase.e12ria.shared.TabDTO;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.layout.AnimationCallback;
import org.gwt.mosaic.ui.client.layout.ColumnLayout;
import org.gwt.mosaic.ui.client.layout.ColumnLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.RowLayout;
import org.gwt.mosaic.ui.client.layout.RowLayoutData;

public class CustomTabLayoutWidget
extends ResizeComposite {
    DecoratedTabLayoutPanel tabPanel = new DecoratedTabLayoutPanel(true);

    public CustomTabLayoutWidget(List<TabDTO> tabs) {
        this.initWidget(this.initializeTabs(tabs));
    }

    private Widget initializeTabs(List<TabDTO> tabs) {
        this.tabPanel.setPadding(5);
        for (TabDTO t : tabs) {
            System.out.println("Initializing Tab :" + t.getTitle());
            this.tabPanel.add(this.initializeScreens(t), t.getTitle(), true);
        }
        return this.tabPanel.asWidget();
    }

    private Widget initializeScreens(TabDTO tab) {
        LayoutPanel layoutPanel = new LayoutPanel((LayoutManager)new ColumnLayout());
        layoutPanel.enableDragAndDrop(false);
        layoutPanel.setPadding(3);
        layoutPanel.setWidgetSpacing(8);
        layoutPanel.setAnimationEnabled(true);
        layoutPanel.setAnimationCallback((AnimationCallback)new LayoutAnimationCallback(layoutPanel));
        int maxColNo = tab.getMaxColumnNo();
        System.out.println("Max Col No :" + tab.getMaxColumnNo());
        int createCols = maxColNo > 0 ? maxColNo : 1;
        this.createDefaultColumns(layoutPanel, createCols);
        int index = 0;
        Set<ScreenDTO> screens = tab.getScreens();
        if (screens != null) {
            screens = new TreeSet<ScreenDTO>(screens);
            for (ScreenDTO s : screens) {
                index = s.getColumnNo() > 0 ? s.getColumnNo() - 1 : 0;
                LayoutPanel col = (LayoutPanel)layoutPanel.getWidget(index);
                if (col == null) continue;
                col.add((Widget)new CustomScreenLayoutWidget(layoutPanel, s), (LayoutData)new RowLayoutData(1, true));
            }
        }
        return layoutPanel;
    }

    private void createDefaultColumns(LayoutPanel layoutPanel, int colNos) {
        LayoutPanel col = null;
        System.out.println("Create Cols :" + colNos);
        int i = 0;
        while (i < colNos) {
            col = new LayoutPanel((LayoutManager)new RowLayout());
            col.setPadding(0);
            col.setWidgetSpacing(8);
            layoutPanel.add((Widget)col, (LayoutData)new ColumnLayoutData(1));
            layoutPanel.registerDropController((DropController)col);
            ++i;
        }
    }

    public void selectTab(int index) {
        this.tabPanel.selectTab(index);
    }
}

