/********************************************************
Title 	 : BankGuaranteeClose [F15DSUN018]
Date  	 : 29/JUL/15
Developer: Pankaj R.
********************************************************/

package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;

import ibase.webitm.ejb.*;
import ibase.system.config.*;
import javax.ejb.Stateless;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class BankGuaranteeClose extends ActionHandlerEJB implements BankGuaranteeCloseLocal,BankGuaranteeCloseRemote  
{

	public String close(String tranId,String xtraParams,String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("Inside Close Method");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", sql1 = "";
		ConnDriver connDriver = null;
		String status = "",confirm="";
		int updateCount=0;
		ITMDBAccessEJB itmDBAccess = null;
		ibase.utility.E12GenericUtility genericUtility = null;
		genericUtility = new ibase.utility.E12GenericUtility();
		itmDBAccess = new ITMDBAccessEJB();
		connDriver = null;
		String errString = "";
		ValidatorEJB validatorEJB = null;
		SimpleDateFormat sdf=null;
		Timestamp timestamp=null;

		ITMDBAccessEJB itmDBAccessEJB = null;
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			validatorEJB = new ValidatorEJB();
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			connDriver = null;
			conn.setAutoCommit(false);
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());
			System.out.println("TimeStamp>>>>>>>>>>"+timestamp);
//			currDate = (sdf.format(timestamp).toString()).trim();
			
			System.out.println("Tran Id>>>>>>"+tranId);
			sql = "select status,confirmed from lc_voucher where tran_id = ? and tran_type='B'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				status = rs.getString("status");
				confirm = rs.getString("confirmed");
			}
			System.out.println("Status@@@@@@@@" + status);
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if((status==null || status.length()<=0) && (confirm==null || confirm.length()<=0))
			{
				System.out.println("Status and Confirm is null");
				errString = itmDBAccessEJB.getErrorString("", "VMTYPE", "","", conn);
				return errString;
			}
			
			if (status != null && status.equalsIgnoreCase("C"))
			{
				System.out.println("The Selected transaction is already Closed");
				errString = itmDBAccessEJB.getErrorString("", "VTMCLOSE1", "","", conn);
				return errString;
			} 
			else /* (status != null && status.equalsIgnoreCase("O") */
			{
				if(confirm != null && confirm.equalsIgnoreCase("N"))
				{
					System.out.println("Transaction not confirmed");
					errString = itmDBAccessEJB.getErrorString("", "VTMCONF4", "","", conn);
					return errString;
				}
				else
				{
					System.out.println("Inside Status's Confirm to update status");
					sql = "update lc_voucher set status = 'C', status_date = ? where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
//					pstmt.setDate(1, new java.sql.Date(new java.util.Date().getTime()));
					pstmt.setTimestamp(1,timestamp );
					pstmt.setString(2, tranId);
					updateCount = pstmt.executeUpdate();
					System.out.println("no of row update = " + updateCount);
					System.out.println("Status Date"+ new java.sql.Date(new java.util.Date().getTime()));
					System.out.println("tranId@@@@@@@@@" + tranId);
					pstmt.close();
					pstmt = null;
					if(updateCount > 0) 
					{
						System.out.println(">>The selected transaction Closed Successfully");
						errString = itmDBAccessEJB.getErrorString("","VTEXCL001 ","","",conn);
					}	
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception ::"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println(">>>>>In finally errString:"+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					if(errString.indexOf("VTEXCL001") > -1)
					{
						System.out.println("Comitted");
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}//end of close method
}//end of class
