/**
* PURPOSE : Pre Save Logic 
* AUTHOR : Priyanka Chavan.
*/

package ibase.webitm.ejb.fin;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
@javax.ejb.Stateless
public class CostallocPrs extends ValidatorEJB implements CostallocPrsLocal, CostallocPrsRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}
	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		System.out.println("CostallocPrs EJB called");
		Document dom = null;
		try
		{
			System.out.println("xmlString in CostallocPrs : preSaveRec \n"+xmlString);			
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
				errString = executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :ShipmentPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}
	public String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException, SQLException
	{

		System.out.println("executepreSave method called");
		String errString = "";
		NodeList parentNodeList = null;
		Node parentNode = null;
		String updateFlag="";
		int parentNodeListLength=0;
		String  allocPerc ="";
		double allocPercVal = 0.0;
		boolean isLocCon = false;
		boolean isError = false;
		try
		{			
			if (conn == null ||  conn.isClosed())
			{
				conn = getConnection();
				System.out.println("connection is not null :"+conn);
				isLocCon = true;
			}
			System.out.println("connection is :"+conn);
			/*	parentNodeList = dom.getElementsByTagName("Detail2");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeLength = childNodeList.getLength();*/
			
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			for(int row = 0; row < parentNodeListLength; row++)
			{
				updateFlag = getAttribValue(parentNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
				System.out.println(" update flag ["+updateFlag+"]");
				if(!"D".equalsIgnoreCase(updateFlag))
				{
					allocPerc = checkNull(genericUtility.getColumnValueFromNode("alloc_perc", dom.getElementsByTagName("Detail2").item(row)));
					System.out.println("allocPerc :"+allocPerc);
					if(allocPerc != null && allocPerc.trim().length() >0)
					{
						allocPercVal = allocPercVal + Double.valueOf(allocPerc);
					}
				}
			}
			System.out.println("allocPercVal :"+allocPercVal);
			if(allocPercVal <100)
			{
				System.out.println("allocPercVal if < 100 :"+allocPercVal);
				errString = itmDBAccessEJB.getErrorString("","VTRCONT2","","",conn);
				isError = true;
			}
			else if(allocPercVal > 100)
			{
				System.out.println("allocPercVal if > 100 :"+allocPercVal);
				errString = itmDBAccessEJB.getErrorString("","OVERALLINV","","",conn);
				isError = true;
			}
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in CostallocPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally CostCtrAllocPosEJB isError["+isError+"] connStatus["+isLocCon+"]");


				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();
					}
				}
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}		
	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "";
		try
		{
			String domStr = genericUtility.serializeDom(detailNode);
			Document dom = genericUtility.parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
}
