package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import ibase.system.config.ConnDriver;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ArrayList;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless

public class SupplierBankIC extends ValidatorEJB implements SupplierBankICLocal, SupplierBankICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlStrling :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String errorType = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "",loginSiteCode="",validUptoStr="",effFromStr="";
		Date validUptoDate=null,effFromDate=null;
		Timestamp validUptoDt=null,effFromDt=null,effFromTmstp=null;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		String bankCodeBen="",bankCodeInter="",bankCodeCorr="",bankNameBen="",bankNameInter="",bankNameCorr="" ,bankAcctBen="";
		String currCode="",currDate="",siteCode="",suppCode="";
		
		SimpleDateFormat sdf = null,sdf1=null;
		Timestamp timestamp = null;
		
		int ctr=0;
		int cnt = 0;
		int currentFormNo = 0;
		int childNodeListLength;

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());
			currDate = (sdf.format(timestamp).toString()).trim();
			System.out.println("Current Date>>>>>>>>>"+currDate);
			loginSiteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if(childNodeName.equalsIgnoreCase("supp_code"))
					{
						suppCode= checkNull(genericUtility.getColumnValue("supp_code", dom)).trim();
						System.out.println("Supplier Code>>>>"+suppCode);
						
						if(suppCode == null || (suppCode.trim().length() == 0))
						{
							System.out.println("NULL Supplier code!");
							errList.add("NULLSUPPCD");
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql="Select count(1) from supplier where supp_code = ? ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,suppCode);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if(cnt == 0) 
							{
								System.out.println("Supplier code entered does not exist, please enter valid supplier code !");
								errCode = "INVSUPPCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}
					}
					else if(childNodeName.equalsIgnoreCase("eff_from"))
					{
						effFromStr = checkNull(genericUtility.getColumnValue("eff_from", dom)).trim();
						validUptoStr = checkNull(genericUtility.getColumnValue("valid_upto", dom)).trim();
						if(effFromStr==null || effFromStr.trim().length() <= 0)
						{
							System.out.println("Effective Date is null>>>>>>>");
							errCode = "NULLEFFDA";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if(childNodeName.equalsIgnoreCase("valid_upto"))
					{
						validUptoStr=checkNull((genericUtility.getColumnValue("valid_upto", dom))).trim();
						effFromStr=checkNull((genericUtility.getColumnValue("eff_from", dom))).trim();
						if(effFromStr!=null && effFromStr.trim().length() > 0)
						{
							if(validUptoStr==null || validUptoStr.trim().length() <= 0)
							{
								System.out.println("Valid Upto Date is null>>>>>>>");
								errCode = "VTDATE26";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							else //(validUptoStr!=null && (validUptoStr() > 0))
							{
								effFromDt = Timestamp.valueOf(genericUtility.getValidDateString(effFromStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
								validUptoDt = Timestamp.valueOf(genericUtility.getValidDateString(validUptoStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
								System.out.println("Edit Flag>>>>"+editFlag);
								if(editFlag.equalsIgnoreCase("A"))
								{
									System.out.println("Edit Flag"+editFlag);
									sql = " select count(1) from supplier_bank where trim(supp_code)= ? and trim(eff_from) = ? and trim(valid_upto)= ?";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,suppCode);
									pstmt.setTimestamp(2, effFromDt);
									pstmt.setTimestamp(3, validUptoDt);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt =  rs.getInt(1);
										if(cnt > 0) 
										{
											errCode = "VTSUPPEFF";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());	
										}									
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
								}
								sql = " select eff_from from supplier_bank where trim(supp_code)= ? and confirmed= 'Y' and active_yn= 'Y'";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,suppCode);
	//							pstmt.setTimestamp(2, effFromDt);
	//							pstmt.setTimestamp(3, validUptoDt);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									effFromTmstp =  rs.getTimestamp("eff_from");
									System.out.println("effFromTmstp>>>>>>>>"+effFromTmstp);
									if(effFromDt.before(effFromTmstp)) 
									{
										System.out.println("effFromDt < effFromTmstp : "+effFromDt+" < "+effFromTmstp);
										errCode = "VTINVEFFDT";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());	
									}									
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							
								if(validUptoDt.before(effFromDt))
								{
									System.out.println("Valid Upto Datet < Effective Date  : "+validUptoDt+" < "+effFromDt);
									errCode = "VTDATE6";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}
							}
						}
						else
						{
							System.out.println("Effective Date is null>>>>>>>");
							errCode = "NULLEFFDA";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
					}
					else if(childNodeName.equalsIgnoreCase("bank_code__ben"))
					{
						bankCodeBen= genericUtility.getColumnValue("bank_code__ben", dom);
						System.out.println("Bank Code Ben>>>>"+bankCodeBen);
						
						/*if(bankCodeBen == null || (bankCodeBen.trim().length() == 0))
						{
							errList.add("VMBANKCD1");
							errFields.add(childNodeName.toLowerCase());
						}*/
						if(bankCodeBen != null && (bankCodeBen.trim().length() > 0))
						{
							sql="Select count(1) from bank where bank_code = ? ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,bankCodeBen);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								System.out.println("Count>>>>>>>>>"+cnt);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if(cnt == 0) 
							{
								System.out.println("Bank code entered does not exists in master. Please enter defined bank code.");
								errCode = "VMBANK1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							
						}
					}
					else if(childNodeName.equalsIgnoreCase("bank_code__inter"))
					{

						bankCodeInter= genericUtility.getColumnValue("bank_code__inter", dom);
						System.out.println("Bank Code Inter>>>>"+bankCodeInter);
						
						/*if(bankCodeInter == null || (bankCodeInter.trim().length() == 0))
						{
							errList.add("VMBANKCD1");
							errFields.add(childNodeName.toLowerCase());
						}*/
						if(bankCodeInter != null && (bankCodeInter.trim().length() > 0))
						{
							sql="Select count(1) from bank where bank_code = ? ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,bankCodeInter);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								System.out.println("Count>>>>>>>>>"+cnt);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if(cnt == 0) 
							{
								System.out.println("Bank code entered does not exists in master. Please enter defined bank code.");
								errCode = "VMBANK1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}						
					}
					else if(childNodeName.equalsIgnoreCase("bank_code__corr"))
					{

						bankCodeCorr= genericUtility.getColumnValue("bank_code__corr", dom);
						System.out.println("Bank Code Corr>>>>"+bankCodeCorr);
						
						/*if(bankCodeInter == null || (bankCodeInter.trim().length() == 0))
						{
							errList.add("VMBANKCD1");
							errFields.add(childNodeName.toLowerCase());
						}*/
						if(bankCodeCorr != null && (bankCodeCorr.trim().length() > 0))
						{
							sql="Select count(1) from bank where bank_code = ? ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,bankCodeCorr);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								System.out.println("Count>>>>>>>>>"+cnt);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if(cnt == 0) 
							{
								System.out.println("Bank code entered does not exists in master. Please enter defined bank code.");
								errCode = "VMBANK1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}						
					}
					else if(childNodeName.equalsIgnoreCase("bank_name__ben"))
					{
						bankNameBen= genericUtility.getColumnValue("bank_name__ben", dom);
						System.out.println("Bank Name bankNameBen>>>>"+bankNameBen);
						
						if(bankNameBen == null || (bankNameBen.trim().length() == 0))
						{
							errList.add("VTBANKNAME");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("bank_name__inter"))
					{
						bankNameInter= genericUtility.getColumnValue("bank_name__inter", dom);
						System.out.println("Bank Name bankNameInter>>>>"+bankNameInter);
						
						if(bankNameBen == null || (bankNameBen.trim().length() == 0))
						{
							errList.add("VTBANKNAME");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("bank_name__corr"))
					{
						bankNameCorr= genericUtility.getColumnValue("bank_name__corr", dom);
						System.out.println("bankNameCorr>>>>"+bankNameCorr);
						
						if(bankNameBen == null || (bankNameBen.trim().length() == 0))
						{
							errList.add("VTBANKNAME");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("bank_acct_no__ben"))
					{
						bankAcctBen= genericUtility.getColumnValue("bank_acct_no__ben", dom);
						System.out.println("Bank Name>>>>"+bankAcctBen);
						
						if(bankAcctBen == null || (bankAcctBen.trim().length() == 0))
						{
							errList.add("VTBANKACNO");
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if(childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode=genericUtility.getColumnValue("curr_code", dom);
						System.out.println("Currency Code>>>>"+currCode);
						if(currCode==null || (currCode.trim().length()==0))
						{
							errCode = "VTCURR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());	
						}
						else//(currCode != null && (currCode.trim().length() > 0))
						{
							sql = " select count(*) from currency where curr_code= ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,currCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								errCode = "VTCURRCD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}	
						}
					}
				}			
				break;
			}//end switch
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation
	
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("XML STRING@@@@@@@@@");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			if(xmlString != null)// || xmlString1!=null || xmlString2!=null)
			{
				dom = parseString(xmlString);
				System.out.println("XML STRING@@@@@@@@@@@@@!"+dom);
			}
			if(xmlString1 != null)// || xmlString1!=null || xmlString2!=null)
			{
				dom1 = parseString(xmlString1);
				System.out.println("XML STRING@@@@@@@@@@@@@!1"+dom1);
			}
			if(xmlString2 != null)// || xmlString1!=null || xmlString2!=null)
			{
				dom = parseString(xmlString2);
				System.out.println("XML STRING@@@@@@@@@@@@@!2"+dom2);
			}
			System.out.println("XML STRING@@@@@@@@@@@@@!"+xmlString);
			System.out.println("XML STRING@@@@@@@@@@@@@!1"+xmlString1);
			System.out.println("XML STRING@@@@@@@@@@@@@!2"+xmlString2);
			
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		System.out.println("valueXmlStringvalueXmlStrin ST"+valueXmlString);
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		SimpleDateFormat sdf =null;
		Timestamp timestamp = null;
		String currDate="";
		String childNodeName = null;
		String siteCode = "",loginSiteCode="",siteDescr="";
		String chgUser = "";
		String chgTerm = "";
		String sql = "";
		String columnValue="";
		String purcOrder="";
		int ctr = 0;
		int currentFormNo = 0;
		
		
		/*For Supplier Bank */
		 String bankCodeBen="",bankCodeInter="",bankCodeCorr="",bankNameBen="",bankNameInter="",bankNameCorr="",bankAcctBen="";
		 String suppCode="",suppName="",bankName="", addr1="", addr2="", addr3="", stateCode="", city="", pin="", countryCode="";
		
		
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{			 
			System.out.println("@@@@@@@@@@@ itemchange method called for ---->>>>["+currentColumn+"]");
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			timestamp = new Timestamp(System.currentTimeMillis());	
		
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			loginSiteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			siteDescr = findValue(conn, "descr" ,"site", "site_code", loginSiteCode);
			System.out.println("@@@@@@ 1 siteCode["+loginSiteCode+"]::::::siteDescr["+siteDescr+"]");
			
			chgUser =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			chgTerm =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm"));
			
			currDate = (sdf.format(timestamp).toString()).trim();
			System.out.println("Current Date>>>>"+currDate);
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			switch(currentFormNo)
			{
			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if(childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();  
						}
					}
					ctr++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("@@@@@@  itm_default itemchange called");
					System.out.println("Effective Date>>>>>"+currDate);
					valueXmlString.append("<eff_from>").append("<![CDATA[" + currDate + "]]>").append("</eff_from>");
					
//					siteCode = (genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode")); 
//					siteDescr = findValue(conn, "descr" ,"site", "site_code", siteCode);
					
//					suppCode = genericUtility.getColumnValue("supp_code", dom);
//					suppName = findValue(conn, "supp_name" ,"supplier", "supp_code", suppCode);
	
//					System.out.println("Supplier Code>>>>>>>["+suppCode+"]::::::Supplier Name["+suppName+"]");
//					
//					valueXmlString.append("<supp_code>").append("<![CDATA[" +  suppCode + "]]>").append("</supp_code>");
//					valueXmlString.append("<supp_name>").append("<![CDATA[" +  suppName + "]]>").append("</supp_name>");
				}//end of if
				
				if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					valueXmlString.append("<chg_date>").append("<![CDATA[" + currDate + "]]>").append("</chg_date>");

					suppCode = genericUtility.getColumnValue("supp_code", dom);
					
//					valueXmlString.append("<supp_code protect = \"1\">").append("<![CDATA[" + suppCode + "]]>").append("</supp_code>");
					valueXmlString.append("<supp_code>").append("<![CDATA[" + suppCode + "]]>").append("</supp_code>");
					
				}
				else if(currentColumn.trim().equalsIgnoreCase("supp_code"))
				{
					suppCode = genericUtility.getColumnValue("supp_code", dom);
					System.out.println("Supplier Code>>>>>>"+suppCode);
					
					sql ="select supp_name from supplier where supp_code = ?";
					pstmt =conn.prepareStatement(sql);
					pstmt.setString(1, suppCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						suppName=rs.getString("supp_name");
						System.out.println("Supplier Name>>>>>>"+suppName);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append("<supp_name>").append("<![CDATA[" +  suppName + "]]>").append("</supp_name>");
					
				}
				else if(currentColumn.trim().equalsIgnoreCase("bank_code__corr"))
				{
					bankCodeCorr = genericUtility.getColumnValue("bank_code__corr", dom);
					System.out.println("Bank Code Correspondant>>>>>>"+bankCodeCorr);
					
					sql ="select bank_name, addr1, addr2, addr3, state_code, city, pin, count_code " +
							"from bank where bank_code = ? ";
					pstmt =conn.prepareStatement(sql);
					pstmt.setString(1, bankCodeCorr);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						bankNameCorr=rs.getString("bank_name");
						addr1=rs.getString("addr1");
						addr2=rs.getString("addr2");
						addr3=rs.getString("addr3");
						stateCode=rs.getString("state_code");
						city=rs.getString("city");
						pin=rs.getString("pin");
						countryCode=rs.getString("count_code");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append("<bank_name__corr>").append("<![CDATA[" +  bankNameCorr + "]]>").append("</bank_name__corr>");
					valueXmlString.append("<addr1__corr>").append("<![CDATA[" +  addr1 + "]]>").append("</addr1__corr>");
					valueXmlString.append("<addr2__corr>").append("<![CDATA[" +  addr2 + "]]>").append("</addr2__corr>");
					valueXmlString.append("<addr3__corr>").append("<![CDATA[" +  addr3 + "]]>").append("</addr3__corr>");
					valueXmlString.append("<state_code__corr>").append("<![CDATA[" +  stateCode + "]]>").append("</state_code__corr>");
					valueXmlString.append("<city__corr>").append("<![CDATA[" +  city + "]]>").append("</city__corr>");
					valueXmlString.append("<pin__corr>").append("<![CDATA[" +  pin + "]]>").append("</pin__corr>");
					valueXmlString.append("<count_code__corr>").append("<![CDATA[" +  countryCode + "]]>").append("</count_code__corr>");
					
				}
				else if(currentColumn.trim().equalsIgnoreCase("bank_code__ben"))
				{
					bankCodeBen = genericUtility.getColumnValue("bank_code__ben", dom);
					System.out.println("Bank Code Beneficiary>>>>>>"+bankCodeBen);
					
					sql ="select bank_name, addr1, addr2, addr3, state_code, city, pin, count_code " +
							"from bank where bank_code = ? ";
					pstmt =conn.prepareStatement(sql);
					pstmt.setString(1, bankCodeBen);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						bankNameBen=rs.getString("bank_name");
						addr1=rs.getString("addr1");
						addr2=rs.getString("addr2");
						addr3=rs.getString("addr3");
						stateCode=rs.getString("state_code");
						city=rs.getString("city");
						pin=rs.getString("pin");
						countryCode=rs.getString("count_code");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append("<bank_name__ben>").append("<![CDATA[" +  bankNameBen + "]]>").append("</bank_name__ben>");
					valueXmlString.append("<addr1__ben>").append("<![CDATA[" +  addr1 + "]]>").append("</addr1__ben>");
					valueXmlString.append("<addr2__ben>").append("<![CDATA[" +  addr2 + "]]>").append("</addr2__ben>");
					valueXmlString.append("<addr3__ben>").append("<![CDATA[" +  addr3 + "]]>").append("</addr3__ben>");
					valueXmlString.append("<state_code__ben>").append("<![CDATA[" +  stateCode + "]]>").append("</state_code__ben>");
					valueXmlString.append("<city__ben>").append("<![CDATA[" +  city + "]]>").append("</city__ben>");
					valueXmlString.append("<pin__ben>").append("<![CDATA[" +  pin + "]]>").append("</pin__ben>");
					valueXmlString.append("<count_code__ben>").append("<![CDATA[" +  countryCode + "]]>").append("</count_code__ben>");
					
				}
				else if(currentColumn.trim().equalsIgnoreCase("bank_code__inter"))
				{
					bankCodeInter = genericUtility.getColumnValue("bank_code__inter", dom);
					System.out.println("Bank Code Intermediatry>>>>>>"+bankCodeInter);
					
					sql ="select bank_name, addr1, addr2, addr3, state_code, city, pin, count_code " +
							"from bank where bank_code = ? ";
					pstmt =conn.prepareStatement(sql);
					pstmt.setString(1, bankCodeInter);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						bankNameInter=rs.getString("bank_name");
						addr1=rs.getString("addr1");
						addr2=rs.getString("addr2");
						addr3=rs.getString("addr3");
						stateCode=rs.getString("state_code");
						city=rs.getString("city");
						pin=rs.getString("pin");
						countryCode=rs.getString("count_code");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append("<bank_name__inter>").append("<![CDATA[" +  bankNameInter + "]]>").append("</bank_name__inter>");
					valueXmlString.append("<addr1__inter>").append("<![CDATA[" +  addr1 + "]]>").append("</addr1__inter>");
					valueXmlString.append("<addr2__inter>").append("<![CDATA[" +  addr2 + "]]>").append("</addr2__inter>");
					valueXmlString.append("<addr3__inter>").append("<![CDATA[" +  addr3 + "]]>").append("</addr3__inter>");
					valueXmlString.append("<state_code__inter>").append("<![CDATA[" +  stateCode + "]]>").append("</state_code__inter>");
					valueXmlString.append("<city__inter>").append("<![CDATA[" +  city + "]]>").append("</city__inter>");
					valueXmlString.append("<pin__inter>").append("<![CDATA[" +  pin + "]]>").append("</pin__inter>");
					valueXmlString.append("<count_code__inter>").append("<![CDATA[" +  countryCode + "]]>").append("</count_code__inter>");
				}
				valueXmlString.append("</Detail1>");
				break;
			}//end of switch-case
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}//end of itemChanged
	
	
	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
			if (findValue == null )
			{
				findValue = "";
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}//end of findValue

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}//end of errorType
	private String checkNull( String input )
	{
		if (input == null )
		{
			input = "";
		}
		return input;
	}//end of checkNull
	
}
