/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.adm.EmpAdPrsLocal;
import ibase.webitm.ejb.adm.EmpAdPrsRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpAdPrs
extends ValidatorEJB
implements EmpAdPrsLocal,
EmpAdPrsRemote {
    @Override
    public String preSaveRec() throws RemoteException, ITMException {
        return "";
    }

    @Override
    public String preSaveRec(String xmlString1, String domId, String objContext, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
        System.out.println("EmpAdPrsEJB called...........");
        String retString = "";
        Document dom = null;
        try {
            if (xmlString1 != null && xmlString1.trim().length() > 0) {
                dom = GenericUtility.getInstance().parseString(xmlString1);
                retString = this.executepreSaveRec(dom, domId, objContext, editFlag, xtraParams, conn);
            }
        }
        catch (Exception e) {
            System.out.println("Exception :EmpAdPrsEJB :preSaveRec() :" + e.getMessage() + ":");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retString;
    }

    private String executepreSaveRec(Document dom, String domID, String objContext, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String empCode = "";
        String adCode = "";
        String effDate = "";
        String expDate = "";
        String periodFrom = "";
        String periodTo = "";
        String sqlStr = "";
        String amt = "";
        String keyString = "";
        String errorCode = "";
        String updateStatus = "";
        String userId = "";
        String retString = "";
        double originalAmt = 0.0;
        double amount = 0.0;
        boolean empStatus = false;
        int count = 0;
        Timestamp effectiveDate = null;
        Timestamp expiryDate = null;
        Node currDetail = null;
        try {
            try {
                conn.setAutoCommit(false);
                GenericUtility genericUtility = GenericUtility.getInstance();
                userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
                AdmCommon admCommon = new AdmCommon();
                System.out.println("dom.............:: " + dom);
                System.out.println("domID.............:: " + domID);
                currDetail = this.getCurrentDetailFromDom(dom, domID);
                updateStatus = this.getCurrentUpdateFlag(currDetail);
                System.out.println("updateStatus......:: " + updateStatus);
                if (currDetail != null) {
                    if (updateStatus.equalsIgnoreCase("A") || updateStatus.equalsIgnoreCase("E")) {
                        if (updateStatus.equals("A")) {
                            empCode = genericUtility.getColumnValueFromNode("emp_code", currDetail);
                            adCode = genericUtility.getColumnValueFromNode("ad_code", currDetail);
                            effDate = genericUtility.getColumnValueFromNode("eff_date", currDetail);
                            empStatus = admCommon.empPrevRec(empCode, adCode, effDate, conn);
                        }
                        if (empStatus) {
                            expDate = genericUtility.getColumnValueFromNode("exp_date", currDetail);
                            amt = genericUtility.getColumnValueFromNode("amount", currDetail);
                            if (amt != null) {
                                amount = Double.parseDouble(amt);
                            }
                            effectiveDate = Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
                            expiryDate = Timestamp.valueOf(genericUtility.getValidDateTimeString(expDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
                            System.out.println("effectiveDate...:: " + effectiveDate);
                            System.out.println("expiryDate...:: " + expiryDate);
                            sqlStr = "SELECT CODE FROM PERIOD WHERE FR_DATE <= ? AND TO_DATE >= ? ";
                            System.out.println("sqlStr.....::[1]:: " + sqlStr);
                            pstmt = conn.prepareStatement(sqlStr);
                            pstmt.setTimestamp(1, effectiveDate);
                            pstmt.setTimestamp(2, effectiveDate);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                periodFrom = rs.getString("CODE");
                            }
                            System.out.println("periodFrom:: " + periodFrom);
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            sqlStr = "SELECT CODE FROM PERIOD WHERE FR_DATE <= ? AND TO_DATE >= ? ";
                            System.out.println("sqlStr.....::[2]:: " + sqlStr);
                            pstmt = conn.prepareStatement(sqlStr);
                            pstmt.setTimestamp(1, expiryDate);
                            pstmt.setTimestamp(2, expiryDate);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                periodTo = rs.getString("CODE");
                            }
                            System.out.println("periodTo:: " + periodTo);
                            rs.close();
                            rs = null;
                            keyString = String.valueOf(empCode) + "|" + adCode + "|" + effectiveDate + "|" + expiryDate;
                            sqlStr = "SELECT BASIC FROM EMPLOYEE WHERE EMP_CODE = '" + empCode + "'";
                            System.out.println("sqlStr.....::[3]:: " + sqlStr);
                            stmt = conn.createStatement();
                            rs = stmt.executeQuery(sqlStr);
                            if (rs.next()) {
                                originalAmt = rs.getDouble("BASIC");
                            }
                            rs.close();
                            rs = null;
                            errorCode = admCommon.payarrToProcUpdation(periodFrom, periodTo, empCode, empCode, "AR", "W_EMP_AD", keyString, adCode, amount - originalAmt, effDate, expDate, xtraParams, conn);
                            if (errorCode.trim().length() > 0) {
                                conn.rollback();
                                retString = this.getErrorString("", errorCode, userId);
                                System.out.println("Ret String: " + retString);
                            } else if (errorCode.trim().length() == 0) {
                                conn.commit();
                            }
                        }
                    } else if (updateStatus.equalsIgnoreCase("D")) {
                        empCode = genericUtility.getColumnValueFromNode("emp_code", currDetail);
                        adCode = genericUtility.getColumnValueFromNode("ad_code", currDetail);
                        sqlStr = "SELECT COUNT(*) AS COUNT FROM PAYROLLDET WHERE EMP_CODE = '" + empCode + "' and ad_code = '" + adCode + "'";
                        System.out.println("sqlStr.........:: " + sqlStr);
                        stmt = conn.createStatement();
                        rs = stmt.executeQuery(sqlStr);
                        if (rs.next()) {
                            count = rs.getInt("COUNT");
                        }
                        if (count != 0) {
                            errorCode = "VTPAYFND";
                            retString = this.getErrorString("", errorCode, userId);
                            System.out.println("Ret String: " + retString);
                        }
                    }
                }
            }
            catch (SQLException sqe) {
                System.out.println("The SQLException occurs in [EmpAdPrsEJB] :: [executepreSaveRec] :" + sqe);
                sqe.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ITMException((Exception)sqe);
            }
            catch (Exception e) {
                System.out.println("The Exception occurs in [EmpAdPrsEJB] :: [executepreSaveRec] :" + e);
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                System.out.println("Closing stmt and pstmt In [executepreSaveRec]......");
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :[EmpAdPrsEJB] :: [executepreSaveRec] :\n" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return retString;
    }

    private Node getCurrentDetailFromDom(Document dom, String domId) {
        NodeList detailList = null;
        Node currDetail = null;
        Node reqDetail = null;
        String currDomId = "";
        int detailListLength = 0;
        detailList = dom.getElementsByTagName("Detail1");
        detailListLength = detailList.getLength();
        int ctr = 0;
        while (ctr < detailListLength) {
            currDetail = detailList.item(ctr);
            currDomId = currDetail.getAttributes().getNamedItem("domID").getNodeValue();
            if (currDomId.equals(domId)) {
                reqDetail = currDetail;
                break;
            }
            ++ctr;
        }
        return reqDetail;
    }

    private String getCurrentUpdateFlag(Node currDetail) {
        NodeList currDetailList = null;
        String updateStatus = "";
        String nodeName = "";
        int currDetailListLength = 0;
        currDetailList = currDetail.getChildNodes();
        currDetailListLength = currDetailList.getLength();
        int i = 0;
        while (i < currDetailListLength) {
            nodeName = currDetailList.item(i).getNodeName();
            if (nodeName.equalsIgnoreCase("Attribute")) {
                updateStatus = currDetailList.item(i).getAttributes().getNamedItem("updateFlag").getNodeValue();
                break;
            }
            ++i;
        }
        return updateStatus;
    }
}

