<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<!-- 
<link href="/ibase/webitm/css/DD/ProductWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
 -->
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/productWiz.css"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" />

<script type="text/javascript" src="/ibase/webitm/js/prodWiz_Edit.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/e12PluginWrapper.js"></script>

<style>

.attachedFile
{

	border: 1px solid grey;
}

.attachedNewFile
{
    height: 25px;
    width: 25px;
}

.wordWrap
{
	word-wrap: break-word;
	overflow: hidden;
}

</style>

<script>
<![CDATA[
$(function() {
		
		/*getAppDateFormat();*/  /* Comment added by parikshit kumbhar on 09/07/15 */
		pageLoad();
		$( "#accordion" ).accordion({ collapsible:false, active:false });
		$( "#accordion" ).accordion('option', 'active' , 1);
});
	
function setActionVal( value )
{
	document.getElementById(value).style.pointerEvents = 'none';
   	document.getElementById("action").value = value;
   	
   document.getElementById(value).style.display = "none";
   document.getElementById("next").style.display = "none";
   document.getElementById("buttonreplacement").style.display = "";
   document.getElementById("errorActivityTable").style.display = "none";
   	
}
]]>
</script>

<body onload="getAppDateFormat(); setCustItemRef(); ">
<form name="prodWizEditFormII" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">

<!-- 	<div id="header">
		<div id="headingText">Product Wizard</div>
  	</div> -->

	<TABLE border="0" width="99%" height="2%" class="header_td header_table" cellpadding="0" cellspacing="0" >
		<TR>
			<div class='contentHeaderLbl'>
			<img src="/ibase/images/menuImages/web/Dailyactivityreport.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px;margin-top:9px; height: 20px; width: 20px;"/>
				<TD class="header_main header_td1" nowrap="true" valign="middle" > 
				      Product Wizard Edit
				</TD>
			</div>
		</TR>
	</TABLE>
	
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:99%">
	<table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 0px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
			<xsl:for-each select="//error">
				<xsl:if test="position() = 1">
					<tr>	
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Message :
						</td> 
						<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Description :
						</td>
						<td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
							<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr style="background: rgba(255, 204, 0, 0.66);">
					 <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
						<xsl:value-of select="message"/>
					</td> 
					
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
					
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					</td>
				</tr>
			</xsl:for-each>
			
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
						<tr style="background: rgba(255, 204, 0, 0.66);">
							<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
								<input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
							</td>
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
						</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
	</table>
</div>
<!-- 	
	<div class="mainPage-Container">
	<div style="width: 100%">
	<div style="width: 52%; float: left;"> -->
	
	<div class="pageContentWrapper"  style="height:72%;overflow:auto; ">	
  		<div class="body_table">
			<table id="activityTable"  class="editDisplayColumnClass" cellSpacing="0" width="99%" cellPadding="1">
				<xsl:for-each select="//Detail2">
					<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
					<xsl:variable name="descr"><xsl:value-of select="descr"/></xsl:variable>
					<xsl:variable name="item_type"><xsl:value-of select="item_type"/></xsl:variable>
					<xsl:variable name="item_type_descr"><xsl:value-of select="item_type_descr"/></xsl:variable>
					<xsl:variable name="item_ser"><xsl:value-of select="item_ser"/></xsl:variable>
					<xsl:variable name="item_ser_descr"><xsl:value-of select="item_ser_descr"/></xsl:variable>
					<xsl:variable name="grp_code"><xsl:value-of select="grp_code"/></xsl:variable>
					<xsl:variable name="grp_code_descr"><xsl:value-of select="grp_code_descr"/></xsl:variable>
					<xsl:variable name="loc_code"><xsl:value-of select="loc_code"/></xsl:variable>
					<xsl:variable name="loc_code_descr"><xsl:value-of select="loc_code_descr"/></xsl:variable>
					<xsl:variable name="site_codes"><xsl:value-of select="site_codes"/></xsl:variable>
					<xsl:variable name="site_desc"><xsl:value-of select="site_desc"/></xsl:variable>
		         	<xsl:variable name="size_type"><xsl:value-of select="size_type"/></xsl:variable>
					<xsl:variable name="dimension_desc"><xsl:value-of select="dimension_desc"/></xsl:variable>
					<xsl:variable name="dim_code_desc"><xsl:value-of select="dim_code_desc"/></xsl:variable>
					<xsl:variable name="color_codes"><xsl:value-of select="color_codes"/></xsl:variable>
					<xsl:variable name="color_code_descr"><xsl:value-of select="color_code_descr"/></xsl:variable>
					<xsl:variable name="size_codes"><xsl:value-of select="size_codes"/></xsl:variable>
					<xsl:variable name="phy_attr4"><xsl:value-of select="phy_attr4"/></xsl:variable>
					<xsl:variable name="phy_attr5"><xsl:value-of select="phy_attr5"/></xsl:variable>
					<xsl:variable name="price"><xsl:value-of select="price"/></xsl:variable>
					<xsl:variable name="curr_code"><xsl:value-of select="curr_code"/></xsl:variable>
					<xsl:variable name="unit"><xsl:value-of select="unit"/></xsl:variable>
					<xsl:variable name="loc_type"><xsl:value-of select="loc_type"/></xsl:variable>
					<xsl:variable name="track_shelf_life"><xsl:value-of select="track_shelf_life"/></xsl:variable>
					<xsl:variable name="unit_rate"><xsl:value-of select="unit_rate"/></xsl:variable>
					
					<xsl:variable name="item_category"><xsl:value-of select="item_category"/></xsl:variable>
					<xsl:variable name="category_descr"><xsl:value-of select="category_descr"/></xsl:variable>
					<xsl:variable name="price_list_dtl"><xsl:value-of select="price_list_dtl"/></xsl:variable>
					<xsl:variable name="item_length"><xsl:value-of select="item_length"/></xsl:variable>
					<xsl:variable name="item_width"><xsl:value-of select="item_width"/></xsl:variable>
					<xsl:variable name="item_height"><xsl:value-of select="item_height"/></xsl:variable>
					<xsl:variable name="item_gross_wt"><xsl:value-of select="item_gross_wt"/></xsl:variable>
					<xsl:variable name="shipper_size"><xsl:value-of select="shipper_size"/></xsl:variable>
					<xsl:variable name="case_length"><xsl:value-of select="case_length"/></xsl:variable>
					<xsl:variable name="case_width"><xsl:value-of select="case_width"/></xsl:variable>
					<xsl:variable name="size_height"><xsl:value-of select="size_height"/></xsl:variable>
					<xsl:variable name="case_gross_weight"><xsl:value-of select="case_gross_weight"/></xsl:variable>
					<xsl:variable name="case_net_weight"><xsl:value-of select="case_net_weight"/></xsl:variable>
					<xsl:variable name="size_type_desc"><xsl:value-of select="size_type_desc"/></xsl:variable>
					<xsl:variable name="language"><xsl:value-of select="language"/></xsl:variable>
					<xsl:variable name="language_desc"><xsl:value-of select="language_desc"/></xsl:variable>
					<xsl:variable name="pack_size_dtl"><xsl:value-of select="pack_size_dtl"/></xsl:variable>
					<xsl:variable name="language_dtl"><xsl:value-of select="language_dtl"/></xsl:variable>
					<xsl:variable name="tax"><xsl:value-of select="tax"/></xsl:variable>
					<xsl:variable name="tax_descr"><xsl:value-of select="tax_descr"/></xsl:variable>
					<xsl:variable name="supp_code"><xsl:value-of select="supp_code"/></xsl:variable>
					<xsl:variable name="supplier_desc"><xsl:value-of select="supplier_desc"/></xsl:variable>
					<xsl:variable name="supp_item_desc"><xsl:value-of select="supp_item_desc"/></xsl:variable>
					
					<xsl:variable name="sh_descr"><xsl:value-of select="sh_descr"/></xsl:variable>
					<xsl:variable name="long_descr"><xsl:value-of select="long_descr"/></xsl:variable>
					<xsl:variable name="meta_desc"><xsl:value-of select="meta_desc"/></xsl:variable>
					<xsl:variable name="meta_keywords"><xsl:value-of select="meta_keywords"/></xsl:variable>
					<xsl:variable name="meta_title"><xsl:value-of select="meta_title"/></xsl:variable>
					<xsl:variable name="img_path"><xsl:value-of select="img_path"/></xsl:variable>
					
					<xsl:variable name="login_code"><xsl:value-of select="login_code"/></xsl:variable>
					<xsl:variable name="chg_date"><xsl:value-of select="chg_date"/></xsl:variable>
					<xsl:variable name="chg_user"><xsl:value-of select="chg_user"/></xsl:variable>
					<xsl:variable name="chg_term"><xsl:value-of select="chg_term"/></xsl:variable>
					<xsl:variable name="pur_lead_time"><xsl:value-of select="pur_lead_time"/></xsl:variable>
					<xsl:variable name="date_format"><xsl:value-of select="date_format"/></xsl:variable><!-- Added by parikshit kumbhar on 08/07/15 [to set date format]  -->
					
					<!--added by samadhan on 23/12/2015 for brand,limited edition and stop purchase start-->
					<xsl:variable name="usage_type"><xsl:value-of select="usage_type"/></xsl:variable><!--limited edition-->
					<xsl:variable name="stop_purchase"><xsl:value-of select="stop_purchase"/></xsl:variable><!--Stop purchase-->
					<xsl:variable name="phy_attrib_24"><xsl:value-of select="phy_attrib_24"/></xsl:variable><!--brand code-->
					<xsl:variable name="brand_descr"><xsl:value-of select="brand_descr"/></xsl:variable><!--brand descr-->
					<!--added by samadhan on 23/12/2015 for brand,limited edition and stop purchase end-->
					
					<!--Changed by Sneha on 07-07-2016, for item parent description [Start] -->
					<xsl:variable name="attr_value"><xsl:value-of select="attr_value"/></xsl:variable>
					<!--Changed by Sneha on 07-07-2016, for item parent description [End] -->
					
					<!--Changed by wasim on 02-08-2016 for tax chapter [START]-->
					<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>
					<!--Changed by wasim on 02-08-2016 for tax chapter [END]-->
					
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
					<xsl:variable name="trade_mark"><xsl:value-of select="trade_mark"/></xsl:variable>
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
					
					<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [Start] -->
					<xsl:variable name="phy_attrib_4"><xsl:value-of select="phy_attrib_4"/></xsl:variable>
					<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [End] -->
					
					<!-- Changed by Sneha on 03-11-2016, for size and color code [Start] -->
					<xsl:variable name="phy_attrib_1"><xsl:value-of select="phy_attrib_1"/></xsl:variable>
					<xsl:variable name="phy_attrib_2"><xsl:value-of select="phy_attrib_2"/></xsl:variable>
					<xsl:variable name="phy_attrib_6"><xsl:value-of select="phy_attrib_6"/></xsl:variable>
					<!-- Changed by Sneha on 03-11-2016, for size and color code [End] -->
					
					<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
		
					<input type="hidden" name="Detail2.{normalize-space($dbID)}.login_code" id="Detail2.{normalize-space($dbID)}.login_code" 
						value="{$login_code}" ISCHANGED="false"/>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Parent Code*: </strong>
						</td>
						<td class="td_leftAlign">
							<input type="text" class="input_editable" value="{$item_code}" name="Detail2.{normalize-space($dbID)}.item_code" 
								id="Detail2.{normalize-space($dbID)}.item_code" maxlength="10" style="width: 100%" readonly="1" focus="true"
								onkeypress="return disableEnter()"  />
						</td>
						
						<td colspan="2">
							<input type="text" name="Detail2.{normalize-space($dbID)}.descr" id="Detail2.{normalize-space($dbID)}.descr" 
								value="{descr}" class="input_editable" style="width: 100%;" maxlength="80" 
								onkeyup = "return specialCharValidate(this.id);" onkeypress="return disableEnter()" /> <!-- Changed by Sneha on 23-06-2016, for special character validation -->
						</td>
					</tr>

					<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [Start] -->
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Customer Item Refernces: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.phy_attrib_4" id="Detail2.{normalize-space($dbID)}.phy_attrib_4" 
								value="{phy_attrib_4}" class="input_editable" maxlength="30" style="width: 100%"
								onkeyup = "return specialCharValidate(this.id);" onkeypress="return disableEnter()" /> 
							
							<input type="hidden" name="cust_item_ref_status" id="cust_item_ref_status" ISCHANGED="false" readOnly = "1" onkeypress="return disableEnter()"/>
						</td>
					</tr>
					<!-- Changed by Sneha on 24-10-2016, to add new field customer item references [End] -->
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Short Description: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.sh_descr" id="Detail2.{normalize-space($dbID)}.sh_descr" 
								value="{sh_descr}" class="input_editable" maxlength="30" style="width: 100%"
								onkeyup = "return specialCharValidate(this.id);" onkeypress="return disableEnter()" /> <!-- Changed by Sneha on 23-06-2016, for special character validation -->
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="top">
							<strong>Long Description: </strong>
						</td>
						<td class="td_leftAlign" colspan="3">
							<textarea rows="3" name="Detail2.{normalize-space($dbID)}.long_descr" id="Detail2.{normalize-space($dbID)}.long_descr" 
								class="input_editable" maxlength="490" style="width: 100%; resize: none;" onkeyup = "return specialCharValidate(this.id);"
								onkeypress="return disableEnter()"  >
								<xsl:value-of select="long_descr"/>
								<!-- Changed by Sneha on 23-06-2016, for special character validation -->
							</textarea>
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Meta Keyword: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.meta_keywords" id="Detail2.{normalize-space($dbID)}.meta_keywords" 
								value="{meta_keywords}" class="input_editable" maxlength="100" style="width: 100%" onkeypress="return disableEnter()" 
								onkeyup = "return specialCharValidate(this.id);" />
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Meta Title: </strong>
						</td>
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.meta_title" id="Detail2.{normalize-space($dbID)}.meta_title" 
								value="{meta_title}" class="input_editable" maxlength="75" style="width: 100%" onkeypress="return disableEnter()" 
								onkeyup = "return specialCharValidate(this.id);" />
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Meta Description: </strong>
						</td>
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.meta_desc" id="Detail2.{normalize-space($dbID)}.meta_desc" 
								value="{meta_desc}" class="input_editable" maxlength="255" style="width: 100%" 
								onkeyup = "return specialCharValidate(this.id);" onkeypress="return disableEnter()" /> <!-- Changed by Sneha on 23-06-2016, for special character validation -->
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Image Path: </strong>
						</td>
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.img_path" id="Detail2.{normalize-space($dbID)}.img_path" 
								value="{img_path}" class="input_editable" style="width: 100%" onkeypress="return disableEnter()" 
								onkeyup = "return specialCharValidate(this.id);" /> <!--Changed by parikshit on 23/7/15 removed maxlenght-->
						</td>
					</tr>
					
					<!--Changed by Sneha on 07-07-2016, for item parent description [Start] -->
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Item Description*: </strong>
						</td>
						<td class="td_leftAlign" colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.attr_value" id="Detail2.{normalize-space($dbID)}.attr_value" 
								value="{attr_value}" class="input_editable" style="width: 100%" onkeypress="return disableEnter()" 
								onkeyup = "return specialCharValidate(this.id);" />
						</td>
					</tr>
					<!--Changed by Sneha on 07-07-2016, for item parent description [End] -->
					
					<!-- Changed by Sneha on 03-11-2016, to display size and color code [Start] -->
					 <tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Size Code: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="3">
							<div>
								<input type="text" value="{phy_attrib_6}" class="editDisplayClass" name="Detail2.{normalize-space($dbID)}.phy_attrib_6" 
									id="Detail2.{normalize-space($dbID)}.phy_attrib_6" style="width: 95%;" ISCHANGED="false" readOnly = "1"
									onkeyup = "return specialCharValidate(this.id);"
									onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','0','size_code_edit', 'Size Codes', '0');" />
							</div>
							
							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','size_code_edit', 'Size Codes', 0);"
								id="Detail2.{normalize-space($dbID)}.size_code_pophelp" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass1" title="Select Size Code" />
							</a>

							<input type="hidden" name="Detail2.{normalize-space($dbID)}.phy_attrib_1" id="Detail2.{normalize-space($dbID)}.phy_attrib_1" 
								value="{phy_attrib_1}" ISCHANGED="false" readOnly = "1" onkeyup = "return specialCharValidate(this.id);" /> 
						</td>
					</tr> 
		
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Color Code: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="3">
							<div>
								<input type="text" value="{color_code_descr}" class="editDisplayClass" name="Detail2.{normalize-space($dbID)}.color_code_descr" 
									id="Detail2.{normalize-space($dbID)}.color_code_descr" style="width:95%;" ISCHANGED="false" readOnly = "1"
									onkeyup = "return specialCharValidate(this.id);"
									onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','0','color_code_edit', 'Color Code', '0');" /> 
							</div>

							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','color_code_edit', 'Color Code', 0);"
								 id="Detail2.{normalize-space($dbID)}.color_code_pophelp" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass1" title="Select Color Code" />
							</a>

							<input type="hidden" name="Detail2.{normalize-space($dbID)}.phy_attrib_2" id="Detail2.{normalize-space($dbID)}.phy_attrib_2" 
								value="{phy_attrib_2}" ISCHANGED="false" readOnly = "1" onkeyup = "return specialCharValidate(this.id);"/> 						
						</td>
					</tr>  
					<!-- Changed by Sneha on 03-11-2016, to display size and color code [End] -->
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Product Type*: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="1">
							<input type="text" class="input_editable" value="{$item_type}" name="Detail2.{normalize-space($dbID)}.item_type" 
								id="Detail2.{normalize-space($dbID)}.item_type" maxlength="10" ISCHANGED="false" readOnly = "1" style="width: 85%;" 
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','{normalize-space($login_code)}','item_type', 'Product Type', 0);"
								onkeypress="return disableEnter()" />
							
							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','item_type', 'Product Type', 0);" 
								id="Detail2.{normalize-space($dbID)}.item_type_pophelp" 
								onkeypress="return disableEnter()" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass" title="Select Product Type"/>
							</a>
						</td>
						
						<td colspan="3">
							<input type="text" class="editDisplayClass" value="{item_type_descr}" name="Detail2.{normalize-space($dbID)}.item_type_descr" 
								id="Detail2.{normalize-space($dbID)}.item_type_descr" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%" 
								onkeypress="return disableEnter()" />
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Item Series*: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="1">
							<input type="text" class="input_editable" value="{$item_ser}" name="Detail2.{normalize-space($dbID)}.item_ser" 
								id="Detail2.{normalize-space($dbID)}.item_ser" maxlength="10" ISCHANGED="false" readOnly = "1" style="width: 85%;"
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','{normalize-space($login_code)}','item_ser', 'Item Series', 0);"
								onkeypress="return disableEnter()" />

							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','item_ser', 'Item Series', 0);" 
								onkeypress="return disableEnter()">
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass" title="Select Item Series" />
							</a>
						</td>
						
						<td colspan="3">
							<input type="text" name="Detail2.{normalize-space($dbID)}.item_ser_descr" id="Detail2.{normalize-space($dbID)}.item_ser_descr" 
								value="{item_ser_descr}" class="editDisplayClass" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%"
								onkeypress="return disableEnter()" />
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Group Code: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="1">
							<input type="text" class="input_editable" value="{$grp_code}" name="Detail2.{normalize-space($dbID)}.grp_code" 
								id="Detail2.{normalize-space($dbID)}.grp_code" maxlength="10" ISCHANGED="false" readOnly = "1" style="width: 85%;" 
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','{normalize-space($login_code)}','grp_code', 'Group Code', 0);"
								onkeypress="return disableEnter()"/>

							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','grp_code', 'Group Code', 0);" 
								 onkeypress="return disableEnter()">
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass"  title="Select Group Code" />
							</a>
						</td>
						
						<td colspan="3">
							<input type="text" class="editDisplayClass" value="{grp_code_descr}" name="Detail2.{normalize-space($dbID)}.grp_code_descr" 
								id="Detail2.{normalize-space($dbID)}.grp_code_descr" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%" 
								onkeypress="return disableEnter()" />
						</td>
					</tr>
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Location Code*: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="1">
							<input type="text" class="input_editable" value="{$loc_code}" name="Detail2.{normalize-space($dbID)}.loc_code" 
								id="Detail2.{normalize-space($dbID)}.loc_code" maxlength="10" ISCHANGED="false" readOnly = "1" style="width: 85%;" 
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','{normalize-space($login_code)}','loc_code', 'Location Code', 0);"
								onkeypress="return disableEnter()"/>

							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','loc_code', 'Location Code', 0);" 
								id="Detail2.{normalize-space($dbID)}.loc_code_pophelp" onkeypress="return disableEnter()" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass" title="Select Location Code" />
							</a>

						</td>
						
						<td colspan="3">
							<input type="text" class="editDisplayClass" value="{loc_code_descr}"  name="Detail2.{normalize-space($dbID)}.loc_code_descr" 
								id="Detail2.{normalize-space($dbID)}.loc_code_descr" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%" 
								onkeypress="return disableEnter()"/>
							
							<input type="hidden" value="{$loc_type}" name="Detail2.{normalize-space($dbID)}.loc_type" 
									id="Detail2.{normalize-space($dbID)}.loc_type" maxlength="10"/>	
						</td>
					</tr>
		
					<!--added by samadhan on 23/12/2015 for brand,limited edition and stop purchase start-->
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Brand*: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="1">
							<input type="text" class="input_editable" value="{$phy_attrib_24}" name="Detail2.{normalize-space($dbID)}.phy_attrib_24" 
								id="Detail2.{normalize-space($dbID)}.phy_attrib_24" maxlength="10" ISCHANGED="false" readOnly = "1" style="width: 85%;"
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','{normalize-space($login_code)}','phy_attrib_24', 'Brand', 0);"
								onkeypress="return disableEnter()"/>
								
							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','phy_attrib_24', 'Brand', 0);" 
								id="Detail2.{normalize-space($dbID)}.phy_attrib_24_pophelp" onkeypress="return disableEnter()" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass" title="Select Location Code" />
							</a>
						</td>
						
						<td colspan="1">
							<input type="text" name="Detail2.{normalize-space($dbID)}.brand_descr" id="Detail2.{normalize-space($dbID)}.brand_descr" 
								value="{brand_descr}" class="editDisplayClass" maxlength="0" ISCHANGED="false" readOnly = "1" style="width: 100%"
								onkeypress="return disableEnter()" />
								
							<input type="hidden" value="{$phy_attrib_24}" name="Detail2.{normalize-space($dbID)}.phy_attrib_24" 
									id="Detail2.{normalize-space($dbID)}.phy_attrib_24" maxlength="10"/>	
						</td>
					</tr>

					<!-- Changed by wasim on 03-08-2016 for tax chapter [START] -->
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Purchase Tax :</strong>
						</td>
						
						<td class="td_leftAlign">
							<input type="text" class="input_editable" value="{$tax_chap}" name="Detail2.{normalize-space($dbID)}.tax_chap" 
								id="Detail2.{normalize-space($dbID)}.tax_chap" maxlength="10" ISCHANGED="false" readOnly = "1" style="width: 85%;" 
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','0','tax_chap', 'Purchase Tax', '0');"
								onkeypress="return disableEnter()"/>
							
							<a href="javascript:callListJSP('{normalize-space($dbID)}','0','tax_chap', 'Purchase Tax', '0');" 
								 id="Detail2.{normalize-space($dbID)}.tax_chap_pophelp" onkeypress="return disableEnter()" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass" title="Select Purchase Tax" />
							</a>
						</td>
					</tr>
					<!-- Changed by wasim on 03-08-2016 for tax chapter [END] -->
					
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [Start] -->
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Trade Mark: </strong>
						</td>
						
						<td class="td_leftAlign">
							<input type="text" name="Detail2.{normalize-space($dbID)}.trade_mark" id="Detail2.{normalize-space($dbID)}.trade_mark" 
								value="{trade_mark}" class="input_editable" maxlength="25"  style="width:85%;" ISCHANGED="false" readOnly = "1"
								onkeyup = "return specialCharValidate(this.id);"
								onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','0','trade_mark_parent', 'Trade Mark', '0');" /> 
								
							<a href="javascript:callListJSP('{normalize-space($dbID)}','{normalize-space($login_code)}','trade_mark_parent', 'Trade Mark', 0);"
								 id="Detail2.{normalize-space($dbID)}.trade_mark_pophelp" >
								<img src="/ibase/webitm/images/pophelp.png" class = "imgClass" title="Select Trade Mark" />
							</a>
						</td>
					</tr>
					<!-- Changed by Sneha on 26-09-2016, to add new field trade mark [End] -->
					
					<!--added by samadhan on 23/12/2015 for brand,limited edition and stop purchase start-->
					
					<tr>
						<td class="td_rightAlign" nowrap="true">
							<strong>Purchase Lead Time: </strong>
						</td>
						
						<td class="td_leftAlign" colspan="1">
							<input type="text" class="input_editable" value="{$pur_lead_time}" name="Detail2.{normalize-space($dbID)}.pur_lead_time" 
								id="Detail2.{normalize-space($dbID)}.pur_lead_time" maxlength="4" style='text-align: right; width: 85%' onchange='return isNumeric1(this)'  
								onkeypress="return disableEnter()" />
							
							<input type="hidden" class="input_editable" value="{$language}" name="Detail2.{normalize-space($dbID)}.language" 
								id="Detail2.{normalize-space($dbID)}.language" maxlength="10" ISCHANGED="false" readOnly = "1"/>
							
							<input type="hidden" name="Detail2.{normalize-space($dbID)}.language_desc" value="{$language_desc}" 
								id="Detail2.{normalize-space($dbID)}.language_desc" />
							
							<input type="hidden" class="input_editable" value="{$language_dtl}" name="Detail2.{normalize-space($dbID)}.language_dtl" 
								id="Detail2.{normalize-space($dbID)}.language_dtl" />
								
							<input type="hidden" class="input_editable" value="{$tax}" name="Detail2.{normalize-space($dbID)}.tax" 
								id="Detail2.{normalize-space($dbID)}.tax" maxlength="10" ISCHANGED="false" readOnly = "1"/>
						</td>				
					</tr>
					<!-- Changed by Sneha on 04-11-2016, to add new to upload images [Start] -->
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="top">
							<strong>Upload Images: </strong>
						</td>
						
						 <td class="td_leftAlign" id="attachmentsTarget"  >
							<!-- <input type="button" style="cursor:hand" value="Attach Images" class="button" title='Attach Images' id="Detail2.{normalize-space($dbID)}.upload_img" onclick ="javascript:uploadImg('item');"/> -->
						</td>
						<!-- <td class="td_leftAlign">
							<a href="javascript:uploadImg('dd_productWiz');" 
								 id="Detail1.{normalize-space($dbID)}.upload_img_pophelp" >
								<img src="/ibase/webitm/images/pophelp.png"  title="Select Upload Image" />
							</a>
						</td> -->
					</tr>
					<!-- Changed by Sneha on 04-11-2016, to add new to upload images [End] -->

					<tr>
						<td colspan="2"><br/>
							<input type="submit" style="cursor:hand;" class="button" value="Cancel" title='Cancel' id="previous"
								onclick="javascript:setActionVal('previous');" />
								
							<input type="submit" id="next" name="next" style="cursor:hand;" class="button" value="Next" title='Next' 
								onclick="javascript:return checkNullvalidation({normalize-space($dbID)}, 'next');" />
						</td>
					</tr> 
					
			        <input type="hidden" value="{$chg_date}" name="Detail2.{normalize-space($dbID)}.chg_date" id="chg_date" ISCHANGED="false" />
					<input type="hidden" value="{$chg_user}" name="Detail2.{normalize-space($dbID)}.chg_user" id="chg_user" ISCHANGED="false" />
					<input type="hidden" value="{$chg_term}" name="Detail2.{normalize-space($dbID)}.chg_term" id="chg_term" ISCHANGED="false" />
				    <input type="hidden" value="{$date_format}" name="Detail2.{normalize-space($dbID)}.date_format" id="date_format" ISCHANGED="false" /><!-- Added by parikshit kumbhar on 08/07/15 [to set date format]  -->
				</xsl:for-each>
		</table>
	</div>
	
	<!-- <div style="float: left; width:45%; border: 0px solid; padding: 0px;">
		<div id="accordion" style="position: fixed; float: left; margin-left: 5px; width:45%;"> 
		<h3 style="font-family: Arial Unicode MS, Arial, sans-serif;">Language</h3>
		 <div style="padding: 0.8em 0.8em;">
				<div id="langDtl" style="height: 180px; overflow: auto; margin-left: 0px; width:100%;"> 
				<table id="langList" class='tableClass' border="0" style="text-align: center; visibility: hidden;"> -->

	<div id="accordion" class="accordionClass" >
		<h3 class= "accordionHeader">Language</h3>
		<div id="langDtl" style="padding: 0.1em 0.1em !important; border: 1px solid #fbd850;">
			<table id="langList" class="headertableClass" style="border-top-style: none;">

				<thead>
					<tr class='thClass'>
						<th class = "tHeader" width="80%">Language&#160;Code</th>
						<th class = "tHeader" width="5%">Item&#160;Description*</th>
						<th class = "tHeader" width="5%">Short&#160;Description</th>
						<th class = "tHeader" width="5%">Long&#160;Description</th>
					</tr>
				</thead>
					<tbody class='table-body fadeInDown'></tbody>
			</table>
		</div>
	</div>
</div>
	
	<div id="buttonreplacement" align="center" style="display:none;">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" >
			 Please wait......
		</img>	
	</div> 
	
	<div style="border: 1px solid transparent; width: 100%;">
		<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
		<input type="hidden" value="dd_productWizEdit" name="OBJ_NAME" id="OBJ_NAME"/>
		<input type="hidden" value="1:MP" name="formType" id="formType" />
		<input type="hidden" value="" name="action" id="action" />
	</div>

	
</form>


<script>
<![CDATA[
	try
	{

		var targetDiv = document.querySelector('td#attachmentsTarget');
		
		
		if (! window.getAttachmentsPluginUI) throw "getAttachmentsPluginUI method not found";
		
		var pWindow = window;
		if (! window.e12plugin)
		{
			pWindow = window.parent;
			if (! pWindow.e12plugin) throw "e12plugin defination not found."
		}
		
		var ContentType = pWindow.e12plugin.enums.ContentType;
		var MetadataKey = pWindow.e12plugin.enums.MetadataKey;
		var MetadataValue = pWindow.e12plugin.metadata.MetadataValue;
		var PluginMetadata = pWindow.e12plugin.metadata.PluginMetadata;
		
		var types = [ ContentType.IMAGE ];
		
		var refId = document.getElementById("Detail2.1.item_code").value;
		var attachmentPluginElem = window.getAttachmentsPluginUI({
			OBJ_NAME : "item",
			REF_SER : "M-ITEM",
			REF_ID : refId,	
			HOST_URL : "",
			DOC_TYPE : "Attachments",
			UI : "E",
			THUMBNAIL_WIDTH : "50px",
			THUMBNAIL_HEIGHT : "50px",
			MAX_WIDTH : "300px",
			LAYOUT : "T",
			MIN_REQUIRED : 0,
			MAX_ALLOWED : 5,
			CONTENT_TYPE : types,
			IS_HOSTED_MODE: true
		});
		
		if (targetDiv)
		{	
			targetDiv.innerHTML = "";
			targetDiv.appendChild(attachmentPluginElem);
			targetDiv.style.width = "90%";
			targetDiv.style.overflowX = "auto";
		}
	}
	catch (ex)
	{
		window.alert(ex);
	}
]]>
</script>

</body>

</html>
</xsl:template>
</xsl:stylesheet>