<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">
<html>
	<head>
	<!-- added by Dadaso pawar on 5 MAR 2013 -->
	<SCRIPT language="Javascript" type="text/javascript" src="/ibase/webitm/js/sundryInfo.js"></SCRIPT>
		<link type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css"/>
	</head>
	<body>
		<div>
			<table width="100%" class="tTableHeader">
			<tr>
				<td colspan="4" align="center" class="tTitle">Payments</td>
			</tr>
        	<xsl:for-each select="//Detail1">
        	<!-- added by Dadaso pawar on 5 MAR 2013 -->
        	 <xsl:variable name="sundryCode"><xsl:value-of select="sundry_code"/></xsl:variable>
			<xsl:variable name="sundryType"><xsl:value-of select="sundry_type"/></xsl:variable>
	        <tr>
				<td>
					<span class="tLabel">Transaction ID : </span>
					<span class="tLabelData"><xsl:value-of select="tran_id"/></span>
				</td>
				<td>
					<span class="tLabel">Transaction Date : </span>
					<span class="tLabelData"><xsl:value-of select="tran_date"/></span >
				</td>
				<td>
					<span class="tLabel">Payment Type : </span>				
					<span class="tLabelData"><xsl:value-of select="tran_type"/></span>
				</td>
				<td>
					<span class="tLabel">Payment Mode : </span>
					<span class="tLabelData">
						<xsl:variable name="payMode"><xsl:value-of select="pay_mode"/></xsl:variable>
						<xsl:choose>
						<xsl:when test="$payMode = 'C'">
							Cash
						</xsl:when>
						<xsl:when test="$payMode = 'Q'">
							Cheque
						</xsl:when>
						<xsl:when test="$payMode = 'D'">
							Demand Draft
						</xsl:when>
						<xsl:when test="$payMode = 'T'">
							Electronic Transfer
						</xsl:when>
						<xsl:when test="$payMode = 'I'">
							EDI
						</xsl:when>
						<xsl:when test="$payMode = 'P'">
							Pay Order
						</xsl:when>
						<xsl:when test="$payMode = 'R'">
							Credit Card
						</xsl:when>
						<xsl:when test="$payMode = 'Y'">
							Payment Advice
						</xsl:when>
						<xsl:when test="$payMode = 'G'">
							RTGS
						</xsl:when>
						<xsl:when test="$payMode = 'N'">
							NEFT
						</xsl:when>
						</xsl:choose>
					</span>						
				</td>
			</tr>
			<tr>		
				<td colspan="4">
					<span class="tLabel">Site Code : </span>
					<span class="tLabelData"><xsl:value-of select="site_code"/> [<xsl:value-of select="site_descr"/>]</span>
				</td>
			</tr>
			<tr>				
				<td colspan="4">
					<span class="tLabel">Payable To : </span>
					<span class="tLabelData">
					<xsl:if test="sundry_type='S'">Supplier</xsl:if>
					<xsl:if test="sundry_type='C'">Customer</xsl:if>
					<xsl:if test="sundry_type='P'">Sales Person</xsl:if>
					<xsl:if test="sundry_type='B'">Bank</xsl:if>
					<xsl:if test="sundry_type='E'">Employee</xsl:if>
					<xsl:if test="sundry_type='O'">Others</xsl:if>
					<xsl:if test="sundry_type='R'">Strategic Customer</xsl:if>
					<!-- added by Dadaso pawar on 5 MAR 2013 -->
					<xsl:if test="sundry_type='L'">Loan Party</xsl:if>
					<xsl:if test="sundry_type='T'">Transporter</xsl:if>
					<xsl:if test="sundry_type='X'">Tax Authority</xsl:if> 
					
					<xsl:text>&#160;</xsl:text><xsl:value-of select="sundry_code" /> [<xsl:value-of select="sundry_name" />]
					<!-- added by Dadaso pawar on 5 MAR 2013 -->
					<IMG name="sundryinfo" src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" style="width=15;height=15;visibility;" onClick="showReference();" />
					<input id="stype" type="hidden" value="{$sundryType}" size ="5"/>
					<input id="scode" type="hidden" value="{$sundryCode}" size ="5"/>
					</span>					
				</td>				
			</tr>
			<tr>
				<td colspan="3">
					<span class="tLabel">Cheque/DD No : </span>
					<span class="tLabelData"><xsl:value-of select="ref_no"/></span>
				</td>
				<td>	
					<span class="tLabel">Cheque/DD Date : </span>
					<span class="tLabelData"><xsl:value-of select="ref_date"/></span>					
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<span class="tLabel">Cheque Name : </span>				
					<span class="tLabelData"><xsl:value-of select="chq_name"/></span>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<span class="tLabel">Remarks : </span>				
					<span class="tLabelData"><xsl:value-of select="remarks"/></span>
				</td>
			</tr>
			</xsl:for-each>
			</table>
		</div>
		
		<xsl:if test="//Detail2/line_no!=''">
			<div>
			<table width="100%" class="tTableDetail">
				<tr>
					<td colspan="12" align="center" class="tTitleD">Details</td>
				</tr>
				<tr>
					<td class="tLabelD">Line No.</td>
					<td class="tLabelD">Tran Series</td>
					<td class="tLabelD">Voucher No.</td>
					<td class="tLabelD">Voucher Date</td>
					<td class="tLabelD">Exchange Rate</td>
					<td class="tLabelD">Currency</td>
					<td class="tLabelD">Net Amount</td>
					<td class="tLabelD">Amount Paid</td>
					<td class="tLabelD">Bill No.</td>
					<td class="tLabelD">Bill Date</td>
					<td class="tLabelD">Account</td>
					<td class="tLabelD">Cost Center</td>
				</tr>
				<xsl:for-each select="//Detail2">
					<tr>
						<td class="tLabelDataD"><xsl:value-of  select="line_no"/></td>
						<td class="tLabelDataD"><xsl:value-of select="tran_ser"/></td>
						<td class="tLabelDataD"><xsl:value-of select="vouch_no"/></td>
						<td class="tLabelDataD"><xsl:value-of select="vouch_date"/></td>
						<td class="tLabelDataD"><xsl:value-of select="curr_code"/></td>
						<td class="tLabelDataD"><xsl:value-of select="exch_rate__vouch"/></td>
						<td class="tLabelDataD"><xsl:value-of select="net_amt"/></td>
						<td class="tLabelDataD"><xsl:value-of select="pay_amt"/></td>
						<td class="tLabelDataD"><xsl:value-of select="bill_no"/></td>
						<td class="tLabelDataD"><xsl:value-of select="bill_date"/></td>
						<td class="tLabelDataD"><xsl:value-of select="acct_code__ap"/> [<xsl:value-of select="accounts_descr"/>]</td>
						<td class="tLabelDataD"><xsl:value-of select="cctr_code__ap"/></td>
					</tr>
				</xsl:for-each>
			</table>
			</div>
	</xsl:if>
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
