/********************************************************
	Title : SupplierBankWfConf (F15ESUN010)
	Date  : 12/10/15
	Author: Sagar Mane

********************************************************/
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.StringTokenizer;

import javax.naming.InitialContext;

public class SupplierBankWfConf 
{
	public String confirm(String tranId, String empCodeAprv, String xmlDataAll, String keyFlag)
			throws RemoteException, ITMException 
	{
		System.out.println(">>>>> SupplierBankWfConf confirm called <<<<<");
		System.out.println(">>> SupplierBankWfConf Parameters tranId:"+tranId);
		System.out.println(">>> SupplierBankWfConf Parameters empCodeAprv:"+ empCodeAprv);
		System.out.println(">>>>> SupplierBankWfConf confirm xmlDataAll:"+ xmlDataAll);
		System.out.println(">>>>> SupplierBankWfConf confirm keyFlag:"+ keyFlag);
		
		String loginCode = "";
		String loginSiteCode = "";
		String xtraParams="";
		String suppCode="",effFromStr="",validUptoStr="";
		String retString = "";
        int updCnt=0; 
        boolean isError=false;
        Timestamp effFromDate=null, validUptoDate=null;
        Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		ConnDriver connDriver = new ConnDriver();
		InitialContext ctx = null;
		AppConnectParm acp = null;
		SupplierBankConfLocal suppBankConfLocal=null;
	    	
		try 
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);
			E12GenericUtility genericUtility = new E12GenericUtility();
			String[] pkValuesArr = string2StringArray(tranId, ":");
			suppCode = pkValuesArr[0].trim();
			effFromStr = pkValuesArr[1].trim();
			validUptoStr = pkValuesArr[2].trim();
			
			System.out.println(">>>Array suppCode:"+suppCode);
			System.out.println(">>>Array effFromStr:"+effFromStr);
			System.out.println(">>>Array validUptoStr:"+validUptoStr);
			
			if(empCodeAprv!=null && empCodeAprv.trim().length() >0)
			{
				empCodeAprv= empCodeAprv.trim();
			}
			sql = " select code from users where emp_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCodeAprv);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				loginCode = rs.getString(1);
			}
			System.out.println(">>>>from users loginCode:"+loginCode);

			loginCode = loginCode == null ? "" : loginCode.trim();
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			xtraParams = "loginCode=" + loginCode + "~~" + "loginSiteCode=" + loginSiteCode + "~~" + "loginEmpCode=" + empCodeAprv;
			System.out.println(">>>xtraParams:"+xtraParams);
			
			//Check the condition for keyFlag, If Request is approved then confirmation will be sent and WF_STATUS will update as 'C' (Closed)
			if(keyFlag!= null && "SUPAPRV".equals(keyFlag))
			{
				System.out.println(">>>Approved The Supplier Bank Transaction Request<<<<");
				acp = new AppConnectParm();
				ctx = new InitialContext(acp.getProperty());
				suppBankConfLocal = (SupplierBankConfLocal) ctx.lookup("ibase/SupplierBankConf/local");
				retString = suppBankConfLocal.confirm(tranId, xtraParams, "Y");
				System.out.println(">>>>>>SupplierBankConf return from confirm:"  + retString);
				
				if(retString.indexOf("VTCONSUCF") > -1) 
				{
					System.out.println(">>>In SupplierBankWfConf Transaction Confirmed Successfuly");
					retString = "Y";
				} 
				else 
				{
					isError=true;
					System.out.println(">>>Exception while calling EJB SupplierBankWfConf component");
				}
			}
			else if(keyFlag!= null && "SUPREJECT".equals(keyFlag))
			{
			    //Check the condition for keyFlag, If Request is rejected and WF_STATUS will update as 'R' (Rejected)
				System.out.println(">>>Reject The Supplier Bank Transaction Request<<<<");
				if(tranId!= null && tranId.trim().length() > 0)
				{
					effFromDate = Timestamp.valueOf(genericUtility.getValidDateString(effFromStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
					validUptoDate = Timestamp.valueOf(genericUtility.getValidDateString(validUptoStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
					System.out.println(">>Before reject effFromDate:"+effFromDate);
					System.out.println(">>Before reject validUptoDate:"+validUptoDate);
					
					sql= "update supplier_bank set wf_status='R' where supp_code= ? and eff_from= ? and valid_upto= ? ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, suppCode);
					pstmt.setTimestamp(2, effFromDate);
					pstmt.setTimestamp(3, validUptoDate);
					updCnt= pstmt.executeUpdate();
					pstmt.close();
					pstmt= null;
					System.out.println(">>>update supplier_bank updCnt:"+updCnt);
					if(updCnt > 0)
					{
						System.out.println(">>>In SupplierBankWfConf Transaction Rejected Successfuly");
						retString = "Y";
					}
					else
					{
						isError=true;
					}
				}
			}
		} 
		catch (Exception e)
		{
			isError=true;
			e.printStackTrace();
			System.out.println(">>Exeption occured");

			throw new ITMException(e);
		}
		finally 
		{
			try
			{
				System.out.println(">>>In finally Check isError:"+isError);
				if(!isError)
				{
					conn.commit();
					System.out.println(">>>>Connection commit successfuly");
				}
				else
				{
					conn.rollback();
					System.out.println(">>>>Connection rollback successfuly");
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("In finally Exception :"+e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;
	}
	private String[] string2StringArray(String str1, String delimeter) 
	{
		StringTokenizer st = new StringTokenizer(str1, delimeter);
		int count = st.countTokens();
		System.out.println("TOKEN COUNT" + count);
		String[] arry1 = new String[count];
		int i = 0;
		while (st.hasMoreTokens()) 
		{
			arry1[i] = st.nextToken();
			System.out.println("Token " + i + " :[" + arry1[i] + "]");
			i++;
		}
		return arry1;
	}
}
