package ibase.dashboard.mfg.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.simple.JSONObject;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

@Stateless
public class PendingQCPurchaseOrder extends ValidatorEJB implements PendingQCPurchaseOrderLocal, PendingQCPurchaseOrderRemote
{

	public PendingQCPurchaseOrder()
	{
		 // TODO Auto-generated constructor stub
	}
	
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	@SuppressWarnings("unchecked")
    public JSONObject getPendingQCOrderPurchase(String geoLocation, String siteCode, String dataSourceName) throws RemoteException,ITMException 
	{
		
		System.out.println("In PendingQCOrder getPendingQCOrderPurchase geoLocation :"+geoLocation+"----siteCode :"+siteCode+"---dataSourceName :"+dataSourceName);
		JSONObject rowDataPendingQCOrderPurc = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			int count = 0;
			
			dashboardUtility = new DashboardUtility();
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			geoLocation = dashboardUtility.getCommaSeparated(geoLocation);
			System.out.println("geoLocation :"+geoLocation);
			if(geoLocation.trim().length()>0 && geoLocation!=null && siteCode!=null && siteCode.trim().length()>0)
			{
			/* sql=  " SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL,GIM_VALUE_In_Rs" +
				  		" FROM (SELECT z.no_of_days AS no_of_days, z.ITEM_SER AS ITEM_SER," +
				  		" SUM(z.NO_OF_OPEN_QCORDER) AS NO_OF_OPEN_QCORDER, z.CHK_VAL AS CHK_VAL, " +
				  		" sum(z.amt) as GIM_VALUE_IN_RS FROM (SELECT CASE " +
				  		" WHEN  TO_CHAR(A.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY')" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<90 THEN '>0-90 days'" +
				  		" WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY')" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=90" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<180 THEN '>90-180 days'" +
				  		" WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=180 " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<365 THEN '>180-365 days'" +
				  		" WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY')" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>365 THEN '>365 days' " +
				  		" WHEN TO_CHAR(a.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
				  		" THEN  TO_CHAR(a.TRAN_DATE,'YYYY') END no_of_days, A.ITEM_SER,COUNT(G.QORDER_NO)" +
				  		" AS NO_OF_OPEN_QCORDER, (CASE WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 0 " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 90 THEN 1 " +
				  		" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 90 " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 180 THEN 2 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 180 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 365 THEN 3 " +
				  		" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 365 THEN 4 " +
				  		" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
				  		" THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (a.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) AS CHK_VAL, sum(b.quantity*b.rate*A.EXCH_RATE) " +
				  		" as amt FROM PORCP A,PORCPDET B,ITEM C,SUPPLIER D,QC_ORDER G " +
				  		" WHERE " +
				  		" A.SITE_CODE IN ("+siteCode+") " +
				  		" AND A.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
				  		" AND " +
				  		" A.CONFIRMED='Y' AND G.STATUS='U' AND A.TRAN_ID=B.TRAN_ID " +
				  		" AND B.ITEM_CODE=C.ITEM_CODE AND A.SUPP_CODE=D.SUPP_CODE AND G.LOT_NO=B.LOT_NO " +
				  		" AND g.PORCP_NO=A.TRAN_ID AND G.ITEM_CODE=B.ITEM_CODE GROUP BY A.item_ser,A.TRAN_DATE) z GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL ORDER BY z.ITEM_SER) ORDER BY CHK_VAL ASC ";
	                    	*/
				
				sql=    " SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL, " +
						" ROUND((GIM_VALUE)/100000,3) As GIM_VALUE " +
						" FROM ( SELECT z.no_of_days AS no_of_days, " +
						" z.ITEM_SER AS ITEM_SER, SUM(z.NO_OF_OPEN_QCORDER) " +
						" AS NO_OF_OPEN_QCORDER, z.CHK_VAL AS CHK_VAL, sum(z.amt) as GIM_VALUE " +
						" FROM (SELECT CASE WHEN  TO_CHAR(A.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<90 " +
						" THEN '>0-90 days' WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<180 " +
						" THEN '>90-180 days' WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=180 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<365 " +
						" THEN '>180-365 days' WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>365 THEN '>365 days' " +
						" WHEN TO_CHAR(a.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
						" THEN  TO_CHAR(a.TRAN_DATE,'YYYY') END no_of_days, A.ITEM_SER,COUNT(DISTINCT(G.QORDER_NO)) " +
						" AS NO_OF_OPEN_QCORDER, (CASE WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 0 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 90 " +
						" THEN 1 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 90 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 180 " +
						" THEN 2 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 180 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 365 " +
						" THEN 3 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 365 THEN 4 " +
						" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
						" THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (a.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) " +
						" AS CHK_VAL, sum(b.quantity*b.rate*A.EXCH_RATE) as amt " +
						" FROM PORCP A,PORCPDET B,ITEM C,SUPPLIER D,QC_ORDER G,SITE H " +
						" WHERE " +
						" A.SITE_CODE IN ("+siteCode+") " +
						" AND A.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
						" AND " +
						" A.CONFIRMED='Y' AND G.STATUS='U' AND G.QC_CREATE_TYPE='A' AND A.TRAN_ID=B.TRAN_ID AND B.ITEM_CODE=C.ITEM_CODE " +
						" AND A.SUPP_CODE=D.SUPP_CODE AND G.LOT_NO=B.LOT_NO AND g.PORCP_NO=A.TRAN_ID " +
						" AND G.ITEM_CODE=B.ITEM_CODE AND A.SITE_CODE=H.SITE_CODE " +
						" AND H.CITY in("+geoLocation+") " +
						" GROUP BY A.item_ser,A.TRAN_DATE) z GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL " +
						" ORDER BY z.ITEM_SER) ORDER BY CHK_VAL ASC ";
				
			 pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				String noOfOpenQCOrderVal="";
				String gimValue="";
				String noOfDay="",subType="";
				List<String> noOfDayList= new ArrayList<String>();
				List<String> subTypeList= new ArrayList<String>();
				String key="";
				LinkedHashMap<String, String> graphDataMap = new LinkedHashMap<String, String>(); 
		   		LinkedHashMap<String, String> sortedGraphDataMap = new LinkedHashMap<String, String>(); 
				while (rs.next())
				{
					
					noOfOpenQCOrderVal = rs.getString("NO_OF_OPEN_QCORDER");
					noOfDay = rs.getString("NO_OF_DAYS");
					subType= rs.getString("ITEM_SER");
					gimValue= rs.getString("GIM_VALUE");
					
					if(!noOfDayList.contains(noOfDay))
					{
						noOfDayList.add(noOfDay);
					}
					if(!subTypeList.contains(subType))
					{
						subTypeList.add(subType);
					}
					key = (noOfDay.trim()+"@"+subType.trim());
				        if(graphDataMap.size()==0)
				        {
				        	graphDataMap.put(key, (noOfOpenQCOrderVal+"-"+gimValue));
				        }
				        if(graphDataMap !=null && graphDataMap.size()>0)
				        {
				        	if(graphDataMap.containsKey(key))
				        	{
				        		//wipValue = wipValue +  graphDataMap.get(key);
				        		noOfOpenQCOrderVal = graphDataMap.get(key);
				        	}
				        	else  if(! graphDataMap.containsKey(key))
				        	{
				        		noOfOpenQCOrderVal = noOfOpenQCOrderVal+"-"+gimValue;
				        	}
				        	graphDataMap.put(key, noOfOpenQCOrderVal);
				        }
					
				}
			
			System.out.println("graphDataMap: "+graphDataMap);
			String sbType="";
			String grpKey="";
			for(int itmCtr=0;itmCtr<subTypeList.size();itmCtr++)
				{
					sbType = subTypeList.get(itmCtr);
					for (Map.Entry<String, String> grpentry : graphDataMap.entrySet())
					{
						for(int dayCtr=0;dayCtr<noOfDayList.size();dayCtr++)
						{
							grpKey = (noOfDayList.get(dayCtr).trim()+"@"+sbType.trim());
							if(graphDataMap.containsKey(grpKey))
							{
								sortedGraphDataMap.put(grpKey, graphDataMap.get(grpKey));
							}
							if(!graphDataMap.containsKey(grpKey) )
							{
								sortedGraphDataMap.put(grpKey, "0-0");
							}
						}
					}
				}
			System.out.println("sortedGraphDataMap: "+sortedGraphDataMap);
			rowData = new JSONObject();
			String noDays="",qcOrd="";
			String subType1="",prvsubType1="";
			LinkedHashMap<String, String> catValues = new LinkedHashMap<String, String>();
			LinkedHashMap<String, String> catGimValues = new LinkedHashMap<String, String>();
			int cnt=0;
			for (Map.Entry<String, String> entry : sortedGraphDataMap.entrySet())
				{
					cnt++;
					String mapKey     = entry.getKey();
					String value  = entry.getValue();// need to split
					String[] temp = null;
					temp = mapKey.split("@");
					noDays = temp[0].trim();
					subType1 = temp[1].trim();
					
					String[] qcOrdArr = null;
					qcOrdArr = value.split("-");
					qcOrd = qcOrdArr[0].trim();
					
					
					if( subType1 != null && ("").equals(prvsubType1) && subType1.trim().length()>0)
					{
						catValues.put(noDays,qcOrd);	
						catGimValues.put(noDays,value);	
						rowData.put("month",cnt);
						rowData.put("product_category",subType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catGimValues);
					}
					else if(!("").equals(prvsubType1) && prvsubType1.equals(subType1))
					{
						catValues.put(noDays,qcOrd);
						catGimValues.put(noDays,value);	
					}
					else if(!("").equals(prvsubType1) && ! prvsubType1.equals(subType1))
					{
						rowData.put("month",cnt);
						rowData.put("product_category",prvsubType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catGimValues);
						rowDataPendingQCOrderPurc.put(count, rowData);
						count++;
						rowData = new JSONObject();
						catValues = new LinkedHashMap<String, String>();
						catGimValues = new LinkedHashMap<String, String>();
						catGimValues.put(noDays,value);	
						catValues.put(noDays,qcOrd);
					}
					if(cnt==sortedGraphDataMap.size())
					{
						rowData.put("month",++cnt);
						rowData.put("product_category",subType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catGimValues);
						rowDataPendingQCOrderPurc.put(count, rowData);
					}
					prvsubType1=subType1;
				}
				if(rowDataPendingQCOrderPurc.isEmpty())
				{
					System.out.println("**** rowDataPendingQCOrderPurc is Empty **** ");
					catValues.put(">0-90 days", "0");
					catValues.put(">90-180 days", "0");
					catValues.put(">180-365 days", "0");
					
					catGimValues.put(">0-90 days", "0-0");
					catGimValues.put(">90-180 days", "0-0");
					catGimValues.put(">180-365 days", "0-0");
					
					rowData = new JSONObject();
					rowData.put("month",cnt);
					rowData.put("product_category","RM1");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catGimValues);
					rowDataPendingQCOrderPurc.put(count, rowData);
					
					rowData = new JSONObject();
					rowData.put("month",++cnt);
					rowData.put("product_category","BD");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catGimValues);
					rowDataPendingQCOrderPurc.put(++count, rowData);
					
					rowData = new JSONObject();
					rowData.put("month",++cnt);
					rowData.put("product_category","PM1");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catGimValues);
					rowDataPendingQCOrderPurc.put(++count, rowData);
					
					rowData = new JSONObject();
					rowData.put("month",++cnt);
					rowData.put("product_category","BDI");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catGimValues);
					rowDataPendingQCOrderPurc.put(++count, rowData);
				}
			}	
			System.out.println("rowDataPendingQCOrderPurc :"+rowDataPendingQCOrderPurc);

			/*Code for PDF*/
			
			/*Document document = new Document();
			String subtype = "";
			PdfWriter.getInstance(document,new FileOutputStream("/home/support-1/Desktop/HelloWorld-Table.pdf"));
			JSONObject fetchRowWiseValJsn = null;
            document.open();
            PdfPTable table = null; // 3 columns.
            PdfPCell cell1 = null;
            PdfPCell cell2 = null;
            PdfPCell cell3 = null;
           
            LinkedHashMap<String, String> catGimValues = null;
            DecimalFormat df = new DecimalFormat("#.###");
            HashMap<Integer, String> totalMap = new HashMap<Integer, String>();
            for (int jsnCnt = 0; jsnCnt < rowDataPendingQCOrderPurc.size(); jsnCnt++)
            {
            	catGimValues = new LinkedHashMap<String, String>();
            	fetchRowWiseValJsn = new JSONObject();
            	fetchRowWiseValJsn = (JSONObject) rowDataPendingQCOrderPurc.get(jsnCnt);
            	subtype = ""+fetchRowWiseValJsn.get("product_category");
            	
            	System.out.println("subtype :"+subtype);
            	catGimValues = (LinkedHashMap<String, String>) fetchRowWiseValJsn.get("category_gimvalue");
            	System.out.println("catGimValues :"+catGimValues);
            	
            	count = 0;
            	
            	System.out.println("catValuesGim.size() :"+catGimValues.size());
            	if(jsnCnt == 0)
            	{
            		table = new PdfPTable(catGimValues.size()+1+catGimValues.size());
            		cell1 = new PdfPCell(new Paragraph("OPEN SINCE", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
               		cell1.setBackgroundColor(Color.gray);
               		
                	table.addCell(cell1); 
                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
    	            {
                		
                		cell2 = new PdfPCell(new Paragraph(entry.getKey(), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
                		cell2.setColspan(2);
                		cell2.setBackgroundColor(Color.gray);
    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
    	            	table.addCell(cell2);
    	            }
                	table.setWidthPercentage(100);
                	document.add(table);
                	
                	table = new PdfPTable(catGimValues.size()*2+1);
            		cell1 = new PdfPCell(new Paragraph("", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
                	table.addCell(cell1); 
                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
    	            {                		                               		
                		cell2 = new PdfPCell(new Paragraph("Open QC Order Count", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
                		cell3 = new PdfPCell(new Paragraph("GIM Value In Lacs", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
                		
    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
    	            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
    	            	table.addCell(cell2);
    	            	table.addCell(cell3);
    	            }
                	table.setWidthPercentage(100);
                	document.add(table);           	                	
            	}           	           	           	
            	table = new PdfPTable(catGimValues.size() * 2 + 1); 
            	cell1 = new PdfPCell(new Paragraph(subtype, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
            	table.addCell(cell1); 
	            for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
	            {	            		            	
	            		            		            		            		          	
	            	String val = entry.getValue();
	            	
	            	String[] temp;
	            	String noOfQC = "";
	            	String gimVal = "";
	            	temp = val.split("-");
	            	noOfQC = temp[0].trim();
	            	gimVal = temp[1].trim();
	            	System.out.println("noOfQC :"+noOfQC+"---- gimVal :"+gimVal);
	            	String totalStrVal =  "";
	            	cell2 = new PdfPCell(new Paragraph(noOfQC, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	            	cell3 = new PdfPCell(new Paragraph(gimVal, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
	            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
	            	
	            	table.addCell(cell2);
	            	table.addCell(cell3);
	            	
	            	if(jsnCnt == 0)
					{
						totalStrVal = noOfQC+"@"+gimVal;
		            	totalMap.put(count, totalStrVal);
		            	count++;
		            	System.out.println("totalMap in if:"+totalMap);
					}
					else
					{
						totalStrVal =  totalMap.get(count);
		            	System.out.println("str in else :"+totalStrVal);
		            	String[] totalStrValArr;
		            	totalStrValArr = totalStrVal.split("@");
		            	
		            	String noOfQC1 = totalStrValArr[0].trim();
		            	String gimVal1 = totalStrValArr[1].trim();
		            	
		            	int noOfQCTotal = Integer.parseInt(noOfQC) + Integer.parseInt(noOfQC1);
		            	double gimValTotal = Double.parseDouble(gimVal) + Double.parseDouble(gimVal1);
		            	totalStrVal =  ""+noOfQCTotal+"@"+""+gimValTotal;
		            	System.out.println("str in else:"+totalStrVal);
		            	totalMap.put(count, totalStrVal);
		            	
		            	
		            	count++;
					}
	            }
	            table.setWidthPercentage(100);
	            document.add(table);
	            
			}
            System.out.println("totalMap :"+totalMap);
    		table = new PdfPTable(catGimValues.size()* 2 +1);
    		cell1 = new PdfPCell(new Paragraph("TOTAL", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
       		table.addCell(cell1); 
        	for (Map.Entry<Integer, String> entry : totalMap.entrySet())
            {
       			String val = entry.getValue();
            	String[] temp;
            	String noOfQC = "";
            	String gimVal = "";
            	double total= 0.0;
            	temp = val.split("@");
            	noOfQC = temp[0].trim();
            	gimVal = temp[1].trim();
            	
       			cell2 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(noOfQC)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
       			cell3 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(gimVal)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
       			
       			cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
       			cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
            	
       			table.addCell(cell2);
            	table.addCell(cell3);
            }
        	table.setWidthPercentage(100);
        	document.add(table);
            
        	document.close();
            System.out.println("PDF Create Successfully");*/
		}
            catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :PendingQCPurchaseOrder : getPendingQCOrderPurchase():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataPendingQCOrderPurc;
	}	
	@SuppressWarnings("unchecked")
    public JSONObject getPendingQCOrderPurchaseGrid(String geoLocation, String siteCode, String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rowDataPendingQCOrderPurcGrid = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			System.out.println(" Inside getPendingQCOrderPurchase for getPendingQCOrderPurchaseGrid Data Soruc Name ="+dataSourceName);
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			int count = 0;
			dashboardUtility = new DashboardUtility();
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			geoLocation = dashboardUtility.getCommaSeparated(geoLocation);
			System.out.println("geoLocation in getPendingQCOrderPurchaseGrid :"+geoLocation);
			if(geoLocation.trim().length()>0 && geoLocation!=null && siteCode!=null && siteCode.trim().length()>0)
			{
			
			/* sql=  " SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL,GIM_VALUE_In_Rs" +
				  		" FROM (SELECT z.no_of_days AS no_of_days, z.ITEM_SER AS ITEM_SER," +
				  		" SUM(z.NO_OF_OPEN_QCORDER) AS NO_OF_OPEN_QCORDER, z.CHK_VAL AS CHK_VAL, " +
				  		" sum(z.amt) as GIM_VALUE_In_Rs FROM (SELECT CASE " +
				  		" WHEN  TO_CHAR(A.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY')" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<90 THEN '>0-90 days'" +
				  		" WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY')" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=90" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<180 THEN '>90-180 days'" +
				  		" WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=180 " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<365 THEN '>180-365 days'" +
				  		" WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY')" +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>365 THEN '>365 days' " +
				  		" WHEN TO_CHAR(a.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
				  		" THEN  TO_CHAR(a.TRAN_DATE,'YYYY') END no_of_days, A.ITEM_SER,COUNT(G.QORDER_NO)" +
				  		" AS NO_OF_OPEN_QCORDER, (CASE WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 0 " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 90 THEN 1 " +
				  		" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 90 " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 180 THEN 2 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
				  		" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 180 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 365 THEN 3 " +
				  		" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 365 THEN 4 " +
				  		" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
				  		" THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (a.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) AS CHK_VAL, sum(b.quantity*b.rate*A.EXCH_RATE) " +
				  		" as amt FROM PORCP A,PORCPDET B,ITEM C,SUPPLIER D,QC_ORDER G " +
				  		" WHERE " +
				  		" A.SITE_CODE IN ("+siteCode+") " +
				  		" AND A.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
				  		" AND " +
				  		" A.CONFIRMED='Y' AND G.STATUS='U' AND A.TRAN_ID=B.TRAN_ID " +
				  		" AND B.ITEM_CODE=C.ITEM_CODE AND A.SUPP_CODE=D.SUPP_CODE AND G.LOT_NO=B.LOT_NO " +
				  		" AND g.PORCP_NO=A.TRAN_ID AND G.ITEM_CODE=B.ITEM_CODE GROUP BY A.item_ser,A.TRAN_DATE) z GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL ORDER BY z.ITEM_SER) ORDER BY CHK_VAL ASC ";
	                    	*/
			
				sql=    " SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL, " +
						" ROUND((GIM_VALUE)/100000,3) As GIM_VALUE FROM ( SELECT z.no_of_days AS no_of_days, " +
						" z.ITEM_SER AS ITEM_SER, SUM(z.NO_OF_OPEN_QCORDER) " +
						" AS NO_OF_OPEN_QCORDER, z.CHK_VAL AS CHK_VAL, sum(z.amt) as GIM_VALUE " +
						" FROM (SELECT CASE WHEN  TO_CHAR(A.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<90 " +
						" THEN '>0-90 days' WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<180 " +
						" THEN '>90-180 days' WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>=180 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)<365 " +
						" THEN '>180-365 days' WHEN  TO_CHAR(a.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)>365 THEN '>365 days' " +
						" WHEN TO_CHAR(a.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
						" THEN  TO_CHAR(a.TRAN_DATE,'YYYY') END no_of_days, A.ITEM_SER,COUNT(DISTINCT(G.QORDER_NO)) " +
						" AS NO_OF_OPEN_QCORDER, (CASE WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 0 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 90 " +
						" THEN 1 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 90 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 180 " +
						" THEN 2 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 180 AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE)  < 365 " +
						" THEN 3 WHEN TO_CHAR (a.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - a.TRAN_DATE) >= 365 THEN 4 " +
						" WHEN TO_CHAR (a.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
						" THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (a.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) " +
						" AS CHK_VAL, sum(b.quantity*b.rate*A.EXCH_RATE) as amt " +
						" FROM PORCP A,PORCPDET B,ITEM C,SUPPLIER D,QC_ORDER G,SITE H " +
						" WHERE " +
						" A.SITE_CODE IN ("+siteCode+") " +
						" AND A.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
						" AND " +
						" A.CONFIRMED='Y' AND G.STATUS='U' AND G.QC_CREATE_TYPE='A' AND A.TRAN_ID=B.TRAN_ID AND B.ITEM_CODE=C.ITEM_CODE " +
						" AND A.SUPP_CODE=D.SUPP_CODE AND G.LOT_NO=B.LOT_NO AND g.PORCP_NO=A.TRAN_ID " +
						" AND G.ITEM_CODE=B.ITEM_CODE AND A.SITE_CODE=H.SITE_CODE " +
						" AND H.CITY in("+geoLocation+") " +
						" GROUP BY A.item_ser,A.TRAN_DATE) z GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL " +
						" ORDER BY z.ITEM_SER) ORDER BY CHK_VAL ASC ";
				
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					rowData = new JSONObject();
					
					rowData.put("no_of_days", rs.getString("no_of_days"));		
					rowData.put("item_ser", rs.getString("ITEM_SER"));
					rowData.put("no_of_open_qcorder", rs.getString("NO_OF_OPEN_QCORDER"));
					rowData.put("gim_value_in_rs", rs.getString("GIM_VALUE"));
					rowDataPendingQCOrderPurcGrid.put(count, rowData);
					count++;
				}
			}
			System.out.println("rowDataPendingQCOrderPurcGrid :"+rowDataPendingQCOrderPurcGrid);
				    
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PendingQCPurchaseOrder : getPendingQCOrderPurchaseGrid:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataPendingQCOrderPurcGrid;
    }
	
	/*Start- this method add for generatePDF on 13Aug2015*/
	 @SuppressWarnings("unchecked")
	public String getPDFByScheduler(String rptTitle, String remark, String userID, String imgName, String city, String siteCode) throws RemoteException, ITMException 
	 {
		 System.out.println("In PendingQCPurchaseOrder EJB.getPDFByScheduler Method ");
			PdfWriter writer = null;	
			OutputStream file = null;
			Document document = null;		
			ConnDriver connDriver = new ConnDriver();
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;		
			ArrayList<String> mailInfo=null;
			String imageName = null;
			Image image = null;
			File attachFile   = null;
			File attachExcleFile   = null;
			File attachManualQCExcleFile   = null;
		    String imgFilePath =null;	
		    File  existImgFile =null;
		    String pdfFileName =null;
		    String excelFileName = null;
		    String excelManualQCFileName = null;
		    String toMailId    =""; 
			String ccMailId    ="";
			String bccAddress  =""; 
			String subject     ="";
			String userWiseBodytext="";
			String resultFlage ="false";
			String exportPDFPath ="";
			String exportImagePath = "";
			String imgNameArray[] = null;  
			SimpleDateFormat simpleDateFormat = null;
			Calendar calendar = null;
			String currDate = "";
			int prntTblNo      =1;
			PdfPTable parentTable=null;
			Paragraph preface = null;
			
			PdfPTable table = null; 
			PdfPCell cell1 = null;
			PdfPCell cell2 = null;
			PdfPCell cell3 = null;
			String subtype = "";
           
			JSONObject fetchRowWiseValJsn = null;
			JSONObject rowDataforGrid = null;
			//List<String> valList = new ArrayList<String>();
			int count = 0;
			LinkedHashMap<String, String> catGimValues = null;
			DecimalFormat df = new DecimalFormat("#.###");
			HashMap<Integer, String> totalMap = null;
			
			String noOfQC = "";
        	String gimVal = "";
        	String totalStrVal =  "";
        	String val = "";
        	int noOfQCTotal = 0;
        	double gimValTotal = 0.0;
        	String noOfQCPrev = "";
        	String gimValPrev = "";
        	String titleForManualQCExcel = "";
			System.out.print("Calling for PDF created step1");
			try
			{
				
				
				System.out.println("In PendingQCPurchaseOrder getPDFByScheduler city :"+city+"----siteCode :"+siteCode);
				
				
				
				 //START CODE FOR WINDOWS
				//exportPDFPath    ="C://jboss-5.1.0.GA//server//default//deploy//ibase.ear//ibase.war//dashboard//mfg//Scheduler//ExportExample//ExportPDF//";
				//exportImagePath  ="C://jboss-5.1.0.GA//server//default//deploy//ibase.ear//ibase.war//dashboard//mfg//Scheduler//ExportExample//ExportImages//";
				 //END CODE FOR WINDOWS
				
				 //START CODE FOR LINUX
				exportPDFPath      = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportPDF"+File.separator;
		        exportImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportImages"+File.separator;
		       //END CODE FOR LINUX
				System.out.println("exportPDFPath----->"+exportPDFPath);				
				simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
				calendar      = Calendar.getInstance();
				currDate      = simpleDateFormat.format(calendar.getTime());			
				document      = new Document();				
				//rptTitle      = rptTitle.replace("@", "&");
				
				rptTitle      = city+" ("+siteCode+")"+" Pending QC Against Purchase as on " +currDate;
				titleForManualQCExcel = city+" ("+siteCode+")"+" Pending Manual QC as on " +currDate;
				System.out.println("rptTitle in PendingQCPurchaseOrder getPDFByScheduler :"+rptTitle);
				
				pdfFileName     = exportPDFPath+rptTitle+".pdf";
				excelFileName   = exportPDFPath+rptTitle+".xls";
				excelManualQCFileName = exportPDFPath+titleForManualQCExcel+".xls";
				
				System.out.println("excelFileName :"+excelFileName);
				System.out.println("pdfFileName "+	pdfFileName);
				
				file          = new FileOutputStream(new File(pdfFileName));			
				writer        = PdfWriter.getInstance(document, file);
				document.open();			
				
			   
			    
				imgNameArray = imgName.split(",");
				for(int size=0;size<imgNameArray.length;size++)
				{
					totalMap = new HashMap<Integer, String>();
					imageName= imgNameArray[size];
					System.out.println("imageName in PendingQCPurchaseOrder getPDFByScheduler =="+imageName);
					imgFilePath = exportImagePath+imageName+".png";
					existImgFile= new File(imgFilePath);
					
					
					if(existImgFile.exists())
					{
						image = Image.getInstance(imgFilePath);
						if(size == 0)
						{
							rptTitle      = city+" ("+siteCode+")"+" Pending QC Against Purchase as on " +currDate;
							subject = rptTitle;
							rowDataforGrid = this.getPendingQCOrderPurchase(city, siteCode, "DriverITM");
							System.out.println("rowDataforGrid in getPDFByScheduler :"+rowDataforGrid);
							this.getExcelGenerate(city, siteCode, "DriverITM");
						}else if(size == 1)
						{
							rptTitle      = city+" ("+siteCode+")"+" Pending Manual QC as on " +currDate;
							rowDataforGrid = this.getPendingManualQCOrder(city, siteCode, "DriverITM");
							System.out.println("rowDataforGrid in getPDFByScheduler :"+rowDataforGrid);
							this.getPendingManualQCExcelGenerate(city, siteCode, "DriverITM");	
						}
						
						preface = new Paragraph();
						preface.setAlignment(Element.ALIGN_CENTER);
					    preface.add(new Paragraph(rptTitle, FontFactory.getFont(FontFactory.TIMES_ROMAN, 15)));
					    preface.add(new Paragraph(" "));   
					    document.add(preface);
					    
						parentTable = new PdfPTable(1);
						parentTable.addCell(image);
						
						existImgFile.delete();
						System.out.println("Image  Deleted after status *******"+imgFilePath ); 
						
						parentTable.setWidthPercentage(100);
						
						document.add(parentTable);
						preface = new Paragraph();
						/*preface.add(new Paragraph(" "));*/
						document.add(preface);
						
						preface = new Paragraph();
						preface.add(new Paragraph("Remark: "+remark, FontFactory.getFont(FontFactory.TIMES_ROMAN, 8)));
						preface.add(new Paragraph(" "));
						document.add(preface);
							
						preface.add(new Paragraph(" ")); 
						for (int jsnCnt = 0; jsnCnt < rowDataforGrid.size(); jsnCnt++)
						{
			            	catGimValues = new LinkedHashMap<String, String>();
			            	fetchRowWiseValJsn = new JSONObject();
			            	fetchRowWiseValJsn = (JSONObject) rowDataforGrid.get(jsnCnt);
			            	subtype = ""+fetchRowWiseValJsn.get("product_category");
			            	
			            	System.out.println("subtype :"+subtype);
			            	catGimValues = (LinkedHashMap<String, String>) fetchRowWiseValJsn.get("category_gimvalue");
			            	System.out.println("catGimValues :"+catGimValues);
			            	
			            	count = 0;
			            	
			            	System.out.println("catValuesGim.size() :"+catGimValues.size());
			            	if(jsnCnt == 0)
			            	{
			            		table = new PdfPTable(catGimValues.size()*2+1);
			            		cell1 = new PdfPCell(new Paragraph("OPEN SINCE", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
			               		cell1.setBackgroundColor(Color.gray);
			               		
			                	table.addCell(cell1); 
			                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
			    	            {
			                		
			                		cell2 = new PdfPCell(new Paragraph(entry.getKey(), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
			                		cell2.setColspan(2);
			                		cell2.setBackgroundColor(Color.gray);
			    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
			    	            	table.addCell(cell2);
			    	            }
			                	table.setWidthPercentage(100);
			                	document.add(table);
			                	
			                	table = new PdfPTable(catGimValues.size()*2+1);
			            		cell1 = new PdfPCell(new Paragraph("", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
			                	table.addCell(cell1); 
			                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
			    	            {                		                               		
			                		cell2 = new PdfPCell(new Paragraph("Open QC Order Count", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
			                		cell3 = new PdfPCell(new Paragraph("GIM Value Rs(In Lacs)", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
			                		
			    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
			    	            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
			    	            	table.addCell(cell2);
			    	            	table.addCell(cell3);
			    	            }
			                	table.setWidthPercentage(100);
			                	document.add(table);           	                	
			            	}           	           	           	
			            	table = new PdfPTable(catGimValues.size() * 2 + 1); 
			            	cell1 = new PdfPCell(new Paragraph(subtype, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
			            	table.addCell(cell1); 
				            for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
				            {	            		            	
				            		            		            		            		          	
				            	val = entry.getValue();
				            	
				            	String[] temp = null;
				            	noOfQC = "";
				            	gimVal = "";
				            	totalStrVal =  "";
				            	temp = val.split("-");
				            	noOfQC = temp[0].trim();
				            	gimVal = temp[1].trim();
				            	System.out.println("noOfQC :"+noOfQC+"---- gimVal :"+gimVal);
				            	
				            	cell2 = new PdfPCell(new Paragraph(noOfQC, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
				            	cell3 = new PdfPCell(new Paragraph(gimVal, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
				            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
				            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
				            	
				            	table.addCell(cell2);
				            	table.addCell(cell3);
				            	
				            	if(jsnCnt == 0)
								{
									totalStrVal = noOfQC+"@"+gimVal;
					            	totalMap.put(count, totalStrVal);
					            	count++;
								}
								else
								{
									noOfQCTotal = 0;
					            	gimValTotal = 0.0;
					            	noOfQCPrev = "";
					            	gimValPrev = "";
									totalStrVal =  totalMap.get(count);
					            	String[] totalStrValArr;
					            	totalStrValArr = totalStrVal.split("@");
					            	noOfQCPrev = totalStrValArr[0].trim();
					            	gimValPrev = totalStrValArr[1].trim();
					            	
					            	noOfQCTotal = Integer.parseInt(noOfQC) + Integer.parseInt(noOfQCPrev);
					            	gimValTotal = Double.parseDouble(gimVal) + Double.parseDouble(gimValPrev);
					            	totalStrVal =  ""+noOfQCTotal+"@"+""+gimValTotal;
					            	totalMap.put(count, totalStrVal);
					            	count++;
								}
				            	
				            }
				            table.setWidthPercentage(100);
				            document.add(table);
				            
						}
						
						/*Add code for total by Dhanendra on 08-09-15*/
						table = new PdfPTable(catGimValues.size()* 2 +1);
			    		cell1 = new PdfPCell(new Paragraph("TOTAL", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
			       		table.addCell(cell1); 
			        	
			       		System.out.println("totalMap in PendingQCPurchaseOrder :"+totalMap);
			       		for (Map.Entry<Integer, String> entry : totalMap.entrySet())
			            {
			       			val = entry.getValue();
			            	String[] tempArr;
			            	noOfQC = "";
			            	gimVal = "";
			            	tempArr = val.split("@");
			            	noOfQC = tempArr[0].trim();
			            	gimVal = tempArr[1].trim();
			            	
			            	cell2 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(noOfQC)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
			       			cell3 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(gimVal)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
			       			
			       			cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
			       			cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
			            	
			       			table.addCell(cell2);
			            	table.addCell(cell3);
			            }
				        table.setWidthPercentage(100);
				        document.add(table);
				        document.newPage();   
					}
				}
					
				
	        	/*End code for total by Dhanendra on 08-09-15*/
	        	
				document.close();
				file.close();
				
				System.out.println("PDF Created succesfully in PendingQCPurchaseOrder getPDFByScheduler");
				/*conn = connDriver.getConnectDB("DriverITM");
				connDriver  =null;*/
				/*add new code for connection DB on dated:17062016 by Nikhil*/
				conn = getConnection();
				toMailId    =""; 
				ccMailId    ="";
				bccAddress  =""; 
				//subject     =rptTitle;
				userWiseBodytext ="Dear Sir, Please find attached here with is the Weekly Output:"+subject+" Report in PDF format.";
					
				city = "PQCPAR_"+city.trim();
				System.out.println("Add PQCPAR in city  :" +city);
				String sql = "SELECT SEND_TO, COPY_TO, BLIND_COPY FROM MAIL_FORMAT WHERE FORMAT_CODE = '"+city+"'";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					toMailId     = checkNull(rs.getString("SEND_TO").trim());
					ccMailId     = checkNull(rs.getString("COPY_TO").trim());
					bccAddress   = checkNull(rs.getString("BLIND_COPY").trim());
					System.out.println("No of Users for PendingQCWorkOrder.getPDFByScheduler city = "+city+" --- toMailId ="+toMailId +"AND According to the ccMailId ======="+ccMailId+"---- bccAddress ==  "+bccAddress);
				}

				/*toMailId = "Julian.Soares@sunpharma.com,Bhaumik.Joshi@sunpharma.com,Jigar.Gohil@sunpharma.com";
				ccMailId = "birendra.pandey@baseinformation.com,nikhil.sawalakhe@baseinformation.com,dhanendra.kasliwal@baseinformation.com";
				bccAddress = "";*/
					
				/*toMailId = "Julian.Soares@sunpharma.com,Bhaumik.Joshi@sunpharma.com,Jigar.Gohil@sunpharma.com";
				ccMailId = "dhanendra.kasliwal@baseinformation.com";
				bccAddress = "";*/
					
				System.out.println("Export Pdf path for PendingQCPurchaseOrder.getPDFByScheduler ="+pdfFileName);
				attachFile = new File(pdfFileName);	
				attachExcleFile = new File(excelFileName);
				attachManualQCExcleFile = new File(excelManualQCFileName);
				if(attachFile.exists() && attachFile.length()>0 && attachExcleFile.exists() && attachExcleFile.length()>0 && attachManualQCExcleFile.exists() && attachManualQCExcleFile.length()>0)
		        {
					mailInfo =new ArrayList<String>();
					mailInfo.add(toMailId);
					mailInfo.add(ccMailId);
					mailInfo.add(bccAddress);
					mailInfo.add(subject);
					mailInfo.add(userWiseBodytext);
					mailInfo.add(attachFile.getPath());
					mailInfo.add(attachExcleFile.getPath());
					mailInfo.add(attachManualQCExcleFile.getPath());
					this.sendingMail(mailInfo);
					resultFlage="true";
				}
				System.out.println("*sending  mail done succesfully for PendingQCPurchaseOrder.getPDFByScheduler*");
			} catch (Exception e)
			{
				System.out.println("Exception :PendingQCPurchaseOrder :getPDFByScheduler "+e.getMessage());
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in PendingQCPurchaseOrder.getPDFByScheduler" + d.getMessage());
					throw new ITMException(d);
				}
			}
			return 	resultFlage;
		 	 
	 }
	 
	public void sendingMail(ArrayList<String> mailInfo)
	 {
		    StringBuffer commInfo = new StringBuffer();
			commInfo.append("<ROOT>");
			commInfo.append("<MAILINFO>");
			commInfo.append("<EMAIL_TYPE>").append("page").append("</EMAIL_TYPE>");
			commInfo.append("<TO_ADD>").append("<![CDATA[" + mailInfo.get(0) + "]]>").append("</TO_ADD>");
			commInfo.append("<CC_ADD>").append("<![CDATA[" + mailInfo.get(1) + "]]>").append("</CC_ADD>");
			commInfo.append("<BCC_ADD>").append("<![CDATA[" + mailInfo.get(2) + "]]>").append("</BCC_ADD>");
			commInfo.append("<SUBJECT>").append("<![CDATA[" + mailInfo.get(3) + "]]>").append("</SUBJECT>");
			commInfo.append("<BODY_TEXT>").append("<![CDATA[" +  mailInfo.get(4) + "]]>").append("</BODY_TEXT>");
			commInfo.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" +  mailInfo.get(5)+";"+ mailInfo.get(6)+";"+ mailInfo.get(7)+ "]]>").append("</XML_DATA_FILE_PATH>");
			commInfo.append("</MAILINFO>");
			commInfo.append("</ROOT>");
			EMail email = new EMail();
			try
			{
			 System.out.println(" calling sendMail  method() for PendingQCPurchaseOrder.getPDFByScheduler");
			  email.sendMail(commInfo.toString(), "ITM", null);
			  System.out.println(" ********Email send succesfully for getPendingQCOrderPurchase.getPDFByScheduler ***********");
			} catch (Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception :PendingQCPurchaseOrder :sendMail(String ,String)" + e.getMessage());
			}
			email = null;
	}
	 /*End- this method add for generatePDF on 13Aug2015*/	
	 
	/*Add this method for generate Excel file on Date 21-09-15 by Nikhil*/
		
    public void getExcelGenerate(String city, String siteCode, String dataSourceName)throws RemoteException, ITMException 
	{
		System.out.println("in getExcelGenerate getPendingQCOrderPurchase city :"+city+"-----siteCode :"+siteCode);
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		String excelFileName = null;
		String exportPDFPath = "";
		String currDate="";
		SimpleDateFormat simpleDateFormat = null;
		Calendar calendar = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
			dashboardUtility = new DashboardUtility();
			calendar      = Calendar.getInstance();
			exportPDFPath      = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportPDF"+File.separator;
			currDate      = simpleDateFormat.format(calendar.getTime());
			excelFileName   = city+" ("+siteCode+")"+" Pending QC Against Purchase as on " +currDate;
			System.out.println("excelFileName in getPendingQCOrderPurchase :"+excelFileName);
			
			city = dashboardUtility.getCommaSeparated(city);
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			
			System.out.println("in getExcelGenerate after dashboardUtility city :"+city+"-----siteCode :"+siteCode);
			
			HSSFWorkbook wb = new HSSFWorkbook();
			HSSFSheet sheet = wb.createSheet("Excel Sheet");
			HSSFRow rowhead = sheet.createRow(0);
			  
			HSSFCellStyle cellStyleLeft=wb.createCellStyle() ;
			cellStyleLeft.setAlignment(HSSFCellStyle.ALIGN_LEFT);
			 
			HSSFCellStyle cellStyleRight=wb.createCellStyle() ;
			cellStyleRight.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
						 
			HSSFFont font=wb.createFont();
			font.setFontName("Calibri");
			font.setFontHeightInPoints((short)10);
			   
			cellStyleLeft.setFont(font);
			cellStyleRight.setFont(font);
			
			sql = "SELECT A.SITE_CODE, A.TRAN_ID AS GIM_NO, to_char(A.TRAN_DATE,'dd/mm/yy') AS GIM_DATE, " +
					"A.TRAN_SER, TRUNC(SYSDATE)-TRUNC(A.TRAN_DATE) AS DAYS, A.SUPP_CODE, " +
					"D.SUPP_NAME, A.ITEM_SER, B.PURC_ORDER, B.ITEM_CODE AS ITEM_CODE," +
					" C.DESCR AS ITEM_DESCR, B.UNIT, sum(B.QUANTITY) as QTY," +
					" B.ACCT_CODE__DR, B.CCTR_CODE__dr, B.ACCT_CODE__CR, " +
					"sum(b.quantity*b.rate*A.EXCH_RATE) as AMT, B.LOT_NO, " +
					"G.STATUS , A.EXCH_RATE, b.RATE, A.CURR_CODE ,to_char(G.MFG_DATE,'dd/mm/yy') AS MFG_DATE, to_char(G.EXPIRY_DATE,'dd/mm/yy') AS EXPIRY_DATE " +
					" FROM PORCP A, PORCPDET B,ITEM C,SUPPLIER D,QC_ORDER G," +
					"SITE H WHERE " +
					"A.SITE_CODE IN ("+siteCode+") " +
					"AND " +
					"A.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
					"AND " +
					"A.CONFIRMED='Y' AND G.STATUS='U' AND G.QC_CREATE_TYPE='A' AND A.TRAN_ID=B.TRAN_ID " +
					"AND B.ITEM_CODE=C.ITEM_CODE AND A.SUPP_CODE=D.SUPP_CODE " +
					"AND G.LOT_NO=B.LOT_NO and g.PORCP_NO=A.TRAN_ID " +
					"AND G.ITEM_CODE=B.ITEM_CODE AND A.SITE_CODE=H.SITE_CODE " +
					"AND H.CITY in("+city+") " +
					"group by A.SITE_CODE,A.TRAN_ID, " +
					"A.TRAN_DATE, B.ITEM_CODE, C.DESCR, B.UNIT, B.LOt_no, " +
					"A.SUPP_CODE, D.SUPP_NAME, B.PURC_ORDER, G.STATUS, " +
					"A.ITEM_SER, B.ACCT_CODE__DR, B.CCTR_CODE__dr, B.ACCT_CODE__CR," +
					"A.EXCH_RATE, A.CURR_CODE,A.TRAN_SER,b.rate,g.mfg_date,g.expiry_date ORDER BY A.TRAN_DATE ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			ResultSetMetaData rsmtdt= rs.getMetaData();
			int columncount=rsmtdt.getColumnCount();
			
			int index = 0;
			boolean flag=true;
			HSSFRow row=null;
			
			while(rs.next())
			{
				//System.out.println("index :"+index);
				row = sheet.createRow(index);
				if(flag)
				{
					for(int i=1;i<=columncount;i++)
					{
					    createCell(wb, rowhead, i-1,cellStyleLeft, rsmtdt.getColumnLabel(i), "String");
					}
					flag=false;
					index++;
					row = sheet.createRow(index);
				}
				createCell(wb,row, 0,cellStyleLeft,checkNull(rs.getString(1)).trim(),"String"); //SITE_CODE
				createCell(wb,row, 1,cellStyleLeft,checkNull(rs.getString(2)).trim(),"String"); //GIM_NO
				createCell(wb,row, 2,cellStyleLeft,checkNull(rs.getString(3)).trim(),"String"); //GIM_DATE
				
				createCell(wb,row, 3,cellStyleLeft,checkNull(rs.getString(4)).trim(),"String"); //TRAN_SER
				createCell(wb,row, 4,cellStyleRight,checkZero(rs.getString(5)).trim(),"String"); //DAYS
				createCell(wb,row, 5,cellStyleLeft,checkNull(rs.getString(6)).trim(),"String"); //SUPP_CODE
				
				createCell(wb,row, 6,cellStyleLeft,checkNull(rs.getString(7)).trim(),"String"); //SUPP_NAME
				createCell(wb,row, 7,cellStyleLeft,checkNull(rs.getString(8)).trim(),"String"); //ITEM_SER
				createCell(wb,row, 8,cellStyleLeft,checkNull(rs.getString(9)).trim(),"String"); //PURC_ORDER
				
				createCell(wb,row, 9,cellStyleLeft,checkNull(rs.getString(10)).trim(),"String"); //ITEM_CODE
				createCell(wb,row, 10,cellStyleLeft,checkNull(rs.getString(11)).trim(),"String"); //ITEM_DESCR
				createCell(wb,row, 11,cellStyleLeft,checkNull(rs.getString(12)).trim(),"String"); //UNIT
				
				createCell(wb,row, 12,cellStyleRight,checkZero(rs.getString(13)).trim(),"Number"); //QTY
				createCell(wb,row, 13,cellStyleLeft,checkNull(rs.getString(14)).trim(),"String"); //ACCT_CODE__DR
				createCell(wb,row, 14,cellStyleLeft,checkNull(rs.getString(15)).trim(),"String"); //CCTR_CODE__dr
				
				createCell(wb,row, 15,cellStyleLeft,checkNull(rs.getString(16)).trim(),"String"); //ACCT_CODE__CR
				createCell(wb,row, 16,cellStyleRight,checkZero(rs.getString(17)).trim(),"Number"); //AMT
				createCell(wb,row, 17,cellStyleLeft,checkNull(rs.getString(18)).trim(),"String"); //LOT_NO
				
				createCell(wb,row, 18,cellStyleLeft,checkNull(rs.getString(19)).trim(),"String"); //STATUS
				createCell(wb,row, 19,cellStyleRight,checkZero(rs.getString(20)).trim(),"Number"); //EXCH_RATE
				createCell(wb,row, 20,cellStyleRight,checkZero(rs.getString(21)).trim(),"Number"); //RATE
				
				createCell(wb,row, 21,cellStyleLeft,checkNull(rs.getString(22)).trim(),"String"); //CURR_CODE
				createCell(wb,row, 22,cellStyleLeft,checkNull(rs.getString(23)).trim(),"String"); //MFG_DATE
				createCell(wb,row, 23,cellStyleLeft,checkNull(rs.getString(24)).trim(),"String"); //EXPIRY_DATE
					
				
	            index++;
			}
			
			excelFileName   = exportPDFPath+excelFileName+".xls";
			System.out.println("excelFileName in getExcelGenerate :"+excelFileName);
			FileOutputStream out = new FileOutputStream(excelFileName);
			wb.write(out);
			out.close();
			
		}catch (Exception e) 
		{
			System.out.println("Exception :PendingQCPurchaseOrder :getExcelGenerate(String city, String siteCode, String dataSourceName :"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PendingQCPurchaseOrder.getPDFByScheduler" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
	}
	@SuppressWarnings("deprecation")
	private void createCell(HSSFWorkbook wb, HSSFRow row, int column, HSSFCellStyle cellStyle, String data, String dataType)
	 {
	 	HSSFCell cell = null;
	 	if("String".equalsIgnoreCase(dataType))
	 	{
	 		cell = row.createCell((short) column, HSSFCell.CELL_TYPE_STRING);
	 		cell.setCellValue(data);
	 	}
	 	if("Number".equalsIgnoreCase(dataType))
	 	{
	 		cellStyle.setDataFormat((short)2);
	 		cell = row.createCell((short) column, HSSFCell.CELL_TYPE_NUMERIC);
	 		cell.setCellValue(Double.parseDouble(data));
	 	}
		cell.setCellStyle(cellStyle);		
	 }
	/*End this method for generate Excel file on Date 21-09-15 by Nikhil*/
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str ;
		}

	}
	private String checkZero(String str)
	{
		if(str == null || str.equals(null) || str.equalsIgnoreCase(""))
		{
			return "0";
		}
		else
		{
			return str ;
		}

	}
	
	/*Start Method add for PendingManualQCOrder Stack Chart by Dhanendra On 01-10-2015 */
	@SuppressWarnings("unchecked")
    public JSONObject getPendingManualQCOrder(String geoLocation, String siteCode, String dataSourceName) throws RemoteException, ITMException
    {
		
		System.out.println("In PendingQCOrder getPendingManualQCOrder geoLocation :"+geoLocation+"----siteCode :"+siteCode+"---dataSourceName :"+dataSourceName);
		JSONObject rowDataPendingManualQCOrder = null;
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			int count = 0;
			
			if(geoLocation.trim().length()>0 && geoLocation!=null && siteCode!=null && siteCode.trim().length()>0)
			{
				rowDataPendingManualQCOrder = new JSONObject();
				dashboardUtility = new DashboardUtility();
				siteCode = dashboardUtility.getCommaSeparated(siteCode);
				geoLocation = dashboardUtility.getCommaSeparated(geoLocation);
				
				sql=  " Select NO_OF_DAYS,ITEM_SER,NO_OF_OPEN_QCORDER,CHK_VAL, ROUND((VALUE)/100000,3) AS VALUE " +
						"FROM( SELECT z.no_of_days AS no_of_days, z.ITEM_SER AS ITEM_SER, SUM(z.NO_OF_OPEN_QCORDER) AS NO_OF_OPEN_QCORDER, " +
						"z.CHK_VAL AS CHK_VAL, sum(z.QUANTITY*Z.RATE) as VALUE " +
						"FROM (SELECT CASE WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)<90 THEN '>0-90 days' " +
						"WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)<180 THEN '>90-180 days' " +
						"WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>=180 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)<365 THEN '>180-365 days' " +
						"WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>365 THEN '>365 days' " +
						"WHEN TO_CHAR(A.QORDER_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  THEN  TO_CHAR(A.QORDER_DATE,'YYYY') END no_of_days, " +
						"C.ITEM_SER, COUNT(DISTINCT(A.QORDER_NO)) AS NO_OF_OPEN_QCORDER, (CASE WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 0 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)  < 90 THEN 1 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 90 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)  < 180 THEN 2 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 180 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)  < 365 THEN 3 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 365 THEN 4 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (A.QORDER_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) AS CHK_VAL, " +
						"A.quantity, MIN(b.rate) as RATE FROM QC_ORDER A,ITEM C,STOCK B,SITE H " +
						"WHERE A.STATUS='U' " +
						"AND A.SITE_CODE IN ("+siteCode+") " +
						"AND B.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
						"AND A.ITEM_CODE=C.ITEM_CODE " +
						"AND A.SITE_CODE=B.SITE_CODE " +
						"AND B.QUANTITY>0 AND B.INV_STAT in ('NOSL','REJ') AND A.ITEM_CODE=B.ITEM_CODE AND A.LOT_NO=A.LOT_NO " +
						"AND A.SITE_CODE=H.SITE_CODE AND A.QC_CREATE_TYPE='M' " +
						"AND H.CITY in ("+geoLocation+") " +
						"GROUP BY C.item_ser,A.QORDER_DATE,A.QUANTITY,A.QORDER_NO ) z " +
						"GROUP BY no_of_days,ITEM_SER,CHK_VAL ORDER BY z.ITEM_SER) " +
						"ORDER BY CHK_VAL ASC";
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				String noOfOpenQCOrderVal="";
				String qcValue="";
				String noOfDay="",subType="";
				List<String> noOfDayList= new ArrayList<String>();
				List<String> subTypeList= new ArrayList<String>();
				String key="";
				LinkedHashMap<String, String> graphDataMap = new LinkedHashMap<String, String>(); 
		   		LinkedHashMap<String, String> sortedGraphDataMap = new LinkedHashMap<String, String>(); 
				while (rs.next())
				{
					
					noOfOpenQCOrderVal = rs.getString("NO_OF_OPEN_QCORDER");
					noOfDay = rs.getString("NO_OF_DAYS");
					subType= rs.getString("ITEM_SER");
					qcValue=rs.getString("VALUE");
					
					if(!noOfDayList.contains(noOfDay))
					{
						noOfDayList.add(noOfDay);
					}
					if(!subTypeList.contains(subType))
					{
						subTypeList.add(subType);
					}
					key = (noOfDay.trim()+"@"+subType.trim());
				        if(graphDataMap.size()==0)
				        {
				        	graphDataMap.put(key, (noOfOpenQCOrderVal+"-"+qcValue));
				        }
				        if(graphDataMap !=null && graphDataMap.size()>0)
				        {
				        	if(graphDataMap.containsKey(key))
				        	{
				        		//wipValue = wipValue +  graphDataMap.get(key);
				        		noOfOpenQCOrderVal = graphDataMap.get(key);
				        	}
				        	else  if(! graphDataMap.containsKey(key))
				        	{
				        		noOfOpenQCOrderVal = noOfOpenQCOrderVal+"-"+qcValue;
				        	}
				        	graphDataMap.put(key, noOfOpenQCOrderVal);
				        }
					
				}
			
			System.out.println("graphDataMap: "+graphDataMap);
			String sbType="";
			String grpKey="";
			for(int itmCtr=0;itmCtr<subTypeList.size();itmCtr++)
				{
					sbType = subTypeList.get(itmCtr);
					for (Map.Entry<String, String> grpentry : graphDataMap.entrySet())
					{
						for(int dayCtr=0;dayCtr<noOfDayList.size();dayCtr++)
						{
							grpKey = (noOfDayList.get(dayCtr).trim()+"@"+sbType.trim());
							if(graphDataMap.containsKey(grpKey))
							{
								sortedGraphDataMap.put(grpKey, graphDataMap.get(grpKey));
							}
							if(!graphDataMap.containsKey(grpKey) )
							{
								sortedGraphDataMap.put(grpKey, "0-0");
							}
						}
					}
				}
			System.out.println("sortedGraphDataMap: "+sortedGraphDataMap);
			rowData = new JSONObject();
			String noDays="",qcOrd="";
			String subType1="",prvsubType1="";
			LinkedHashMap<String, String> catValues = new LinkedHashMap<String, String>();
			LinkedHashMap<String, String> catQCValues = new LinkedHashMap<String, String>();
			int cnt=0;
			for (Map.Entry<String, String> entry : sortedGraphDataMap.entrySet())
			{
					cnt++;
					String mapKey     = entry.getKey();
					String value  = entry.getValue();// need to split
					String[] temp;
					temp = mapKey.split("@");
					noDays = temp[0].trim();
					subType1 = temp[1].trim();
					
					String[] qcOrdArr;
					qcOrdArr = value.split("-");
					qcOrd = qcOrdArr[0].trim();
					
					
					if( subType1 != null && ("").equals(prvsubType1) && subType1.trim().length()>0)
					{
						catValues.put(noDays,qcOrd);	
						catQCValues.put(noDays,value);	
						rowData.put("month",cnt);
						rowData.put("product_category",subType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catQCValues);
					}
					else if(!("").equals(prvsubType1) && prvsubType1.equals(subType1))
					{
						catValues.put(noDays,qcOrd);
						catQCValues.put(noDays,value);	
					}
					else if(!("").equals(prvsubType1) && ! prvsubType1.equals(subType1))
					{
						rowData.put("month",cnt);
						rowData.put("product_category",prvsubType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catQCValues);
						rowDataPendingManualQCOrder.put(count, rowData);
						count++;
						rowData = new JSONObject();
						catValues = new LinkedHashMap<String, String>();
						catQCValues = new LinkedHashMap<String, String>();
						catQCValues.put(noDays,value);	
						catValues.put(noDays,qcOrd);
					}
					if(cnt==sortedGraphDataMap.size())
					{
						rowData.put("month",++cnt);
						rowData.put("product_category",subType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catQCValues);
						rowDataPendingManualQCOrder.put(count, rowData);
					}
					prvsubType1=subType1;
				}
				if(rowDataPendingManualQCOrder.isEmpty())
				{
					System.out.println("**** rowDataPendingManualQCOrder is Empty **** ");
					catValues.put(">0-90 days", "0");
					catValues.put(">90-180 days", "0");
					catValues.put(">180-365 days", "0");
					
					catQCValues.put(">0-90 days", "0-0");
					catQCValues.put(">90-180 days", "0-0");
					catQCValues.put(">180-365 days", "0-0");
					
					rowData = new JSONObject();
					rowData.put("month",cnt);
					rowData.put("product_category","RM1");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catQCValues);
					rowDataPendingManualQCOrder.put(count, rowData);
					
					rowData = new JSONObject();
					rowData.put("month",++cnt);
					rowData.put("product_category","BD");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catQCValues);
					rowDataPendingManualQCOrder.put(++count, rowData);
					
					rowData = new JSONObject();
					rowData.put("month",++cnt);
					rowData.put("product_category","PM1");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catQCValues);
					rowDataPendingManualQCOrder.put(++count, rowData);
					
					rowData = new JSONObject();
					rowData.put("month",++cnt);
					rowData.put("product_category","BDI");
					rowData.put("category_value",catValues);
					rowData.put("category_gimvalue",catQCValues);
					rowDataPendingManualQCOrder.put(++count, rowData);
				}
			}	
			System.out.println("rowDataPendingManualQCOrder :"+rowDataPendingManualQCOrder);

		}
            catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :PendingQCPurchaseOrder : getPendingManualQCOrder():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingManualQCOrder;
	}
	/*End Method add for PendingManualQCOrder Stack Chart by Dhanendra On 01-10-2015 */

	
	
	/*Start Method add for PendingManualQCOrder Stack Chart by Dhanendra On 01-10-2015 */
	@SuppressWarnings("unchecked")
    public JSONObject getPendingManualQCOrderGrid(String geoLocation, String siteCode, String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rowDataPendingManualQCOrderGrid = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			System.out.println(" Inside getPendingQCOrderPurchase for getPendingManualQCOrderGrid Data Soruc Name ="+dataSourceName);
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			int count = 0;
			dashboardUtility = new DashboardUtility();
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			geoLocation = dashboardUtility.getCommaSeparated(geoLocation);
			System.out.println("geoLocation in getPendingManualQCOrderGrid :"+geoLocation);
			if(geoLocation.trim().length()>0 && geoLocation!=null && siteCode!=null && siteCode.trim().length()>0)
			{
			
			
				sql=  " Select NO_OF_DAYS,ITEM_SER,NO_OF_OPEN_QCORDER,CHK_VAL,ROUND((VALUE)/100000,3) AS VALUE " +
						"FROM( SELECT z.no_of_days AS no_of_days, z.ITEM_SER AS ITEM_SER, SUM(z.NO_OF_OPEN_QCORDER) AS NO_OF_OPEN_QCORDER, " +
						"z.CHK_VAL AS CHK_VAL, sum(z.QUANTITY*Z.RATE) as VALUE " +
						"FROM (SELECT CASE WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)<90 THEN '>0-90 days' " +
						"WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)<180 THEN '>90-180 days' " +
						"WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>=180 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)<365 THEN '>180-365 days' " +
						"WHEN  TO_CHAR(A.QORDER_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)>365 THEN '>365 days' " +
						"WHEN TO_CHAR(A.QORDER_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  THEN  TO_CHAR(A.QORDER_DATE,'YYYY') END no_of_days, " +
						"C.ITEM_SER, COUNT(DISTINCT(A.QORDER_NO)) AS NO_OF_OPEN_QCORDER, (CASE WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 0 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)  < 90 THEN 1 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 90 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)  < 180 THEN 2 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 180 AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE)  < 365 THEN 3 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') AND TRUNC (TRUNC (SYSDATE) - A.QORDER_DATE) >= 365 THEN 4 " +
						"WHEN TO_CHAR (A.QORDER_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (A.QORDER_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) AS CHK_VAL, " +
						"A.quantity, MIN(b.rate) as RATE FROM QC_ORDER A,ITEM C,STOCK B,SITE H " +
						"WHERE A.STATUS='U' " +
						"AND A.SITE_CODE IN ("+siteCode+") " +
						"AND B.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
						"AND A.ITEM_CODE=C.ITEM_CODE " +
						"AND A.SITE_CODE=B.SITE_CODE " +
						"AND B.QUANTITY>0 AND B.INV_STAT in ('NOSL','REJ') AND A.ITEM_CODE=B.ITEM_CODE AND A.LOT_NO=A.LOT_NO " +
						"AND A.SITE_CODE=H.SITE_CODE AND A.QC_CREATE_TYPE='M' " +
						"AND H.CITY in ("+geoLocation+") " +
						"GROUP BY C.item_ser,A.QORDER_DATE,A.QUANTITY,A.QORDER_NO ) z " +
						"GROUP BY no_of_days,ITEM_SER,CHK_VAL ORDER BY z.ITEM_SER) " +
						"ORDER BY CHK_VAL ASC";
				
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					rowData = new JSONObject();
					
					rowData.put("no_of_days", rs.getString("NO_OF_DAYS"));		
					rowData.put("item_ser", rs.getString("ITEM_SER"));
					rowData.put("no_of_open_qcorder", rs.getString("NO_OF_OPEN_QCORDER"));
					rowData.put("value", rs.getString("VALUE"));
					rowDataPendingManualQCOrderGrid.put(count, rowData);
					count++;
				}
			}
			System.out.println("rowDataPendingManualQCOrderGrid :"+rowDataPendingManualQCOrderGrid);
				    
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PendingQCPurchaseOrder : getPendingManualQCOrderGrid:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataPendingManualQCOrderGrid;
    }
	/*End Method add for PendingManualQCOrder Stack Chart by Dhanendra On 01-10-2015 */
	
	public void getPendingManualQCExcelGenerate(String city, String siteCode, String dataSourceName)throws RemoteException, ITMException 
	{
		System.out.println("in getPendingManualQCExcelGenerate getPendingQCOrderPurchase city :"+city+"-----siteCode :"+siteCode);
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		String excelFileName = null;
		String exportPDFPath = "";
		String currDate="";
		SimpleDateFormat simpleDateFormat = null;
		Calendar calendar = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
			dashboardUtility = new DashboardUtility();
			calendar      = Calendar.getInstance();
			exportPDFPath      = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportPDF"+File.separator;
			currDate      = simpleDateFormat.format(calendar.getTime());
			excelFileName   = city+" ("+siteCode+")"+" Pending Manual QC as on " +currDate;
			System.out.println("excelFileName in getPendingManualQCExcelGenerate :"+excelFileName);
			
			city = dashboardUtility.getCommaSeparated(city);
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			
			System.out.println("in getPendingManualQCExcelGenerate after dashboardUtility city :"+city+"-----siteCode :"+siteCode);
			
			HSSFWorkbook wb = new HSSFWorkbook();
			HSSFSheet sheet = wb.createSheet("Excel Sheet");
			HSSFRow rowhead = sheet.createRow(0);
			  
			HSSFCellStyle cellStyleLeft=wb.createCellStyle() ;
			cellStyleLeft.setAlignment(HSSFCellStyle.ALIGN_LEFT);
			 
			HSSFCellStyle cellStyleRight=wb.createCellStyle() ;
			cellStyleRight.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
						 
			HSSFFont font=wb.createFont();
			font.setFontName("Calibri");
			font.setFontHeightInPoints((short)10);
			   
			cellStyleLeft.setFont(font);
			cellStyleRight.setFont(font);
			
			/*sql = " SELECT to_char(A.QORDER_DATE,'dd/mm/yy') AS QORDER_DATE, A.QORDER_NO, A.SITE_CODE, TRUNC(SYSDATE)-TRUNC(A.QORDER_DATE) AS DAYS, " +
					"C.ITEM_SER, B.ITEM_CODE AS ITEM_CODE, C.DESCR AS ITEM_DESCR, A.LOT_NO, A.UNIT, A.QUANTITY as QTY ," +
					"MIN(B.RATE) AS RATE, (A.QUANTITY*MIN(RATE)) AS VALUE " +
					"FROM QC_ORDER A, ITEM C, STOCK B ,SITE H " +
					"WHERE A.STATUS='U' " +
					"AND A.SITE_CODE IN ("+siteCode+") " +
					"AND B.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
					"AND A.ITEM_CODE=C.ITEM_CODE AND A.SITE_CODE=B.SITE_CODE AND B.QUANTITY>0 " +
					"AND B.INV_STAT='NOSL' AND A.ITEM_CODE=B.ITEM_CODE AND A.LOT_NO=A.LOT_NO AND A.SITE_CODE=H.SITE_CODE AND A.QC_CREATE_TYPE='M' " +
					"AND H.CITY in("+city+") " +
					"group by A.SITE_CODE, C.ITEM_SER, B.ITEM_CODE, C.DESCR , A.UNIT, A.QORDER_DATE, A.QUANTITY,A.LOT_NO,A.QORDER_NO";*/
			
			sql= "SELECT to_char(A.QORDER_DATE,'dd/mm/yy') AS QORDER_DATE, A.QORDER_NO, A.SITE_CODE, MIN(B.SUPP_CODE__MFG) AS SUPP_MFG_CODE, " +
					"DDF_GET_MULTI_SUPP_NAME_CITY(MIN(B.SUPP_CODE__MFG),'S') AS SUPP_NAME, TRUNC(SYSDATE)-TRUNC(A.QORDER_DATE) AS DAYS, " +
					"C.ITEM_SER, B.ITEM_CODE AS ITEM_CODE, C.DESCR AS ITEM_DESCR, A.LOT_NO, A.UNIT, A.QUANTITY as QTY ," +
					"MIN(B.RATE) AS RATE, (A.QUANTITY*MIN(RATE)) AS VALUE, to_char(A.MFG_DATE,'dd/mm/yy') AS MFG_DATE, to_char(A.EXPIRY_DATE,'dd/mm/yy') AS EXPIRY_DATE " +
					"FROM QC_ORDER A, ITEM C, STOCK B,SITE H " +
					"WHERE A.SITE_CODE IN ("+siteCode+") " +
					"AND B.ITEM_SER IN ('RM1','BD','PM1','BDI') " +
					"AND A.STATUS='U' AND A.ITEM_CODE=C.ITEM_CODE " +
					"AND A.SITE_CODE=B.SITE_CODE AND B.QUANTITY>0 " +
					"AND B.INV_STAT in ('NOSL','REJ') AND A.ITEM_CODE=B.ITEM_CODE AND A.LOT_NO=A.LOT_NO AND A.SITE_CODE=H.SITE_CODE " +
					"AND A.QC_CREATE_TYPE='M' " +
					"AND H.CITY in ("+city+") " +
					"group by A.SITE_CODE, C.ITEM_SER, B.ITEM_CODE, C.DESCR , A.UNIT, A.QORDER_DATE, A.QUANTITY," +
					"A.LOT_NO,A.QORDER_NO ,A.MFG_DATE,A.EXPIRY_DATE ORDER BY A.QORDER_DATE";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			ResultSetMetaData rsmtdt= rs.getMetaData();
			int columncount=rsmtdt.getColumnCount();
			
			int index = 0;
			boolean flag=true;
			HSSFRow row=null;
			
			while(rs.next())
			{
				//System.out.println("index :"+index);
				row = sheet.createRow(index);
				if(flag)
				{
					for(int i=1;i<=columncount;i++)
					{
					    createCell(wb, rowhead, i-1,cellStyleLeft, rsmtdt.getColumnLabel(i), "String");
					}
					flag=false;
					index++;
					row = sheet.createRow(index);
				}
				
				createCell(wb,row, 0,cellStyleLeft,checkNull(rs.getString(1)).trim(),"String"); //QORDER_DATE
				createCell(wb,row, 1,cellStyleLeft,checkNull(rs.getString(2)).trim(),"String"); //QORDER_NO
				createCell(wb,row, 2,cellStyleLeft,checkNull(rs.getString(3)).trim(),"String"); //SITE_CODE
				
				createCell(wb,row, 3,cellStyleLeft,checkNull(rs.getString(4)).trim(),"String"); //SUPP_MFG_CODE
				createCell(wb,row, 4,cellStyleLeft,checkNull(rs.getString(5)).trim(),"String"); //SUPP_NAME
				createCell(wb,row, 5,cellStyleRight,checkZero(rs.getString(6)).trim(),"String"); //DAYS
				
				createCell(wb,row, 6,cellStyleLeft,checkNull(rs.getString(7)).trim(),"String"); //ITEM_SER
				createCell(wb,row, 7,cellStyleLeft,checkNull(rs.getString(8)).trim(),"String"); //ITEM_CODE
				createCell(wb,row, 8,cellStyleLeft,checkNull(rs.getString(9)).trim(),"String"); //ITEM_DESCR
				
				createCell(wb,row, 9,cellStyleLeft,checkNull(rs.getString(10)).trim(),"String"); //LOT_NO
				createCell(wb,row, 10,cellStyleLeft,checkNull(rs.getString(11)).trim(),"String"); //UNIT
				createCell(wb,row, 11,cellStyleRight,checkZero(rs.getString(12)).trim(),"Number"); //QTY
				
				createCell(wb,row, 12,cellStyleRight,checkZero(rs.getString(13)).trim(),"Number"); //RATE
				createCell(wb,row, 13,cellStyleRight,checkZero(rs.getString(14)).trim(),"Number"); //VALUE
				createCell(wb,row, 14,cellStyleLeft,checkNull(rs.getString(15)).trim(),"String"); //MFG_DATE
				
				createCell(wb,row, 15,cellStyleLeft,checkNull(rs.getString(16)).trim(),"String"); //EXPIRY_DATE
				
				index++;
			}
			
			excelFileName   = exportPDFPath+excelFileName+".xls";
			System.out.println("excelFileName in getExcelGenerate :"+excelFileName);
			FileOutputStream out = new FileOutputStream(excelFileName);
			wb.write(out);
			out.close();
			
		}catch (Exception e) 
		{
			System.out.println("Exception :PendingQCPurchaseOrder :getExcelGenerate(String city, String siteCode, String dataSourceName :"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PendingQCPurchaseOrder.getPendingManualQCExcelGenerate" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
	}
}
