package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNRA;

public class CDNRASerializer extends JsonSerializer<CDNRA>
{
	final SimpleDateFormat gstFmt = new SimpleDateFormat("dd-MM-yyyy");
	@Override
	public void serialize(CDNRA cdnra, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		json.writeStringField("ctin", cdnra.ctin);
		
		json.writeFieldName("nt");
        json.writeStartArray();

        for(CDNDetails cdnDetails : cdnra.cdnDetails)
        {
        	writeCDNDetails(cdnra, json, cdnDetails);
        }
        
        json.writeEndArray();
        
        json.writeEndObject();
	}
	
	private void writeCDNDetails(CDNRA cdnra, JsonGenerator json, CDNDetails cdnDetails)
	{
		try
		{
			json.writeStartObject();
			
			json.writeStringField("ntty", cdnDetails.cdnNoteType);
			json.writeStringField("nt_num", cdnDetails.cdNoteNumber);
			json.writeStringField("nt_dt", gstFmt.format(cdnDetails.cdNoteDate));
			json.writeStringField("rsn", cdnDetails.reason);
			
			if(cdnDetails.orgCDNoteNumber != null && cdnDetails.orgCDNoteDate != null)
			{
				json.writeStringField("ont_num", cdnDetails.orgCDNoteNumber);
				json.writeStringField("ont_dt", gstFmt.format(cdnDetails.orgCDNoteDate));
			}
			json.writeStringField("inum", cdnDetails.invoiceNumber);
			json.writeStringField("idt", gstFmt.format(cdnDetails.invoiceDate));
			
			if(cdnra.isReverseCharge)
			{
				json.writeStringField("rchrg", cdnDetails.rchrg ? "Y" : "N");
			}
			
			json.writeNumberField("val", cdnDetails.val);

            json.writeNumberField("irt", cdnDetails.irt);
            json.writeNumberField("iamt", cdnDetails.iamt);
            
        	json.writeNumberField("crt", cdnDetails.crt);
        	json.writeNumberField("camt", cdnDetails.camt);
        	
        	json.writeNumberField("srt", cdnDetails.srt);
        	json.writeNumberField("samt", cdnDetails.samt);
            
            json.writeNumberField("csrt", cdnDetails.csrt);
            json.writeNumberField("csamt", cdnDetails.csamt);
            
            if(cdnDetails.etin!=null)
            {
            	json.writeStringField("etin", cdnDetails.etin);
            }
            
			json.writeEndObject();
		}
		catch(Exception e)
		{
			System.out.println("CDNRASerializer.writecdnDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}

}
