package ibase.webitm.ejb.mfg;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMWizardStatefulRemote;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
import java.io.File;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;

public class ReqMRPItemcodeSetBean

{
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	ITMWizardStatefulRemote itmWizardRemote = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public String getItemCodeList( String itemCode,String search ,String dbID,String siteCode) throws ITMException
	{
		String itemCodeData = "";
		RequirementICRemote requirementICRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			requirementICRemote = (ibase.webitm.ejb.mfg.RequirementICRemote)ctx.lookup("ibase/RequirementIC/remote");
			itemCodeData = requirementICRemote.getItemCodeList( itemCode ,search,dbID,siteCode);
			requirementICRemote = null;
			System.out.println("itemCodeData=="+itemCodeData);
			
			String xslFileName = getXSLFileName( "requirement_item_code_set_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//String xslFileName = getXSLFileName( "requirement_item_code_wiz_en_US.xsl" );
			//itemCodeData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, itemCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			itemCodeData = ( new  E12GenericUtility() ).transformToString( xslFileName, itemCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			
			System.out.println("itemCodeData===>"+itemCodeData);
		}
		catch ( Exception e  )
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( requirementICRemote != null )
			{
				requirementICRemote = null;
			}						
		}
		return itemCodeData;
	}
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

}
