/**
 * VALLABH KADAM
 * PurcVchrMultiAttachmentBean.java
 * [F15ESUN001]
 * */

package ibase.webitm.ejb.fin;

import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.DocumentHandlerRemote;
import ibase.webitm.ejb.DocumentHandlerWrapperRemote;
import ibase.webitm.utility.ITMException;
import ibase.system.config.ConnDriver;
import ibase.system.config.AppConnectParm;

import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import ibase.utility.CommonConstants;

import org.apache.commons.io.IOUtils;

public class PurcVchrMultiAttachmentBean
{
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private ServletContext servletContext = null;
	private HttpServletRequest request = null;
	private String objName = "";
	private String user_lang = "en";
	private String user_country = "US";
	private String userId = "";
	private String sessionId = "";
	private Map<String, ArrayList<String>> mapListUnAlloc = new HashMap<String, ArrayList<String>>();
	private Map<String, ArrayList<String>> inProcessMapList = new HashMap<String, ArrayList<String>>();
	private String inProcessDocIds = "";
	private HttpSession session = null;

	E12GenericUtility genericUtility = new E12GenericUtility();

	public PurcVchrMultiAttachmentBean()
	{

	}

	public PurcVchrMultiAttachmentBean(HttpSession sessionCtx, String objName) throws ITMException
	{
		try
		{
			this.sessionCtx = sessionCtx;
			this.objName = objName;
			this.userInfo = (ibase.utility.UserInfoBean) this.sessionCtx.getAttribute("USER_INFO");
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
	}

	public PurcVchrMultiAttachmentBean(String objName, HttpSession session) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.session = session;
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
	}

	public PurcVchrMultiAttachmentBean(HttpSession sessionCtx, ServletContext servletContext, HttpServletRequest request, String objName) throws ITMException
	{
		try
		{
			this.sessionCtx = sessionCtx;
			this.servletContext = servletContext;
			this.request = request;
			this.objName = objName;

			this.userInfo = (ibase.utility.UserInfoBean) this.sessionCtx.getAttribute("USER_INFO");
			this.userId = userInfo.getLoginCode();
			this.sessionId = this.sessionCtx.getId();
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
	}

	/**
	 * Find voucher detail from table 'VOUCHER' and 'LC_VOUCHER'
	 * */
	public String getVoucherDetails(String tranId) throws ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		DecimalFormat decimalFormat = new DecimalFormat("#.00");
		StringBuffer valueXmlString = new StringBuffer();
		String vouch_det = "";
		int num = 0;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			String sql = "select v.tran_id as voucher_id,v.confirmed,l.tran_id as ref_id,l.purc_order,l.status,l.tran_date" 
			+" from VOUCHER v, LC_VOUCHER l where v.purc_order=l.purc_order and v.tran_id=? Order by v.purc_order";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);

			rs = pstmt.executeQuery();

			valueXmlString.append("<Root>\r\n");
			while (rs.next())
			{
				valueXmlString.append("<VOUCHER_DET domID='" + num + "'>\r\n");
				valueXmlString.append("<voucher_no><![CDATA[").append(rs.getString("voucher_id")).append("]]></voucher_no>\r\n");
				valueXmlString.append("<purc_order><![CDATA[").append(rs.getString("purc_order")).append("]]></purc_order>\r\n");
				valueXmlString.append("<confirmed><![CDATA[").append(rs.getString("confirmed")).append("]]></confirmed>\r\n");
				valueXmlString.append("<ref_id><![CDATA[").append(rs.getString("ref_id")).append("]]></ref_id>\r\n");
				
				if (rs.getString("status").equalsIgnoreCase("O"))
				{
					valueXmlString.append("<status><![CDATA[").append("Open").append("]]></status>\r\n");
				} else if (rs.getString("status").equalsIgnoreCase("C"))
				{
					valueXmlString.append("<status><![CDATA[").append("Close").append("]]></status>\r\n");
				}
				
				DateFormat sourceFormat = new SimpleDateFormat("dd/MM/yyyy");
				SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd");
				String reformattedStr = sourceFormat.format(myFormat.parse(rs.getString("tran_date")));
				System.out.println("@V@ Date in dd/MM/yyyy :-["+reformattedStr+"]");
//				valueXmlString.append("<tran_date><![CDATA[").append(rs.getString("tran_date")).append("]]></tran_date>\r\n");
				valueXmlString.append("<tran_date><![CDATA[").append(reformattedStr).append("]]></tran_date>\r\n");
				valueXmlString.append("</VOUCHER_DET>\r\n");
				num++;
			}
			valueXmlString.append("</Root>\r\n");

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			conn.close();

		} catch (SQLException sqe)
		{
			sqe.printStackTrace();
			throw new ITMException(sqe);
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				conn.close();
				if (pstmt != null)
				{
					pstmt.close();
				}
			} catch (SQLException e)
			{
				throw new ITMException(e);
			}
		}
		try
		{
			String xslFileName = getXSLFileName("BankGuranteeDetails.xsl");

			vouch_det = genericUtility.transformToString(xslFileName, valueXmlString.toString(), CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html");
		} catch (ITMException e)
		{
			throw new ITMException(e);
		}

		return vouch_det;
	}

	/**
	 * get XSL filename
	 * 
	 * @param xslFileName
	 * @return
	 * @throws ITMException
	 */
	private String getXSLFileName(String xslFileName) throws ITMException
	{
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if (CommonConstants.APPLICATION_CONTEXT != null)
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			} else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File(defaultPath + File.separator + "xsl" + File.separator + CommonConstants.THEME);
			if (!xslPath.exists())
			{
				xslPath.mkdir();
			}
			System.out.println(" xslPath [" + xslPath + "] xslFileName [" + xslFileName + "]");
			File xslFile = new File(xslPath, xslFileName);
			if (xslFile.exists())
			{
				retFileName = xslFile.getAbsolutePath();
			} else
			{
				throw new ITMException(new Exception(retFileName + " Wizard XSL file Not Found"));
			}
		} catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	/**
	 * get refId for view attachment
	 * @param refNo
	 * @return
	 * @throws ITMException
	 */
	public String getDocument(String refNo) throws ITMException
	{
		String refId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		System.out.println("@V@ in getDocument(refNo)");

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			String sql = "select tran_id from lc_voucher where tran_id=?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refNo);

			rs = pstmt.executeQuery();
			while (rs.next())
			{
				refId += rs.getString(1) + ",";
			}
			rs.close();
			pstmt.close();
			if (refId.trim().length() > 1)
			{
				refId = refId.substring(0, refId.trim().length() - 1);
			}
			System.out.println("TRAN_ID : [" + refId + "]");
		} catch (SQLException e)
		{
			throw new ITMException(e);
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				conn.close();
			} catch (SQLException e)
			{
				throw new ITMException(e);
			}
		}

		return refId;
	}

	/**
	 * get Attachment details
	 * 
	 * @param refId
	 * @return
	 * @throws ITMException
	 */
	public String getAttachmentDetails(String objName, String refId) throws ITMException
	{
		String retStr = "", refSer = "", xmlData = "";
		String refCol = null;
		try
		{
			InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());

			DBAccessRemote dbAccess = (DBAccessRemote) ctx.lookup("ibase/DBAccessEJB/remote");
			refSer = dbAccess.getRefSer(null, objName);

			DocumentHandlerRemote docHandler = (DocumentHandlerRemote) ctx.lookup("ibase/DocumentHandlerEJB/remote");
			if (refId != null && refId.indexOf(",") != -1)
			{
				try
				{
					DocumentHandlerWrapperRemote docWrapperHandler = (DocumentHandlerWrapperRemote) ctx.lookup("ibase/DocumentHandlerWrapperEJB/remote");
					System.out.println("@V@ In PurcVchrMultiAttachmentBean docWrapperHandler[" + docWrapperHandler + "]");
					xmlData = docWrapperHandler.getMultiDocumentInfoList(refSer, refId, refCol);
				} catch (Exception e)
				{
					System.out.println("Exception In PurcVchrMultiAttachmentBean getMultiDocumentInfoList : " + e.getMessage());
					e.printStackTrace();
				}

			} else
			{
				xmlData = docHandler.getDocumentInfoList(refSer, refId, refCol);
			}
		} catch (NamingException e)
		{
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		} catch (Exception e)
		{
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		}

		try
		{
			String xslFileName = getXSLFileName("MultiAttachmentsView.xsl");

			retStr = genericUtility.transformToString(xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html");
		} catch (ITMException e)
		{
			retStr = e.getMessage();
			throw new ITMException(e);
		}

		return retStr;
	}

	/**
	 * checking rights and delete attachment
	 * 
	 * @param docId
	 * @param refId
	 * @param objName
	 * @param refCol
	 * @return
	 * @throws ITMException
	 * @throws RemoteException
	 */
	public String removeAttachment(String docId, String refId, String objName, String refCol) throws ITMException, RemoteException
	{
		String retStr = "";
		try
		{
			String userLevel = this.userInfo.getUserLevel();
			String profileId = this.userInfo.getProfileId();
			String loginCode = this.userInfo.getLoginCode();
			if (profileId != null)
			{
				profileId = profileId.trim();
			}
			String pkValues = refId;
			System.out.println("pkValues==== " + pkValues);

			InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());

			DBAccessRemote dbAccess = (DBAccessRemote) ctx.lookup("ibase/DBAccessEJB/remote");
			DocumentHandlerRemote docHandler = (DocumentHandlerRemote) ctx.lookup("ibase/DocumentHandlerEJB/remote");

			if (pkValues != null && !pkValues.isEmpty())
			{
				String addedByUserId = docHandler.docAddedBy(docId);
				System.out.println("addedByUserId = [" + addedByUserId + "]");

				boolean isAuthorized = dbAccess.deleteAttachmentAuth(docId, userLevel, profileId, loginCode, objName, pkValues, addedByUserId);
				System.out.println("isAuthorized = [" + isAuthorized + "]");

				if (isAuthorized)
				{
					retStr = removeAttach(docId, refId, objName, refCol);
				} else
				{
					retStr = "User have not authorization to delete attachment";
				}
			} else
			{
				System.out.println("pkValues are null.");
				retStr = "pkValues are null.";
			}
		} catch (RemoteException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} catch (ITMException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} catch (NamingException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retStr = [" + retStr + "]");

		return retStr;
	}

	/**
	 * remove attachment from DOC_CONTENTS
	 * 
	 * @param docId
	 * @param refId
	 * @param objName
	 * @param refCol
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String removeAttach(String docId, String refId, String objName, String refCol) throws RemoteException, ITMException
	{
		String retString = "", refSer = ""; //$NON-NLS-1$
		Connection conn = null;
		PreparedStatement mPstmt = null;
		String selQry = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
			DBAccessRemote dbAccess = (DBAccessRemote) ctx.lookup("ibase/DBAccessEJB/remote");
			refSer = dbAccess.getRefSer(null, objName);

			System.out.println("refCol = [" + refCol + "]");
			if (refCol == null || "null".equalsIgnoreCase(refCol))
			{
				refCol = "";
			}

			selQry = "DELETE FROM DOC_CONTENTS WHERE DOC_ID ='" + docId + "'"; //$NON-NLS-1$ //$NON-NLS-2$
			System.out.println("Execute --- " + selQry);

			mPstmt = conn.prepareStatement(selQry);
			int deletedRow = mPstmt.executeUpdate();
			mPstmt.close();
			mPstmt = null;

			String refIds = refId;
			if (refId != null && refId.indexOf(",") != -1)
			{
				String[] refIDs = refId.split(",");
				refIds = "";
				for (int i = 0; i < refIDs.length; i++)
				{
					refIds += "'" + refIDs[i].trim() + "',";
				}
				if (refIds.trim().length() >= 2)
				{
					refIds = refIds.substring(1, refIds.trim().length() - 2);
				}
			}
			System.out.println("tranId [" + refIds + "]");
			if (refCol.length() == 0)
			{
				selQry = "DELETE FROM DOC_TRANSACTION_LINK WHERE DOC_ID ='" + docId + "' AND REF_ID IN ('" + refIds + "') AND REF_SER = '" + refSer + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			} else
			{
				selQry = "DELETE FROM DOC_TRANSACTION_LINK WHERE DOC_ID ='" + docId + "' AND REF_ID IN ('" + refIds + "') AND REF_SER = '" + refSer + "' AND REF_COL='" + refCol + "'"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}

			mPstmt = conn.prepareStatement(selQry);
			int deletedTranRow = mPstmt.executeUpdate();
			mPstmt.close();
			mPstmt = null;
			if (deletedRow == 1 && deletedTranRow == 1)
			{
				retString = "success";
				conn.commit();
			} else
			{
				retString = "Deleted Failure";
				conn.rollback();
			}
		} catch (SQLException ie)
		{
			System.out.println("SQLException :PurcVchrMultiAttachmentBean :removeAttach:==>" + ie); //$NON-NLS-1$
			retString = "Deleted Failure";
			ie.printStackTrace();
			throw new ITMException(ie);
		} catch (Exception e)
		{
			System.out.println("Exception :PurcVchrMultiAttachmentBean :removeAttach :==>" + e); //$NON-NLS-1$
			retString = "Deleted Failure";
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (mPstmt != null)
					{
						mPstmt.close();
						mPstmt = null;
					}
					conn.close();
					conn = null;
				}
			} catch (Exception e)
			{
				throw new ITMException(e);
			}
		}

		System.out.println("In PurcVchrMultiAttachmentBean : removeAttach :retString[" + retString + "]");

		return retString;
	}

	/**
	 * for view document from Payment Authorization screen
	 * 
	 * @param docId
	 * @param docName
	 * @return
	 */
	public String viewDocument(String docIds) throws Exception
	{
		String documentPath = "";
		String docName = "";
		String documentNames = "";
		System.out.println("docIds = [" + docIds + "]");
		try
		{
			DocumentHandlerRemote documentHandlerEJB = null;
			InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
			documentHandlerEJB = (DocumentHandlerRemote) ctx.lookup("ibase/DocumentHandlerEJB/remote");

			String[] documentIds = docIds.split(",");
			for (int i = 0; i < documentIds.length; i++)
			{
				String docId = documentIds[i];
				byte[] byteArray = documentHandlerEJB.getDocument(docId);

				docName = documentHandlerEJB.getDocumentName(docId);
				System.out.println("docId = [" + docId + "] docName = [" + docName + "]");
				documentNames += "," + docName;
				if (byteArray != null)
				{
					try
					{
						documentPath = CommonConstants.APPLICATION_CONTEXT + "PayAuthAttachments";
						File outFile = new File(documentPath);
						if (!outFile.exists())
						{
							outFile.mkdir();
						}
						if (!docName.equals(""))
						{
							outFile = new File(documentPath + File.separator + docName);
							FileOutputStream fout = new FileOutputStream(outFile);
							IOUtils.write(byteArray, fout);
							fout.close();
						} else
						{
							System.out.println("Document Name is empty.");
						}
					} catch (Exception e)
					{
						e.printStackTrace();
					}
				}
			}
			documentNames = documentNames.substring(1, documentNames.length());
			System.out.println("documentNames = [" + documentNames + "]");
		} catch (RemoteException e)
		{
			System.out.println("RemoteException: viewDocument : " + e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		} catch (ITMException e)
		{
			System.out.println("ITMException: viewDocument : " + e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		} catch (NamingException e)
		{
			System.out.println("NamingException: viewDocument : " + e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		} catch (Exception e)
		{
			System.out.println("Exception: viewDocument : " + e.getMessage());
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("documentPath = [" + (documentPath + File.separator + docName).toString() + "]");

		return documentNames;
	}
		
}
