package ibase.webitm.ejb.adm.adv;

import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3
import ibase.webitm.ejb.adm.AdmCommon;

@Stateless // added for ejb3

public class FullFinalUnConfirm extends ActionHandlerEJB implements FullFinalUnConfirmLocal,FullFinalUnConfirmRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}*/

    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{

		String  retString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			retString = actionUnConfirm(tranId, xtraParams, forcedFlag);
		}
		catch(Exception e)
		{
			System.out.println("Exception :FullFinalUnConfirm :actionHandler :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from FullFinalUnConfirm :actionHandler :"+retString);
		return retString;
	}

	private String actionUnConfirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String sql = "", empCodeAprove = "", loginEmpCode = "", errCode = "", errString = "", confirmed = "", updSql = "", empCode = "";
		double itaxAmt = 0d , totAmt = 0d;
		Connection conn = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement delPstmt = null;
		ResultSet rs = null;
		int updCnt = 0;
		java.sql.Date currDate = null;
		ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		GenericUtility genericUtility = GenericUtility.getInstance();
		AdmCommon admCommon = new AdmCommon();
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			stmt = conn.createStatement();
			System.out.println("Tran ID : "+ tranId);
			sql = "SELECT CONFIRMED, EMP_CODE, IT_AMT, TOTAL_AMT FROM FULLFINAL_HDR WHERE TRAN_ID = ?";
			System.out.println("sql :"+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1 , tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirmed = checkNull(rs.getString("CONFIRMED"));
				empCode = checkNull(rs.getString("EMP_CODE"));
				itaxAmt = rs.getDouble("IT_AMT");
				totAmt = rs.getDouble("TOTAL_AMT");
			}
			else
			{
				errCode = "VTFFSUNC01";
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (errCode.trim().length() == 0)
			{
				if (confirmed.equalsIgnoreCase("Y"))
				{
					errCode = "VTMUCONF1";
					conn.rollback();
				}
				else if (confirmed.equalsIgnoreCase("X"))
				{
					errCode = "VTFFSCANC2";
					conn.rollback();
				}
				else if (!confirmed.equalsIgnoreCase("F") && !confirmed.equalsIgnoreCase("X") && !confirmed.equalsIgnoreCase("I"))
				{
					errCode = "VTMUCONF2";
					conn.rollback();
				}
				else
				{
					if (confirmed.equalsIgnoreCase("I"))
					{
						updSql = "UPDATE FULLFINAL_HDR SET TOTAL_AMT = TOTAL_AMT - ?, IT_AMT = IT_AMT - ?, CONFIRMED = 'F' WHERE TRAN_ID = ?"; 
						pstmt = conn.prepareStatement(updSql);
						pstmt.setDouble(1 , itaxAmt);
						pstmt.setDouble(2 , itaxAmt);
						pstmt.setString(3 , tranId);
						updCnt = pstmt.executeUpdate();
						if (updCnt == 0)
						{
							errCode = "VTFFSUNC02";
							conn.rollback();
						}
						else
						{
							String f16DedList = checkNull(admCommon.getEnv("999999" , "F16_DED" , conn));
							if (f16DedList.equalsIgnoreCase("NULLFOUND"))
							{
								errCode = "VSENVAR1";
								conn.rollback();
							}
							else
							{
								String[] f16DednADList = f16DedList.split(",");
								if (f16DednADList.length > 0)
								{
									sql = "SELECT MAX(LINE_NO) AS LINE_NO FROM FULLFINAL_DET WHERE TRAN_ID = ? AND AD_CODE = ?";
									pstmt = conn.prepareStatement(sql);

									sql = "DELETE FROM FULLFINAL_DET WHERE TRAN_ID = ? AND LINE_NO = ?";
									delPstmt = conn.prepareStatement(sql);

									for (int i = 0; i < f16DednADList.length; i++)
									{
										pstmt.setString(1 , tranId);
										pstmt.setString(2 , f16DednADList[i]);
										rs = pstmt.executeQuery();
										if (rs.next())
										{
											int lineNo = rs.getInt("LINE_NO");
											delPstmt.setString(1 , tranId);
											delPstmt.setInt(2 , lineNo);
											updCnt = pstmt.executeUpdate();
											delPstmt.clearParameters();
										}
										if (rs != null)
										{
											rs.close();
											rs = null;
										}
										pstmt.clearParameters();
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if (delPstmt != null)
									{
										delPstmt.close();
										delPstmt = null;
									}
								}
							}
						}
					}
					sql = "UPDATE FULLFINAL_HDR SET CONFIRMED = 'N' WHERE TRAN_ID = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1 , tranId);
					updCnt = pstmt.executeUpdate();
					conn.commit();
					errCode = "";
				}
			}
			if (errCode == null || errCode.trim().length() == 0)
			{
				errCode = "VTMUCONF3";
			}
			errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
		}
		catch (SQLException sqx)
		{
			System.out.println("The sqlException occure in EmpAddChgCncEJB :"+sqx);
			throw new ITMException(sqx);
		}
		catch (Exception e)
		{
			System.out.println("The Exception occure in EmpAddChgCncEJB :"+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{	
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (delPstmt != null)
				{
					delPstmt.close();
					delPstmt = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception in finally: " + e);
			}
		}
		return errString;
	}

	private String checkNull(String input)
	{
		if (input == null) 
		{
			input = "";
		} 
		else
		{
			input = input.trim();
		}
		return input;
	}

}