package ibase.webitm.ejb.adm;

import ibase.utility.CommonConstants;
import java.sql.*;
import java.util.Calendar;
import java.text.SimpleDateFormat;
import ibase.webitm.utility.*;

// Modified By Hemlata on [11/11/2014] To update org_structure and org_struc_trace on postsave[Start]
import java.util.Date;
import java.text.SimpleDateFormat;
// Modified By Hemlata on [11/11/2014] To update org_structure and org_struc_trace on postsave[End]

/*
	Sudhir	 
*/ 

public class AdmCommon 
{
	public String getSiteEnv(String siteCode, String module, String levelType, String levelCode, String parName, Timestamp date, Connection conn) 
	{
		System.out.println("siteCode :"+siteCode+" module : "+module+" levelType  :"+levelType+"  levelCode  :"+levelCode+"  parName :"+parName+"  date :"+date );
		String parValue = "";
		String sql = "";
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT PAR_VALUE "   
				+ "FROM SITE_ENV "
				+ "WHERE SITE_CODE	= 	'" + siteCode + "' "
				+ "AND MODULE_CODE	= 	'" + module + "' "
				+ "AND LEVEL_TYPE	= 	'" + levelType + "' "
				+ "AND LEVEL_CODE	= 	'" + levelCode + "' "
				+ "AND PAR_NAME		= 	'" + parName + "' "
				+ "AND EFF_DATE		<=	? " 
				+ "AND UPTO_DATE	>=	? ";
			System.out.println(">>>>>>>>>>>..  sql in getSiteEnv  "+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, date);
			pstmt.setTimestamp(2, date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				parValue = rs.getString(1);
				pstmt.close();
				rs.close();
			}
			else if(levelType.equalsIgnoreCase("X") && !module.equalsIgnoreCase("ADM"))  
			{
				pstmt.close();
				rs.close();
				sql = "SELECT PAR_VALUE "  
					+ "FROM SITE_ENV "
					+ "WHERE SITE_CODE	= 	'99999' "
					+ "AND MODULE_CODE	= 	'" + module + "' "
					+ "AND LEVEL_TYPE	= 	'" + levelType + "' "
					+ "AND LEVEL_CODE	= 	'" + levelCode + "' "
					+ "AND PAR_NAME		= 	'" + parName + "' "
					+ "AND EFF_DATE		<=	? "
					+ "AND UPTO_DATE	>=	? ";
				System.out.println(">>>>>>>>>>>..  sql in getSiteEnv else  "+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, date);
				pstmt.setTimestamp(2, date);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					parValue = rs.getString(1);
				}
				else
				{
					parValue = "NULLFOUND";
				}
			}
			else
			{
				parValue = "NULLFOUND";
			}
			rs.close();
			pstmt.close();	
			if (parValue == null) parValue = "NULLFOUND"; //ADDED BY ALKA 25/07/07 TO AVOID NULLPOINTER EXCEPTION FROM WHERE THE METHOD IS CALLED.
		}
		catch (Exception e)
		{
//			System.out.println("Exception :ITMDBAccessEJB :getEvFin:" + e.getMessage() + ":"); //COMMENTED BY ALKA 24/07/07 AS WRONG METHOD NAME IS PRINTED IN THE SOP
			System.out.println("Exception :ITMDBAccessEJB :getSiteEnv:" + e.getMessage() + ":");
		}
//		System.out.println("Returning Value From getEnvFin() :: "+parValue);  //COMMENTED BY ALKA 24/07/07 AS WRONG METHOD NAME IS PRINTED IN THE SOP
		System.out.println("Returning Value From getSiteEnv() :: "+parValue);  
		return parValue;
	}
	public String getAdmEnv(String siteCode, String cadre, String grade, String envName, Timestamp date, Connection conn) 
	{
		String retValue = "";
		try
		{
			retValue = getSiteEnv(siteCode, "ADM", "G",  grade,  envName,  date,  conn);
			if(retValue.equals("NULLFOUND"))
			{
				retValue = getSiteEnv(siteCode, "ADM", "C",  cadre,  envName,  date,  conn);
				if(retValue.equals("NULLFOUND"))
				{
					retValue = getSiteEnv(siteCode, "ADM", "X", "ZZZZZ",  envName,  date,  conn);
					if(retValue.equals("NULLFOUND"))
					{
						// Modified by Piyush on 02/04/2015 [Site code should passed as "99999"].Start
						/*
						retValue = getSiteEnv(siteCode, "ADM", "G",  grade,  envName,  date,  conn);
						if(retValue.equals("NULLFOUND"))
						{
							retValue = getSiteEnv(siteCode, "ADM", "C",  cadre,  envName,  date,  conn);
							if(retValue.equals("NULLFOUND"))
							{
								retValue = getSiteEnv(siteCode, "ADM", "X", "ZZZZZ",  envName,  date,  conn);
							}
						}
						*/
						retValue = getSiteEnv("99999", "ADM", "G",  grade,  envName,  date,  conn);
						if(retValue.equals("NULLFOUND"))
						{
							retValue = getSiteEnv("99999", "ADM", "C",  cadre,  envName,  date,  conn);
							if(retValue.equals("NULLFOUND"))
							{
								retValue = getSiteEnv("99999", "ADM", "X", "ZZZZZ",  envName,  date,  conn);
							}
						}
						// Modified by Piyush on 02/04/2015 [Site code should passed as "99999"].End
					}
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :AdmCommon :getEnvFin:" + e.getMessage() + ":");
			e.printStackTrace();
		}
		System.out.println("Returning Value From getAdmEnv() :: "+retValue);  
		return retValue;
	}
	public String getEnv(String prdCode, String varName,Connection conn)
	{
		String retValue = "";
		String sql = "";
		Statement stmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT VAR_VALUE FROM PAYRPARM "  
			   	+ "WHERE PRD_CODE = '" + prdCode + "' AND VAR_NAME = '" + varName + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				retValue = rs.getString(1);
			}
			else
			{
				retValue = "NULLFOUND";
			}
			rs.close();
			stmt.close();
		}
		catch (SQLException se)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + se.getMessage() + ":");
			se.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("Exception :ITMDBAccessEJB :getEnvFin:" + e.getMessage() + ":");
			e.printStackTrace();
		}
	//	System.out.println("Returning Value From getEnvFin() :: "+retValue);  
		return retValue;
	}
	//Function empPrevRec(String empCode, String adCode, String effDate, Connection conn) added by Gulzar 15/01/07
	public boolean empPrevRec(String empCode, String adCode, String effDate, Connection conn) throws ITMException
	{
		boolean status = false;
		String updSql = "", relativeDate = "";
		int updCnt = 0;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		ResultSet rs = null;

		//	Modified By Hemlata on [15/09/2014] To Change Functionality as per ITM During migration in Rcp [Start]
		String expDate = "";
		String expDateSql = "";
		java.sql.Date minExpDate = null;
		//	Modified By Hemlata on [15/09/2014] To Change Functionality as per ITM During migration in Rcp [End]

		try
		{
			conn.setAutoCommit(false);
			GenericUtility genericUtility = GenericUtility.getInstance();
			relativeDate = getRelativeDate(effDate,-1);
			System.out.println("relativeDate...::" + relativeDate);

			//	Modified By Hemlata on [15/09/2014] To Change Functionality as per ITM During migration in Rcp [Start]

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			expDateSql="select min(exp_date) as min_expdate from employee_ad where emp_code = ? and ad_code = ? and eff_date = ? and exp_date <= ? ";
			pstmt = conn.prepareStatement(expDateSql);
			pstmt.setString(1,empCode);
			pstmt.setString(2,adCode);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(relativeDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				minExpDate = rs.getDate("min_expdate");
			}
			
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			System.out.println(" [minExpDate]........:: " + minExpDate);
			if(minExpDate != null)
			{
				expDate = sdf.format(minExpDate);
				relativeDate = getRelativeDate(expDate,-1);
				System.out.println(" [relativeDate]........:: " + relativeDate);
			}

			//	Modified By Hemlata on [15/09/2014] To Change Functionality as per ITM During migration in Rcp [End]
			updSql = "UPDATE EMPLOYEE_AD SET EXP_DATE = ? " +
					" WHERE EMP_CODE = '"+empCode+"' AND " +
					" AD_CODE = '"+adCode+"' AND " +
					" EFF_DATE <= ? AND " +
					" EXP_DATE >= ? ";
			System.out.println("Update sql In [empPrevRec][updSql][1]........:: " + updSql);
			pstmt = conn.prepareStatement(updSql);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(relativeDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			updCnt = pstmt.executeUpdate();
			// Modified by Piyush on 30/06/2015[To work same as ITM]
			// if(updCnt > 0)
			if(updCnt >= 0 && updCnt < 2)
			{
				status = true;
				System.out.println("Updated Into EMPLOYEE_AD Sucessfully......! [updCnt] :: "+ updCnt);
			}
			else
			{
				System.out.println("No Updation into EMPLOYEE_AD......! [updCnt] :: "+ updCnt);
			}
		}
		catch (SQLException se)
		{
			System.out.println("Exception :AdmCommon :empPrevRec:" + se.getMessage() + ":");
			se.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[AdmCommon][function::empPrevRec()] :==>\n"+e.getMessage());
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing pstmt In [empPrevRec()]...............");
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
			}
			catch(Exception ex){}
		}
		return status;
	}
	//Function payarrToProcUpdation() Added by Gulzar 16/010/07
	public String payarrToProcUpdation(String periodFrom, String periodTo, String empCodeFr, String empCodeTo, String procType, String winName, String keyStr, String adCode, double amount, String effDate, String expDate, String xtraParams, Connection conn) throws ITMException
	{
		String errCode = "", sqlStr = "", keyString = "", adBasic = "", startPeriod = "";
		String sqlEmp = "", sqlPrd = "", voucherNo = "", tranID = "", sqlIns = "";
		String currEmpCode = "", currPeriod = "", userId = "";
		int count = 0, count1 = 0;
		Statement stmt = null, stmtEmp = null, stmtPrd = null, stmt1 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null, rsEmp = null, rsPrd = null, rs1 = null;
		java.sql.Timestamp joinDate = null;

		// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration].Start
		String workSite ="";
		String empSite="";
		String paySite ="";
		// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration].End
		
		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			conn.setAutoCommit(false);
			stmt = conn.createStatement();
			adBasic = getEnv("999999", "BASIC", conn);
			if (adBasic.equals("NULLFOUND"))
			{
				errCode = "VSENVAR1";
				return errCode;
			}
			sqlStr = "SELECT KEY_STRING FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = 'T_PAYARR_TO_PROC'";
			System.out.println("sqlStr In [payarrToProcUpdation][sqlStr][1]........:: " + sqlStr);
			rs = stmt.executeQuery(sqlStr);
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
			}
			System.out.println("keyString.....:: " + keyString);
			rs.close();
			rs = null;
			if (periodTo == null)
			{
				periodTo = "";
			}
			startPeriod = getEnv("999999", "START_PRD", conn);
			if (startPeriod.equals("NULLFOUND"))
			{
				errCode = "VSENVAR1";
				return errCode;
			}
			sqlStr = "SELECT COUNT(*) AS COUNT FROM PERIOD WHERE CODE = '"+startPeriod+"'";
			System.out.println("sqlStr In [payarrToProcUpdation][sqlStr][2]........:: " + sqlStr);
			rs = stmt.executeQuery(sqlStr);
			if (rs.next())
			{
				count = rs.getInt("COUNT");
			}
			else
			{
				errCode = "STARTPRD";
				return errCode;
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;

			// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration. Added emp_site,pay_site,work_site]
			// sqlEmp = "SELECT EMP_CODE, DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE >= '"+empCodeFr+"' AND EMP_CODE <= '"+empCodeTo+"'";
			sqlEmp = "SELECT EMP_CODE, DATE_JOIN, EMP_SITE, WORK_SITE, PAY_SITE FROM EMPLOYEE WHERE EMP_CODE >= '"+empCodeFr+"' AND EMP_CODE <= '"+empCodeTo+"'";
			System.out.println("sqlEmp In [payarrToProcUpdation][sqlEmp][3]........:: " + sqlEmp);
			stmtEmp = conn.createStatement();
			rsEmp = stmtEmp.executeQuery(sqlEmp);
			while (rsEmp.next())
			{
				currEmpCode = rsEmp.getString("EMP_CODE");
				joinDate	= rsEmp.getTimestamp("DATE_JOIN");

				// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration. Added emp_site,pay_site,work_site].Start
				empSite  =   rsEmp.getString("EMP_SITE");
				workSite  =   rsEmp.getString("WORK_SITE");
				paySite  =    rsEmp.getString("PAY_SITE");
				// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration. Added emp_site,pay_site,work_site].End

				sqlPrd = "SELECT CODE FROM PERIOD WHERE CODE >= '"+periodFrom+"' AND CODE >= '"+startPeriod+"'";
				System.out.println("sqlPrd In [payarrToProcUpdation][sqlPrd][4]........:: " + sqlPrd);
				stmtPrd = conn.createStatement();
				rsPrd = stmtPrd.executeQuery(sqlPrd);
				while (rsPrd.next())
				{
					currPeriod = rsPrd.getString("CODE");
					if (periodTo != null && periodTo.trim().length() > 0 && Integer.parseInt(currPeriod) > Integer.parseInt(periodTo))
					{
						break;
					}
					voucherNo = "";

					// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration]
					// sqlStr = "SELECT VOUCHER_NO FROM PAYROLL WHERE PRD_CODE = '"+currPeriod+"' AND EMP_CODE = '"+currEmpCode+"' AND VOUCHER_NO <> 'PAYROLL'";
					sqlStr = "SELECT VOUCHER_NO FROM PAYROLL WHERE PRD_CODE = '"+currPeriod+"' AND EMP_CODE = '"+currEmpCode+"' AND (CASE WHEN VOUCHER_NO is null THEN ' ' ELSE VOUCHER_NO END) <> 'PAYROLL'";
					System.out.println("sqlStr In [payarrToProcUpdation][sqlStr][5]........:: " + sqlStr);
					stmt = conn.createStatement();
					rs = stmt.executeQuery(sqlStr);
					if (rs.next())
					{
						voucherNo = rs.getString("VOUCHER_NO");
						
						//Modified by Ahmed on 22/Mar/2017[As instructed by Piyush sir for trimmed value of voucher no as PAYROLL]
						if(voucherNo != null && !(voucherNo.trim().equalsIgnoreCase("PAYROLL")))
						{
							// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration]
							// if ((voucherNo != null && voucherNo.trim().length() > 0) || procType.equals("PY"))
							if ((voucherNo != null && voucherNo.trim().length() > 0) || procType.equals("PY") || winName.equals("W_ATTD_PROC_NORULE") || winName.equals("W_ATTD_MON"))
							{
								sqlStr = "SELECT COUNT(*) AS COUNT FROM PAYARR_TO_PROC WHERE EMP_CODE = '"+currEmpCode+"'" +
										" AND PRD_CODE = '"+currPeriod+"' AND STATUS = 'U' AND PROC_TYPE = '"+procType+"'" ;
								System.out.println("sqlStr In [payarrToProcUpdation][sqlStr][6]........:: " + sqlStr);
								stmt1 = conn.createStatement();
								rs1 = stmt1.executeQuery(sqlStr);
								if (rs1.next())
								{
									count1 = rs1.getInt("COUNT");
								}
								rs1.close();
								rs1 = null;
								stmt1.close();
								stmt1 = null;
								System.out.println("COUNT(*) FROM PAYARR_TO_PROC.....::[count1]:: "+ count1);
								if (count1 == 0)
								{
									// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration. Added emp_site,pay_site,work_site].Start
									/*
									String XMLString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
									"\r\n</header><Detail1></Detail1></Root>";
									*/
									String XMLString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
									"\r\n</header><Detail1><work_site><![CDATA[" + workSite.trim() + "]]></work_site><pay_site><![CDATA[" + paySite.trim() + "]]></pay_site><emp_site><![CDATA[" + empSite.trim() + "]]></emp_site></Detail1></Root>";
									// Modified by chetna on [06-09-2014][To incorporate changes of ITM in RCP Migration. Added emp_site,pay_site,work_site].End
	
									CommonConstants.setIBASEHOME();
									TransIDGenerator tg = new TransIDGenerator(XMLString, userId, CommonConstants.DB_NAME);
									tranID = tg.generateTranSeqID("PAYARR", "tran_id", keyString, conn);
									System.out.println("Transaction Id Generated [tranID] :: "+tranID);
									if (tranID.equals("ERROR"))
									{
										errCode = "VTTRANID";
										break;
									}
									String status = "U";
									sqlIns = "INSERT INTO PAYARR_TO_PROC (TRAN_ID, EMP_CODE, PRD_CODE, STATUS, PROC_TYPE, CHG_DATE, CHG_USER, CHG_TERM) " +
											" VALUES(?,?,?,?,?,?,?,?)";
									System.out.println("Insert sql In [payarrToProcUpdation][sqlIns][1]........:: " + sqlIns);
									pstmt = conn.prepareStatement(sqlIns);
									pstmt.setString(1,tranID);
									pstmt.setString(2,currEmpCode);
									pstmt.setString(3,currPeriod);
									pstmt.setString(4,status);
									pstmt.setString(5,procType);
									pstmt.setTimestamp(6,new java.sql.Timestamp(System.currentTimeMillis()));
									pstmt.setString(7,GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
									pstmt.setString(8,GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"termId"));
									int insCnt = pstmt.executeUpdate();
									if (insCnt == 1)
									{
										System.out.println("Inserted Into PAYARR_TO_PROC_TRACE Successfully.........");
									}
									else
									{
										errCode = "DS000";
										break;
									}
									pstmt.close();
									pstmt = null;
								}
								sqlIns = "INSERT INTO PAYARR_TO_PROC_TRACE (EMP_CODE, PRD_CODE, PROC_TYPE, TRAN_WINDOW, KEY_VALUES, CHG_DATE, CHG_USER, CHG_TERM) " + 
										" VALUES(?,?,?,?,?,?,?,?)" ;
								System.out.println("Insert sql In [payarrToProcUpdation][sqlIns][2]........:: " + sqlIns);
								pstmt = conn.prepareStatement(sqlIns);
								pstmt.setString(1,currEmpCode);
								pstmt.setString(2,currPeriod);
								pstmt.setString(3,procType);
								pstmt.setString(4,winName);
								pstmt.setString(5,keyStr);
								pstmt.setTimestamp(6,new java.sql.Timestamp(System.currentTimeMillis()));
								pstmt.setString(7,genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
								pstmt.setString(8,genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
								int insCnt = pstmt.executeUpdate();
								if (insCnt == 1)
								{
									System.out.println("Inserted Into PAYARR_TO_PROC_TRACE Successfully:: [insCnt].........::" + insCnt);
								}
								else
								{
									errCode = "DS000";
									break;
								}
								pstmt.close();
								pstmt = null;
							}
						}
					}//End Of If Block
					rs.close();
					rs = null;
					stmt.close();
					stmt = null;
				}//End Inner While loop
				rsPrd.close();
				rsPrd = null;
				stmtPrd.close();
				stmt = null;
				if (errCode.trim().length() > 0)
				{
					//conn.rollback();
					break;
				}
				if (adCode != null && adBasic.trim().equals(adCode.trim()))
				{
					errCode = empBasicUpdate(currEmpCode, adCode, amount, effDate, expDate, conn);
					System.out.println("errCode Returned From empBasicUpdate()[errCode]......:: "+ errCode);
					if (errCode.trim().length() > 0)
					{
						break;
					}
				}
			}//End Outer While loop
		}//End Of Try Block
		catch (SQLException se)
		{
			System.out.println("Exception :AdmCommon :payarrToProcUpdation:" + se.getMessage() + ":");
			se.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[AdmCommon][function::payarrToProcUpdation()] :==>\n"+e.getMessage());
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing ResultSet, Statement etc... In [payarrToProcUpdation()]...............");
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if (stmt1!= null)
				{
					stmt1.close();
					stmt1 = null;
				}
				if (rsEmp != null)
				{
					rsEmp.close();
					rsEmp = null;
				}
				if (stmtEmp != null)
				{
					stmtEmp.close();
					stmtEmp = null;
				}
				if (rsPrd != null)
				{
					rsPrd.close();
					rsPrd = null;
				}
				if (stmtPrd != null)
				{
					stmtPrd.close();
					stmtPrd = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception ex){}
		}
		return errCode;
	}
	//Function empBasicUpdate() Added by Gulzar 16/010/07
	public String empBasicUpdate(String currEmpCode, String adCode, double amount, String effDate, String expDate, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		String updSql = "", errCode = "";
		long effTime = 0, expTime = 0, todayTime = 0;
		java.sql.Timestamp effectiveDate = null, expiryDate = null;
		java.sql.Timestamp toDate = new java.sql.Timestamp(System.currentTimeMillis());

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			//Start
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date newDate =  new java.util.Date();
			java.util.Date newEffDate =  new java.util.Date();
			java.util.Date newExpDate =  new java.util.Date();
		
			newDate =  sdf.parse(sdf.format(newDate));
			newEffDate =  sdf.parse(sdf.format(sdf.parse(effDate)));
			newExpDate =  sdf.parse(sdf.format(sdf.parse(expDate)));
			//End
			effectiveDate	= java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(effDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
			expiryDate		= java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(expDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));

			effTime		= effectiveDate.getTime();
			expTime		= expiryDate.getTime();
			todayTime	= toDate.getTime();

			//if (toDate.compareTo(effectiveDate) >= 0 && toDate.compareTo(expiryDate) <= 0)
			//if (todayTime >= effTime && todayTime <= expTime)
			if (newDate.compareTo(newEffDate) >= 0 && newDate.compareTo(newExpDate) <= 0)//Modified
			{
				// Modified by Piyush on 30/06/2015[To check null value]
				//updSql = "UPDATE EMPLOYEE SET BASIC = BASIC + ? WHERE EMP_CODE = '"+currEmpCode+"' ";
				updSql = "UPDATE EMPLOYEE SET BASIC = CASE WHEN BASIC IS NULL THEN 0 ELSE BASIC END + ? WHERE EMP_CODE = '"+currEmpCode+"' ";
				System.out.println("Update sql In [empBasicUpdate][updSql][2]........:: " + updSql);
				pstmt = conn.prepareStatement(updSql);
				pstmt.setDouble(1,amount);
				int updCnt = pstmt.executeUpdate();
				if (updCnt == 1)
				{
					System.out.println("Updated Into EMPLOYEE Successgully......! [updCnt] :: "+ updCnt);
				}
				else if (updCnt == 0)
				{
					errCode = "VMEMP1";
					System.out.println("Error In Updating EMPLOYEE [errCode] :: " + errCode);
				}
			}//End Of if Block
		}//End Of try Block
		catch (SQLException se)
		{
			System.out.println("Exception :AdmCommon :empBasicUpdate:" + se.getMessage() + ":");
			se.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[AdmCommon][function::empBasicUpdate()] :==>\n"+e.getMessage());
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing pstmt In [empBasicUpdate()]...............");
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception ex){}
		}
		return errCode;
	}
	//Function  getRelativeDate(String effDate, int no) added by Gulzar 15/01/07
	public String getRelativeDate(String effDate, int no) 
	{
		String relativeDate ="";
		java.util.Date date1 = null;

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			date1 = sdf.parse(effDate);
			Calendar calObject = Calendar.getInstance();
			calObject.setTime(date1);
			calObject.add(calObject.DATE,no);
			date1 = calObject.getTime();
			relativeDate = sdf.format(date1);
			System.out.println(" relativeDate : " +relativeDate);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[AdmCommon][function::getRelativeDate()] :==>\n"+e.getMessage());
			e.printStackTrace();
		}
		return relativeDate;
	}

	// Modified By Hemlata on [11/11/2014] To update org_structure and org_struc_trace on postsave[Start]
	// Modified by Hemlata on 24/11/2014 [Modification done to throw exceptio]
	public String updateOrgStructure(  String domString, String empCode, String posCode, String deptCode,Date dateJoin,String posCodeOld,String deptCodeOld, String dateJoinOld,String userId,String chgTerm, String traceSource , Connection conn )  throws ITMException
	{
		PreparedStatement pstmt = null;
		boolean isError = false;
		ResultSet rs = null; 
		
		//Variables defined [Start]
		
		String lsKeyString = "";
		String lsRefSer = "";
		String errString = "";
		String sql="";
		String lsEmpCode = "";
		String joinDateSql = "";
		Date joinDateOld = null ;
		String lsTableno = "";
		String currDate =  "";
		String versionId = "";
		String lsDescr = "";
		String shDescr = "";
		String levelNo = "";
		String poolCode = "";
		Date chgDate = null;
		String posCodeRepto = "";
		Date effDate = null ;
		String validUpTo ="";
		String tranId = "";
		String chgUser = "";
		String effDatesql = "";
		String toUpdateNewPos = "";
		String chgTermFrmDb = "";
		
		//Variables defined [Start]
		
		try
		{

			GenericUtility genericUtility = GenericUtility.getInstance();	
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			SimpleDateFormat sdformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			toUpdateNewPos = "N";
			
			Date currentDate = new Date();
			String curDate = sdf.format(currentDate);
			currDate = genericUtility.getValidDateTimeString(curDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			//currDate = sdformat.format(currentDate);
			System.out.println("currDate::::::"+currDate);
			
			joinDateOld =  sdf.parse(dateJoinOld);
			System.out.println("joinDateOld::::::"+joinDateOld);
			
			System.out.println("dateJoin::::::"+dateJoin);
			
			sql =  "SELECT KEY_STRING , REF_SER  FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"w_org_struct_trace");

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				lsKeyString = checkNull(rs.getString("KEY_STRING"));
				lsRefSer = checkNull(rs.getString("REF_SER"));
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("lsKeyString::::::"+lsKeyString);
			System.out.println("lsRefSer::::::"+lsRefSer);
			
			joinDateSql = sdf.format(dateJoin);
			joinDateSql = genericUtility.getValidDateTimeString(joinDateSql,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("joinDateSql::::::"+joinDateSql);
			if (posCodeOld == null)
			{
				posCodeOld = "";
			}
			if (posCode == null)
			{
				posCode = "";
			}
			if (deptCodeOld == null)
			{
				deptCodeOld = "";
			}
			if (deptCode == null)
			{
				deptCode = "";
			}
			if(posCodeOld.trim().length() > 0 && deptCodeOld.trim().length() > 0 && joinDateOld != null)
			{
				if(!(posCodeOld.equalsIgnoreCase(posCode)) || !(deptCodeOld.equalsIgnoreCase(deptCode)) || joinDateOld.compareTo(dateJoin) != 0)
				{
					toUpdateNewPos = "Y";
					System.out.println("toUpdateNewPos::::::["+toUpdateNewPos+"]");

					
					sql =  "SELECT ITEM_SER AS TABLENO FROM DEPARTMENT WHERE DEPT_CODE = ?  ";
					pstmt = conn.prepareStatement(sql);

					pstmt.setString(1,deptCodeOld);
					rs = pstmt.executeQuery();

					if(rs.next())
					{
						lsTableno = checkNull(rs.getString("TABLENO"));
					}

					if( rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("lsTableno::::::"+lsTableno);
					
					if(lsTableno == null || lsTableno.trim().length() == 0)
					{
						errString = "VMTBLNO";
						return errString;
					}
					
					sql =  "SELECT VERSION_ID  FROM VERSION WHERE ? BETWEEN EFF_FROM AND VALID_UPTO  ";
					
					pstmt = conn.prepareStatement(sql);

					pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));

					rs = pstmt.executeQuery();

					if(rs.next())
					{
						versionId = checkNull(rs.getString("VERSION_ID"));
					}
					else
					{
						errString = "VERID";
					}
					if( rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("versionId::::::"+versionId);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString ;
					}
					
					sql = " SELECT DESCR , SH_DESCR , EMP_CODE , LEVEL_NO , POOL_CODE , CHG_DATE , CHG_USER , CHG_TERM , POS_CODE__REPTO , EFF_DATE  FROM ORG_STRUCTURE WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,versionId);
					pstmt.setString(2,lsTableno);
					pstmt.setString(3,posCodeOld);

					rs = pstmt.executeQuery();

					if(rs.next())
					{
						lsDescr = checkNull(rs.getString("DESCR"));
						shDescr = checkNull(rs.getString("SH_DESCR"));
						lsEmpCode = checkNull(rs.getString("EMP_CODE"));
						levelNo = checkNull(rs.getString("LEVEL_NO"));
						poolCode = checkNull(rs.getString("POOL_CODE"));
						chgDate = rs.getDate("CHG_DATE");
						chgUser = checkNull(rs.getString("CHG_USER"));
						chgTermFrmDb = checkNull(rs.getString("CHG_TERM"));
						posCodeRepto = checkNull(rs.getString("POS_CODE__REPTO"));
						effDate = rs.getDate("EFF_DATE");
					}
					else
					{
						errString = "NOPOS";
					}
					if( rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					} 
					System.out.println("lsDescr::::::"+lsDescr);
					System.out.println("shDescr::::::"+shDescr);
					System.out.println("empCode::::::"+lsEmpCode);
					System.out.println("levelNo::::::"+levelNo);
					System.out.println("poolCode::::::"+poolCode);
					System.out.println("chgDate::::::"+chgDate);
					System.out.println("chgUser::::::"+chgUser);
					System.out.println("chgTerm::::::"+chgTerm);
					System.out.println("posCodeRepto::::::"+posCodeRepto);
					System.out.println("effDate::::::"+effDate);
					
					if(errString != null && errString.trim().length()  > 0)
					{
						return errString ;
					}
					
					effDatesql = sdf.format(effDate);
					effDatesql = genericUtility.getValidDateTimeString(effDatesql,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					System.out.println("effDatesql::::::"+effDatesql);
					
					validUpTo =  relativeDate(dateJoin , -1);
					validUpTo = genericUtility.getValidDateTimeString(validUpTo,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					System.out.println("validUpTo::::::"+validUpTo);
					
					TransIDGenerator tg = new TransIDGenerator(domString, userId, "");
					tranId = tg.generateTranSeqID(lsRefSer, "tran_id", lsKeyString, conn);
					
					if(tranId == null || tranId.trim().length() == 0 || tranId.equalsIgnoreCase("ERROR"))
					{
						errString = "VTTRANID";
						return errString;
					}
					
					Date changeDate  = new Date();
					String chngDate = sdf.format(changeDate);
					chngDate = genericUtility.getValidDateTimeString(chngDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					
					sql = " INSERT INTO ORG_STRUC_TRACE(TRAN_ID,VERSION_ID,TABLE_NO,POS_CODE,DESCR,SH_DESCR,POS_CODE__REPTO,EMP_CODE, LEVEL_NO,POOL_CODE,CHG_DATE,CHG_USER,CHG_TERM,EFF_DATE,VALID_UPTO, TRACE_SRC) " +
							"VALUES(? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,? ,? , ? , ? ,? ) "; 
					
					pstmt = conn.prepareStatement(sql);

					pstmt.setString(1,tranId);
					pstmt.setString(2,versionId);
					pstmt.setString(3,lsTableno);
					pstmt.setString(4,posCodeOld);
					pstmt.setString(5,lsDescr);
					pstmt.setString(6,shDescr);
					pstmt.setString(7,posCodeRepto);
					pstmt.setString(8,lsEmpCode);
					pstmt.setString(9,levelNo);
					pstmt.setString(10,poolCode);
					pstmt.setTimestamp(11,java.sql.Timestamp.valueOf(chngDate));
					pstmt.setString(12,userId);
					pstmt.setString(13,chgTerm);
					pstmt.setTimestamp(14,java.sql.Timestamp.valueOf(effDatesql));
					//pstmt.setString(15,validUpTo);
					pstmt.setTimestamp(15,java.sql.Timestamp.valueOf(validUpTo));		
					pstmt.setString(16,traceSource);

					pstmt.executeQuery();
					
					validUpTo =  relativeDate(dateJoin , 5475);
					validUpTo = genericUtility.getValidDateTimeString(validUpTo,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					System.out.println("validUpTo::::::"+validUpTo);
					//Modified by Ahmed on 27/Apr/2017 to set valid upto value based on parameter[start] 
					validUpTo = getEnv("999999", "VALID_UPTO_ORG_STRUC", conn);
					System.out.println("validUpTo From PAYRPARM::"+validUpTo);
					validUpTo = genericUtility.getValidDateTimeString(validUpTo, "yyyy-MM-dd hh:mm:ss", genericUtility.getDBDateFormat());
					System.out.println("validUpTo From PAYRPARM::After conversion::"+validUpTo);
					//Modified by Ahmed on 27/Apr/2017 to set valid upto value based on parameter[end]
					
					if(posCodeOld.equalsIgnoreCase(posCode) && deptCodeOld.equalsIgnoreCase(deptCode))
					{
						sql = " UPDATE ORG_STRUCTURE SET EMP_CODE = ? , EFF_DATE = ? , VALID_UPTO = ? , CHG_DATE = ? , CHG_USER = ? , CHG_TERM = ?  WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? " ; 
						pstmt = conn.prepareStatement(sql);
						
						pstmt.setString(1,empCode);
						pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(joinDateSql));
						pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(validUpTo));
						pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(chngDate));
						pstmt.setString(5,userId);
						pstmt.setString(6,chgTerm);
						pstmt.setString(7,versionId);
						pstmt.setString(8,lsTableno);
						pstmt.setString(9,posCodeOld);
						pstmt.executeUpdate();
						
						toUpdateNewPos = "N" ;
						return errString;
					}
					else
					{
						sql = " UPDATE ORG_STRUCTURE SET EMP_CODE = null , EFF_DATE = ?, VALID_UPTO = ? , CHG_DATE = ? , CHG_USER = ? , CHG_TERM = ?  WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? " ; 
						
						pstmt = conn.prepareStatement(sql);
						
						pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(joinDateSql));
						pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(validUpTo));
						pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(chngDate));
						pstmt.setString(4,userId);
						pstmt.setString(5,chgTerm);
						pstmt.setString(6,versionId);
						pstmt.setString(7,lsTableno);
						pstmt.setString(8,posCodeOld);

						pstmt.executeUpdate();
						
						toUpdateNewPos = "Y" ;
					}
				}
				
			}
			else if(posCode != null && posCode.trim().length() > 0)
			{
				toUpdateNewPos = "Y" ;
			}
			else
			{
				toUpdateNewPos =  "N" ;
			}

			if(toUpdateNewPos == null || toUpdateNewPos.equalsIgnoreCase("N")  || posCode == null || posCode.trim().length() == 0)
			{
				return errString;
			}
			
			sql =  "SELECT ITEM_SER AS TABLENO FROM DEPARTMENT WHERE DEPT_CODE = ?  ";
			
			pstmt = conn.prepareStatement(sql);

			pstmt.setString(1,deptCode);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				lsTableno = checkNull(rs.getString("TABLENO"));
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("lsTableno::::::"+lsTableno);
			
			if(lsTableno == null || lsTableno.trim().length() == 0)
			{
				errString = "VMTBLNO";
				return errString;
			}
			
			sql =  "SELECT VERSION_ID  FROM VERSION WHERE ? BETWEEN EFF_FROM AND VALID_UPTO";

			pstmt = conn.prepareStatement(sql);

			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				versionId = checkNull(rs.getString("VERSION_ID"));
			}
			else
			{
				errString = "VERID";
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("versionId::::::"+versionId);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString ;
			}
			
			sql = "SELECT DESCR , SH_DESCR , EMP_CODE , LEVEL_NO , POOL_CODE , CHG_DATE , CHG_USER , CHG_TERM , POS_CODE__REPTO , EFF_DATE  FROM ORG_STRUCTURE WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ?";
			
			pstmt = conn.prepareStatement(sql);

			pstmt.setString(1,versionId);
			pstmt.setString(2,lsTableno);
			pstmt.setString(3,posCode);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				lsDescr = checkNull(rs.getString("DESCR"));
				shDescr = checkNull(rs.getString("SH_DESCR"));
				lsEmpCode = checkNull(rs.getString("EMP_CODE"));
				levelNo = checkNull(rs.getString("LEVEL_NO"));
				poolCode = checkNull(rs.getString("POOL_CODE"));
				chgDate = rs.getDate("CHG_DATE");
				chgUser = checkNull(rs.getString("CHG_USER"));
				chgTermFrmDb = checkNull(rs.getString("CHG_TERM"));
				posCodeRepto = checkNull(rs.getString("POS_CODE__REPTO"));
				effDate = rs.getDate("EFF_DATE");
			}
			else
			{
				errString = "NOPOS";
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			} 
			System.out.println("lsDescr::::::"+lsDescr);
			System.out.println("shDescr::::::"+shDescr);
			System.out.println("empCode::::::"+lsEmpCode);
			System.out.println("levelNo::::::"+levelNo);
			System.out.println("poolCode::::::"+poolCode);
			System.out.println("chgDate::::::"+chgDate);
			System.out.println("chgUser::::::"+chgUser);
			System.out.println("chgTerm::::::"+chgTerm);
			System.out.println("posCodeRepto::::::"+posCodeRepto);
			System.out.println("effDate::::::"+effDate);
			
			if(errString != null && errString.trim().length()  > 0)
			{
				return errString ;
			}
			
			effDatesql = sdf.format(effDate);
			effDatesql = genericUtility.getValidDateTimeString(effDatesql,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("effDatesql::::::"+effDatesql);
			
			validUpTo =  relativeDate(dateJoin , -1);
			validUpTo = genericUtility.getValidDateTimeString(validUpTo,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("validUpTo::::::"+validUpTo);
			
			TransIDGenerator tg = new TransIDGenerator(domString, userId, "");
			tranId = tg.generateTranSeqID(lsRefSer, "tran_id", lsKeyString, conn);
			if(tranId == null || tranId.trim().length() == 0 || tranId.equalsIgnoreCase("ERROR"))
			{
				errString = "VTTRANID";
				return errString;
			}
			
			Date changeDate  = new Date();
			String chngDate = sdf.format(changeDate);
			chngDate = genericUtility.getValidDateTimeString(chngDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("chngDate::::::"+chngDate);
			
			sql = " INSERT INTO ORG_STRUC_TRACE(TRAN_ID,VERSION_ID,TABLE_NO,POS_CODE,DESCR,SH_DESCR,POS_CODE__REPTO,EMP_CODE, LEVEL_NO,POOL_CODE,CHG_DATE,CHG_USER,CHG_TERM,EFF_DATE,VALID_UPTO, TRACE_SRC) " +
					"VALUES(? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,? ,? , ? , ? ,? ) "; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.setString(2,versionId);
			pstmt.setString(3,lsTableno);
			pstmt.setString(4,posCode);
			pstmt.setString(5,lsDescr);
			pstmt.setString(6,shDescr);
			pstmt.setString(7,posCodeRepto);
			pstmt.setString(8,lsEmpCode);
			pstmt.setString(9,levelNo);
			pstmt.setString(10,poolCode);
			pstmt.setTimestamp(11,java.sql.Timestamp.valueOf(chngDate));
			pstmt.setString(12,userId);
			pstmt.setString(13,chgTerm);
			pstmt.setTimestamp(14,java.sql.Timestamp.valueOf(effDatesql));
			//pstmt.setString(15,validUpTo);
			pstmt.setTimestamp(15,java.sql.Timestamp.valueOf(validUpTo));			
			pstmt.setString(16,"EMPMST");

			pstmt.executeQuery();
			
			sql = " UPDATE ORG_STRUCTURE SET EMP_CODE = ? , EFF_DATE = ? , CHG_DATE = ? , CHG_USER = ? , CHG_TERM = ?  WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? " ; 
			
			pstmt = conn.prepareStatement(sql);

			pstmt.setString(1,empCode);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(joinDateSql));
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(chngDate));
			pstmt.setString(4,userId);
			pstmt.setString(5,chgTerm);
			pstmt.setString(6,versionId);
			pstmt.setString(7,lsTableno);
			pstmt.setString(8,posCode);

			pstmt.executeUpdate();
			
			
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpBasicInfoPos : :==>\n"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				//System.out.println("isLocalConn ["+isLocalConn+"]");
				if (rs != null)
				{
					rs.close();
					rs = null;
				}

				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( conn != null )
				{
					if( isError )
					{
						conn.rollback();
					}
					
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : : :==>\n"+e.getMessage());
			
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}
				catch(SQLException sqle)
				{
					System.out.println(sqle);
				}
				throw new ITMException(e);
			}
		}
		System.out.println("Return Error string :"+errString);
		return errString;		
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
		
	public String relativeDate(Date sourceDate , int days)
	{
		String returnDate =  "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar cal = Calendar.getInstance();
			cal.setTime(sourceDate);
			cal.add(cal.DAY_OF_MONTH , days);
			returnDate = sdf.format(cal.getTime());
			System.out.println("Final Calculated Date...::" +returnDate);			
			//returnDate = sdf.parse(calDate);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return returnDate ;
	}
	//Modified By Hemlata on [11/11/2014] To update org_structure and org_struc_trace on postsave[End]

	//Modified by Sana on [25-11-2015][Request ID: A15JSUN006 - To add gbfEmp during migration of Employee Seperation in java][Start]
	public String gbfEmp(String empCode , Date asOfDate , String empSite , String loginSite , Connection conn)
	{
		String status = "",retString="",errString="";
		String relieveDateStr = "";
		String asOfDateStr = "";
		String sql = "" ;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		java.util.Date relieveDate = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		System.out.println("worksite is" + empSite);
		System.out.println("login site is" + loginSite);
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			SimpleDateFormat dbsdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			
			if(asOfDate != null)
			{
				asOfDateStr =sdf.format(asOfDate) ;
			}
		
			sql = "SELECT RELIEVE_DATE , STATUS FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				relieveDateStr = rs.getString("RELIEVE_DATE");
				status = rs.getString("STATUS");
				
			}
			else
			{
				errString ="VMEMP1";
			}
			
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null ; 
			}
			if (errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			System.out.println("Relieve Date in gbfEmp is " + relieveDateStr);
			System.out.println("Status in gbfEmp is " + status );
			
			if(relieveDateStr != null && relieveDateStr.trim().length() >0)
			{
				relieveDate = dbsdf.parse(relieveDateStr);
			}
			
			System.out.println("Relieve Date in gbfEmp is " + relieveDate);
			
			if((asOfDateStr == null || asOfDateStr.trim().length() == 0))
			{
				System.out.println("INSIDE IF LOOP OF GBFEMP (asOfDate NULL) " + asOfDateStr);
				
				errString ="VMEMP1";
				return errString;				
							
			}
			System.out.println("asOfDate in gbfEmp is " + asOfDate);
			System.out.println("asOfDateStr in gbfEmp is " + asOfDateStr);
			
			if(relieveDateStr != null && (asOfDate.after(relieveDate) || asOfDate.equals(relieveDate)) && status.trim().equals("S"))
			{
				System.out.println("INSIDE IF LOOP OF GBFEMP (relieveDateStr) " + relieveDateStr);
				
				errString = "VMEMP2";
				return errString;
				
			}
			 if((loginSite != null && loginSite.trim().length() > 0) && !empSite.trim().equals(loginSite.trim()))
			{
				 System.out.println("INSIDE IF LOOP OF GBFEMP (loginsite) " + loginSite);
				
				 errString = "VMSITE10";
				 return errString;
				
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
				
		return errString;
	}
	//Modified by Sana on [25-11-2015][Request ID: A15JSUN006 - To add gbfEmp during migration of Employee Seperation in java][End]
	//Modified by Juhi on 04-05-2016 [A15JSUN007] [To display error message as xml string] [START]
	/** 
	 * This method returns error string when invoked
	 * @author Juhi Mehta
	 * @Date 10-May-2016
	 * @RequestID A15JSUN007
	 * 
     * @param msgId : ID defined for message
     * @param errorType : Type of error
     * @param columnName : Column name for which error occurred 
     * @param errorCode : Code of error
     * @param msgDescr : Message description of error
     * @return errStringXml : Error string in xml format
	 **/
	public String getErrorXmlString( String msgId, String errorType, String columnName, String errorCode, String msgDescr )
	{
		StringBuffer errStringXml = null;
		try
		{
			errStringXml = new StringBuffer();
			errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
			errStringXml.append("<error id=").append("\"" +msgId + "\"").append(" type=").append( "\"" + errorType + "\"" ).append(" column_name=").append("\"" + columnName + "\"").append(">\r\n");
			errStringXml.append("<message>").append( "<![CDATA[" + errorCode + "]]>" ).append("</message>\r\n");
			errStringXml.append("<description>").append( "<![CDATA[" + msgDescr + "]]>" ).append("</description>\r\n");
			errStringXml.append("<type>").append( "<![CDATA[" + errorType + "]]>" ).append("</type>\r\n");
			errStringXml.append("<trace>").append( "<![CDATA[" + errorCode + "]]>" ).append("</trace>\r\n");
			errStringXml.append("</error>\r\n");
			errStringXml.append("</Errors></Root>\r\n");
			System.out.println("errStringXml ::" + errStringXml.toString());
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return errStringXml.toString();
	}
	//Modified by Juhi on 04-05-2016 [A15JSUN007] [To display error message as xml string] [END]
}