<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">
	<html>
		<head>
			<style type="text/css">
				.tTitle1
				{
				text-align:center;
				}
				.tHeaderD1
				{
				text-align:right;
				}
				.tTitleD1
				{
				text-align:center;
				}
				.numberData
				{
				text-align:right;
				}
				.editDisplayClass
				{readOnly:true;border :inset 1;COLOR:BLACK ;BACKGROUND:#FFFFD9; TEXT-ALIGN:left;FONT:
				8ptarial; width:auto;};
				.editDisplayRemarkClass
				{readOnly:true;border :inset 1;COLOR:black ; BACKGROUND:#FFFFD9; TEXT-ALIGN:left;FONT:
				7ptarial;};
				.editDisplayrightClass
				{readOnly:true;border :inset 1;COLOR:black ; TEXT-ALIGN:right;FONT:8ptarial;};
				.editDisplayecnterClass
				{readOnly:true;border :inset 1;COLOR:white ;
				BACKGROUND:#5b7290;TEXT-ALIGN:center;FONT:8ptarial;};
				.displayCenterClass
				{readOnly:true;border :inset 1;COLOR:#DC143C;
				BACKGROUND:#CCCCFF;TEXT-ALIGN:center;FONT:10ptarial;};
				.displayCenterClass2
				{readOnly:true;border :inset 1;COLOR:#0000CD;
				BACKGROUND:#E0FFFF;TEXT-ALIGN:center;FONT:10ptarial;};
				.editDisplayColumnClass{readOnly:true;color:#555; TEXT-ALIGN:left;
				padding:5px; font-size:16px; font-weight:normal;}
				.editDisplayheaderClass{readOnly:true;color:#000; TEXT-ALIGN:left;
				padding:5px; font-weight:normal; font-size:14px;
				vertical-align:top;}
				.editDisplayrightClass{readOnly:true;border :inset 1;COLOR:black ; BACKGROUND:#FFFFD9;TEXT-ALIGN:right;
				font-weight:normal;}
				.editDisplayecnterClass{readOnly:true; color:#5fdeb2; TEXT-ALIGN:left; font-size:18px; padding:5px 0;
				font-weight:normal;}
				.editDisplayecnterClass2{readOnly:true;border :inset 1;COLOR:black ; TEXT-ALIGN:center; font-weight:normal;}
				.editDisplayClass{background-color: transparent
				!important;readOnly:true;color:#555; TEXT-ALIGN:left; padding:5px;
				font-weight:normal; font-size:14px;}
				.editDisplayecnterClass1 {readOnly:true; color:#5fdeb2; TEXT-ALIGN:left; font-size:16px;
				padding:10px 0 0 0;}
				.editDisplayecnterClass3 {readOnly:true; color:#5fdeb2; TEXT-ALIGN:left; font-size:16px;
				padding:10px 0 0 0;}
				.tableClass {margin-bottom:10px; width:100%; background-color:#FFF;
				/*padding:10px;*/ border-left: 1px solid #d9d9d9; border-top: 1px
				solid #d9d9d9;}
				.tableClass td {border-bottom: 1px solid #d9d9d9; border-right: 1px solid
				#d9d9d9; font-size:14px;}
				.tbletopbrd{border-top:2px solid #5fdeb2;}
				.date {
				color: #9d9ca2;
				font-size: 11px;
				font-weight: normal;
				}
				.tableClass1 {
				margin-bottom: 5px;
				width: 100%;
				background-color: #FFF;
				border-LEFT: 1px solid #d9d9d9;
				border-top: 1px solid #d9d9d9;
				}
				.tableClass1 td {
				border-bottom: 1px solid #d9d9d9;
				border-right: 1px solid #d9d9d9;
				font-size: 14px;
				line-height: 18px;
				padding: 5px;
				}
		</style>
		</head>
		<body>
			<input type="hidden" value="bom" name="OBJ_NAME" id="OBJ_NAME" />
			<input type="hidden" value="2" name="PAGE_CONTEXT" id="PAGE_CONTEXT" />
			<input type="hidden" value="1" name="OBJ_CONTEXT" id="OBJ_CONTEXT" />
			<form name="BillOfMaterial">
				<table cellSpacing="0" cellPadding="0" width="100%" border="0">
							<tbody>
								<tr>
									<td colSpan="4" class="editDisplayColumnClass">
										<font size="4">
											Bill Of Material
										</font>
									</td>
								</tr>
							</tbody>
					</table>
					<xsl:for-each select="//Detail1">
						<table class="tableClass tbletopbrd" cellSpacing="0" cellPadding="0" width="100%" border="0">
							<TBODY>
								<xsl:variable name="dbID">
									<xsl:value-of select="@dbID" />
								</xsl:variable>
								<xsl:variable name="wf_status">
									<xsl:value-of select="wf_status" />
								</xsl:variable>
								<xsl:variable name="bom_code">
									<xsl:value-of select="bom_code" />
								</xsl:variable>
								<xsl:variable name="eff_from">
									<xsl:value-of select="eff_from" />
								</xsl:variable>
								<xsl:variable name="valid_upto">
									<xsl:value-of select="valid_upto" />
								</xsl:variable>
								<xsl:variable name="item_code">
									<xsl:value-of select="item_code" />
								</xsl:variable>
								<xsl:variable name="descr">
									<xsl:value-of select="descr" />
								</xsl:variable>
								<xsl:variable name="item_ref">
									<xsl:value-of select="item_ref" />
								</xsl:variable>
								<xsl:variable name="item_descr">
									<xsl:value-of select="item_descr" />
								</xsl:variable>
								<xsl:variable name="emp_code__aprv">
									<xsl:value-of select="emp_code__aprv" />
								</xsl:variable>
								<xsl:variable name="site_code">
									<xsl:value-of select="site_code" />
								</xsl:variable>
								<xsl:variable name="remarks">
									<xsl:value-of select="remarks" />
								</xsl:variable>
								
								<TR>
									<td class="editDisplayClass" width="50%">
										<font face="Times New Roman">
											<font size="2">
												<strong>Item Code : </strong>
											</font>
											<font size="2">
												<xsl:value-of select="item_code" />
											</font>
										</font>
									</td>
									<td class="editDisplayClass" style="text-align: right;" width="50%">
										<font face="Times New Roman">
											<font size="2">
												<b>Claim Date : </b>
												<xsl:value-of select="valid_upto" />
											</font>
										</font>
									</td>
								</TR>
								<tr>
									<td class="editDisplayheaderClass"
										style="text-align: center;font-size: 18px;border: 0px;padding-bottom: 0px;"	colspan="2">
										Bill Of Material No :
										<xsl:value-of select="bom_code" />
									</td>
								</tr>
								<tr>
									<td class="date" style="text-align: center;border: 0px;padding-top: 0px;" width="100%" colspan="2">
										<xsl:value-of select="eff_from"/>
									</td>
								</tr>
								<tr>
								<td class="editDisplayClass">
									<font size="2">
										<strong>Site : </strong>
											<xsl:value-of select="site_code" />
									</font>
								</td>
								<td class="editDisplayClass" style="text-align: right;">
									<font size="2">
										<strong>Item Series : </strong>&#160;<xsl:value-of select="item_ser" />
									</font>
								</td>
								</tr>
								
							</TBODY>
						</table>
						<br></br>
								
					</xsl:for-each>
					<!--<br />
					<table width="100%" border="0" cellspacing="0" cellpadding="0">
						<tr>
							<td class="editDisplayheaderClass" width="1%">
								Bill Of Material Details
							</td>
						</tr>
					</table>
					<table class="tableClass" cellSpacing="0" cellPadding="0" width="100%" border="0">
						<tbody>
							<xsl:for-each select="//Detail1">
								<tr border="1">
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Sr No</font>
									</td>
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Item Code</font>
									</td>
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Description </font>
									</td>
									<td class="editDisplayheaderClass">
										<font face="Times New Roman" size="2">Unit 
										</font>
									</td>
									<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Quantity</font>
									</td>
									<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Rate
											</font>
									</td>
									<td class="editDisplayheaderClass">
											<font face="Times New Roman" size="2">Amount 
											</font>
									</td>
								</tr>
							</xsl:for-each>
							
						</tbody>
					</table>-->
			</form>
		</body>
	</html>
</xsl:template>
</xsl:stylesheet>