/**
 * 
 */
package ibase.dashboard.mfg.bean;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import ibase.dashboard.mfg.ejb.ProductionVsBudgetReportRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import javax.naming.InitialContext;

/**
 * @author base
 *
 */
public class ProductionVsBudgetReportBean

{
	ProductionVsBudgetReportRemote  budgetReportRemote=null;

	/**
	 * 
	 */
	public ProductionVsBudgetReportBean()
	{
		AppConnectParm appConnectParm=new AppConnectParm();
		try
        {
	        InitialContext context=new InitialContext(appConnectParm.getProperty());
	     
	        budgetReportRemote=(ProductionVsBudgetReportRemote)context.lookup("ibase/ProductionVsBudgetReport/remote");
        }
		catch (Exception e)
        {
			System.out.println(" ibase.dashboard.mfg.bean :ProductionVsBudgetReportBean "+e);
	        e.printStackTrace();
        }
	}
	
	
	public String getProductionBudget(String frmDate,String toDate,String geoLoc,String unitForm) throws RemoteException, ITMException
    {
		String xmlString="";
		try
		{
		xmlString= budgetReportRemote.getProductionBudget(frmDate, toDate,geoLoc,unitForm);
		}
		catch (Exception e)
		{
			System.out.println("ibase.dashboard.mfg.bean :ProductionVsBudgetReportBean "+e);
	        e.printStackTrace();
		}
		
		return xmlString;
    }
	
	public String getGeoLoCodeXmlData() throws RemoteException, ITMException
    {
		String xmlDataString="";
		try
		{
			xmlDataString= budgetReportRemote.getGeoLoCodeXmlData();
		}
		catch (Exception e)
		{
			System.out.println("ibase.dashboard.mfg.bean :ProductionVsBudgetReportBean "+e.getMessage());
	        e.printStackTrace();
		}
		
		return xmlDataString;
    }
	
	public String getUnitFormXmlData() throws RemoteException, ITMException
    {
		String xmlDataString="";
		try
		{
			xmlDataString= budgetReportRemote.getUnitFormXmlData();
		}
		catch (Exception e)
		{
			System.out.println("ibase.dashboard.mfg.bean :ProductionVsBudgetReportBean "+e.getMessage());
	        e.printStackTrace();
		}
		
		return xmlDataString;
    }
	
	
	
	public String generatePDF(HashMap<String, List<String>> hashMap ,String exportPDFPath,String exportImagePath,String preyearMonth,String rptTitle,String userID) throws RemoteException, ITMException
       {
		String resultString="false";
		try
		{
			
			
		  resultString= budgetReportRemote.generatePDF(hashMap,exportPDFPath,exportImagePath,preyearMonth,rptTitle,userID);
		}
		catch (Exception e)
		{
			System.out.println("ibase.dashboard.mfg.bean :ProductionVsBudgetReportBean "+e.getMessage());
	        e.printStackTrace();
		}
		
		return resultString;
    }
	
		
	
	
	public boolean getRoleValid(String userCode, String roleCode) throws RemoteException, ITMException
    {
		boolean isRoleExists=false;
		try
		{
			 isRoleExists =   budgetReportRemote.getRoleValid(userCode,roleCode);
			
		}
		catch (Exception e)
		{
			System.out.println("ibase.dashboard.mfg.bean :ProductionVsBudgetReportBean "+e.getMessage());
	        e.printStackTrace();
		}
		
		return isRoleExists;
    }
	

	
}
