package ibase.webitm.ejb.mfg;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless

public class StoppagesConf extends ActionHandlerEJB implements
StoppagesConfLocal, StoppagesConfRemote 
{
	public String actionHandler() throws RemoteException, ITMException
	{
		return "";
	}

	public String actionHandler(String actionType, String xmlString,
			String objContext, String xtraParams) throws RemoteException,
			ITMException 
			{
		System.out.println("item actionHandler(...) called............");
		String str = "";
		System.out.println("actionType---" + actionType);
		System.out.println("xmlString---" + xmlString);
		System.out.println("objContext---" + objContext);
		System.out.println("xtraParams---" + xtraParams);
		return str;
			}
	public String confirm(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException
			{
		System.out.println("Stoppagesconf confirm called..............");
		String confirmed = "";
		String siteCode="";
		
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		String errString = "",errCode="";
		ResultSet rs = null;
		int  cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		StoppagesConf stoppgesscnf=new StoppagesConf();// Object required to confirm Stoppages.
		boolean isLocal=false;
		try 
		{
			E12GenericUtility genericUtility=new E12GenericUtility();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());
			System.out.println("Now the date is :=>  " + sysDate);
			
			itmDBAccessEJB = new ITMDBAccessEJB();
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (errString == null || errString.trim().length() == 0)
			{
				
				if (tranId != null && tranId.trim().length() > 0) 
				{

					sql = "select confirmed,site_code from stoppages where tran_id =?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					while (rs.next()) 
					{
						confirmed =  rs.getString(1)==null?"":rs.getString(1);
						siteCode=	rs.getString(2)==null?"":(rs.getString(2));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					System.out.println("Status from stoppages &&&&&&&&&&&:- "+confirmed);
					
					if ("Y".equalsIgnoreCase(confirmed)) 
					{
						System.out.println("Confirmed Status" + confirmed);
						errCode = "VTCONF1";   //'StoppagesConf Already Confirmed'
						errString = itmDBAccessLocal.getErrorString("",errCode,"");
					}	
					else
					{
						
						errString = Stoppagesconf(tranId,1, xtraParams,conn);
						System.out.println("@@@@ confirmStoppages::errCode["+errString+"]");
						
					}


				}
				if (errString == null || errString.trim().length() == 0) 
				{
					errCode = "VTCONFIRM";
					errString = itmDBAccessLocal.getErrorString("",errCode,"");
					return errString;
				}

			}


		} catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				if (errString != null && errString.trim().length() > 0	&& !("VTCONFIRM".equalsIgnoreCase(errCode)) ) 
				{

					conn.rollback();
					System.out.println("@@@@ Transaction rollback...["+errString+"]::errCode["+errCode+"]");
					if(isLocal){
					conn.close();
					conn = null;
					}
				}
				else 
				{
					if(isLocal){
					conn.commit(); // test
					System.out.println("c"+errString+"]::errCode["+errCode+"]");
					conn.close();
					conn = null;
					}else{
						System.out.println("DIDNT COMMIT ********8");
					}
				}
			}
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
			}
	


	

	private String Stoppagesconf(String tranId, int i, String xtraParams, Connection conn)
			throws RemoteException, ITMException
			{
		PreparedStatement pstmt = null, pstmtSql = null,pstmtSql1=null;
		ResultSet rs = null,rs1 = null;
		int cnt = 0,updCnt=0;
		String  sql = "", errCode = "",errString ="",sql1 ="",sql2 ="",loginEmpCode="";
			try
			
			{
		
		 ibase.utility.E12GenericUtility genericUtility= null;
		genericUtility = new ibase.utility.E12GenericUtility();
		//loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
		Timestamp sysDate = null;
		Calendar currentDate = Calendar.getInstance();
		GenericUtility genericUtility1 = GenericUtility.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat(genericUtility1.getApplDateFormat());
		String sysDateStr = sdf.format(currentDate.getTime());
		sysDate= Timestamp.valueOf(genericUtility1.getValidDateString(sysDateStr, genericUtility1.getApplDateFormat(),genericUtility1.getDBDateFormat()) + " 00:00:00.0");
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
				
		sql="select count(*) from stoppagesdet where  tran_id =?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, tranId);
		rs = pstmt.executeQuery();
		while(rs.next()) 
		{
			cnt = rs.getInt(1);
			
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;
		
		if(cnt<= 0)
		{
			errCode="DS000NR";
			errString = itmDBAccessLocal.getErrorString("",errCode,"Details for this Transaction! Cannot be confirmed");
			return errString;
			
		}
		sql2="Select emp_code from stoppages where tran_id=?";
		pstmtSql1=conn.prepareStatement(sql2);
		pstmtSql1.setString(1, tranId);
		rs1 = pstmtSql1.executeQuery();
		while (rs1.next()) {
			loginEmpCode = rs1.getString(1)==null?"":rs1.getString(1);
		}
		pstmtSql1.close();
		pstmtSql1 = null;
		rs1.close();
		rs1 = null;
		System.out.println("empcode"+loginEmpCode);
		sql1="update stoppages set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where  tran_id   = ?";
		pstmtSql = conn.prepareStatement(sql1);
		pstmtSql.setTimestamp(1, sysDate);
		pstmtSql.setString(2,loginEmpCode);
		pstmtSql.setString(3, tranId);
		
		updCnt = pstmtSql.executeUpdate();
		pstmtSql.close();
		pstmtSql = null;
		System.out.println("If 1 then updated = "+updCnt);
		if(updCnt != 1)
		{
			errCode = "VTUPDHDR";
		}
		
			}

		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		return errCode;
			
		}
}
		
		