/**
 * PURPOSE : ApplicationMasterIC component
 * AUTHOR : Sneha Mestry
 * DATE : 07-10-2016
 */

package ibase.webitm.ejb.sys;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class ApplicationMasterIC extends ValidatorEJB implements ApplicationMasterICLocal, ApplicationMasterICRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility(); 

	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String  childNodeName = "", errorType = "", errCode = "", errString = "", userId = "";
		int currentFormNo = 0, childNodeListLength = 0, cnt = 0, ctr = 0;

		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String> ();

		String applicationName = "", applicationGroup = "", applicationColor = "", descr = "", applicationOrder = "";
		int countApplColor = 0, countApplMst = 0, countItm2Menu = 0;
		
		try
		{	
			System.out.println("@@@@@@@@@ Inside wfValData for  ApplicationMasterIC @@@@@@@@ ");
			
			conn = getConnection();
			conn.setAutoCommit(false);
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			System.out.println(" editFlag in case1 ========>>"+editFlag);
			System.out.println("xtraParam in wfValData ----->>["+xtraParams+"]");
			/*System.out.println("DOM  in wfValData  ---->>["+genericUtility.serializeDom(dom).toString()+"]");
			System.out.println("DOM1  in wfValData  ----->>["+genericUtility.serializeDom(dom1).toString()+"]");
			System.out.println("DOM2  in wfValData ----->>["+genericUtility.serializeDom(dom2).toString()+"]");	*/

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  
			{
			case 1:
				applicationName = checkNullAndTrim(genericUtility.getColumnValue("app_name",dom));
				applicationGroup = checkNullAndTrim(genericUtility.getColumnValue("appl_group",dom));
				applicationColor = checkNullAndTrim(genericUtility.getColumnValue("appl_color",dom));
				descr = checkNullAndTrim(genericUtility.getColumnValue("descr",dom));
				applicationOrder = checkNullAndTrim(genericUtility.getColumnValue("appl_order",dom));
				
				System.out.println(" applicationName in case1 ========>>["+applicationName+"]");
				System.out.println(" applicationGroup in case1 ========>>["+applicationGroup+"]");
				System.out.println(" applicationColor in case1 ========>>["+applicationColor+"]");
				System.out.println(" descr in case1 ========>>["+descr+"]");
				System.out.println(" applicationOrder in case1 ========>>["+applicationOrder+"]");

				parentNodeList = dom1.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("value of child node name ["+childNodeName + "]");

					if(editFlag.equalsIgnoreCase("A"))
					{
						if("app_name".equalsIgnoreCase(childNodeName))
						{
							if(applicationName.trim().length() == 0 || applicationName.equalsIgnoreCase("")) 
							{					
								System.out.println(" applicationName found blank ---------- ");
								errCode = "VTAPPNMBLK";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
							
							if((applicationName.trim().length() > 0 || !applicationName.trim().equalsIgnoreCase(""))) 
							{									
								countItm2Menu = getCount("ITM2MENU", "APPLICATION", applicationName, conn);
								System.out.println("countItm2Menu=========>>["+countItm2Menu+"]");
								
								if(countItm2Menu <= 0)
								{
									System.out.println(" applicationName not found in Itm2Menu table --------- ");
									errCode = "VTAPPNMNFD";		
									errList.add( errCode );
									errFields.add(childNodeName.toLowerCase());
									break;
								}
								else if(countItm2Menu >= 1)
								{									
									countApplMst = getCount("APPL_MST", "APP_NAME", applicationName, conn);
									System.out.println("countApplMst=========>>["+countApplMst+"]");
									
									if(countApplMst > 0)
									{
										System.out.println("Duplicate record found for applicationName ---------");
										errCode = "VTAPPNMDUP";		
										errList.add( errCode );
										errFields.add(childNodeName.toLowerCase());
										break;
									}
								}
							}
						}
					}
					
					if(editFlag.equalsIgnoreCase("A") || editFlag.equalsIgnoreCase("E"))
					{
						if("descr".equalsIgnoreCase(childNodeName))
						{
							if(descr.trim().length() == 0 || descr.trim().equalsIgnoreCase("")) 
							{	
								System.out.println("Description found blank ---------");
								errCode = "VTDESCRBLK";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
						else if("appl_group".equalsIgnoreCase(childNodeName))
						{
							if(applicationGroup.trim().length() == 0 || applicationGroup.trim().equalsIgnoreCase("")) 
							{			
								System.out.println("Application group found blank ---------");
								errCode = "VTAPPGPBLK";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
							if(applicationGroup.trim().length() > 0 && !applicationGroup.matches("[0-9A-Za-z-]+")) 
							{ 								
								System.out.println("Special character found for Application group ---------");
								errCode = "VTAPPGPINV";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
						else if("appl_color".equalsIgnoreCase(childNodeName))
						{
							if(applicationColor.trim().length() > 0 ) 
							{
								countApplColor = getApplColorCount(applicationColor, conn);
								System.out.println("applicationColor count =========>>" + countApplColor);
								
								if(countApplColor <= 0)
								{
									System.out.println("Application color invalid ---------");
									errCode = "VTAPPCLINV";		
									errList.add( errCode );
									errFields.add(childNodeName.toLowerCase());
									break;
								}
							}
						}
						else if("appl_order".equalsIgnoreCase(childNodeName))
						{
							if(applicationOrder.trim().length() > 0 && !applicationOrder.matches("[0-9]+")) 
							{
								System.out.println("Character found for Application order ---------");
								errCode = "VTAPPLCOLR";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
					}
				}
				break;
			}//End of switch statement

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: ApplicationMasterIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);	
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : ApplicationMasterIC: wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::" + errString );
		return errString;
	}

	private String errorType(Connection conn, String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;

		System.out.println("xmlString in itemChanged ["+xmlString+"]");
		System.out.println("xmlString1 in itemChanged ["+xmlString1+"]");
		System.out.println("xmlString2  in itemChanged ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : ApplicationMasterIC: itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from ApplicationMasterIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;
		int currentFormNo = 0;
		String chgUser = "", chgTerm = "";
		StringBuffer valueXmlString;

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append(editFlag);
		
		try
		{
			conn = getConnection();
			System.out.println("@@@@@@@@@ Inside itemChanged for  ApplicationMasterIC @@@@@@@@ ");

			System.out.println("xtraParams=["+xtraParams+"]");
			/*System.out.println("editFlag---------=["+editFlag+"]");
			System.out.println("currentColumn---------=["+currentColumn+"]");
			System.out.println("hdrDataDom------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
			System.out.println("currFormDataDom------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
			System.out.println("allFormDataDom------>>["+genericUtility.serializeDom(allFormDataDom)+"]");*/
		
			chgUser = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(currentDate.getTime());	

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");

			valueXmlString.append("</editFlag>\r\n</Header>\r\n");

			switch ( currentFormNo )  
			{
			case 1:
			{
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					valueXmlString.append( "<Detail1>\r\n" );	
					valueXmlString.append( "<app_name protect = '0'><![CDATA[" ).append( "" ).append( "]]></app_name>\r\n" );
					//valueXmlString.append( "<appl_color protect = '1'><![CDATA[" ).append( "" ).append( "]]></appl_color>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append( currDate ).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUser ).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
					valueXmlString.append("</Detail1>\r\n");
				}
			} //Case 1. End
			break;
			}
			valueXmlString.append( "</Root>\r\n" );	 
		}
		catch (Exception e)
		{				
			e.printStackTrace();			

		}
		finally
		{	
			try
			{				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	
	private int getCount(String tableName, String columnName, String fieldValue, Connection conn) throws SQLException
	{
		int count = 0;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("tableName--------->>["+tableName+"] columnName=========>> ["+columnName+"] fieldValue------->> ["+fieldValue+"]");
			
			sql = "SELECT COUNT(*) FROM "+tableName+" WHERE "+columnName+" = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, fieldValue);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);	
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}	
		System.out.println("return count from getCount method --------->>["+count+"]");
		return count;
	}
	
	
	private int getApplColorCount(String applicationColor, Connection conn) throws SQLException
	{
		
		int count = 0;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT COUNT(*) FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND DESCR = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "APPL_COLOR");
			pstmt.setString(2, "W_APPL_MST");
			pstmt.setString(3, applicationColor);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);				
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (conn != null)
			{
				conn.close();
				conn = null;
			}
		}	
		System.out.println("return count from getCount--------->>["+count+"]");
		return count;
		
	}
}

