package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNR;

public class CDNRSerializer extends JsonSerializer<CDNR>
{
	final SimpleDateFormat gstFmt = new SimpleDateFormat("dd-MM-yyyy");
	@Override
	public void serialize(CDNR cdnr, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		json.writeStringField("ctin", cdnr.ctin);
		
		json.writeFieldName("nt");
        json.writeStartArray();

        for(CDNDetails cdnDetails : cdnr.cdnDetails)
        {
        	writeCDNDetails(cdnr, json, cdnDetails);
        }
        
        json.writeEndArray();
        
        json.writeEndObject();
	}
	
	private void writeCDNDetails(CDNR cdnr, JsonGenerator json, CDNDetails cdnDetails)
	{
		try
		{
			json.writeStartObject();
			
			json.writeStringField("ntty", cdnDetails.cdnNoteType);
			json.writeStringField("nt_num", cdnDetails.cdNoteNumber);
			json.writeStringField("nt_dt", gstFmt.format(cdnDetails.cdNoteDate));
			json.writeStringField("rsn", cdnDetails.reason);
			json.writeStringField("inum", cdnDetails.invoiceNumber);
			json.writeStringField("idt", gstFmt.format(cdnDetails.invoiceDate));
			
			if(cdnr.isReverseCharge)
			{
				json.writeStringField("rchrg", cdnDetails.rchrg ? "Y" : "N");
			}
			
			json.writeNumberField("val", cdnDetails.val);

            json.writeNumberField("irt", cdnDetails.irt);
            json.writeNumberField("iamt", cdnDetails.iamt);
            
        	json.writeNumberField("crt", cdnDetails.crt);
        	json.writeNumberField("camt", cdnDetails.camt);
        	
        	json.writeNumberField("srt", cdnDetails.srt);
        	json.writeNumberField("samt", cdnDetails.samt);
            
            json.writeNumberField("csrt", cdnDetails.csrt);
            json.writeNumberField("csamt", cdnDetails.csamt);
            
            if(cdnDetails.etin!=null)
            {
            	json.writeStringField("etin", cdnDetails.etin);
            }
            
			json.writeEndObject();
		}
		catch(Exception e)
		{
			System.out.println("CDNRSerializer.writecdnDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}

}
