package ibase.dashboard.sfa.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;

import org.json.simple.JSONObject;


/**
 * Session Bean implementation class RXSurvey
 */
@Stateless
public class RXSurveyEJB extends ValidatorEJB implements RXSurveyRemote, RXSurveyLocal {

    /**
     * Default constructor. 
     */
    public RXSurveyEJB() {
        // TODO Auto-generated constructor stub
    }
    
    @SuppressWarnings("unchecked")
	@Override
    public JSONObject getRXSurveyDetails(String loginId, String salesPerson, String month, String year,String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataRXSurveyWiseJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashbordUtil = null;
		
		try
		{
			System.out.println(" Inside RXSurveyEJB for Data Soruc Name ="+dataSourceName+" loginId:"+loginId+" salesPerson is =" + salesPerson +" month is =" + month +" year is =" + year);
			dashbordUtil = new DashboardUtility();
			salesPerson= dashbordUtil.getCommaSeparated(salesPerson);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			
			/*sql = " Select SP.Sales_Pers as Sales_Pers,SP.Sp_Name as Sp_Name,Max(SM.Event_Date) as Max_Event_Date, "
					+" To_Char(Max(SM.Event_Date),'YYYYMM') as YYYYMM, To_Char(Max(SM.Event_Date),'MON-YYYY') as MONYYYY, "
					+" SMI.Sales_Prod_Grp as Brand_Code,SPG.Descr as Brand,SM.Strg_Code as Doc_Code, "
					+" SC.First_Name||' '||(Case When SC.Middle_Name is null then '' else SC.Middle_Name||' ' end)||SC.Last_Name as Doc_Name, "
					+" SS.Spl_Code as Spl_Code,Spl.Descr as Spl_Descr, "
					+" FN_R_Presc_Cnt(SP.Sales_Pers,SMI.Sales_Prod_Grp,SM.Strg_Code,Max(SM.Event_Date)) as Presc_No "
					+" From Sales_Pers SP Inner join Strg_Meet SM On SM.Sales_Pers = SP.Sales_Pers "
					+" Inner join Strg_Meet_Items SMI ON SM.DCR_ID = SMI.DCR_ID And SM.Strg_Code = SMI.Strg_Code "
					+" Inner Join Sales_prod_Grp SPG On SPG.Sales_Prod_Grp = SMI.Sales_Prod_Grp Inner Join "
					+" Strg_Customer SC On SC.Sc_Code = SM.Strg_Code Inner Join "
					+" Strg_Series SS On SS.Sc_Code = SM.Strg_Code And SS.Sales_Pers = SP.Sales_Pers And SS.Cust_Type = 'D' "
					+" Inner Join Speciality Spl On Spl.Spl_Code = SS.Spl_Code "
					+" Where SP.ITEM_SER = 'OTC' And SM.STRG_TYPE = 'D' And SP.Sales_Pers IN "
					+" (select emp_code from employee start with "
					+" emp_code = (select emp_code from users where (Profile_Id = 'MR-BEM' OR Profile_Id = 'ADMIN') And code ='"+loginId+"' ) "
					+" connect by prior emp_code = report_to ) And SP.Sales_Pers in (" + salesPerson + " ) "
					+" AND to_char(SM.EVENT_DATE,'MONYYYY') = TO_CHAR(TO_DATE('"+month+"','MM'),'MON')||'"+year+"' "
					+" Group By SP.Sales_Pers, SP.Sp_Name, SMI.Sales_Prod_Grp,SPG.Descr,SM.Strg_Code, "
					+" SC.First_Name,SC.Middle_Name,SC.Last_Name,SS.Spl_Code,Spl.Descr";*/
			
			sql = " SELECT DISTINCT SMI.STRG_CODE,SM.SALES_PERS,SP.SP_NAME,SMI.SALES_PROD_GRP,SG.DESCR, " +
					" SC.FIRST_NAME,SC.MIDDLE_NAME, SC.LAST_NAME,SR.SPL_CODE, SC.LOCALITY_CODE,LC.DESCR, " +
					" SMI.PRESC_NO,SM.EVENT_DATE FROM STRG_MEET_ITEMS SMI JOIN STRG_CUSTOMER SC " +
					" ON SMI.STRG_CODE = SC.SC_CODE JOIN LOCALITY LC ON SC.LOCALITY_CODE = LC.LOCALITY_CODE " +
					" JOIN SALES_PROD_GRP SG ON SMI.SALES_PROD_GRP = SG.SALES_PROD_GRP JOIN STRG_MEET " +
					" SM ON SMI.DCR_ID = SM.DCR_ID JOIN SALES_PERS SP ON SM.SALES_PERS = SP.SALES_PERS " +
					" JOIN STRG_SERIES SR ON SMI.STRG_CODE=SR.SC_CODE WHERE SM.EVENT_DATE BETWEEN " +
					" trunc(to_date('"+month+"'||'"+year+"','MONYYYY'),'MON') " +
					" and last_day(to_date('"+month+"'||'"+year+"','MONYYYY')) " +
					" AND SP.ITEM_SER = 'OTC' AND SP.TELE_EXT IN('A','O') " +
					" AND SMI.PRESC_NO != '0' ORDER BY SM.SALES_PERS,SMI.SALES_PROD_GRP ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("sp_name", (rs.getString("sp_name")));
				rowData.put("max_event_date", (rs.getString("max_event_date")));
				rowData.put("year", (rs.getString("yyyymm")));
				rowData.put("month", (rs.getString("monyyyy")));
				rowData.put("brand_code", (rs.getString("brand_code")));
				rowData.put("brand", (rs.getString("brand")));
				rowData.put("doc_code", rs.getString("doc_code"));
				rowData.put("doc_name", rs.getString("doc_name"));		
				rowData.put("spl_code", rs.getString("spl_code"));		
				rowData.put("spl_descr", rs.getString("spl_descr"));		
				rowData.put("presc_no", rs.getString("presc_no"));		
				rawDataRXSurveyWiseJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :RXSurveyEJB :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataRXSurveyWiseJson;
		
	}
}
