package ibase.webitm.ejb.wms;

import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wms.Product;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class DDProductWizEditPosEJB
 */
@Stateless
public class DDProductWizEditPosEJB extends ValidatorEJB implements DDProductWizEditPosRemote, DDProductWizEditPosLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	
	private String loginSiteCode= "", userId= "", chgTerm = "";
	private String item_descr= "", item_code= "", item_ser= "", grp_code= "", item_type= "", phy_attrib_1= "", phy_attrib_2= "", phy_attrib_3= "",item_length= "", size_codes= "",
		item_width= "", item_height= "", price_list_dtl= "", item_gross_wt= "", item_parnt_desc= "", item_type_descr= "", item_ser_descr= "", 
		descr= "", grp_code_descr= "", site_codes= "", color_codes= "", dimension_desc= "", supp_item_dtl= "", item_barcode= "", item_category= "",
		img_path= "", sh_descr= "", long_descr= "", meta_desc= "", meta_keywords= "", meta_title= "", loc_code= "", suppCode= "", loc_type= "", loc_type_child= "", pack_size_descr= "",
		language_dtl= "", language= "", categoryId= "", tax= "",item_commodity = "", tradeMarkParent = "", tradeMarkChild = "";
	private Double pur_lead_time = 0.00; 
	//Changed by wasim on 15-07-2015 [START]
	private String deleteSkus = "",attributeSetId = "",item_parnt = "",hdrlanguage_dtl = "";
	CommonWmsUtil commonutility = new CommonWmsUtil();
	List<Integer> simpleProductIdCollection = new ArrayList<Integer>();
	int simpleProductId = 0;
	String apiSimpleUrl = commonutility.getDDSalesConfig("PROD_SIMPLE_API_URL");
	String apiConfigUrl = commonutility.getDDSalesConfig("PROD_CONFIG_API_URL");
	String apiDelSkusUrl = commonutility.getDDSalesConfig("PROD_DELETE_API_URL");
	String priceDtFormat = commonutility.getDDSalesConfig("SPE_PRICE_DT_FORMATE");
	String apiKey = commonutility.getDDSalesConfig("API_KEY");//Changed by wasim on 15-07-2015 to get apiKey for magento
	int siteCnt=0;
	String storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
	double price = 0.0;
	ArrayList<Double> parentMaxPrice = new ArrayList<Double>();
	DDProductWizPosEJB prodEjb = new DDProductWizPosEJB();
	Product objProductsChild = null;
	//Changed by samadhan on 27/07/2015 FOR magento Updation
	HashMap maxPriceMap = new HashMap();
	//Changed by Samadhan on 26/12/2015 for price list to/from date integration Start
	HashMap<String, String> minFormDate = new HashMap<String, String>();
	HashMap<String, String> maxToDate = new HashMap<String, String>();
	//Changed by Samadhan on 26/12/2015 for price list to/from date integration Emd
	PreparedStatement pstmt = null;
	ResultSet rs1 = null;
	PreparedStatement pstmtsel=null;
	ResultSet rs = null;
	//Changed by wasim on 15-07-2015 [END]
	Timestamp currDate = new Timestamp(System.currentTimeMillis());
	//Changed by Samadhan for brand,limited edition purchase stop start
	String brandCode ="",brandDescr="",ltdEdition="",stopPurchase="";
	DistCommon distComm = new DistCommon();
	//Changed by Samadhan for brand,limited edition purchase stop end
	private String taxChapChild = "", taxChapParent = ""; //Changed by wasim on 02-08-2016 for tax chapter
    /**
     * Default constructor. 
     */
    public DDProductWizEditPosEJB() 
    {
    	
    }
	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, 	String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString = "";
		loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
		userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
		chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
		
		System.out.println("PostSave Action Called:::");
		System.out.println("loginSiteCode = ["+ loginSiteCode +"]");
		try 
		{
			retString = updateItemDetails( xmlStringAll, conn );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			retString = e.getMessage();
			throw new ITMException(e);
		}
		// Changed by samadhan on 19/05/16 [start]
		finally
		{
			tradeMarkParent = "";
			tradeMarkChild = "";
			deleteSkus = "";
			attributeSetId = "";
			item_parnt = "";
			hdrlanguage_dtl = "";
			simpleProductIdCollection.clear();
			int simpleProductId = 0;
			int siteCnt=0;
			String storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
			double price = 0.0;
			parentMaxPrice.clear();
			objProductsChild = null;
			maxPriceMap.clear();
			minFormDate.clear();;
			maxToDate.clear();
		}
		// Changed by samadhan on 19/05/16 [end]
		return retString;
	}
	
	private String updateItemDetails( String xmlStringAll, Connection conn ) throws Exception 
	{
		String retString = "";
		PreparedStatement pstmtIns = null;
		boolean localConnection = false;
		boolean isError = false;
		Document dom = null;
		
		// Changed by Sneha on 04-04-2016 [Start]
		String tranId = "", itmVal = "", attVal = "", loc_type_parent = "", siteCode = "", status = "";
		HashMap<String, String> sizeMapDtl = new HashMap<String, String>();
		DDProductWizPosEJB ddProductWizEJB = new DDProductWizPosEJB();
		currDate = new Timestamp(System.currentTimeMillis());
		HashMap<String, String> itemAttrHashMap = new HashMap<String, String>();
		String skuItemDescrs = "", attrValue = "", custItemRefChild = "", custItemRefParent = "", active = "";
		// Changed by Sneha on 04-04-2016 [End]

		System.out.println("xmlStringAll::"+xmlStringAll);
		
		try 
		{
			System.out.println("<<=========Inside updateItemDetails========>>");
			dom = genericUtility.parseString(xmlStringAll);
			
			int currDetailListLength = 0;
			int	detailListLength = 0;
			Node currDetail1 = null;
			NodeList detail1List = null;
			NodeList currDetail1List = null;
			
			detail1List = dom.getElementsByTagName("Detail2");
			detailListLength = detail1List.getLength();
			
			for ( int ctr1 = 0; ctr1 < detailListLength; ctr1++ )
			{
				currDetail1 = detail1List.item(ctr1);
				currDetail1List = currDetail1.getChildNodes();
				currDetailListLength = currDetail1List.getLength();
				
				System.out.println("currDetailListLength =["+currDetailListLength+"]");
				
				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetail1List.item(i);
					String nodeName = childNode.getNodeName();
					
					if (nodeName.equalsIgnoreCase("item_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							item_parnt = item_code;//Changed by wasim on 15-07-2015
						}
						else
						{
							item_code = "";
							item_parnt = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							//Changed by samadhan on 27/07/2015
							item_parnt_desc = descr;
						}
						else
						{
							descr = "";
							item_parnt_desc = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("item_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_type = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("item_type_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_type_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_type_descr = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("item_ser"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_ser = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_ser = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("item_ser_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_ser_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_ser_descr = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("grp_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							grp_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							grp_code = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("grp_code_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							grp_code_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							grp_code_descr = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("tax"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							tax  = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							tax = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("language"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							language  = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							language = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("language_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							language_dtl = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							hdrlanguage_dtl = language_dtl;//Changed by wasim on 15-07-2015 to get header data
						}
						else
						{
							language_dtl = "";
							hdrlanguage_dtl = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("sh_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							sh_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							sh_descr = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("meta_title"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							meta_title = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							meta_title = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("meta_keywords"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							meta_keywords = checkNullAndTrim(childNode.getFirstChild().getNodeValue());

						}
						else
						{
							meta_keywords = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("meta_desc"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							meta_desc = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							meta_desc = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("img_path"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							img_path = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							img_path = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("pur_lead_time"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							pur_lead_time = Double.parseDouble(checkNullAndTrim(childNode.getFirstChild().getNodeValue()));
						}
						else
						{
							pur_lead_time = 0.0;
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							loc_code = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							loc_type_parent = loc_type;
						}
						else
						{
							loc_type = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("long_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							long_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							long_descr = "";
						}
					}
					//Changed by Samadhan for brand start
					//String brandCode ="",brandDescr="",ltdEdition="",stopPurchase="";
					else if (nodeName.equalsIgnoreCase("phy_attrib_24"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							brandCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							brandCode = "";
						}
					}
					//Changed by Samadhan for brand end
					
					// Changed by Sneha on 07-07-2016, to set parent item description in attr_value [Start]
					else if (nodeName.equalsIgnoreCase("attr_value"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							attrValue = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							attrValue = "";
						}
						//System.out.println("attrValue=======>>"+attrValue);
					}
					// Changed by Sneha on 07-07-2016, to set parent item description in attr_value [End]
					
					//Changed by wasim on 27-07-2016 to add tax chapter for child items [START]
					else if (nodeName.equalsIgnoreCase("tax_chap"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							taxChapParent = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							taxChapParent = "";
						}
					}
					//Changed by wasim on 27-07-2016 to add tax chapter for child items [END]
					
					//Changed by Sneha on 26-09-2019, to add trade mark for item parent [Start]
					else if (nodeName.equalsIgnoreCase("trade_mark"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							tradeMarkParent = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							tradeMarkParent = "";
						}
					}
					//System.out.println("tradeMarkParent ==========>>[" + tradeMarkParent + "]");
					//Changed by Sneha on 26-09-2019, to add trade mark for item parent [End]

					//Changed by Sneha on 24-10-2016, to add customer item references [Start] 
					else if (nodeName.equalsIgnoreCase("phy_attrib_4"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							custItemRefParent = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							custItemRefParent = "";
						}
					}
					//System.out.println("custItemRefParent=======>>"+custItemRefParent);
					//Changed by Sneha on 26-09-2019, to add trade mark for item parent [End]
				}
			}
			
			String sql = "UPDATE ITEM SET DESCR = ?, ITEM_SER = ?, GRP_CODE = ?, ITEM_TYPE = ?, LOC_TYPE = ?, LOC_CODE = ?, "
					+ " SH_DESCR = ?, PHY_ATTRIB_17 = ?, PHY_ATTRIB_18 = ?, PHY_ATTRIB_19 = ?, PHY_ATTRIB_20 = ?, PHY_ATTRIB_21 = ?, "
					+ " LOC_TYPE__PARENT = ?, PUR_LEAD_TIME = ?, UDF__STR1 = ?, CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ? " 
					+ " ,PHY_ATTRIB_24 = ? " //Changed by samadhan on 23/12/2015 for brand
					+ " ,TAX_CHAP = ? " //Changed by wasim on 02-08-2016 for tax chapter
					+ " ,TRADE_MARK = ? " //Changed by sneha on 27-09-2016 for trade mark
					+ " ,PHY_ATTRIB_4 = ? " //Changed by sneha on 27-09-2016 for trade mark
					+ " WHERE ITEM_CODE = ?";
			System.out.println("sh_descr = ["+ checkNullAndTrim(sh_descr) +"] img_path = ["+checkNullAndTrim(img_path)+"] long_descr = ["+checkNullAndTrim(long_descr)+"]");
			System.out.println("meta_desc = ["+ checkNullAndTrim(meta_desc) +"] meta_keywords = ["+checkNullAndTrim(meta_keywords)+"] meta_title = ["+checkNullAndTrim(meta_title)+"]");

			if (conn == null)
			{
				//Changed and Commented By Santosh on 14-06-2016 :[START]
				/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;*/
				conn = getConnection();
				//Changed and Commented By Santosh on 14-06-2016 :[end]
				localConnection = true;
			}
			conn.setAutoCommit(false);
			
			pstmtIns = conn.prepareStatement( sql );
			
			pstmtIns.setString(1, descr);
			pstmtIns.setString(2, item_ser);
			pstmtIns.setString(3, grp_code);
			pstmtIns.setString(4, item_type);
			pstmtIns.setString(5, loc_type); 
			pstmtIns.setString(6, loc_code);
			pstmtIns.setString(7, checkNullAndTrim(sh_descr));
			pstmtIns.setString(8, checkNullAndTrim(img_path));
			pstmtIns.setString(9, checkNullAndTrim(long_descr));
			pstmtIns.setString(10, checkNullAndTrim(meta_desc));
			pstmtIns.setString(11, checkNullAndTrim(meta_keywords)); 
			pstmtIns.setString(12, checkNullAndTrim(meta_title));
			pstmtIns.setString(13, loc_type);
			pstmtIns.setDouble(14, pur_lead_time);
			pstmtIns.setString(15, tax);
			pstmtIns.setString(16, chgTerm); 
			pstmtIns.setString(17, userId);
			//Changed by Samadhan on 23/12/2015 for brand start
			pstmtIns.setString(18, brandCode);//phy_attrib_24
			//Changed by Samadhan on 23/12/2015 for brand end
			pstmtIns.setString(19, taxChapParent); //Changed by wasim on 02-08-2016 for tax chapter for item parent
			pstmtIns.setString(20, tradeMarkParent); //Changed by Sneha on 27-09-2016
			pstmtIns.setString(21, custItemRefParent);	//Changed by Sneha on 28-10-2016
			pstmtIns.setString(22, item_code);
			
			pstmtIns.executeUpdate();
			pstmtIns.close(); pstmtIns = null;
			
			// Changed by Sneha on 07-07-2016, to set parent item description in attr_value [Start]
			sql = " UPDATE OBJ_ATTRIBUTE SET ATTR_VALUE = ? " +
				     " WHERE ITEM_ATTR_VAL = ? AND OBJ_NAME = 'W_ITEM' and LANGUAGES = 'EN' ";
			pstmtIns = conn.prepareStatement(sql);
			pstmtIns.setString(1, checkNullAndTrim(attrValue));
			pstmtIns.setString(2, "ITEM_CODE:"+item_code);
			pstmtIns.executeUpdate();
			pstmtIns.close(); pstmtIns = null;
			// Changed by Sneha on 07-07-2016, to set parent item description in attr_value [End]
			
			//Changed by Samadhan on 28/07/2015 Start
			String sql5="select ATTR_VALUE from OBJ_ATTRIBUTE  WHERE ITEM_ATTR_VAL = ? AND OBJ_NAME = 'W_ITEM' and LANGUAGES = 'EN'";
			pstmt = conn.prepareStatement( sql5 );
			pstmt.setString(1,"ITEM_CODE:"+item_code);
			rs1 = pstmt.executeQuery();
			if(rs1.next())
			{
				item_descr = rs1.getString(1);
			}
			pstmt.close();
			rs1.close();
			//Changed by Samadhan on 28/07/2015 End
						
			sql = " UPDATE OBJ_ATTRIBUTE SET UDF_STR1 = ?, UDF_STR2 = ?, CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ? " +
				     " WHERE ITEM_ATTR_VAL = ? AND OBJ_NAME = 'W_ITEM' and LANGUAGES = 'EN' ";
			
			pstmtIns = conn.prepareStatement(sql);
			
			//Changed by parikshit on 27 07 2015 for stop description updation start
			//pstmtIns.setString(1, descr);
			pstmtIns.setString(1, checkNullAndTrim(sh_descr));
			pstmtIns.setString(2, checkNullAndTrim(long_descr));
			pstmtIns.setString(3, chgTerm); 
			pstmtIns.setString(4, userId);
			pstmtIns.setString(5, "ITEM_CODE:"+item_code);
			//Changed by parikshit on 27 07 2015 for stop description updation End
			pstmtIns.executeUpdate();
			pstmtIns.close(); pstmtIns = null;
			
			String[] lang = language_dtl.split("\\|\\|");
			for (int i = 0; i < lang.length; i++)
			{
				String[] language = lang[i].split(":");
				
				String langShDescr = "";
				String langLngDescr = "";
				for (int j = 0; j < language.length; j++) 
				{
					if (j == 3)
						langShDescr = language[3];
					if (j == 4)
						langLngDescr = language[4];
				}
				
				sql = " UPDATE OBJ_ATTRIBUTE SET ATTR_VALUE = ?, UDF_STR1 = ?, UDF_STR2 = ? , CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ?" +
					     " WHERE ITEM_ATTR_VAL = ? AND LANGUAGES != 'EN' AND OBJ_NAME = 'W_ITEM' and LANGUAGES = ?";
				
				pstmtIns = conn.prepareStatement( sql );
				pstmtIns.setString(1, language[2]);
				pstmtIns.setString(2, langShDescr);
				pstmtIns.setString(3, langLngDescr);				
				pstmtIns.setString(4, chgTerm); 
				pstmtIns.setString(5, userId);
				pstmtIns.setString(6, "ITEM_CODE:"+item_code);
				pstmtIns.setString(7, language[0]);
				
				pstmtIns.executeUpdate();
				pstmtIns.close(); pstmtIns = null;
			}			

			Node currDetail = null;
			NodeList detail2List = null;
			NodeList currDetailList = null;
			detail2List = dom.getElementsByTagName("Detail3");
			detailListLength = detail2List.getLength();
			
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detail2List.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();

				System.out.println("currDetailListLength =["+currDetailListLength+"]");

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					String nodeName = childNode.getNodeName();

					if (nodeName.equalsIgnoreCase("item_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_code = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							descr = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("length"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_length = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_length = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("width"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_width = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_width = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("height"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_height = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_height = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("gross_weight"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_gross_wt = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_gross_wt = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("phy_attrib_1"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							phy_attrib_1 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							phy_attrib_1 = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("phy_attrib_2"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							phy_attrib_2 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							phy_attrib_2 = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("phy_attrib_3"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							phy_attrib_3 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							phy_attrib_3 = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("item_category"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_category = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_category = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("item_barcode"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_barcode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_barcode = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							// Added by Sneha on 04-04-2016 for location type [Start]
							loc_type_child = loc_type;
							// Added by Sneha on 04-04-2016 for location type [End]
						}
					}
					else if (nodeName.equalsIgnoreCase("pack_size_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							pack_size_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							pack_size_descr = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("supp_item_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							supp_item_dtl = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							supp_item_dtl = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("price_list_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							price_list_dtl = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							price_list_dtl = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("language_dtl"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							language_dtl = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							//System.out.println("language_dtl=========>>"+language_dtl);
						}
						else
						{
							language_dtl = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("tax"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							tax = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("category_descr"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							categoryId = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							categoryId = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("size_codes"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							size_codes = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							size_codes = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("loc_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							loc_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_ser"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_ser = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("pur_lead_time"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							pur_lead_time = Double.parseDouble(checkNullAndTrim(childNode.getFirstChild().getNodeValue()));
						}
					}
					else if (nodeName.equalsIgnoreCase("grp_code"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							grp_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
					else if (nodeName.equalsIgnoreCase("item_commodity"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							item_commodity = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							item_commodity = "";
						}
					}
					//Changed by Samadhan for brand,limited edition purchase stop start
					else if (nodeName.equalsIgnoreCase("usage_type"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							ltdEdition = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							ltdEdition = "";
						}
					}
					else if (nodeName.equalsIgnoreCase("catalog_no"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							stopPurchase = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							stopPurchase = "";
						}
					}
					//Changed by Samadhan for brand,limited edition purchase stop end
					
					//Changed by wasim on 27-07-2016 to add tax chapter for child items [START]
					else if (nodeName.equalsIgnoreCase("tax_chap"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							taxChapChild = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							taxChapChild = "";
						}
					}
					//Changed by wasim on 27-07-2016 to add tax chapter for child items [END]
					
					//Changed by Sneha on 26-09-2019, to add trade mark for child item [Start]
					else if (nodeName.equalsIgnoreCase("trade_mark"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							tradeMarkChild = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							tradeMarkChild = "";
						}
					}
					//Changed by Sneha on 26-09-2019, to add trade mark for child item [End]
					
					//Changed by Sneha on 28-10-2016 to add customer item ref [Start]
					else if (nodeName.equalsIgnoreCase("phy_attrib_4"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							custItemRefChild = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							custItemRefChild = "";
						}
					}
					
					else if (nodeName.equalsIgnoreCase("active"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							active = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else
						{
							active = "";
						}
					}
					//Changed by Sneha on 28-10-2016 to add customer item ref [End]
				}
				
				// Changed by Sneha on 04-04-2016 for adding new item [Start]	
				if(!"".equalsIgnoreCase(item_code))
				{
					System.out.println("Updating the item ==========>>[" + item_code + "]");
					
					String whiteSpace = "            ";
					item_code = item_code + whiteSpace.substring(0,10-item_code.length());
					System.out.println("item_code with whiteSpace is["+item_code+"]");
					// Changed by Sneha on 04-04-2016 for adding new item [End]
					
					sql = "UPDATE ITEM SET DESCR = ?, ITEM_SER = ?, GRP_CODE = ?, ITEM_TYPE = ?, LOC_TYPE = ?, "
						+ " LOC_CODE = ?, LENGTH = ?, WIDTH = ?, HEIGHT = ?, GROSS_WEIGHT = ?, PHY_ATTRIB_1 = ?, PHY_ATTRIB_2 = ?, "
						+ " PHY_ATTRIB_3 = ?, PHY_ATTRIB_23 = ?, UDF__STR2 = ?, LOC_TYPE__PARENT = ?, "
						+ " PUR_LEAD_TIME = ?, UDF__STR1 = ?, CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ?, HSN_NO = ? " 
						+ " ,PHY_ATTRIB_24 = ?, USAGE_TYPE = ?, CATALOG_NO = ? " //Changed by samadhan on 23/12/2015 for brand, limited edition,stop purchase
						+ " ,TAX_CHAP = ? " //Changed by wasim on 02/08/2016 for tax chap for child items
						+ " ,TRADE_MARK = ? " //Changed By Sneha on 27-09-2016 for adding trade mark for child item
						+ " ,PHY_ATTRIB_4 = ?, ACTIVE = ? " //Changed By Sneha on 28-10-2016 for adding  cust item ref and active for child item
						+ " WHERE ITEM_CODE = ?";
	
					pstmtIns = conn.prepareStatement( sql );
	
					pstmtIns.setString(1, descr);
					pstmtIns.setString(2, item_ser);
					pstmtIns.setString(3, grp_code);
					pstmtIns.setString(4, item_type);
					pstmtIns.setString(5, loc_type);
					pstmtIns.setString(6, loc_code);
					pstmtIns.setString(7, item_length);
					pstmtIns.setString(8, item_width);
					pstmtIns.setString(9, item_height);
					pstmtIns.setString(10, item_gross_wt);
					pstmtIns.setString(11, phy_attrib_1);
					pstmtIns.setString(12, phy_attrib_2);
					pstmtIns.setString(13, phy_attrib_3);
					pstmtIns.setString(14, item_category); 
					pstmtIns.setString(15, item_barcode);
					//pstmtIns.setString(16, size_codes); //commented by parikshit on 24/07/15 [non updatable field]
					pstmtIns.setString(16, loc_type);
					pstmtIns.setDouble(17, pur_lead_time);
					pstmtIns.setString(18, tax);
					pstmtIns.setString(19, chgTerm); 
					pstmtIns.setString(20, userId);
					pstmtIns.setString(21, item_commodity);
					//Changed by Samadhan for brand,limited edition purchase stop start
					pstmtIns.setString(22, brandCode);//phy_attrib_24
					pstmtIns.setString(23, ltdEdition);//usage_type
					pstmtIns.setString(24, stopPurchase);//cotalog_no
					//Changed by Samadhan for brand,limited edition purchase stop end
					pstmtIns.setString(25, taxChapChild); //Changed by wasim on 02-08-2016 for tax chapter for child items
					pstmtIns.setString(26, tradeMarkChild);//Changed By Sneha on 27-09-2016 for adding trade mark for child item 
					pstmtIns.setString(27, custItemRefChild);//Changed By Sneha on 28-10-2016 for adding  cust item ref for child item
					pstmtIns.setString(28, active);//Changed By Sneha on 28-10-2016 for adding  cust item ref for child item
					pstmtIns.setString(29, item_code);
	
					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;
	
					sql = " UPDATE OBJ_ATTRIBUTE SET ATTR_VALUE = ?, CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ? " +
					" WHERE ITEM_ATTR_VAL = ? AND OBJ_NAME = 'W_ITEM' and LANGUAGES = 'EN'";
	
					pstmtIns = conn.prepareStatement(sql);
					pstmtIns.setString(1, descr);
					pstmtIns.setString(2, chgTerm); 
					pstmtIns.setString(3, userId);
					pstmtIns.setString(4, "ITEM_CODE:"+item_code);
	
					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;
	
					System.out.println("language_dtl = "+language_dtl);
					String[] langDtl = language_dtl.split("\\|\\|");
					for (int i = 0; i < langDtl.length; i++)
					{
						String[] language = langDtl[i].split(":");
	
						String sql1 = " UPDATE OBJ_ATTRIBUTE SET Attr_Value=?, CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ?" +
						" WHERE item_attr_val = ? and Languages != 'EN' and OBJ_NAME = 'W_ITEM' and LANGUAGES = ? ";
						pstmtIns = conn.prepareStatement( sql1 );
	
						pstmtIns.setString(1, language[2]);
						pstmtIns.setString(2, chgTerm); 
						pstmtIns.setString(3, userId);
						pstmtIns.setString(4, "ITEM_CODE:"+item_code);
						pstmtIns.setString(5, language[0]);
	
						pstmtIns.executeUpdate();
						pstmtIns.close(); pstmtIns = null;
					}	
	
					System.out.println("pack_size_descr = "+pack_size_descr);
					String[] pack_size_desc = pack_size_descr.split(":");
	
					String sql1 = "UPDATE ITEM_LOT_PACKSIZE SET SHIPPER_SIZE = ?, LENGTH = ?, WIDTH = ?, HEIGHT = ?, GROSS_WEIGHT = ?, "
						+ " NET_WEIGHT = ?, SITE_CODE__OWN = ?,CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ? "
						+ " WHERE ITEM_CODE = ?";
	
					pstmtIns = conn.prepareStatement( sql1);
	
					pstmtIns.setString(1, pack_size_desc[0]);
					pstmtIns.setString(2, pack_size_desc[1]);
					pstmtIns.setString(3, pack_size_desc[2]);
					pstmtIns.setString(4, pack_size_desc[3]);
					pstmtIns.setString(5, pack_size_desc[4]);
					pstmtIns.setString(6, pack_size_desc[5]);
					pstmtIns.setString(7, loginSiteCode);
					pstmtIns.setString(8, chgTerm); 
					pstmtIns.setString(9, userId);
					pstmtIns.setString(10, item_code);
	
					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;
	
					System.out.println("** supp_item_desc ** : "+ supp_item_dtl);
					if(supp_item_dtl != null)
					{
						String[] supp_item_list = supp_item_dtl.split("\\|\\|");
						for (int i = 0; i < supp_item_list.length; i++)
						{
							String[] supp_item = supp_item_list[i].split(":");
							String suppFrDt = "", suppToDt = "", suppRate = "", suppPrice = "";
							for (int j = 0; j < supp_item.length; j++) 
							{
								if (j == 2)
									suppPrice = checkNullAndTrim(supp_item[2]);
								else if (j == 3)
									suppRate = checkNullAndTrim(supp_item[3]).equals("") ? "0.00" : checkNullAndTrim(supp_item[3]);
								else if (j == 4)
									suppFrDt = checkNullAndTrim(supp_item[4]);
								else if (j == 5)
									suppToDt = checkNullAndTrim(supp_item[5]);
							}
	
							if (!supp_item[0].equals("0"))
							{
								System.out.println("** supp_item[1] **\n"+ supp_item[1]);
	
								String[] suppliers = supp_item[1].split(",");
								suppCode = suppliers[0];
								System.out.println("Supplier Code in for loop = "+suppCode);
	
								for (int j = 0; j < suppliers.length; j++)
								{
									String sqlSuppItemIns = "UPDATE supplieritem SET item_code__ref = ?, item_ser = ?, pur_lead_time = ?, " +
									//Changed by Samadhan 23/05/2016 for update item parent 
									//" grp_code = ?, chg_date = SYSDATE, chg_user = ?, chg_term = ? WHERE supp_code = ? AND item_code = ? ";
									" grp_code = ?, chg_date = SYSDATE, chg_user = ?, chg_term = ?, descr = ? WHERE supp_code = ? AND item_code = ? ";
									pstmtIns = conn.prepareStatement(sqlSuppItemIns);
									//Changed by Samadhan 23/05/2016 for update item parent 
									//pstmtIns.setString(1, item_code);
									pstmtIns.setString(1, item_parnt);
									pstmtIns.setString(2, item_ser);
									pstmtIns.setDouble(3, pur_lead_time);
									pstmtIns.setString(4, grp_code);
									pstmtIns.setString(5, userId); 
									pstmtIns.setString(6, chgTerm);
									pstmtIns.setString(7, descr);
									pstmtIns.setString(8, suppliers[j]);
									pstmtIns.setString(9, item_code);
	
									pstmtIns.executeUpdate();
									pstmtIns.close(); pstmtIns = null;
								}

								int slabNo = 1; 
								double rates = 0;
								String effFrDt = "" , validUpDt = "" ;
								String  sqlPrice = " SELECT SLAB_NO, RATE, EFF_FROM, VALID_UPTO " +
								" FROM PRICELIST " +
								" WHERE ITEM_CODE = '"+item_code+"' " +
								" AND PRICE_LIST = '"+suppPrice+"' " +
								" AND SLAB_NO IN (SELECT MAX(SLAB_NO) FROM PRICELIST WHERE ITEM_CODE = '"+item_code+"' AND PRICE_LIST = '"+suppPrice+"')";
	
								pstmtIns = conn.prepareStatement(sqlPrice);
								ResultSet rs1 = pstmtIns.executeQuery();
								while (rs1.next())
								{
									slabNo = rs1.getInt(1) + 1;
									rates = rs1.getDouble(2);
									effFrDt = rs1.getString(3);
									validUpDt = rs1.getString(4);
								}
								pstmtIns.close();
								pstmtIns = null;
								rs1.close();rs1 = null;

								String fromDate = "", toDate = "";
								if(!effFrDt.equals("") && !validUpDt.equals("") )
								{
									fromDate = genericUtility.getValidDateString(
											checkNullAndTrim(effFrDt), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
									toDate = genericUtility.getValidDateString(
											checkNullAndTrim(validUpDt), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
								}
	
								
								if( !supp_item[0].equals("0") && (rates != Double.parseDouble(suppRate) || ! fromDate.equals(suppFrDt) || ! toDate.equals(suppToDt)) )
								{
									// Changed by Sneha on 29-08-2016, for VALID_UPTO date [Start]
									String effFromAppl = genericUtility.getValidDateString(checkNullAndTrim(validUpDt), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());									
									Calendar calender = Calendar.getInstance();
									java.text.SimpleDateFormat sdtf = new java.text.SimpleDateFormat( genericUtility.getApplDateFormat() );
									java.util.Date effFromCal = sdtf.parse( effFromAppl );
									
									calender.setTime( effFromCal );
									calender.add( calender.DATE, -1 );
									java.text.SimpleDateFormat  sdf =  new java.text.SimpleDateFormat( genericUtility.getDBDateFormat() );
									java.sql.Date effectFrom = java.sql.Date.valueOf( sdf.format( calender.getTime() ) );
									Timestamp effectFromTS = Timestamp.valueOf(genericUtility.getValidDateString(effectFrom.toString(), genericUtility.getDBDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");					
									System.out.println("effectFromTS ---------->>"+effectFromTS);
									// Changed by Sneha on 29-08-2016, for VALID_UPTO date [End]
									
									String sqlPricesIns1 = "UPDATE PRICELIST SET VALID_UPTO = ?, CHG_DATE = SYSDATE, CHG_USER = ?, CHG_TERM = ? " +
									" WHERE ITEM_CODE = ? AND PRICE_LIST = ?";
	
									pstmtIns = conn.prepareStatement(sqlPricesIns1);
									//pstmtIns.setTimestamp(1, currDate);
									pstmtIns.setTimestamp(1, effectFromTS);	// Changed by Sneha on 29-08-2016 for validupto date 
									pstmtIns.setString(2, userId); 
									pstmtIns.setString(3, chgTerm); 
									pstmtIns.setString(4, item_code);
									pstmtIns.setString(5, suppPrice);
	
									pstmtIns.executeUpdate();
									pstmtIns.close(); pstmtIns = null;	
	
									String sqlPricesIns = "INSERT INTO PRICELIST(PRICE_LIST, ITEM_CODE, UNIT, LIST_TYPE, SLAB_NO, RATE, " +
									" EFF_FROM, VALID_UPTO, LOT_NO__FROM, LOT_NO__TO, MIN_QTY, MAX_QTY, " +
									" RATE_TYPE, MIN_RATE, MAX_RATE, CHG_DATE, CHG_USER, CHG_TERM ) " +
									" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	
									pstmtIns = conn.prepareStatement(sqlPricesIns);
	
									String dtFrom = "", dtTo = "";
									if(!suppFrDt.equals("") && !suppToDt.equals("") )
									{
										dtFrom = genericUtility.getValidDateTimeString( checkNullAndTrim(suppFrDt), 
												genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
	
										dtTo = genericUtility.getValidDateTimeString( checkNullAndTrim(suppToDt), 
												genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
									}
	
									pstmtIns.setString(1, suppPrice);
									pstmtIns.setString(2, item_code);
									pstmtIns.setString(3, "NO");
									pstmtIns.setString(4, "L");
									pstmtIns.setInt(5, slabNo);
									pstmtIns.setString(6, suppRate);
									pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(dtFrom));
									pstmtIns.setTimestamp(8, java.sql.Timestamp.valueOf(dtTo));
									pstmtIns.setString(9, "00");
									pstmtIns.setString(10, "ZZ");
									pstmtIns.setString(11, "0");
									pstmtIns.setString(12, "999999");
									pstmtIns.setString(13, "F");
									pstmtIns.setString(14, suppRate);
									pstmtIns.setString(15, suppRate);
									pstmtIns.setTimestamp(16, currDate);
									pstmtIns.setString(17, userId); 
									pstmtIns.setString(18, chgTerm); 
	
									pstmtIns.executeUpdate();
									pstmtIns.close(); pstmtIns = null;
								}
								
							}
						}
					}
	
					System.out.println("** price_list_dtl ** : "+ price_list_dtl);
					if(price_list_dtl != null)
					{
						String[] price_list = price_list_dtl.split("\\|\\|");
						for (int k = 0; k < price_list.length; k++)
						{
							String[] site_list = price_list[k].split(":");
							String siteFrDt = "", siteToDt = "", siteRate = "", sitePrice = "";
							for (int j = 0; j < site_list.length; j++) 
							{
								if (j == 2)
									sitePrice = checkNullAndTrim(site_list[2]);
								else if (j == 3)
									siteRate = checkNullAndTrim(site_list[3]).equals("") ? "0.00" : checkNullAndTrim(site_list[3]);
								else if (j == 5)
									siteFrDt = checkNullAndTrim(site_list[5]);
								else if (j == 6)
									siteToDt = checkNullAndTrim(site_list[6]);
							}
							if (!site_list[0].equals("0"))
							{
								String sqlSiteIns = " UPDATE SITEITEM SET ITEM_CODE = ?, PUR_LEAD_TIME = ?,  " +
								" ITEM_SER = ?,CHG_DATE = SYSDATE, CHG_USER = ?, CHG_TERM = ?, loc_code__aprv = ? " +
								" WHERE ITEM_CODE = ? and SITE_CODE = ?";			
	
								pstmtIns = conn.prepareStatement(sqlSiteIns);
	
								pstmtIns.setString(1, item_code);
								pstmtIns.setDouble(2, pur_lead_time); 
								pstmtIns.setString(3, item_ser);
								pstmtIns.setString(4, userId); 
								pstmtIns.setString(5, chgTerm); 
								pstmtIns.setString(6, loc_code);
								pstmtIns.setString(7, item_code);
								pstmtIns.setString(8, site_list[1]);
	
								pstmtIns.executeUpdate();
								pstmtIns.close(); pstmtIns = null;
	
								int slabNos = 1 ;
								double rate = 0 ;
								String effFrDts = "" , validUpDts = "" ;
								String sqlPrices = " SELECT SLAB_NO, RATE, EFF_FROM, VALID_UPTO " +
								" FROM PRICELIST WHERE ITEM_CODE = '"+item_code+"' " +
								" AND PRICE_LIST = '"+sitePrice+"' " +
								" AND SLAB_NO IN (SELECT MAX(SLAB_NO) FROM PRICELIST WHERE ITEM_CODE = '"+item_code+"' AND PRICE_LIST = '"+sitePrice+"')";
	
								pstmtIns = conn.prepareStatement(sqlPrices);
								ResultSet rs1 = pstmtIns.executeQuery();
								while (rs1.next())
								{
									slabNos = rs1.getInt(1) + 1;
									rate = rs1.getDouble(2);
									effFrDts = rs1.getString(3);
									validUpDts = rs1.getString(4);
								}
								pstmtIns.close();
								pstmtIns = null;
								rs1.close();rs1 = null;
	
								String fromDt = "", toDate = "";
								if(!effFrDts.equals("") && !validUpDts.equals("") )
								{
									fromDt = genericUtility.getValidDateString(
											checkNullAndTrim(effFrDts), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
									toDate = genericUtility.getValidDateString(
											checkNullAndTrim(validUpDts), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
								}
	
								if( !site_list[0].equals("0") && (rate != Double.parseDouble(siteRate) || ! fromDt.equals(siteFrDt) || ! toDate.equals(siteToDt)) )
								{
									String sqlPricesIns1 = "UPDATE PRICELIST SET VALID_UPTO = ?, CHG_DATE = SYSDATE, CHG_USER = ?, CHG_TERM = ? " +
									" WHERE ITEM_CODE = ? AND PRICE_LIST = ?";
	
									pstmtIns = conn.prepareStatement(sqlPricesIns1);
									pstmtIns.setTimestamp(1, currDate);
									pstmtIns.setString(2, userId); 
									pstmtIns.setString(3, chgTerm); 
									pstmtIns.setString(4, item_code);
									pstmtIns.setString(5, sitePrice);
	
									pstmtIns.executeUpdate();
									pstmtIns.close(); pstmtIns = null;	
	
									String dtFrom = "", dtTo ="";
									if (!siteFrDt.equals("") && !siteToDt.equals(""))
									{
										dtFrom = genericUtility.getValidDateTimeString( checkNullAndTrim(siteFrDt), 
												genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
	
										dtTo = genericUtility.getValidDateTimeString( checkNullAndTrim(siteToDt), 
												genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
									}
	
									String sqlPricesIn = "insert into PRICELIST(PRICE_LIST, ITEM_CODE, UNIT, LIST_TYPE, SLAB_NO, RATE, " +
									" EFF_FROM, VALID_UPTO, LOT_NO__FROM, LOT_NO__TO, min_qty, max_qty, " +
									" rate_type, min_rate, max_rate, CHG_DATE, CHG_USER, CHG_TERM ) " +
									" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	
									pstmtIns = conn.prepareStatement(sqlPricesIn);
	
									pstmtIns.setString(1, checkNullAndTrim(sitePrice));
									pstmtIns.setString(2, item_code);
									pstmtIns.setString(3, "NO");
									pstmtIns.setString(4, "L");
									pstmtIns.setInt(5, slabNos);
									pstmtIns.setString(6, checkNullAndTrim(siteRate));
									pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(dtFrom));
									pstmtIns.setTimestamp(8, java.sql.Timestamp.valueOf(dtTo));
									pstmtIns.setString(9, "00");
									pstmtIns.setString(10, "ZZ");
									pstmtIns.setString(11, "0");
									pstmtIns.setString(12, "999999");
									pstmtIns.setString(13, "F");
									pstmtIns.setString(14, checkNullAndTrim(siteRate));
									pstmtIns.setString(15, checkNullAndTrim(siteRate));
									pstmtIns.setTimestamp(16, currDate);
									pstmtIns.setString(17, userId); 
									pstmtIns.setString(18, chgTerm); 
	
									pstmtIns.executeUpdate();
									pstmtIns.close(); pstmtIns = null;
								}
							}
						}//ENd Detail 3 loop	
					}
					//Changed By Samadhan on 30/07/2015 for change loop location Start
					
				// Changed by Sneha on 04-04-2016, for inserting new item [Start]	
				}
				else
				{
					System.out.println("--------- Adding new item ---------");

					// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
					//tranId = getTransID( "w_dd_productWiz", conn);
					sizeMapDtl =  ddProductWizEJB.getSizeMap(phy_attrib_1, size_codes, conn);
					String phy_attrib_6 = sizeMapDtl.get("DESCR");
					tranId = getTransID( "w_dd_productWiz", item_parnt, phy_attrib_6, phy_attrib_2, conn);
					// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]
					
					// Changed by samadhan on 19/05/16 [start]
					String whiteSpace = "            ";
					tranId = tranId + whiteSpace.substring(0,10-tranId.length());
					System.out.println("tranId with whiteSpace is["+tranId+"]");
					// Changed by samadhan on 19/05/16 [end]
					//sizeMapDtl =  ddProductWizEJB.getSizeMap(phy_attrib_1, size_codes, conn);
					
					
					// Changed by Sneha on 16-12-2016, for barcode auto generation [Start]
					DDProductWizEJB ddProductWiz = new DDProductWizEJB();
					String barcodeFlagVal = ddProductWiz.getDefaultBarcodeFlagVal();
					if(barcodeFlagVal.equalsIgnoreCase("Y"))
					{
						int paramName = 0;
						item_barcode = ddProductWiz.generateTranId( "w_barcode", loginSiteCode, conn);
						
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(udf__str2) = ? ";
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, item_barcode);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						System.out.println("2222222222222222222");
						if (paramName != 0) 
						{
							System.out.println("6666666666666666666666666");
							isError = true;
							String errMsg = "Invalid barcode generated. Generated Barcode already exists in item master.";
							throw new Exception(errMsg);
						}
			       
					}
					// Changed by Sneha on 16-12-2016, for barcode auto generation [End]
					
					sql = "INSERT INTO ITEM (ITEM_CODE, DESCR, ITEM_PARNT, ITEM_SER, GRP_CODE, ITEM_TYPE, UNIT, TRACK_SHELF_LIFE, UNIT__RATE, " +
					" STK_OPT, LOC_TYPE, LOC_CODE, LENGTH, WIDTH, HEIGHT, GROSS_WEIGHT, " +
					" PHY_ATTRIB_1, PHY_ATTRIB_2, PHY_ATTRIB_3, INTEGRAL_QTY, ISS_CRITERIA, UNIT__PUR, " +
					" PHY_ATTRIB_23, UDF__STR2, ACTIVE, PHY_ATTRIB_22, SUPP_SOUR, QC_REQD, PACK_CODE, " +
					" ORDER_OPT, ITEM_USAGE, AUTO_REQC, LOC_TYPE__PARENT, CHG_DATE, CHG_TERM, CHG_USER,PUR_LEAD_TIME,UDF__STR1,HSN_NO,PHY_ATTRIB_6," +
					" USAGE_TYPE,PHY_ATTRIB_24,PHY_ATTRIB_8,CATALOG_NO,TAX_CHAP," + //Changed by wasim on 02-08-2016 to add tax chapter for new child item
					" PO_RATE_OPTION, " + // Added by Manish on 21-09-2016 as per devendra sir
					" TRADE_MARK " +    // Changed By Sneha on 27-09-2016 for adding trade mark for child item 
					" ,PHY_ATTRIB_4) " +    // Changed By Sneha on 27-09-2016 for adding trade mark for child item 
					" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; 
					pstmtIns = conn.prepareStatement( sql );
					pstmtIns.setString(1, tranId); 
					pstmtIns.setString(2, descr); 
					pstmtIns.setString(3, item_parnt); 
					pstmtIns.setString(4, item_ser);
					pstmtIns.setString(5, grp_code);	
					pstmtIns.setString(6, item_type);	
					pstmtIns.setString(7, "NO");
					pstmtIns.setString(8, "N");
					pstmtIns.setString(9, "NO");
					pstmtIns.setString(10, "1");
					pstmtIns.setString(11, loc_type_child); 
					pstmtIns.setString(12, loc_code);         
					pstmtIns.setString(13, item_length);
					pstmtIns.setString(14, item_width);
					pstmtIns.setString(15, item_height);
					pstmtIns.setString(16, item_gross_wt);
					pstmtIns.setString(17, phy_attrib_1);
					pstmtIns.setString(18, phy_attrib_2);
					pstmtIns.setString(19, phy_attrib_3);
					pstmtIns.setString(20, "1");
					pstmtIns.setString(21, "I"); 
					pstmtIns.setString(22, "NO");
					pstmtIns.setString(23, item_category); 
					pstmtIns.setString(24, item_barcode);
					//pstmtIns.setString(25, "Y");
					pstmtIns.setString(25, active);	// Change by Sneha on 28-10-2016, for active
					pstmtIns.setString(26, size_codes); 
					pstmtIns.setString(27, "P");
					pstmtIns.setString(28, "N"); 
					pstmtIns.setString(29, "NO");
					pstmtIns.setString(30, "C");
					pstmtIns.setString(31, "NA");
					pstmtIns.setString(32, "N");
					pstmtIns.setString(33, loc_type_parent);        
					pstmtIns.setTimestamp(34, currDate);
					pstmtIns.setString(35, chgTerm); 
					pstmtIns.setString(36, userId);
					pstmtIns.setDouble(37, pur_lead_time);  
					pstmtIns.setString(38, tax);
					pstmtIns.setString(39, item_commodity);
					pstmtIns.setString(40, sizeMapDtl.get("DESCR"));
					pstmtIns.setString(41, ltdEdition);
					pstmtIns.setString(42, brandCode);
					pstmtIns.setString(43, sizeMapDtl.get("SH_DESCR"));
					pstmtIns.setString(44, stopPurchase);
					pstmtIns.setString(45, taxChapChild);//Added by wasim on 02-08-2016 to add tax chapter for child items
					pstmtIns.setString(46, "A"); //Added by Manish on 21-08-2016
					pstmtIns.setString(47, tradeMarkChild);//Changed By Sneha on 27-09-2016 for adding trade mark for child item 
					pstmtIns.setString(48, custItemRefChild);//Changed By Sneha on 27-09-2016 for adding trade mark for child item 
					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;
					
					// Pack Details
					System.out.println("** pack_size_dtl----- **\n"+ pack_size_descr);
					String pack_list[] = pack_size_descr.split(":");
					
					
					String sqlpacksize = "INSERT INTO  ITEM_LOT_PACKSIZE (SHIPPER_SIZE, LENGTH, WIDTH, HEIGHT, GROSS_WEIGHT, NET_WEIGHT, LOT_NO__FROM, " 
							+ " LOT_NO__TO,UNIT__PACK,UNIT__INNER_LABEL, SITE_CODE__OWN,ITEM_CODE, CHG_DATE, CHG_TERM, CHG_USER) " 
							+ "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmtIns = conn.prepareStatement(sqlpacksize);
					pstmtIns.setString(1, pack_list[0]);
					pstmtIns.setString(2, pack_list[1]);
					pstmtIns.setString(3, pack_list[2]);
					pstmtIns.setString(4, pack_list[3]);
					pstmtIns.setString(5, pack_list[4]);
					pstmtIns.setString(6, pack_list[5]);
					pstmtIns.setString(7, "00");
					pstmtIns.setString(8, "ZZ");
					pstmtIns.setString(9, "NO");
					pstmtIns.setString(10, "NO");
					pstmtIns.setString(11, loginSiteCode);
					pstmtIns.setString(12, tranId);
					pstmtIns.setTimestamp(13, currDate);
					pstmtIns.setString(14, chgTerm);
					pstmtIns.setString(15, userId);
					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;

					
					String sqlselt	= "SELECT (ITEM_ATTR_VAL||':'||LANGUAGES)As LANG_DET, ATTR_VALUE FROM OBJ_ATTRIBUTE WHERE OBJ_NAME = 'W_ITM_ATTRIB_VAL'"+
					"AND ( ITEM_ATTR_VAL LIKE 'COLOR:%' OR ITEM_ATTR_VAL LIKE 'DIMENSION:%' OR ITEM_ATTR_VAL LIKE 'SIZE:%' ) ORDER BY ITEM_ATTR_VAL, LANGUAGES";					
					pstmt = conn.prepareStatement(sqlselt);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						itmVal = rs.getString(1);
						attVal = rs.getString(2);
						itemAttrHashMap.put(itmVal, attVal);
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;
					
					String colors = checkNullAndTrim(itemAttrHashMap.get("COLOR:"+ phy_attrib_2 + ":" + "EN"));
					String dimensions = checkNullAndTrim(itemAttrHashMap.get("DIMENSION:"+ phy_attrib_3 + ":" + "EN"));
					String sizes = checkNullAndTrim(itemAttrHashMap.get("SIZE:" + phy_attrib_1 + ":" + "EN"));
					skuItemDescrs = checkNullAndTrim(descr + " " + colors.trim() + " " + dimensions.trim() + " " + sizes.trim());
					
					System.out.println("** language_dtl-------- **\n" + language_dtl);
					String sqllangdtlItemInsEn = "INSERT INTO OBJ_ATTRIBUTE (OBJ_NAME, ITEM_ATTR_VAL, COLUMN_NAME, LANGUAGES, ATTR_VALUE, UDF_STR1, UDF_STR2, CHG_DATE, CHG_USER, CHG_TERM)"
							+ " VALUES(?,?,?,?,?,?,?,?,?,?)";
					pstmtIns = conn.prepareStatement(sqllangdtlItemInsEn);
					pstmtIns.setString(1, "W_ITEM");
					pstmtIns.setString(2, "ITEM_CODE:" + tranId);
					pstmtIns.setString(3, "ITEM_CODE");
					pstmtIns.setString(4, "EN");
					pstmtIns.setString(5, skuItemDescrs);
					pstmtIns.setString(6, "");
					pstmtIns.setString(7, "");
					pstmtIns.setTimestamp(8, currDate);
					pstmtIns.setString(9, userId);
					pstmtIns.setString(10, chgTerm);
					pstmtIns.executeUpdate();
					pstmtIns.close(); pstmtIns = null;
					
					String[] language_dtl_list = language_dtl.split("\\|\\|");
					
					String skuItemDescr = "";
					String color = "";
					String dimension = "";
					String size = "";
					for (int i = 0; i < language_dtl_list.length; i++) 
					{
						lang = language_dtl_list[i].split(":");
						
						System.out.println("lang[0]---------" + lang[0]);
						System.out.println("lang[2]---------" + lang[1]);
						if (!lang[0].equals("0"))
						{
							color = checkNullAndTrim(itemAttrHashMap.get("COLOR:"+ phy_attrib_2 + ":" + lang[0]));
							dimension = checkNullAndTrim(itemAttrHashMap.get("DIMENSION:"+ phy_attrib_3 + ":" + lang[0]));
							size = checkNullAndTrim(itemAttrHashMap.get("SIZE:" + phy_attrib_1 + ":" + lang[0]));
							
							skuItemDescr = checkNullAndTrim(lang[1]) + " " + color.trim() + " " + dimension.trim() + " " + size.trim();
							
							String sqllangdtlItemIns = "INSERT INTO OBJ_ATTRIBUTE (OBJ_NAME, ITEM_ATTR_VAL, COLUMN_NAME, LANGUAGES, ATTR_VALUE, UDF_STR1, UDF_STR2, CHG_DATE, CHG_USER, CHG_TERM)"
									+ " VALUES(?,?,?,?,?,?,?,?,?,?)";
							pstmtIns = conn.prepareStatement(sqllangdtlItemIns);
							pstmtIns.setString(1, "W_ITEM");
							pstmtIns.setString(2, "ITEM_CODE:" + tranId);
							pstmtIns.setString(3, "ITEM_CODE");
							pstmtIns.setString(4, checkNullAndTrim(lang[0]));
							pstmtIns.setString(5, skuItemDescr);
							pstmtIns.setString(6, "");
							pstmtIns.setString(7, "");
							pstmtIns.setTimestamp(8, currDate);
							pstmtIns.setString(9, userId);
							pstmtIns.setString(10, chgTerm);
		
							pstmtIns.executeUpdate();
							pstmtIns.close(); pstmtIns = null;
						}	             		
					}

	                System.out.println("** supp_item_desc **\n"+ supp_item_dtl);
					String[] supp_item_list = supp_item_dtl.split("\\|\\|");
					
					for (int i = 0; i < supp_item_list.length; i++)
					{
						String[] supp_item = supp_item_list[i].split(":");
						
						if (!supp_item[0].equals("0"))
						{
							System.out.println("** supp_item[1] **\n"+ supp_item[1]);
							
							String[] suppliers = supp_item[1].split(",");
							suppCode = suppliers[0];							
							System.out.println("Supplier Code in for loop = "+suppCode);
							
							for (int j = 0; j < suppliers.length; j++)
							{
								String sqlSuppItemIns = "INSERT INTO SUPPLIERITEM (SUPP_CODE, ITEM_CODE, ITEM_CODE__REF, UNIT, ITEM_SER, PUR_LEAD_TIME, " +
										" GRP_CODE, CHG_DATE, CHG_USER, CHG_TERM" +
										" ,DESCR)" +//Changed by Samadhan on 23/05/2016 for insert SKU Description.
										" VALUES(?,?,?,?,?,?,?,?,?,?,?)";
								pstmtIns = conn.prepareStatement(sqlSuppItemIns);
								pstmtIns.setString(1, checkNullAndTrim(suppliers[j]));
								pstmtIns.setString(2, tranId);
								//Changed by Samadhan on 23/05/2016 for insert product id.
								//pstmtIns.setString(3, tranId);
								pstmtIns.setString(3, item_parnt);
								pstmtIns.setString(4, "NO");
								pstmtIns.setString(5, item_ser);
								pstmtIns.setDouble(6, pur_lead_time); 
								pstmtIns.setString(7, grp_code);
								pstmtIns.setTimestamp(8, currDate);
								pstmtIns.setString(9, userId); 
								pstmtIns.setString(10, chgTerm);
								pstmtIns.setString(11, descr);//Changed by Samadhan on 23/05/2016 for insert SKU Description.
								pstmtIns.executeUpdate();
								pstmtIns.close(); pstmtIns = null;
							}
							
							String sqlPricesIns = "INSERT INTO PRICELIST(PRICE_LIST, ITEM_CODE, UNIT, LIST_TYPE, SLAB_NO, RATE, " +
									" EFF_FROM, VALID_UPTO, LOT_NO__FROM, LOT_NO__TO, min_qty, max_qty, " +
									" rate_type, min_rate, max_rate, CHG_DATE, CHG_USER, CHG_TERM ) " +
									" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
							pstmtIns = conn.prepareStatement(sqlPricesIns);
							
							String dtFrom = genericUtility.getValidDateTimeString( checkNullAndTrim(supp_item[4]), 
									genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
							
							String dtTo = genericUtility.getValidDateTimeString( checkNullAndTrim(supp_item[5]), 
									genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
							
							pstmtIns.setString(1, supp_item[2]);
							pstmtIns.setString(2, tranId);
							pstmtIns.setString(3, "NO");
							pstmtIns.setString(4, "L");
							pstmtIns.setString(5, "1");
							pstmtIns.setString(6, supp_item[3]);
							pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(dtFrom));
							pstmtIns.setTimestamp(8, java.sql.Timestamp.valueOf(dtTo));
							pstmtIns.setString(9, "00");
							pstmtIns.setString(10, "ZZ");
							pstmtIns.setString(11, "0");
							pstmtIns.setString(12, "999999");
							pstmtIns.setString(13, "F");
							pstmtIns.setString(14, supp_item[3]);
							pstmtIns.setString(15, supp_item[3]);
							pstmtIns.setTimestamp(16, currDate);
							pstmtIns.setString(17, userId); 
							pstmtIns.setString(18, chgTerm); 
							pstmtIns.executeUpdate();
							pstmtIns.close(); pstmtIns = null;
						}
					}


					System.out.println("** price_list_dtl **\n" + price_list_dtl);
					String[] price_list = price_list_dtl.split("\\|\\|");
					ArrayList<String> siteList = new ArrayList<String>();
					
					for (int i = 0; i < price_list.length; i++) 
					{
						String[] site_list = price_list[i].split(":");
						siteList.add(site_list[1].trim());
						
						if (!site_list[0].equals("0"))
						{
							String dtFrom = genericUtility.getValidDateTimeString(
									checkNullAndTrim(site_list[5]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

							String dtTo = genericUtility.getValidDateTimeString(
									checkNullAndTrim(site_list[6]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
							//priceListInsert(siteCode, price_list_dtl, tranId, conn);
							String sqlPricesIns = "INSERT INTO PRICELIST(PRICE_LIST, ITEM_CODE, UNIT, LIST_TYPE, SLAB_NO, RATE, "
								+ " EFF_FROM, VALID_UPTO, LOT_NO__FROM, LOT_NO__TO, MIN_QTY, MAX_QTY, "
								+ " RATE_TYPE, MIN_RATE, MAX_RATE, CHG_DATE, CHG_USER, CHG_TERM ) "
								+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
							pstmtIns = conn.prepareStatement(sqlPricesIns);
							pstmtIns.setString(1, checkNullAndTrim(site_list[2]));
							pstmtIns.setString(2, tranId);
							pstmtIns.setString(3, "NO");
							pstmtIns.setString(4, "L");
							pstmtIns.setString(5, "1");
							pstmtIns.setString(6, checkNullAndTrim(site_list[3]));
							pstmtIns.setTimestamp(7, java.sql.Timestamp.valueOf(dtFrom));
							pstmtIns.setTimestamp(8, java.sql.Timestamp.valueOf(dtTo));
							pstmtIns.setString(9, "00");
							pstmtIns.setString(10, "ZZ");
							pstmtIns.setString(11, "0");
							pstmtIns.setString(12, "999999");
							pstmtIns.setString(13, "F");
							pstmtIns.setString(14, checkNullAndTrim(site_list[3]));
							pstmtIns.setString(15, checkNullAndTrim(site_list[3]));
							pstmtIns.setTimestamp(16, currDate);
							pstmtIns.setString(17, userId);
							pstmtIns.setString(18, chgTerm);
							pstmtIns.executeUpdate();
							pstmtIns.close();
							pstmtIns = null;
						}
					}
					String sqlPriceSite = " SELECT SITE_CODE FROM SITE ";
					pstmt = conn.prepareStatement(sqlPriceSite);
					rs = pstmt.executeQuery();
					while (rs.next()) 
					{
						siteCode = rs.getString(1);

						String sqlSiteIns = "INSERT INTO SITEITEM (SITE_CODE, ITEM_CODE, MIN_QTY, MAX_QTY, REO_QTY, REO_LEV, "
								+ " PUR_LEAD_TIME, STK_OPT, ITEM_SER, ACTIVE, CHG_DATE, CHG_USER, CHG_TERM , LOC_CODE__APRV, "
								+ " SUPP_SOUR ) "	// Added by Sneha on 21-11-2016
								//change by sarita ? missing 09-03-2017
								//+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
						        + " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";

						if (siteList.contains(siteCode.trim())) 
						{
							System.out.println("Inside if for insert into site item ------------ ");
							status = "Y";								
						}
						else
						{
							status = "N";
						}
						pstmtIns = conn.prepareStatement(sqlSiteIns);
						pstmtIns.setString(1, checkNullAndTrim(siteCode));
						pstmtIns.setString(2, tranId);
						pstmtIns.setString(3, "0");
						pstmtIns.setString(4, "99999");
						pstmtIns.setString(5, "0");
						pstmtIns.setString(6, "0");
						pstmtIns.setDouble(7, pur_lead_time); 
						pstmtIns.setString(8, "1");
						pstmtIns.setString(9, item_ser);
						pstmtIns.setString(10, status);
						pstmtIns.setTimestamp(11, currDate);
						pstmtIns.setString(12, userId);
						pstmtIns.setString(13, chgTerm);
						pstmtIns.setString(14, loc_code);
						pstmtIns.setString(15, "P"); // Change by Sneha on date 21-11-2013
						
						pstmtIns.executeUpdate();
						pstmtIns.close();
						pstmtIns = null;
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					
					item_code = tranId;
					System.out.println("item_code ---------- " + item_code);
					
				}
				// Changed by Sneha on 04-04-2016, for inserting new item [End]
				
				//Changed by wasim on 14-07-2015 [START]
				System.out.println("@@Language="+hdrlanguage_dtl);
				String[] language_dtl_list = hdrlanguage_dtl.split("\\|\\|");
				String[] price_list = price_list_dtl.split("\\|\\|");

				siteCode = "";
				String sqlPriceSite = " SELECT SITE_CODE FROM SITE ";
				PreparedStatement pstmtSel=null;
				pstmtSel = conn.prepareStatement(sqlPriceSite);
				ResultSet rs1 = pstmtSel.executeQuery();

				siteCnt=0;
				storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
				double adminPrice = 0.0;
				String adminSite = commonutility.getDDSalesConfig("PRODUCT_ADMIN_SITE");
				
				while (rs1.next()) 
				{
					siteCode = rs1.getString(1);
					siteCnt++;
					String operatingLang="";
					boolean flag = false;
					operatingLang = prodEjb.getOperatingLang(siteCode.trim(),conn);
					price = 0.0;
					//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento Start
					String dateFrom ="";
					String dateTo="";
					String  specialPriceFrom="";
					String specialPriceTo="";
					//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento Start
					
					System.out.println("@@My Length="+price_list.length);

					for (int i = 0; i < price_list.length; i++) 
					{
						String []site_list = price_list[i].split(":");
						System.out.println("@@My List="+site_list[1]+"Site Code="+siteCode);
						if(site_list[1].trim().equalsIgnoreCase(siteCode.trim()))
						{
							System.out.println("@@SiteList3["+site_list[3]+"]");
							price = Double.parseDouble((site_list[3]==null||site_list[3].equals(""))?"0":site_list[3].trim());
							//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento Start
							dateFrom = checkNullAndTrim(site_list[5]);
							dateTo = checkNullAndTrim(site_list[6]);
							if(!(dateFrom.length()==0))
							{
								specialPriceFrom = genericUtility.getValidDateString(dateFrom,genericUtility.getApplDateFormat(), priceDtFormat);
							}
							if(!(dateTo.length()==0))
							{
								specialPriceTo = genericUtility.getValidDateString(dateTo,genericUtility.getApplDateFormat(), priceDtFormat);
							}
							System.out.println("date From:["+dateFrom+"] dateTo:["+dateTo+"]");
							System.out.println("SpecialPriceFrom:["+specialPriceFrom+"] SpecialPriceTo:["+specialPriceTo+"]");
							//Changed by Samadhan on 25/12/2015 for integrate price to/from with megento End
						}

					}	
					System.out.println("@@My Price="+price);
					System.out.println("@@Language Lenght="+language_dtl_list.length);
					for (int j = 0; j < language_dtl_list.length; j++) 
					{
						lang = language_dtl_list[j].split(":");
						System.out.println("@@ MyLang="+lang[0]);
						System.out.println("@@ OpLang="+operatingLang);
						if(operatingLang.equalsIgnoreCase(adminSite))
						{
							adminPrice = price;
						}
						if(operatingLang.equalsIgnoreCase(lang[0]))
						{
							System.out.println("@@ MyLang2="+lang[2]);
							//Changed by samadhan Start
							String sDescr = "";
							String lDescr = "";
							try
							{
								sDescr = lang[3];
							}catch(Exception e)
							{}
							try
							{
								lDescr = lang[4];
							}catch(Exception e)
							{}
							//Changed by samadhan End
							System.out.println("@@ MyLang3="+sDescr);
							System.out.println("@@ MyLang4="+lDescr);

							storeInfo = storeInfo +	"<store>		" ;
							storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
							storeInfo = storeInfo + "<product_id><![CDATA["+item_code+"]]></product_id>		" ;
							storeInfo = storeInfo + "<name><![CDATA["+lang[2]+"]]></name>		" ;
							storeInfo = storeInfo + "<short_desc><![CDATA["+sDescr+"]]></short_desc>		";
							storeInfo = storeInfo + "<long_desc><![CDATA["+lDescr+"]]></long_desc>		";
							storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
							//Changed by Samadhan on 29/12/2015 for special price start
							storeInfo = storeInfo + "<specialPrice><![CDATA["+price+"]]></specialPrice>	";
							storeInfo = storeInfo + "<specialPriceFrom><![CDATA["+specialPriceFrom+"]]></specialPriceFrom>	";
							storeInfo = storeInfo + "<specialPriceTo><![CDATA["+specialPriceTo+"]]></specialPriceTo>	";
							//Changed by Samadhan on 29/12/2015 for special price end
							storeInfo = storeInfo + "</store>";
							parentMaxPrice.add(price);
							flag=true;
							break;
						}
					}
					if(!flag)
					{
						storeInfo = storeInfo +	"<store>	 	" ;
						storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
						storeInfo = storeInfo + "<product_id><![CDATA["+item_code+"]]></product_id>		" ;
						storeInfo = storeInfo + "<name><![CDATA["+item_descr+"]]></name>		" ;
						storeInfo = storeInfo + "<short_desc><![CDATA["+sh_descr+"]]></short_desc>		";
						storeInfo = storeInfo + "<long_desc><![CDATA["+long_descr+"]]></long_desc>		";
						storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
						//Changed by Samadhan on 29/12/2015 for special price start
						storeInfo = storeInfo + "<specialPrice><![CDATA["+price+"]]></specialPrice>	";
						storeInfo = storeInfo + "<specialPriceFrom><![CDATA["+specialPriceFrom+"]]></specialPriceFrom>	";
						storeInfo = storeInfo + "<specialPriceTo><![CDATA["+specialPriceTo+"]]></specialPriceTo>	";
						//Changed by Samadhan on 29/12/2015 for special price end
						storeInfo = storeInfo + "</store>";
						parentMaxPrice.add(price);
					}
					//Changed by samadhan on 27/07/2015 Start
					if(maxPriceMap.containsKey(operatingLang.toLowerCase()))
					{
						if((Double)maxPriceMap.get(operatingLang.toLowerCase())<price)
						{
							maxPriceMap.put(operatingLang.toLowerCase(), price);
						}
					}
					else
					{
						maxPriceMap.put(operatingLang.toLowerCase(), price);
					}
					//Changed by samadhan on 27/07/2015 End
					//Changed by samadhan 25/12/2015 for price list to/from date integration with megento start
					if(!(dateFrom.length()==0))
					{
						if(minFormDate.containsKey(operatingLang.toLowerCase()))
						{
							if(genericUtility.getDateObject(minFormDate.get(operatingLang.toLowerCase())).compareTo(genericUtility.getDateObject(dateFrom)) > 0)
							{
								minFormDate.put(operatingLang.toLowerCase(), dateFrom);
							}
						}
						else
						{
							minFormDate.put(operatingLang.toLowerCase(), dateFrom);
						}
					}
					if(!(dateTo.length()==0))
					{
						if(maxToDate.containsKey(operatingLang.toLowerCase()))
						{
							if(genericUtility.getDateObject(maxToDate.get(operatingLang.toLowerCase())).compareTo(genericUtility.getDateObject(dateTo)) < 0)
							{
								maxToDate.put(operatingLang.toLowerCase(), dateTo);
							}
						}
						else
						{
							maxToDate.put(operatingLang.toLowerCase(), dateTo);
						}
					}
					//Changed by samadhan 25/12/2015 for price list to/from date integrate with megento start
			
				}
				pstmtSel.close();
				pstmtSel = null;
				rs1.close();
				rs1 = null;

				storeInfo = storeInfo + "</store_info>";
				System.out.println("Hurray======"+storeInfo);

				String colorId = "";
				objProductsChild = new Product();
				objProductsChild.setApiKey(apiKey);//Changed by wasim on 14-08-2015 to set apiKey for magento
				objProductsChild.setCost(0);
				objProductsChild.setStoreId(0);
				colorId = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1","COLOR",phy_attrib_2, conn));
				colorId = colorId.length() == 0 ? "0" : colorId;
				objProductsChild.setColorId(Integer.parseInt(colorId));	

				objProductsChild.setTaxClass(Integer.parseInt((tax.equals("")||tax==null)?"2":tax.trim()));

				//Changed by Samadhan on 28/07/2015 
				size_codes = prodEjb.getColumnDescr(conn,"phy_attrib_22","item","item_code",item_code);	

				System.out.println("@@My Size Code is="+size_codes);
				//Changed by samadhan on 23/12/2015 for size grid start
				//String sizeStrGen = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1",size_codes,phy_attrib_1, conn));
				HashMap<String, String> sizeMap =  prodEjb.getSizeMap(phy_attrib_1,size_codes,conn);
				String sizeStrGen = checkNullAndTrim(sizeMap.get("MEGETO_ID"));
				//Changed by samadhan on 23/12/2015 for size grid end
				sizeStrGen = sizeStrGen.length() == 0 ? "0" : sizeStrGen;
				objProductsChild.setProductSizeId(Integer.parseInt(sizeStrGen)); 
				
				//Changed by Samadhan on 21/12/2015 for size short description and limited edition integration Start
				String sizeShortDescr = sizeMap.get("SH_DESCR");
				String sizeDescr = sizeMap.get("DESCR");
				String megetoBrandId = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1","BRAND",brandCode, conn));
				String megetoBrandCatId = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1","CATEGORY",brandCode, conn));
				
				System.out.println("MegentoSizeId:"+sizeStrGen);
				System.out.println("SizeDescr:"+sizeDescr);
				System.out.println("SizeShortDescr:"+sizeShortDescr);
				System.out.println("LimitedEdition:"+ltdEdition);
				System.out.println("MegentoBrandId:"+megetoBrandId);
				System.out.println("MegentoBrandCatId:"+megetoBrandCatId);
				//Changed by Samadhan on 21/12/2015 for size short description integration End
			
				String dimension1 = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1","DIMENSION",phy_attrib_3, conn));

				dimension1 = dimension1.length() == 0 ? "0" : dimension1;
				int dimension = Integer.parseInt(dimension1);
				objProductsChild.setProductDimensionId(dimension); //MEDIUM		
				System.out.println("@@My Image="+img_path);
				objProductsChild.setImagePath(URLEncoder.encode(checkNullAndTrim(img_path),"UTF-8"));//phy_attrib_17					
				objProductsChild.setLongDescription(URLEncoder.encode(checkNullAndTrim(long_descr),"UTF-8"));

				//Changed by Samadhan on 28/07/2015 Start
				String categoryDesc = prodEjb.getColumnDescr(conn,"phy_attrib_23","item","item_code",item_code);	
				String [] id = categoryDesc.split(",");
				categoryId="";	
				for(String str : id)
				{		
					categoryId = categoryId+prodEjb.getColumnDescr(conn,"attrib_id","itm_attrib_val","attrib_code = 'CATEGORY' and descr",checkNullAndTrim(str))+",";
				}
				categoryId = categoryId.substring(0 ,categoryId.length() -1);
				//Changed by Samadhan on 28/07/2015 End

				id = categoryId.split(",");
				String categoty ="";
				for(String str : id)
				{		
					String categoryId="";				
					categoryId = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1","CATEGORY",checkNullAndTrim(str), conn));
					categoty = categoty + categoryId+",";
				}
				categoty = categoty.substring(0 ,categoty.length() -1);
				System.out.println("categoty------>>["+categoty+"]");
				//Changed by Samadhan on 21/12/2015 for brand and limited edition integration Start
				if(megetoBrandCatId.length()>0)
				{
					if((","+categoty+",").indexOf(","+megetoBrandCatId+",")==-1)
					{
						categoty = categoty+","+megetoBrandCatId;
					}
				}
				if(ltdEdition.equals("Y"))
				{
					String attribLtdEdiId = checkNullAndTrim(distComm.getDisparams("999999", "LTDEDI_ATTRIB_ID", conn));
					String limitedEdiMegentoId = checkNullAndTrim(prodEjb.getItemAttribVal("UDF__STR1","CATEGORY",attribLtdEdiId, conn));
					if((","+categoty+",").indexOf(","+limitedEdiMegentoId+",")==-1)
					{
						categoty = categoty+","+limitedEdiMegentoId;
					}
				}
				System.out.println("categoty after brand and limited edi------>>["+categoty+"]");
				//Changed by Samadhan on 21/12/2015 for brand and limited edition integration End
			
				objProductsChild.setCategories(categoty);	

				String manufacturerId="";
				//Changed by Samadhan on 21/12/2015 for brand integration start
				/*manufacturerId = prodEjb.getColumnDescr(conn,"udf_1","supplier","supp_code",suppCode);		        
				manufacturerId = manufacturerId.length() == 0 ? "0" :manufacturerId;
				objProductsChild.setManufacturerId(Integer.parseInt(manufacturerId));//supplier code

				sql = "SELECT SP.COUNT_CODE FROM ITEM I,SUPPLIERITEM S,SUPPLIER SP "
					+"WHERE I.ITEM_CODE = ? "
					+"AND I.ITEM_CODE = S.ITEM_CODE " 
					+"AND SP.SUPP_CODE = S.SUPP_CODE ";


				pstmtsel = conn.prepareStatement(sql);
				pstmtsel.setString(1, item_code);
				rs = pstmtsel.executeQuery();
				String countCodeMfg="";
				if(rs.next())
				{
					countCodeMfg = checkNullAndTrim(rs.getString("COUNT_CODE"));	
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmtsel != null)
				{
					pstmtsel.close();
					pstmtsel = null;
				}

				objProductsChild.setManufacturerCountryCode(countCodeMfg); //count_code__mfg
*/				
				megetoBrandId = megetoBrandId.length() == 0 ? "0" :megetoBrandId;
				objProductsChild.setManufacturerId(Integer.parseInt(megetoBrandId));
				//Changed by Samadhan on 21/12/2015 for brand integration End
				objProductsChild.setMetaDescription(URLEncoder.encode(checkNullAndTrim(meta_desc),"UTF-8")); //.phy_attrib_19
				objProductsChild.setMetaKeywords(URLEncoder.encode(checkNullAndTrim(meta_keywords),"UTF-8"));//phy_attrib_20
				objProductsChild.setMetaTitle(URLEncoder.encode(checkNullAndTrim(meta_title),"UTF-8"));//phy_attrib_21

				objProductsChild.setPrice(adminPrice);	
				objProductsChild.setProductName(URLEncoder.encode(checkNullAndTrim(descr),"UTF-8"));
				objProductsChild.setProductStatus(1);
				item_gross_wt=(item_gross_wt==null||item_gross_wt.equals(""))?"0":item_gross_wt.trim();

				objProductsChild.setProductWeight(Double.parseDouble(item_gross_wt));
				objProductsChild.setQty(0);
				objProductsChild.setShortDescription(URLEncoder.encode(checkNullAndTrim(sh_descr),"UTF-8"));
				objProductsChild.setSku(item_code);	

				deleteSkus = deleteSkus + item_code +",";

				attributeSetId = prodEjb.getColumnDescr(conn,"udf_str1","item_type","item_type",item_type);		
				objProductsChild.setAttributeSetId(Integer.parseInt((attributeSetId.equals("")||attributeSetId==null)?"0":attributeSetId.trim()));

				/*ArrayList<String> prIds = new ArrayList<String>();
				System.out.println("@@@Site Count is="+siteCnt);
				for(int j=0;j<siteCnt;j++)
				{
					prIds.add(item_code);
				}*/

				System.out.println("Store Info Child >>>>>>>>>:["+storeInfo+"]");

				//objProductsChild.setStoreInf(URLEncoder.encode(String.format(storeInfo,prIds.toArray(new String[prIds.size()])),"UTF-8"));
				objProductsChild.setStoreInf(URLEncoder.encode(checkNullAndTrim(storeInfo),"UTF-8"));
				objProductsChild.setBarcode(URLEncoder.encode(checkNullAndTrim(item_barcode),"UTF-8"));

				int simpleId =  commonutility.Call(objProductsChild,apiSimpleUrl, null);
				System.out.println("simpleId child---->>["+simpleId+"]");					
				if(simpleId != 0)
				{
					simpleProductIdCollection.add(simpleId);
					prodEjb.updateItemUdfNum(item_code,simpleId,conn);
				}

				//Changed By Samadhan on 30/07/2015 End
				
			}
			
			//Changed By Samadhan on 30/07/2015 Start
			System.out.println("simpleProductId Parent@------>>["+simpleProductId+"]");
			System.out.println("simpleProductIdCollection Parent------>>["+simpleProductIdCollection+"]");
			
			if(simpleProductIdCollection !=null && ! simpleProductIdCollection.isEmpty())
			{
				System.out.println("itemCodec Parent@------>>["+item_parnt+"] itemCodeDescrP--->>"+item_parnt_desc);
				System.out.println("parentMaxPrice parentMaxPrice@------>>["+parentMaxPrice+"]");
				String sqlPriceSite = " SELECT SITE_CODE FROM SITE ";
				pstmtsel = conn.prepareStatement(sqlPriceSite);
				rs = pstmtsel.executeQuery();
				siteCnt=0;
				storeInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <store_info>	";
				double adminPrice = 0.0;
				String adminSite = commonutility.getDDSalesConfig("PRODUCT_ADMIN_SITE");
				String[] language_dtl_list = hdrlanguage_dtl.split("\\|\\|");
				//Changed by samadhan on 25/12/2015 for price list to/from date
				String dateFrom="",dateTo="",specialPriceFrom="",specialPriceTo="";
				while (rs.next()) 
				{
					siteCode = rs.getString(1);
					String operatingLang="";
					boolean flag = false;
					operatingLang = prodEjb.getOperatingLang(siteCode.trim(),conn);
					siteCnt++;

					price = (Double)maxPriceMap.get(operatingLang.toLowerCase());
					price = 0.0;
					System.out.println("Max Price of "+operatingLang+" is: "+price);
					//Changed by samadhan on 25/12/2015 for price list to/from date start
					dateFrom = checkNullAndTrim(minFormDate.get(operatingLang.toLowerCase()));
					if(!(dateFrom.length()==0))
					{
						specialPriceFrom = genericUtility.getValidDateString(dateFrom,genericUtility.getApplDateFormat(), priceDtFormat);
					}
					System.out.println("Min from date of Special price for "+operatingLang+" is: "+specialPriceFrom);
					
					dateTo = checkNullAndTrim(maxToDate.get(operatingLang.toLowerCase()));
					if(!(dateFrom.length()==0))
					{
						specialPriceTo = genericUtility.getValidDateString(dateTo,genericUtility.getApplDateFormat(), priceDtFormat);
					}
					System.out.println("Max To date of Special price for "+operatingLang+" is: "+specialPriceTo);
					//Changed by samadhan on 25/12/2015 for price list to/from date end
					for (int j = 0; j < language_dtl_list.length; j++) 
					{
						String[] langdescr = language_dtl_list[j].split(":");
						if(operatingLang.equalsIgnoreCase(adminSite))
						{
							adminPrice = price;
						}
						if(operatingLang.equalsIgnoreCase(langdescr[0]))
						{
							storeInfo = storeInfo +	"<store>		" ;
							storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
							storeInfo = storeInfo + "<product_id><![CDATA["+item_parnt+"]]></product_id>		" ;
							storeInfo = storeInfo + "<name><![CDATA["+langdescr[2]+"]]></name>		" ;
							storeInfo = storeInfo + "<short_desc><![CDATA["+langdescr[3]+"]]></short_desc>		";
							storeInfo = storeInfo + "<long_desc><![CDATA["+langdescr[4]+"]]></long_desc>		";
							storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
							//Changed by Samadhan on 29/12/2015 for special price start
							storeInfo = storeInfo + "<specialPrice><![CDATA["+price+"]]></specialPrice>	";
							storeInfo = storeInfo + "<specialPriceFrom><![CDATA["+specialPriceFrom+"]]></specialPriceFrom>	";
							storeInfo = storeInfo + "<specialPriceTo><![CDATA["+specialPriceTo+"]]></specialPriceTo>	";
							//Changed by Samadhan on 29/12/2015 for special price end
							storeInfo = storeInfo + "</store>";
							flag=true;
							break;
						}
					}
					if(!flag)
					{
						storeInfo = storeInfo +	"<store>	 	" ;
						storeInfo = storeInfo + "<code><![CDATA["+operatingLang.toLowerCase()+"]]></code>		" ;
						storeInfo = storeInfo + "<product_id><![CDATA["+item_parnt+"]]></product_id>		" ;
						storeInfo = storeInfo + "<name><![CDATA["+item_descr+"]]></name>		" ;
						storeInfo = storeInfo + "<short_desc><![CDATA["+sh_descr+"]]></short_desc>		";
						storeInfo = storeInfo + "<long_desc><![CDATA["+long_descr+"]]></long_desc>		";
						storeInfo = storeInfo + "<price><![CDATA["+price+"]]></price>	";
						//Changed by Samadhan on 29/12/2015 for special price start
						storeInfo = storeInfo + "<specialPrice><![CDATA["+price+"]]></specialPrice>	";
						storeInfo = storeInfo + "<specialPriceFrom><![CDATA["+specialPriceFrom+"]]></specialPriceFrom>	";
						storeInfo = storeInfo + "<specialPriceTo><![CDATA["+specialPriceTo+"]]></specialPriceTo>	";
						//Changed by Samadhan on 29/12/2015 for special price end
						storeInfo = storeInfo + "</store>";
					}
				}
				storeInfo = storeInfo + "</store_info> ";
				pstmtsel.close();
				rs.close();
				
				objProductsChild.setSku(item_parnt);
				objProductsChild.setProductName(URLEncoder.encode(checkNullAndTrim(item_parnt_desc),"UTF-8"));
				objProductsChild.setPrice(adminPrice);
				/*ArrayList<String> prIds = new ArrayList<String>();
				for(int k=0;k<siteCnt;k++)
				{
					prIds.add(item_parnt);
				}*/

				System.out.println("Store Info Parent >>>>>>>>>:["+storeInfo+"]");
				//objProductsChild.setStoreInf(URLEncoder.encode(String.format(storeInfo,prIds.toArray(new String[prIds.size()])),"UTF-8"));
				objProductsChild.setStoreInf(URLEncoder.encode(checkNullAndTrim(storeInfo),"UTF-8"));
				deleteSkus = deleteSkus + item_parnt +",";
				simpleProductId = commonutility.Call(objProductsChild,apiConfigUrl, simpleProductIdCollection);
				prodEjb.updateItemUdfNum(item_parnt,simpleProductId,conn);

			}	
			//Changed By Samadhan on 30/07/2015 End
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			isError = true;
			retString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pstmtIns != null)
				{
					pstmtIns.close();
					pstmtIns = null;
				}
				if (localConnection && conn != null && !conn.isClosed())
				{
					if ( !isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){}
		}
		
		return retString;
	}
		
	/**
	 * Check string is null
	 * @param input
	 * @return
	 */
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	// Changed by Sneha on 04-04-2016, for tranId generation and inserting values in priceList [Start] 
	
	// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
	//private String getTransID( String windowName, Connection conn ) throws ITMException
	private String getTransID( String windowName, String item_parnt, String phy_attrib_6, String phy_attrib_2, Connection conn ) throws ITMException
	// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";

		 try
         {
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
					keyString = rs.getString("KEY_STRING");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);
			
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
			String itemParntStr = "";
			if(item_parnt.length() < 5)
			{
				itemParntStr = "00000".substring(item_parnt.length()) + item_parnt;	
			}
			else
			{
				itemParntStr = item_parnt;
			}
			//System.out.println("itemParntStr========>>"+itemParntStr);
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [Start]
			xmlValues = xmlValues +		"<item_parnt>" + itemParntStr + "</item_parnt>";
			xmlValues = xmlValues +		"<phy_attrib_2>" + phy_attrib_2 + "</phy_attrib_2>";
			xmlValues = xmlValues +		"<phy_attrib_6>" + phy_attrib_6 + "</phy_attrib_6>"; 
			// Changed by Sneha on 30-09-2016, for generating tranid as parent_code, color_code, size_code [End]
						
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
         }
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
        return tranId;
	}
	// Changed by Sneha on 04-04-2016, for tranId generation and inserting values in priceList [End] 
}
