package ibase.webitm.ejb.dis.adv;

import ibase.utility.CommonConstants;
import ibase.utility.EMail;
import ibase.webitm.utility.*;
import ibase.webitm.utility.wms.CommonWmsUtil;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvHoldGen;
import ibase.webitm.ejb.dis.PostOrderActivity;
import ibase.webitm.ejb.dis.StockUpdate;
import ibase.webitm.ejb.fin.*;
import ibase.webitm.ejb.fin.adv.CalculateCommission;
import ibase.webitm.ejb.fin.adv.DrCrRcpConf;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.ejb.sys.UtilMethods;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.*;
import java.sql.*;

import javax.ejb.*;

import ibase.webitm.ejb.MasterStatefulLocal;

import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import ibase.utility.E12GenericUtility;

@Stateless
public class SalesReturnConfirm extends ActionHandlerEJB implements SalesReturnConfLocal, SalesReturnConfRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	String DB = CommonConstants.DB_NAME;
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
	ValidatorEJB vdt = new ValidatorEJB();
	CommonWmsUtil common = new  CommonWmsUtil(); 
	DistCommon distCommon = new DistCommon();
	//Added by wasim [START]
	InvAcct invacct = new InvAcct();
	String gs_run_mode = "";
	FinCommon finCommon = new FinCommon();
	//Added by wasim [END]
	
	@Override
	
	//Changed by wasim on 23-MAY-2017 for overloading confirm method as to accept Connection parameter [START]
	public String confirm(String msalereturn, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		String retString = "";
		Connection conn = null;
		try
		{
			retString = confirm(msalereturn,xtraParams,forcedFlag,conn);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return retString;
	}
	//Changed by wasim on 23-MAY-2017 for overloading confirm method as to accept Connection parameter [END]
	
	//Changed by wasim on 23-MAY-2017 for overloading confirm method as to accept Connection parameter [START]
	//public String confirm(String msalereturn, String xtraParams, String forcedFlag)throws RemoteException, ITMException
	public String confirm(String msalereturn, String xtraParams, String forcedFlag,Connection conn)throws RemoteException, ITMException
	{
	//Changed by wasim on 23-MAY-2017 for overloading confirm method as to accept Connection parameter [END]
	
		System.out.println("SalesReturnConf Called........" + msalereturn);

		//Connection conn = null;
		
		
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		java.sql.Timestamp chgDate = null,currDate = null;
		String sql = "", ls_invoice_id ="", ls_full_ret = "", ls_var_value = "", ls_lr_no = "",ls_status = "", ls_confirmed ="",ls_sale_order = "",ls_cust_code__trf="";
		String ls_errcode = "", mreturn = "", ls_edioption = "", ls_ledg_post_conf = "", ls_verify_password_filter = "", ls_filter = "", ls_cust_code__bill = "";
		String errMsg = null;
		double lc_sret_amt = 0, lc_inv_amt = 0, lc_amt_drcr	= 0;	
		boolean  lb_ask_pwd=false;
		boolean isError = false;
		Timestamp sysDate = null;//Added by wasim on 19-MAY-2017
		boolean isLocConn = false;//Added by wasim on 23-MAY-2017
		try
		{
			//Changed by wasim on 23-MAY-2017 to check is connection is null then creation connection [START]
			//conn = getConnection();
			if(conn == null)
			{
				conn = getConnection();
				isLocConn = true;
			}
			//Changed by wasim on 23-MAY-2017 to check is connection is null then creation connection [END]	
			
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			//Added by wasim on 19-MAY-2017 to get current Date without Timestamp
			sysDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			
			//Added by wasim on 19-MAY-2017 to get GS_MODE from Xtra Params as per manohar sir
			gs_run_mode = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "runMode"))); 
			
			sql = "select invoice_id, full_ret,status,confirmed,cust_code__trf from sreturn where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_invoice_id = checkNullAndTrim(rs.getString("invoice_id"));
				ls_full_ret = checkNullAndTrim(rs.getString("full_ret"));
				ls_status = checkNullAndTrim(rs.getString("status"));
				ls_confirmed = checkNullAndTrim(rs.getString("confirmed"));
				ls_cust_code__trf = checkNullAndTrim(rs.getString("cust_code__trf"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("ls_invoice_id---------->>"+ls_invoice_id);
			System.out.println("ls_status---------->>"+ls_status);
			System.out.println("ls_confirmed---------->>"+ls_confirmed);

			if("S".equalsIgnoreCase(ls_status))
			{
				errMsg = itmDBAccessLocal.getErrorString("","VTALSUB","");
				return errMsg;
			}
			else if("X".equalsIgnoreCase(ls_status))
			{
				errMsg = itmDBAccessLocal.getErrorString("","VTSRET18","");
				return errMsg;
			}
			if("Y".equalsIgnoreCase(ls_confirmed))
			{
				errMsg = itmDBAccessLocal.getErrorString("","VTMCONF1","");
				return errMsg;
			}

			ls_var_value = distCommon.getDisparams( "999999", "HO_APPROVAL_REQD", conn);
			System.out.println("ls_var_value---------->>"+ls_var_value);
			if("Y".equalsIgnoreCase(ls_var_value))
			{
				sql = "select lr_no from despatch where desp_id in ( select desp_id from invoice where invoice_id = ? )";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,ls_invoice_id );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ls_lr_no = checkNullAndTrim(rs.getString("lr_no"));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("ls_lr_no---------->>"+ls_lr_no);
			}

			// Sneha need to uncomment
			/*if((ls_invoice_id == null || ls_invoice_id.length() == 0) || (ls_lr_no != null && ls_lr_no.length() > 0))
			{
				errMsg = itmDBAccessLocal.getErrorString("","VTHOAPRV","");
				return errMsg;
			}*/

			System.out.println("ls_invoice_id---------->>"+ls_invoice_id);
			if(ls_invoice_id != null && ls_invoice_id.length() > 0)
			{
				System.out.println("ls_full_ret---------->>"+ls_full_ret);
				if("Y".equalsIgnoreCase(ls_full_ret))
				{
					sql = "select sum((case when b.net_amt is null then 0 else b.net_amt end) - (case when b.tax_amt is null then 0 else b.tax_amt end)) from sreturn a, sreturndet b " +
							" where b.tran_id = a.tran_id and b.invoice_id = ? and a.status <> 'X' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,ls_invoice_id );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						lc_sret_amt = rs.getDouble(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("lc_sret_amt---------->>"+lc_sret_amt);
					
					sql = "select ((case when net_amt is null then 0 else net_amt end) - (case when round_adj is null then 0 else round_adj end) - (case when tax_amt is null then 0 else tax_amt end))" +
					" from invoice where invoice_id = ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,ls_invoice_id );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						lc_inv_amt = rs.getDouble(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("lc_inv_amt---------->>"+lc_inv_amt);
					
					sql = "select sum(case when a.drcr_flag = 'C' then ((case when b.drcr_amt is null then 0 else b.drcr_amt end) * -1) else 0 End) " +
					" from drcr_rcp a, drcr_rdet b where  a.tran_id = b.tran_id and b.invoice_id  = ? and a.sreturn_no is null ";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,ls_invoice_id );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						lc_amt_drcr = rs.getDouble(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("lc_amt_drcr---------->>"+lc_amt_drcr);
				}
				
				lc_inv_amt = lc_inv_amt + lc_amt_drcr;
				System.out.println("lc_inv_amt---------->>"+lc_inv_amt);
				System.out.println("lc_sret_amt---------->>"+lc_sret_amt);
				
				if ((lc_sret_amt - lc_inv_amt) > 1 )
				{
					errMsg = itmDBAccessLocal.getErrorString("","VTAMTDIF","");
					return errMsg;
				}
			}


			/*	nvo_business_object_dist_salesreturn nvo_dist_sales
			nvo_business_object_dist_interstockist nvo_dist_interstock
			 */
			//nvo_dist_sales		  = create nvo_business_object_dist_salesreturn 	

			sql = "select edi_option, (case when ledg_post_conf is null then 'N' else ledg_post_conf end), verify_password " +
			" from transetup where  lower(tran_window) = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"w_salesreturn" );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_edioption = checkNullAndTrim(rs.getString(1));
				ls_ledg_post_conf = checkNullAndTrim(rs.getString(2));
				ls_verify_password_filter = checkNullAndTrim(rs.getString(3));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(ls_verify_password_filter == null)
			{
				ls_verify_password_filter= "";
			}

			if("db2".equalsIgnoreCase(DB))
			{
				sql = "select confirmed from sreturn where tran_id = ? for update";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ls_confirmed = checkNullAndTrim(rs.getString("confirmed"));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			else if("mssql".equalsIgnoreCase(DB))
			{
				sql = "select confirmed from sreturn (updlock) where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ls_confirmed = checkNullAndTrim(rs.getString("confirmed"));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			else
			{
				sql = "select confirmed from sreturn where tran_id = ? for update nowait";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ls_confirmed = checkNullAndTrim(rs.getString("confirmed"));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			System.out.println("ls_confirmed---------->>"+ls_confirmed);
			System.out.println("ls_ledg_post_conf---------->>"+ls_ledg_post_conf);
			System.out.println("gs_run_mode---------->>"+gs_run_mode);
			System.out.println("ls_verify_password_filter---------->>"+ls_verify_password_filter);
			
			if("Y".equalsIgnoreCase(ls_ledg_post_conf))
			{
				if(!"B".equalsIgnoreCase(gs_run_mode))
				{

					sql = "update sreturn set tran_date = ? where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					//Changed by wasim on 15-may-2017 to set current date in Time stamp in prepared statement
					//pstmt.setString(1,currDateStr );
					pstmt.setTimestamp(1,sysDate );
					pstmt.setString(2,msalereturn );
					int rowcnt = pstmt.executeUpdate();
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			if("Y".equalsIgnoreCase(ls_confirmed))
			{
				errMsg = itmDBAccessLocal.getErrorString("","VTMCONF1","");
				return errMsg;
			}

			if (ls_verify_password_filter.length() > 0)
			{
				lb_ask_pwd = false;
			}

			sql = "select cust_code, invoice_id	from sreturn where  tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_cust_code__bill = checkNullAndTrim(rs.getString("cust_code"));
				ls_invoice_id = checkNullAndTrim(rs.getString("invoice_id"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("ls_cust_code__bill---------->>"+ls_cust_code__bill);
			System.out.println("ls_invoice_id---------->>"+ls_invoice_id);
			
			ls_errcode = confirmSalesReturn(msalereturn, xtraParams, conn);
			//ls_errcode = nvo_dist_sales.gbf_sreturn_confirm(msalereturn, 1, sqlca_cp) 
			
			System.out.println("after sales return confirm=== ["+ls_errcode+"]");
			if(ls_cust_code__trf.length() > 0)
			{
				//nvo_dist_interstock = create nvo_business_object_dist_interstockist
				//ls_errcode = nvo_dist_interstock.gbf_create_inter_stock_transfer(mreturn,'*',sqlca_cp)
			}

			if (ls_errcode != null && ls_errcode.trim().length() > 0) 
			{
				//errMsg = itmDBAccessLocal.getErrorString("",ls_errcode,"");
				errMsg = ls_errcode;
				return errMsg;
			}
			System.err.println("errMsg===========>>"+errMsg);
		} 
		catch (Exception e) 
		{
			System.out.println("Inside catch confirm==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
		}
		finally 
		{
			System.out.println("Inside Finally ["+isError+"] isLocConn["+isLocConn+"] ErrorCode ["+ls_errcode+"] ");
			try
			{
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed by wasim on 17-05-2017 to check the error code [START]
				/*if (isError)//VTSRTRNCMP 
				{
					conn.rollback();
				} */
				if(isLocConn)
				{
					if(isError || (ls_errcode != null && ls_errcode.indexOf("VTSRTRNCMP") == -1))
					{
						System.out.println("Rollback Transaction.............");
						conn.rollback();
					}
					else 
					{
						System.out.println("Committed Transaction.............");
						conn.commit();//For test only 
						//conn.rollback();
					}
					
					if (conn != null) 
					{
						conn.close();
						conn = null;
					}
				}
				//Changed by wasim on 17-05-2017 to check the error code [END]
			}
			catch (SQLException e) 
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		System.out.println("errString is +++:"+errMsg);
		return errMsg;

	}

	public String confirmSalesReturn(String msalereturn,String xtraParams, Connection conn) throws ITMException
	{
		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "", dataStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ValidatorEJB vdt=new ValidatorEJB();
		DistCommon distCommon = new DistCommon();
		HashMap stockUpd = new HashMap();
		//FinCommon finCommon = new FinCommon();
		PostOrderActivity postordact=new PostOrderActivity();
		String	mconf = "",	msite_code = "", mitem_ser	= "", merrcode = "", mitem_code	= "", mflag = "", munit = "", ls_ret_opt = "", mloc_code = "", mlot_no = "", mlot_sl = "",	msite_code_mfg	= "", errorString = "";
		String mvar_value = "", minvoice_id = "", mreas_code = "",	mpack_code = "", minv_stat = "", mfull_ret = "", mcust_code = "", memp_code = "", ls_descr = "", ls_acct_code__dr = "",	ls_cctr_code__dr = "",	ls_acct_code__cr = "";	
		String ls_grade= "",ls_trantype	= "",ls_cctr_code__cr= "",ls_channel_partner = "", ls_tran_type	= "", ls_cust_code= "",	ls_site_code = "", ls_crdt = "",ls_item_code = "", ls_unit = "", ls_hdr = "", ls_det	= "";
		String ls_dis_link = "", ls_site_code_dlv = "",	ls_loc_code_git	= "", ls_tran_stat = "", ls_online_acct = "", ls_edioption = "", ls_ledg_post_conf = ""	,	ls_invoice_id = "", ls_acctmethod = ""	,ls_sretinvqty	= "",  ls_var_value	= "", ls_reas_code	= ""; 
		String ls_conf_drcr_opt = "", ls_conf_jv_opt = "", ls_comm_calc_on_off = "",ls_desp_id = ""	,ls_desp_line_no = "", ls_full_ret = "", ls_lot_no = "", ls_lot_sl = "", ls_sitecodedlv = "",ls_quar_lockcode = "", gs_run_mode = ""; 
		String chgUser = "", chgTerm = "",lc_no_art = "",mline_no = ""; 

		int	mcount = 0,	mmin_shelf_life = 0	,mdays = 0 , mcount1 = 0,	ll_min_shelf_life =0, ll_count = 0,	ll_counter = 0 , ll_sret_count = 0,	ll_invtrace_count =0,ll_row	=0,	ll_line_no_inv = 0,	ll_invamd_count = 0, ll_line_no = 0;
		Timestamp currDate = null, mtran_date = null;
		Date mmfg_date = null,	mexp_date = null, meff_date = null, mrestrict_upto = null, mchk_date = null,	ld_today = null, ld_tran_date = null, ld_eff_date = null, ld_restr_upto_date = null, ldt_conf_date = null ;
		double	mquantity = 0, mset_qty = 0, mtot_stk = 0, mrate = 0, lc_physicalqty = 0, lc_qty = 0,	lc_qty1 = 0;
		double lc_rate = 0, lc_gross_wt = 0, lc_net_wt = 0, lc_tare_wt = 0, lc_invqty_lot = 0, lc_srqty_lot = 0, lc_srqty_prev = 0,	lc_srqty = 0;

		int	 li_restr_days = 0,	li_cnt = 0, ll_line_no__invtrace = 0, mnet_amt = 0, meff_amt = 0, mret_ref_netamt = 0; 

		StockUpdate stockUpdate = new StockUpdate();

		/*	nvo_business_object_drcr_rcp i_nvo_drcrrcp 
		i_nvo_drcrrcp = Create nvo_business_object_drcr_rcp 

		nvo_business_object_dist_porcp nvo_porcp
		nvo_porcp= create nvo_business_object_dist_porcp*/
		UtilMethods utilMethods = UtilMethods.getInstance();
		ArrayList tempList = new ArrayList();
		InvHoldGen invHoldGen = new InvHoldGen();
		//Added by wasim 
		boolean isError = false;
		Timestamp sysDate = null;
		ResultSet rsDetail = null;
		PreparedStatement pstmtDetail = null;
		String errMessage = "";
		int detCnt = 0;
		
		try
		{
			System.out.println("------------------- Inside confirmSalesReturn --------------- ");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate.getTime());
			//Added by wasim on 19-MAY-2017 to get current without Timestamp
			sysDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			
			//Added by wasim on 19-MAY-2017 to get GS_MODE from Xtra Params as per manohar sir
			gs_run_mode = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "runMode"))); 
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			sql = "select edi_option, (case when ledg_post_conf is null then 'N' else ledg_post_conf end) " +
			" from transetup where  lower(tran_window) = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"w_salesreturn_retn" );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_edioption = checkNullAndTrim(rs.getString(1));
				ls_ledg_post_conf = checkNullAndTrim(rs.getString(2));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			System.out.println("---------- ls_ledg_post_conf  ---------------"+ls_ledg_post_conf);
			if("Y".equalsIgnoreCase(ls_ledg_post_conf))
			{
				// No vale is initialized for gs_run_mode
				System.out.println("---------- gs_run_mode  ---------------"+gs_run_mode);
				//Changed by wasim on 19-MAY-2017 to check runMode as not equal to B
				//if("B".equalsIgnoreCase(gs_run_mode))
				if(!"B".equalsIgnoreCase(gs_run_mode))
				{
					sql = "update sreturn set tran_date = ? where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					//Changed by wasim on 15-may-2017 to set current date in Time stamp in prepared statement
					//pstmt.setString(1,currDateStr );
					pstmt.setTimestamp(1,sysDate );
					pstmt.setString(2,msalereturn );
					int rowcnt = pstmt.executeUpdate();
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}	
				
				//Changed by wasim on 19-MAY-2017 for changing prepared statement and result set variables because while loop used [START]
				/*sql = "select b.reas_code, b.quantity, b.rate, a.eff_date, b.invoice_id , b.item_code, a.cust_code	,b.line_no__inv, b.full_ret ,b.line_no__invtrace, b.line_no, a.ret_opt,	b.lot_no, b.lot_sl " +
				" from sreturn a,sreturndet b where a.tran_id = b.tran_id and a.tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				 */
				sql = "select b.reas_code, b.quantity, b.rate, a.eff_date, b.invoice_id , b.item_code, a.cust_code	,b.line_no__inv, b.full_ret ,b.line_no__invtrace, b.line_no, a.ret_opt,	b.lot_no, b.lot_sl " +
					" from sreturn a,sreturndet b where a.tran_id = b.tran_id and a.tran_id = ? ";
				pstmtDetail = conn.prepareStatement(sql);
				pstmtDetail.setString(1,msalereturn );
				rsDetail = pstmtDetail.executeQuery();
				while(rsDetail.next())
				{
				//Changed by wasim on 19-MAY-2017 for changing prepared statement and result set variables becuasue while loop used [END]	
					ls_reas_code = checkNullAndTrim(rsDetail.getString(1));
					lc_qty = rsDetail.getDouble(2);
					lc_rate = rsDetail.getDouble(3);
					ld_eff_date = rsDetail.getDate(4);
					ls_invoice_id = checkNullAndTrim(rsDetail.getString(5));
					ls_item_code = checkNullAndTrim(rsDetail.getString(6));
					ls_cust_code = checkNullAndTrim(rsDetail.getString(7));
					ll_line_no_inv = rsDetail.getInt(8);
					ls_full_ret = checkNullAndTrim(rsDetail.getString(9));
					ll_line_no__invtrace = rsDetail.getInt(10);
					ll_line_no = rsDetail.getInt(11);
					ls_ret_opt = checkNullAndTrim(rsDetail.getString(12));
					ls_lot_no = checkNull(rsDetail.getString(13));
					ls_lot_sl = checkNull(rsDetail.getString(14));
				/*}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}*/
			
					System.out.println("---------- ls_invoice_id  ---------------"+ls_invoice_id);
					if(ls_invoice_id != null && ls_invoice_id.length() > 0)
					{
						System.out.println("---------- ll_line_no__invtrace  ---------------"+ll_line_no__invtrace);
						if(ll_line_no__invtrace > 0)
						{
							sql = "select count(1) from sreturndet where tran_id  = ? and invoice_id = ? and line_no__invtrace = ? and line_no <> ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,msalereturn );
							pstmt.setString(2,ls_invoice_id );
							pstmt.setInt(3,ll_line_no__invtrace );
							pstmt.setInt(4,ll_line_no );
							rs = pstmt.executeQuery();
							if(rs.next())
							{										
								li_cnt = rs.getInt(1);
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(li_cnt > 0) 
							{
								merrcode = "VTINVLN"; 	// Pending
								errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
								return errorString;
							}
						}
					}
		
					System.out.println("---------- ll_line_no__invtrace  ---------------"+ll_line_no__invtrace);
					if(ll_line_no__invtrace == 0)
					{
						sql = "select sum(quantity__stduom) from invoice_trace where  invoice_id  = ? and inv_line_no = ? and lot_no = ? and lot_sl = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,ls_invoice_id );
						pstmt.setInt(2,ll_line_no_inv );
						pstmt.setString(3,ls_lot_no );
						pstmt.setString(4,ls_lot_sl );
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							lc_invqty_lot = rs.getDouble(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						sql = "select sum(quantity__stduom) from invoice_trace where  invoice_id  = ? and inv_line_no = ? and line_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,ls_invoice_id );
						pstmt.setInt(2,ll_line_no_inv );
						pstmt.setInt(3,ll_line_no__invtrace );
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							lc_invqty_lot = rs.getDouble(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					System.out.println("---------- lc_invqty_lot  ---------------"+lc_invqty_lot);
					
					sql = "select sum(b.quantity__stduom) from sreturn a, sreturndet b where b.tran_id = a.tran_id and b.invoice_id = ? and b.line_no__inv = ? " +
					" and ((b.line_no__invtrace = ?) or (b.line_no__invtrace is null or b.line_no__invtrace = 0)) and a.tran_id <> ? and a.status  <> 'X'" ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,ls_invoice_id );
					pstmt.setInt(2,ll_line_no_inv );
					pstmt.setInt(3,ll_line_no__invtrace );
					pstmt.setString(4,msalereturn );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						lc_srqty_prev = rs.getDouble(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}	
					System.out.println("---------- lc_srqty_prev  ---------------"+lc_srqty_prev);
					
					sql = "select sum(b.quantity__stduom) from sreturn a, sreturndet b where b.tran_id = a.tran_id and b.tran_id = ? and b.invoice_id = ? and b.line_no__inv = ?" +
					" and ((b.line_no__invtrace = ?) or (b.line_no__invtrace is null or b.line_no__invtrace = 0))" ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,msalereturn );
					pstmt.setString(2,ls_invoice_id );
					pstmt.setInt(3,ll_line_no_inv );
					pstmt.setInt(4,ll_line_no__invtrace );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						lc_srqty = rs.getDouble(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}		
					System.out.println("---------- lc_srqty  ---------------"+lc_srqty);
					
					lc_srqty_lot = lc_srqty + lc_srqty_prev ;
		
					System.out.println("---------- lc_srqty_lot  ---------------"+lc_srqty_lot);
					System.out.println("---------- lc_invqty_lot  ---------------"+lc_invqty_lot);
					System.out.println("---------- ls_full_ret  ---------------"+ls_full_ret);
					
					if (lc_srqty_lot > lc_invqty_lot)
					{
						System.out.println("---------- ls_ret_opt  ---------------"+ls_ret_opt);
						if(!"D".equalsIgnoreCase(ls_ret_opt))
						{
							merrcode = "VTSRET7";
							errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
							return errorString;
						}
					}
					else if(lc_srqty_lot < lc_invqty_lot && "Y".equalsIgnoreCase(ls_full_ret))
					{
						merrcode = "VTSRET11";
						errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
						return errorString;
					}
					else if(lc_srqty_prev == 0)
					{
						if (lc_srqty_lot == lc_invqty_lot && !"Y".equalsIgnoreCase(ls_full_ret))
						{
							merrcode = "VTSRET10";
							errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
							return errorString;
						}
						else if (lc_srqty_lot != lc_invqty_lot && "Y".equalsIgnoreCase(ls_full_ret))
						{
							merrcode = "VTSRET11";
							errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
							return errorString;
						}
					}
					else if (lc_srqty_lot != lc_invqty_lot && "Y".equalsIgnoreCase(ls_full_ret))
					{
						merrcode = "VTSRET12";
						errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
						return errorString;
					}
		
					sql = "select restr_days from sreturn_reason where reason_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,ls_reas_code );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						li_restr_days = rs.getInt(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("li_restr_days===["+li_restr_days+"]");
					if (li_restr_days > 0 )
					{
						ld_restr_upto_date = utilMethods.RelativeDate(ld_eff_date,li_restr_days);
						System.out.println("ld_restr_upto_date===["+ld_restr_upto_date+"]");
		
						sql = "select unit, descr from item where item_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,ls_item_code );
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							ls_unit = checkNullAndTrim(rs.getString(1));
							ls_descr = checkNullAndTrim(rs.getString(2));
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						sql = "select count(*) from customeritem where cust_code = ? and item_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,ls_cust_code );
						pstmt.setString(2,ls_item_code );
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							li_cnt = rs.getInt(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println("li_cnt for customeritem["+li_cnt+"]");
		
						if(li_cnt > 0)
						{
							sql = "select quantity from sreturndet where tran_id = ? and line_no__inv = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,msalereturn );
							pstmt.setInt(2,ll_line_no_inv );
							rs = pstmt.executeQuery();
							if(rs.next())
							{										
								lc_qty1 = rs.getInt(1);
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							sql = "update customeritem set restrict_upto = ?, quantity__dem = (case when quantity__dem is null then 0 else quantity__dem end) " +
							" + (? - ?) where cust_code = ? and item_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setDate(1,new java.sql.Date(ld_restr_upto_date.getTime()));
							pstmt.setDouble(2,lc_qty );
							pstmt.setDouble(3,lc_qty1 );
							pstmt.setString(4,ls_cust_code );
							pstmt.setString(5,ls_item_code );
							int rowcnt = pstmt.executeUpdate();
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						else
						{	
							sql = "insert into customeritem (cust_code, item_code, item_code__ref, rate__ref, quantity__dem, unit, descr, restrict_upto, " +
									"min_qty, integral_qty, min_shelf_life, chg_date, chg_user, chg_term) " +
									"values(?, ?, ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?) ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,ls_cust_code );
							pstmt.setString(2,ls_item_code );
							pstmt.setString(3,ls_item_code );
							pstmt.setDouble(4,lc_rate );
							pstmt.setDouble(5,lc_qty );
							pstmt.setString(6,ls_unit );
							pstmt.setString(7,ls_descr );
							pstmt.setDate(8,new java.sql.Date(ld_restr_upto_date.getTime()) );
							pstmt.setString(9,"0" );
							pstmt.setString(10,"0" );
							pstmt.setString(11,"0" );
							//Changed by wasim on 15-may-2017 to set current date in Time stamp in prepared statement
							//pstmt.setString(12,currDateStr );
							pstmt.setTimestamp(12,currDate);
							pstmt.setString(13,chgUser );
							pstmt.setString(14,chgTerm );
							pstmt.executeUpdate();
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}	
					}
		    //Added by wasim on 19-MAY-2017 for while loop instead of if loop [END]
				}//While loop END for Sales return Detail
				if (rsDetail != null)
				{
					rsDetail.close();
					rsDetail = null;
				}
				if (pstmtDetail != null)
				{
					pstmtDetail.close();
					pstmtDetail = null;
				}
			//Added by wasim on 19-MAY-2017 for while loop instead of if loop [END]
			
			sql = "Select site_code, item_ser, tran_date, invoice_id, eff_date , cust_code, ret_opt, tran_type, case when site_code__dlv is null then site_code else site_code__dlv end from sreturn where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				msite_code = rs.getString(1);
				mitem_ser = rs.getString(2);
				mtran_date = rs.getTimestamp(3);
				minvoice_id = rs.getString(4);
				meff_date = rs.getDate(5);
				mcust_code = rs.getString(6);
				ls_ret_opt = rs.getString(7);
				ls_trantype = rs.getString(8);
				ls_sitecodedlv = rs.getString(9);
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "select count(1) From sreturndet Where tran_id = ? and qc_reqd = 'Y'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ll_count = rs.getInt(1);
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(ll_count > 0 && !"B".equalsIgnoreCase(gs_run_mode))
			{
				merrcode = gbf_create_sretqc(msalereturn, xtraParams, conn);
				System.out.println("After creating QC order="+merrcode);
				if(merrcode != null && merrcode.trim().length() > 0)
				{
					errorString = itmDBAccessLocal.getErrorString("",merrcode,"");
					return errorString;
				}
			}
			System.out.println("------------- ls_ret_opt ------------ "+ ls_ret_opt);
			if("R".equalsIgnoreCase(ls_ret_opt))
			{
				sql = "Select count(*) From sreturndet Where tran_id = ? and ret_rep_flag = 'P'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ll_count = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(ll_count == 0)
				{
					merrcode = "VTRETREP01";
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}

				sql = "Select abs(sum((case when eff_net_amt is null then 0 else eff_net_amt end))), sum((case when net_amt is null then 0 else net_amt end)) From sreturndet Where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					meff_amt = rs.getInt(1);
					mnet_amt = rs.getInt(2);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				mvar_value = distCommon.getDisparams( "999999", "PERMIT_AMT", conn);
				if(meff_amt > Integer.parseInt(mvar_value))
				{
					merrcode = "VTSRET3";
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}
				sql = "Select	sum((case when net_amt is null then 0 else net_amt end)) from sreturndet Where tran_id	= ? and	ret_rep_flag = 'R'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					mnet_amt = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				mvar_value = distCommon.getDisparams( "999999", "PERMIT_PERCENT", conn);

				if( ((mnet_amt * Integer.parseInt(mvar_value)) / 100 ) < meff_amt) 
				{
					merrcode = "VTSRET3";
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}
			}
			else if("D".equalsIgnoreCase(ls_ret_opt))
			{
				sql = "Select sum((case when net_amt is null then 0 else net_amt end) - (case when tax_amt is null then 0 else tax_amt end)) from sreturndet Where tran_id	= ? and	ret_rep_flag = 'R'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					mnet_amt = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				sql = "Select	net_amt - (case when tax_amt is null then 0 else tax_amt end) from sreturn Where tran_id	= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					mret_ref_netamt = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				mvar_value = distCommon.getDisparams( "999999", "PERMIT_AMT", conn);
				if((mnet_amt - mret_ref_netamt) > Integer.parseInt(mvar_value)) 
				{
					merrcode = "VTAMTDIF1";
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}
			}
			sql = "Select channel_partner, dis_link, site_code__ch from site_customer where cust_code =	? And site_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,mcust_code );
			pstmt.setString(2,msite_code );
			rs = pstmt.executeQuery();
			if(rs.next())
			{				
				ls_channel_partner = checkNullAndTrim(rs.getString(1));
				ls_dis_link = checkNullAndTrim(rs.getString(2));
				ls_site_code_dlv = checkNullAndTrim(rs.getString(3));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(ls_channel_partner== null || ls_channel_partner.trim().length()==0)
			{
				sql ="select channel_partner, dis_link, site_code from  customer where cust_code = ? ";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, mcust_code);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ls_channel_partner = checkNullAndTrim(rs.getString(1));
					ls_dis_link = checkNullAndTrim(rs.getString(2));
					ls_site_code_dlv = checkNullAndTrim(rs.getString(3));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}

			ls_loc_code_git = distCommon.getDisparams( "999999", "TRANSIT_LOC", conn);

			if( "Y".equalsIgnoreCase(ls_channel_partner) && "E".equalsIgnoreCase(ls_dis_link))
			{
				sql = "Select inv_stat From location Where loc_code	= ? ";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, ls_loc_code_git);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ls_tran_stat = checkNullAndTrim(rs.getString(1));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			ls_sretinvqty = distCommon.getDisparams("999999","SRET_INV_QTY",conn) ;

			//Changed by wasim on 19-MAY-2017 for changing prepared statements for while loop [START]
			/*sql = "Select line_no, item_code, quantity__stduom, ret_rep_flag, unit__std, loc_code, lot_no, lot_sl, mfg_date, exp_date, site_code__mfg, cost_rate, reas_code, pack_code, full_ret, physical_qty, no_art, line_no__inv,	line_no__invtrace ,	gross_weight, tare_weight, net_weight From sreturndet where tran_id	= ? Order by line_no";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, msalereturn);
			rs = pstmt.executeQuery();*/
			sql = "Select line_no, item_code, quantity__stduom, ret_rep_flag, unit__std, loc_code, lot_no, lot_sl, mfg_date, exp_date, site_code__mfg, cost_rate, reas_code, pack_code, full_ret, physical_qty, no_art, line_no__inv,	line_no__invtrace ,	gross_weight, tare_weight, net_weight From sreturndet where tran_id	= ? Order by line_no";
			pstmtDetail=conn.prepareStatement(sql);
			pstmtDetail.setString(1, msalereturn);
			rsDetail = pstmtDetail.executeQuery();
			//Changed by wasim on 19-MAY-2017 for changing prepared statements for while loop [END]
			//Changed by wasim on 19-MAY-2017 to use while loop instead of if for multiple lines in sales return details
			//if(rs.next())
			while(rsDetail.next())
			{
				detCnt++;//Added by wasim on 05-JUN-2017 for detail counter
				
				mline_no = checkNullAndTrim(rsDetail.getString(1));
				mitem_code = checkNullAndTrim(rsDetail.getString(2));
				mquantity = rsDetail.getDouble(3);
				mflag = checkNullAndTrim(rsDetail.getString(4));
				munit = checkNullAndTrim(rsDetail.getString(5));
				mloc_code = checkNullAndTrim(rsDetail.getString(6));
				mlot_no = checkNull(rsDetail.getString(7));
				mlot_sl = checkNull(rsDetail.getString(8));
				//Changed by wasim on 16-MAY-2017 to get date in Timestamp [START]
				//mmfg_date = rs.getDate(9);
				//mexp_date = rs.getDate(10);
				mmfg_date = rsDetail.getTimestamp(9);
				mexp_date = rsDetail.getTimestamp(10);
				//Changed by wasim on 16-MAY-2017 to get date in Timestamp [END]
				msite_code_mfg = checkNullAndTrim(rsDetail.getString(11));
				lc_rate = rsDetail.getDouble(12);
				mreas_code = checkNullAndTrim(rsDetail.getString(13));
				mpack_code = checkNullAndTrim(rsDetail.getString(14));
				mfull_ret = checkNullAndTrim(rsDetail.getString(15));
				lc_physicalqty = rsDetail.getDouble(16);
				lc_no_art = checkNullAndTrim(rsDetail.getString(17));
				ll_line_no_inv = rsDetail.getInt(18);
				ll_line_no__invtrace = rsDetail.getInt(19);
				lc_gross_wt = rsDetail.getDouble(20);
				lc_tare_wt = rsDetail.getDouble(21);
				lc_net_wt = rsDetail.getDouble(22);
			/*}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/

				if( "Y".equalsIgnoreCase(mfull_ret))
				{
					mvar_value = distCommon.getDisparams( "999999", "RESTRICT_ON_FRET", conn);
				}
				//Changed by wasim on 15-may-2017 if mvar_value is blank or null then set as 0 [START]
				if(mvar_value == null || mvar_value.length() == 0)
				{
					mvar_value = "0";
				}
				//Changed by wasim on 15-may-2017 if mvar_value is blank or null then set as 0 [END]
				mrestrict_upto = utilMethods.RelativeDate(meff_date,Integer.parseInt(mvar_value));
	
				sql = "Select count(*) From	customeritem Where cust_code = ? And item_code = ?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, mcust_code);
				pstmt.setString(2, mitem_code);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					mcount1 = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
	
				if( "R".equalsIgnoreCase(mflag))
				{
					System.out.println("$$$$$$$$$$$Inside Sales Return------->["+mflag+"]$$$$$$$$$$$$$$");
					
					sql = "Select inv_stat From location Where loc_code	= ? ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, mloc_code);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						minv_stat = checkNullAndTrim(rs.getString("inv_stat"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					//Changed by wasim as this closing bracket will end at after compeleting stock update for Returned tran type (R) 	
				//}
				
					minvoice_id = checkNull(minvoice_id);//Added by wasim as it is giving null pointer if minvoice_id is null
					if(minvoice_id.trim().length() >0)
					{
						sql = "Select inv_type From invoice Where invoice_id = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, minvoice_id);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ls_trantype = checkNullAndTrim(rs.getString("inv_type"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
		
					if(ls_trantype == null || ls_trantype.trim().length() == 0)
					{
						ls_trantype = " ";
					}
		
					sql = "Select acct_code__inv, cctr_code__inv, grade From stock Where site_code = ? And item_code = ? And loc_code = ? And lot_no = ? And lot_sl	= ? ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, msite_code);
					pstmt.setString(2, mitem_code);
					pstmt.setString(3, mloc_code);
					pstmt.setString(4, mlot_no);
					pstmt.setString(5, mlot_sl);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						ls_acct_code__dr = checkNullAndTrim(rs.getString("acct_code__inv"));
						ls_cctr_code__dr = checkNullAndTrim(rs.getString("cctr_code__inv"));
						ls_grade = checkNullAndTrim(rs.getString("grade"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
		
					if(ls_acct_code__dr == null || ls_acct_code__dr.length() == 0)
					{
						ls_cctr_code__dr = finCommon.getAcctDetrTtype(mitem_code, mitem_ser, "STKINV", ls_trantype, conn);
						
						if (ls_cctr_code__dr != null && ls_cctr_code__dr.trim().length() > 0) 
						{
							String tokens [] = ls_cctr_code__dr.split(",");
							System.out.println("Length=["+tokens.length+"]");
		
							if ( tokens.length >= 2)
							{
								ls_acct_code__dr = tokens[0];
								ls_cctr_code__dr = tokens[1];
		
								ls_acct_code__dr = checkNullAndTrim(ls_acct_code__dr);
								ls_cctr_code__dr = checkNullAndTrim(ls_cctr_code__dr);
							}
							else
							{
								ls_acct_code__dr = ls_cctr_code__dr.substring(0,ls_cctr_code__dr.indexOf(","));
								ls_cctr_code__dr = ls_cctr_code__dr.substring(ls_cctr_code__dr.indexOf(",") + 1);
							}
							tokens = null;
						}
						System.out.println("@@ls_cctr_code__dr ["+ls_cctr_code__dr+"]");
						//ls_acct_code__dr = ls_cctr_code__dr.substring(0,ls_cctr_code__dr.indexOf(","));
						//ls_cctr_code__dr = ls_cctr_code__dr.substring(ls_cctr_code__dr.indexOf(",")+1);
					}
					if(ls_cctr_code__cr == null || ls_cctr_code__cr.length() == 0)
					{
						ls_cctr_code__cr = finCommon.getAcctDetrTtype(mitem_code, mitem_ser, "COGS", ls_trantype, conn);
						if (ls_cctr_code__cr != null && ls_cctr_code__cr.trim().length() > 0) 
						{
							String tokens [] = ls_cctr_code__cr.split(",");
							System.out.println("Length=["+tokens.length+"]");
		
							if ( tokens.length >= 2)
							{
								ls_acct_code__cr = tokens[0];
								ls_cctr_code__cr = tokens[1];
		
								ls_acct_code__cr = checkNullAndTrim(ls_acct_code__cr);
								ls_cctr_code__cr = checkNullAndTrim(ls_cctr_code__cr);
							}
							else
							{
								ls_acct_code__cr = ls_cctr_code__cr.substring(0,ls_cctr_code__cr.indexOf(","));
								ls_cctr_code__cr = ls_cctr_code__cr.substring(ls_cctr_code__cr.indexOf(",") + 1);
							}
							tokens = null;
						}
		
					}
		
					if(ls_cctr_code__cr == null || ls_cctr_code__cr.length() == 0)
					{
						ls_cctr_code__cr = ls_cctr_code__dr;
					}
		
					if(minvoice_id != null && minvoice_id.trim().length()>0)
					{
						if(ll_line_no__invtrace == 0)
						{
							sql = "select desp_id,desp_line_no from invoice_trace where invoice_id = ? and inv_line_no = ? and	item_code =	? and lot_no = ? and lot_sl	= ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1, minvoice_id);
							pstmt.setInt(2, ll_line_no_inv);
							pstmt.setString(3, mitem_code);
							pstmt.setString(4, mlot_no);
							pstmt.setString(5, mlot_sl);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								ls_desp_id = checkNullAndTrim(rs.getString("desp_id"));
								ls_desp_line_no = checkNullAndTrim(rs.getString("desp_line_no"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{
							sql = "select desp_id,desp_line_no from invoice_trace where invoice_id = ? and inv_line_no = ? and line_no = ? and	item_code =	? and lot_no = ? and lot_sl	= ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1, minvoice_id);
							pstmt.setInt(2, ll_line_no_inv);
							pstmt.setInt(3, ll_line_no__invtrace);
							pstmt.setString(4, mitem_code);
							pstmt.setString(5, mlot_no);
							pstmt.setString(6, mlot_sl);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								ls_desp_id = checkNullAndTrim(rs.getString("desp_id"));
								ls_desp_line_no = checkNullAndTrim(rs.getString("desp_line_no"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
		
					sql = "select cost_rate from despatchdet where desp_id = ? and line_no = ? ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, ls_desp_id);
					pstmt.setString(2, ls_desp_line_no);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lc_rate = rs.getDouble("cost_rate");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
		
					stockUpd.put("tran_date",mtran_date) ;
					stockUpd.put("tran_ser","S-RET") ;
					stockUpd.put("gross_rate",lc_rate) ;
					stockUpd.put("tran_id",msalereturn);
					mline_no= "   "+mline_no;
					mline_no = mline_no.substring(mline_no.length()-3, mline_no.length());
					stockUpd.put("line_no",mline_no);
					stockUpd.put("sale_order",minvoice_id);
					stockUpd.put("item_code",mitem_code);
					stockUpd.put("site_code",ls_sitecodedlv); 
					stockUpd.put("loc_code",mloc_code);
					stockUpd.put("unit",munit);
					stockUpd.put("lot_no",mlot_no);
					stockUpd.put("lot_sl", mlot_sl);
		
					if( lc_physicalqty == 0 )
					{
						lc_physicalqty = mquantity;
					}
					if("P".equalsIgnoreCase(ls_sretinvqty))
					{
						stockUpd.put("qty_stduom",lc_physicalqty);
					}
					else{
						stockUpd.put("qty_stduom",mquantity);
					}
					stockUpd.put("rate",lc_rate);
					stockUpd.put("inv_stat",minv_stat);
					stockUpd.put("exp_date",mexp_date);
					stockUpd.put("item_ser",mitem_ser);
					stockUpd.put("mfg_date",mmfg_date);
					stockUpd.put("site_code__mfg",msite_code_mfg);
					stockUpd.put("reas_code",mreas_code);
					stockUpd.put("pack_code",mpack_code);
					stockUpd.put("tran_type","R");
					stockUpd.put("grade",ls_grade);
					stockUpd.put("acct_code_inv",ls_acct_code__dr);
					stockUpd.put("cctr_code_inv",ls_cctr_code__dr);
					stockUpd.put("acct_code__cr",ls_acct_code__cr);
					stockUpd.put("acct_code__dr",ls_acct_code__dr);
					stockUpd.put("cctr_code__cr",ls_cctr_code__cr);
					stockUpd.put("cctr_code__dr",ls_cctr_code__dr);
					stockUpd.put("no_art",Double.parseDouble(lc_no_art));
					stockUpd.put("gross_weight",lc_gross_wt);
					stockUpd.put("tare_weight",lc_tare_wt);
					stockUpd.put("net_weight",lc_net_wt);
		
					merrcode = stockUpdate.updateStock(stockUpd,xtraParams, conn);
					System.out.println("After stockUpdate1 ["+merrcode+"]");
					if(merrcode !=null && merrcode.trim().length() >0)  
					{
						return merrcode;
					}
				
					if("Y".equalsIgnoreCase(ls_channel_partner) && "E".equalsIgnoreCase(ls_dis_link))
					{
						stockUpd.put("inv_stat",ls_tran_stat);
						stockUpd.put("loc_code",ls_loc_code_git);
						stockUpd.put("tran_type","I");
						merrcode = stockUpdate.updateStock(stockUpd,xtraParams, conn);
						System.out.println("After stockUpdate2 ["+merrcode+"]");
						if(merrcode !=null && merrcode.trim().length() >0)  
						{
							return merrcode;
						}
					}
				}//END tran type R (Sales return) by wasim on 19-MAY-2017
				else //Added by wasim on 19-05-2017 else part for Replace (ID) 
				{
					System.out.println("$$$$$$$$$$$Inside Sales Replacement------->["+mflag+"]$$$$$$$$$$$$$$");
					
					sql = "Select (case when var_value is null then 'N' else var_value end) From finparm Where prd_code = '999999' And var_name = 'INV_ACCT_SRET'";
					pstmt=conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						ls_online_acct = checkNullAndTrim(rs.getString(1));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
		
					if(minvoice_id != null && minvoice_id.length() > 0)
					{
						sql = "Select inv_type From invoice Where invoice_id = ? ";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, minvoice_id);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ls_trantype = checkNullAndTrim(rs.getString("inv_type"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					else
					{
						ls_trantype = "  ";
					}
		
					sql = "Select acct_code__inv, cctr_code__inv, grade From stock Where site_code = ? And item_code = ? And loc_code  = ? And lot_no =  ? And lot_sl = ? ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, msite_code);
					pstmt.setString(2, mitem_code);
					pstmt.setString(3, mloc_code);
					pstmt.setString(4, mlot_no);
					pstmt.setString(5, mlot_sl);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						ls_acct_code__cr = checkNullAndTrim(rs.getString("acct_code__inv"));
						ls_cctr_code__cr = checkNullAndTrim(rs.getString("cctr_code__inv"));
						ls_grade = checkNullAndTrim(rs.getString("grade"));
					}
					if(ls_cctr_code__cr == null || ls_cctr_code__cr.length() == 0)
					{
						ls_cctr_code__cr = finCommon.getAcctDetrTtype(mitem_code, mitem_ser, "COGS", ls_trantype, conn);
						if (ls_cctr_code__cr != null && ls_cctr_code__cr.trim().length() > 0) 
						{
							String tokens [] = ls_cctr_code__cr.split(",");
		
							System.out.println("Length="+tokens.length);
		
							if ( tokens.length >= 2)
							{
								ls_acct_code__cr = tokens[0];
								ls_cctr_code__cr = tokens[1];
		
								ls_acct_code__cr = checkNullAndTrim(ls_acct_code__cr);
								ls_cctr_code__cr = checkNullAndTrim(ls_cctr_code__cr);
							}
							else
							{
								ls_acct_code__cr = ls_cctr_code__cr.substring(0,ls_cctr_code__cr.indexOf(","));
								ls_cctr_code__cr = ls_cctr_code__cr.substring(ls_cctr_code__cr.indexOf(",") + 1);
							}
							tokens = null;
						}
					}
		
					if(ls_acct_code__dr == null || ls_acct_code__dr.length() == 0)
					{
						ls_cctr_code__dr = finCommon.getAcctDetrTtype(mitem_code, mitem_ser, "", ls_trantype, conn);
						if (ls_cctr_code__dr != null && ls_cctr_code__dr.trim().length() > 0) 
						{
							String tokens [] = ls_cctr_code__dr.split(",");
		
							System.out.println("Length="+tokens.length);
		
							if ( tokens.length >= 2)
							{
								ls_acct_code__dr = tokens[0];
								ls_cctr_code__dr = tokens[1];
		
								ls_acct_code__dr = checkNullAndTrim(ls_acct_code__dr);
								ls_cctr_code__dr = checkNullAndTrim(ls_cctr_code__dr);
							}
							else
							{
								ls_acct_code__dr = ls_cctr_code__dr.substring(0,ls_cctr_code__dr.indexOf(","));
								ls_cctr_code__dr = ls_cctr_code__dr.substring(ls_cctr_code__dr.indexOf(",") + 1);
							}
							tokens = null;
						}
		
					}
					if(ls_cctr_code__dr == null || ls_cctr_code__dr.trim().length() == 0)
					{
						ls_cctr_code__dr = ls_cctr_code__cr;
					}
		
					if("db2".equalsIgnoreCase(DB))
					{
						sql = "Select a.quantity From stock a, invstat b Where a.inv_stat = b.inv_stat And a.item_code = ? and a.site_code = ? And a.loc_code = ? And a.lot_no = ? And a.lot_sl = ? for update";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, mitem_code);
						pstmt.setString(2, msite_code);
						pstmt.setString(3, mloc_code);
						pstmt.setString(4, mlot_no);
						pstmt.setString(5, mlot_sl);
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							mtot_stk = rs.getDouble(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else if("mysql".equalsIgnoreCase(DB))
					{
						sql = "Select a.quantity From stock a, invstat b Where a.inv_stat = b.inv_stat And a.item_code = ? and a.site_code = ? And a.loc_code = ? And a.lot_no = ? And a.lot_sl = ? for update";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, mitem_code);
						pstmt.setString(2, msite_code);
						pstmt.setString(3, mloc_code);
						pstmt.setString(4, mlot_no);
						pstmt.setString(5, mlot_sl);
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							mtot_stk = rs.getDouble(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else if("mssql".equalsIgnoreCase(DB))
					{
						sql = "Select a.quantity From stock a (updlock), invstat b Where a.inv_stat = b.inv_stat And a.item_code = ? and a.site_code = ? And a.loc_code = ? And a.lot_no = ? And a.lot_sl = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, mitem_code);
						pstmt.setString(2, msite_code);
						pstmt.setString(3, mloc_code);
						pstmt.setString(4, mlot_no);
						pstmt.setString(5, mlot_sl);
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							mtot_stk = rs.getDouble(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						sql = "Select a.quantity From stock a, invstat b Where a.inv_stat = b.inv_stat And a.item_code = ? and a.site_code = ? And a.loc_code = ? And a.lot_no = ? And a.lot_sl = ? for update nowait ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, mitem_code);
						pstmt.setString(2, msite_code);
						pstmt.setString(3, mloc_code);
						pstmt.setString(4, mlot_no);
						pstmt.setString(5, mlot_sl);
						rs = pstmt.executeQuery();
						if(rs.next())
						{										
							mtot_stk = rs.getDouble(1);
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
		
					if(mtot_stk < mquantity)     
					{
						merrcode = "VTDIST4" + " ~t for site code : " + msite_code + " for item code : " + mitem_code + " for loc.code : " + mloc_code + " for lot no : " + mlot_no + " for lot sl.: " + mlot_sl;
						errorString = vdt.getErrorString("",merrcode,"");
						return errorString;
					}
		
					stockUpd.put("tran_date",mtran_date) ;
					stockUpd.put("tran_ser","S-RET") ;
					stockUpd.put("tran_id",msalereturn);
					mline_no= "   "+mline_no;
					mline_no = mline_no.substring(mline_no.length()-3, mline_no.length());
					stockUpd.put("line_no",mline_no);
					stockUpd.put("sale_order",minvoice_id);
					stockUpd.put("item_code",mitem_code);
					stockUpd.put("site_code",ls_sitecodedlv); 
					stockUpd.put("loc_code",mloc_code);
					stockUpd.put("unit",munit);
					stockUpd.put("lot_no",mlot_no);
					stockUpd.put("lot_sl", mlot_sl);
					stockUpd.put("qty_stduom",mquantity);
					stockUpd.put("rate",lc_rate);
					stockUpd.put("exp_date",mexp_date);
					stockUpd.put("item_ser",mitem_ser);
					stockUpd.put("mfg_date",mmfg_date);
					stockUpd.put("site_code__mfg",msite_code_mfg);
					stockUpd.put("reas_code",mreas_code);
					stockUpd.put("tran_type","ID");
					stockUpd.put("grade",ls_grade);
					stockUpd.put("acct_code_inv",ls_acct_code__dr);
					stockUpd.put("cctr_code_inv",ls_cctr_code__dr);
					stockUpd.put("acct_code__cr",ls_acct_code__cr);
					stockUpd.put("acct_code__dr",ls_acct_code__dr);
					stockUpd.put("cctr_code__cr",ls_cctr_code__cr);
					stockUpd.put("cctr_code__dr",ls_cctr_code__dr);
					stockUpd.put("no_art",Double.parseDouble(lc_no_art));
					stockUpd.put("gross_weight",lc_gross_wt);
					stockUpd.put("tare_weight",lc_tare_wt);
					stockUpd.put("net_weight",lc_net_wt);
		
					merrcode = stockUpdate.updateStock(stockUpd,xtraParams, conn);
					System.out.println("After stockUpdate3 ["+merrcode+"]");
					if(merrcode !=null && merrcode.trim().length() >0)  
					{
						//Commented by wasim as it is returning the full XML
						//errorString = vdt.getErrorString("",merrcode,"");
						//return errorString;
						return merrcode;
					}
		
					if("Y".equalsIgnoreCase(ls_channel_partner) && "E".equalsIgnoreCase(ls_dis_link))
					{
						stockUpd.put("inv_stat",ls_tran_stat);
						stockUpd.put("loc_code",ls_loc_code_git);
						stockUpd.put("tran_type","R");
						merrcode = stockUpdate.updateStock(stockUpd,xtraParams, conn);
						if(merrcode !=null && merrcode.trim().length() >0)  
						{
							errorString = vdt.getErrorString("",merrcode,"");
							return errorString;
						}
					}
				} //End else part for Replaced (ID) by wasim on 19-MAY-2017
			
			}//End while loop for sales return Details
			//Added by wasim on 19-MAY-2017 to use while loop instead of if for multiple lines in sales return details [END]
			if(rsDetail!=null)
			{
				rsDetail.close();rsDetail = null;
			}
			if(pstmtDetail!=null)
			{
				pstmtDetail.close();pstmtDetail = null;
			}
			//Added by wasim on 19-MAY-2017 to use while loop instead of if for multiple lines in sales return details [END]

			ls_quar_lockcode = distCommon.getDisparams("999999","QUARNTINE_LOCKCODE",conn) ;
			if("NULLFOUND".equalsIgnoreCase(ls_quar_lockcode))
			{
				ls_quar_lockcode = " ";
			}
			else if(ls_quar_lockcode != null && ls_quar_lockcode.trim().length() > 0)
			{
				sql = "Select count(*) From sreturndet Where tran_id = ? and qc_reqd = 'Y'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ll_count = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			if(ll_count > 0)
			{
				sql = "select a.site_code,b.item_code,b.loc_code,b.lot_no,b.lot_sl from sreturn a, sreturndet b where a.tran_id = ? and a.tran_id = b.tran_id and b.qc_reqd='Y'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				while(rs.next())
				{										
					msite_code = checkNullAndTrim(rs.getString(1));
					mitem_code = checkNullAndTrim(rs.getString(2));
					mloc_code = checkNullAndTrim(rs.getString(3));
					mlot_no = checkNull(rs.getString(4));
					mlot_sl = checkNull(rs.getString(5));

					tempList.add(msite_code);
					tempList.add(mitem_code);
					tempList.add(mloc_code);
					tempList.add(mlot_no);
					tempList.add(mlot_sl);
					System.out.println("tempList on confirm:::"+tempList);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				merrcode = invHoldGen.generateHoldTrans(ls_quar_lockcode, msalereturn, "S-RET", msite_code, tempList, xtraParams, conn);
				System.out.println("After invHoldGen.generateHoldTrans ["+merrcode+"]");
				if (merrcode != null && merrcode.trim().length() > 0)
				{
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}
			}

			if("Y".equalsIgnoreCase(ls_channel_partner) && "E".equalsIgnoreCase(ls_dis_link))
			{
				sql = "Select count(*) From sreturndet Where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ll_sret_count = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				sql = "Select count(*) From invtrace Where ref_ser = 'S-RET' And ref_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ll_invtrace_count = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(ll_sret_count != ll_invtrace_count)
				{
					merrcode = "VTMISMATCH";
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}
			}

			if((merrcode.trim().length() == 0 || merrcode == null) && !"B".equalsIgnoreCase(gs_run_mode))
			{
				sql = "select full_ret ,invoice_id, tran_type from sreturn where  tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					mfull_ret = checkNullAndTrim(rs.getString(1));
					minvoice_id = checkNullAndTrim(rs.getString(2));
					ls_tran_type = checkNullAndTrim(rs.getString(3));
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(minvoice_id != null && minvoice_id.length()>0)
				{
					sql = "Select count(*) From invoice_amendment where invoice_id = ? and confirmed  = 'Y' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,minvoice_id );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						ll_invamd_count = rs.getInt(1);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					if("IC".equalsIgnoreCase(ls_tran_type) && "Y".equalsIgnoreCase(mfull_ret) && ll_invamd_count == 0)
					{
						sql = "Update invoice Set doc_status = 'C' Where invoice_id	= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,minvoice_id );
						int rowcnt = pstmt.executeUpdate();
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
				}
				if(gs_run_mode == null)
				{
					gs_run_mode = "I";
				}

				if((merrcode == null || merrcode.trim().length() == 0) && !"B".equalsIgnoreCase(gs_run_mode) )
				{
					sql = "Select emp_code From users Where code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,chgUser );
					rs = pstmt.executeQuery();
					if(rs.next())
					{										
						memp_code = checkNullAndTrim(rs.getString("emp_code"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					sql = "Update sreturn Set confirmed ='Y', conf_date = ?, emp_code__aprv = ? Where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, currDate);
					pstmt.setString(2,memp_code );
					pstmt.setString(3,msalereturn );
					int rowcnt = pstmt.executeUpdate();
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			
			//Changed by wasim on 05-JUN-2017 for [START]
			if(detCnt != 0)
			{
				retString  =  invacct.postSalesReturn (msalereturn, xtraParams, "", conn);
			}
			System.out.println("After InvAcct confirmSalesReturn ["+retString+"]");
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			//Changed by wasim on 05-JUN-2017 for [END]

			if(!"B".equalsIgnoreCase(gs_run_mode))
			{
				String ediOption = "";
				sql = "select edi_option from transetup where tran_window = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "w_salesreturn_retn");
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					ediOption = rs.getString("edi_option");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if("Y".equalsIgnoreCase(ls_channel_partner) && "E".equalsIgnoreCase(ls_dis_link))
				{
					if ("2".equals(ediOption)) 
					{
						//	CreateRCPXML createRCPXML = new CreateRCPXML("w_salesreturn", "tran_id");
						CreateRCPXML createRCPXML = new CreateRCPXML("w_salesreturn_retn", "tran_id");
						dataStr = createRCPXML.getTranXML(msalereturn, conn);
						System.out.println("dataStr =[ " + dataStr + "]");
						Document ediDataDom = genericUtility.parseString(dataStr);

						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						//	retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_salesreturn", "2", xtraParams, conn);
						retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_salesreturn_retn", "2", xtraParams, conn);
						createRCPXML = null;
						e12CreateBatchLoad = null;

						if (retString != null && "SUCCESS".equalsIgnoreCase(retString)) 
						{
							System.out.println("retString from edi 2 batchload = [" + retString + "]");
						}
					}

					else 
					{
						//	CreateRCPXML createRCPXML = new CreateRCPXML("w_salesreturn","tran_id");
						CreateRCPXML createRCPXML = new CreateRCPXML("w_salesreturn_retn","tran_id");
						dataStr = createRCPXML.getTranXML(msalereturn, conn);
						System.out.println("dataStr =[ " + dataStr + "]");
						Document ediDataDom = genericUtility.parseString(dataStr);

						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						//	retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_salesreturn", ediOption, xtraParams, conn);
						retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_salesreturn_retn", ediOption, xtraParams, conn);
						createRCPXML = null;
						e12CreateBatchLoad = null;

						if (retString != null && "SUCCESS".equalsIgnoreCase(retString)) 
						{
							System.out.println("retString from batchload = ["+ retString + "]");
						}
					}
				}


				sql = "Select count(*) From sreturndet Where tran_id = ? and ret_rep_flag = 'P'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,msalereturn );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ll_count = rs.getInt(1);
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(ll_count > 0)
				{
					merrcode = postordact.schemeHistoryUpd(msalereturn,msite_code,"R",conn) ;
					if (merrcode != null && merrcode.trim().length() > 0)
					{
						errorString = vdt.getErrorString("",merrcode,"");
						return errorString;
					}
					ls_var_value = distCommon.getDisparams("999999","PUR_INTEGRATED",conn) ;

					if(("Y".equalsIgnoreCase(ls_channel_partner) && "Y".equalsIgnoreCase(ls_var_value)) || Integer.parseInt(ls_edioption) > 0)
					{
						if("E".equalsIgnoreCase(ls_dis_link))
						{
							if ("2".equals(ls_edioption)) 
							{
								CreateRCPXML createRCPXML = new CreateRCPXML("w_salesrcp", "tran_id");
								dataStr = createRCPXML.getTranXML(msalereturn, conn);
								System.out.println("dataStr =[ " + dataStr + "]");
								Document ediDataDom = genericUtility.parseString(dataStr);

								E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
								retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_salesrcp", "2", xtraParams, conn);
								createRCPXML = null;
								e12CreateBatchLoad = null;

								if (retString != null && "SUCCESS".equalsIgnoreCase(retString)) 
								{
									System.out.println("retString from edi 2 batchload = [" + retString + "]");
								}
							}

							else 
							{
								CreateRCPXML createRCPXML = new CreateRCPXML("w_salesrcp","tran_id");
								dataStr = createRCPXML.getTranXML(msalereturn, conn);
								System.out.println("dataStr =[ " + dataStr + "]");
								Document ediDataDom = genericUtility.parseString(dataStr);

								E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
								retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_salesrcp", ls_edioption, xtraParams, conn);
								createRCPXML = null;
								e12CreateBatchLoad = null;

								if (retString != null && "SUCCESS".equalsIgnoreCase(retString)) 
								{
									System.out.println("retString from batchload = ["+ retString + "]");
								}
							}
						}
						/*else if("A".equalsIgnoreCase(ls_dis_link) || "S".equalsIgnoreCase(ls_dis_link) || "C".equalsIgnoreCase(ls_dis_link) )
						{
							merrcode = nvo_porcp.gbf_create_sreturn_porcp(ls_hdr,ls_det,sqlca_cp,ls_dis_link);
						}*/
						else
						{
							merrcode = "VTSRET24";
							errorString = vdt.getErrorString("",merrcode,"");
							return errorString;	
						}
					}
				}
			}
			sql = "select invoice_id, tran_type, site_code, tran_date, cust_code, ret_opt From sreturn Where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_invoice_id = checkNullAndTrim(rs.getString("invoice_id"));
				ls_tran_type = checkNullAndTrim(rs.getString("tran_type"));
				ls_site_code = checkNullAndTrim(rs.getString("site_code"));
				ld_tran_date = rs.getDate("tran_date");
				ls_cust_code = checkNullAndTrim(rs.getString("cust_code"));
				ls_ret_opt = checkNullAndTrim(rs.getString("ret_opt"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(!"R".equalsIgnoreCase(ls_ret_opt) && !"B".equalsIgnoreCase(gs_run_mode))
			{
				ls_crdt = finCommon.getFinparams("999999", "SRET_CRN_DATE", conn);
				String ls_crdtArray[]=ls_crdt.split(";");
				ls_crdt = ls_crdtArray[0];
				if(ls_crdt == null || ls_crdt.trim().length() == 0)
				{
					ls_crdt = " ";
				}
				if("NULLFOUND".equalsIgnoreCase(ls_crdt))
				{
					merrcode = "VTENVAR1";
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;	
				}
				else if("S".equalsIgnoreCase(ls_crdt))
				{
					ld_today = new Date(currDate.getTime());
				}
				else if("T".equalsIgnoreCase(ls_crdt))
				{
					ld_today = ld_tran_date;
				}
				ls_var_value = distCommon.getDisparams("999999","CRN_ON_SRETURN",conn) ;
				
				System.out.println("CRN_ON_SRETURN["+ls_var_value+"]");
				
				if(ls_var_value == null || ls_var_value.trim().length() == 0)
				{
					ls_var_value = " ";
				}
				else if(!"N".equalsIgnoreCase(ls_var_value.trim()))
				{
					if(ls_invoice_id == null || ls_invoice_id.trim().length() == 0)
					{
						merrcode = gbf_auto_crnote_sreturn_misc(currDate, ls_tran_type, ls_site_code, msalereturn, msalereturn, ld_tran_date, ld_tran_date, ls_cust_code,ls_cust_code, "Y", xtraParams, conn);
						//merrcode = gbf_auto_crnote_sreturn_misc(ld_today, ls_tran_type, ls_site_code,as_tran_id, as_tran_id, ld_tran_date, ld_tran_date, ls_cust_code, ls_cust_code, 'Y');
					}
					else
					{
						merrcode = gbf_auto_crnote_sreturn(currDate, ls_tran_type, ls_site_code, msalereturn, msalereturn, ld_tran_date, ld_tran_date, ls_cust_code,ls_cust_code, "Y", xtraParams, conn);
					}

				}
				if(merrcode != null && merrcode.trim().length() >  0)
				{
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;	
				}
			}
			if((ls_invoice_id != null && ls_invoice_id.trim().length() > 0) && "C".equalsIgnoreCase(ls_ret_opt))
			{
				ls_comm_calc_on_off =  finCommon.getFinparams("999999", "COMM_CALC_ON_OFF", conn);
			}

			if("Y".equalsIgnoreCase(ls_comm_calc_on_off))
			{
				CalculateCommission calCom = new CalculateCommission();
				ls_conf_drcr_opt =  finCommon.getFinparams("999999", "COMM_DRCR_CONF", conn);
				ls_conf_jv_opt =  finCommon.getFinparams("999999", "COMM_JV_CONF", conn);
				merrcode =  calCom.CalCommission(ls_invoice_id,"SR",msalereturn,ls_conf_drcr_opt,ls_conf_jv_opt,xtraParams, conn);
				if(merrcode != null && merrcode.trim().length() > 0)
				{
					errorString = vdt.getErrorString("",merrcode,"");
					return errorString;
				}
			}

		}
		catch(Exception e)
		{	
			System.out.println("Expception inside confirmSalesReturn-->["+e.getMessage()+"]");
			isError = true;
			e.printStackTrace();
			errMessage = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//Changed by wasim on 15-MAY-17 for returning the success error string if merrcode and errorString and blank [START]
				System.out.println("Inside Finaly confirmSalesReturn["+isError+"] merrcode["+merrcode+"] errorString["+errorString+"]");
				if(!isError)
				{
					if((errorString == null || errorString.trim().length() == 0) && (merrcode == null || merrcode.trim().length() == 0))
					{
						errorString = itmDBAccessLocal.getErrorString("", "VTSRTRNCMP", "", "", conn);
					}
				}
				else if(isError)
				{
					errorString = getError(errMessage , "VTSRTRNFLR" , conn);
					return errorString ;
				}
				//Changed by wasim on 15-MAY-17 for returning the success error string  if merrcode and errorString and blank [END]
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}
				if(rsDetail!=null)
				{
					rsDetail.close();rsDetail = null;
				}
				if(pstmtDetail!=null)
				{
					pstmtDetail.close();pstmtDetail = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		System.out.println("Returning from confirmSalesReturn ["+errorString+"]");
		return errorString;
	}
	public String gbf_create_sretqc(String msalereturn, String xtraParams, Connection conn) throws ITMException
	{
		String	sql = "",chgUser = "", chgTerm = "",errorString = "", ls_errcode = "", ls_itemcode = "", ls_unit = "", ls_loccode = "", ls_lotno = "", ls_lotsl = "", merrcode = "", ls_sitecode = "", ls_sretinvqty = "", ls_supp_code__mfg = "", ls_supp_code = "";
		Date ldt_expdate = null, ldt_mfgdate = null;
		double	lc_quantity = 0, lc_sample_qty = 0, lc_physicalqty = 0, lc_gross_wt = 0, lc_net_wt = 0;
		String ll_lineno = "";
		int ll_ctr = 0, ll_count = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ValidatorEJB vdt=new ValidatorEJB();
		DistCommon distCommon = new DistCommon();
		//FinCommon finCommon = new FinCommon();
		Timestamp currDate = null;
		HashMap lstr_qc = new HashMap();
		/*s_qcorder lstr_qc
		nvo_business_object_create_qord lnvo_qc

		if itm_structure.dis_comp = 0 then 
			lnvo_qc = create nvo_business_object_create_qord
		else
			itm_app_server[itm_structure.dis_comp].createinstance(lnvo_qc)
		end if*/

		try
		{
			System.out.println("------- Inside gbf_create_sretqc ----------------");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			sql = "select site_code from sreturn where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_sitecode = checkNullAndTrim(rs.getString("site_code"));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			
			ls_sretinvqty = distCommon.getDisparams("999999","SRET_INV_QTY",conn) ;
			System.out.println("ls_sretinvqty--------->>"+ls_sretinvqty);

			sql = "select item_code, sum(quantity__stduom) ,count(1), max(lot_sl), max(unit__std), loc_code, lot_no, min(exp_date), Min(line_no), min(mfg_date), sum(physical_qty) " +
			" from sreturndet where tran_id = ? and	qc_reqd = 'Y' Group by loc_code, item_code, lot_no Order by loc_code, item_code, lot_no";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,msalereturn );
			rs = pstmt.executeQuery();
			while(rs.next())
			{										
				ls_itemcode = checkNullAndTrim(rs.getString(1));
				lc_quantity = rs.getDouble(2);
				ll_ctr = rs.getInt(3);
				ls_lotsl = checkNullAndTrim(rs.getString(4));
				ls_unit = checkNullAndTrim(rs.getString(5));
				ls_loccode = checkNullAndTrim(rs.getString(6));
				ls_lotno = checkNullAndTrim(rs.getString(7));
				ldt_expdate = rs.getDate(8);
				ll_lineno = checkNullAndTrim(rs.getString(9));
				ldt_mfgdate = rs.getDate(10);
				lc_physicalqty = rs.getDouble(11);
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			

			System.out.println("ll_ctr--------->>"+ll_ctr);
			if(ll_ctr > 1)
			{
				//SetNull(ls_lotsl)
				ls_lotsl = " ";
			}

			sql = "select QTY_SAMPLE from siteitem where site_code = ? and item_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,ls_sitecode );
			pstmt.setString(2,ls_itemcode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				lc_sample_qty = rs.getDouble("QTY_SAMPLE");
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			
			System.out.println("lc_sample_qty--------->>"+lc_sample_qty);
			
			if(lc_sample_qty == 0)
			{
				sql = "select QTY_SAMPLE from item where item_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,ls_itemcode );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					lc_sample_qty = rs.getDouble("QTY_SAMPLE");
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}
				System.out.println("lc_sample_qty 111111 --------->>"+lc_sample_qty);
				
			}
			sql = "select count(*) from item_lot_info where item_code = ? and lot_no = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,ls_itemcode );
			pstmt.setString(2,ls_lotno );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ll_count = rs.getInt(1);;
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}
			System.out.println("ll_count 111111 --------->>"+ll_count);
			
			if (ll_count > 0)
			{
				sql = "select supp_code__mfg , supp_code, exp_date, mfg_date from item_lot_info where item_code = ? and lot_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,ls_itemcode );
				pstmt.setString(2,ls_lotno );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ls_supp_code__mfg = checkNullAndTrim(rs.getString("supp_code__mfg"));
					ls_supp_code = checkNullAndTrim(rs.getString("supp_code"));
					ldt_expdate = rs.getDate("exp_date");
					ldt_mfgdate = rs.getDate("mfg_date");
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}			
			}
			System.out.println("ll_count 22222222 --------->>"+ll_count);
			System.out.println("ls_supp_code__mfg 22222222 --------->>"+ls_supp_code__mfg);
			if (ll_count == 0 || ls_supp_code__mfg == null)
			{
				sql = "select exp_date, mfg_date, supp_code__mfg from stock where item_code = ? and site_code = ? and lot_no = ? " +
						"and exp_date is not null ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,ls_itemcode );
				pstmt.setString(2,ls_sitecode );
				pstmt.setString(3,ls_lotno );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ldt_expdate = rs.getDate(1);
					ldt_mfgdate = rs.getDate(2);
					ls_supp_code__mfg = checkNullAndTrim(rs.getString(3));
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}	
				System.out.println(" 22222222 --------->>");
			}
			
			lstr_qc.put("supp_code", ls_supp_code);	
			lstr_qc.put("supp_code__mfg", ls_supp_code__mfg);	
			lstr_qc.put("qorder_type", "I");	
			lstr_qc.put("qorder_date", currDate);	
			lstr_qc.put("site_code", ls_sitecode);	
			lstr_qc.put("item_code", ls_itemcode);	

			if(lc_physicalqty == 0 )
			{
				lc_physicalqty = lc_quantity;
			}
			if ("P".equalsIgnoreCase(ls_sretinvqty))
			{
				lstr_qc.put("quantity", lc_physicalqty);
			}
			else
			{
				lstr_qc.put("quantity", lc_quantity);
			}
			lstr_qc.put("lot_no", ls_lotno);
			lstr_qc.put("lot_sl", ls_lotsl);
			lstr_qc.put("loc_code", ls_loccode);
			lstr_qc.put("tran_id", msalereturn);

			ll_lineno= "   "+ll_lineno;
			ll_lineno = ll_lineno.substring(ll_lineno.length()-3, ll_lineno.length());
			
			String expdate = (ldt_expdate == null) ? null : sdf.format(ldt_expdate);
			String mfgdate = (ldt_mfgdate == null) ? null : sdf.format(ldt_mfgdate);

			lstr_qc.put("line_no", ll_lineno);
			lstr_qc.put("unit", ls_unit);
			lstr_qc.put("batch_no", ls_lotno);
			lstr_qc.put("qc_create_type", "A");
			/*lstr_qc.put("expiry_date", expdate);
			lstr_qc.put("mfg_date", mfgdate);*/
			lstr_qc.put("expiry_date", ldt_expdate);
			lstr_qc.put("mfg_date", ldt_mfgdate);
			
			lstr_qc.put("qty_sample", lc_sample_qty);
			lstr_qc.put("route_code", null);

			ls_errcode = createQc(lstr_qc, xtraParams, conn) ;
			if (ls_errcode != null && ls_errcode.trim().length() > 0) 
			{
				errorString = vdt.getErrorString("",ls_errcode,"");
				return errorString;
			}
		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}				
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return errorString;
	}
	public String createQc(HashMap qcOrd,String xtraParams, Connection conn) throws RemoteException, ITMException
	{
		String ls_errcode = "", ls_key = "", ls_win = "", ls_qcno = "", ls_genlotauto = "", ls_supp_code = "",ls_gene_lot_no = "";
		String tranSer = "",keyCol = "",userId = "",chgTerm = "",chgUser = "",sql = "";
		Date ldt_duedate = null;
		String ls_aprv = "", ls_rej = "", ls_empcode = "", ls_item_ser = "", ls_lotno = "", ls_supp_code__mfg = "", ls_procmth ="";
		String lc_qccycletime = "", lc_qcleadtime = "", lc_qcleadtime_item = "", lc_qcleadtime_siteitem = "", lc_qtysample = "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ValidatorEJB vdt=new ValidatorEJB();
		DistCommon distCommon = new DistCommon();
		Timestamp currDate = null;
		UtilMethods utilMethods = UtilMethods.getInstance();
		java.sql.Date startDate = null, dueDate = null, retestDate = null,qcOrderDate = null;
		try
		{
			System.out.println("----------- Inside createQc -------------");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			sql = "select qc_cycle_time, qc_lead_time from item where item_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,qcOrd.get("item_code").toString() );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				lc_qccycletime = checkNullAndTrim(rs.getString(1));
				lc_qcleadtime_item = checkNullAndTrim(rs.getString(2));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			

			sql = "select qc_lead_time,item_ser from siteitem where site_code = ? and item_code = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,qcOrd.get("site_code").toString() );
			pstmt.setString(2,qcOrd.get("item_code").toString() );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				lc_qcleadtime_siteitem = checkNullAndTrim(rs.getString(1));
				ls_item_ser = checkNullAndTrim(rs.getString(2));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			

			if(ls_item_ser == null || ls_item_ser.trim().length() == 0 )
			{
				sql = "select item_ser from item where item_code = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,qcOrd.get("item_code").toString() );
				rs = pstmt.executeQuery();
				if(rs.next())
				{										
					ls_item_ser = checkNullAndTrim(rs.getString(1));
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}			
			}

			if(lc_qccycletime == null || lc_qccycletime.length() == 0)
			{
				lc_qccycletime = "0";
			}

			if(lc_qcleadtime_siteitem == null || lc_qcleadtime_siteitem.length() == 0)
			{
				lc_qcleadtime = lc_qcleadtime_item;
			}
			else
			{
				lc_qcleadtime = lc_qcleadtime_siteitem;
			}

			if(lc_qcleadtime == null || lc_qcleadtime.length() == 0)
			{
				lc_qcleadtime = "0"; 
			}

			ldt_duedate =  utilMethods.RelativeDate(new Date(currDate.getTime()),(Integer.parseInt(lc_qccycletime) + Integer.parseInt(lc_qcleadtime)));

			qcOrd.put("qorder_date", currDateStr);
			qcOrd.put("start_date", currDateStr);
			qcOrd.put("due_date", sdfAppl.format(ldt_duedate));
			
			sql = "select KEY_STRING, TRAN_ID_COL, REF_SER from transetup where tran_window = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"w_qcorder_new" );
			rs = pstmt.executeQuery();
			if(rs.next())
			{										
				ls_key = checkNullAndTrim(rs.getString(1));
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}	
			
			if(ls_key == null || ls_key.length() == 0)
			{
				sql = " select KEY_STRING, TRAN_ID_COL, REF_SER from transetup where tran_window = 'GENERAL'";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ls_key  = rs.getString("key_string");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}
			}

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"user_id");
			String XMLString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
			"\r\n</header><Detail1><site_code>"+qcOrd.get("site_code").toString()+"</site_code><qorder_type>"+qcOrd.get("qorder_type").toString()+"</qorder_type>"+
			" <qorder_date>"+new java.sql.Date(System.currentTimeMillis())+"</qorder_date><lot_no>"+qcOrd.get("lot_no").toString()+"</lot_no><item_ser>"+ls_item_ser+"</item_ser></Detail1></Root>";
			TransIDGenerator tg = new TransIDGenerator(XMLString, userId, "");
			
			ls_qcno = tg.generateTranSeqID(tranSer, keyCol, ls_key, conn);
			if ("ERROR".equals(ls_qcno))
			{
				ls_errcode = new ITMDBAccessEJB().getErrorString("", "VTTRANID", "");
			}

			sql = "select loc_code__aprv,loc_code__rej,PROC_MTH,  QTY_SAMPLE  from siteitem where site_code = ? and item_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,qcOrd.get("site_code").toString() );
			pstmt.setString(2,qcOrd.get("item_code").toString() );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ls_aprv = checkNullAndTrim(rs.getString(1));
				ls_rej = checkNullAndTrim(rs.getString(2));
				ls_procmth = checkNullAndTrim(rs.getString(3));
				lc_qtysample = checkNullAndTrim(rs.getString(4));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}

			if(ls_procmth == null || ls_procmth.length() == 0)
			{
				if(lc_qtysample == null || lc_qtysample.length() == 0)
				{
					lc_qtysample = "0";
				}
				else if(lc_qtysample != null || lc_qtysample.length() > 0)
				{
					qcOrd.put("qty_sample", lc_qtysample);
				}
			}
			else
			{
				qcOrd.put("qty_sample", "0");
			}

			if(qcOrd.get("lot_no").toString() == null || qcOrd.get("lot_no").toString().length() == 0)
			{
				qcOrd.put("lot_no", ls_qcno);
				/*choose case upper(trim(astr_qcorder.transer))
				case 'W-RCP'*/
				sql = "update workorder_receipt set lot_no = ? where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,qcOrd.get("lot_no").toString() );
				pstmt.setString(2,qcOrd.get("tran_id").toString() );
				int rowcnt = pstmt.executeUpdate();
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}	
			}
			sql = "select generate_lot_no from siteitem where site_code= ? and item_code= ?"; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,qcOrd.get("site_code").toString() );
			pstmt.setString(2,qcOrd.get("item_code").toString() );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ls_gene_lot_no = checkNull(rs.getString(1));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}

			if(ls_gene_lot_no == null || ls_gene_lot_no.length() == 0)
			{
				ls_gene_lot_no = "1";
			}
			ls_genlotauto = distCommon.getDisparams("999999","GENERATE_LOT_NO_AUTO",conn) ;

			if("D-RCP".equalsIgnoreCase(tranSer))
			{
				if(("Y".equalsIgnoreCase(ls_genlotauto) || "M".equalsIgnoreCase(ls_genlotauto)) && "1".equalsIgnoreCase(ls_gene_lot_no))
				{
					ls_lotno = qcOrd.get("lot_no").toString();
					qcOrd.put("lot_no",ls_qcno);
				}
			}
			sql = "select emp_code from users where code = ?"; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,userId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ls_empcode = checkNullAndTrim(rs.getString(1));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}
			
			if(qcOrd.get("route_code") == null || qcOrd.get("route_code").toString().trim().length() == 0)
			{
				qcOrd.put("route_code", null);
			}
			String route_code = (qcOrd.get("route_code") == null) ? "" : qcOrd.get("route_code").toString();
			qcOrd.put("qcorder_no", ls_qcno);

			double qtyPass = Double.parseDouble(qcOrd.get("quantity").toString())-Double.parseDouble(qcOrd.get("qty_sample").toString());
			
			if(qcOrd.get("due_date") != null)
			{
				dueDate = java.sql.Date.valueOf(genericUtility.getValidDateString(qcOrd.get("due_date").toString(), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
			}
			System.out.println("---------- dueDate -----------------"+dueDate);
			
			//Changed by wasim to convert for getting proper date formate [START]
			if(qcOrd.get("qorder_date") != null)
			{
				qcOrderDate = java.sql.Date.valueOf(genericUtility.getValidDateString(qcOrd.get("qorder_date").toString(), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
			}
			//Changed by wasim to convert for getting proper date formate [END]
			

			/*if(qcOrd.get("retest_date") != null)
			{
				retestDate = java.sql.Date.valueOf(genericUtility.getValidDateString(qcOrd.get("retest_date").toString(), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
			}
			System.out.println("---------- retestDate -----------------"+retestDate);*/

			sql = "insert into qc_order (qorder_no,qorder_type,qorder_date,site_code,item_code,route_code,quantity,qty_passed,qty_rejected,start_date,due_date,rel_date,porcp_no,porcp_line_no," +
			" lot_no,lot_sl,chg_date,chg_user,chg_term,loc_code,qty_sample,status, unit,qc_create_type,unit__sample,loc_code__aprv,loc_code__rej,lot_no__new, batch_no,expiry_date, proj_code," +
			" emp_code,item_code__new,mfg_date,spec_ref,supp_code,supp_code__mfg,retest_date) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,ls_qcno);	
			pstmt.setString(2,qcOrd.get("qorder_type").toString());	
			//pstmt.setString(3,qcOrd.get("qorder_date").toString());//Changed by wasim on 15-MAY-17
			pstmt.setDate(3,qcOrderDate);
			pstmt.setString(4,qcOrd.get("site_code").toString());	
			pstmt.setString(5,qcOrd.get("item_code").toString());	
			pstmt.setString(6,route_code);	
			pstmt.setDouble(7,Double.parseDouble(qcOrd.get("quantity").toString()));	
			pstmt.setDouble(8,qtyPass);	
			pstmt.setString(9,"0");	
			pstmt.setDate(10, new java.sql.Date(new java.util.Date().getTime()));
			pstmt.setDate(11, dueDate);
			pstmt.setDate(12, new java.sql.Date(new java.util.Date().getTime()));
			pstmt.setString(13,qcOrd.get("tran_id").toString());	
			pstmt.setString(14,qcOrd.get("line_no").toString());	
			pstmt.setString(15,qcOrd.get("lot_no").toString());	
			pstmt.setString(16,qcOrd.get("lot_sl").toString());	
			pstmt.setDate(17,new java.sql.Date(new java.util.Date().getTime()));
			pstmt.setString(18,userId);	
			pstmt.setString(19,chgTerm);	
			pstmt.setString(20,qcOrd.get("loc_code").toString());	
			pstmt.setDouble(21,Double.parseDouble(qcOrd.get("qty_sample").toString()));	
			pstmt.setString(22,"U");
			pstmt.setString(23,qcOrd.get("unit").toString());
			pstmt.setString(24,qcOrd.get("qc_create_type").toString());
			pstmt.setString(25,qcOrd.get("unit").toString());
			pstmt.setString(26,ls_aprv);
			pstmt.setString(27,ls_rej);
			pstmt.setString(28,qcOrd.get("lot_no").toString());
			pstmt.setString(29,qcOrd.get("batch_no").toString());
			pstmt.setDate(30, (java.sql.Date) qcOrd.get("expiry_date"));
			pstmt.setString(31,null);
			
			pstmt.setString(32,ls_empcode);
			pstmt.setString(33,qcOrd.get("item_code").toString());
			pstmt.setDate(34, (java.sql.Date) qcOrd.get("mfg_date"));
			pstmt.setString(35,null);
			pstmt.setString(36,qcOrd.get("supp_code").toString());
			pstmt.setString(37,qcOrd.get("supp_code__mfg").toString());
			//pstmt.setString(38,qcOrd.get("retest_date").toString());			// retest_date is not put into map
			pstmt.setDate(38, null);
			
			pstmt.executeUpdate(); 
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}				
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return ls_errcode;
	}

	public String gbf_auto_crnote_sreturn (Timestamp adt_credit_note, String as_tran_type, String as_site_code, String as_tranid_from, String as_tranid_to, Date adt_tran_date_from, Date adt_tran_date_to, String as_cust_code_from, String as_cust_code_to, String as_post, String xtraParams, Connection conn)
	throws RemoteException, ITMException
	{
		String ls_errcode = "", errorString = "", ls_tran_id = "", ls_invoice_id = "", ls_item_code = "", ls_cust_code = "";
		String ls_old_cust_code = "",  trnofld = "", keystr = "", ls_auto_tran_id = "", ls_round = "";
		String ls_tax_chap = "", ls_tax_class = "", ls_tax_env = "", ls_sales_pers = "", ls_reas_code = "",ls_list_type = "";
		String ls_fin_entity = "", ls_curr_code = "", ls_anal_code = "", ls_emp_code__aprv = "", ls_sales_pers_sreturn = "", ls_sr_inv_tran_id = "", ls_prevtranid = "";
		String ls_acct_code = "", ls_cctr_code = "", ls_cr_term = "", ls_tax_rec = "", ls_item_ser = "", ls_old_item_ser = "", ls_lotsl = "";
		String ls_ret_opt = "",ls_drcr_flag = "",ls_tranwin = "", ls_serial_no = "", ls_sales_order = "",ls_apply_price = "";
		String ls_sord_line_no = "", ls_pricelist = "", ls_item_code_sord = "", ls_item_code__ord = "",ls_sr_tran_id = "", ls_item_code_sr = "",ls_finpara = "",ls_lot_no = "",ls_gp_no = "", ls_sr_ref_ser = "", ls_sr_ref_no = "";
		double lc_qty = 0, lc_qty1 = 0, lc_qty2 = 0, lc_exch_rate = 0, lc_tot_net_amt = 0;
		int ll_line_no = 0;
		String ll_line_no__inv = "", ll_hdr_row = "", ll_det_row = "", ll_line_no_sret = "", ll_count = "", ll_sr_line_no = "", ll_line_no_invtrace = "", li_currow = "";
		String lc_quantity = "", lc_round_to = "", lc_sr_adj_amt = "", lc_sr_ref_bal_amt = "", lc_round_amt = "", lc_diff_amt = "";
		String lc_old_amount = "", lc_old_amount_bc = "", lc_dprice_item = "", chgUser = "", chgTerm = "", transer = "", remarks = "", sql = "", keyCol = "", tranSer = "";
		double lc_rate__clg = 0, lc_qty_stduom = 0, lc_rate_stduom = 0, lc_discount = 0, lc_amt = 0, lc_drcr_amt = 0, lc_net_amt = 0, lc_tax_amt = 0; 
		Timestamp ld_eff_date = null, ld_due_date = null,ld_gp_date = null;
		String ls_rndstr = "", ls_rndTo = "", ls_rndoff = "", ls_ret_ref = "", ls_site_type = "", ls_creat_inv_othlist = "", ls_creat_inv_oth = "", ls_other_site = "";

		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null,rs1=null;
		ValidatorEJB vdt=new ValidatorEJB();
		DistCommon distCommon = new DistCommon();
		//FinCommon finCommon = new FinCommon();
		Timestamp currDate = null;
		UtilMethods utilMethods = UtilMethods.getInstance();
		boolean lb_flag;
		int currRow = 0; //Added by wasim
		try
		{
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			transer = "CRNRCP";
			trnofld = "tran_id";
			ls_cr_term =  finCommon.getFinparams("999999", "CR_PRD_ZERO", conn);

			if ("D".equalsIgnoreCase(ls_ret_opt))
			{
				ls_drcr_flag = "D";		
				transer = "DRNRCP";
				ls_tranwin = "W_DRCRRCP_DR";
				ls_auto_tran_id = generateTranId("w_drcrrcp_dr",as_site_code,currDateStr,conn);	
				remarks = "Auto Generated Debit Note for Sales Return " + ls_tran_id;
			}
			else
			{
				ls_drcr_flag = "C";			
				transer = "CRNRCP";
				ls_tranwin = "W_DRCRRCP_CR";
				ls_auto_tran_id = generateTranId("w_drcrrcp_cr",as_site_code,currDateStr,conn);	
				remarks = "Auto Generated Credit Note for Sales Return " + ls_tran_id;
			}

			lb_flag = false;

			sql = "select KEY_STRING, TRAN_ID_COL, REF_SER from transetup where upper(tran_window) = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,ls_tranwin );
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				keystr = checkNullAndTrim(rs.getString("KEY_STRING"));
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}

			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			

			if(keystr == null || keystr.length() == 0)
			{
				sql = "select KEY_STRING, TRAN_ID_COL, REF_SER from transetup where tran_window = 'GENERAL' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{	
					keystr = checkNullAndTrim(rs.getString("KEY_STRING"));
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
				}

				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}			
			}
			//Changed by wasim on 30-MAY-2017 to copy below code in while loop below [START]
			/*System.out.println("Old CustCode["+ls_old_cust_code+"] CustCode["+ls_cust_code+"] ls_old_item_ser["+ls_old_item_ser+"] ItemSer["+ls_item_ser+"]");
			if(ls_old_cust_code != ls_cust_code || ls_old_item_ser != ls_item_ser)
			{
				sql = "select fin_entity, acct_code__ar, cctr_code__ar, due_date, gp_no, gp_date from invoice where invoice_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ls_invoice_id);
				rs = pstmt.executeQuery();
				if(rs.next())
				{	
					ls_fin_entity = checkNullAndTrim(rs.getString(1));
					ls_acct_code = checkNullAndTrim(rs.getString(2));
					ls_cctr_code = checkNullAndTrim(rs.getString(3));
					ld_due_date = rs.getTimestamp(4);
					ls_gp_no = checkNullAndTrim(rs.getString(5));
					ld_gp_date = rs.getTimestamp(6);
				}

				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}		

				ls_finpara =  finCommon.getFinparams("999999", "INVOICE_DRCR_ADJ", conn);
				if("NULLFOUND".equalsIgnoreCase(ls_finpara))
				{
					ls_finpara = "N" ;
				}

				ls_rndstr = transer + "-RND";
				ls_rndoff =  finCommon.getFinparams("999999", ls_rndstr, conn);

				if (!"NULLFOUND".equalsIgnoreCase(ls_rndoff)) 
				{
					ls_rndoff = ls_rndoff.trim();
				}
				ls_rndstr = transer + "-RNDTO";
				ls_rndTo =  finCommon.getFinparams("999999", ls_rndstr, conn);
				if (!"NULLFOUND".equalsIgnoreCase(ls_rndTo)) 
				{
					ls_rndTo = ls_rndTo.trim();
				}

				sql = "INSERT INTO DRCR_RCP ( tran_id, tran_date, site_code, fin_entity, tran_type," +
				" tran_ser, drcr_flag, cust_code, item_ser, invoice_id ,acct_code ,cctr_code ,eff_date ," +
				" due_date ,curr_code ,exch_rate ,anal_code ,cr_term ,emp_code__aprv ,chg_date ,chg_user," +
				" chg_term,remarks,gp_no,gp_date ,rnd_off,rnd_to,amount,amount__bc,adj_recv,sreturn_no,cust_ref_no) " +
				" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,? ,?,?,?,?,?,?,?) " ; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString( 1, ls_auto_tran_id); 
				pstmt.setTimestamp( 2, adt_credit_note ); 
				pstmt.setString( 3, as_site_code );
				pstmt.setString( 4, ls_fin_entity );
				pstmt.setString( 5, as_tran_type);
				pstmt.setString( 6, transer );
				pstmt.setString( 7, ls_drcr_flag);
				pstmt.setString( 8,ls_cust_code );
				pstmt.setString( 9, ls_item_ser ); 
				pstmt.setString( 10, ls_invoice_id );
				pstmt.setString( 11, ls_acct_code ); 
				pstmt.setString( 12, ls_cctr_code ); 
				pstmt.setTimestamp( 13, ld_eff_date ); 
				pstmt.setTimestamp( 14, ld_eff_date ); 
				pstmt.setString( 15, ls_curr_code ); 
				pstmt.setDouble( 16, lc_exch_rate ); 
				pstmt.setString( 17, ls_anal_code ); 
				pstmt.setString( 18, ls_cr_term ); 
				pstmt.setString( 19, ls_emp_code__aprv ); 
				pstmt.setTimestamp( 20, currDate ); 
				pstmt.setString( 21, chgUser );
				pstmt.setString( 22, chgTerm );
				pstmt.setString( 23, remarks );
				pstmt.setString( 24, ls_gp_no );
				pstmt.setTimestamp( 25, ld_gp_date );
				pstmt.setString( 26, ls_rndoff );
				pstmt.setString( 27, ls_rndTo );
				pstmt.setDouble( 28, lc_tot_net_amt );
				pstmt.setDouble( 29, (lc_tot_net_amt * lc_exch_rate) );
				pstmt.setString( 30, ls_finpara );
				pstmt.setString( 31, ls_tran_id );
				pstmt.setString( 32, ls_ret_ref );

				int cnt=pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}

			sql = "select sales_pers from invoice where invoice_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, ls_invoice_id); 
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				ls_sales_pers = checkNullAndTrim(rs.getString(1));
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}*/	
			//Changed by wasim on 30-MAY-2017 to copy below code in while loop below [END]

			sql = "select a.cust_code__bill, a.eff_date, a.curr_code, a.exch_rate, a.anal_code, a.emp_code__aprv, a.item_ser, b.tran_id, b.invoice_id, b.line_no__inv," +
			" b.item_code, b.quantity, b.net_amt, b.tax_chap, b.tax_class, b.tax_env, b.quantity__stduom, b.rate__stduom, b.discount, b.tax_amt, b.reas_code, b.line_no," +
			" a.sales_pers , a.ret_opt, b.tran_id, b.line_no, b.rate__clg, b.lot_no, b.line_no__invtrace, b.lot_sl, a.ret_ref from 	sreturn a , sreturndet b " +
			" where a.tran_id = b.tran_id and a.tran_id >= ? and a.tran_id <= ? and a.tran_date >= ? " +
			" and a.tran_date <= ? and a.cust_code >= ? and a.cust_code <= ? and a.site_code = ? " +
			" and a.tran_type = ? and a.confirmed = 'Y' and a.ret_opt in ('C','D') and b.invoice_id is not null and a.tran_id__crn is null " +
			" order by a.cust_code, a.item_ser, a.tran_date, a.tran_id ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,as_tranid_from );
			pstmt.setString(2,as_tranid_to );
			pstmt.setDate(3, (java.sql.Date) adt_tran_date_from);
			pstmt.setDate(4,(java.sql.Date) adt_tran_date_to );
			pstmt.setString(5,as_cust_code_from );
			pstmt.setString(6,as_cust_code_to );
			pstmt.setString(7,as_site_code );
			pstmt.setString(8,as_tran_type );
			rs = pstmt.executeQuery();
			while(rs.next())
			{	
				lb_flag = false;
				
				ll_line_no ++;
				ls_cust_code = checkNullAndTrim(rs.getString(1));
				ld_eff_date = rs.getTimestamp(2);
				ls_curr_code = checkNullAndTrim(rs.getString(3));
				lc_exch_rate = rs.getDouble(4);
				ls_anal_code = checkNullAndTrim(rs.getString(5));
				ls_emp_code__aprv = checkNullAndTrim(rs.getString(6));
				ls_item_ser = checkNullAndTrim(rs.getString(7));
				ls_tran_id = checkNullAndTrim(rs.getString(8));
				ls_invoice_id = checkNullAndTrim(rs.getString(9));
				ll_line_no__inv = checkNullAndTrim(rs.getString(10));
				ls_item_code = checkNullAndTrim(rs.getString(11));
				lc_quantity = checkNullAndTrim(rs.getString(12));
				lc_net_amt = rs.getDouble(13);
				ls_tax_chap = checkNullAndTrim(rs.getString(14));
				ls_tax_class = checkNullAndTrim(rs.getString(15));
				ls_tax_env = checkNullAndTrim(rs.getString(16));
				lc_qty_stduom = rs.getDouble(17);
				lc_rate_stduom = rs.getDouble(18);
				lc_discount = rs.getDouble(19);
				lc_tax_amt = rs.getDouble(20);
				ls_reas_code = checkNullAndTrim(rs.getString(21));
				ll_line_no_sret = rs.getString(22);
				ls_sales_pers_sreturn = checkNullAndTrim(rs.getString(23));
				ls_ret_opt = checkNullAndTrim(rs.getString(24));
				ls_sr_tran_id = checkNullAndTrim(rs.getString(25));
				ll_sr_line_no = checkNullAndTrim(rs.getString(26));
				lc_rate__clg = rs.getDouble(27);
				ls_lot_no = checkNull(rs.getString(28));
				ll_line_no_invtrace = checkNullAndTrim(rs.getString(29));
				ls_lotsl = checkNullAndTrim(rs.getString(30));
				ls_ret_ref = checkNullAndTrim(rs.getString(31));
				
				
				//Added by wasim on 01-JUN-2017 as amount calculation was not migrated [START]
				sql = "select sum(quantity) from invdet where invoice_id = ? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_invoice_id); 
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{	
					lc_qty1 = rs1.getDouble(1);
				}
				if (pstmt1 != null )
				{
					pstmt1.close();pstmt1 = null;
				}				
				if (rs1 != null )
				{
					rs1.close();rs1 = null;
				}	
				sql = "select sum(quantity) from sreturndet where tran_id =  ? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_sr_tran_id); 
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{	
					lc_qty2 = rs1.getDouble(1);
				}
				if (pstmt1 != null )
				{
					pstmt1.close();pstmt1 = null;
				}				
				if (rs1 != null )
				{
					rs1.close();rs1 = null;
				}	
				
				if (lc_qty1 == lc_qty2)
				{
					lb_flag = false;
				}
				
				System.out.println("lb_flag-->"+lb_flag);
				
				if (lb_flag == false)
				{
					lc_drcr_amt = (lc_qty_stduom * lc_rate_stduom) - ((lc_qty_stduom * lc_rate_stduom) * lc_discount / 100);
					lc_tot_net_amt = lc_tot_net_amt + lc_net_amt ;
				}
				if (lb_flag == true)
				{
					lc_tot_net_amt = lc_tot_net_amt + lc_amt + lc_tax_amt;
				}
				System.out.println("DRCR_RCP---lc_tot_net_amt["+lc_tot_net_amt+"] lc_amt ["+lc_amt+"] lc_tax_amt["+lc_tax_amt+"] lc_drcr_amt["+lc_drcr_amt+"]"
						+ "lc_qty_stduom["+lc_qty_stduom+"] lc_rate_stduom["+lc_rate_stduom+"]  lc_discount["+lc_discount+"]");
				//Added by wasim on 01-JUN-2017 as amount calculation was not migrated [END]
				
				
				//Changed by wasim to insert into header [START]
				System.out.println("Old CustCode["+ls_old_cust_code+"] CustCode["+ls_cust_code+"] ls_old_item_ser["+ls_old_item_ser+"] ItemSer["+ls_item_ser+"]");
				if(ls_old_cust_code != ls_cust_code || ls_old_item_ser != ls_item_ser)
				{
					sql = "select fin_entity, acct_code__ar, cctr_code__ar, due_date, gp_no, gp_date from invoice where invoice_id = ? ";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, ls_invoice_id);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{	
						ls_fin_entity = checkNullAndTrim(rs1.getString(1));
						ls_acct_code = checkNullAndTrim(rs1.getString(2));
						ls_cctr_code = checkNullAndTrim(rs1.getString(3));
						ld_due_date = rs1.getTimestamp(4);
						ls_gp_no = checkNullAndTrim(rs1.getString(5));
						ld_gp_date = rs1.getTimestamp(6);
					}
					if (pstmt1 != null )
					{
						pstmt1.close();pstmt1 = null;
					}				
					if (rs1 != null )
					{
						rs1.close();rs1 = null;
					}		

					ls_finpara =  finCommon.getFinparams("999999", "INVOICE_DRCR_ADJ", conn);
					if("NULLFOUND".equalsIgnoreCase(ls_finpara))
					{
						ls_finpara = "N" ;
					}

					ls_rndstr = transer + "-RND";
					ls_rndoff =  finCommon.getFinparams("999999", ls_rndstr, conn);

					if (!"NULLFOUND".equalsIgnoreCase(ls_rndoff)) 
					{
						ls_rndoff = ls_rndoff.trim();
					}
					ls_rndstr = transer + "-RNDTO";
					ls_rndTo =  finCommon.getFinparams("999999", ls_rndstr, conn);
					if (!"NULLFOUND".equalsIgnoreCase(ls_rndTo)) 
					{
						ls_rndTo = ls_rndTo.trim();
					}

					sql = "INSERT INTO DRCR_RCP ( tran_id, tran_date, site_code, fin_entity, tran_type," +
					" tran_ser, drcr_flag, cust_code, item_ser, invoice_id ,acct_code ,cctr_code ,eff_date ," +
					" due_date ,curr_code ,exch_rate ,anal_code ,cr_term ,emp_code__aprv ,chg_date ,chg_user," +
					" chg_term,remarks,gp_no,gp_date ,rnd_off,rnd_to,amount,amount__bc,adj_recv,sreturn_no,cust_ref_no, confirmed) " +
					" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,? ,?,?,?,?,?,?,?,? ) " ; 
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString( 1, ls_auto_tran_id); 
					pstmt1.setTimestamp( 2, adt_credit_note ); 
					pstmt1.setString( 3, as_site_code );
					pstmt1.setString( 4, ls_fin_entity );
					pstmt1.setString( 5, as_tran_type);
					pstmt1.setString( 6, transer );
					pstmt1.setString( 7, ls_drcr_flag);
					pstmt1.setString( 8,ls_cust_code );
					pstmt1.setString( 9, ls_item_ser ); 
					pstmt1.setString( 10, ls_invoice_id );
					pstmt1.setString( 11, ls_acct_code ); 
					pstmt1.setString( 12, ls_cctr_code ); 
					pstmt1.setTimestamp( 13, ld_eff_date ); 
					pstmt1.setTimestamp( 14, ld_eff_date ); 
					pstmt1.setString( 15, ls_curr_code ); 
					pstmt1.setDouble( 16, lc_exch_rate ); 
					pstmt1.setString( 17, ls_anal_code ); 
					pstmt1.setString( 18, ls_cr_term ); 
					pstmt1.setString( 19, ls_emp_code__aprv ); 
					pstmt1.setTimestamp( 20, currDate ); 
					pstmt1.setString( 21, chgUser );
					pstmt1.setString( 22, chgTerm );
					pstmt1.setString( 23, remarks );
					pstmt1.setString( 24, ls_gp_no );
					pstmt1.setTimestamp( 25, ld_gp_date );
					pstmt1.setString( 26, ls_rndoff );
					pstmt1.setString( 27, ls_rndTo );
					pstmt1.setDouble( 28, lc_tot_net_amt );
					pstmt1.setDouble( 29, (lc_tot_net_amt * lc_exch_rate) );
					pstmt1.setString( 30, ls_finpara );
					pstmt1.setString( 31, ls_tran_id );
					pstmt1.setString( 32, ls_ret_ref );
					pstmt1.setString( 33, "N" );

					int cnt=pstmt1.executeUpdate();
					if(pstmt1 != null)
					{
						pstmt1.close();pstmt1 = null;
					}
				}

				sql = "select sales_pers from invoice where invoice_id = ? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_invoice_id); 
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{	
					ls_sales_pers = checkNullAndTrim(rs1.getString(1));
				}
				if (pstmt1 != null )
				{
					pstmt1.close();pstmt1 = null;
				}				
				if (rs1 != null )
				{
					rs1.close();rs1 = null;
				}
				//Changed by wasim to insert into header [END]
				
				/*sql = "select sum(quantity) from invdet where invoice_id = ? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_invoice_id); 
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{	
					lc_qty1 = rs1.getDouble(1);
				}
				if (pstmt1 != null )
				{
					pstmt1.close();pstmt1 = null;
				}				
				if (rs1 != null )
				{
					rs1.close();rs1 = null;
				}	
				sql = "select sum(quantity) from sreturndet where tran_id =  ? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_sr_tran_id); 
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{	
					lc_qty2 = rs1.getDouble(1);
				}
				if (pstmt1 != null )
				{
					pstmt1.close();pstmt1 = null;
				}				
				if (rs1 != null )
				{
					rs1.close();rs1 = null;
				}	

				if (lc_qty1 == lc_qty2)
				{
					lb_flag = false;
				}*/


				sql = " INSERT INTO DRCR_RDET ( TRAN_ID, LINE_NO, INVOICE_ID, LINE_NO__INV, ITEM_CODE, SALES_PERS, TAX_CLASS, TAX_CHAP, TAX_ENV, DRCR_AMT," +
				" TAX_AMT, NET_AMT, REAS_CODE, QUANTITY, RATE, RATE__CLG, DISCOUNT, LINE_NO__SRET, LINE_NO__INVTRACE, LOT_NO, LOT_SL) " +
				" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) " ; 
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_auto_tran_id); 
				pstmt1.setInt(2, ll_line_no ); 
				pstmt1.setString( 3, ls_invoice_id );
				pstmt1.setString( 4, ll_line_no__inv );
				pstmt1.setString( 5, ls_item_code );
				pstmt1.setString( 6, ls_sales_pers);
				pstmt1.setString( 7, ls_tax_class );
				pstmt1.setString( 8, ls_tax_chap);
				pstmt1.setString( 9, ls_tax_env);

				if (lb_flag == false)
				{
					//lc_drcr_amt = (lc_qty_stduom * lc_rate_stduom) - ((lc_qty_stduom * lc_rate_stduom) * lc_discount / 100);
					pstmt1.setDouble( 10, lc_drcr_amt);
					//lc_tot_net_amt = lc_tot_net_amt + lc_net_amt ;
					pstmt1.setDouble( 12, lc_net_amt);
				}
				if (lb_flag == true)
				{
					pstmt1.setDouble( 10, lc_amt);
					pstmt1.setDouble( 12, (lc_amt + lc_tax_amt));
				}

				//pstmt1.setDouble( 10, lc_drcr_amt);
				pstmt1.setDouble( 11, lc_tax_amt);
				//pstmt1.setDouble( 12, (lc_amt + lc_tax_amt));
				pstmt1.setString( 13, ls_reas_code);
				pstmt1.setDouble( 14, lc_qty_stduom);
				pstmt1.setDouble( 15, lc_rate_stduom);
				pstmt1.setDouble( 16, lc_rate__clg);
				pstmt1.setDouble( 17, lc_discount);
				pstmt1.setString( 18, ll_line_no_sret);
				pstmt1.setString( 19, ll_line_no_invtrace);
				pstmt1.setString( 20, ls_lot_no);
				pstmt1.setString( 21, ls_lotsl);
				int detCnt = pstmt1.executeUpdate();
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			} //End while loop
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}		
			
			currRow = 0;
			sql = "SELECT TRAN_ID, REF_SER, REF_NO, ADJ_AMT, REF_BAL_AMT FROM SRETURN_INV WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, ls_tran_id); 
			rs = pstmt.executeQuery();
			while(rs.next())
			{	
				currRow++;
				ls_sr_inv_tran_id = checkNullAndTrim(rs.getString(1));
				ls_sr_ref_ser = checkNullAndTrim(rs.getString(2));
				ls_sr_ref_no = checkNullAndTrim(rs.getString(3));
				lc_sr_adj_amt = checkNullAndTrim(rs.getString(4));
				lc_sr_ref_bal_amt = checkNullAndTrim(rs.getString(5));
				
				//Added by wasim on 01-jun-2017 to insert data into drcr_rcpinv as per NVO code, previously it was writtten this code [START]
				sql = " insert into drcr_rcpinv (tran_id, line_no, ref_ser, ref_no, adj_amt, ref_bal_amt) values (?,?,?,?,?,?) ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, ls_auto_tran_id);
				pstmt1.setInt(2, currRow);
				pstmt1.setString(3, ls_sr_ref_ser);
				pstmt1.setString(4, ls_sr_ref_no);
				pstmt1.setDouble(5, Double.valueOf(lc_sr_adj_amt));
				pstmt1.setDouble(6, Double.valueOf(lc_sr_ref_bal_amt));
				pstmt1.executeUpdate();
				if (pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Added by wasim on 01-jun-2017 to insert data into drcr_rcpinv as per NVO code, previously it was writtten this code [END]
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}	

			sql = "update sreturn set tran_id__crn = ? where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, ls_auto_tran_id);
			pstmt.setString(2, ls_tran_id);
			int rowcnt = pstmt.executeUpdate();
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			//Changed by wasim on 24-MAY-2017 to call gbfRetrieveDrCrRCP as previously gbfRetrieveDrCrInv login was migrated [START]
			/*ls_errcode = gbfRetrieveDrCr(ls_auto_tran_id, as_site_code, xtraParams, conn);
			if (ls_errcode != null && ls_errcode.trim().length() > 0) 
			{
				errorString = vdt.getErrorString("",ls_errcode,"");
				return errorString;
			}*/
			
			    ls_errcode = gbfRetrieveDrCrRcp(ls_auto_tran_id, as_site_code, xtraParams, conn);
			  //DrCrRcpConf drcrObj = new DrCrRcpConf();
			  //ls_errcode = drcrObj.confirm (ls_auto_tran_id, xtraParams, "" , conn);
			//Changed by wasim on 24-MAY-2017 to call gbfRetrieveDrCrRCP as previously gbfRetrieveDrCrInv login was migrated [END]
			

		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}				
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return errorString;
	}

	public String gbf_auto_crnote_sreturn_misc (Timestamp adt_credit_note, String as_tran_type, String as_site_code, String as_tranid_from, String as_tranid_to, Date adt_tran_date_from, Date adt_tran_date_to, String as_cust_code_from, String as_cust_code_to, String as_post, String xtraParams, Connection conn)
	throws RemoteException, ITMException
	{
		String ls_errcode = "", errorString = "", ls_tran_id = "", ls_invoice_id = "", ls_item_code = "", ls_cust_code = "", ls_posttype = "", ls_adj_misc_crn = "";
		String ls_old_cust_code = "",  trnofld = "", keystr = "", ls_auto_tran_id = "", ls_round = "", ls_acct_code__pfee = "", ls_cctr_code__pfee = "";
		String ls_tax_chap = "", ls_tax_class = "", ls_tax_env = "", ls_sales_pers = "", ls_reas_code = "",ls_list_type = "", ls_trantype = "", ls_unit = "";
		String ls_fin_entity = "", ls_curr_code = "", ls_anal_code = "", ls_emp_code__aprv = "", ls_sales_pers_sreturn = "", ls_sr_inv_tran_id = "", ls_prevtranid = "";
		String ls_acct_code = "", ls_cctr_code = "", ls_det_acct = "", ls_det_cctr = "", ls_cr_term = "", ls_tax_rec = "", ls_item_ser = "", ls_old_item_ser = "", ls_lotsl = "";
		String ls_ret_opt = "",ls_drcr_flag = "",ls_tranwin = "", ls_serial_no = "", ls_sales_order = "",ls_apply_price = "", ls_process_fee_reason = "";
		String ls_sord_line_no = "", ls_pricelist = "", ls_item_code_sord = "", ls_item_code__ord = "",ls_sr_tran_id = "", ls_item_code_sr = "",ls_finpara = "",ls_lot_no = "",ls_gp_no = "", ls_sr_ref_ser = "", ls_sr_ref_no = "";
		double lc_qty = 0, lc_qty1 = 0, lc_qty2 = 0, lc_exch_rate = 0, lc_tot_net_amt = 0, lc_process_fee = 0;
		int ll_line_no = 0;
		String ll_line_no__inv = "", ll_hdr_row = "", ll_det_row = "", ll_line_no_sret = "", ll_count = "", ll_sr_line_no = "", ll_line_no_invtrace = "", li_currow = "";
		String lc_quantity = "", lc_round_to = "", lc_sr_adj_amt = "", lc_sr_ref_bal_amt = "", lc_round_amt = "", lc_diff_amt = "";
		String lc_old_amount = "", lc_old_amount_bc = "", lc_dprice_item = "", chgUser = "", chgTerm = "", transer = "", remarks = "", sql = "", keyCol = "", tranSer = "";
		double lc_rate__clg = 0, lc_qty_stduom = 0, lc_rate_stduom = 0, lc_discount = 0, lc_amt = 0, lc_drcr_amt = 0, lc_net_amt = 0, lc_tax_amt = 0; 
		Timestamp ld_eff_date = null, ld_due_date = null,ld_gp_date = null;
		String ls_rndstr = "", ls_rndTo = "", ls_rndoff = "", ls_ret_ref = "", ls_site_type = "", ls_creat_inv_othlist = "", ls_creat_inv_oth = "", ls_other_site = "";
		String ls_temp = "", li_Sreturn_cnt = "", ls_sr_REF_SER = "", ls_sr_REF_NO = "", lc_SR_ADJ_AMT = "", lc_SR_REF_BAL_AMT = "", lc_SR_mrp_value__adj = "";

		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ValidatorEJB vdt=new ValidatorEJB();
		DistCommon distCommon = new DistCommon();
		//FinCommon finCommon = new FinCommon();
		Timestamp currDate = null;
		UtilMethods utilMethods = UtilMethods.getInstance();
		boolean lb_flag;
		try
		{
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			transer = "MDRCRC";
			trnofld = "tran_id";

			ls_posttype =  finCommon.getFinparams("999999", "SALES_INV_POST_HDR", conn);
			if ("NULLFOUND".equalsIgnoreCase(ls_posttype))
			{
				ls_posttype = "H";
			}

			sql = "select case when (process_fee) is null then 0 else ( process_fee) end from sreturn where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, as_tranid_from); 
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				lc_process_fee = rs.getDouble(1);
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}	
			if ("D".equalsIgnoreCase(ls_ret_opt))
			{
				ls_drcr_flag = "D";		
				transer = "MDRCRD";
				ls_tranwin = "W_MISC_DRCR_RCP_DR";
				ls_auto_tran_id = generateTranId("w_misc_drcr_rcp_dr",as_site_code,currDateStr,conn);	
				remarks = "Auto Generated Debit Note for Sales Return " + ls_tran_id;
			}
			else
			{
				ls_drcr_flag = "C";			
				transer = "MDRCRC";
				ls_tranwin = "W_MISC_DRCR_RCP_CR";
				ls_auto_tran_id = generateTranId("w_misc_drcr_rcp_cr",as_site_code,currDateStr,conn);	
				remarks = "Auto Generated Credit Note for Sales Return " + ls_tran_id;
			}

			lb_flag = false;
			sql = "select KEY_STRING, TRAN_ID_COL, REF_SER from transetup where upper(tran_window) = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,ls_tranwin );
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				keystr = checkNullAndTrim(rs.getString("KEY_STRING"));
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}

			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			

			if(keystr == null || keystr.length() == 0)
			{
				sql = "select KEY_STRING, TRAN_ID_COL, REF_SER from transetup where tran_window = 'GENERAL' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{	
					keystr = checkNullAndTrim(rs.getString("KEY_STRING"));
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
				}

				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}			
			}

			sql = "select acct_code__pfee, cctr_code__pfee from itemser where item_ser = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,ls_item_ser );
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				ls_acct_code__pfee = checkNullAndTrim(rs.getString("acct_code__pfee"));
				ls_cctr_code__pfee = checkNullAndTrim(rs.getString("cctr_code__pfee"));
			}

			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}			

			if((ls_acct_code__pfee == null || ls_acct_code__pfee.length()== 0) || (ls_cctr_code__pfee == null || ls_cctr_code__pfee.length() == 0) )
			{
				/*ls_cctr_code__pfee =  gbf_acct_detr_ttype(ls_itemcode,ls_itemser,'SRET', ls_trantype, as_site_code)
				ls_acct_code__pfee =  f_get_token(ls_cctr_code__pfee,'~t')*/

				ls_cctr_code__pfee = finCommon.getAcctDetrTtype(ls_item_code, ls_item_ser, "SRET", as_tran_type, conn);
				if (ls_cctr_code__pfee != null && ls_cctr_code__pfee.trim().length() > 0) 
				{
					String tokens [] = ls_cctr_code__pfee.split(",");

					System.out.println("Length="+tokens.length);

					if ( tokens.length >= 2)
					{
						ls_acct_code__pfee = tokens[0];
						ls_cctr_code__pfee = tokens[1];

						ls_acct_code__pfee = checkNullAndTrim(ls_acct_code__pfee);
						ls_cctr_code__pfee = checkNullAndTrim(ls_cctr_code__pfee);
					}
					else
					{
						ls_acct_code__pfee = ls_cctr_code__pfee.substring(0,ls_cctr_code__pfee.indexOf(","));
						ls_cctr_code__pfee = ls_cctr_code__pfee.substring(ls_cctr_code__pfee.indexOf(",") + 1);
					}
					tokens = null;
				}

			}

			if(ls_old_cust_code != ls_cust_code || ls_old_item_ser != ls_item_ser)
			{
				sql = "select fin_entity from site where site_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, as_site_code);
				rs = pstmt.executeQuery();
				if(rs.next())
				{	
					ls_fin_entity = checkNullAndTrim(rs.getString(1));
				}

				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}	
				sql = "select acct_code__ar, cctr_code__ar from customer where cust_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ls_cust_code);
				rs = pstmt.executeQuery();
				if(rs.next())
				{	
					ls_acct_code = checkNullAndTrim(rs.getString(1));
					ls_cctr_code = checkNullAndTrim(rs.getString(2));
				}

				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}


				else if((ls_acct_code == null || ls_cctr_code == null) || (ls_acct_code.length() == 0 || ls_cctr_code.length() == 0)) 
				{
					sql = "select acct_code__ar, cctr_code__ar from itemser where item_ser = ? " ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, ls_item_ser);
					rs = pstmt.executeQuery();
					if(rs.next())
					{	
						ls_acct_code = checkNullAndTrim(rs.getString(1));
						ls_cctr_code = checkNullAndTrim(rs.getString(2));
					}

					if (pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}				
					if (rs != null )
					{
						rs.close();
						rs = null;
					}
				}	
				/*ls_cctr_code = gbf_acct_detr_ttype(ls_itemcode,ls_item_ser,'AR',ls_trantype, as_site_code)
				ls_acct_code = f_get_token(ls_cctr_code,'~t')*/

				ls_cctr_code = finCommon.getAcctDetrTtype(ls_item_code, ls_item_ser, "AR", as_tran_type, conn);
				if (ls_cctr_code != null && ls_cctr_code.trim().length() > 0) 
				{
					String tokens [] = ls_cctr_code.split(",");

					System.out.println("Length="+tokens.length);

					if ( tokens.length >= 2)
					{
						ls_acct_code = tokens[0];
						ls_cctr_code = tokens[1];

						ls_acct_code = checkNullAndTrim(ls_acct_code);
						ls_cctr_code = checkNullAndTrim(ls_cctr_code);
					}
					else
					{
						ls_acct_code = ls_cctr_code.substring(0,ls_cctr_code.indexOf(","));
						ls_cctr_code = ls_cctr_code.substring(ls_cctr_code.indexOf(",") + 1);
					}
					tokens = null;
				}


				/*ls_det_cctr = gbf_acct_detr_ttype(ls_itemcode,ls_item_ser,'SRET', ls_trantype, as_site_code)
				ls_det_acct = f_get_token(ls_det_cctr,'~t')*/
				ls_det_cctr = finCommon.getAcctDetrTtype(ls_item_code, ls_item_ser, "SRET", as_tran_type, conn);
				if (ls_det_cctr != null && ls_det_cctr.trim().length() > 0) 
				{
					String tokens [] = ls_det_cctr.split(",");

					System.out.println("Length="+tokens.length);

					if ( tokens.length >= 2)
					{
						ls_det_acct = tokens[0];
						ls_det_cctr = tokens[1];

						ls_det_acct = checkNullAndTrim(ls_det_acct);
						ls_det_cctr = checkNullAndTrim(ls_det_cctr);
					}
					else
					{
						ls_det_acct = ls_det_cctr.substring(0,ls_det_cctr.indexOf(","));
						ls_det_cctr = ls_det_cctr.substring(ls_det_cctr.indexOf(",") + 1);
					}
					tokens = null;
				}

				ls_finpara =  finCommon.getFinparams("999999", "INVOICE_DRCR_ADJ", conn);
				if("NULLFOUND".equalsIgnoreCase(ls_finpara))
				{
					ls_finpara = "N" ;
				}

				ls_rndstr = transer + "-RND";
				ls_rndoff =  finCommon.getFinparams("999999", ls_rndstr, conn);

				if (!"NULLFOUND".equalsIgnoreCase(ls_rndoff)) 
				{
					ls_rndoff = ls_rndoff.trim();
				}
				ls_rndstr = transer + "-RNDTO";
				ls_rndTo =  finCommon.getFinparams("999999", ls_rndstr, conn);
				if (!"NULLFOUND".equalsIgnoreCase(ls_rndTo)) 
				{
					ls_rndTo = ls_rndTo.trim();
				}

				sql = "insert into MISC_DRCR_RCP(TRAN_ID, TRAN_SER, TRAN_DATE, EFF_DATE, FIN_ENTITY, SITE_CODE, SUNDRY_TYPE, SUNDRY_CODE, ACCT_CODE, CCTR_CODE, AMOUNT, CURR_CODE," +
				" EXCH_RATE, REMARKS, DRCR_FLAG, CHG_USER, CHG_DATE, CHG_TERM, EMP_CODE__APRV, DUE_DATE, TRAN_TYPE, ITEM_SER, AMOUNT__BC, SRETURN_NO, ADJ_MISC_CRN, CUST_REF_NO, RND_OFF, RND_TO) ) " +
				" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,? ,?,?,?) " ; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString( 1, ls_auto_tran_id); 
				pstmt.setString( 2, transer ); 
				pstmt.setTimestamp( 3, adt_credit_note ); 
				pstmt.setTimestamp( 4, ld_eff_date );
				pstmt.setString( 5, ls_fin_entity );
				pstmt.setString( 6, as_site_code );
				pstmt.setString( 7, "C" );
				pstmt.setString( 8, ls_cust_code );
				pstmt.setString( 9, ls_acct_code );
				pstmt.setString( 10, ls_cctr_code ); 
				pstmt.setDouble( 11, (lc_tot_net_amt + lc_process_fee) ); 
				pstmt.setString( 12, ls_curr_code ); 
				pstmt.setDouble( 13, lc_exch_rate ); 
				pstmt.setString( 14, remarks );
				pstmt.setString( 15, ls_drcr_flag);
				pstmt.setString( 16, chgUser );
				pstmt.setTimestamp( 17, currDate ); 
				pstmt.setString( 18, chgTerm );
				pstmt.setString( 19, ls_emp_code__aprv );
				pstmt.setTimestamp( 20, ld_eff_date );
				pstmt.setString( 21, as_tran_type);
				pstmt.setString( 22, ls_item_ser ); 
				pstmt.setDouble( 23, (lc_tot_net_amt + lc_process_fee) * lc_exch_rate ); 
				pstmt.setString( 24, ls_tran_id );
				pstmt.setString( 25, ls_adj_misc_crn );
				pstmt.setString( 26, ls_ret_ref );
				pstmt.setString( 27, ls_rndoff );
				pstmt.setString( 28, ls_rndTo );

				int cnt=pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}

			sql = "select a.cust_code__bill, a.eff_date, a.curr_code, a.exch_rate, a.anal_code, a.emp_code__aprv, a.item_ser, b.tran_id, b.quantity, " +
			" case when (b.net_amt) is null then 0 else (b.net_amt) end , b.tax_chap, b.tax_class, b.tax_env, b.quantity__stduom, b.rate__stduom, " +
			" b.discount,case when ( b.tax_amt) is null then 0 else ( b.tax_amt) end, b.reas_code, b.line_no, a.ret_opt, a.tran_type, b.item_code, " +
			" a.adj_misc_crn, b.lot_no, b.line_no__invtrace, b.lot_sl,a.ret_ref, b.unit from 	sreturn a , sreturndet b where a.tran_id = b.tran_id " +
			" and a.tran_id >= ? and a.tran_id <= ? and a.tran_date >= ? and a.tran_date <= ? and a.cust_code >= ? and a.cust_code <= ? and a.site_code = ?" +
			" and a.tran_type = ? and a.confirmed = 'Y' and a.ret_opt in ('C','D') and b.invoice_id is null and a.tran_id__crn is null order by a.cust_code, a.item_ser, a.tran_date, a.tran_id " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,as_tranid_from );
			pstmt.setString(2,as_tranid_to );
			pstmt.setDate(3, (java.sql.Date) adt_tran_date_from);
			pstmt.setDate(4,(java.sql.Date) adt_tran_date_to );
			pstmt.setString(5,as_cust_code_from );
			pstmt.setString(6,as_cust_code_to );
			pstmt.setString(7,as_site_code );
			pstmt.setString(8,as_tran_type );
			rs = pstmt.executeQuery();
			if(rs.next())
			{	
				ll_line_no ++;
				ls_cust_code = checkNullAndTrim(rs.getString(1));
				ld_eff_date = rs.getTimestamp(2);
				ls_curr_code = checkNullAndTrim(rs.getString(3));
				lc_exch_rate = rs.getDouble(4);
				ls_anal_code = checkNullAndTrim(rs.getString(5));
				ls_emp_code__aprv = checkNullAndTrim(rs.getString(6));
				ls_item_ser = checkNullAndTrim(rs.getString(7));
				ls_tran_id = checkNullAndTrim(rs.getString(8));
				lc_quantity = checkNullAndTrim(rs.getString(9));
				lc_net_amt = rs.getDouble(10);
				ls_tax_chap = checkNullAndTrim(rs.getString(11));
				ls_tax_class = checkNullAndTrim(rs.getString(12));
				ls_tax_env = checkNullAndTrim(rs.getString(13));
				lc_qty_stduom = rs.getDouble(14);
				lc_rate_stduom = rs.getDouble(15);
				lc_discount = rs.getDouble(16);
				lc_tax_amt = rs.getDouble(17);
				ls_reas_code = checkNullAndTrim(rs.getString(18));
				ll_line_no_sret = checkNullAndTrim(rs.getString(19));
				ls_ret_opt = checkNullAndTrim(rs.getString(20));
				ls_trantype = checkNullAndTrim(rs.getString(21));
				ls_item_code = checkNullAndTrim(rs.getString(22));
				ls_adj_misc_crn = checkNullAndTrim(rs.getString(23));
				ls_lot_no = checkNull(rs.getString(24));
				ll_line_no_invtrace = checkNullAndTrim(rs.getString(25));
				ls_lotsl = checkNullAndTrim(rs.getString(26));
				ls_ret_ref = checkNullAndTrim(rs.getString(27));
				ls_unit = checkNullAndTrim(rs.getString(28));

				sql = "INSERT INTO MISC_DRCR_RDET(TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, NET_AMT, TAX_AMT, TAX_CLASS, TAX_CHAP, TAX_ENV, REAS_CODE, ITEM_CODE, QUANTITY, RATE, LINE_NO__SRET, LINE_NO__INVTRACE, LOT_NO, LOT_SL, UNIT) )" +
				" values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";

				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, ls_auto_tran_id); 
				pstmt1.setInt(2, ll_line_no ); 
				pstmt1.setString( 8, ls_tax_class );
				pstmt1.setString( 9, ls_tax_chap);
				pstmt1.setString( 10, ls_tax_env);

				ls_process_fee_reason = distCommon.getDisparams("999999","PROCESS_FEE_REASON",conn) ;
				if ("NULLFOUND".equalsIgnoreCase(ls_process_fee_reason) || ls_process_fee_reason == null || ls_process_fee_reason.trim().length() == 0)
				{
					ls_process_fee_reason = " ";
				}
				if( lc_process_fee != 0)
				{
					pstmt1.setString( 3, ls_acct_code__pfee ); 
					pstmt1.setString( 4, ls_cctr_code__pfee );
					pstmt1.setDouble( 5, lc_process_fee );
					pstmt1.setDouble( 6, lc_process_fee );
					pstmt1.setString( 11, ls_process_fee_reason); 
				}	
				else
				{
					pstmt1.setString( 3, ls_det_acct ); 
					pstmt1.setString( 4, ls_det_cctr );
					pstmt1.setString( 11, ls_reas_code);
				}
				lc_drcr_amt = (lc_qty_stduom * lc_rate_stduom) - ((lc_qty_stduom * lc_rate_stduom) * lc_discount / 100)	;	
				if (lc_net_amt >= 0 )
				{
					pstmt1.setDouble( 5, lc_drcr_amt );
					pstmt1.setDouble( 6, lc_net_amt );
				}
				pstmt1.setDouble( 7, lc_tax_amt );
				pstmt1.setString( 12, ls_item_code);
				pstmt1.setDouble( 13, lc_qty_stduom);
				pstmt1.setDouble( 14, lc_rate_stduom);
				pstmt1.setString( 15, ll_line_no_sret);
				pstmt1.setString( 16, ll_line_no_invtrace);
				pstmt1.setString( 17, ls_lot_no);
				pstmt1.setString( 18, ls_lotsl);
				pstmt1.setString( 19, ls_unit);

				int detCnt = pstmt1.executeUpdate();
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}				
			if (rs != null )
			{
				rs.close();
				rs = null;
			}		

			if(("MI".equalsIgnoreCase(ls_adj_misc_crn) || "MC".equalsIgnoreCase(ls_adj_misc_crn)) && (ls_prevtranid != ls_tran_id))
			{
				sql = "SELECT TRAN_ID,LINE_NO,REF_SER,REF_NO,ADJ_AMT,REF_BAL_AMT,mrp_value__adj FROM SRETURN_INV WHERE TRAN_ID = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ls_tran_id);
				rs = pstmt.executeQuery();
				while(rs.next())
				{	
					ls_temp = checkNullAndTrim(rs.getString(1));
					li_Sreturn_cnt = checkNullAndTrim(rs.getString(2));
					ls_sr_REF_SER = checkNullAndTrim(rs.getString(3));
					ls_sr_REF_NO = checkNullAndTrim(rs.getString(4));
					lc_SR_ADJ_AMT = checkNullAndTrim(rs.getString(5));
					lc_SR_REF_BAL_AMT = checkNullAndTrim(rs.getString(6));
					lc_SR_mrp_value__adj = checkNullAndTrim(rs.getString(7));

					sql = "insert into misc_drcr_rcpinv(TRAN_ID, LINE_NO, REF_SER, REF_NO, REF_BAL_AMT, ADJ_AMT, MRP_VALUE__ADJ)";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString( 1, ls_auto_tran_id); 
					pstmt1.setString( 2, li_Sreturn_cnt ); 
					pstmt1.setString( 3, ls_sr_REF_SER ); 
					pstmt1.setString( 4, ls_sr_REF_NO );
					pstmt1.setString( 5, lc_SR_REF_BAL_AMT );
					pstmt1.setString( 6, lc_SR_ADJ_AMT );
					pstmt1.setString( 7, lc_SR_mrp_value__adj );
					int detCnt = pstmt1.executeUpdate();
					if(pstmt1 != null)
					{
						pstmt1.close();pstmt1 = null;
					}
				}

				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
				if (rs != null )
				{
					rs.close();
					rs = null;
				}
			}


			sql = "update sreturn set tran_id__crn = ? where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, ls_auto_tran_id);
			pstmt.setString(2, ls_tran_id);
			int rowcnt = pstmt.executeUpdate();
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			if( rowcnt == 0 )
			{
				ls_errcode = "DS000NR";
			}

			if( "Y".equalsIgnoreCase( as_post )  )
			{
				ls_errcode = retrieveMiscDrcrRcp("misc_drcr_rcp",ls_auto_tran_id, xtraParams, "N");
				if (ls_errcode != null && ls_errcode.trim().length() > 0) 
				{
					errorString = vdt.getErrorString("",ls_errcode,"");
					return errorString;
				}
			}

		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errorString;
	}
	private String generateTranId(String windowName, String siteCode, String tranDateStr, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Date effDate = null;
		try
		{
			System.out.println("generateTranId() called");
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			// System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("keyString :" + keyString);
			System.out.println("keyCol :" + keyCol);
			System.out.println("tranSer :" + tranSer);
			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>" + tranDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues :[" + xmlValues + "]");
			TransIDGenerator generatedTranid = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = generatedTranid.generateTranSeqID(tranSer, keyCol, keyString, conn);

			System.out.println("tranId :" + tranId);
		} catch (SQLException ex)
		{
			System.out.println("Exception ::" + selSql + ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		} catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return tranId;
	}

	private String gbfRetrieveDrCr(String tranId,String siteCode,String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String errCode = "",keyFld = "" , expHdr = "",expDet = "", winName = "", ledgPostconf= "" , ledgPostConf = "",loginEmpCode = "",
		sql = "" , sql1 = "" ,winname ="",acctCode = "",cctrCode= "",invoiceId = "", tranSer = "";
		String acctReco = "", cctrReco = "", taxRecoAcct = "", taxRecoCctr = "", acctExch = "", cctrExch = "", acctRnd = "", cctrRnd = "";



		double recoAmount = 0,diffExchAmt = 0,roundAdj = 0,amountMap = 0, exchRateInv = 0, exchRatehdr = 0 ;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		HashMap HdrMap = null;
		HashMap DetMap = null;
		int lineNo = 0,findIndex = -1;
		ArrayList DetList = new ArrayList();
		ITMDBAccessEJB itmDBAccessEJB = null;
		itmDBAccessEJB = new ITMDBAccessEJB();
		E12GenericUtility genericUtility = new E12GenericUtility();
		int cntrHdr = 0,cntr = 0,insertedRow = 0,rows = 0;
		java.sql.Timestamp tranDate = null, today;
		//FinCommon finCommon = null;
		String tranType = "";
		try
		{
			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql1 = "SELECT tran_id FROM drcr_inv  WHERE tran_id = ? for update ";
			}

			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql1 = "SELECT tran_id FROM drcr_inv (updlock) WHERE tran_id = ? " ;
			}
			else
			{
				sql1 =" SELECT tran_id  FROM drcr_inv WHERE tran_id =  ? for update nowait" ;
			}
			pstmt1 = conn.prepareStatement(sql1);
			pstmt1.setString(1,tranId);
			rs1 = pstmt1.executeQuery();
			if(rs1.next())
			{
				keyFld = rs1.getString("tran_id") == null ? " ":rs1.getString("tran_id");
			}
			rs1.close();
			rs1 = null;
			pstmt1.close();
			pstmt1 = null;
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;

			winname = "W_DRCRINV";

			sql = "select ledg_post_conf from transetup where upper(tran_window) = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"W_DRCRINV");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ledgPostConf = rs.getString(1);
			}
			else
			{
				errCode = itmDBAccessEJB.getErrorString("","VTSEQ","","",conn);
				return errCode;
			}

			if("Y".equalsIgnoreCase(ledgPostConf))
			{
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
				tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");

				sql = " update drcr_inv set tran_date = ? where tran_id   = ?" ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, tranDate);
				pstmt.setString(2,tranId);
				pstmt.executeUpdate();		

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}

			sql = "select tran_id ,tran_date ,fin_entity ,acct_code , cctr_code ,eff_date , invoice_id , amount , curr_code , exch_rate , remarks , " +
			"site_code,  anal_code ,  drcr_flag  ,  tran_id__rcv,  confirmed,conf_date ,emp_code__aprv, tran_type , tran_ser ,   " +
			"due_date ,cr_term ,amount__bc, item_ser , round_adj , sundry_type , sundry_code ,  " +
			"  acct_code__cf , cctr_code__cf  , diff_amt_exch ,voucher_no , invvouc_flag , parent__tran_id , rev__tran " +
			" from drcr_inv where tran_id = ?";


			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				HdrMap = new HashMap();
				HdrMap.put("tran_id",tranId);
				HdrMap.put("tran_date",rs.getTimestamp("tran_date"));
				HdrMap.put("fin_entity",rs.getString("fin_entity"));
				HdrMap.put("acct_code",rs.getString("acct_code"));
				cctrCode = rs.getString("cctr_code");
				if (cctrCode == null || "null".equals(cctrCode))
				{
					cctrCode = "    ";
				}

				HdrMap.put("cctr_code",cctrCode);
				HdrMap.put("eff_date",rs.getTimestamp("eff_date"));
				HdrMap.put("invoice_id",rs.getString("invoice_id"));
				HdrMap.put("amount",rs.getDouble("amount"));
				HdrMap.put("curr_code",rs.getString("curr_code"));
				exchRatehdr = rs.getDouble("exch_rate");
				if (exchRatehdr == 0 )
				{
					exchRatehdr = 1;
				}
				HdrMap.put("exch_rate",exchRatehdr);
				HdrMap.put("remarks",rs.getString("remarks"));
				HdrMap.put("site_code",rs.getString("site_code"));
				HdrMap.put("anal_code",rs.getString("anal_code"));
				HdrMap.put("drcr_flag",rs.getString("drcr_flag"));
				HdrMap.put("tran_id__rcv",rs.getString("tran_id__rcv"));
				HdrMap.put("confirmed",rs.getString("confirmed"));
				HdrMap.put("conf_date",rs.getTimestamp("conf_date"));
				HdrMap.put("emp_code__aprv",rs.getString("emp_code__aprv"));
				HdrMap.put("tran_type",rs.getString("tran_type"));
				HdrMap.put("tran_ser",rs.getString("tran_ser"));
				tranSer = rs.getString("tran_ser");
				HdrMap.put("due_date",rs.getTimestamp("due_date"));
				HdrMap.put("cr_term",rs.getString("cr_term"));
				HdrMap.put("amount__bc",rs.getDouble("amount__bc"));
				HdrMap.put("item_ser",rs.getString("item_ser"));
				HdrMap.put("round_adj",rs.getDouble("round_adj"));
				HdrMap.put("sundry_type",rs.getString("sundry_type"));
				HdrMap.put("sundry_code",rs.getString("sundry_code"));
				HdrMap.put("acct_code__cf",rs.getString("acct_code__cf"));
				cctrCode = rs.getString("cctr_code__cf");
				if (cctrCode == null || "null".equals(cctrCode))
				{
					cctrCode = "    ";
				}
				HdrMap.put("cctr_code__cf",cctrCode);
				HdrMap.put("diff_amt_exch",rs.getDouble("diff_amt_exch"));
				HdrMap.put("voucher_no",rs.getString("voucher_no"));
				HdrMap.put("invvouc_flag",rs.getString("invvouc_flag"));
				HdrMap.put("parent__tran_id",rs.getString("parent__tran_id"));
				HdrMap.put("rev__tran",rs.getString("rev__tran"));

				System.out.println(" Header Map..........");
				System.out.println(HdrMap.toString());
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = " select acct_code, cctr_code, sum(tax_amt) as tax_amt, case when sum(reco_amount) is null then 0 else sum(reco_amount) end as reco_amt "
				+ " from taxtran where tran_code = ? and tran_id = ? and tax_amt <> 0 and (case when reco_amount is null then 0 else reco_amount end) <> 0 and effect <> 'N' group by acct_code, cctr_code";              
			pstmt = conn.prepareStatement(sql);

			//Changed by wasim on 24-MAY-2017 to check tran_ser null or not [START]
			if(HdrMap !=null && HdrMap.get("tran_ser") != null)
			{
				tranSer = (String) HdrMap.get("tran_ser");
			}
			//Changed by wasim on 24-MAY-2017 to check tran_ser null or not [END]
			
			pstmt.setString(1, tranSer);
			pstmt.setString(2,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				acctCode = rs.getString("acct_code");
				acctCode = rs.getString("cctr_code");
				if (acctCode == null)
				{
					if (!"CRNVOU".equals(tranSer) )
					{
						sql = " select acct_code__sal, cctr_code__sal  "
							+ " from invoice  where invoice_id = ? ";              
						pstmt1 = conn.prepareStatement(sql);

						pstmt1.setString(1, (String) HdrMap.get("invoice_id"));
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							acctCode = rs1.getString("acct_code__sal");
							acctCode = rs1.getString("cctr_code__sal");
						}
						else
						{
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
							errCode = "VTINVCD1";
							break;
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}
					else
					{
						errCode = "VTACTAX"; 
						break;
					}
				}
				if (cctrCode == null || cctrCode.trim().length() == 0 )
				{
					cctrCode = (String) HdrMap.get("cctr_code");
				}
				if (cctrCode == null || "null".equals(cctrCode))
				{
					cctrCode = "    ";
				}

				DetMap = new HashMap();
				DetMap.put("tran_id",(String) HdrMap.get("tran_id"));
				lineNo++;
				DetMap.put("line_no",(String) "" +lineNo);
				DetMap.put("acct_code",acctCode);
				DetMap.put("cctr_code",cctrCode);
				DetMap.put("amount", rs.getDouble("tax_amt") - rs.getDouble("reco_amt"));
				DetMap.put("emp_code","");
				DetMap.put("anal_code","");
				DetMap.put("exch_rate", (double) Double.parseDouble( "" + HdrMap.get("exch_rate")));
				DetList.add(DetMap);

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (errCode != null && errCode.trim().length() > 0 )
			{
				return errCode;
			}
			recoAmount = 0;
			
			//Changed by wasim on 24-MAY-2017 to check tran_type null or not [START]
			//taxRecoCctr = finCommon.getAcctDetrTtype(" ", " ", "TAXRECO", (String) HdrMap.get("tran_type"), conn);
			if(HdrMap !=null && HdrMap.get("tran_type") != null)
			{
				tranType = (String) HdrMap.get("tran_type");
			}
			taxRecoCctr = finCommon.getAcctDetrTtype(" ", " ", "TAXRECO", tranType, conn);
			//Changed by wasim on 24-MAY-2017 to check tran_type null or not [END]
			if (taxRecoCctr != null && taxRecoCctr.trim().length() > 0)
			{
				taxRecoAcct = taxRecoCctr.substring(0,taxRecoCctr.indexOf(","));
				taxRecoCctr = taxRecoCctr.substring(taxRecoCctr.indexOf(",")+1);
			}

			sql = " select acct_code__reco,	cctr_code__reco, case when sum(reco_amount) is null then 0 else sum(reco_amount) end reco_amount "
				+ " from taxtran where tran_code = ? and tran_id = ? and tax_amt <> 0 and (case when reco_amount is null then 0 else reco_amount end) <> 0  and effect <> 'N' "
				+ " group by acct_code__reco,	cctr_code__reco";              
			pstmt = conn.prepareStatement(sql);

			//Changed by wasim on 24-MAY-2017
			//pstmt.setString(1, (String) HdrMap.get("tran_ser"));
			pstmt.setString(1, tranSer);
			pstmt.setString(2,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				acctReco = rs.getString("acct_code__reco");
				cctrReco = rs.getString("cctr_code__reco");
				recoAmount = rs.getDouble("reco_amount");
				if (acctReco == null || acctReco.trim().length() == 0 )
				{
					cctrReco = taxRecoCctr;
					acctReco = taxRecoAcct;
				}

				// If ACCT Code is NULL/SPACE Then Exit
				if (acctReco == null || acctReco.trim().length() == 0 )
				{
					errCode = "VTACCTRECO"; 
					break;
				}
				if (cctrReco == null || "null".equals(cctrReco))
				{
					cctrReco = "    ";
				}
				DetMap = new HashMap();
				DetMap.put("tran_id",(String) HdrMap.get("tran_id"));
				lineNo++;
				DetMap.put("line_no",(String) "" +lineNo);
				DetMap.put("acct_code",acctReco);
				DetMap.put("cctr_code",cctrReco);
				DetMap.put("amount", recoAmount);
				DetMap.put("emp_code","");
				DetMap.put("anal_code","");
				DetMap.put("exch_rate",(double) Double.parseDouble( "" + HdrMap.get("exch_rate")));
				DetList.add(DetMap);
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			if (errCode != null && errCode.trim().length() > 0 )
			{
				return errCode;
			}

			sql = " select tran_id ,line_no ,acct_code,cctr_code ,drcr_amt,exch_rate__inv from drcr_invdet where tran_id = ? and drcr_amt <> 0";              
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				findIndex = -1;
				findIndex = findExistingIndex(DetList,rs.getString("acct_code"), rs.getString("cctr_code"), rs.getDouble("exch_rate__inv"));
				System.out.println(" 16/06/14 findExistingIndex [" + findIndex + "] Map [" + DetList.toString() + "]");
				if (findIndex > -1) 
				{
					DetMap = (HashMap) DetList.get(findIndex);
					amountMap = (double) Double.parseDouble( "" + DetMap.get("amount"));
					System.out.println(" 16/06/14 findExistingIndex [" + findIndex + "] amountMap [" + amountMap + "] amount [" + rs.getDouble("drcr_amt") + "]");
					DetMap.put("amount", amountMap + rs.getDouble("drcr_amt"));
					DetList.set(findIndex, DetMap);
				}
				else
				{
					DetMap = new HashMap();
					DetMap.put("tran_id", rs.getString("tran_id"));
					lineNo++;
					DetMap.put("line_no",(String) "" +lineNo);
					DetMap.put("amount", rs.getDouble("drcr_amt"));
					DetMap.put("emp_code", "");
					DetMap.put("anal_code", "");
					DetMap.put("acct_code", rs.getString("acct_code"));

					cctrCode = rs.getString("cctr_code");

					if (cctrCode == null || "null".equals(cctrCode))
					{
						cctrCode = "    ";
					}


					DetMap.put("cctr_code", cctrCode );
					exchRateInv = rs.getDouble("exch_rate__inv");
					if (exchRateInv == 0)
					{
						exchRateInv = (double) Double.parseDouble( "" + HdrMap.get("exch_rate"));
					}
					DetMap.put("exch_rate",exchRateInv);
					DetList.add(DetMap);
				}
				System.out.println(DetMap.toString());
			}    
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			
			//Changed by wasim on 24-MAY-2017 to check diff_amt_exch null or not [START]
			//diffExchAmt = (double) Double.parseDouble( "" +HdrMap.get("diff_amt_exch"));
			if(HdrMap !=null && HdrMap.get("diff_amt_exch") != null)
			{
				diffExchAmt = (double) Double.parseDouble( "" +HdrMap.get("diff_amt_exch"));
			}
			//Changed by wasim on 24-MAY-2017 to check tran_type null or not [END]
			if (diffExchAmt != 0 )
			{
				acctExch = (String) HdrMap.get("acct_code__cf"); 
				cctrExch = (String) HdrMap.get("cctr_code__cf");
				if (cctrExch == null || "null".equals(cctrExch))
				{
					cctrExch = "    ";
				}

				DetMap = new HashMap();
				DetMap.put("tran_id", rs.getString("tran_id"));
				lineNo++;
				DetMap.put("line_no",(String) "" +lineNo);
				DetMap.put("amount", diffExchAmt);
				DetMap.put("emp_code", "");
				DetMap.put("anal_code", "");
				DetMap.put("acct_code", acctExch);
				DetMap.put("cctr_code", cctrExch);
				DetMap.put("exch_rate", 1);
				DetList.add(DetMap);

			}
			
			//Changed by wasim on 24-MAY-2017 to check round_adj null or not [START]
			//roundAdj = (double) Double.parseDouble( "" +HdrMap.get("round_adj"));
			if(HdrMap !=null && HdrMap.get("round_adj") != null)
			{
				roundAdj = (double) Double.parseDouble( "" +HdrMap.get("round_adj"));
			}
			//Changed by wasim on 24-MAY-2017 to check round_adj null or not [END]
			if ( roundAdj != 0 )
			{

				cctrRnd = finCommon.getFinparams("999999", "DRCR_ACCT_RND", conn);
				if (cctrRnd != null && cctrRnd.trim().length() > 0)
				{
					acctRnd = cctrRnd.substring(0,cctrRnd.indexOf(";"));
					cctrRnd = cctrRnd.substring(cctrRnd.indexOf(";")+1);
				}
				if (cctrRnd == null || "null".equals(cctrRnd))
				{
					cctrRnd = "    ";
				}

				DetMap = new HashMap();
				DetMap.put("tran_id", rs.getString("tran_id"));
				lineNo++;
				DetMap.put("line_no",(String) "" +lineNo);
				DetMap.put("amount", roundAdj);
				DetMap.put("emp_code", "");
				DetMap.put("anal_code", "");
				DetMap.put("acct_code", acctRnd);
				DetMap.put("cctr_code", cctrRnd);
				DetMap.put("exch_rate", 1);
				DetList.add(DetMap);
			}
			sql = "Insert into drcr_invacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE__INV,AMOUNT) values (?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			int maxline = 0;
			System.out.println("08/01/15 DetList ["+DetList.toString() + "]");
			for(int i = 0 ; i < DetList.size() ; i++)
			{

				double tempAmt = (double) Double.parseDouble( "" +DetMap.get("amount"));
				if (tempAmt != 0)
				{
					maxline++;
					DetMap = (HashMap) DetList.get(i);
					System.out.println(" Insert in drcr_invacct ctr [" + i + "] Map [" + HdrMap.toString() + "]");
					pstmt.setString(1,(String) DetMap.get("tran_id"));
					pstmt.setInt(2,maxline);
					pstmt.setString(3,(String) DetMap.get("acct_code"));
					cctrCode = (String) DetMap.get("cctr_code");
					if (cctrCode == null || "null".equals(cctrCode))
					{
						cctrCode = "    ";
					}
					pstmt.setString(4,cctrCode);
					pstmt.setDouble(5,(double) Double.parseDouble( "" +DetMap.get("exch_rate")));
					pstmt.setDouble(6,(double) Double.parseDouble( "" +DetMap.get("amount")));
					pstmt.addBatch();
					pstmt.clearParameters();
				}
			}
			if (maxline > 0 ) 
			{
				pstmt.executeBatch();
			}
			pstmt.close();
			pstmt = null;

			errCode = gbfPostDrCr(tranId, HdrMap,DetList,xtraParams,conn);

		}
		catch(SQLException sqx)
		{
			SQLException ex ;

			while (sqx != null)
			{
				if((CommonConstants.DB_NAME).equalsIgnoreCase("oracle") && (sqx).toString().indexOf("ORA-00054") > -1)
				{
					errCode = "VTLCKERR";

					System.out.println("The SQLException occurs in UpdatStock [Stockupdate]  Exception[Recod is locked try after some time]  ["+sqx.toString() + "]");
				}
				else
				{
					errCode = "ERROR";
					System.out.println("The SQLException occurs in UpdatStock [Stockupdate]  Exception ["+sqx.toString() + "]");
				}
				ex = sqx;

				sqx.printStackTrace();
				sqx =  sqx.getNextException();
				if(sqx == null)
				{
					sqx = ex;
					break;
				}
			}
			throw new ITMException(sqx);
		}
		catch(Exception se12){
			System.out.println("Exception in UpdatStock [Stockupdate]"+se12);
			se12.printStackTrace();
			throw new ITMException(se12);

		}
		return errCode;
	}
	private String gbfPostDrCr(String tranId, HashMap HdrMap,ArrayList DetList, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		String errCode = "";
		//FinCommon finCommon = null;
		try
		{
			//finCommon = new  FinCommon();
			errCode = gbfPostDrcrInvhdr(tranId, HdrMap, xtraParams,conn);
			System.out.println("16/06/14 after gbfPostDrcrInvhdr errCode [" + errCode + "]");
			if(errCode == null || errCode.trim().length() ==0)
			{
				errCode = gbfPostDrcrInvdet(tranId, HdrMap,DetList, xtraParams,conn);
				System.out.println("16/06/14 after gbfPostDrcrInvdet errCode [" + errCode + "]");
				if(errCode != null && errCode.trim().length() >0)
				{
					return errCode;
				}
			}
			System.out.println("16/06/14 after gbfPostDrcrInvdet errCode [" + errCode + "]");
			errCode = finCommon.checkGlTranDrCr("CRNINV",tranId,conn);

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return errCode ;

	}
	private String gbfPostDrcrInvhdr(String tranId,HashMap HdrMap,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("gbfPostDrcrinv called..............");
		String errString = "";
		String currCode = "";
		String siteCode = "";
		String siteCodeFor = "";
		String finEntity = "";
		String acctCode = "";
		String cctrCode = ""; 
		String recoAcctCode = "";
		String recoCctrCode = "";
		String taxAcctCode = "";
		String taxCctrCode = "";
		String acctCode1 = "";
		String cctrCode1 = "";
		String acctCodeAr = "";
		String cctrCodeAr = "";
		String projectCode = "";
		String analCode = "";
		String bankCode = "";
		String remarks = "";
		String sundryType = "";
		String contactCode = "";
		String sundryCode = "";
		String sundryTypeFor = "";
		String sundryCodeFor = "";
		String tranType = "";
		String empCode = "";
		String refNO = "";
		String payMode = "";
		String rcpMode = "";
		String batchNo = "";
		String confirm = "";
		String loginEmpCode = "";
		String winName = "";
		String editOption = "";
		String sql = "";
		String hcurrCode = "";
		String errorType = "";
		String payslip = "";
		String partyDocRef = "";
		String refSer = "";
		String refNo = "";
		String salesPers = "";
		String status = "";
		String lineNoPef = "";

		String tranSer = "",drcrFlag = "";
		int count = 0;
		int lineNo = 0;
		double exchRate = 0.0;
		double hexchRate = 0.0;
		double netAmount = 0.0;
		double amount = 0.0;
		double taxAmount = 0.0;
		double recoAmount = 0.0;
		double debit  = 0.0;
		double credit = 0.0;
		double totAmt = 0.0;
		double advAmt = 0.0;
		double adjAmt = 0.0;
		double advAdj = 0.0;
		double recoverAmt = 0.0;
		java.sql.Timestamp effDate = null;
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp refDate = null;
		java.sql.Timestamp billDate = null;
		java.sql.Timestamp dueDate = null;

		HashMap DetMap = null;
		HashMap miscPayMap = null;
		HashMap glTraceMap = null;
		HashMap sundryBalMap = null;
		HashMap bankTranLogMap = null;
		HashMap detListMap = null;
		HashMap recofiltMap = null;
		HashMap recodataMap = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//FinCommon finCommon = null;
		DistCommon distCommon = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ValidatorEJB validatorEJB = new ValidatorEJB();
		//		GenericUtility genericUtility = new GenericUtility();
		try
		{
			//finCommon = new  FinCommon();
			distCommon = new DistCommon();
			itmDBAccessEJB = new ITMDBAccessEJB();
			loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			//tranId = (String)HdrMap.get("tran_id");
			tranSer = (String)HdrMap.get("tran_ser");

			tranDate = (Timestamp)HdrMap.get("tran_date");
			effDate = (Timestamp)HdrMap.get("eff_date");
			finEntity = (String)HdrMap.get("fin_entity");
			siteCode = (String)HdrMap.get("site_code");
			siteCodeFor = (String)HdrMap.get("site_code__for");
			projectCode = (String)HdrMap.get("proj_code");
			hcurrCode = (String)HdrMap.get("curr_code");
			hexchRate = (double) Double.parseDouble( "" + HdrMap.get("exch_rate"));
			remarks = (String)HdrMap.get("remarks");
			confirm = (String)HdrMap.get("confirm");
			dueDate = (Timestamp)HdrMap.get("due_date");

			sundryType = (String)HdrMap.get("sundry_type");
			sundryCode = (String)HdrMap.get("sundry_code");
			amount = (double) Double.parseDouble( "" + HdrMap.get("amount")); 
			remarks = (String)HdrMap.get("remarks");

			glTraceMap = new HashMap();
			glTraceMap.put("tran_date",new Timestamp(tranDate.getTime()));
			glTraceMap.put("eff_date",new Timestamp(effDate.getTime()));
			glTraceMap.put("fin_entity", finEntity);
			glTraceMap.put("site_code", siteCode);
			glTraceMap.put("sundry_type",sundryType);
			glTraceMap.put("sundry_code",sundryCode);
			glTraceMap.put("acct_code", (String)HdrMap.get("acct_code"));

			glTraceMap.put("cctr_code", (String)HdrMap.get("cctr_code")==null?"":(String)HdrMap.get("cctr_code"));
			glTraceMap.put("emp_code", "");
			glTraceMap.put("anal_code", (String)HdrMap.get("anal_code"));
			glTraceMap.put("curr_code", (String)HdrMap.get("curr_code")==null?hcurrCode:(String)HdrMap.get("curr_code"));

			glTraceMap.put("exch_rate", (double) Double.parseDouble( "" + HdrMap.get("exch_rate")));
			drcrFlag = (String) HdrMap.get("drcr_flag");
			System.out.println("gltrace  drcrFlag ["+ drcrFlag + "]amount [" + amount+ "]");
			if("D".equals(drcrFlag))
			{
				glTraceMap.put("dr_amt",amount);
				glTraceMap.put("cr_amt",0.0);
			}
			else
			{
				glTraceMap.put("dr_amt", 0.0);
				glTraceMap.put("cr_amt",amount);
			}
			glTraceMap.put("ref_type","F");
			glTraceMap.put("ref_ser", tranSer);
			glTraceMap.put("ref_id", tranId);
			glTraceMap.put("remarks",remarks);

			System.out.println("848 glTraceUpdate Called glTraceMap[" + glTraceMap.toString() + "]");
			errString = finCommon.glTraceUpdate(glTraceMap,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				System.out.println("ERROR IN GLTRACE ...........");

				return errString;
			}

			// Populate sundry balance structure
			sundryBalMap = new HashMap();
			sundryBalMap.put("tran_date",new Timestamp(tranDate.getTime()));
			sundryBalMap.put("eff_date",new Timestamp(effDate.getTime()));
			sundryBalMap.put("fin_entity", finEntity);
			sundryBalMap.put("site_code", siteCode);
			sundryBalMap.put("sundry_type", sundryType);
			sundryBalMap.put("sundry_code", sundryCode);
			sundryBalMap.put("acct_code", (String)HdrMap.get("acct_code"));
			sundryBalMap.put("cctr_code", (String)HdrMap.get("cctr_code")==null?"":(String)HdrMap.get("cctr_code"));
			sundryBalMap.put("curr_code", (String)HdrMap.get("curr_code"));
			sundryBalMap.put("exch_rate", (double) Double.parseDouble( "" + HdrMap.get("exch_rate")));

			if("D".equals(drcrFlag))
			{
				sundryBalMap.put("dr_amt", amount);
				sundryBalMap.put("cr_amt", 0.0);
			}

			else
			{
				sundryBalMap.put("dr_amt", 0.0);
				sundryBalMap.put("cr_amt", amount);
			}


			sundryBalMap.put("adv_amt", 0.0);

			System.out.println("2366 sundryBaleUpdate Called..............");
			errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
			if(errString != null && errString.trim().length() > 0)
			{
				System.out.println("error is sundryBaleUpdate ..........."+errString);

				return errString;
			}


			///Populate the misc_payables structure				/////
			// insert into misc_payable	
			miscPayMap = new HashMap();
			miscPayMap.put("tran_date",new Timestamp(tranDate.getTime()));
			miscPayMap.put("tran_ser",(String)HdrMap.get("tran_ser"));
			miscPayMap.put("ref_no",(String)HdrMap.get("ref_no"));
			miscPayMap.put("ref_date", new Timestamp(tranDate.getTime()));			
			//miscPayMap.put("bill_no", (String)HdrMap.get("bill_no"));
			//miscPayMap.put("bill_date", new Timestamp(billDate.getTime()));
			miscPayMap.put("sundry_type",(String)HdrMap.get("sundry_type")==null?"O":(String)HdrMap.get("sundry_type"));
			miscPayMap.put("sundry_code", (String)HdrMap.get("sundry_code")==null?"O":(String)HdrMap.get("sundry_code"));
			miscPayMap.put("acct_code", (String)HdrMap.get("acct_code"));
			miscPayMap.put("cctr_code", (String)HdrMap.get("cctr_code")==null?"":(String)HdrMap.get("cctr_code"));
			miscPayMap.put("curr_code", (String)HdrMap.get("curr_code"));
			miscPayMap.put("exch_rate", (double) Double.parseDouble( "" + HdrMap.get("exch_rate")));


			miscPayMap.put("due_date", new Timestamp(dueDate.getTime()));
			miscPayMap.put("site_code",siteCode);
			miscPayMap.put("fin_entity",finEntity);
			if("C".equals(drcrFlag))
			{
				miscPayMap.put("tot_amt", amount);
			}
			else
			{
				miscPayMap.put("tot_amt", -1 * amount);
			}
			sql = "select bank_code   from site where site_code = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				bankCode = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "select pay_mode from sales_pers where sales_pers = ?" ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				payMode = rs.getString(1)==null?"Q":rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			miscPayMap.put("bank_code", bankCode);
			miscPayMap.put("auto_pay", "Y");
			miscPayMap.put("pay_mode", payMode);
			miscPayMap.put("paid", "N");
			miscPayMap.put("adv_amt", 0.0);
			miscPayMap.put("hold_amt", 0.0);
			miscPayMap.put("supp_bill_amt","0.0");
			miscPayMap.put("tds_amt","0.0");


			System.out.println("884 sundryBaleUpdate Called..............");
			errString = finCommon.gbfMiscPayUpd(miscPayMap, conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			if(confirm == null || "null".equals(confirm))
			{
				confirm = "N";
			}
			/*if(!"Y".equals(confirm))
			{
				sql = "update drcr_inv set confirmed = 'Y', conf_date = ? ,emp_code__aprv = ? where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDate(1, new java.sql.Date(new java.util.Date().getTime()));
				pstmt.setString(2, loginEmpCode);
				pstmt.setString(3, tranId);
				int updateCoount = pstmt.executeUpdate();
				System.out.println("no of row update = "+updateCoount);
				pstmt.close();
				pstmt = null;
				if(updateCoount > 0)
				{
					errString= itmDBAccessEJB.getErrorString("","VTCICONF3 ","","",conn);
					return errString;
				}
			}*/



		}
		catch(Exception e)
		{
			errString = "ERROR";
			throw new ITMException(e);
		}
		return errString;
	}

	private String gbfPostDrcrInvdet(String tranId,HashMap HdrMap,ArrayList DetList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("gbfPostDrcrInvdet called........");
		String errString = "";
		String linkType = "";
		String currCode = "";
		String siteCode = "";
		String siteCodeFor = "";
		String finEntity = "";
		HashMap DetMap = null;
		String acctCode = "";
		String cctrCode = "";
		String acctCodePay = "";
		String cctrCodePay = "";
		String acctCodeAr = "";
		String cctrCodeAr = "";
		String tranSer = "";
		String projectCode = "";
		String analCode = "";
		String bankCode = "";
		String remarks = "";
		String sundryType = "";
		String sundryCode = "";
		String sundryTypeFor = "";
		String sundryCodeFor = "";
		String contactCode = "";
		String empCode = "";
		String refNO = "";
		String rcpMode = "";
		String batchNo = "";
		String tranType = "";
		String confirm = "";
		String loginEmpCode = "";
		String winName = "";
		String editOption = "";
		String confirmed = "";
		String sql = "";
		String errorType = "";
		String bdFluctuationCf = "";
		String acctCodeBal = "";
		String cctrCodeBal = "";
		String basecurrCode = "";
		String projCode = "";
		String custCode = "";
		String salesPers = "";
		String refSer = "";
		String refNo = "";
		String acctCodeCf = "";
		String payslip = "";
		//String tranId = "";
		boolean isInBaseCurr =false;
		int count = 0;
		int cnt1 = 0 ;
		int cnt = 0;
		double exchRate = 0.0;
		double netAmount = 0.0;
		double amount = 0.0;
		double advAmt = 0.0;
		double netAmt = 0.0;
		double chqAmt = 0.0;
		double debit  = 0.0;
		double credit = 0.0;
		double totAmt = 0.0;
		double ediOption = 0.0;
		double netAmountBc = 0.0;
		Date effDate = null;
		Date tranDate = null;
		Date refDate = null;
		HashMap detListMap = null;
		HashMap glTraceMap = null;
		HashMap sundryBalMap = null;
		HashMap bankTranLogMap = null;
		HashMap receivablesMap = null;
		HashMap epcadjMap = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//FinCommon finCommon = null;
		ValidatorEJB validatorEJB = new ValidatorEJB();
		//		GenericUtility genericUtility = new GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = null;
		try
		{
			//finCommon =new  FinCommon();

			loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

			java.util.Date today=	new java.sql.Date(new java.util.Date().getTime());

			itmDBAccessEJB = new ITMDBAccessEJB();

			linkType = (String)HdrMap.get("link_type");
			//tranId = (String)HdrMap.get("tran_id");

			tranDate = (Date)HdrMap.get("tran_date");
			refDate = (Date)HdrMap.get("ref_date");
			effDate = (Date)HdrMap.get("eff_date");
			remarks = (String)HdrMap.get("remarks");

			finEntity = (String)HdrMap.get("fin_entity");
			siteCode = (String)HdrMap.get("site_code");
			tranSer = (String)HdrMap.get("tran_ser");
			bankCode = (String)HdrMap.get("bank_code");

			acctCode = (String)HdrMap.get("acct_code");
			cctrCode = (String)HdrMap.get("cctr_code");

			currCode = (String)HdrMap.get("curr_code");
			exchRate = (double) Double.parseDouble( "" + HdrMap.get("exch_rate"));

			System.out.println("DetList SIZE "+DetList.size());
			System.out.println("DetList SIZE ["+DetList.toString() + "]");

			for (int ctr =0; ctr < DetList.size(); ctr++)
			{

				System.out.println("no of times "+ctr);
				DetMap = new HashMap();
				DetMap = (HashMap) DetList.get(ctr);


				sundryCode = (String)DetMap.get("sundry_code");
				sundryType = (String)DetMap.get("sundry_type");

				acctCode = (String)DetMap.get("acct_code");
				cctrCode = (String)DetMap.get("cctr_code");
				//empCode = (String)DetMap.get("emp_code");
				//analCode = (String)DetMap.get("anal_code");

				exchRate = (double) Double.parseDouble( "" + DetMap.get("exch_rate"));
				analCode = (String)DetMap.get("anal_code");
				analCode = (String)DetMap.get("anal_code");
				amount = (double) Double.parseDouble( "" + DetMap.get("amount"));


				System.out.println("DetMap SIZE "+DetMap);

				glTraceMap = new HashMap();
				glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
				glTraceMap.put("eff_date",new Timestamp(effDate.getTime()));
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", sundryType);
				glTraceMap.put("sundry_code", sundryCode);
				glTraceMap.put("acct_code", acctCode);
				glTraceMap.put("cctr_code", cctrCode);
				//glTraceMap.put("emp_code", empCode);
				//glTraceMap.put("anal_code", analCode);
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				if("D".equals(HdrMap.get("drcr_flag")))
				{
					if(amount > 0 )
					{
						glTraceMap.put("dr_amt",0.0);
						glTraceMap.put("cr_amt",amount);
					}
					else
					{
						glTraceMap.put("dr_amt", -1 * amount);
						glTraceMap.put("cr_amt",0.0);
					}
				}
				else
				{
					if(amount > 0 )
					{
						glTraceMap.put("dr_amt", amount);
						glTraceMap.put("cr_amt", 0.0 );
					}
					else
					{
						glTraceMap.put("dr_amt", 0.0);
						glTraceMap.put("cr_amt",  -1 * amount);
					}
				}

				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser", tranSer);
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);

				System.out.println("1766 glTraceUpdate Called..drcrflag [" + HdrMap.get("drcr_flag") + "] glTraceMap [" + glTraceMap + "]");
				errString = finCommon.glTraceUpdate(glTraceMap,conn); 
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
		}
		catch(Exception e)
		{
			errString = "ERROR";
			throw new ITMException(e);
		}
		return errString;

	}
	private int findExistingIndex(ArrayList detList, String acctCode, String cctrCode, double exchRate)throws RemoteException,ITMException
	{
		int findIndex  = -1;
		HashMap detMap = null;
		String acctCodeMap = null, cctrCodeMap = null;
		double exchRateMap = 0;
		try
		{
			for(int ctr=0 ; ctr < detList.size() ; ctr++)
			{
				detMap = (HashMap) detList.get(ctr);
				acctCodeMap = (String) detMap.get("acct_code");
				cctrCodeMap = (String) detMap.get("cctr_code");
				exchRateMap = (double) Double.parseDouble( "" + detMap.get("exch_rate"));
				if (acctCodeMap.trim().equalsIgnoreCase(acctCode.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCode.trim()) && exchRateMap == exchRate)
				{
					findIndex = ctr;
					break;
				}

			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return findIndex;
	}
	public String retrieveMiscDrcrRcp(String businessObj, String tranIdFr,String xtraParams, String forcedFlag) throws ITMException
	{
		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		int cnt = 0;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = getConnection();
			conn.setAutoCommit(false);
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1,businessObj);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			if (pStmt != null)
			{
				pStmt.close();
				pStmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1,serviceCode);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			if (pStmt != null)
			{
				pStmt.close();
				pStmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));			
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI); 
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);

			call.setReturnType(XMLType.XSD_STRING);
			retString = (String)call.invoke(aobj);
			System.out.println("Return string from NVO is:==>["+retString+"]");	
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
				if( conn != null ){
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{}
		}
		return retString;
	}
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}
	public String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	
	//Changed by wasim on 24-MAY-2017 for migration to retrieve DRCRrcp [START]
	private String gbfRetrieveDrCrRcp(String tranId,String siteCode,String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today;
		//FinCommon finCommon = null;
		
		ArrayList<String> tranIDList = new ArrayList<String>();
		ArrayList<Map> detailList = new ArrayList<Map>();
		ArrayList<Map> adjList = new ArrayList<Map>();
		
		Map hdrMap = new HashMap();
		Map detMap = new HashMap();
		Map adjMap = new HashMap();
		
		int hdrCount = 0, dtlCount = 0,countRec = 0,taxRows = 0,adjCount = 0,countRcv = 0,updRowCnt = 0;
		double recoAmt = 0,amount = 0,amountTotal = 0,drcrAmount = 0,total = 0,amountHdr = 0,exchRate = 0,
				amountHdr1 = 0, roundTo = 0,adjAmount = 0,recoAmount = 0,diffExchAmt = 0,roundAdj = 0,amountDet = 0,totalAmountRec = 0,adjAmountRec = 0;
		
		String invoiceIDHdr = "", tranIDDrcrRcp = "",tranSer = "",winName = "",ledgPostConf = "",errCode = "",acctCode = "",cctrCode= "",
		posType = "",itemSer = "",acctCodeSal = "",cctrCodeSal = "",cctrCodeAr = "",acctReco = "",cctrReco = "",acctRnd = "",cctrRnd = "",
		tranType = "",invType = "",lineNo = "",taxAmt = "",itemCode = "",lsStr = "",custCode = "",refNo = "",refSer = "",roundOff = "";
		
		try
		{
			//finCommon = new FinCommon();
			System.out.println("Inside gbfRetrieveDrCrRcp.....tranId["+tranId+"] siteCode["+siteCode+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");
			
			sql = " select tran_id from drcr_rcp where tran_id 	>= ? and tran_id <= ? and "
				 +" site_code =  ? and confirmed = 'N' order by tran_id asc ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.setString(2,tranId);
			pstmt.setString(3,siteCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranIDDrcrRcp = rs.getString("tran_id");
				tranIDList.add(tranIDDrcrRcp);
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			for(int i = 0; i<tranIDList.size(); i++)
			{
				tranIDDrcrRcp = tranIDList.get(i);
				
				System.out.println("TranID is--->["+tranIDDrcrRcp+"]");
				
				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT tran_id FROM drcr_rcp  WHERE tran_id = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT tran_id FROM drcr_rcp (updlock) WHERE tran_id = ? " ;
				}
				else
				{
					sql =" SELECT tran_id  FROM drcr_rcp WHERE tran_id =  ? for update nowait" ;
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDDrcrRcp);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranIDDrcrRcp = rs.getString("tran_id") == null ? " ":rs.getString("tran_id");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				hdrCount = 0;
				sql = " select tran_id,tran_date,fin_entity,cust_code,acct_code,cctr_code,eff_date,invoice_id,amount,curr_code,exch_rate,remarks,"
					+ " site_code,anal_code,drcr_flag,tran_id__rcv,confirmed,conf_date,emp_code__aprv,tran_type,tran_ser,due_date,cr_term,chg_date,"
					+ " chg_user,chg_term,add_date,add_user,add_term,amount__bc,item_ser,round_adj,sreturn_no,adj_recv,gp_ser,gp_no,gp_date,"
					+ " parent__tran_id,rev__tran,cust_ref_no,cust_ref_date,cust_ref_amt,rnd_off,rnd_to,sundry_type,sundry_code,site_code__drcr,"
					+ " drcr_type,ord_billback_amt,ord_offinv_amt,line_billback_amt,line_offinv_amt,edi_stat "
					+ " from drcr_rcp where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDDrcrRcp);
				rs = pstmt.executeQuery();
				if(rs.next())
				{ 
					hdrCount++;
					hdrMap.put("tran_id", rs.getString("tran_id"));
					hdrMap.put("tran_date", rs.getTimestamp("tran_date"));
					hdrMap.put("fin_entity", rs.getString("fin_entity"));
					hdrMap.put("cust_code", rs.getString("cust_code"));
					hdrMap.put("acct_code", rs.getString("acct_code"));
					hdrMap.put("cctr_code", rs.getString("cctr_code"));
					hdrMap.put("eff_date", rs.getTimestamp("eff_date"));
					hdrMap.put("invoice_id", rs.getString("invoice_id"));
					hdrMap.put("amount", rs.getDouble("amount"));
					hdrMap.put("curr_code", rs.getString("curr_code"));
					hdrMap.put("exch_rate", rs.getDouble("exch_rate"));
					hdrMap.put("remarks", rs.getString("remarks"));
					hdrMap.put("site_code", rs.getString("site_code"));
					hdrMap.put("anal_code", rs.getString("anal_code"));
					hdrMap.put("drcr_flag", rs.getString("drcr_flag"));
					hdrMap.put("tran_id__rcv", rs.getString("tran_id__rcv"));
					hdrMap.put("confirmed", rs.getString("confirmed"));
					hdrMap.put("conf_date", rs.getString("conf_date"));
					hdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
					hdrMap.put("tran_type", rs.getString("tran_type"));
					hdrMap.put("tran_ser", rs.getString("tran_ser"));
					hdrMap.put("due_date", rs.getTimestamp("due_date"));
					hdrMap.put("cr_term", rs.getString("cr_term"));
					hdrMap.put("chg_date", rs.getTimestamp("chg_date"));
					hdrMap.put("chg_term", rs.getString("chg_term"));
					hdrMap.put("add_date", rs.getTimestamp("add_date"));
					hdrMap.put("add_user", rs.getString("add_user"));
					hdrMap.put("add_user", rs.getString("add_user"));
					hdrMap.put("amount__bc", rs.getString("amount__bc"));
					hdrMap.put("item_ser", rs.getString("item_ser"));
					hdrMap.put("round_adj", rs.getDouble("round_adj"));
					hdrMap.put("sreturn_no", rs.getString("sreturn_no"));
					hdrMap.put("adj_recv", rs.getString("adj_recv"));
					hdrMap.put("gp_ser", rs.getString("gp_ser"));
					hdrMap.put("gp_no", rs.getString("gp_no"));
					hdrMap.put("gp_date", rs.getTimestamp("gp_date"));
					hdrMap.put("parent__tran_id", rs.getString("parent__tran_id"));
					hdrMap.put("rev__tran", rs.getString("rev__tran"));
					hdrMap.put("cust_ref_no", rs.getString("cust_ref_no"));
					hdrMap.put("cust_ref_date", rs.getTimestamp("cust_ref_date"));
					hdrMap.put("cust_ref_amt", rs.getDouble("cust_ref_amt"));
					hdrMap.put("rnd_off", rs.getString("rnd_off"));
					hdrMap.put("rnd_to", rs.getDouble("rnd_to"));
					hdrMap.put("sundry_type", rs.getString("sundry_type"));
					hdrMap.put("sundry_code", rs.getString("sundry_code"));
					hdrMap.put("site_code__drcr", rs.getString("site_code__drcr"));
					hdrMap.put("drcr_type", rs.getString("drcr_type"));
					hdrMap.put("ord_billback_amt",  rs.getDouble("ord_billback_amt"));
					hdrMap.put("ord_offinv_amt", rs.getDouble("ord_offinv_amt"));
					hdrMap.put("line_billback_amt", rs.getDouble("line_billback_amt"));
					hdrMap.put("line_offinv_amt", rs.getDouble("line_offinv_amt"));
					hdrMap.put("edi_stat", rs.getString("edi_stat"));
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				/*sql = " select tran_id,line_no,invoice_id,line_no__inv,item_code,sales_pers,tax_class,tax_chap,tax_env,drcr_amt,tax_amt,net_amt, "
					+ " reas_code,cost_rate,rate__std,quantity,rate,rate__clg,discount,line_no__sret,line_no__invtrace,lot_no,lot_sl,tran_id__rcp, "
					+ " billback_amt,offinv_amt "
					+ " from drcr_rdet where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDDrcrRcp);
				rs = pstmt.executeQuery();
				while(rs.next())
				{ 
					detMap = new HashMap();
					detMap.put("tran_id", rs.getString("tran_id"));
					detMap.put("line_no", rs.getString("line_no"));
					detMap.put("invoice_id", rs.getString("invoice_id"));
					detMap.put("line_no__inv", rs.getString("line_no__inv"));
					detMap.put("item_code", rs.getString("item_code"));
					detMap.put("sales_pers", rs.getString("sales_pers"));
					detMap.put("tax_class", rs.getString("tax_class"));
					detMap.put("tax_chap", rs.getString("tax_chap"));
					detMap.put("tax_env", rs.getString("tax_env"));
					detMap.put("drcr_amt", rs.getDouble("drcr_amt"));
					detMap.put("tax_amt", rs.getDouble("tax_amt"));
					detMap.put("net_amt", rs.getDouble("net_amt"));
					detMap.put("reas_code", rs.getString("reas_code"));
					detMap.put("cost_rate", rs.getDouble("cost_rate"));
					detMap.put("rate__std", rs.getDouble("rate__std"));
					detMap.put("quantity", rs.getDouble("quantity"));
					detMap.put("rate", rs.getDouble("rate"));
					detMap.put("rate__clg", rs.getDouble("rate__clg"));
					detMap.put("discount", rs.getDouble("discount"));
					detMap.put("line_no__sret", rs.getString("line_no__sret"));
					detMap.put("line_no__invtrace", rs.getString("line_no__invtrace"));
					detMap.put("lot_no", rs.getString("lot_no"));
					detMap.put("lot_sl", rs.getString("lot_sl"));
					detMap.put("tran_id__rcp", rs.getString("tran_id__rcp"));
					detMap.put("billback_amt", rs.getDouble("billback_amt"));
					detMap.put("offinv_amt", rs.getDouble("offinv_amt"));
					detMap.put("amount", 0.0);
					
					detailList.add(detMap);
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}*/
				
				tranSer = (String) hdrMap.get("tran_ser");
				tranId = (String) hdrMap.get("tran_id");
				//tranDate = Timestamp.valueOf(genericUtility.getValidDateString(hdrMap.get("tran_date"), genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
				tranDate = (Timestamp) hdrMap.get("tran_date");
				tranDate = java.sql.Timestamp.valueOf(sdf.format(tranDate) + " 00:00:00.000");
				
				if(hdrCount > 0)
				{
					invoiceIDHdr = (String) hdrMap.get("invoice_id");
					
					sql = " select posttype, item_ser,acct_code__sal, cctr_code__sal, cctr_code__ar from invoice where invoice_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,invoiceIDHdr);
					rs = pstmt.executeQuery();
					if(rs.next())
					{ 
						posType = rs.getString("posttype");
						itemSer = rs.getString("item_ser");
						acctCodeSal = rs.getString("acct_code__sal");
						cctrCodeSal = rs.getString("cctr_code__sal");
						cctrCodeAr = rs.getString("cctr_code__ar");
					}
					if(rs != null)
					{
						rs.close();rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					
					System.out.println("acctCodeSal["+acctCodeSal+"]--cctrCodeSal["+cctrCodeSal+"]--cctrCodeAr["+cctrCodeAr+"]");
					
					if(cctrCodeSal == null || cctrCodeSal.length() == 0)
					{
						cctrCodeSal = cctrCodeAr;
					}
					if(posType == null || posType.length() == 0)
					{
						posType = "H";
					}
					
					siteCode = (String) hdrMap.get("site_code");
				}
				
				System.out.println("PosType["+posType+"]");
				
				if("CRNRCP".equalsIgnoreCase(tranSer.trim()))
				{
					winName = "W_DRCRRCP_CR";
				}
				else if("DRNRCP".equalsIgnoreCase(tranSer.trim()))
				{
					winName = "W_DRCRRCP_CR";
				}
				
				sql = "select ledg_post_conf from transetup where upper(tran_window) = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,winName);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ledgPostConf = rs.getString(1);
				}
				else
				{
					errCode = "VTSEQ";
					return errCode;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				if("Y".equalsIgnoreCase(ledgPostConf))
				{
					sql = " update drcr_rcp set tran_date = ? where tran_id = ?" ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, tranDate);
					pstmt.setString(2,tranId);
					pstmt.executeUpdate();		

					if(rs != null)
					{
						rs.close();rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					
					hdrMap.put("tran_date", tranDate);
				}
				
				System.out.println("DetailCount-->"+dtlCount);
				if(dtlCount == 0)
				{
					//do
					//{
						invoiceIDHdr = (String) hdrMap.get("invoice_id");
						
						countRec = 0;
						sql = " select tran_type from sreturn where tran_id__crn = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranIDDrcrRcp);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							tranType = checkNullAndTrim(rs.getString("tran_type"));
							countRec++;
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();pstmt = null;
						}
						
						if(countRec > 0)
						{	
							sql = " select inv_type from invoice where invoice_id = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,invoiceIDHdr);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								invType = checkNullAndTrim(rs.getString("inv_type"));
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
						}
						
						sql = " select acct_code, cctr_code, sum(tax_amt), line_no, (case when sum(reco_amount) is null then 0 else sum(reco_amount) end) as reco_amount " 
							 +" from taxtran where tran_code = ? and tran_id = ? "
							 +" and tax_amt <> 0 and effect <> 'N' group by acct_code, cctr_code, line_no ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranSer);
						pstmt.setString(2,tranId);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							acctCode = rs.getString("acct_code");
							cctrCode = rs.getString("cctr_code");
							taxAmt = rs.getString("tax_amt");
							lineNo = rs.getString("line_no");
							recoAmt = rs.getDouble("reco_amount");
							
							System.out.println("@@acctCode ["+acctCode+"]");
							
							if(acctCode == null || acctCode.trim().length() == 0)
							{
								if("H".equalsIgnoreCase(posType))
								{
									//Need to verify below codew
									cctrCode = finCommon.getAcctDetrTtype(" ", itemSer, "SRET" , tranType, conn);
									//ls_acctcode = f_get_token(ls_cctrcode,'~t');
									
									if (cctrCode != null && cctrCode.trim().length() > 0) 
									{
										String tokens [] = cctrCode.split(",");
					
										if ( tokens.length >= 2)
										{
											acctCode = tokens[0];
											cctrCode = tokens[1];
										}
										else
										{
											acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
											cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
										}
									}
								}
								else if("D".equalsIgnoreCase(posType))
								{
									lineNo = lineNo.trim();
									
									sql = " select inv.item_code,i.item_ser from invoice_trace inv,item i "
										 +" where inv.invoice_id = ? and line_no = ? " 
										 +" and inv.item_code = i.item_code " ;
									pstmt1 = conn.prepareStatement(sql);
									pstmt1.setString(1,invoiceIDHdr);
									pstmt1.setString(2,lineNo);
									rs1 = pstmt1.executeQuery();
									if(rs1.next())
									{
										itemCode = rs.getString("item_code");
										itemSer = rs.getString("item_ser");
									}
									if(rs1 != null)
									{
										rs1.close();rs1 = null;
									}
									if(pstmt1 != null)
									{
										pstmt1.close();pstmt1 = null;
									}
									
									//Need to verify below code
									cctrCode = finCommon.getAcctDetrTtype(itemCode, itemSer, "SRET", tranType, conn);
									//ls_acctcode = f_get_token(ls_cctrcode,'~t')
									if (cctrCode != null && cctrCode.trim().length() > 0) 
									{
										String tokens [] = cctrCode.split(",");
					
										if ( tokens.length >= 2)
										{
											acctCode = tokens[0];
											cctrCode = tokens[1];
										}
										else
										{
											acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
											cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
										}
									}
								}
							}
							
							System.out.println("@@cctrCode ["+cctrCode+"]");
							
							if(cctrCode == null || cctrCode.trim().length() == 0)
							{
								cctrCode = cctrCodeSal;
							}	
								
							lsStr = "acct_code = '" + checkNull((acctCode)) + "' and cctr_code = '" + checkNull(cctrCode) + "'";
							lineNo = String.valueOf(findLineNofromDetail(acctCode, cctrCode ,detailList));
									
							if(Integer.parseInt(lineNo) == 0) 
							{
								//Need to verfiy below code
								//li_lineno = lds_det.insertrow(0);
								//amountTotal = amount;
								detMap = new HashMap();
								amountTotal = amount;
							}
							else
							{	
								//Need to verfiy below code
								//amountTotal = amount + lds_det.getitemnumber(li_lineno,"amount");
								detMap = (HashMap) detailList.get(Integer.valueOf(lineNo));
								amountTotal = amount + (Double) detMap.get("amount");
							}	
						
							detMap.put("tran_id", tranId);
							detMap.put("line_no", lineNo);
							detMap.put("acct_code", acctCode);
							detMap.put("cctr_code", cctrCode);
							detMap.put("amount", amountTotal - recoAmt);
							detMap.put("emp_code", "");
							detMap.put("anal_code", "");
							
							if(Integer.parseInt(lineNo) == 0) 
							{
								detailList.add(detMap);
							}
							else
							{
								detailList.set(Integer.parseInt(lineNo), detMap);
							}
							
							total = total + amount;
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();pstmt = null;
						}
						
						
							sql = " select line_no, acct_code__reco, cctr_code__reco, (case when sum(reco_amount) is null then 0 else sum(reco_amount) end) as reco_amount "
					             +" from taxtran where tran_code = ? "
								 +" and tran_id	= ?  and (case when reco_amount is null then 0 else reco_amount end ) <> 0 " 
								 +" and effect <> 'N' group by line_no,acct_code__reco, cctr_code__reco ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranSer);
							pstmt.setString(2,tranId);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								lineNo = rs.getString("line_no");
								acctReco = rs.getString("acct_code__reco");
								cctrReco = rs.getString("cctr_code__reco");
								recoAmount = rs.getDouble("reco_amount");
								
								System.out.println("@@acctReco ["+acctReco+"]");
								
								if(acctReco == null || acctReco.trim().length() == 0)
								{
									if("H".equalsIgnoreCase(posType))
									{
										//Need to verfiy below code
										acctReco = finCommon.getAcctDetrTtype(" ", itemSer, "TAXRECO", tranType, conn);
										//ls_acct_reco = f_get_token(ls_cctr_reco,'~t')
										
										if (acctReco != null && acctReco.trim().length() > 0) 
										{
											String tokens [] = acctReco.split(",");
											acctReco = tokens[0];
										}
									}
									else if("D".equalsIgnoreCase(posType))
									{
										lineNo = lineNo.trim();
										
										sql = " select inv.item_code,i.item_ser from invoice_trace inv,item i "
											 +" where inv.invoice_id = ? and line_no = ? " 
											 +" and inv.item_code = i.item_code " ;
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1,invoiceIDHdr);
										pstmt1.setString(2,lineNo);
										rs1 = pstmt1.executeQuery();
										if(rs1.next())
										{
											itemCode = rs.getString("item_code");
											itemSer = rs.getString("item_ser");
										}
										if(rs1 != null)
										{
											rs1.close();rs1 = null;
										}
										if(pstmt1 != null)
										{
											pstmt1.close();pstmt1 = null;
										}
										
										//Need to verify below code
										cctrReco = finCommon.getAcctDetrTtype(itemCode , itemSer, "TAXRECO", tranType, conn);
										//ls_acct_reco = f_get_token(ls_cctr_reco,'~t')
										
										if (cctrReco != null && cctrReco.trim().length() > 0) 
										{
											String tokens [] = cctrReco.split(",");
						
											if ( tokens.length >= 2)
											{
												acctReco = tokens[0];
												cctrReco = tokens[1];
											}
											else
											{
												acctReco = cctrReco.substring(0,cctrReco.indexOf(","));
												cctrReco = cctrReco.substring(cctrReco.indexOf(",") + 1);
											}
										}
									}
								}
								
								if(acctReco == null || acctReco.trim().length() == 0)
								{
									errCode = "VTACCTRECO";
									return errCode;
								}
								
								System.out.println("@@cctrReco["+cctrReco+"]");
								
								if(cctrReco == null || cctrReco.trim().length() == 0)
								{
									cctrReco = " ";
								}	
								
								taxRows = findLineNofromDetail(acctReco, cctrReco ,detailList);//Need to verify this code
								
								if(taxRows == 0)
								{
									//Need to verift below code
									detMap = new HashMap();
									detMap.put("tran_id",tranId);
									detMap.put("line_no",detailList.size()+1);//Need to verify what could be the line number here
									detMap.put("acct_code",acctReco);
									detMap.put("cctr_code",cctrReco);
									detMap.put("amount",recoAmt);
									detMap.put("emp_code","");
									detMap.put("anal_code","");
									detailList.add(detMap);
								}
								else if(taxRows > 0)
								{
									detMap = (HashMap) detailList.get(Integer.valueOf(taxRows));
									amount = (Double) detMap.get("amount");
									detMap.put("amount", amount + recoAmt);
									detailList.set(taxRows, detMap);
								}
								
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							
							if(errCode!= null && errCode.trim().length() > 0)
							{
								return errCode;
							}
						
							sql = " select d.item_code, sum(d.drcr_amt) as drcr_amt from drcr_rdet d, invoice i where d.invoice_id = i.invoice_id "
								+ " and d.tran_id = ? group by d.item_code ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranIDDrcrRcp);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								itemCode = rs.getString("item_code");
								amount = rs.getDouble("drcr_amt");
								
								if("H".equalsIgnoreCase(posType))
								{
									//Need to verify below code
									cctrCode = finCommon.getAcctDetrTtype(" " , itemSer, "SRET", tranType, conn);
									//ls_acctcode = f_get_token(ls_cctrcode,'~t')
									if (cctrCode != null && cctrCode.trim().length() > 0) 
									{
										String tokens [] = cctrCode.split(",");
					
										if ( tokens.length >= 2)
										{
											acctCode = tokens[0];
											cctrCode = tokens[1];
										}
										else
										{
											acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
											cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
										}
									}
								}
								else if("D".equalsIgnoreCase(posType))
								{
									lineNo = lineNo.trim();
									
									sql = " select inv.item_code,i.item_ser from invoice_trace inv,item i "
										 +" where inv.invoice_id = ? and line_no = ? " 
										 +" and inv.item_code = i.item_code " ;
									pstmt1 = conn.prepareStatement(sql);
									pstmt1.setString(1,invoiceIDHdr);
									pstmt1.setString(2,lineNo);
									rs1 = pstmt1.executeQuery();
									if(rs1.next())
									{
										itemCode = rs.getString("item_code");
										itemSer = rs.getString("item_ser");
									}
									if(rs1 != null)
									{
										rs1.close();rs1 = null;
									}
									if(pstmt1 != null)
									{
										pstmt1.close();pstmt1 = null;
									}
									
									//Need to verify below code
									cctrCode = finCommon.getAcctDetrTtype(itemCode ,itemSer ,"SRET", tranType, conn);
									//ls_acctcode = f_get_token(ls_cctrcode,'~t')
									if (cctrCode != null && cctrCode.trim().length() > 0) 
									{
										String tokens [] = cctrCode.split(",");
					
										if ( tokens.length >= 2)
										{
											acctCode = tokens[0];
											cctrCode = tokens[1];
										}
										else
										{
											acctCode = cctrCode.substring(0,cctrCode.indexOf(","));
											cctrCode = cctrCode.substring(cctrCode.indexOf(",") + 1);
										}
									}
								}
								
								System.out.println("@@@cctrCode ["+cctrCode+"]");
								
								if(cctrCode == null || cctrCode.trim().length() == 0)
								{
									cctrCode = cctrCodeSal;
								}	
									
								lsStr = "acct_code = '" + checkNull((acctCode)) + "' and cctr_code = '" + checkNull(cctrCode) + "'";
								lineNo = String.valueOf(findLineNofromDetail(acctCode, cctrCode ,detailList));
										
								if(Integer.parseInt(lineNo) == 0) 
								{
									//Need to verify below code
									//li_lineno = lds_det.insertrow(0);
									//amountTotal = amount;
									detMap = new HashMap();
									amountTotal = amount;
								}
								else
								{	
									//Need to verify
									//amountTotal = amount + lds_det.getitemnumber(li_lineno,"amount");
									detMap = (HashMap) detailList.get(Integer.valueOf(lineNo));
									amountTotal = amount + (Double) detMap.get("amount");
								}
								
								detMap.put("tran_id", tranId);
								detMap.put("line_no", lineNo);
								detMap.put("acct_code", acctCode);
								detMap.put("cctr_code", cctrCode);
								detMap.put("amount", amountTotal);
								detMap.put("emp_code", "");
								detMap.put("anal_code", "");
								
								System.out.println("LINE NUMBER IS["+lineNo+"]");
								if(Integer.parseInt(lineNo) == 0)
								{
									detailList.add(detMap);
								}
								else
								{
									detailList.set(Integer.parseInt(lineNo), detMap);
								}
								
								total = total + amount;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							
							roundAdj = (Double) hdrMap.get("round_adj");
							amountHdr = (Double) hdrMap.get("amount");
							exchRate = (Double) hdrMap.get("exch_rate");
							amountHdr1 = amountHdr;
							
							System.out.println("@roundAdj["+roundAdj+"]");
							
							if(roundAdj == 0)
							{
								amountHdr = (Double)hdrMap.get("amount");
								roundOff =  (String) hdrMap.get("rnd_off");
								
								amountHdr1 = amountHdr;
								System.out.println("@roundOff["+roundOff+"]");
								if(!"N".equals(roundOff))
								{
									roundTo = (Double)hdrMap.get("rnd_to");
									amountHdr = distCommon.getRndamt(amountHdr1, roundOff, roundTo);
								}
								
								System.out.println("@amountHdr["+amountHdr+"] amountHdr1["+amountHdr1+"]");
								if(amountHdr != amountHdr1)
								{
									updRowCnt = 0;
									sql = " update drcr_rcp set amount = ?, amount__bc = (? * ?), round_adj = (? - ?) where tran_id = ? " ;
									pstmt1 = conn.prepareStatement(sql);
									pstmt1.setDouble(1, amountHdr);
									pstmt1.setDouble(2, amountHdr);
									pstmt1.setDouble(3, exchRate);
									pstmt1.setDouble(4, amountHdr);
									pstmt1.setDouble(5, amountHdr1);
									pstmt1.setString(6, tranIDDrcrRcp);
									updRowCnt = pstmt1.executeUpdate();
									
									if(pstmt1!=null)
									{
										pstmt.close();pstmt= null;
									}
									
									if(updRowCnt != 1)
									{
										errCode = "DS000NR";
									}
									
									hdrMap.put("round_adj", amountHdr - amountHdr1);
									hdrMap.put("amount", amountHdr);
									hdrMap.put("amount__bc", amountHdr * exchRate);
								}
							}
							
							roundAdj = (Double) hdrMap.get("round_adj");
							
							System.out.println("@@roundAdj["+roundAdj+"]");
							
							if(roundAdj != 0)
							{
								acctRnd = checkNullAndTrim(finCommon.getFinparams("999999", "ROUND_ADJUST_ACCT", conn));
								cctrRnd = checkNullAndTrim(finCommon.getFinparams("999999", "ROUND_ADJUST_CCTR", conn));
								
								if(("NULLFOUND".equals(acctRnd) || acctRnd == null || acctRnd.length() == 0) || (("NULLFOUND".equals(cctrRnd) || cctrRnd == null || cctrRnd.length() == 0)))
								{
									errCode = "VSENVAR1";
									return errCode;
								}
								
								System.out.println("@@cctrRnd["+cctrRnd+"]");
								
								if(cctrRnd == null || cctrRnd.length() == 0 || "  ".equals(cctrRnd))
								{
									lineNo = String.valueOf(findLineNofromDetail(acctRnd, cctrRnd ,detailList));//Need to verify this code
									
									if(Integer.valueOf(lineNo) == 0)
									{
										//li_lineno = lds_det.insertrow(0);//NVO code
										lineNo = ""+detailList.size() + 1; //Need to verify this code
									}
								
									detMap.put("tran_id", tranId);
									detMap.put("line_no", lineNo);
									detMap.put("acct_code", acctRnd);
									detMap.put("cctr_code", cctrRnd);
									detMap.put("amount", roundAdj);
									detMap.put("emp_code", "");
									detMap.put("anal_code", "");
									
									detailList.set(Integer.valueOf(lineNo), detMap);
								}
							}
					//}
					//while(true);
					
					if(errCode != null && errCode.trim().length() > 0)
					{
						return errCode;
					}
					
					total = 0;
					dtlCount = detailList.size();
					
					System.out.println("@@dtlCount["+dtlCount+"]");
					for(int x = 0; x < dtlCount; x++)
					{
						detMap = (HashMap) detailList.get(x);
						amountDet = (Double) detMap.get("amount");
						
						System.out.println("amountDet["+amountDet+"]");
						
						total = total + amountDet;
					}
					
					amountHdr = (Double) hdrMap.get("amount");
					
					System.out.println("total["+total+"] amountHdr["+amountHdr+"] and  Math.abs["+ Math.abs(total - amountHdr)+"]");
					
					if(total != amountHdr && Math.abs(total - amountHdr) > 1 )
					{
						errCode = "VTPOST2";  
						return errCode;
					}
					
					custCode = (String) hdrMap.get("cust_code");
					//ll_adj_cnt = lds_adj.retrieve(ls_tranid)//Need to verify
					sql = " select tran_id,line_no,ref_ser,ref_no,ref_bal_amt,adj_amt,mrp_value__adj from drcr_rcpinv where tran_id= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDDrcrRcp);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						adjMap = new HashMap();
						adjMap.put("tran_id", rs.getString("tran_id"));
						adjMap.put("line_no", rs.getString("line_no"));
						adjMap.put("ref_ser", rs.getString("ref_ser"));
						adjMap.put("ref_no", rs.getString("ref_no"));
						adjMap.put("ref_bal_amt", rs.getDouble("ref_bal_amt"));
						adjMap.put("adj_amt", rs.getDouble("adj_amt"));
						adjMap.put("mrp_value__adj", rs.getString("mrp_value__adj"));
						
						adjList.add(adjMap);
					}
					if(rs != null)
					{
						rs.close();rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					
					adjCount = adjList.size();
					total = 0;
					
					System.out.println("drcr_rcpinv Count="+adjCount);
					
					for(int x = 0; x < adjCount; x++)
					{
						adjMap = (HashMap) adjList.get(x);
						
						refNo = (String) adjMap.get("ref_no");
						refSer = (String) adjMap.get("ref_ser");
						adjAmount = (Double) adjMap.get("adj_amt");
						
						total = total + adjAmount;
						
						sql = " select count(*) from receivables where cust_code = ? and tran_ser = ? and ref_no = ? " ;
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,custCode);
						pstmt1.setString(2,refSer);
						pstmt1.setString(3,refNo);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							countRcv = rs.getInt(1);
						}
						if(rs1 != null)
						{
							rs1.close();rs1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();pstmt1 = null;
						}
						
						if(countRcv == 0)
						{
							return errCode;//Need to verify
						}
						
						sql = " select (tot_amt - adj_amt) as amount ,tot_amt , adj_amt from receivables where cust_code = ? and tran_ser = ? and ref_no = ? " ;
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,custCode);
						pstmt1.setString(2,refSer);
						pstmt1.setString(3,refNo);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							amount = rs.getDouble("amount");
							totalAmountRec = rs.getDouble("tot_amt");
							adjAmountRec = rs.getDouble("adj_amt");
							
							if(Math.abs(adjAmountRec + adjAmount ) > Math.abs(totalAmountRec))
							{
								//Need to check this error code
								errCode = "The  tot_amt - adj_amt in receivables table should be more than or equal to the adj_amt in detail.";
								return errCode;
							}
						}
						if(rs1 != null)
						{
							rs1.close();rs1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();pstmt1 = null;
						}
					}
					
					amount = (Double)hdrMap.get("amount");
					
					System.out.println("@@@amount["+amount+"] total["+total+"]");
					
					if(amount < 0 && total <= 0)
					{
						if(Math.abs(amount) < Math.abs(total))
						{
							//Need to check this code how to return error code
							errCode = "The total of adj_amt in detail should not be more than the header net amount";
							return errCode;
						}
					}
					else
					{
						if(amount < total)
						{
							//Need to check this code how to return error code
							errCode = "The total of adj_amt in detail should not be more than the header net amount";
							return errCode;
						}
					}
				}
				else// records found then verify amount
				{
					total = 0;
					dtlCount = detailList.size();
					
					for(int x = 1; x< dtlCount; x++)
					{
						detMap = (HashMap) detailList.get(x);
						amountDet = (Double) detMap.get("amount");
						
						if(amountDet != 0)
						{
							total = total + amountDet;
						}
					}

					amountHdr = (Double)hdrMap.get("amount");
					if(total != amountHdr && Math.abs(total - amountHdr) > 1 )
					{
						errCode = "VTPOST2";
						return errCode;
					}
				}
				
				//errCode = gbf_post_drcr_rcp(lds_hdr.describe("datawindow.data"), lds_det.describe("datawindow.data"),ai_commit,lds_adj.describe("datawindow.data"))
				errCode = gbf_post_drcr_rcp(tranId, hdrMap, detailList, adjList, xtraParams, conn);
				
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbfRetrieveDrCrRcp==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		
		System.out.println("Returning errorCode from gbfRetrieveDrCrRcp ["+errCode+"]");
		return errCode;
	}
	
	private String gbf_post_drcr_rcp(String tranId, Map hdrMap,ArrayList detailList,ArrayList adjList, String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		String retString = "";
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today;
		//FinCommon finCommon = null;
		String sReturnNo = "",sretFullRetType = "",tranType = "",postOnline = "",refSerHdr = "",refId = "",invIbcaGen = "",
			   custCode = "",siteCode = "",siteCodeRcv = "",keyStr = "",linkType = "",acctCodepay = "",cctrCodePay = "",
			   acctCodeRcp = "",cctrCodeRcp = "",ibcaID = "",remarks = "",tranSer = "",loginSiteCode = "";

		Timestamp refDate = null,dueDate = null,custRefDate = null,gpDate = null;
		String currCode = "",acctCode = "",cctrCode = "",autoRcp = "",bankCode = "",recd = "",refType = "",
				crTerm = "",itemSer = "",salesPers = "",salesPers1 = "",salesPers2 = "",custRefNo = "",gpNo = "",chgUser = "",chgTerm = "",invoiceID = "";
		double exchRate = 0,discount = 0,taxAmount = 0,custRefAmount = 0,amountBc = 0;
		
		String finEntityFrom = "",finEntityTo = "";
		double amount = 0;
		boolean adjInvoice = false;
		Map keyStoreMap = null;
		
		try
		{
			System.out.println("Inside gbf_post_drcr_rcp....tranId["+tranId+"]");
			
			chgUser = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_user"))); 
			chgTerm = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_term"))); 
			loginSiteCode = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"))); 
			
			tranDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(tranDate);
			
			tranId = (String) hdrMap.get("tran_id");
			sReturnNo = (String) hdrMap.get("sreturn_no");
			refSerHdr = (String) hdrMap.get("tran_ser");
			invoiceID = (String) hdrMap.get("invoice_id");
			
			if(sReturnNo!= null && sReturnNo.trim().length() > 0)
			{
				sql = " update sreturn set tran_id__crn = ? where  tran_id = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				pstmt.setString(2,sReturnNo);
				pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			retString = gbf_post_drcr_rcphdr(tranId, hdrMap, detailList, xtraParams, conn);
			System.out.println("After gbfPostRcphdr---->["+retString+"]");
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			else
			{
				retString = gbf_post_drcr_rcpdet(tranId, hdrMap, detailList , xtraParams, conn);
				System.out.println("After gbfPostRcpdet---->["+retString+"]");
			}
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			else
			{
				retString = gbf_post_drcr_adjdet(tranId, hdrMap, adjList, xtraParams, conn);
				System.out.println("After gbf_post_drcr_adjdet---->["+retString+"]");
			}
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			
			adjInvoice = true;
			
			if(sReturnNo != null && sReturnNo.trim().length() > 0)
			{
				sretFullRetType = checkNullAndTrim(distCommon.getDisparams("999999","SRET_FULL_TRANTYPE",conn));
				
				System.out.println("sretFullRetType["+sretFullRetType+"]");
				if("NULLFOUND".equals(sretFullRetType) || sretFullRetType.length() > 0)
				{
					adjInvoice = true;
				}
				else
				{
					adjInvoice = false;
				}
				
				sql = " select tran_type from sreturn where tran_id = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,sReturnNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranType = rs.getString("tran_type");
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				
				System.out.println("adjInvoice["+adjInvoice+"]");
				if(adjInvoice)
				{
					retString = gbf_invoice_drcr_adj(tranId , xtraParams, conn);
					System.out.println("After gbf_invoice_drcr_adj---->["+retString+"]");
					if(retString != null && retString.trim().length() > 0)
					{
						return retString;
					}
				}
				
				postOnline = checkNullAndTrim(finCommon.getFinparams("999999", "POST_ON_LINE", conn));
				System.out.println("PostOnline["+postOnline+"]");
				
				if("Y".equals(postOnline))
				{
					retString = finCommon.checkGlTranDrCr(refSerHdr, tranId, conn);
				}
				
				System.out.println("After POST_ON_LINE retString["+retString+"] RunMode["+gs_run_mode+"]");
				
				if("I".equals(gs_run_mode) && (retString == null || retString.trim().length() == 0))
				{
					invIbcaGen = checkNullAndTrim(finCommon.getFinparams("999999","INV_IBCA_GEN",conn));
					System.out.println("INV_IBCA_GEN["+invIbcaGen+"]");
					
					if("NULLFOUND".equals(invIbcaGen))
					{
						invIbcaGen = "Y";
					}
					
					if("Y".equals(invIbcaGen))
					{
						custCode = (String) hdrMap.get("cust_code");
						siteCode = (String) hdrMap.get("site_code");
						
						sql = " select site_customer.site_code__rcp from site_customer "
							+ " where ( site_customer.site_code = ? ) and ( site_customer.cust_code = ? ) ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteCode);
						pstmt.setString(2,custCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteCodeRcv = checkNullAndTrim(rs.getString("site_code__rcp"));
						}
						if(pstmt != null)
						{
							pstmt.close();pstmt = null;
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}
						
						if(siteCodeRcv.length() == 0)
						{
							sql = " select site_code__rcp from customer where cust_code = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								siteCodeRcv = checkNullAndTrim(rs.getString("site_code__rcp"));
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
						}
						
						if(siteCodeRcv.length() == 0)
						{
							siteCodeRcv = siteCode ;
						}
						
						if(!siteCodeRcv.equals(siteCode) && !"I".equals(siteCodeRcv))
						{	
							sql = " select key_string from transetup where upper(tran_window) = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,"W_RCP_IBCA");
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								keyStr = checkNullAndTrim(rs.getString("key_string"));
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							
							sql = " select fin_entity from site where site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								finEntityFrom = rs.getString("fin_entity");
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							
							sql = " select fin_entity from site where site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCodeRcv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								finEntityTo = rs.getString("fin_entity");
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
							
							sql = " select link_type, acct_code__pay, cctr_code__pay, acct_code__rcp, cctr_code__rcp "
								 +" from ibca_rcp_ctrl where site_code__from = ? and site_code__to = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							pstmt.setString(2,siteCodeRcv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								linkType = rs.getString("link_type");
								acctCodepay = rs.getString("acct_code__pay");
								cctrCodePay = rs.getString("cctr_code__pay");
								acctCodeRcp = rs.getString("acct_code__rcp");
								cctrCodeRcp = rs.getString("cctr_code__rcp");
							}
							if(pstmt != null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs != null)
							{
								rs.close();rs = null;
							}
						
							//ibcaID = generateTranId("w_rcp_ibca", loginSiteCode, currDateStr, conn);
							String xmlValues = "";
							xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
							xmlValues = xmlValues + "<Header></Header>";
							xmlValues = xmlValues + "<Detail1>";
							xmlValues = xmlValues +	"<tran_id/>";
							xmlValues = xmlValues + "<site_code__from>" + siteCode + "</site_code__from>";
							xmlValues = xmlValues + "<site_code__to>" + siteCodeRcv + "</site_code__to>";
							xmlValues = xmlValues + "<tran_date>"+ currDateStr + "</tran_date>";
							xmlValues = xmlValues + "<link_type>"+linkType+"</link_type>";
							xmlValues = xmlValues + "</Detail1></Root>";
							TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
							ibcaID = tg.generateTranSeqID("R-IBCA", "tran_id", keyStr, conn);

							if("ERROR".equalsIgnoreCase(ibcaID))
							{
								retString = itmDBAccessLocal.getErrorString("", "VTTRANID", "", "",conn);
								return retString;
							}
							
							remarks = " Auto IBCA transfer of Dr/Cr Note of " + custCode;

							sql = " select ref_date, curr_code, exch_rate, cust_code, acct_code, "
							     +" cctr_code, due_date, (tot_amt - adj_amt) as amt , discount, tax_amt, auto_rcp, "
							     +" bank_code, recd, ref_type, cr_term, item_ser, sales_pers, "
							     +" sales_pers__1, sales_pers__2, tran_date,cust_ref_no,cust_ref_date,cust_ref_amt,gp_no,gp_date "
							     +" from receivables where tran_ser like '%RCP%' and  ref_no = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									System.out.println("Inside rs.Next()-----");
									
									refDate = rs.getTimestamp("ref_date");
									currCode = rs.getString("curr_code");
									exchRate = rs.getDouble("exch_rate");
									custCode = rs.getString("cust_code");
									acctCode = rs.getString("acct_code");
									cctrCode = rs.getString("cctr_code");
									dueDate = rs.getTimestamp("due_date");
									amount = rs.getDouble("amt");
									discount = rs.getDouble("discount");
									taxAmount = rs.getDouble("tax_amt");
									autoRcp = rs.getString("auto_rcp");
									bankCode = rs.getString("bank_code");
									recd = rs.getString("recd");
									refType = rs.getString("ref_type");
									crTerm = rs.getString("cr_term");
									itemSer = rs.getString("item_ser");
									salesPers = rs.getString("sales_pers");
									salesPers1 = rs.getString("sales_pers__1");
									salesPers2 = rs.getString("sales_pers__2");
									tranDate = rs.getTimestamp("tran_date");
									custRefNo = rs.getString("cust_ref_no");
									custRefDate = rs.getTimestamp("cust_ref_date");
									custRefAmount = rs.getDouble("cust_ref_amt");
									gpNo = rs.getString("gp_no");
									gpDate = rs.getTimestamp("gp_date");
								}
								if(pstmt != null)
								{
									pstmt.close();pstmt = null;
								}
								if(rs != null)
								{
									rs.close();rs = null;
								}
								
								if(amount < 0)
								{
									tranSer = "CRNRCP";
								}
								else
								{
									tranSer = "CRNRCP";
								}
								
								System.out.println("amount["+amount+"] * exchRate["+exchRate+"]* ");
								
								amountBc = amount * exchRate ;
								
								System.out.println("amountBc--["+amountBc+"]");
								if(amountBc != 0)
								{
									sql = " insert into rcp_ibca (tran_id, tran_date, eff_date, site_code__from, fin_entity__from, "
										 +" site_code__to, fin_entity__to, amount, curr_code, exch_rate, confirmed, acct_code__ifr," 
										 +" cctr_code__ifr, acct_code__ito, cctr_code__ito, chg_date, chg_user, chg_term, amount__bc, "
										 +" tran_type, tran_ser, link_type, remarks) " //23
										 +" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, ibcaID);
									pstmt.setTimestamp(2, tranDate);
									pstmt.setTimestamp(3, tranDate);
									pstmt.setString(4, siteCode);
									pstmt.setString(5, finEntityFrom);
									pstmt.setString(6, siteCodeRcv);
									pstmt.setString(7, finEntityTo);
									pstmt.setDouble(8, amount);
									pstmt.setString(9, currCode);
									pstmt.setDouble(10, exchRate);
									pstmt.setString(11, "N");
									pstmt.setString(12, acctCodepay);
									pstmt.setString(13, cctrCodePay);
									pstmt.setString(14, acctCodeRcp);
									pstmt.setString(15, cctrCodeRcp);
									pstmt.setTimestamp(16, tranDate);
									pstmt.setString(17, chgUser);
									pstmt.setString(18, chgTerm);
									pstmt.setDouble(19, amountBc);
									pstmt.setString(20, tranType);
									pstmt.setString(21, "I");
									pstmt.setString(22, linkType);
									pstmt.setString(23, remarks);
									pstmt.executeUpdate();
									
									sql = " insert into rcp_ibca_det (tran_id, ref_ser, ref_no, ref_date, curr_code, exch_rate, "
										 +" cust_code, acct_code, cctr_code, due_date, tot_amt, discount,tax_amt, bank_code, "
										 +" ref_type, auto_rcp, sales_pers, item_ser, sales_pers__1, sales_pers__2, cr_term, "
										 +" recd, ref_ser__org, line_no__ref, cust_ref_no, cust_ref_date, cust_ref_amt, gp_no, gp_date) " //29
										 +" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, ibcaID);
									pstmt.setString(2, refSerHdr);
									pstmt.setString(3, tranId);
									pstmt.setTimestamp(4, refDate);
									pstmt.setString(5, currCode);
									pstmt.setDouble(6, exchRate);
									pstmt.setString(7, custCode);
									pstmt.setString(8, acctCode);
									pstmt.setString(9, cctrCode);
									pstmt.setTimestamp(10, dueDate);
									pstmt.setDouble(11, amount);
									pstmt.setDouble(12, discount);
									pstmt.setDouble(13, taxAmount);
									pstmt.setString(14, bankCode);
									pstmt.setString(15, refType);
									pstmt.setString(16, autoRcp);
									pstmt.setString(17, salesPers);
									pstmt.setString(18, itemSer);
									pstmt.setString(19, salesPers1);
									pstmt.setString(20, salesPers2);
									pstmt.setString(21, crTerm);
									pstmt.setString(22, recd);
									pstmt.setString(23, tranSer);
									pstmt.setString(24, "1");
									pstmt.setString(25, custRefNo);
									pstmt.setTimestamp(26, custRefDate);
									pstmt.setDouble(27, custRefAmount);
									pstmt.setString(28, gpNo);
									pstmt.setTimestamp(29, gpDate);
									pstmt.executeUpdate();

									//ls_errcode = nvo_rcpibca.gbf_retrieve_ribca(ls_ibca_id, ls_ibca_id, 1,ls_site)
									retString = gbf_retrieve_ribca(ibcaID, siteCode, xtraParams, conn);
									
									//RcvIbcaConf ibcaObj = new RcvIbcaConf();
									//retString = ibcaObj.confirm(ibcaID, xtraParams, "", conn);
									
									System.out.println("After gbf_retrieve_ribca ----->["+retString+"]");
									
									if(retString != null && retString.trim().length() > 0)
									{
										return retString;
									}
								}
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_rcp==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	private String gbf_post_drcr_rcphdr(String tranId, Map hdrMap,ArrayList detailList, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today = null;
		//FinCommon finCommon = null;
		
		int ediOption = 0;
		double mrpValue = 0;
		String invoiceIDHdr = "", tranIDDrcrRcp = "",tranSer = "",winName = "",ledgPostConf = "",errCode = "",acctCode = "",cctrCode= "",
				posType = "",itemSer = "",acctCodeSal = "",cctrCodeSal = "",cctrCodeAr = "",acctReco = "",cctrReco = "",acctRnd = "",cctrRnd = "",
				tranType = "",invType = "",lineNo = "",taxAmt = "",itemCode = "",lsStr = "",custCode = "",refNo = "",refSer = "",drcrFalg = "";
		String temp = "",analysis = "",analysis1 = "",analysis2 = "",analysis3 = "",contactCode = "",salesPers = "",salesReturnNo = "",
				partyDocPref = "",confirmed = "",empCodeAprv = "",dataStr = "";
		
		Map glTraceMap = null; 
		Map sundryBalMap = null;
		Map receivablesMap = null;
		
		try
		{
			System.out.println("Inside gbf_post_drcr_rcphdr...tranId["+tranId+"]");
			
			//finCommon = new FinCommon();
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");
			
			tranSer = (String) hdrMap.get("tran_ser");
			tranId = (String) hdrMap.get("tran_id");
			tranType = (String) hdrMap.get("tran_type");
			
			if("CRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_cr";
			}
			else if("DRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_dr";
			}
			
		
			/*// Not to migrate following methods as per manohar sir suggetion
			ls_errcode = gbf_ud_accountposting(ls_winname, ls_transer, '', 4 , &
			 lds_hdr.describe("datawindow.syntax") &
			 + '~r' + lds_hdr.describe("datawindow.syntax.data"), &
			 lds_det.describe("datawindow.syntax") + &
			 '~r' + lds_det.describe("datawindow.syntax.data"), &
			lds_deta.describe("datawindow.syntax") + &
			 '~r' + lds_deta.describe("datawindow.syntax.data"), & 
			 lds_adj.describe("datawindow.syntax") + &
			 '~r' + lds_adj.describe("datawindow.syntax.data"), '', '', '')					 							 
			 
			 ls_acctmethod = f_get_token(ls_errcode,',')	*/			
			
			
			drcrFalg = (String) hdrMap.get("drcr_flag");
			
			System.out.println("DRCR Flag inside gbf_post_drcr_rcphdr["+drcrFalg+"]");
			
			if("D".equalsIgnoreCase(drcrFalg))
			{
				analysis = invacct.AcctAnalysisType(" ", tranSer, tranType, "DR", conn);
				temp = "DR" + analysis; 
				sql = " SELECT "+temp+" from dual ";
			}
			else
			{
				analysis = invacct.AcctAnalysisType(" ", tranSer, tranType, "CR", conn);
				temp = "CR" + analysis; 
				sql = " SELECT "+temp+" from dual ";
			}
			
			if(analysis !=null && analysis.trim().length() > 0)
			{
				String token[] = analysis.split(",");
				
				if(token.length >= 3)
				{
					analysis1 = token[0];
					analysis2 = token[1];
					analysis3 = token[2];
				}
			}
		
			//GL Trace Map started
			glTraceMap = new HashMap();
			glTraceMap.put("analysis1", analysis1);
			glTraceMap.put("analysis2", analysis2);
			glTraceMap.put("analysis3", analysis3);
			glTraceMap.put("tran_date", (Timestamp) hdrMap.get("tran_date"));
			glTraceMap.put("eff_date",  (Timestamp) hdrMap.get("eff_date"));
			glTraceMap.put("fin_entity",hdrMap.get("fin_entity"));
			glTraceMap.put("site_code", hdrMap.get("site_code"));
			glTraceMap.put("sundry_type", "C");
			glTraceMap.put("sundry_code", hdrMap.get("cust_code"));
			glTraceMap.put("cust_code", hdrMap.get("cust_code"));
			glTraceMap.put("acct_code", hdrMap.get("acct_code"));
			glTraceMap.put("cctr_code", hdrMap.get("cctr_code"));
			glTraceMap.put("emp_code", "");
			glTraceMap.put("anal_code", hdrMap.get("anal_code"));
			glTraceMap.put("curr_code", hdrMap.get("curr_code"));
			glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
			
			if("D".equals(drcrFalg))
			{
				glTraceMap.put("dr_amt", hdrMap.get("amount"));
				glTraceMap.put("cr_amt", "0");
			}
			else
			{
				glTraceMap.put("cr_amt", hdrMap.get("amount"));
				glTraceMap.put("dr_amt", "0");
			}
			
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser", hdrMap.get("tran_ser"));
			glTraceMap.put("ref_id", hdrMap.get("tran_id"));
			glTraceMap.put("remarks", hdrMap.get("remarks"));
			
			refSer = (String) glTraceMap.get("ref_ser");
			refNo  = (String) glTraceMap.get("ref_id");
			
			System.out.println("RefSer["+refSer+"] and RefNo["+refNo+"]");
			
			partyDocPref = finCommon.gfGetPartyDocRef(refSer, refNo, conn);
			glTraceMap.put("party_doc_ref", partyDocPref);
			
			errString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
			
			System.out.println("After glTraceUpdate--->["+errString+"]");
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			//Sundry Balance Map started
			sundryBalMap = new HashMap();
			sundryBalMap.put("tran_date", (Timestamp) hdrMap.get("tran_date"));
			sundryBalMap.put("eff_date",  (Timestamp) hdrMap.get("eff_date"));
			sundryBalMap.put("fin_entity",hdrMap.get("fin_entity"));
			sundryBalMap.put("site_code", hdrMap.get("site_code"));
			sundryBalMap.put("sundry_type", glTraceMap.get("sundry_type"));
			sundryBalMap.put("sundry_code", hdrMap.get("cust_code"));
			sundryBalMap.put("acct_code", hdrMap.get("acct_code"));
			sundryBalMap.put("cctr_code", hdrMap.get("cctr_code"));
			sundryBalMap.put("curr_code", hdrMap.get("curr_code"));
			sundryBalMap.put("exch_rate", hdrMap.get("exch_rate"));
			
			if("D".equals(drcrFalg))
			{
				sundryBalMap.put("dr_amt", (Double)hdrMap.get("amount"));
				sundryBalMap.put("cr_amt", 0.0);
			}
			else
			{
				sundryBalMap.put("cr_amt", (Double)hdrMap.get("amount"));
				sundryBalMap.put("dr_amt", 0.0);
			}
			sundryBalMap.put("adv_amt", 0.0);
			
			sql = " select contact_code from customer where cust_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, (String)sundryBalMap.get("sundry_code"));
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				contactCode = rs.getString("contact_code");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			sundryBalMap.put("contact_code",contactCode );
			
			errString = finCommon.gbf_sundrybal_upd((HashMap) sundryBalMap,conn);
			System.out.println("After gbf_sundrybal_upd--->["+errString+"]");
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			//Recievables Map started
			receivablesMap = new HashMap();
			receivablesMap.put("tran_ser",  hdrMap.get("tran_ser"));
			receivablesMap.put("tran_date",  (Timestamp) hdrMap.get("tran_date"));
			receivablesMap.put("fin_entity",  hdrMap.get("fin_entity"));
			receivablesMap.put("site_code",  hdrMap.get("site_code"));
			receivablesMap.put("ref_no",  (String) hdrMap.get("tran_id"));
			receivablesMap.put("due_date",  (Timestamp) hdrMap.get("due_date"));
			receivablesMap.put("eff_date",  (Timestamp) hdrMap.get("eff_date"));
			receivablesMap.put("curr_code",  hdrMap.get("curr_code"));
			receivablesMap.put("exch_rate",  hdrMap.get("exch_rate"));
			receivablesMap.put("cust_code",  hdrMap.get("cust_code"));
			receivablesMap.put("acct_code",  hdrMap.get("acct_code"));
			receivablesMap.put("cctr_code",  hdrMap.get("cctr_code"));
			receivablesMap.put("tax_amt",  "0");
			receivablesMap.put("discount",  "0");
			
			if("D".equals(drcrFalg))
			{
				receivablesMap.put("tot_amt", (Double) hdrMap.get("amount"));
			}
			else
			{
				receivablesMap.put("tot_amt", 0 - (Double) hdrMap.get("amount"));
			}
			receivablesMap.put("auto_rcp", "N");
			receivablesMap.put("bank_code", "");
			receivablesMap.put("ref_type", hdrMap.get("tran_type"));
			receivablesMap.put("cr_term", hdrMap.get("cr_term"));
			invoiceIDHdr = (String) hdrMap.get("invoice_id");
			
			sql = " select sales_pers, item_ser from invoice where invoice_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,invoiceIDHdr);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				salesPers = rs.getString("sales_pers");
				itemSer = rs.getString("item_ser");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			receivablesMap.put("cust_ref_no", hdrMap.get("cust_ref_no"));
			receivablesMap.put("cust_ref_date", hdrMap.get("cust_ref_date"));
			receivablesMap.put("cust_ref_amt", String.valueOf((Double) hdrMap.get("cust_ref_amt")));
			receivablesMap.put("gp_no", hdrMap.get("gp_no"));
			receivablesMap.put("gp_date", (Timestamp) hdrMap.get("gp_date"));
			salesReturnNo =  (String) hdrMap.get("sreturn_no");
			
			if(salesReturnNo != null && salesReturnNo.length() > 0)
			{
				sql = " select sum(case when mrp_value is null then 0 else mrp_value end) as mrp_value from sreturndet where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,salesReturnNo);
				rs= pstmt.executeQuery();
				if(rs.next())
				{
					mrpValue = rs.getDouble("mrp_value");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			receivablesMap.put("mrp_value", (double) mrpValue);
			
			errString = finCommon.gbfReceivablesUpd((HashMap) receivablesMap,conn);
			System.out.println("After gbfReceivablesUpd--->["+errString+"]");
			
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			confirmed = (String) hdrMap.get("confirmed");
			if(!"Y".equals(confirmed))
			{
				sql = "update drcr_rcp set confirmed = 'Y', conf_date = ? ,emp_code__aprv = ? where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, tranDate);
				pstmt.setString(2, empCodeAprv);
				pstmt.setString(3, (String) glTraceMap.get("ref_id"));
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt=null;
				}
			}
			
			tranSer = (String) hdrMap.get("tran_ser");
			
			if("CRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_cr";
			}
			else if("DRNRCP".equals(tranSer))
			{
				winName = "w_drcrrcp_dr";
			}
				
			sql = "select edi_option from transetup where tran_window = ?";	
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,winName);	
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ediOption = rs.getInt(1);
			}
			if(rs!=null)
			{
				rs.close();rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt=null;
			}

			if(ediOption > 0)
			{
				hdrMap.put("confirmed", "Y");
				hdrMap.put("conf_date", tranDate);
				hdrMap.put("emp_code__aprv", empCodeAprv);
			}
			
			//Need to check NVO code for edit option 2
			if(ediOption == 2)
			{
				CreateRCPXML createRCPXML = new CreateRCPXML(winName, "tran_id");
                dataStr = createRCPXML.getTranXML(tranId, conn);
                System.out.println("dataStr =[ " + dataStr + "]");
                Document ediDataDom = genericUtility.parseString(dataStr);

                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
                errString = e12CreateBatchLoad.createBatchLoad(ediDataDom, winName , "2", xtraParams, conn);
                createRCPXML = null;
                e12CreateBatchLoad = null;
                
                System.out.println("retString from edi 2 batchload gbf_post_drcr_rcphdr--->[" + errString + "]");
                
                //if (errString != null && "SUCCESS".equalsIgnoreCase(errString)) 
                if (errString != null && errString.indexOf("SUCCESS") != -1) 
				{
                	errString = "";
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_rcphdr==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();pstmt1 = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	
	private String gbf_post_drcr_rcpdet(String tranId, Map hdrMap,ArrayList detailList, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "",sql1 = "";
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		java.sql.Timestamp tranDate = null, today = null;
		//FinCommon finCommon = null;
		Map detMap = null;
		Map glTraceMap = null;
		
		String invoiceIDHdr = "", tranIDDrcrRcp = "",tranSer = "",winName = "",ledgPostConf = "",errCode = "",acctCode = "",cctrCode= "",
				posType = "",itemSer = "",acctCodeSal = "",cctrCodeSal = "",cctrCodeAr = "",acctReco = "",cctrReco = "",acctRnd = "",cctrRnd = "",
				tranType = "",invType = "",lineNo = "",taxAmt = "",itemCode = "",lsStr = "",custCode = "",refNo = "",refSer = "",drcrFalg = "";
		String temp = "",analysis = "",analysis1 = "",analysis2 = "",analysis3 = "",contactCode = "",salesPers = "",salesReturnNo = "",
				partyDocPref = "",confirmed = "",empCodeAprv = "",siteCode = "",siteCodeFor = "",projectCode = "",currCode = "",remarks = "";
		String finEntity = "";
		double exchRate = 0;
		Date effDate = null;
		
		try
		{
			System.out.println("Inside gbf_post_drcr_rcpdet detailList size-->"+detailList.size());
			
			drcrFalg = (String)hdrMap.get("drcr_flag");
			tranDate = (Timestamp)hdrMap.get("tran_date");
			effDate = (Date)hdrMap.get("eff_date");
			finEntity = (String) hdrMap.get("fin_entity");
			siteCode = (String)hdrMap.get("site_code");
			siteCodeFor = (String)hdrMap.get("site_code__for");
			projectCode = (String)hdrMap.get("proj_code");
			currCode = (String)hdrMap.get("curr_code");
			exchRate = (Double) hdrMap.get("exch_rate");
			remarks = (String)hdrMap.get("remarks");
			
			for (int ctr =0; ctr < detailList.size(); ctr++)
			{
				detMap = (HashMap) detailList.get(ctr);
				System.out.println(" DetMap ctr [" + ctr + "] ["+detMap + "]");
				
				itemCode = checkNull((String)detMap.get("item_code"));
				tranSer = (String)hdrMap.get("tran_ser");
				tranType = (String)hdrMap.get("tran_type");
				
				if("D".equalsIgnoreCase(drcrFalg))
				{
					analysis = invacct.AcctAnalysisType(itemCode, tranSer, tranType, "DR", conn);
					temp = "DR" + analysis; 
					sql = " SELECT "+temp+" from dual ";
				}
				else
				{
					analysis = invacct.AcctAnalysisType(itemCode, tranSer, tranType, "CR", conn);
					temp = "CR" + analysis; 
					sql = " SELECT "+temp+" from dual ";
				}
				
				if(analysis !=null && analysis.trim().length() > 0)
				{
					String token[] = analysis.split(",");
					
					if(token.length >= 3)
					{
						analysis1 = token[0];
						analysis2 = token[1];
						analysis3 = token[2];
					}
				}
				
				
				glTraceMap = new HashMap();
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type","O");
				glTraceMap.put("sundry_code"," ");
				glTraceMap.put("acct_code", (String)detMap.get("acct_code"));
				glTraceMap.put("cctr_code", (String)detMap.get("cctr_code"));
				glTraceMap.put("emp_code", (String)detMap.get("emp_code"));
				glTraceMap.put("anal_code", (String)detMap.get("anal_code"));
				glTraceMap.put("curr_code", (String)hdrMap.get("curr_code"));
				glTraceMap.put("exch_rate", (Double)hdrMap.get("exch_rate"));
				
				if("D".equals(drcrFalg))
				{
					if((Double)detMap.get("amount") > 0)
					{
						glTraceMap.put("cr_amt", (Double) detMap.get("amount"));
						glTraceMap.put("dr_amt", "0");
					}
					else
					{
						glTraceMap.put("dr_amt", 0 - (Double)detMap.get("amount"));
						glTraceMap.put("cr_amt", "0");
					}
				}
				else
				{
					if((Double)detMap.get("amount") > 0)
					{
						glTraceMap.put("dr_amt", (Double) detMap.get("amount"));
						glTraceMap.put("cr_amt", "0");
					}
					else
					{
						glTraceMap.put("cr_amt", 0 - (Double)detMap.get("amount"));
						glTraceMap.put("dr_amt", "0");
					}
				}
				
				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("ref_ser", tranSer);
				glTraceMap.put("remarks", remarks);
				
				System.out.println("refSer["+tranSer+"] tranId["+tranId+"]");
				
				partyDocPref = finCommon.gfGetPartyDocRef(tranSer, tranId, conn);
				glTraceMap.put("party_doc_ref", partyDocPref);
				
				errString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
				System.out.println("After glTraceUpdate---->["+errString+"]");
				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_rcpdet==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	
	private String gbf_post_drcr_adjdet(String tranId, Map hdrMap, ArrayList detailList, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map detMap = null;
	
		String refSer = "",refNo = "", refSerHdr = "";

		double totAdjAmount = 0,amount = 0,adjAmt = 0,totalAmount = 0;
	
		try
		{
			System.out.println("Inside gbf_post_drcr_adjdet detailList size-->"+detailList.size());
			
			tranId = (String)hdrMap.get("tran_id");
			refSerHdr = (String)hdrMap.get("tran_ser");
			
			for (int ctr =0; ctr < detailList.size(); ctr++)
			{
				detMap = (HashMap) detailList.get(ctr);
				
				refSer = checkNull((String)detMap.get("ref_ser"));
				refNo = (String)detMap.get("ref_no");
				amount = (Double) detMap.get("adj_amt");
				totAdjAmount += amount;
				
				sql = "update receivables set adj_amt = (case when adj_amt is null then 0 else adj_amt end + ? ) where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,amount);
				pstmt.setString(2,refSer);
				pstmt.setString(3,refNo);
				pstmt.executeUpdate();
				
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " select adj_amt, tot_amt from receivables where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					adjAmt = rs.getDouble("adj_amt");
					totalAmount = rs.getDouble("tot_amt");
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				if(adjAmt > totalAmount)
				{
					sql = "update receivables set status = ? where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"A");
					pstmt.setString(2,refSer);
					pstmt.setString(3,refNo);
					pstmt.executeUpdate();
					
					if(pstmt!=null)
					{	
						pstmt.close();pstmt = null;
					}
				}
				
				sql = " update receivables set adj_amt = (case when adj_amt is null then 0 else adj_amt end + (-1 * ?) ) where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,amount);
				pstmt.setString(2,refSerHdr);
				pstmt.setString(3,tranId);
				pstmt.executeUpdate();
				
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}

				sql = " select adj_amt, tot_amt from receivables where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSerHdr);
				pstmt.setString(2,tranId);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					adjAmt = rs.getDouble("adj_amt");
					totalAmount = rs.getDouble("tot_amt");
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				if(adjAmt == totalAmount)
				{
					sql = "update receivables set status = ? where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"A");
					pstmt.setString(2,refSerHdr);
					pstmt.setString(3,tranId);
					pstmt.executeUpdate();
					
					if(pstmt!=null)
					{	
						pstmt.close();pstmt = null;
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside gbf_post_drcr_adjdet==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	
	public String gbf_invoice_drcr_adj(String tranIDDrCr ,String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null,pstmt1= null;
		ResultSet rs = null;
		String keyStr = "", adjTranSer = "",invoiceID = "",tranSer = "",siteCode = "",adjRecv = "",postOnline = "",
			   refType = "",adjRefNo = "",refNo = "",nextID = "",status = "",tranID = "";
		int cnt = 0;
		Timestamp tranDate = null,currDate = null;
		double totAmount = 0,adjAmount = 0,diffAmount = 0,netAmount = 0,allInvTot = 0,allInvAdj = 0,invTot = 0, invAdj = 0,
				pendAmount = 0,crAmount = 0;
		ArrayList invoiceIDList = new ArrayList();
		ArrayList netAmountList = new ArrayList();
		
		try
		{
			System.out.println("Inside gbf_invoice_drcr_adj...tranIDDrCr["+tranIDDrCr+"]");
			
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			
			adjTranSer = "S-INV";
			sql = " select invoice_id, tran_ser, site_code, adj_recv from drcr_rcp where tran_id = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranIDDrCr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt++;
				invoiceID = rs.getString("invoice_id");
				tranSer = rs.getString("tran_ser");
				siteCode = rs.getString("site_code");
				adjRecv = rs.getString("adj_recv");
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			
			if(cnt > 0)
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			if(adjRecv == null)
			{
				adjRecv = "N";
			}
			if(!("C".equals(adjRecv) || "D".equals(adjRecv) || "B".equals(adjRecv) || !"N".equals(adjRecv)))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			if("DRNRCP".equals(tranSer) && "C".equals(adjRecv))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			else if("CRNRCP".equals(tranSer) && "D".equals(adjRecv))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			cnt = 0;
			sql = " select invoice_id, tran_date, inv_type from invoice where invoice_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt++;
				adjRefNo = rs.getString("invoice_id");
				tranDate = rs.getTimestamp("tran_date");
				refType = rs.getString("inv_type");
			}
			if(rs!=null)
			{
				rs.close();rs= null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			
			if(cnt > 0)
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			else if("FN".equals(refType))
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			cnt = 0;
			sql = " select key_string from transetup where upper(tran_window) = ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"W_REC_ADJ");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt++;
				keyStr = checkNullAndTrim(rs.getString("key_string"));
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			
			if(cnt > 0)
			{
				sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDDrCr);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
			}
			else
			{
				sql = " select key_str from transetup where upper(tran_window) = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,"GENERAL");
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					keyStr = checkNullAndTrim(rs.getString("key_str"));
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				
				if(cnt > 0)
				{
					sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranIDDrCr);
					pstmt.executeUpdate();
					if(pstmt!=null)
					{
						pstmt.close();pstmt = null;
					}
				}
			}
			
			sql = " select tran_id, tran_ser, ref_no, tot_amt, adj_amt from receivables "
				+ " where ((tran_ser = ? ) and (tot_amt - adj_amt) <> 0) and ref_no = ? and line_no__ref = '1' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranSer);
			pstmt.setString(2,tranIDDrCr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranID = rs.getString("tran_id");
				tranSer = rs.getString("tran_ser");
				refNo = rs.getString("ref_no");
				totAmount = rs.getDouble("tot_amt");
				adjAmount = rs.getDouble("adj_amt");
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			diffAmount = totAmount - adjAmount;
			
			sql = " select invoice_id, sum(net_amt) as net_amt from drcr_rdet where tran_id = ? group by invoice_id ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIDDrCr);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				invoiceID = rs.getString("invoice_id");
				netAmount = rs.getDouble("net_amt");
				
				invoiceIDList.add(invoiceID);
				netAmountList.add(netAmount);
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			
			
			for(int i = 0; i < invoiceIDList.size(); i++)
			{
				invoiceID = (String) invoiceIDList.get(i);
				adjRefNo = invoiceID;
				diffAmount = (Double) netAmountList.get(i);
				
				if("CRNRCP".equals(tranSer) || "R-ADV".equals(tranSer))
				{
					diffAmount = diffAmount * -1;
				}
				allInvTot = 0;
				allInvAdj = 0;
				invTot = 0;
				invAdj = 0;
				
				sql = " select  tot_amt, adj_amt from receivables where tran_ser = ? and ref_no = ? and (tot_amt - adj_amt) <> 0 ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranSer);
				pstmt.setString(2,invoiceID);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					System.out.println("Inside receivables for refNo ["+invoiceID+"] ");
					
					invTot = rs.getDouble("tot_amt");
					invAdj = rs.getDouble("adj_amt");
					
					allInvTot = allInvTot + invTot;
					allInvAdj = allInvAdj + invAdj;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				
				System.out.println("allInvTot["+allInvTot+"] allInvAdj["+allInvAdj+"] diffAmount["+diffAmount+"] invTot["+invTot+"] invAdj["+invAdj+"]");
				 
				if(allInvTot == 0 && allInvAdj == 0)
				{
					return retString;
				}		
				if((invTot - (invAdj - diffAmount)) < 0 ) 
				{
					return retString;		
				}
				
				if((allInvTot - (allInvAdj - diffAmount)) < 0 )
				{
					sql = " update drcr_rcp set adj_recv = 'N' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranIDDrCr);
					pstmt.executeUpdate();
					if(pstmt!=null)
					{
						pstmt.close();pstmt = null;
					}
				}
				
				 nextID = generateTranId( "w_rec_adj", siteCode, currDateStr, conn);
				 
				 sql = " insert into receivables_adj (tran_id, ref_ser, ref_no, tot_amt, adj_amt, net_amt,ref_ser_adj,ref_no_adj, tran_id__rcv) "
					 	 + " values(?, ?, ?, ?, ?, ?, ?, ?, ?) ";
				 pstmt = conn.prepareStatement(sql);
				 pstmt.setString(1, nextID);
				 pstmt.setString(2, tranSer);
				 pstmt.setString(3, refNo);
				 pstmt.setDouble(4, diffAmount);
				 pstmt.setDouble(5, diffAmount);
				 pstmt.setDouble(6, 0);
				 pstmt.setString(7, adjTranSer);
				 pstmt.setString(8, adjRefNo);
				 pstmt.setString(9, tranID);
				 pstmt.executeUpdate();
				 
				 if(pstmt!=null)
				 {
					 pstmt.close();pstmt= null;
				 }
				 
				 if(i == 0)
				 {
					sql = " update receivables set adj_amt = tot_amt, status = 'A'  where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranID);
					pstmt.executeUpdate();
					if(pstmt!=null)
					{
						pstmt.close();pstmt = null;
					}
				 }
				 
				cnt = 0; 
			    sql = " select  tot_amt, adj_amt from receivables where tran_ser = ? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranSer);
				pstmt.setString(2,invoiceID);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					cnt++;
					invTot = rs.getDouble("tot_amt");
					invAdj = rs.getDouble("adj_amt");
					
					if(invTot == invAdj && (!"DRNRCP".equals(tranSer) || !"MDRCRD".equals(tranSer)))
					{
						continue;
					}
					
					if("CRNRCP".equals(tranSer) || "MDRCRC".equals(tranSer) || "R-ADV".equals(tranSer))
					{
						pendAmount = invTot - invAdj;
						crAmount = diffAmount;
						diffAmount = diffAmount + pendAmount;
						
						if(diffAmount <= 0)
						{
							status = "A";
							sql = " update receivables set adj_amt = adj_amt + ?, status = ?  where tran_ser = ? and tran_id = ? and line_no__ref = ? ";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setDouble(1, pendAmount);
							pstmt1.setString(2, status);
							pstmt1.setString(3, adjTranSer);
							pstmt1.setString(4, invoiceID);
							pstmt1.setString(5, ""+cnt);
							pstmt1.executeUpdate();
							if(pstmt1!=null)
							{
								pstmt1.close();pstmt1 = null;
							}
						}
						else
						{
							status = "U";
							sql = " update receivables set adj_amt = adj_amt - ?, status = ?  where tran_ser = ? and tran_id = ? and line_no__ref = ? ";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setDouble(1, crAmount);
							pstmt1.setString(2, status);
							pstmt1.setString(3, adjTranSer);
							pstmt1.setString(4, invoiceID);
							pstmt1.setString(5, ""+cnt);
							pstmt1.executeUpdate();
							if(pstmt!=null)
							{
								pstmt.close();pstmt = null;
							}
						}
						
					}
					else if("DRNRCP".equals(tranSer) || "MDRCRD".equals(tranSer))
					{
						if(invTot != (invAdj - diffAmount))
						{
							status = "U";
						}
						else
						{
							status = "A";
						}
						
						sql = " update receivables set adj_amt = adj_amt - ?, status = ?  where tran_ser = ? and tran_id = ? and line_no__ref = ? ";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setDouble(1, crAmount);
						pstmt1.setString(2, status);
						pstmt1.setString(3, adjTranSer);
						pstmt1.setString(4, invoiceID);
						pstmt1.setString(5, ""+cnt);
						pstmt1.executeUpdate();
						if(pstmt!=null)
						{
							pstmt.close();pstmt = null;
						}
					}
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_invoice_drcr_adj ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();pstmt1= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	public String gbf_retrieve_ribca(String ibcaID , String siteCode , String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<String> tranIDList = new ArrayList<String>();
		int cntHdr = 0;
		String tranIDRcpIBCA = "",winName = "",ledgPostConf = "";
		Timestamp tranDate = null,today = null;
		Map hdrMap = null;
		Map detMap = null;
		List detailList = new ArrayList();
		try
		{
			System.out.println("Inside gbf_retrieve_ribca...ibcaID["+ibcaID+"] siteCode["+siteCode+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;
		
			sql = " select tran_id from rcp_ibca where tran_id >= ? and tran_id <= ? and site_code__from = ? "
				 +" and upper(confirmed) <> 'Y' " ;
	        pstmt = conn.prepareStatement(sql);
	        pstmt.setString(1, ibcaID);
			pstmt.setString(2, ibcaID);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				cntHdr++;
				tranIDList.add(rs.getString("tran_id"));
			}
			if(rs!=null)
			{
				rs.close();rs= null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt= null;
			}
			
			for(int i = 0; i<tranIDList.size(); i++)
			{
				tranIDRcpIBCA = tranIDList.get(i);
				
				System.out.println("tranIDRcpIBCA--->["+tranIDRcpIBCA+"]");
				
				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " select tran_id from rcp_ibca where tran_id = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " select tran_id from rcp_ibca (updlock) where tran_id = ? ";
				}
				else
				{
					sql = " select tran_id from rcp_ibca where tran_id = ? for update nowait ";
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDRcpIBCA);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranIDRcpIBCA = rs.getString("tran_id") == null ? " ":rs.getString("tran_id");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}

				sql =  " select tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to, "
					  +" amount,curr_code,confirmed,exch_rate,conf_date,emp_code__aprv,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito, "
					  +" chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks, "
					  +" parent__tran_id,rev__tran,sundry_type,sundry_code "
					  +" from rcp_ibca WHERE tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDRcpIBCA);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					hdrMap = new HashMap(); 
					
					hdrMap.put("tran_id", rs.getString("tran_id"));
					hdrMap.put("tran_date", rs.getTimestamp("tran_date"));
					hdrMap.put("eff_date", rs.getTimestamp("eff_date"));
					hdrMap.put("site_code__from", rs.getString("site_code__from"));
					hdrMap.put("fin_entity__from", rs.getString("fin_entity__from"));
					hdrMap.put("site_code__to", rs.getString("site_code__to"));
					hdrMap.put("fin_entity__to", rs.getString("fin_entity__to"));
					hdrMap.put("amount", rs.getDouble("amount"));
					hdrMap.put("curr_code", rs.getString("curr_code"));
					hdrMap.put("confirmed", rs.getString("confirmed"));
					hdrMap.put("exch_rate", rs.getString("exch_rate"));
					hdrMap.put("conf_date", rs.getTimestamp("conf_date"));
					hdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
					hdrMap.put("acct_code__ifr", rs.getString("acct_code__ifr"));
					hdrMap.put("cctr_code__ifr", rs.getString("cctr_code__ifr"));
					hdrMap.put("acct_code__ito", rs.getString("acct_code__ito"));
					hdrMap.put("cctr_code__ito", rs.getString("cctr_code__ito"));
					hdrMap.put("amount__bc", rs.getDouble("amount__bc"));
					hdrMap.put("tran_type", rs.getString("tran_type"));
					hdrMap.put("tran_ser", rs.getString("tran_ser"));
					hdrMap.put("tran_id__iss", rs.getString("tran_id__iss"));
					hdrMap.put("link_type", rs.getString("link_type"));
					hdrMap.put("remarks", rs.getString("remarks"));
					hdrMap.put("parent__tran_id", rs.getString("parent__tran_id"));
					hdrMap.put("rev__tran", rs.getString("rev__tran"));
					hdrMap.put("sundry_type", rs.getString("sundry_type"));
					hdrMap.put("sundry_code", rs.getString("sundry_code"));
					
					System.out.println("IBCA header tranSer----["+rs.getString("tran_ser")+"]");
				}
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				
				sql =  " select tran_id,ref_ser,ref_no,ref_date,curr_code,exch_rate,cust_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt,"
					 + " auto_rcp,bank_code,recd,ref_type,cr_term,sales_pers,item_ser,sales_pers__1,sales_pers__2,ref_ser__org,line_no__ref,gp_no,"
					 + " gp_date,cust_ref_no,cust_ref_date,cust_ref_amt,discount_dt "
					 + " from rcp_ibca_det where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDRcpIBCA);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					detMap = new HashMap();
					detMap.put("tran_id", rs.getString("tran_id"));
					detMap.put("ref_ser", rs.getString("ref_ser"));
					detMap.put("ref_no", rs.getString("ref_no"));
					detMap.put("ref_date", rs.getTimestamp("ref_date"));
					detMap.put("curr_code", rs.getString("curr_code"));
					detMap.put("exch_rate", rs.getDouble("exch_rate"));
					detMap.put("cust_code", rs.getString("cust_code"));
					detMap.put("acct_code", rs.getString("acct_code"));
					detMap.put("cctr_code", rs.getString("cctr_code"));
					detMap.put("due_date", rs.getTimestamp("due_date"));
					detMap.put("tot_amt", rs.getDouble("tot_amt"));
					detMap.put("discount", rs.getDouble("discount"));
					detMap.put("tax_amt", rs.getDouble("tax_amt"));
					detMap.put("auto_rcp", rs.getString("auto_rcp"));
					detMap.put("bank_code", rs.getString("bank_code"));
					detMap.put("recd", rs.getString("recd"));
					detMap.put("cr_term", rs.getString("cr_term"));
					detMap.put("sales_pers", rs.getString("sales_pers"));
					detMap.put("item_ser", rs.getString("item_ser"));
					detMap.put("sales_pers__1", rs.getString("sales_pers__1"));
					detMap.put("sales_pers__2", rs.getString("sales_pers__2"));
					detMap.put("ref_ser__org", rs.getString("ref_ser__org"));
					detMap.put("line_no__ref", rs.getString("line_no__ref"));
					detMap.put("gp_no", rs.getString("gp_no"));
					detMap.put("gp_date", rs.getTimestamp("gp_date"));
					detMap.put("cust_ref_no", rs.getString("cust_ref_no"));
					detMap.put("cust_ref_date", rs.getString("cust_ref_date"));
					detMap.put("cust_ref_amt", rs.getString("cust_ref_amt"));
					detMap.put("discount_dt", rs.getString("discount_dt"));
					
					detailList.add(detMap);
				}
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				
				//Need to verify the below code
				//if lds_hdr.retrieve(ls_tran_id[ll_cntr_hdr]) > 0 then
				if(hdrMap.size() > 0)//Need to change as per above code 
				{
					//lds_det.retrieve(ls_tran_id[ll_cntr_hdr])Need to change the code
					if("I".equals(gs_run_mode))
					{
						tranDate = (Timestamp) hdrMap.get("tran_date");
						winName = "W_RCP_IBCA";
						
						sql = " select ledg_post_conf from transetup where upper(tran_window) = ? ";
				        pstmt = conn.prepareStatement(sql);
				        pstmt.setString(1, winName);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ledgPostConf = rs.getString("ledg_post_conf");
						}
						if(rs!=null)
						{
							rs.close();rs= null;
						}
						if(pstmt!=null)
						{
							pstmt.close();pstmt= null;
						}
						
						if("Y".equals(ledgPostConf))
						{
							if(tranDate != today)
							{	
								tranDate = today;
								
								sql = " update rcp_ibca set tran_date = ? where tran_id   = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setTimestamp(1, tranDate);
								pstmt.setString(2, tranIDRcpIBCA);
								pstmt.executeUpdate();
								if(pstmt!=null)
								{
									pstmt.close();pstmt = null;
								}
							}
							hdrMap.put("tran_date",tranDate);
						}
					}
					//retString = gbf_post_ribca(ls_exp_hdr,ls_exp_det,ai_commit);
					retString = gbf_post_ribca(hdrMap,detailList,xtraParams,conn);
					System.out.println("After gbf_post_ribca---->["+retString+"]");
					if(retString != null && retString.trim().length() > 0)
					{
						return retString;
					}
				}
				else
				{
					System.out.println("Unable to retreive header data");
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_retrieve_ribca ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	public String gbf_post_ribca(Map hdrMap ,List detailList, String xtraParams , Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<String> tranIDList = new ArrayList<String>();
		int cntHdr = 0,ediOption = 0;
		String tranIDRcpIBCA = "",winName = "",ledgPostConf = "";
		Timestamp tranDate = null,today = null;
		String tranId = "",tranSer = "",loginEmpCode = "",dataStr = "",confirmed = "",postOnline = "";
		Map expHdr = null;
		List expDetList = null;
		//FinCommon finCommon = new FinCommon();
		try
		{
			System.out.println("Inside gbf_post_ribca...");
			
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

			sql = " select edi_option from transetup where tran_window = 'w_rcp_ibca' ";
	        pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ediOption = rs.getInt("edi_option");
			}
			if(rs!=null)
			{
				rs.close();rs= null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt= null;
			}
			
			if(hdrMap.size() > 0)
			{
				if(detailList.size() > 0)
				{
					tranId = (String)hdrMap.get("tran_id");
					tranSer = checkNullAndTrim((String) hdrMap.get("tran_ser"));
					expHdr = hdrMap;
					expDetList = detailList;
					
					System.out.println("tranSer ["+tranSer.toUpperCase()+"]");
					
					//switch ( tranSer.toUpperCase() )
					{
						//case "I":
						if("I".equals(tranSer))
						{ 
							retString = gbf_post_ribca_hdr_iss(expHdr, xtraParams ,conn);
							if(retString.trim().length() == 0)
							{
								//migration remaining
								retString = gbf_post_ribca_det_iss(expHdr,expDetList,xtraParams, conn);
								if(retString.trim().length() == 0)
								{
									if("E".equals(hdrMap.get("link_type")) || "2".equals(ediOption))
									{
										if(ediOption > 0)
										{
											hdrMap.put("confirmed", "Y");
											hdrMap.put("conf_date", today);
											hdrMap.put("emp_code__aprv", loginEmpCode);
										}
										if(ediOption == 2)
										{
											CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
							                dataStr = createRCPXML.getTranXML(tranId, conn);
							                System.out.println("dataStr =[ " + dataStr + "]");
							                Document ediDataDom = genericUtility.parseString(dataStr);

							                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
							                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "2", xtraParams, conn);
							                createRCPXML = null;
							                e12CreateBatchLoad = null;
							                
							                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
							                
							                if (retString != null && retString.indexOf("SUCCESS") != -1) 
											{
							                	retString = "";
											}
										}
										else
										{
											CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
							                dataStr = createRCPXML.getTranXML(tranId, conn);
							                System.out.println("dataStr =[ " + dataStr + "]");
							                Document ediDataDom = genericUtility.parseString(dataStr);

							                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
							                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "0", xtraParams, conn);
							                createRCPXML = null;
							                e12CreateBatchLoad = null;
							                
							                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
							                
							                if (retString != null && retString.indexOf("SUCCESS") != -1) 
											{
							                	retString = "";
											}
										}
									}
								}
							}
						}
						//break;
						
						//case "R":
						else if("R".equals(tranSer))
						{ 
							retString = gbf_post_ribca_hdr_rcp(expHdr, conn);
									
							if(retString.trim().length() == 0)
							{
								if("E".equals(hdrMap.get("link_type")) || ediOption > 0)
								{
									if(ediOption > 0)
									{
										hdrMap.put("confirmed", "Y");
										hdrMap.put("conf_date", today);
										hdrMap.put("emp_code__aprv", loginEmpCode);
									}
									if(ediOption == 2)
									{
										CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
						                dataStr = createRCPXML.getTranXML(tranId, conn);
						                System.out.println("dataStr =[ " + dataStr + "]");
						                Document ediDataDom = genericUtility.parseString(dataStr);

						                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "2", xtraParams, conn);
						                createRCPXML = null;
						                e12CreateBatchLoad = null;
						                
						                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
						                
						                if (retString != null && retString.indexOf("SUCCESS") != -1) 
										{
						                	retString = "";
										}
									}
									else
									{
										CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
						                dataStr = createRCPXML.getTranXML(tranId, conn);
						                System.out.println("dataStr =[ " + dataStr + "]");
						                Document ediDataDom = genericUtility.parseString(dataStr);

						                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "2", xtraParams, conn);
						                createRCPXML = null;
						                e12CreateBatchLoad = null;
						                
						                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
						                
						                if (retString != null && retString.indexOf("SUCCESS") != -1) 
										{
						                	retString = "";
										}
									}
								}
							}
						}
						//break;
					}
					
					if (retString != null && retString.trim().length() > 0)
					{
						return retString;
					}
					
					postOnline = checkNullAndTrim(finCommon.getFinparams("999999", "POST_ON_LINE", conn));
					if("Y".equals(postOnline))
					{
						retString = finCommon.checkGlTranDrCr("R-IBCA", tranId, conn);
					}
					
					if(retString.trim().length() == 0)
					{
						confirmed = (String) hdrMap.get("confirmed");
						
						sql = " update rcp_ibca set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, tranDate);
						pstmt.setString(2, loginEmpCode);
						pstmt.setString(3, tranId);
						pstmt.executeUpdate();
						if(pstmt!=null)
						{
							pstmt.close();pstmt= null;
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	public String gbf_post_ribca_hdr_iss(Map hdrMap, String xtraParams , Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String linkType = "";
		Map glTraceMap = null;
		//FinCommon finCommon = new FinCommon();
		String tranId = "";
		try
		{
			linkType = (String) hdrMap.get("link_type");
			
			System.out.println("Inside gbf_post_ribca_hdr_iss-----LinkType["+linkType+"]");
			
			if(!"R".equals(linkType) && "C".equals(linkType))
			{
				glTraceMap = new HashMap();
				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_ser", "R-IBCA");
				glTraceMap.put("ref_id", hdrMap.get("tran_id"));
				glTraceMap.put("tran_date", hdrMap.get("tran_date"));
				glTraceMap.put("fin_entity", hdrMap.get("fin_entity__from"));
				glTraceMap.put("site_code", hdrMap.get("site_code__from"));
				glTraceMap.put("sundry_type","O");
				glTraceMap.put("sundry_code"," ");
				glTraceMap.put("acct_code", hdrMap.get("acct_code__ifr"));
				glTraceMap.put("cctr_code", hdrMap.get("cctr_code__ifr"));
				glTraceMap.put("curr_code", hdrMap.get("curr_code"));
				glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
				
				if((Double)hdrMap.get("amount") > 0)
				{
					glTraceMap.put("dr_amt", hdrMap.get("amount"));
					glTraceMap.put("cr_amt", "0");
				}
				else
				{
					glTraceMap.put("cr_amt", Double.valueOf((0-(Double.valueOf((String)hdrMap.get("amount"))))));
					glTraceMap.put("dr_amt", "0");
				}
				
				glTraceMap.put("remarks", hdrMap.get("remarks"));
				
				retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
				System.out.println("After glTraceUpdate gbf_post_ribca_hdr_iss---->["+retString+"]");
				
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}
			}
			
			//switch(linkType)
			{
				//case "A":
				if("A".equals(linkType))
				{
					retString = gbf_post_ribca_hdr_rcp(hdrMap,conn);
				}
				//break;
				
				//case "P":
				else if("P".equals(linkType))
				{
					tranId = (String)glTraceMap.get("ref_id");
					retString = gbf_create_ribca(tranId, tranId, xtraParams , conn);
				}
				//break;
				
				//case "R":
				else if("R".equals(linkType))
				{
					retString = gbf_post_ribca_hdr_rcp(hdrMap,conn);
				}
				//break;
				
				//case "C":
				else if("C".equals(linkType))
				{
					retString = gbf_post_ribca_hdr_rcp(hdrMap,conn);
				}
				//break;
			}
		
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_hdr_iss ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	public String gbf_post_ribca_det_iss(Map hdrMap, List expDetList, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map glTraceMap = null;
		//FinCommon finCommon = new FinCommon();
		String linkType = "",tranId = "",tranType = "",siteCodeFrom = "",refNo = "",refSer = "",lineNoref = "",siteCode = "",remarks = "",status = "";
		String finEntity = ""; 
		Timestamp tranDate = null,effDate = null,today = null;
		double amount = 0,totAmount = 0, adjAmount = 0;
		Map sundryMap = null;
		try
		{
			System.out.println("Inside gbf_post_ribca_det_iss-----expDetList Size["+expDetList.size()+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ; 
			
			linkType = (String)hdrMap.get("link_type");
			tranId = (String) hdrMap.get("tran_id");
			tranType = (String) hdrMap.get("tran_type");
			tranDate = (Timestamp) hdrMap.get("tran_date");
			effDate =  (Timestamp) hdrMap.get("eff_date");
			finEntity = (String) hdrMap.get("fin_entity__from");
			siteCode = (String)hdrMap.get("site_code__from");
			
			for(int i =0; i< expDetList.size(); i++)
			{
				HashMap detMap = (HashMap) expDetList.get(i);
				
				amount = (Double)detMap.get("tot_amt");
				refNo = (String)detMap.get("ref_no");
				refSer = (String)detMap.get("ref_ser");
				lineNoref = (String)detMap.get("line_no__ref");
				
				if(!"R".equals(linkType) && !"C".equals(linkType))
				{
					glTraceMap = new HashMap();
					glTraceMap.put("ref_id", tranId);
					glTraceMap.put("ref_type", "F");
					glTraceMap.put("ref_ser", "R-IBCA");
					glTraceMap.put("tran_date", tranDate);
					glTraceMap.put("eff_date", effDate);
					glTraceMap.put("fin_entity", finEntity);
					glTraceMap.put("site_code", siteCode);
					glTraceMap.put("sundry_type","C");
					glTraceMap.put("sundry_code",detMap.get("cust_code"));
					glTraceMap.put("acct_code", detMap.get("acct_code"));
					glTraceMap.put("cctr_code", detMap.get("cctr_code"));
					glTraceMap.put("emp_code", "");
					glTraceMap.put("anal_code", "");
					glTraceMap.put("curr_code", detMap.get("curr_code"));
					glTraceMap.put("exch_rate", (Double) detMap.get("exch_rate"));
					
					if(amount > 0)
					{
						glTraceMap.put("dr_amt", 0.0);
						glTraceMap.put("cr_amt", amount);
					}
					else
					{
						glTraceMap.put("dr_amt", 0- amount);
						glTraceMap.put("cr_amt", 0.0);
					}
					
					remarks = ((String)hdrMap.get("remarks")).trim();
					if(remarks.length() > 40)
					{
						remarks = remarks.substring(0,40);
					}
					
					remarks	   = remarks+' '+refSer.trim()+':'+refNo.trim();
					glTraceMap.put("remarks", detMap.get("remarks"));
					glTraceMap.put("party_doc_ref", finCommon.gfGetPartyDocRef(refSer, tranId, conn));
					
					sundryMap = new HashMap();
					sundryMap.put("tran_date", tranDate);
					sundryMap.put("eff_date", effDate);
					sundryMap.put("site_code", siteCode);
					sundryMap.put("sundry_type", "C");
					sundryMap.put("sundry_code", glTraceMap.get("sundry_code"));
					sundryMap.put("acct_code", glTraceMap.get("acct_code"));
					sundryMap.put("cctr_code", glTraceMap.get("cctr_code"));
					sundryMap.put("curr_code", glTraceMap.get("curr_code"));
					sundryMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
					sundryMap.put("dr_amt", (Double) glTraceMap.get("dr_amt"));
					sundryMap.put("cr_amt", (Double) glTraceMap.get("cr_amt"));
					sundryMap.put("adv_amt", 0.0);
					
					retString = finCommon.gbf_sundrybal_upd((HashMap) sundryMap, conn);
					if(retString != null && retString.trim().length() > 0)
					{
						retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
					}
				}
				
				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " SELECT tot_amt, adj_amt FROM receivables WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " SELECT tot_amt, adj_amt FROM receivables (updlock) WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update ";
				}
				else
				{
					sql = " SELECT tot_amt, adj_amt FROM receivables WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update nowait ";
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				pstmt.setString(3,lineNoref);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totAmount = rs.getDouble("tot_amt");
					adjAmount = rs.getDouble("adj_amt");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				if(Math.abs(totAmount - adjAmount) < Math.abs(amount) || (totAmount - adjAmount) == 0)
				{
					retString = "VTBAL1";
				}
				
				adjAmount = adjAmount + amount;
				if(totAmount == adjAmount)
				{
					status = "A";
				}
				else
				{
					status = "P";
				}

				sql = " update receivables set adj_amt = adj_amt + ?, status = ?, stat_date = ? "
					+ " where tran_ser = ? and ref_no = ? and line_no__ref = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, amount);
				pstmt.setString(2, status);
				pstmt.setTimestamp(3, today);
				pstmt.setString(4, refSer);
				pstmt.setString(5, refNo);
				pstmt.setString(6, lineNoref);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			
			//switch(linkType)
			{
				//case "A" :
				if("A".equals(linkType))
				{	
					//retString = gbf_post_ribca_det_rcp(as_hdrdata, as_detdata)
					retString = gbf_post_ribca_det_rcp(hdrMap, expDetList, xtraParams, conn);
				}
				//break;
				//case "R" :
				else if("R".equals(linkType))
				{	
					retString = gbf_post_ribca_det_rcp(hdrMap, expDetList, xtraParams, conn);
				}	
				//break;
				//case "C" :
				else if("C".equals(linkType))
				{	
					retString = gbf_post_ribca_det_rcp(hdrMap, expDetList, xtraParams, conn);
				}
				//break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_det_iss ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	
	public String gbf_create_ribca(String tranIdFr,String tranIdTo ,String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null,pstmtHdr = null,pstmtDet = null;
		ResultSet rs = null;
		Map detMap = null;
		//FinCommon finCommon = new FinCommon();
		String linkType = "",tranType = "",siteCodeFrom = "",refNo = "",refSer = "",lineNoref = "",chgUser = "",chgTerm = "",
			   siteCode = "",remarks = "",status = "",keyStr = "",tranID = "",tranIDIbca = "",newTranId = "",siteCodeTo = "",
			   finEntFrom = "",finEntTo = "",ibcaConf = "";
		int finEntity = 0,count = 0; 
		Timestamp tranDate = null,effDate = null,today = null;
		List tranIDList = new ArrayList();
		
		try
		{
			System.out.println("Inside gbf_create_ribca-----tranIdFrom["+tranIdTo+"] tranIdTo["+tranIdTo+"] ");
			
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			
			 sql = " insert into rcp_ibca (tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to, "
				  +" amount,curr_code,confirmed,exch_rate,conf_date,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito, "
				  +" chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks, "
				  +" rev__tran,sundry_type,sundry_code ) " //31
				  +" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtHdr = conn.prepareStatement(sql);
			
			 sql = " insert into rcp_ibca_det ( tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt,"
				  +" auto_rcp,bank_code,ref_type,cr_term,sales_pers,exch_rate,ref_ser__org)" //18
				  +" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtDet = conn.prepareStatement(sql);
			
			sql = " select key_string from transetup where upper(tran_window) = 'W_RCP_IBCA' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				keyStr = rs.getString("key_string");
			}
			else
			{
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " select key_string from transetup where upper(tran_window) = 'GENERAL' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					keyStr = rs.getString("key_string");
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " select tran_id from rcp_ibca where tran_id >= ? and tran_id <= ? and upper(confirmed) <> 'Y' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdFr);
			pstmt.setString(2, tranIdTo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranIDIbca = rs.getString("tran_id");
				
				if(tranIDIbca != null)
				{	
					tranIDList.add(tranIDIbca);
				}	
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			
			for(int i=0;i < tranIDList.size() ; i++)	
			{
				sql =  " select tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to, "
					  +" amount,curr_code,confirmed,exch_rate,conf_date,emp_code__aprv,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito, "
					  +" chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks, "
					  +" parent__tran_id,rev__tran,sundry_type,sundry_code "
					  +" from rcp_ibca WHERE tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,(String)tranIDList.get(i));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					today = new java.sql.Timestamp(System.currentTimeMillis()) ;
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
					tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");
					
					sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					
					String xmlValues = "";
					xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
					xmlValues = xmlValues + "<Header></Header>";
					xmlValues = xmlValues + "<Detail1>";
					xmlValues = xmlValues +	"<tran_id/>";
					xmlValues = xmlValues + "<site_code__from>" + rs.getString("site_code__from") + "</site_code__from>";
					xmlValues = xmlValues + "<site_code__to>" + rs.getString("site_code__to") + "</site_code__to>";
					xmlValues = xmlValues + "<tran_date>"+ sdf.format(tranDate) + "</tran_date>";
					xmlValues = xmlValues + "<tran_ser>R</tran_ser>";
					xmlValues = xmlValues + "<link_type>R</link_type>";
					xmlValues = xmlValues + "</Detail1></Root>";
					
					TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
					newTranId = tg.generateTranSeqID("R-IBCA", "tran_id", keyStr, conn);
					
					tranType = rs.getString("tran_ser");
					linkType = rs.getString("link_type");
					siteCodeFrom = rs.getString("site_code__from");
					siteCodeTo 	= rs.getString("site_code__to");
					finEntFrom	= rs.getString("fin_entity__from");
					finEntTo = rs.getString("fin_entity__to");
					
					pstmtHdr.clearParameters();
					
					pstmtHdr.setString(1,newTranId);
					pstmtHdr.setTimestamp(2,tranDate);
					pstmtHdr.setTimestamp(3,rs.getTimestamp("eff_date"));
					pstmtHdr.setString(4,rs.getString("site_code__from"));
					pstmtHdr.setString(5,rs.getString("fin_entity__from"));
					pstmtHdr.setString(6,rs.getString("site_code__to"));
					pstmtHdr.setString(7,rs.getString("fin_entity__to"));
					pstmtHdr.setDouble(8,rs.getDouble("amount"));
					pstmtHdr.setString(9,rs.getString("curr_code"));
					pstmtHdr.setString(10, "N");
					pstmtHdr.setString(11,rs.getString("exch_rate"));
					pstmtHdr.setString(12,rs.getString("conf_date"));
					pstmtHdr.setString(13,rs.getString("acct_code__ifr"));
					pstmtHdr.setString(14,rs.getString("cctr_code__ifr"));
					pstmtHdr.setString(15,rs.getString("acct_code__ito"));
					pstmtHdr.setString(16,rs.getString("cctr_code__ito"));
					pstmtHdr.setTimestamp(17,today);
					pstmtHdr.setString(18,chgUser);
					pstmtHdr.setString(19,chgTerm);
					pstmtHdr.setTimestamp(20,today);
					pstmtHdr.setString(21,chgUser);
					pstmtHdr.setString(22,chgTerm);
					pstmtHdr.setDouble(23,rs.getDouble("amount__bc"));
					pstmtHdr.setString(24,rs.getString("tran_type"));
					pstmtHdr.setString(25,"R");
					pstmtHdr.setString(26,(String) tranIDList.get(i));
					pstmtHdr.setString(27,rs.getString("link_type"));
					pstmtHdr.setString(28,rs.getString("remarks"));
					pstmtHdr.setString(30,rs.getString("sundry_type"));
					pstmtHdr.setString(31,rs.getString("sundry_code"));
					count = pstmtHdr.executeUpdate();
					
					if(pstmtHdr!=null)
					{
						pstmtHdr.close();pstmtHdr=null;
					}
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " select tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt,"
					 +" auto_rcp,bank_code,ref_type,cr_term,sales_pers,item_ser,sales_pers__1,sales_pers__2,ref_ser__org,line_no__ref,gp_no,"
					 +" gp_date,cust_ref_no,cust_ref_date,cust_ref_amt,discount_dt  " 
					 +" from rcp_ibca where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,(String) tranIDList.get(i));
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					pstmtDet.clearParameters();
					pstmtDet.setString(1,newTranId);
					pstmtDet.setString(2,rs.getString("ref_ser"));
					pstmtDet.setString(3,rs.getString("ref_no"));
					pstmtDet.setTimestamp(4,rs.getTimestamp("ref_date"));
					pstmtDet.setString(5,rs.getString("curr_code"));
					pstmtDet.setString(6,rs.getString("acct_code"));
					pstmtDet.setString(7,rs.getString("cctr_code"));
					pstmtDet.setTimestamp(8,rs.getTimestamp("due_date"));
					pstmtDet.setDouble(9,rs.getDouble("tot_amt"));
					pstmtDet.setDouble(10,rs.getDouble("discount"));
					pstmtDet.setDouble(11,rs.getDouble("tax_amt"));
					pstmtDet.setString(12,rs.getString("auto_rcp"));
					pstmtDet.setString(13,rs.getString("bank_code"));
					pstmtDet.setString(14,rs.getString("ref_type"));
					pstmtDet.setString(15,rs.getString("cr_term"));
					pstmtDet.setString(16,rs.getString("sales_pers"));
					pstmtDet.setDouble(17,rs.getDouble("exch_rate"));
					pstmtDet.setString(18,rs.getString("ref_ser__org"));
					pstmtDet.addBatch();
					pstmtDet.clearParameters();
				}
				pstmtDet.executeBatch();
				if(rs!=null)
				{
					rs.close();rs=null;
				}
				if(pstmtDet!=null)
				{
					pstmtDet.close();pstmtDet=null;
				}
				
				sql = " select 	case when auto_confirm is null then 'N' else auto_confirm end "
						+ " from ibca_rcp_ctrl "
						+ " where  site_code__from   = ? "
						+ " and    site_code__to     = ? "
						+ " and    fin_entity__from  = ? "
						+ "	and    fin_entity__to    = ? "
						+ " and    link_type         = 'P' " ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCodeFrom);
					pstmt.setString(2,siteCodeTo);
					pstmt.setString(3,finEntFrom);
					pstmt.setString(4,finEntTo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						ibcaConf = rs.getString(1);
					}
					else
					{
						ibcaConf = "N";
					}
					if(rs!=null)
					{
						rs.close();rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();pstmt=null;
					}
					if ("Y".equals(ibcaConf))
					{
						retString = gbf_retrieve_ribca(newTranId , siteCode , xtraParams, conn);
						
						if(retString != null && retString.trim().length() > 0)
						{
							return retString;
						}
					}
			}
			if(pstmtDet!=null)
			{
				pstmtDet.close();pstmtDet=null;
			}
			if(pstmtHdr!=null)
			{
				pstmtHdr.close();pstmtHdr=null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_create_ribca ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				if(pstmtDet!=null)
				{
					pstmtDet.close();pstmtDet=null;
				}
				if(pstmtHdr!=null)
				{
					pstmtHdr.close();pstmtHdr=null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	public String gbf_post_ribca_hdr_rcp(Map hdrMap, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map glTraceMap = null;
		//FinCommon finCommon = new FinCommon();
		
		try
		{
			System.out.println("Inside gbf_post_ribca_hdr_rcp...");
			
			glTraceMap = new HashMap();
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser", "R-IBCA");
			glTraceMap.put("ref_id", hdrMap.get("tran_id"));
			glTraceMap.put("tran_date", hdrMap.get("tran_date"));
			glTraceMap.put("eff_date", hdrMap.get("eff_date"));
			glTraceMap.put("fin_entity", hdrMap.get("fin_entity__to"));
			glTraceMap.put("site_code", hdrMap.get("site_code__to"));
			glTraceMap.put("sundry_type","O");
			glTraceMap.put("sundry_code"," ");
			glTraceMap.put("acct_code", hdrMap.get("acct_code__ito"));
			glTraceMap.put("cctr_code", hdrMap.get("cctr_code__ito"));
			glTraceMap.put("anal_code", "");
			glTraceMap.put("emp_code", "");
			glTraceMap.put("curr_code", hdrMap.get("curr_code"));
			glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
			
			if((Double)hdrMap.get("amount") > 0)
			{
				glTraceMap.put("dr_amt", "0");
				glTraceMap.put("cr_amt", hdrMap.get("amount"));
			}
			else
			{
				glTraceMap.put("dr_amt", Double.valueOf((0-(Double.valueOf((String)hdrMap.get("amount"))))));
				glTraceMap.put("cr_amt", "0");
			}
			
			glTraceMap.put("remarks", hdrMap.get("remarks"));
			
			retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
			System.out.println("After glTraceUpdate gbf_post_ribca_hdr_rcp---->["+retString+"]");
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_hdr_rcp ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}	
	
	public String gbf_post_ribca_det_rcp(Map hdrMap, List expDetList, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map glTraceMap = null;
		//FinCommon finCommon = new FinCommon();
		String finEntityTo = "";
		String tranId = "",tranType = "",siteCodeTo = "",remarks = "",refSer = "",refNo = "";
		Timestamp tranDate = null,effDate = null;
		int count = 0;
		Map detMap = null,sundryBalMap = null,recvbleMap = null;
		double amount = 0;
		
		try
		{
			System.out.println("Inside gbf_post_ribca_det_rcp...");
			
			tranId = (String)hdrMap.get("tranId");
			tranType = (String)hdrMap.get("tran_type");
			tranDate = (Timestamp)hdrMap.get("tran_date");
			effDate = (Timestamp)hdrMap.get("eff_date");
			finEntityTo = (String)hdrMap.get("fin_entity__to");
			siteCodeTo = (String)hdrMap.get("site_code__to");
			
			for(int i=0; i < expDetList.size(); i++)
			{
				detMap = (HashMap) expDetList.get(i);
				
				glTraceMap = new HashMap();
				glTraceMap.put("ref_id",tranId);
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser", "R-IBCA");
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				glTraceMap.put("fin_entity", finEntityTo);
				glTraceMap.put("site_code", siteCodeTo);
				glTraceMap.put("sundry_type", "C");
				glTraceMap.put("sundry_code", (String)detMap.get("cust_code"));
				glTraceMap.put("acct_code", (String)detMap.get("acct_code"));
				glTraceMap.put("cctr_code", (String)detMap.get("cctr_code"));
				glTraceMap.put("emp_code", "");
				glTraceMap.put("anal_code", "");
				glTraceMap.put("curr_code", (String)detMap.get("curr_code"));
				glTraceMap.put("exch_rate", (Double) detMap.get("exch_rate"));
				
				amount = (Double)detMap.get("tot_amt");
				if(amount > 0)
				{
					glTraceMap.put("dr_amt",amount);
					glTraceMap.put("cr_amt",0.0);
				}
				else
				{
					glTraceMap.put("dr_amt",0);
					glTraceMap.put("cr_amt",0-amount);
				}
				
				refSer = (String) detMap.get("ref_no");
				refNo = (String) detMap.get("ref_ser");
				
				remarks = ((String)hdrMap.get("remarks")).trim();
				if(remarks.length() > 40)
				{
					remarks = remarks.substring(0,40);
				}
				
				remarks	   = remarks+' '+refSer.trim()+':'+refNo.trim();
				glTraceMap.put("remarks", detMap.get("remarks"));
				glTraceMap.put("party_doc_ref", finCommon.gfGetPartyDocRef(refSer, refNo, conn));
				
				sundryBalMap = new HashMap();
				sundryBalMap.put("tran_date",tranDate);
				sundryBalMap.put("eff_date",effDate);
				sundryBalMap.put("fin_entity", finEntityTo);
				sundryBalMap.put("site_code", siteCodeTo);
				sundryBalMap.put("sundry_type", "C");
				sundryBalMap.put("sundry_code",(String)glTraceMap.get("sundry_code"));
				sundryBalMap.put("acct_code", (String)glTraceMap.get("acct_code"));
				sundryBalMap.put("cctr_code", (String)glTraceMap.get("cctr_code"));
				sundryBalMap.put("curr_code", (String)glTraceMap.get("curr_code"));
				sundryBalMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
				sundryBalMap.put("dr_amt", (Double)glTraceMap.get("dr_amt"));
				sundryBalMap.put("cr_amt", (Double)glTraceMap.get("cr_amt"));
				sundryBalMap.put("adv_amt", 0.0);
				
				refNo = (String)detMap.get("ref_no");
				
				sql = " select count(*) from receivables where tran_ser like 'R-IBC%' and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				if(rs!=null)
				{
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				
				if(count == 0)
				{
					refSer = "R-IBCA";
				}
				else
				{
					refSer = "R-IBCA"+count;
				}
				
				recvbleMap = new HashMap();
				recvbleMap.put("tran_ser",refSer);
				sundryBalMap.put("tran_date",tranDate);
				recvbleMap.put("eff_date",effDate);
				recvbleMap.put("fin_entity", finEntityTo);
				recvbleMap.put("site_code", siteCodeTo);
				recvbleMap.put("ref_no", detMap.get("ref_no"));
				recvbleMap.put("ref_date", detMap.get("ref_date"));
				recvbleMap.put("due_date", glTraceMap.get("due_date"));
				recvbleMap.put("curr_code", (String)glTraceMap.get("curr_code"));
				recvbleMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
				recvbleMap.put("cust_code", (String)detMap.get("cust_code"));
				recvbleMap.put("acct_code", (String)glTraceMap.get("acct_code"));
				recvbleMap.put("cctr_code", (String)glTraceMap.get("cctr_code"));
				recvbleMap.put("cctr_code", (Double)detMap.get("tax_amt"));
				recvbleMap.put("discount", (Double)detMap.get("discount"));
				recvbleMap.put("tot_amt", (Double)detMap.get("tot_amt"));
				recvbleMap.put("auto_rcp", (String)detMap.get("auto_rcp"));
				recvbleMap.put("bank_code", (String)detMap.get("bank_code"));
				recvbleMap.put("ref_type", (String)detMap.get("ref_type"));
				recvbleMap.put("cr_term", (String)detMap.get("cr_term"));
				recvbleMap.put("item_ser", (String)detMap.get("item_ser"));
				recvbleMap.put("sales_pers", (String)detMap.get("sales_pers"));
				recvbleMap.put("ref_ser__org", (String)detMap.get("ref_ser__org"));
				recvbleMap.put("gp_no", (String)detMap.get("gp_no"));
				recvbleMap.put("gp_date", (String)detMap.get("gp_date"));
				recvbleMap.put("cust_ref_no", (String)detMap.get("cust_ref_no"));
				recvbleMap.put("cust_ref_date", (String)detMap.get("cust_ref_date"));
				recvbleMap.put("cust_ref_amt", (String)detMap.get("cust_ref_amt"));
				recvbleMap.put("discount_date", (String)detMap.get("discount_dt"));
				
				retString = finCommon.gbf_sundrybal_upd((HashMap) sundryBalMap, conn);
				if(retString.trim().length() == 0)
				{
					retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
					if(retString.trim().length() == 0)
					{
						retString = finCommon.gbfReceivablesUpd((HashMap) recvbleMap, conn);
						if(retString != null && retString.trim().length() > 0)
						{
							return retString;
						}
					}
				}
			}	
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_det_rcp ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}	
	
	public int findLineNofromDetail(String acctCode,String cctrCode,ArrayList detailList)
	{
		int lineNo = 0;
		HashMap detMap = new HashMap();
		String acctCodeMap = "",cctrCodeMap = "";
		try
		{
			for(int ctr=0 ; ctr < detailList.size() ; ctr++)
			{
				detMap = (HashMap) detailList.get(ctr);
				acctCodeMap = (String) detMap.get("acct_code");
				cctrCodeMap = (String) detMap.get("cctr_code");
				if (acctCodeMap.trim().equalsIgnoreCase(acctCode.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCode.trim()))
				{
					lineNo = (Integer) detMap.get("line_no");
					break;
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception inside findLineNofromDetail==>"+e.getMessage());
		}
		return lineNo;
	}
	
	public  String getError(String message,String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	//Changed by wasim on 24-MAY-2017 for migration to retrieve DRCRrcp [END]
}
