package ibase.dashboard.crm.servlet;

import ibase.dashboard.crm.ejb.OpportunityStageSummaryRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class OrganizationStageValueServlet extends HttpServlet{

	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {

		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {

		String dataSourceName = "";
		String loginCode = "";
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		OpportunityStageSummaryRemote opportunityStageSummaryRemote = null;  
		
		try {
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName");

			HttpSession session = request.getSession(true);
			UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
			loginCode = userInfo.getEmpCode();

			System.out.println("Login Code ::::[ " + loginCode + " ]");

			context = new InitialContext(appConnectParm.getProperty());
			opportunityStageSummaryRemote = (OpportunityStageSummaryRemote) context.lookup("ibase/OpportunityStageSummary/remote");
			JSONObject jsonObjData = (JSONObject) opportunityStageSummaryRemote.getOrganizationStageValue(dataSourceName, loginCode);
			ServletOutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for OrganizationStageValueServlet === " + jsonObjData);

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception : OrganizationStageValueServlet :::: " + e);
			try {
				throw new ITMException(e);
			} catch (ITMException e1) {
				e1.printStackTrace();
			}
		}
	}

}
