/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Match
implements Function {
    public ValueEval evaluate(ValueEval[] args, int srcCellRow, short srcCellCol) {
        double match_type = 1.0;
        switch (args.length) {
            case 3: {
                try {
                    match_type = Match.evaluateMatchTypeArg(args[2], srcCellRow, srcCellCol);
                    break;
                }
                catch (EvaluationException e) {
                    return ErrorEval.REF_INVALID;
                }
            }
            case 2: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        boolean matchExact = match_type == 0.0;
        boolean findLargestLessThanOrEqual = match_type > 0.0;
        try {
            ValueEval lookupValue = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            LookupUtils.ValueVector lookupRange = Match.evaluateLookupRange(args[1]);
            int index = Match.findIndexOfValue(lookupValue, lookupRange, matchExact, findLargestLessThanOrEqual);
            return new NumberEval(index + 1);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static LookupUtils.ValueVector evaluateLookupRange(ValueEval eval) throws EvaluationException {
        if (eval instanceof RefEval) {
            RefEval re = (RefEval)eval;
            return new SingleValueVector(re.getInnerValueEval());
        }
        if (eval instanceof AreaEval) {
            LookupUtils.ValueVector result = LookupUtils.createVector((AreaEval)eval);
            if (result == null) {
                throw new EvaluationException(ErrorEval.NA);
            }
            return result;
        }
        if (eval instanceof NumericValueEval) {
            throw new EvaluationException(ErrorEval.NA);
        }
        if (eval instanceof StringEval) {
            StringEval se = (StringEval)eval;
            Double d = OperandResolver.parseDouble(se.getStringValue());
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        throw new RuntimeException("Unexpected eval type (" + eval.getClass().getName() + ")");
    }

    private static double evaluateMatchTypeArg(ValueEval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval match_type = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        if (match_type instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)match_type);
        }
        if (match_type instanceof NumericValueEval) {
            NumericValueEval ne = (NumericValueEval)match_type;
            return ne.getNumberValue();
        }
        if (match_type instanceof StringEval) {
            StringEval se = (StringEval)match_type;
            Double d = OperandResolver.parseDouble(se.getStringValue());
            if (d == null) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return d;
        }
        throw new RuntimeException("Unexpected match_type type (" + match_type.getClass().getName() + ")");
    }

    private static int findIndexOfValue(ValueEval lookupValue, LookupUtils.ValueVector lookupRange, boolean matchExact, boolean findLargestLessThanOrEqual) throws EvaluationException {
        LookupUtils.LookupValueComparer lookupComparer = Match.createLookupComparer(lookupValue, matchExact);
        int size = lookupRange.getSize();
        if (matchExact) {
            for (int i = 0; i < size; ++i) {
                if (!lookupComparer.compareTo(lookupRange.getItem(i)).isEqual()) continue;
                return i;
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        if (findLargestLessThanOrEqual) {
            for (int i = size - 1; i >= 0; --i) {
                LookupUtils.CompareResult cmp = lookupComparer.compareTo(lookupRange.getItem(i));
                if (cmp.isTypeMismatch() || cmp.isLessThan()) continue;
                return i;
            }
            throw new EvaluationException(ErrorEval.NA);
        }
        for (int i = 0; i < size; ++i) {
            LookupUtils.CompareResult cmp = lookupComparer.compareTo(lookupRange.getItem(i));
            if (cmp.isEqual()) {
                return i;
            }
            if (!cmp.isGreaterThan()) continue;
            if (i < 1) {
                throw new EvaluationException(ErrorEval.NA);
            }
            return i - 1;
        }
        throw new EvaluationException(ErrorEval.NA);
    }

    private static LookupUtils.LookupValueComparer createLookupComparer(ValueEval lookupValue, boolean matchExact) {
        String stringValue;
        if (matchExact && lookupValue instanceof StringEval && Match.isLookupValueWild(stringValue = ((StringEval)lookupValue).getStringValue())) {
            throw new RuntimeException("Wildcard lookup values '" + stringValue + "' not supported yet");
        }
        return LookupUtils.createLookupComparer(lookupValue);
    }

    private static boolean isLookupValueWild(String stringValue) {
        return stringValue.indexOf(63) >= 0 || stringValue.indexOf(42) >= 0;
    }

    private static final class SingleValueVector
    implements LookupUtils.ValueVector {
        private final ValueEval _value;

        public SingleValueVector(ValueEval value) {
            this._value = value;
        }

        public ValueEval getItem(int index) {
            if (index != 0) {
                throw new RuntimeException("Invalid index (" + index + ") only zero is allowed");
            }
            return this._value;
        }

        public int getSize() {
            return 1;
        }
    }
}

